/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.datamodel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.el.Expression;
import javax.faces.context.FacesContext;
import org.ajax4jsf.model.DataVisitor;
import org.ajax4jsf.model.Range;
import org.ajax4jsf.model.SequenceRange;
import org.openspcoop2.generic_project.expression.SortOrder;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.web.monitor.core.bean.AbstractCoreSearchForm;
import org.openspcoop2.web.monitor.core.dao.ISearchFormService;
import org.openspcoop2.web.monitor.core.datamodel.BaseDataModelWithSearchForm;
import org.richfaces.model.FilterField;
import org.richfaces.model.Modifiable;
import org.richfaces.model.Ordering;
import org.richfaces.model.SortField2;
import org.slf4j.Logger;

public abstract class SortableBaseDataModel<K, T, D, S extends AbstractCoreSearchForm>
extends BaseDataModelWithSearchForm<K, T, D, S>
implements Modifiable {
    private static final long serialVersionUID = 2954923950179861809L;
    private static Logger log = LoggerWrapperFactory.getLogger(SortableBaseDataModel.class);

    public void modify(List<FilterField> filterFields, List<SortField2> sortFields) {
        log.trace("modify numero entries richieste: [" + this.rowsToDisplay + "] ID[" + ((Object)((Object)this)).toString() + "]");
        if (sortFields != null && !sortFields.isEmpty()) {
            SortField2 sortField2 = sortFields.get(0);
            Expression expression = sortField2.getExpression();
            String expressionStr = expression.getExpressionString();
            if (!expression.isLiteralText()) {
                expressionStr = expressionStr.replaceAll("[#|$]{1}\\{.*?\\.", "").replaceAll("\\}", "");
            }
            this.setSortField(expressionStr);
            log.debug("Nuovo Sort Field [" + this.getSortField() + "]");
            Ordering ordering = sortField2.getOrdering();
            this.aggiornaSortOrder(expressionStr, ordering);
            if (ordering == Ordering.DESCENDING) {
                this.setSortOrder(SortOrder.DESC);
            } else {
                this.setSortOrder(SortOrder.ASC);
            }
        }
    }

    private void aggiornaSortOrder(String field, Ordering order) {
        HashMap<String, Ordering> tmpMap = new HashMap<String, Ordering>();
        for (String f : this.getSortOrders().keySet()) {
            if (f.equals(field)) {
                tmpMap.put(f, order);
                continue;
            }
            tmpMap.put(f, Ordering.UNSORTED);
        }
        this.getSortOrders().clear();
        this.getSortOrders().putAll(tmpMap);
    }

    @Override
    public void walk(FacesContext context, DataVisitor visitor, Range range, Object argument) throws IOException {
        try {
            this.checkDataProvider();
            AbstractCoreSearchForm searchForm = null;
            if (this.dataProvider instanceof ISearchFormService) {
                searchForm = (AbstractCoreSearchForm)((ISearchFormService)this.dataProvider).getSearch();
                boolean usaBuffer = this.detached || this.wrappedKeys != null;
                log.trace("walk numero entries richieste: [" + this.rowsToDisplay + "], usaBuffer [" + usaBuffer + "] ID[" + ((Object)((Object)this)).toString() + "]");
                if (usaBuffer) {
                    for (Object key : searchForm.getWrappedKeys()) {
                        this.setRowKey(key);
                        visitor.process(context, key, argument);
                    }
                } else {
                    int start = 0;
                    int limit = 0;
                    if (searchForm.isUseCount()) {
                        if (searchForm.isRestoreSearch()) {
                            start = searchForm.getStart();
                            limit = searchForm.getLimit();
                            searchForm.setRestoreSearch(false);
                            int pageIndex = start / limit + 1;
                            searchForm.setCurrentPage(pageIndex);
                        } else {
                            start = ((SequenceRange)range).getFirstRow();
                            limit = ((SequenceRange)range).getRows();
                        }
                        searchForm.setStart(start);
                        searchForm.setLimit(limit);
                    } else {
                        start = searchForm.getStart();
                        limit = searchForm.getLimit();
                    }
                    this.wrappedKeys = new ArrayList();
                    log.trace("walk numero entries richieste: [" + this.rowsToDisplay + "], Start [" + start + "]. Limit [" + limit + "] ID[" + ((Object)((Object)this)).toString() + "]");
                    List bufferList = this.findObjects(start, limit, this.getSortField(), this.getSortOrder());
                    this.currentSearchSize = bufferList != null ? bufferList.size() : 0;
                    searchForm.setCurrentSearchSize(this.currentSearchSize);
                    if (bufferList != null) {
                        for (Object obj : bufferList) {
                            this.wrappedData.put(this.getId(obj), obj);
                            this.wrappedKeys.add(this.getId(obj));
                            visitor.process(context, this.getId(obj), argument);
                        }
                    }
                    searchForm.setWrappedKeys(this.wrappedKeys);
                }
            } else {
                boolean usaBuffer = this.detached || this.wrappedKeys != null;
                log.trace("walk numero entries richieste: [" + this.rowsToDisplay + "], usaBuffer [" + usaBuffer + "] ID[" + ((Object)((Object)this)).toString() + "]");
                if (usaBuffer) {
                    for (Object key : this.wrappedKeys) {
                        this.setRowKey(key);
                        visitor.process(context, key, argument);
                    }
                } else {
                    int start = 0;
                    int limit = 0;
                    start = ((SequenceRange)range).getFirstRow();
                    limit = ((SequenceRange)range).getRows();
                    this.wrappedKeys = new ArrayList();
                    List bufferList = this.findObjects(start, limit, this.getSortField(), this.getSortOrder());
                    this.currentSearchSize = bufferList != null ? bufferList.size() : 0;
                    if (bufferList != null) {
                        for (Object obj : bufferList) {
                            this.wrappedData.put(this.getId(obj), obj);
                            this.wrappedKeys.add(this.getId(obj));
                            visitor.process(context, this.getId(obj), argument);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("Errore durante la walk: " + e.getMessage(), (Throwable)e);
        }
    }

    public abstract String getDefaultSortField();

    public abstract SortOrder getSortOrder();

    public abstract void setSortOrder(SortOrder var1);

    public abstract String getSortField();

    public abstract void setSortField(String var1);

    public abstract Map<String, Ordering> getSortOrders();

    public abstract void setSortOrders(Map<String, Ordering> var1);
}

