/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.filters;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.web.monitor.core.core.Utils;
import org.openspcoop2.web.monitor.core.listener.IEFilter;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.utils.BrowserInfo;
import org.openspcoop2.web.monitor.core.utils.ContentAuthorizationManager;
import org.slf4j.Logger;

public class BrowserFilter
implements Filter {
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private static Map<BrowserInfo.BrowserFamily, Double> mappaAbilitazioneGraficiSVG;
    private static Map<BrowserInfo.BrowserFamily, Double> mappaAbilitazioneVistaTransazioniCustom;
    private FilterConfig filterConfig = null;
    private static final String parametroSVG = "usaSVG";
    private static final String parametroSVG_FORM_STATS = "sf_usaSVG";
    private static final String parametroSVG_FORM_MENU = "tf_usaSVG";
    private static final String parametroSVG_POLL_STATO = "ps_usaSVG";
    private static final String parametroGeneraReport = "generaReport";
    private static final String parametroEsitiLive = "esiti_live";
    private static final String parametroTipoReport = "tipoReportCombo";
    private static final String parametroTipoReportTabella = "Tabella";
    private List<String> listaPagineNoIE8 = null;

    private static synchronized void loadMappaBrowser() {
        if (mappaAbilitazioneGraficiSVG == null) {
            mappaAbilitazioneGraficiSVG = new HashMap<BrowserInfo.BrowserFamily, Double>();
        }
        mappaAbilitazioneGraficiSVG.put(BrowserInfo.BrowserFamily.CHROME, 4.0);
        mappaAbilitazioneGraficiSVG.put(BrowserInfo.BrowserFamily.FIREFOX, 3.0);
        mappaAbilitazioneGraficiSVG.put(BrowserInfo.BrowserFamily.IE, 9.0);
        mappaAbilitazioneGraficiSVG.put(BrowserInfo.BrowserFamily.OPERA, 10.1);
        mappaAbilitazioneGraficiSVG.put(BrowserInfo.BrowserFamily.SAFARI, 3.2);
        if (mappaAbilitazioneVistaTransazioniCustom == null) {
            mappaAbilitazioneVistaTransazioniCustom = new HashMap<BrowserInfo.BrowserFamily, Double>();
        }
        mappaAbilitazioneVistaTransazioniCustom.put(BrowserInfo.BrowserFamily.CHROME, 29.0);
        mappaAbilitazioneVistaTransazioniCustom.put(BrowserInfo.BrowserFamily.FIREFOX, 28.0);
        mappaAbilitazioneVistaTransazioniCustom.put(BrowserInfo.BrowserFamily.IE, 11.0);
        mappaAbilitazioneVistaTransazioniCustom.put(BrowserInfo.BrowserFamily.OPERA, 12.1);
        mappaAbilitazioneVistaTransazioniCustom.put(BrowserInfo.BrowserFamily.SAFARI, 9.0);
    }

    public static boolean disabilitaGraficiSVG(BrowserInfo browserInfo) {
        Double versione;
        boolean disabilita = false;
        if (mappaAbilitazioneGraficiSVG == null) {
            BrowserFilter.loadMappaBrowser();
        }
        if (browserInfo != null && (versione = mappaAbilitazioneGraficiSVG.get((Object)browserInfo.getBrowserFamily())) != null && browserInfo.getVersion() != null && versione >= browserInfo.getVersion()) {
            disabilita = true;
        }
        return disabilita;
    }

    public static boolean abilitaVisualizzazioneTransazioniCustom(BrowserInfo browserInfo) {
        Double versione;
        boolean abilita = false;
        if (mappaAbilitazioneVistaTransazioniCustom == null) {
            BrowserFilter.loadMappaBrowser();
        }
        if (browserInfo != null && (versione = mappaAbilitazioneVistaTransazioniCustom.get((Object)browserInfo.getBrowserFamily())) != null && browserInfo.getVersion() != null && browserInfo.getVersion() >= versione) {
            abilita = true;
        }
        return abilita;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        request.setAttribute("_abilita_polyfill_ie_", (Object)false);
        String userAgent = request.getHeader("User-Agent");
        if (userAgent != null) {
            try {
                log.debug("Decodifica Browser da Header UserAgent [" + userAgent + "]");
                String urlRichiesta = request.getServletPath();
                log.debug("Richiesta Risorsa [" + urlRichiesta + "]");
                BrowserInfo browserInfo = BrowserInfo.getBrowserInfo(userAgent);
                String browsername = browserInfo.getBrowserName();
                Double browserversion = browserInfo.getVersion();
                log.debug("Browser Riconosciuto: Name [" + browsername + "] Version [" + browserversion + "].");
                boolean usaSVG = this.usaSVG(request);
                if (browserInfo.getBrowserFamily().equals((Object)BrowserInfo.BrowserFamily.IE)) {
                    if (browserversion == null || browserversion <= 11.0) {
                        log.debug("Imposto polyfill per browser IE legacy.");
                        request.setAttribute("_abilita_polyfill_ie_", (Object)true);
                    }
                    boolean abilitaModalitaIE8 = true;
                    if (usaSVG) {
                        log.debug("Richiesto Accesso per La risorsa protetta.");
                        abilitaModalitaIE8 = BrowserFilter.disabilitaGraficiSVG(browserInfo);
                    }
                    log.debug("La risorsa richiesta " + (abilitaModalitaIE8 ? "" : "non ") + "verra' visualizzata in modalita compatibilita IE8.");
                    response.setHeader("X-UA-Compatible", "IE=edge");
                    String accept = request.getHeader("Accept");
                    if ("text/css".equals(accept)) {
                        chain.doFilter((ServletRequest)new IEFilter.IE9HttpServletRequestWrapper(new IEFilter(), request), (ServletResponse)response);
                    }
                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                } else if (browserInfo.getBrowserFamily().equals((Object)BrowserInfo.BrowserFamily.FIREFOX)) {
                    ArrayList<String> lst = new ArrayList<String>();
                    lst.add("/a4j/");
                    if (ContentAuthorizationManager.getInstance().contains(urlRichiesta, lst)) {
                        log.debug("Applico Fix per le risorse A4j in firefox.");
                        chain.doFilter((ServletRequest)new HttpServletRequestWrapper(request){

                            public String getRequestURI() {
                                try {
                                    return URLDecoder.decode(super.getRequestURI(), "UTF-8");
                                }
                                catch (UnsupportedEncodingException e) {
                                    throw new IllegalStateException("Cannot decode request URI.", e);
                                }
                            }
                        }, (ServletResponse)response);
                    } else {
                        chain.doFilter((ServletRequest)request, (ServletResponse)response);
                    }
                } else {
                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                }
            }
            catch (Exception e) {
                log.debug("Browser non riconosciuto.");
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        }
    }

    public void destroy() {
        log.debug("DISTRUIZIONE FILTRO: BrowserFilter");
        this.filterConfig = null;
    }

    public void init(FilterConfig config) throws ServletException {
        this.filterConfig = config;
        try {
            this.listaPagineNoIE8 = Arrays.asList(ContentAuthorizationManager.getInstance().getListaPagineNoIE8());
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public boolean usaSVG(HttpServletRequest httpServletRequest) {
        int svgLength = 0;
        String svg = null;
        Enumeration parameterNames = httpServletRequest.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String parName = (String)parameterNames.nextElement();
            log.trace("Parametro [" + parName + "] con Valore [" + httpServletRequest.getParameter(parName) + "].");
            if (parName == null || !parName.endsWith(parametroSVG)) continue;
            svg = httpServletRequest.getParameter(parName);
            log.trace("Parametro [" + parName + "] con Valore [" + httpServletRequest.getParameter(parName) + "] Utilizzato per pilotare il disegno dei grafici.");
            if (parName.endsWith(parametroSVG_FORM_STATS)) {
                String paramGeneraReport = BrowserFilter.getParamValue(httpServletRequest, parametroGeneraReport);
                String paramTipoReport = BrowserFilter.getParamValue(httpServletRequest, parametroTipoReport);
                log.trace("Caso speciale Form Statistiche: Parametro [generaReport] con Valore [" + paramGeneraReport + "] Utilizzato per pilotare il disegno dei grafici.");
                if (StringUtils.isEmpty((String)paramGeneraReport)) {
                    svg = null;
                } else if (StringUtils.isNotEmpty((String)paramTipoReport) && paramTipoReport.equals(parametroTipoReportTabella)) {
                    log.trace("Caso speciale Form Statistiche: Parametro [tipoReportCombo] con Valore [" + paramTipoReport + "] Visualizzazione del report in forma di tabella.");
                    svg = null;
                }
            }
            if (parName.endsWith(parametroSVG_FORM_MENU)) {
                String paramEsitiLive = BrowserFilter.getParamValue(httpServletRequest, parametroEsitiLive);
                log.trace("Caso speciale Menu': Parametro [esiti_live] con Valore [" + paramEsitiLive + "] Utilizzato per pilotare il disegno dei grafici.");
                if (StringUtils.isEmpty((String)paramEsitiLive)) {
                    svg = null;
                }
            }
            if (!parName.endsWith(parametroSVG_POLL_STATO)) break;
            boolean thisResource = !Utils.isContentAuthorizationRequiredForThisResource(httpServletRequest, this.listaPagineNoIE8);
            log.trace("Caso speciale Menu': Parametro [ps_usaSVG] con Valore [" + thisResource + "] Utilizzato per pilotare il disegno dei grafici.");
            if (thisResource) break;
            svg = null;
            break;
        }
        if (svg != null) {
            svgLength = svg.length();
        }
        log.trace("Attivo controllo SVG [" + (svgLength > 0 ? "SI" : "NO") + "]");
        return svgLength > 0;
    }

    public static String getParamValue(HttpServletRequest httpServletRequest, String paramName) {
        Enumeration parameterNames = httpServletRequest.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String parName = (String)parameterNames.nextElement();
            if (parName == null || !parName.contains(paramName)) continue;
            String parameterValue = httpServletRequest.getParameter(parName);
            log.debug("Trovato Parametro [" + parName + "] con Valore [" + parameterValue + "].");
            return parameterValue;
        }
        return null;
    }
}

