/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.filters;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.UUID;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.slf4j.Logger;

public class HeadersFilter
implements Filter {
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private FilterConfig filterConfig = null;
    private String cspHeaderValue;

    public void init(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
        try {
            PddMonitorProperties pddMonitorProperties = PddMonitorProperties.getInstance(log);
            this.cspHeaderValue = pddMonitorProperties.getCspHeaderValue();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) {
        try {
            HttpServletRequest request = (HttpServletRequest)req;
            HttpServletResponse response = (HttpServletResponse)res;
            this.gestioneContentSecurityPolicy(request, response);
            HeadersFilter.gestioneCacheControl(request, response, log);
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        catch (ServletException e) {
            log.error(e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    public void destroy() {
        log.debug("DISTRUIZIONE FILTRO: HeadersFilter");
        this.filterConfig = null;
    }

    private void gestioneContentSecurityPolicy(HttpServletRequest request, HttpServletResponse response) {
        String uuId = UUID.randomUUID().toString().replace("-", "");
        request.setAttribute("_csp_random_nonce", (Object)uuId);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.cspHeaderValue})) {
            response.setHeader("Content-Security-Policy", MessageFormat.format(this.cspHeaderValue, uuId, uuId));
        }
    }

    private static void gestioneCacheControl(HttpServletRequest request, HttpServletResponse response, Logger log) {
        String[] staticResourceDirs;
        String requestUri = request.getRequestURI();
        if (requestUri != null && ServletUtils.isStaticResource((String)requestUri, (String[])(staticResourceDirs = new String[]{"a4j", "resources", "images", "css", "fonts", "scripts"}))) {
            log.debug("Impostazione header Cache-Control per risorsa statica: {}", (Object)requestUri);
            response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
            response.setHeader("Pragma", "no-cache");
            response.setDateHeader("Expires", 0L);
        }
    }
}

