/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.listener;

import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.web.monitor.core.bean.LoginBean;
import org.slf4j.Logger;

public class HttpSessionCheckListener
implements HttpSessionListener {
    private static Logger log = LoggerWrapperFactory.getLogger(HttpSessionCheckListener.class);

    public void sessionCreated(HttpSessionEvent e) {
        log.debug("session {} created.", (Object)e.getSession().getId());
    }

    public void sessionDestroyed(HttpSessionEvent e) {
        log.debug("session {} destroyed.", (Object)e.getSession().getId());
        try {
            this.cleanUp(e.getSession());
        }
        catch (Exception ex) {
            log.error("errore durante le operazioni di clean-up", (Throwable)ex);
        }
    }

    private void cleanUp(HttpSession session) {
        LoginBean lb = (LoginBean)session.getAttribute("loginBean");
        if (lb != null) {
            log.debug("remove user {} from session", (Object)lb.getUsername());
            session.setAttribute("loginBean", null);
        } else {
            log.debug("no login info found in session, nothing to do.");
        }
    }
}

