/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.listener;

import javax.faces.application.FacesMessage;
import javax.faces.application.NavigationHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.web.monitor.core.bean.LoginBean;
import org.slf4j.Logger;

public class LoginPhaseListener
implements PhaseListener {
    public static final String PRINCIPAL_ERROR_MSG = "principalErrorMsg";
    public static final String PRINCIPAL_SHOW_FORM = "principalShowForm";
    private static final long serialVersionUID = -7545768911858875216L;
    private static Logger log = LoggerWrapperFactory.getLogger(LoginPhaseListener.class);
    private static String[] allowedPages = new String[]{"login", "timeout", "error"};

    public void afterPhase(PhaseEvent event) {
        try {
            boolean allowedPage;
            FacesContext fc = event.getFacesContext();
            ExternalContext ec = fc.getExternalContext();
            LoginBean lb = (LoginBean)ec.getSessionMap().get("loginBean");
            boolean isLogged = lb != null && lb.isLoggedIn();
            UIViewRoot vr = fc.getViewRoot();
            boolean bl = allowedPage = vr != null && this.isAllowedPage(vr.getViewId());
            if (!isLogged && lb != null && lb.getUserToUpdate() != null) {
                allowedPage = true;
            }
            String msg = null;
            if (allowedPage && vr != null && StringUtils.contains((String)vr.getViewId(), (String)"error") && (msg = (String)ec.getSessionMap().get(PRINCIPAL_ERROR_MSG)) != null) {
                ec.getRequestMap().put(PRINCIPAL_SHOW_FORM, "true");
                ec.getSessionMap().remove(PRINCIPAL_ERROR_MSG);
                HttpSession session = (HttpSession)ec.getSession(false);
                if (session != null) {
                    session.invalidate();
                }
                this.addError(fc, msg);
            }
            if (!allowedPage && !isLogged) {
                this.addError(fc, this.getErrorAutenticazione(msg));
                NavigationHandler nh = fc.getApplication().getNavigationHandler();
                nh.handleNavigation(fc, null, "login");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private String getErrorAutenticazione(String msg) {
        return msg != null ? msg : "Autenticazione richiesta.";
    }

    private boolean isAllowedPage(String viewId) {
        for (int i = 0; i < allowedPages.length; ++i) {
            String page = allowedPages[i];
            if (!StringUtils.contains((String)viewId, (String)page)) continue;
            return true;
        }
        return false;
    }

    public void beforePhase(PhaseEvent event) {
    }

    public PhaseId getPhaseId() {
        return PhaseId.RESTORE_VIEW;
    }

    private void addError(FacesContext context, String message) {
        FacesMessage fMessage = new FacesMessage(message);
        if (fMessage != null) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            fMessage.setSeverity(FacesMessage.SEVERITY_ERROR);
            facesContext.addMessage(null, fMessage);
        }
    }
}

