/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.mbean;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.commons.search.Soggetto;
import org.openspcoop2.core.commons.search.constants.TipoPdD;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.plugins.dao.IServiceManager;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.protocol.engine.utils.NamingUtils;
import org.openspcoop2.web.monitor.core.bean.BaseSearchForm;
import org.openspcoop2.web.monitor.core.bean.SelectItem;
import org.openspcoop2.web.monitor.core.bean.UserDetailsBean;
import org.openspcoop2.web.monitor.core.constants.TipologiaRicerca;
import org.openspcoop2.web.monitor.core.core.ConfigurazioneSoggettiVisualizzatiSearchForm;
import org.openspcoop2.web.monitor.core.core.Utility;
import org.openspcoop2.web.monitor.core.dao.IService;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.mbean.PdDBaseBean;
import org.openspcoop2.web.monitor.core.utils.DynamicPdDBeanUtils;
import org.slf4j.Logger;

public class DynamicPdDBean<T, K, ServiceType extends IService>
extends PdDBaseBean<T, K, ServiceType> {
    private static final long serialVersionUID = 1L;
    protected static Logger log = LoggerManager.getPddMonitorCoreLogger();
    protected List<javax.faces.model.SelectItem> soggettiAssociati = null;
    protected List<javax.faces.model.SelectItem> soggettiLocale = null;
    protected List<javax.faces.model.SelectItem> soggetti = null;
    protected List<javax.faces.model.SelectItem> gruppi = null;
    protected List<javax.faces.model.SelectItem> api = null;
    protected List<javax.faces.model.SelectItem> servizi = null;
    protected List<javax.faces.model.SelectItem> azioni = null;
    protected List<javax.faces.model.SelectItem> serviziApplicativi = null;
    protected Integer soggettiAssociatiSelectItemsWidth = 0;
    protected Integer soggettiLocaleSelectItemsWidth = 0;
    protected Integer soggettiSelectItemsWidth = 0;
    protected Integer gruppiSelectItemsWidth = 0;
    protected Integer apiSelectItemsWidth = 0;
    protected Integer serviziSelectItemsWidth = 0;
    protected Integer serviziApplicativiSelectItemsWidth = 0;
    protected Integer azioniSelectItemsWidth = 0;
    protected boolean soggettiAssociatiSelectItemsWidthCheck = false;
    protected boolean soggettiLocaleSelectItemsWidthCheck = false;
    protected boolean soggettiSelectItemsWidthCheck = false;
    protected boolean gruppiSelectItemsWidthCheck = false;
    protected boolean apiSelectItemsWidthCheck = false;
    protected boolean serviziSelectItemsWidthCheck = false;
    protected boolean serviziApplicativiSelectItemsWidthCheck = false;
    protected boolean azioniSelectItemsWidthCheck = false;
    protected transient BaseSearchForm search;
    protected Integer maxSelectItemsWidth = 900;
    protected Integer defaultSelectItemsWidth = 412;
    protected DynamicPdDBeanUtils dynamicUtils = null;

    public DynamicPdDBean() {
        try {
            this.dynamicUtils = new DynamicPdDBeanUtils(log);
        }
        catch (Exception e) {
            log.error("lettura delle properties fallita.....", (Throwable)e);
        }
    }

    public DynamicPdDBean(org.openspcoop2.core.commons.search.dao.IServiceManager serviceManager, IServiceManager pluginsServiceManager, DriverRegistroServiziDB driverRegistroServiziDB, DriverConfigurazioneDB driverConfigurazioneDB) {
        super(serviceManager, pluginsServiceManager, driverRegistroServiziDB, driverConfigurazioneDB);
        try {
            this.dynamicUtils = new DynamicPdDBeanUtils(serviceManager, pluginsServiceManager, driverRegistroServiziDB, driverConfigurazioneDB, log);
        }
        catch (Exception e) {
            log.error("lettura delle properties fallita.....", (Throwable)e);
        }
    }

    public void setSearch(BaseSearchForm searc) {
        this.search = searc;
    }

    public BaseSearchForm getSearch() {
        return this.search;
    }

    public List<SelectItem> gruppiAutoComplete(Object val) throws Exception {
        ArrayList<SelectItem> listaGruppi = new ArrayList<SelectItem>();
        List<Object> listaGruppiTmp = new ArrayList<javax.faces.model.SelectItem>();
        if (val != null && !StringUtils.isEmpty((String)((String)val))) {
            listaGruppiTmp = this._getGruppi((String)val);
        }
        listaGruppiTmp.add(0, new javax.faces.model.SelectItem((Object)"--", "--"));
        for (javax.faces.model.SelectItem selectItem : listaGruppiTmp) {
            String label = selectItem.getLabel();
            String value = (String)selectItem.getValue();
            SelectItem newItem = new SelectItem(value, label);
            listaGruppi.add(newItem);
        }
        return listaGruppi;
    }

    public List<javax.faces.model.SelectItem> getGruppi() throws Exception {
        return this._getGruppi(null);
    }

    protected List<javax.faces.model.SelectItem> _getGruppi(String input) throws Exception {
        if (this.search == null) {
            return new ArrayList<javax.faces.model.SelectItem>();
        }
        if (!this.gruppiSelectItemsWidthCheck) {
            this.gruppi = new ArrayList<javax.faces.model.SelectItem>();
            String tipoProtocollo = this.search.getProtocollo();
            this.gruppi = this.dynamicUtils.getListaGruppi(tipoProtocollo);
            Integer lunghezzaSelectList = this.dynamicUtils.getLunghezzaSelectList(this.gruppi);
            this.gruppiSelectItemsWidth = Math.max(this.gruppiSelectItemsWidth, lunghezzaSelectList);
        }
        return this.gruppi;
    }

    public List<SelectItem> azioniAutoComplete(Object val) throws Exception {
        ArrayList<SelectItem> listaAzioni = new ArrayList<SelectItem>();
        List<Object> listaAzioniTmp = new ArrayList<javax.faces.model.SelectItem>();
        if (val != null && !StringUtils.isEmpty((String)((String)val))) {
            listaAzioniTmp = this._getAzioni((String)val);
        }
        listaAzioniTmp.add(0, new javax.faces.model.SelectItem((Object)"--", "--"));
        for (javax.faces.model.SelectItem selectItem : listaAzioniTmp) {
            String label = selectItem.getLabel();
            String value = (String)selectItem.getValue();
            SelectItem newItem = new SelectItem(value, label);
            listaAzioni.add(newItem);
        }
        return listaAzioni;
    }

    public List<javax.faces.model.SelectItem> getAzioni() {
        return this._getAzioni(null);
    }

    protected List<javax.faces.model.SelectItem> _getAzioni(String input) {
        if (this.search == null) {
            return new ArrayList<javax.faces.model.SelectItem>();
        }
        if (this.search.getApi() == null && this.search.getNomeServizio() == null) {
            return new ArrayList<javax.faces.model.SelectItem>();
        }
        if (this.search != null && StringUtils.isBlank((String)this.search.getNomeServizio()) && StringUtils.isBlank((String)this.search.getApi())) {
            return new ArrayList<javax.faces.model.SelectItem>();
        }
        if (!this.azioniSelectItemsWidthCheck) {
            this.azioni = new ArrayList<javax.faces.model.SelectItem>();
            try {
                String tipoProtocollo = this.search.getProtocollo();
                if (StringUtils.isNotBlank((String)this.search.getApi())) {
                    String api = this.search.getApi();
                    IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(api);
                    String nome = idAccordo.getNome();
                    Integer versione = idAccordo.getVersione();
                    String tipoReferente = idAccordo.getSoggettoReferente().getTipo();
                    String nomeReferente = idAccordo.getSoggettoReferente().getNome();
                    this.azioni = this.dynamicUtils.getListaSelectItemsAzioniFromAPI(tipoProtocollo, nome, tipoReferente, nomeReferente, versione, input);
                } else if (StringUtils.isNotBlank((String)this.search.getNomeServizio())) {
                    IDServizio idServizio = Utility.parseServizioSoggetto(this.search.getNomeServizio());
                    String nomeServizio = idServizio.getNome();
                    String tipoServizio = idServizio.getTipo();
                    String nomeErogatore = idServizio.getSoggettoErogatore().getNome();
                    String tipoErogatore = idServizio.getSoggettoErogatore().getTipo();
                    Integer versioneServizio = idServizio.getVersione();
                    this.azioni = this.dynamicUtils.getListaSelectItemsAzioniFromServizio(tipoProtocollo, tipoServizio, nomeServizio, tipoErogatore, nomeErogatore, versioneServizio, input);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            Integer lunghezzaSelectList = this.dynamicUtils.getLunghezzaSelectList(this.azioni);
            this.azioniSelectItemsWidth = Math.max(this.azioniSelectItemsWidth, lunghezzaSelectList);
        }
        return this.azioni;
    }

    public List<SelectItem> apiAutoComplete(Object val) throws Exception {
        ArrayList<SelectItem> listaApi = new ArrayList<SelectItem>();
        List<Object> listaApiTmp = new ArrayList<javax.faces.model.SelectItem>();
        if (val != null && !StringUtils.isEmpty((String)((String)val))) {
            listaApiTmp = this._getApiList((String)val);
        }
        listaApiTmp.add(0, new javax.faces.model.SelectItem((Object)"--", "--"));
        for (javax.faces.model.SelectItem selectItem : listaApiTmp) {
            String label = selectItem.getLabel();
            String value = (String)selectItem.getValue();
            SelectItem newItem = new SelectItem(value, label);
            listaApi.add(newItem);
        }
        return listaApi;
    }

    public List<javax.faces.model.SelectItem> getApiList() throws Exception {
        return this._getApiList(null);
    }

    protected List<javax.faces.model.SelectItem> _getApiList(String input) throws Exception {
        if (this.search == null) {
            return new ArrayList<javax.faces.model.SelectItem>();
        }
        if (!this.apiSelectItemsWidthCheck) {
            this.api = new ArrayList<javax.faces.model.SelectItem>();
            String tipoSoggettoReferente = null;
            String nomeSoggettoReferente = null;
            boolean isReferente = false;
            String tipoProtocollo = this.search.getProtocollo();
            String gruppo = this.search.getGruppo();
            this.api = this.dynamicUtils.getListaSelectItemsAccordiServizio(tipoProtocollo, tipoSoggettoReferente, nomeSoggettoReferente, isReferente, false, gruppo);
            Integer lunghezzaSelectList = this.dynamicUtils.getLunghezzaSelectList(this.api);
            this.apiSelectItemsWidth = Math.max(this.apiSelectItemsWidth, lunghezzaSelectList);
        }
        return this.api;
    }

    public List<SelectItem> serviziAutoComplete(Object val) throws Exception {
        ArrayList<SelectItem> listaServizi = new ArrayList<SelectItem>();
        List<Object> listaServiziTmp = new ArrayList<javax.faces.model.SelectItem>();
        if (val != null && !StringUtils.isEmpty((String)((String)val))) {
            listaServiziTmp = this._getServizi((String)val);
        }
        listaServiziTmp.add(0, new javax.faces.model.SelectItem((Object)"--", "--"));
        for (javax.faces.model.SelectItem selectItem : listaServiziTmp) {
            String label = selectItem.getLabel();
            String value = (String)selectItem.getValue();
            SelectItem newItem = new SelectItem(value, label);
            listaServizi.add(newItem);
        }
        return listaServizi;
    }

    public List<javax.faces.model.SelectItem> getServizi() throws Exception {
        return this._getServizi(null);
    }

    protected List<javax.faces.model.SelectItem> _getServizi(String input) throws Exception {
        if (this.search == null) {
            return new ArrayList<javax.faces.model.SelectItem>();
        }
        if (!this.serviziSelectItemsWidthCheck) {
            this.servizi = new ArrayList<javax.faces.model.SelectItem>();
            Soggetto erogatore = this._getSoggettoErogatore();
            String tipoSoggetto = null;
            String nomeSoggetto = null;
            if (erogatore != null) {
                tipoSoggetto = erogatore.getTipoSoggetto();
                nomeSoggetto = erogatore.getNomeSoggetto();
            }
            String tipoProtocollo = this.search.getProtocollo();
            String gruppo = this.search.getGruppo();
            IDAccordo idAccordo = null;
            String api = this.search.getApi();
            if (api != null && !"".equals(api)) {
                idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(api);
            }
            this.servizi = TipologiaRicerca.uscita.equals((Object)this.search.getTipologiaRicercaEnum()) ? this.dynamicUtils.getListaSelectItemsElencoServiziFruizione(tipoProtocollo, gruppo, idAccordo, tipoSoggetto, nomeSoggetto, input, true) : (TipologiaRicerca.ingresso.equals((Object)this.search.getTipologiaRicercaEnum()) ? this.dynamicUtils.getListaSelectItemsElencoServiziErogazione(tipoProtocollo, gruppo, idAccordo, tipoSoggetto, nomeSoggetto, input, true) : this.dynamicUtils.getListaSelectItemsElencoServiziFromAccordoAndSoggettoErogatore(tipoProtocollo, gruppo, idAccordo, null, tipoSoggetto, nomeSoggetto, input));
            Integer lunghezzaSelectList = this.dynamicUtils.getLunghezzaSelectList(this.servizi);
            this.serviziSelectItemsWidth = Math.max(this.serviziSelectItemsWidth, lunghezzaSelectList);
        }
        return this.servizi;
    }

    public List<javax.faces.model.SelectItem> _getSoggetti(boolean includiOperativi, boolean includiEsterni, String input) throws Exception {
        return this._getSoggetti(includiOperativi, includiEsterni, false, input);
    }

    public List<javax.faces.model.SelectItem> _getSoggetti(boolean includiOperativi, boolean includiEsterni, boolean escludiSoggettoSelezionato, String input) throws Exception {
        if (this.search == null) {
            return new ArrayList<javax.faces.model.SelectItem>();
        }
        if (!this.soggettiSelectItemsWidthCheck) {
            this.soggetti = new ArrayList<javax.faces.model.SelectItem>();
            String tipoProtocollo = this.search.getProtocollo();
            String idPorta = null;
            List<Soggetto> list = this.dynamicUtilsService.findElencoSoggetti(tipoProtocollo, idPorta, input);
            for (Soggetto soggetto : list) {
                boolean add = true;
                if (!includiOperativi || !includiEsterni) {
                    String nomePddFromSoggetto;
                    if (includiOperativi) {
                        nomePddFromSoggetto = this.dynamicUtils.getServerFromSoggetto(soggetto.getTipoSoggetto(), soggetto.getNomeSoggetto());
                        add = this.dynamicUtils.checkTipoPdd(nomePddFromSoggetto, TipoPdD.OPERATIVO);
                    }
                    if (includiEsterni) {
                        nomePddFromSoggetto = this.dynamicUtils.getServerFromSoggetto(soggetto.getTipoSoggetto(), soggetto.getNomeSoggetto());
                        add = this.dynamicUtils.checkTipoPdd(nomePddFromSoggetto, TipoPdD.ESTERNO);
                    }
                }
                if (escludiSoggettoSelezionato && this.search != null && this.search.getUser() != null) {
                    String soggettoSelezionato = this.search.getUser().getSoggettoSelezionatoPddMonitor();
                    if (soggettoSelezionato == null || "".equals(soggettoSelezionato)) {
                        soggettoSelezionato = this.search.getTipoNomeSoggettoLocale();
                    }
                    if (soggettoSelezionato != null && !"".equals(soggettoSelezionato) && soggettoSelezionato.contains("/")) {
                        String tipo = soggettoSelezionato.split("/")[0];
                        String nome = soggettoSelezionato.split("/")[1];
                        if (tipo.equals(soggetto.getTipoSoggetto()) && nome.equals(soggetto.getNomeSoggetto())) {
                            add = false;
                        }
                    }
                }
                if (!add) continue;
                String value = soggetto.getTipoSoggetto() + "/" + soggetto.getNomeSoggetto();
                IDSoggetto idSoggetto = new IDSoggetto(soggetto.getTipoSoggetto(), soggetto.getNomeSoggetto());
                String label = tipoProtocollo != null ? NamingUtils.getLabelSoggetto((String)tipoProtocollo, (IDSoggetto)idSoggetto) : NamingUtils.getLabelSoggetto((IDSoggetto)idSoggetto);
                this.soggetti.add(new javax.faces.model.SelectItem((Object)value, label));
            }
            Integer lunghezzaSelectList = this.dynamicUtils.getLunghezzaSelectList(this.soggetti);
            this.soggettiSelectItemsWidth = Math.max(this.soggettiSelectItemsWidth, lunghezzaSelectList);
        }
        return this.soggetti;
    }

    public List<SelectItem> soggettiLocaleAutoComplete(Object val) throws Exception {
        List<Object> listaSoggettiTmp = new ArrayList<javax.faces.model.SelectItem>();
        if (val != null && !StringUtils.isEmpty((String)((String)val))) {
            listaSoggettiTmp = this._getSoggettiLocale(true, false, (String)val);
        }
        listaSoggettiTmp.add(0, new javax.faces.model.SelectItem((Object)"--", "--"));
        ArrayList<SelectItem> listaSoggetti = new ArrayList<SelectItem>();
        for (javax.faces.model.SelectItem selectItem : listaSoggettiTmp) {
            String label = selectItem.getLabel();
            String value = (String)selectItem.getValue();
            SelectItem newItem = new SelectItem(value, label);
            listaSoggetti.add(newItem);
        }
        return listaSoggetti;
    }

    public List<javax.faces.model.SelectItem> getSoggettiLocale() throws Exception {
        return this._getSoggettiLocale(true, false, null);
    }

    public List<javax.faces.model.SelectItem> _getSoggettiLocale(boolean includiOperativi, boolean includiEsterni, String input) throws Exception {
        if (this.search == null) {
            return new ArrayList<javax.faces.model.SelectItem>();
        }
        if (!this.soggettiLocaleSelectItemsWidthCheck) {
            this.soggettiLocale = new ArrayList<javax.faces.model.SelectItem>();
            String tipoProtocollo = this.search.getProtocollo();
            String idPorta = null;
            List<Soggetto> list = this.dynamicUtilsService.findElencoSoggetti(tipoProtocollo, idPorta, input);
            for (Soggetto soggetto : list) {
                boolean add = true;
                if (!includiOperativi || !includiEsterni) {
                    String nomePddFromSoggetto;
                    if (includiOperativi) {
                        nomePddFromSoggetto = this.dynamicUtils.getServerFromSoggetto(soggetto.getTipoSoggetto(), soggetto.getNomeSoggetto());
                        add = this.dynamicUtils.checkTipoPdd(nomePddFromSoggetto, TipoPdD.OPERATIVO);
                    }
                    if (includiEsterni) {
                        nomePddFromSoggetto = this.dynamicUtils.getServerFromSoggetto(soggetto.getTipoSoggetto(), soggetto.getNomeSoggetto());
                        add = this.dynamicUtils.checkTipoPdd(nomePddFromSoggetto, TipoPdD.ESTERNO);
                    }
                }
                if (!add) continue;
                String value = soggetto.getTipoSoggetto() + "/" + soggetto.getNomeSoggetto();
                IDSoggetto idSoggetto = new IDSoggetto(soggetto.getTipoSoggetto(), soggetto.getNomeSoggetto());
                String label = tipoProtocollo != null ? NamingUtils.getLabelSoggetto((String)tipoProtocollo, (IDSoggetto)idSoggetto) : NamingUtils.getLabelSoggetto((IDSoggetto)idSoggetto);
                this.soggettiLocale.add(new javax.faces.model.SelectItem((Object)value, label));
            }
            Integer lunghezzaSelectList = this.dynamicUtils.getLunghezzaSelectList(this.soggettiLocale);
            this.soggettiLocaleSelectItemsWidth = Math.max(this.soggettiLocaleSelectItemsWidth, lunghezzaSelectList);
        }
        return this.soggettiLocale;
    }

    protected Soggetto _getSoggettoErogatore() {
        Soggetto erogatore = null;
        if (TipologiaRicerca.ingresso.equals((Object)this.search.getTipologiaRicercaEnum())) {
            if (StringUtils.isNotBlank((String)this.search.getSoggettoLocale())) {
                erogatore = this.dynamicUtilsService.findSoggettoByTipoNome(this.search.getTipoSoggettoLocale(), this.search.getSoggettoLocale());
            }
        } else if (TipologiaRicerca.uscita.equals((Object)this.search.getTipologiaRicercaEnum()) && StringUtils.isNotBlank((String)this.search.getNomeDestinatario())) {
            erogatore = this.dynamicUtilsService.findSoggettoByTipoNome(this.search.getTipoDestinatario(), this.search.getNomeDestinatario());
        }
        return erogatore;
    }

    public List<javax.faces.model.SelectItem> getServiziApplicativi() throws Exception {
        if (this.search == null) {
            return new ArrayList<javax.faces.model.SelectItem>();
        }
        if (!this.serviziApplicativiSelectItemsWidthCheck) {
            this.serviziApplicativi = new ArrayList<javax.faces.model.SelectItem>();
            String tipoProtocollo = this.search.getProtocollo();
            String nomeSoggetto = null;
            String tipoSoggetto = null;
            if (TipologiaRicerca.ingresso.equals((Object)this.search.getTipologiaRicercaEnum()) && StringUtils.isNotEmpty((String)this.search.getRiconoscimento()) && this.search.getRiconoscimento().equals("applicativo")) {
                if (StringUtils.isNotBlank((String)this.search.getTipoNomeMittente())) {
                    tipoSoggetto = this.search.getTipoMittente();
                    nomeSoggetto = this.search.getNomeMittente();
                }
            } else if (StringUtils.isNotBlank((String)this.search.getSoggettoLocale())) {
                tipoSoggetto = this.search.getTipoSoggettoLocale();
                nomeSoggetto = this.search.getSoggettoLocale();
            } else {
                List<Soggetto> lista;
                boolean multiTenant = Utility.isMultitenantAbilitato();
                if (!multiTenant && (lista = this.dynamicUtils.getListaSoggetti(tipoProtocollo, TipoPdD.OPERATIVO)) != null && lista.size() == 1) {
                    nomeSoggetto = lista.get(0).getNomeSoggetto();
                    tipoSoggetto = lista.get(0).getTipoSoggetto();
                }
            }
            if (tipoSoggetto != null && nomeSoggetto != null && StringUtils.isNotEmpty((String)this.search.getIdentificazione())) {
                boolean trasporto = "commons.identificazione.trasporto.label".equals(this.search.getIdentificazione());
                boolean token = "commons.identificazione.token.label".equals(this.search.getIdentificazione());
                this.serviziApplicativi = this.dynamicUtils.getListaSelectItemsServiziApplicativiFromSoggettoLocale(tipoProtocollo, tipoSoggetto, nomeSoggetto, trasporto, token);
            }
            Integer lunghezzaSelectList = this.dynamicUtils.getLunghezzaSelectList(this.serviziApplicativi);
            this.serviziApplicativiSelectItemsWidth = Math.max(this.serviziApplicativiSelectItemsWidth, lunghezzaSelectList);
        }
        return this.serviziApplicativi;
    }

    public List<SelectItem> soggettiAutoComplete(Object val) throws Exception {
        ArrayList<SelectItem> listaSoggetti = new ArrayList<SelectItem>();
        List<javax.faces.model.SelectItem> listaSoggettiTmp = new ArrayList<javax.faces.model.SelectItem>();
        if (val != null && !StringUtils.isEmpty((String)((String)val))) {
            if (this.search != null && TipologiaRicerca.ingresso.equals((Object)this.search.getTipologiaRicercaEnum()) && StringUtils.isNotEmpty((String)this.search.getRiconoscimento()) && this.search.getRiconoscimento().equals("applicativo")) {
                listaSoggettiTmp = this._getSoggetti(true, false, false, (String)val);
            } else {
                ConfigurazioneSoggettiVisualizzatiSearchForm config = Utility.getMultitenantAbilitatoSoggettiConfig(this.search != null ? this.search.getTipologiaRicercaEnum() : null);
                listaSoggettiTmp = this._getSoggetti(config.isIncludiSoloOperativi(), config.isIncludiSoloEsterni(), config.isEscludiSoggettoSelezionato(), (String)val);
            }
        }
        listaSoggettiTmp.add(0, new javax.faces.model.SelectItem((Object)"--", "--"));
        for (javax.faces.model.SelectItem selectItem : listaSoggettiTmp) {
            String label = selectItem.getLabel();
            String value = (String)selectItem.getValue();
            SelectItem newItem = new SelectItem(value, label);
            listaSoggetti.add(newItem);
        }
        return listaSoggetti;
    }

    public List<javax.faces.model.SelectItem> getSoggetti() throws Exception {
        if (this.search != null && TipologiaRicerca.ingresso.equals((Object)this.search.getTipologiaRicercaEnum()) && StringUtils.isNotEmpty((String)this.search.getRiconoscimento()) && this.search.getRiconoscimento().equals("applicativo")) {
            boolean isSupportataAutenticazioneApplicativiEsterni = this.dynamicUtils.isSupportataAutenticazioneApplicativiEsterniErogazione(this.search.getProtocollo());
            return this._getSoggetti(true, isSupportataAutenticazioneApplicativiEsterni, false, null);
        }
        ConfigurazioneSoggettiVisualizzatiSearchForm config = Utility.getMultitenantAbilitatoSoggettiConfig(this.search != null ? this.search.getTipologiaRicercaEnum() : null);
        return this._getSoggetti(config.isIncludiSoloOperativi(), config.isIncludiSoloEsterni(), config.isEscludiSoggettoSelezionato(), null);
    }

    public List<javax.faces.model.SelectItem> getTipiNomiSoggettiAssociati() throws Exception {
        return this._getTipiNomiSoggettiAssociati(false);
    }

    public List<javax.faces.model.SelectItem> _getTipiNomiSoggettiAssociati(boolean soloOperativi) throws Exception {
        if (this.search == null) {
            return new ArrayList<javax.faces.model.SelectItem>();
        }
        if (!this.soggettiAssociatiSelectItemsWidthCheck) {
            this.soggettiAssociati = new ArrayList<javax.faces.model.SelectItem>();
            UserDetailsBean loggedUser = Utility.getLoggedUser();
            if (loggedUser != null) {
                List<Object> lst = new ArrayList();
                String tipoProtocollo = this.search.getProtocollo();
                if (tipoProtocollo == null) {
                    lst = loggedUser.getUtenteSoggettoList();
                } else {
                    ArrayList tipiNomiSoggettiAssociati = loggedUser.getUtenteSoggettoProtocolliMap().containsKey(tipoProtocollo) ? loggedUser.getUtenteSoggettoProtocolliMap().get(tipoProtocollo) : new ArrayList();
                    ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
                    if (tipiNomiSoggettiAssociati != null && tipiNomiSoggettiAssociati.size() > 0) {
                        for (IDSoggetto utenteSoggetto : tipiNomiSoggettiAssociati) {
                            String tipoNome = utenteSoggetto.getTipo() + "/" + utenteSoggetto.getNome();
                            boolean add = true;
                            if (soloOperativi) {
                                String nomePddFromSoggetto = this.dynamicUtils.getServerFromSoggetto(utenteSoggetto.getTipo(), utenteSoggetto.getNome());
                                add = this.dynamicUtils.checkTipoPdd(nomePddFromSoggetto, TipoPdD.OPERATIVO);
                            }
                            if (arrayList.contains(tipoNome) || !add) continue;
                            arrayList.add((CallSite)((Object)tipoNome));
                            lst.add(utenteSoggetto);
                        }
                    }
                }
                for (IDSoggetto iDSoggetto : lst) {
                    String value = iDSoggetto.getTipo() + "/" + iDSoggetto.getNome();
                    String label = tipoProtocollo != null ? NamingUtils.getLabelSoggetto((String)tipoProtocollo, (IDSoggetto)iDSoggetto) : NamingUtils.getLabelSoggetto((IDSoggetto)iDSoggetto);
                    this.soggettiAssociati.add(new javax.faces.model.SelectItem((Object)value, label));
                }
            }
        }
        return this.soggettiAssociati;
    }

    public String getSoggettiAssociatiSelectItemsWidth() throws Exception {
        this.soggettiAssociatiSelectItemsWidthCheck = false;
        this.getTipiNomiSoggettiAssociati();
        this.soggettiAssociatiSelectItemsWidthCheck = true;
        return this.checkWidthLimits(this.soggettiAssociatiSelectItemsWidth).toString();
    }

    public String getSoggettiLocaleSelectItemsWidth() throws Exception {
        this.soggettiLocaleSelectItemsWidthCheck = false;
        this.getSoggettiLocale();
        this.soggettiLocaleSelectItemsWidthCheck = true;
        return this.checkWidthLimits(this.soggettiLocaleSelectItemsWidth).toString();
    }

    public String getSoggettiSelectItemsWidth() throws Exception {
        this.soggettiSelectItemsWidthCheck = false;
        this.getSoggetti();
        this.soggettiSelectItemsWidthCheck = true;
        return this.checkWidthLimits(this.soggettiSelectItemsWidth).toString();
    }

    public String getGruppiSelectItemsWidth() throws Exception {
        this.gruppiSelectItemsWidthCheck = false;
        this.getGruppi();
        this.gruppiSelectItemsWidthCheck = true;
        return this.checkWidthLimits(this.gruppiSelectItemsWidth).toString();
    }

    public String getApiSelectItemsWidth() throws Exception {
        this.apiSelectItemsWidthCheck = false;
        this.getApiList();
        this.apiSelectItemsWidthCheck = true;
        return this.checkWidthLimits(this.apiSelectItemsWidth).toString();
    }

    public String getServiziSelectItemsWidth() throws Exception {
        this.serviziSelectItemsWidthCheck = false;
        this.getServizi();
        this.serviziSelectItemsWidthCheck = true;
        return this.checkWidthLimits(this.serviziSelectItemsWidth).toString();
    }

    public String getServiziApplicativiSelectItemsWidth() throws Exception {
        this.serviziApplicativiSelectItemsWidthCheck = false;
        this.getServiziApplicativi();
        this.serviziApplicativiSelectItemsWidthCheck = true;
        return this.checkWidthLimits(this.serviziApplicativiSelectItemsWidth).toString();
    }

    public String getAzioniSelectItemsWidth() {
        this.azioniSelectItemsWidthCheck = false;
        this.getAzioni();
        this.azioniSelectItemsWidthCheck = true;
        return this.checkWidthLimits(this.azioniSelectItemsWidth).toString();
    }

    public Integer checkWidthLimits(Integer value) {
        Integer toRet = Math.max(this.defaultSelectItemsWidth, value);
        toRet = Math.min(toRet, this.maxSelectItemsWidth);
        return toRet;
    }

    public boolean isSoggettiLocaleSelectItemsWidthCheck() {
        return this.soggettiLocaleSelectItemsWidthCheck;
    }

    public void setSoggettiLocaleSelectItemsWidthCheck(boolean soggettiLocaleSelectItemsWidthCheck) {
        this.soggettiLocaleSelectItemsWidthCheck = soggettiLocaleSelectItemsWidthCheck;
    }

    public boolean isSoggettiAssociatiSelectItemsWidthCheck() {
        return this.soggettiAssociatiSelectItemsWidthCheck;
    }

    public void setSoggettiAssociatiSelectItemsWidthCheck(boolean soggettiAssociatiSelectItemsWidthCheck) {
        this.soggettiAssociatiSelectItemsWidthCheck = soggettiAssociatiSelectItemsWidthCheck;
    }

    public boolean isSoggettiSelectItemsWidthCheck() {
        return this.soggettiSelectItemsWidthCheck;
    }

    public void setSoggettiSelectItemsWidthCheck(boolean soggettiSelectItemsWidthCheck) {
        this.soggettiSelectItemsWidthCheck = soggettiSelectItemsWidthCheck;
    }

    public boolean isGruppiSelectItemsWidthCheck() {
        return this.gruppiSelectItemsWidthCheck;
    }

    public void setGruppiSelectItemsWidthCheck(boolean gruppiSelectItemsWidthCheck) {
        this.gruppiSelectItemsWidthCheck = gruppiSelectItemsWidthCheck;
    }

    public boolean isApiSelectItemsWidthCheck() {
        return this.apiSelectItemsWidthCheck;
    }

    public void setApiSelectItemsWidthCheck(boolean apiSelectItemsWidthCheck) {
        this.apiSelectItemsWidthCheck = apiSelectItemsWidthCheck;
    }

    public boolean isServiziSelectItemsWidthCheck() {
        return this.serviziSelectItemsWidthCheck;
    }

    public void setServiziSelectItemsWidthCheck(boolean serviziSelectItemsWidthCheck) {
        this.serviziSelectItemsWidthCheck = serviziSelectItemsWidthCheck;
    }

    public boolean isServiziApplicativiSelectItemsWidthCheck() {
        return this.serviziApplicativiSelectItemsWidthCheck;
    }

    public void setServiziApplicativiSelectItemsWidthCheck(boolean serviziApplicativiSelectItemsWidthCheck) {
        this.serviziApplicativiSelectItemsWidthCheck = serviziApplicativiSelectItemsWidthCheck;
    }

    public boolean isAzioniSelectItemsWidthCheck() {
        return this.azioniSelectItemsWidthCheck;
    }

    public void setAzioniSelectItemsWidthCheck(boolean azioniSelectItemsWidthCheck) {
        this.azioniSelectItemsWidthCheck = azioniSelectItemsWidthCheck;
    }

    public Integer getDefaultSelectItemsWidth() {
        return this.defaultSelectItemsWidth;
    }

    public void setDefaultSelectItemsWidth(Integer defaultSelectItemsWidth) {
        this.defaultSelectItemsWidth = defaultSelectItemsWidth;
    }

    public void setGruppiSelectItemsWidth(Integer gruppiSelectItemsWidth) {
        this.gruppiSelectItemsWidth = gruppiSelectItemsWidth;
    }

    public void setApiSelectItemsWidth(Integer apiSelectItemsWidth) {
        this.apiSelectItemsWidth = apiSelectItemsWidth;
    }

    public void setServiziSelectItemsWidth(Integer serviziSelectItemsWidth) {
        this.serviziSelectItemsWidth = serviziSelectItemsWidth;
    }

    public void setServiziApplicativiSelectItemsWidth(Integer serviziApplicativiSelectItemsWidth) {
        this.serviziApplicativiSelectItemsWidth = serviziApplicativiSelectItemsWidth;
    }

    public void setAzioniSelectItemsWidth(Integer azioniSelectItemsWidth) {
        this.azioniSelectItemsWidth = azioniSelectItemsWidth;
    }

    public Integer getSoggettiLocaleSelectItemsWidthAsInteger() throws Exception {
        return this.checkWidthLimits(this.soggettiLocaleSelectItemsWidth);
    }

    public Integer getSoggettiAssociatiSelectItemsWidthAsInteger() throws Exception {
        return this.checkWidthLimits(this.soggettiAssociatiSelectItemsWidth);
    }

    public Integer getSoggettiSelectItemsWidthAsInteger() throws Exception {
        return this.checkWidthLimits(this.soggettiSelectItemsWidth);
    }

    public Integer getGruppiSelectItemsWidthAsInteger() throws Exception {
        return this.checkWidthLimits(this.gruppiSelectItemsWidth);
    }

    public Integer getApiSelectItemsWidthAsInteger() throws Exception {
        return this.checkWidthLimits(this.apiSelectItemsWidth);
    }

    public Integer getServiziSelectItemsWidthAsInteger() throws Exception {
        return this.checkWidthLimits(this.serviziSelectItemsWidth);
    }

    public Integer getServiziApplicativiSelectItemsWidthAsInteger() throws Exception {
        return this.checkWidthLimits(this.serviziApplicativiSelectItemsWidth);
    }

    public Integer getAzioniSelectItemsWidthAsInteger() {
        return this.checkWidthLimits(this.azioniSelectItemsWidth);
    }

    @Override
    public String getProtocollo() {
        if (this.search == null) {
            return super.getProtocollo();
        }
        return this.search.getProtocollo();
    }
}

