/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.mbean;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.openspcoop2.monitor.engine.constants.SondaStatus;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.status.ISondaPdd;
import org.openspcoop2.web.monitor.core.status.SondaPddManager;
import org.slf4j.Logger;

public class StatusBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String intervalloRefresh;
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private String tooltipIconaStato = "";
    private String iconaStato = "";
    private volatile boolean aggiornamentoAutomatico = false;
    private volatile boolean enable;
    private Date dataAggiornamento = null;
    private String intervalloRefreshPropValue;
    private static final String ICONA_STATO_OK = "/images/tema_link/status_green.png";
    private static final String ICONA_STATO_WARN = "/images/tema_link/status_yellow.png";
    private static final String ICONA_STATO_ERR = "/images/tema_link/status_red.png";
    private List<ISondaPdd> sondePdd = null;
    private transient boolean initialized = false;

    private synchronized void initialize() {
        if (!this.initialized) {
            try {
                PddMonitorProperties govwayMonitorProperties = PddMonitorProperties.getInstance(log);
                this.intervalloRefreshPropValue = govwayMonitorProperties.getIntervalloRefreshStatusPdD();
                this.intervalloRefresh = govwayMonitorProperties.getIntervalloRefreshStatusPdD();
                this.enable = govwayMonitorProperties.isStatusPdDEnabled();
                this.sondePdd = SondaPddManager.getInstance(log).getSondePdd();
                log.debug("Verranno monitorate [" + this.sondePdd.size() + "] Sonde.");
                log.debug("Creazione Status Bean Completata.");
                this.initialized = true;
                this.aggiornaStato();
            }
            catch (Exception e) {
                log.error("si e' verificato un errore durante la init: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public StatusBean() {
        this.initialize();
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public String getIntervalloRefresh() {
        if (this.dataAggiornamento == null) {
            this.dataAggiornamento = new Date();
            return this.intervalloRefresh;
        }
        int intervallo = Integer.parseInt(this.intervalloRefreshPropValue);
        Calendar c = Calendar.getInstance();
        c.setTime(this.dataAggiornamento);
        c.add(13, intervallo);
        Date now = new Date();
        if (c.getTime().after(now)) {
            Instant startInclusive = now.toInstant();
            Instant endExclusive = c.toInstant();
            Duration between = Duration.between(startInclusive, endExclusive);
            return "" + between.toSeconds();
        }
        this.dataAggiornamento = new Date();
        return this.intervalloRefresh;
    }

    public String getTooltipIconaStato() {
        return this.tooltipIconaStato;
    }

    public String getIconaStato() {
        return this.iconaStato;
    }

    public String aggiorna() {
        this.aggiornaStato();
        return null;
    }

    public String mostraStato() {
        return "statusPdD";
    }

    private void aggiornaStato() {
        this.initialize();
        log.debug("Aggiornamento stato in corso...");
        try {
            for (ISondaPdd sondaPdd : this.sondePdd) {
                sondaPdd.reset();
            }
            this.updateStatoPdd();
            int tot_ok = 0;
            int tot_err = 0;
            int tot_warn = 0;
            for (ISondaPdd pdd : this.sondePdd) {
                SondaStatus statoSonda = pdd.getStatoSondaPdd();
                log.debug("SondaPdd: [" + pdd.getName() + "], Stato: [" + statoSonda.toString() + "]");
                if (statoSonda.equals((Object)SondaStatus.OK)) {
                    ++tot_ok;
                }
                if (statoSonda.equals((Object)SondaStatus.ERROR)) {
                    ++tot_err;
                }
                if (!statoSonda.equals((Object)SondaStatus.WARNING)) continue;
                ++tot_warn;
            }
            if (tot_ok == this.sondePdd.size()) {
                this.iconaStato = ICONA_STATO_OK;
                this.tooltipIconaStato = "Non risultano anomalie";
            } else if (tot_err > 0) {
                this.iconaStato = ICONA_STATO_ERR;
                this.tooltipIconaStato = "Il sistema ha rilevato condizioni di errore";
            } else if (tot_warn > 0) {
                this.iconaStato = ICONA_STATO_WARN;
                this.tooltipIconaStato = "Il sistema ha rilevato condizioni di warning";
            }
            log.debug("Aggiornamento stato completato");
        }
        catch (Exception e) {
            log.error("Si e' verificato un errore durante l'update dello stato delle SondePdD: " + e.getMessage(), (Throwable)e);
            this.iconaStato = ICONA_STATO_ERR;
            this.tooltipIconaStato = "Stato della PdD non disponibile.";
        }
    }

    public boolean isAggiornamentoAutomatico() {
        return this.aggiornamentoAutomatico;
    }

    public void setAggiornamentoAutomatico(boolean aggiornamentoAutomatico) {
        this.aggiornamentoAutomatico = aggiornamentoAutomatico;
    }

    public String getLabelStato() {
        if (this.aggiornamentoAutomatico) {
            this.aggiornaStato();
        }
        this.aggiornamentoAutomatico = false;
        return "";
    }

    public List<ISondaPdd> getListaSondePdd() {
        if (this.sondePdd == null) {
            this.sondePdd = new ArrayList<ISondaPdd>();
        }
        return this.sondePdd;
    }

    public void setListaSondePdd(List<ISondaPdd> sondePdd) {
        this.sondePdd = sondePdd;
    }

    private void updateStatoPdd() {
        for (ISondaPdd sondaPdd : this.sondePdd) {
            try {
                sondaPdd.updateStato();
            }
            catch (Exception e) {
                log.error("Si e' verificato un errore durante l'update dello stato della sonda [" + sondaPdd.getName() + "]: " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

