/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.report;

import javax.faces.context.FacesContext;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.report.ILiveReport;
import org.slf4j.Logger;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.jsf.FacesContextUtils;

public class ReportFactory {
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private static ReportFactory instance = null;
    private ILiveReport transazioniReportManager = null;
    private ILiveReport statisticaReportManager = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ReportFactory getInstance() {
        if (instance != null) return instance;
        Class<ReportFactory> clazz = ReportFactory.class;
        synchronized (ReportFactory.class) {
            ReportFactory.init();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static synchronized void init() {
        if (instance == null) {
            instance = new ReportFactory();
        }
    }

    private ReportFactory() {
        try {
            log.debug("Init ReportFactory in corso...");
            log.debug("Init ReportFactory completato.");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public ILiveReport getTransazioniReportManager() {
        if (this.transazioniReportManager == null) {
            this.initTransazioniReportManager();
        }
        return this.transazioniReportManager;
    }

    private synchronized void initTransazioniReportManager() {
        try {
            FacesContext currentInstance;
            WebApplicationContext context;
            log.debug("Init Report Manager Transazioni in corso...");
            if (this.transazioniReportManager == null && (context = FacesContextUtils.getWebApplicationContext((FacesContext)(currentInstance = FacesContext.getCurrentInstance()))) != null) {
                this.transazioniReportManager = (ILiveReport)context.getBean("transazioniReportManager");
            }
            log.debug("Init Report Manager Transazioni completato.");
        }
        catch (Exception e) {
            log.debug("Errore durante la creazione del Report Manager Transazioni:" + e.getMessage(), (Throwable)e);
        }
    }

    public ILiveReport getStatisticaReportManager() {
        if (this.statisticaReportManager == null) {
            this.initStatisticaReportManager();
        }
        return this.statisticaReportManager;
    }

    private synchronized void initStatisticaReportManager() {
        try {
            FacesContext currentInstance;
            WebApplicationContext context;
            log.debug("Init Report Manager Statistiche in corso...");
            if (this.statisticaReportManager == null && (context = FacesContextUtils.getWebApplicationContext((FacesContext)(currentInstance = FacesContext.getCurrentInstance()))) != null) {
                this.statisticaReportManager = (ILiveReport)context.getBean("statisticaReportManager");
            }
            log.debug("Init Report Manager Statistiche completato.");
        }
        catch (Exception e) {
            log.debug("Errore durante la creazione del Report Manager Statistiche:" + e.getMessage(), (Throwable)e);
        }
    }
}

