/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.servlet;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.commons.search.dao.IServiceManager;
import org.openspcoop2.core.transazioni.utils.ProjectInfo;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.listener.ConsoleStartupListener;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.slf4j.Logger;

public class CheckServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private static final String LOG_PREFIX = "[GovWayMonitorCheck] ";
    private static final String DB_CONFIGURAZIONE = "Database Configurazione";
    private static final String DB_TRACCIAMENTO = "Database Tracciamento";
    private static final String DB_STATISTICHE = "Database Statistiche";
    private static final String SERVICE_MANAGER_NON_DISPONIBILE = "ServiceManager non disponibile";
    private static final String DB_NON_DISPONIBILE = " non disponibile: ";
    private static final String SEND_ERROR_FAILED = "SendError failed: ";

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (!ConsoleStartupListener.initialized) {
            this.serializeNotInitializedResponse(res);
            return;
        }
        StringBuilder sbError = new StringBuilder();
        boolean allDbOk = true;
        if (!this.checkDatabaseConfigurazione(sbError)) {
            allDbOk = false;
        }
        if (!this.checkDatabaseTracciamento(sbError)) {
            allDbOk = false;
        }
        if (!this.checkDatabaseStatistiche(sbError)) {
            allDbOk = false;
        }
        if (allDbOk) {
            this.serializeOkResponse(res);
        } else {
            this.serializeErrorResponse(res, sbError.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkDatabaseConfigurazione(StringBuilder sbError) {
        IServiceManager utilsServiceManager;
        block6: {
            utilsServiceManager = null;
            utilsServiceManager = (IServiceManager)DAOFactory.getInstance((Logger)log).getServiceManager((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance(), log);
            if (utilsServiceManager != null) break block6;
            this.appendError(sbError, DB_CONFIGURAZIONE, SERVICE_MANAGER_NON_DISPONIBILE);
            boolean bl = false;
            return bl;
        }
        try {
            PddMonitorProperties props = PddMonitorProperties.getInstance(log);
            String query = props.getCheckDbConfigurazioneQuery();
            if (query == null || query.trim().isEmpty()) {
                query = "SELECT id FROM configurazione";
            }
            ArrayList<Class<Long>> returnTypes = new ArrayList<Class<Long>>();
            returnTypes.add(Long.class);
            Object[] parameters = new Object[]{};
            utilsServiceManager.getResourceServiceSearch().nativeQuery(query, returnTypes, parameters);
            log.debug("[GovWayMonitorCheck] Database Configurazione: OK");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.appendError(sbError, DB_CONFIGURAZIONE, e.getMessage());
            log.error("[GovWayMonitorCheck] Database Configurazione non disponibile: " + e.getMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkDatabaseTracciamento(StringBuilder sbError) {
        org.openspcoop2.core.transazioni.dao.IServiceManager transazioniServiceManager;
        block6: {
            transazioniServiceManager = null;
            transazioniServiceManager = (org.openspcoop2.core.transazioni.dao.IServiceManager)DAOFactory.getInstance((Logger)log).getServiceManager((IProjectInfo)ProjectInfo.getInstance(), log);
            if (transazioniServiceManager != null) break block6;
            this.appendError(sbError, DB_TRACCIAMENTO, SERVICE_MANAGER_NON_DISPONIBILE);
            boolean bl = false;
            return bl;
        }
        try {
            PddMonitorProperties props = PddMonitorProperties.getInstance(log);
            String query = props.getCheckDbTracciamentoQuery();
            if (query == null || query.trim().isEmpty()) {
                query = "SELECT id FROM transazioni_esiti";
            }
            ArrayList<Class<Long>> returnTypes = new ArrayList<Class<Long>>();
            returnTypes.add(Long.class);
            Object[] parameters = new Object[]{};
            transazioniServiceManager.getTransazioneServiceSearch().nativeQuery(query, returnTypes, parameters);
            log.debug("[GovWayMonitorCheck] Database Tracciamento: OK");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.appendError(sbError, DB_TRACCIAMENTO, e.getMessage());
            log.error("[GovWayMonitorCheck] Database Tracciamento non disponibile: " + e.getMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkDatabaseStatistiche(StringBuilder sbError) {
        org.openspcoop2.core.statistiche.dao.IServiceManager statisticheServiceManager;
        block6: {
            statisticheServiceManager = null;
            statisticheServiceManager = (org.openspcoop2.core.statistiche.dao.IServiceManager)DAOFactory.getInstance((Logger)log).getServiceManager((IProjectInfo)org.openspcoop2.core.statistiche.utils.ProjectInfo.getInstance(), log);
            if (statisticheServiceManager != null) break block6;
            this.appendError(sbError, DB_STATISTICHE, SERVICE_MANAGER_NON_DISPONIBILE);
            boolean bl = false;
            return bl;
        }
        try {
            PddMonitorProperties props = PddMonitorProperties.getInstance(log);
            String query = props.getCheckDbStatisticheQuery();
            if (query == null || query.trim().isEmpty()) {
                query = "SELECT id FROM statistiche";
            }
            ArrayList<Class<Long>> returnTypes = new ArrayList<Class<Long>>();
            returnTypes.add(Long.class);
            Object[] parameters = new Object[]{};
            statisticheServiceManager.getStatisticaInfoServiceSearch().nativeQuery(query, returnTypes, parameters);
            log.debug("[GovWayMonitorCheck] Database Statistiche: OK");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.appendError(sbError, DB_STATISTICHE, e.getMessage());
            log.error("[GovWayMonitorCheck] Database Statistiche non disponibile: " + e.getMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
    }

    private void appendError(StringBuilder sb, String resourceName, String errorMsg) {
        if (sb.length() > 0) {
            sb.append("; ");
        }
        sb.append(resourceName).append(": ").append(errorMsg);
    }

    private void serializeNotInitializedResponse(HttpServletResponse res) {
        String msg = "GovWay Monitor non inizializzato";
        log.error("[GovWayMonitorCheck] {}", (Object)msg);
        res.setStatus(503);
        res.setContentType("text/plain");
        try {
            res.getOutputStream().write(msg.getBytes());
        }
        catch (Exception e) {
            log.error("[GovWayMonitorCheck] SendError failed: " + e.getMessage(), (Throwable)e);
        }
    }

    private void serializeOkResponse(HttpServletResponse res) {
        log.debug("[GovWayMonitorCheck] GovWay Monitor OK");
        res.setStatus(200);
    }

    private void serializeErrorResponse(HttpServletResponse res, String errorDetails) {
        String msg = "GovWay Monitor ERROR: " + errorDetails;
        log.error("[GovWayMonitorCheck] {}", (Object)msg);
        res.setStatus(500);
        res.setContentType("text/plain");
        try {
            res.getOutputStream().write(msg.getBytes());
        }
        catch (Exception e) {
            log.error("[GovWayMonitorCheck] SendError failed: " + e.getMessage(), (Throwable)e);
        }
    }
}

