/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.servlet;

import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.oauth2.BaseOAuth2CallbackServlet;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.slf4j.Logger;

public class OAuth2CallbackServlet
extends BaseOAuth2CallbackServlet {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();

    protected String getConsoleError(HttpServletRequest request) {
        String loginUtenteNonAutorizzatoRedirectUrl = null;
        try {
            loginUtenteNonAutorizzatoRedirectUrl = PddMonitorProperties.getInstance(log).getLoginUtenteNonAutorizzatoRedirectUrl();
        }
        catch (UtilsException e) {
            log.error("Errore durante la lettura delle properties: " + e.getMessage(), (Throwable)e);
        }
        return StringUtils.isNotEmpty((String)loginUtenteNonAutorizzatoRedirectUrl) ? loginUtenteNonAutorizzatoRedirectUrl : request.getContextPath() + "/public/error.jsf?principalShowForm=true";
    }

    protected String getConsoleHome(HttpServletRequest request) {
        return request.getContextPath() + "/oauth2/user";
    }

    protected Properties getLoginProperties() {
        try {
            return PddMonitorProperties.getInstance(log).getLoginProperties();
        }
        catch (UtilsException e) {
            log.error("Errore durante la lettura delle properties: " + e.getMessage(), (Throwable)e);
            return new Properties();
        }
    }

    protected Logger getLog() {
        return log;
    }
}

