/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.status;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.statistiche.dao.IServiceManager;
import org.openspcoop2.core.statistiche.dao.IStatisticaInfoServiceSearch;
import org.openspcoop2.core.statistiche.utils.ProjectInfo;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.monitor.engine.constants.SondaStatus;
import org.openspcoop2.monitor.engine.status.IStatus;
import org.openspcoop2.monitor.engine.status.StatusUtilities;
import org.openspcoop2.pdd.services.connector.CheckStatoPdDHealthCheckStats;
import org.openspcoop2.pdd.services.connector.CheckStatoPdDHealthCheckStatsUtils;
import org.openspcoop2.web.monitor.core.status.BaseSondaPdd;
import org.openspcoop2.web.monitor.core.status.ISondaPdd;
import org.openspcoop2.web.monitor.core.status.StatsStatus;
import org.slf4j.Logger;

public class SondaStatsStatus
extends BaseSondaPdd
implements ISondaPdd {
    private static final long serialVersionUID = 1L;

    public SondaStatsStatus(String identificativo, Logger log, Properties prop) throws Exception {
        super(identificativo, log, prop);
    }

    private boolean readBoolendSondaProperty(String nomeProprieta, boolean defaultV) {
        String p = this.propertiesSonda.getProperty(nomeProprieta);
        if (p != null) {
            return "true".equals(p.trim());
        }
        return defaultV;
    }

    private int readIntSondaProperty(String nomeProprieta, int defaultV) {
        String p = this.propertiesSonda.getProperty(nomeProprieta);
        if (p != null) {
            return Integer.valueOf(p);
        }
        return defaultV;
    }

    @Override
    protected void init() throws Exception {
        try {
            StatsStatus pddStat;
            this.log.debug("Init Sonda Stats Status in corso...");
            this.listaStatus = new ArrayList();
            boolean verificaStatisticaOraria = this.readBoolendSondaProperty("executeHourlyHealthCheckStats", true);
            boolean verificaStatisticaGiornaliera = this.readBoolendSondaProperty("executeDailyHealthCheckStats", true);
            boolean verificaStatisticaSettimanale = this.readBoolendSondaProperty("executeWeeklyHealthCheckStats", false);
            boolean verificaStatisticaMensile = this.readBoolendSondaProperty("executeMonthlyHealthCheckStats", false);
            if (verificaStatisticaOraria) {
                CheckStatoPdDHealthCheckStats hourlyCheck = new CheckStatoPdDHealthCheckStats();
                hourlyCheck.setVerificaStatisticaOraria(verificaStatisticaOraria);
                int verificaStatisticaOrariaSoglia = this.readIntSondaProperty("hourlyHealthCheckStatsThreshold", 1);
                hourlyCheck.setVerificaStatisticaOrariaSoglia(verificaStatisticaOrariaSoglia);
                String hourlyCheckName = this.propertiesSonda.getProperty("hourlyHealthCheckStatsName");
                if (hourlyCheckName == null || StringUtils.isEmpty((String)hourlyCheckName)) {
                    throw new CoreException("Property 'hourlyHealthCheckStatsName' undefined");
                }
                pddStat = new StatsStatus();
                pddStat.setNome(hourlyCheckName);
                pddStat.setCheck(hourlyCheck);
                this.listaStatus.add(pddStat);
            }
            if (verificaStatisticaGiornaliera) {
                CheckStatoPdDHealthCheckStats dailyCheck = new CheckStatoPdDHealthCheckStats();
                dailyCheck.setVerificaStatisticaGiornaliera(verificaStatisticaGiornaliera);
                int verificaStatisticaGiornalieraSoglia = this.readIntSondaProperty("dailyHealthCheckStatsThreshold", 1);
                dailyCheck.setVerificaStatisticaGiornalieraSoglia(verificaStatisticaGiornalieraSoglia);
                String dailyCheckName = this.propertiesSonda.getProperty("dailyHealthCheckStatsName");
                if (dailyCheckName == null || StringUtils.isEmpty((String)dailyCheckName)) {
                    throw new CoreException("Property 'dailyHealthCheckStatsName' undefined");
                }
                pddStat = new StatsStatus();
                pddStat.setNome(dailyCheckName);
                pddStat.setCheck(dailyCheck);
                this.listaStatus.add(pddStat);
            }
            if (verificaStatisticaSettimanale) {
                CheckStatoPdDHealthCheckStats weeklyCheck = new CheckStatoPdDHealthCheckStats();
                weeklyCheck.setVerificaStatisticaSettimanale(verificaStatisticaSettimanale);
                int verificaStatisticaSettimanaleSoglia = this.readIntSondaProperty("weeklyHealthCheckStatsThreshold", 1);
                weeklyCheck.setVerificaStatisticaSettimanaleSoglia(verificaStatisticaSettimanaleSoglia);
                String weeklyCheckName = this.propertiesSonda.getProperty("weeklyHealthCheckStatsName");
                if (weeklyCheckName == null || StringUtils.isEmpty((String)weeklyCheckName)) {
                    throw new CoreException("Property 'weeklyHealthCheckStatsName' undefined");
                }
                pddStat = new StatsStatus();
                pddStat.setNome(weeklyCheckName);
                pddStat.setCheck(weeklyCheck);
                this.listaStatus.add(pddStat);
            }
            if (verificaStatisticaMensile) {
                CheckStatoPdDHealthCheckStats monthlyCheck = new CheckStatoPdDHealthCheckStats();
                monthlyCheck.setVerificaStatisticaMensile(verificaStatisticaMensile);
                int verificaStatisticaMensileSoglia = this.readIntSondaProperty("monthlyHealthCheckStatsThreshold", 1);
                monthlyCheck.setVerificaStatisticaMensileSoglia(verificaStatisticaMensileSoglia);
                String monthlyCheckName = this.propertiesSonda.getProperty("monthlyHealthCheckStatsName");
                if (monthlyCheckName == null || StringUtils.isEmpty((String)monthlyCheckName)) {
                    throw new CoreException("Property 'monthlyHealthCheckStatsName' undefined");
                }
                pddStat = new StatsStatus();
                pddStat.setNome(monthlyCheckName);
                pddStat.setCheck(monthlyCheck);
                this.listaStatus.add(pddStat);
            }
            this.log.debug("Init Sonda Pdd Status completato.");
        }
        catch (Exception e) {
            this.logError("Si e' verificato un errore durante l'Init Sonda Pdd Status: " + e.getMessage(), e);
            throw e;
        }
    }

    @Override
    public List<IStatus> updateStato() throws Exception {
        for (IStatus status : this.listaStatus) {
            this.updateStato(status, this.log);
        }
        return this.listaStatus;
    }

    private void updateStato(IStatus status, Logger log) {
        try {
            CheckStatoPdDHealthCheckStats check = null;
            if (!(status instanceof StatsStatus)) {
                throw new CoreException("Tipo sonda '" + status.getClass().getName() + "' sconosciuto");
            }
            check = ((StatsStatus)status).getCheck();
            IServiceManager serviceManager = (IServiceManager)DAOFactory.getInstance((Logger)log).getServiceManager((IProjectInfo)ProjectInfo.getInstance(), log);
            IStatisticaInfoServiceSearch search = serviceManager.getStatisticaInfoServiceSearch();
            CheckStatoPdDHealthCheckStatsUtils.verificaInformazioniStatistiche((Logger)log, (IStatisticaInfoServiceSearch)search, (CheckStatoPdDHealthCheckStats)check);
            status.setStato(SondaStatus.OK);
            status.setDescrizione(null);
        }
        catch (Exception e) {
            status.setStato(SondaStatus.WARNING);
            status.setDescrizione(e.getMessage());
            log.error("Verifica '" + status.getNome() + "' fallita: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getMessaggioStatoSondaPdd() throws Exception {
        int totOk = StatusUtilities.getTotOk((List)this.listaStatus);
        if (totOk == 0) {
            return "Dati non aggiornati";
        }
        if (totOk < this.listaStatus.size()) {
            if (this.listaStatus.size() > 2) {
                String numero = this.listaStatus.size() - totOk + " su " + this.listaStatus.size();
                return "Dati parzialmente aggiornati (" + numero + ")";
            }
            return "Dati parzialmente aggiornati";
        }
        return "Dati aggiornati";
    }

    @Override
    public SondaStatus getStatoSondaPdd() throws Exception {
        return StatusUtilities.statesProcess((List)this.listaStatus);
    }
}

