/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdi.builder;

import it.gov.agenziaentrate.ivaservizi.docs.xsd.fatture.v1_0.utils.serializer.JaxbSerializer;
import it.gov.fatturapa.sdi.fatturapa.v1_1.FatturaElettronicaType;
import it.gov.fatturapa.sdi.fatturapa.v1_1.ObjectFactory;
import it.gov.fatturapa.sdi.messaggi.v1_0.AttestazioneTrasmissioneFatturaType;
import it.gov.fatturapa.sdi.messaggi.v1_0.NotificaDecorrenzaTerminiType;
import it.gov.fatturapa.sdi.messaggi.v1_0.NotificaEsitoType;
import it.gov.fatturapa.sdi.messaggi.v1_0.NotificaMancataConsegnaType;
import it.gov.fatturapa.sdi.messaggi.v1_0.NotificaScartoType;
import it.gov.fatturapa.sdi.messaggi.v1_0.RicevutaConsegnaType;
import it.gov.fatturapa.sdi.messaggi.v1_0.ScartoEsitoCommittenteType;
import it.gov.fatturapa.sdi.messaggi.v1_0.constants.TipiMessaggi;
import it.gov.fatturapa.sdi.ws.ricezione.v1_0.types.constants.EsitoNotificaType;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.exception.MessageException;
import org.openspcoop2.message.exception.MessageNotSupportedException;
import org.openspcoop2.message.soap.DumpSoapMessageUtils;
import org.openspcoop2.message.soap.SoapUtils;
import org.openspcoop2.message.soap.TunnelSoapUtils;
import org.openspcoop2.message.soap.mtom.MTOMUtilities;
import org.openspcoop2.message.utils.MessageUtilities;
import org.openspcoop2.pdd.core.CostantiPdD;
import org.openspcoop2.protocol.sdi.builder.SDIBustaBuilder;
import org.openspcoop2.protocol.sdi.config.SDIProperties;
import org.openspcoop2.protocol.sdi.constants.SDICostanti;
import org.openspcoop2.protocol.sdi.utils.SDIUtils;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.beans.BaseBean;
import org.openspcoop2.utils.dch.MailcapActivationReader;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.mime.MimeTypes;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SDISbustamento {
    private SDIBustaBuilder bustaBuilder = null;

    public SDISbustamento(SDIBustaBuilder bustaBuilder) {
        this.bustaBuilder = bustaBuilder;
    }

    public SOAPElement sbustamentoRisposta_ServizioSdIRiceviFile_AzioneRiceviFile(Busta busta, OpenSPCoop2Message msgParam) throws ProtocolException {
        try {
            OpenSPCoop2SoapMessage msg = msgParam.castAsSoap();
            SOAPElement element = null;
            SOAPBody soapBody = msg.getSOAPBody();
            element = SDIUtils.readHeader(msg);
            soapBody.removeContents();
            if (msg.countAttachments() > 0) {
                msg.removeAllAttachments();
            }
            msg.setContentType(MessageUtilities.getDefaultContentType((MessageType)msg.getMessageType()));
            return element;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public SOAPElement sbustamentoRichiesta_ServizioRicezioneFatture_AzioneRiceviFatture(Busta busta, OpenSPCoop2Message msgParam) throws ProtocolException {
        try {
            OpenSPCoop2SoapMessage msg = msgParam.castAsSoap();
            OpenSPCoop2MessageFactory messageFactory = msgParam.getFactory();
            SOAPElement element = null;
            Object ctxFatturaPA = msg.removeContextProperty(SDICostanti.SDI_MESSAGE_CONTEXT_FATTURA);
            String versioneFattura = busta.getProperty("FormatoFatturaPA");
            SOAPBody soapBody = msg.getSOAPBody();
            element = SDIUtils.readHeader(msg);
            byte[] xmlFattura = null;
            boolean p7m = false;
            if (ctxFatturaPA != null) {
                BaseBean fattura;
                if (SDICostanti.SDI_VERSIONE_FATTURA_PA_10.equals(versioneFattura)) {
                    fattura = (it.gov.fatturapa.sdi.fatturapa.v1_0.FatturaElettronicaType)ctxFatturaPA;
                    it.gov.fatturapa.sdi.fatturapa.v1_0.ObjectFactory of = new it.gov.fatturapa.sdi.fatturapa.v1_0.ObjectFactory();
                    it.gov.fatturapa.sdi.fatturapa.v1_0.utils.serializer.JaxbSerializer serializer = new it.gov.fatturapa.sdi.fatturapa.v1_0.utils.serializer.JaxbSerializer();
                    xmlFattura = serializer.toByteArray(of.createFatturaElettronica((it.gov.fatturapa.sdi.fatturapa.v1_0.FatturaElettronicaType)fattura));
                } else if (SDICostanti.SDI_VERSIONE_FATTURA_PA_11.equals(versioneFattura)) {
                    fattura = (FatturaElettronicaType)ctxFatturaPA;
                    ObjectFactory of = new ObjectFactory();
                    it.gov.fatturapa.sdi.fatturapa.v1_1.utils.serializer.JaxbSerializer serializer = new it.gov.fatturapa.sdi.fatturapa.v1_1.utils.serializer.JaxbSerializer();
                    xmlFattura = serializer.toByteArray(of.createFatturaElettronica((FatturaElettronicaType)fattura));
                } else if (SDICostanti.SDI_VERSIONE_FATTURA_SEMPLIFICATA_10.equals(versioneFattura)) {
                    fattura = (it.gov.agenziaentrate.ivaservizi.docs.xsd.fatture.v1_0.FatturaElettronicaType)ctxFatturaPA;
                    it.gov.agenziaentrate.ivaservizi.docs.xsd.fatture.v1_0.ObjectFactory of = new it.gov.agenziaentrate.ivaservizi.docs.xsd.fatture.v1_0.ObjectFactory();
                    JaxbSerializer serializer = new JaxbSerializer();
                    xmlFattura = serializer.toByteArray(of.createFatturaElettronicaSemplificata((it.gov.agenziaentrate.ivaservizi.docs.xsd.fatture.v1_0.FatturaElettronicaType)fattura));
                } else {
                    fattura = (it.gov.agenziaentrate.ivaservizi.docs.xsd.fatture.v1_2.FatturaElettronicaType)ctxFatturaPA;
                    it.gov.agenziaentrate.ivaservizi.docs.xsd.fatture.v1_2.ObjectFactory of = new it.gov.agenziaentrate.ivaservizi.docs.xsd.fatture.v1_2.ObjectFactory();
                    it.gov.agenziaentrate.ivaservizi.docs.xsd.fatture.v1_2.utils.serializer.JaxbSerializer serializer = new it.gov.agenziaentrate.ivaservizi.docs.xsd.fatture.v1_2.utils.serializer.JaxbSerializer();
                    xmlFattura = serializer.toByteArray(of.createFatturaElettronica((it.gov.agenziaentrate.ivaservizi.docs.xsd.fatture.v1_2.FatturaElettronicaType)fattura));
                }
            } else {
                SOAPElement elementBody = SoapUtils.getNotEmptyFirstChildSOAPElement((SOAPElement)soapBody);
                List childs = SoapUtils.getNotEmptyChildNodes((OpenSPCoop2MessageFactory)messageFactory, (Node)elementBody, (boolean)false);
                for (int i = 0; i < childs.size(); ++i) {
                    Node child = (Node)childs.get(i);
                    if (!"File".equals(child.getLocalName())) continue;
                    Element e = MTOMUtilities.getIfExistsXomReference((OpenSPCoop2MessageFactory)messageFactory, (Element)((Element)child));
                    if (e != null) {
                        AttachmentPart ap = this.getAttachmentPart(msg, e);
                        if (ap == null) continue;
                        xmlFattura = Utilities.getAsByteArray((InputStream)ap.getDataHandler().getInputStream());
                        continue;
                    }
                    xmlFattura = Base64Utilities.decode((String)child.getTextContent());
                }
                String formato = busta.getProperty("FormatoArchivioInvioFattura");
                if (formato != null && formato.equals("P7M")) {
                    p7m = true;
                }
            }
            soapBody.removeContents();
            if (msg.countAttachments() > 0) {
                msg.removeAllAttachments();
            }
            msg.setContentType(MessageUtilities.getDefaultContentType((MessageType)msg.getMessageType()));
            if (p7m) {
                MimeTypes mimeTypes = MimeTypes.getInstance();
                TunnelSoapUtils.imbustamentoMessaggioConAttachment((OpenSPCoop2Message)msg, (byte[])xmlFattura, (String)"application/openspcoop2", (boolean)MailcapActivationReader.existsDataContentHandler((String)"application/openspcoop2"), (String)mimeTypes.getMimeType("P7M"), (String)"www.openspcoop2.org/protocols/sdi");
                DumpSoapMessageUtils.dumpMessage((OpenSPCoop2SoapMessage)msg, (boolean)true);
            } else {
                TunnelSoapUtils.imbustamentoMessaggioConAttachment((OpenSPCoop2Message)msg, (byte[])xmlFattura, (String)"application/openspcoop2", (boolean)MailcapActivationReader.existsDataContentHandler((String)"application/openspcoop2"), (String)"text/xml", (String)"www.openspcoop2.org/protocols/sdi");
                DumpSoapMessageUtils.dumpMessage((OpenSPCoop2SoapMessage)msg, (boolean)true);
            }
            return element;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public SOAPElement sbustamentoRisposta_ServizioSdIRiceviNotifica_AzioneNotificaEsito(Busta busta, OpenSPCoop2Message msgParam, Context context) throws ProtocolException {
        try {
            OpenSPCoop2SoapMessage msg = msgParam.castAsSoap();
            OpenSPCoop2MessageFactory messageFactory = msgParam.getFactory();
            SOAPElement element = null;
            Object ctxNotificaScartoEsitoCommittente = msg.removeContextProperty(SDICostanti.SDI_MESSAGE_CONTEXT_MESSAGGIO_SERVIZIO_SDI);
            String nomeFileRichiesta = null;
            String identificativoSdIRichiesta = null;
            if (context != null) {
                Object idSdiObj;
                Object nomeFileObj;
                if (context.containsKey(CostantiPdD.BUSTA_RICHIESTA_SDI_NOME_FILE) && (nomeFileObj = context.getObject(CostantiPdD.BUSTA_RICHIESTA_SDI_NOME_FILE)) instanceof String) {
                    nomeFileRichiesta = (String)nomeFileObj;
                }
                if (context.containsKey(CostantiPdD.BUSTA_RICHIESTA_SDI_IDENTIFICATIVO_SDI) && (idSdiObj = context.getObject(CostantiPdD.BUSTA_RICHIESTA_SDI_IDENTIFICATIVO_SDI)) instanceof String) {
                    identificativoSdIRichiesta = (String)idSdiObj;
                }
            }
            SOAPBody soapBody = msg.getSOAPBody();
            element = SDIUtils.readHeader(msg);
            byte[] xmlNotificaScartoEsitoCommittente = null;
            if (ctxNotificaScartoEsitoCommittente != null) {
                ScartoEsitoCommittenteType scarto = (ScartoEsitoCommittenteType)ctxNotificaScartoEsitoCommittente;
                it.gov.fatturapa.sdi.messaggi.v1_0.ObjectFactory of = new it.gov.fatturapa.sdi.messaggi.v1_0.ObjectFactory();
                it.gov.fatturapa.sdi.messaggi.v1_0.utils.serializer.JaxbSerializer serializer = new it.gov.fatturapa.sdi.messaggi.v1_0.utils.serializer.JaxbSerializer();
                xmlNotificaScartoEsitoCommittente = serializer.toByteArray(of.createScartoEsitoCommittente(scarto));
            } else {
                SOAPElement elementBody = SoapUtils.getNotEmptyFirstChildSOAPElement((SOAPElement)soapBody);
                List childs = SoapUtils.getNotEmptyChildNodes((OpenSPCoop2MessageFactory)messageFactory, (Node)elementBody, (boolean)false);
                for (int i = 0; i < childs.size(); ++i) {
                    List elementScartoChilds;
                    Node child = (Node)childs.get(i);
                    if (!"ScartoEsito".equals(child.getLocalName()) || (elementScartoChilds = SoapUtils.getNotEmptyChildNodes((OpenSPCoop2MessageFactory)messageFactory, (Node)child, (boolean)false)) == null) continue;
                    for (int j = 0; j < elementScartoChilds.size(); ++j) {
                        Node scartoChild = (Node)elementScartoChilds.get(j);
                        if (!"File".equals(scartoChild.getLocalName())) continue;
                        Element e = MTOMUtilities.getIfExistsXomReference((OpenSPCoop2MessageFactory)messageFactory, (Element)((Element)scartoChild));
                        if (e != null) {
                            AttachmentPart ap = this.getAttachmentPart(msg, e);
                            if (ap == null) continue;
                            xmlNotificaScartoEsitoCommittente = Utilities.getAsByteArray((InputStream)ap.getDataHandler().getInputStream());
                            continue;
                        }
                        xmlNotificaScartoEsitoCommittente = Base64Utilities.decode((String)scartoChild.getTextContent());
                    }
                }
            }
            soapBody.removeContents();
            if (msg.countAttachments() > 0) {
                msg.removeAllAttachments();
            }
            msg.setContentType(MessageUtilities.getDefaultContentType((MessageType)msg.getMessageType()));
            if (xmlNotificaScartoEsitoCommittente != null) {
                TunnelSoapUtils.imbustamentoMessaggioConAttachment((OpenSPCoop2Message)msg, (byte[])xmlNotificaScartoEsitoCommittente, (String)"application/openspcoop2", (boolean)MailcapActivationReader.existsDataContentHandler((String)"application/openspcoop2"), (String)"text/xml", (String)"www.openspcoop2.org/protocols/sdi");
                DumpSoapMessageUtils.dumpMessage((OpenSPCoop2SoapMessage)msg, (boolean)true);
            }
            String esitoNotifica = busta.getProperty("EsitoNotifica");
            if (EsitoNotificaType.ES01.name().equals(esitoNotifica)) {
                msg.setForcedResponseCode("202");
            } else if (EsitoNotificaType.ES00.name().equals(esitoNotifica)) {
                msg.setForcedResponseCode("200");
            }
            if (nomeFileRichiesta != null) {
                busta.addProperty("NomeFile", nomeFileRichiesta);
            }
            if (identificativoSdIRichiesta != null) {
                busta.addProperty("IdentificativoSdI", identificativoSdIRichiesta);
            }
            return element;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SOAPElement sbustamentoRichiesta_ServizioTrasmissioneFatture_Notifiche(TipiMessaggi tipoMessaggio, Busta busta, OpenSPCoop2Message msgParam) throws ProtocolException {
        try {
            OpenSPCoop2SoapMessage msg = msgParam.castAsSoap();
            OpenSPCoop2MessageFactory messageFactory = msgParam.getFactory();
            SOAPElement element = null;
            Object ctxMessaggio = msg.removeContextProperty(SDICostanti.SDI_MESSAGE_CONTEXT_MESSAGGIO_SERVIZIO_SDI);
            SOAPBody soapBody = msg.getSOAPBody();
            element = SDIUtils.readHeader(msg);
            byte[] xmlNotifica = null;
            byte[] zip = null;
            if (ctxMessaggio != null) {
                it.gov.fatturapa.sdi.messaggi.v1_0.ObjectFactory of = new it.gov.fatturapa.sdi.messaggi.v1_0.ObjectFactory();
                it.gov.fatturapa.sdi.messaggi.v1_0.utils.serializer.JaxbSerializer serializer = new it.gov.fatturapa.sdi.messaggi.v1_0.utils.serializer.JaxbSerializer();
                switch (tipoMessaggio) {
                    case RC: {
                        RicevutaConsegnaType rc = (RicevutaConsegnaType)ctxMessaggio;
                        xmlNotifica = serializer.toByteArray(of.createRicevutaConsegna(rc));
                        break;
                    }
                    case MC: {
                        NotificaMancataConsegnaType mc = (NotificaMancataConsegnaType)ctxMessaggio;
                        xmlNotifica = serializer.toByteArray(of.createNotificaMancataConsegna(mc));
                        break;
                    }
                    case NS: {
                        NotificaScartoType ns = (NotificaScartoType)ctxMessaggio;
                        xmlNotifica = serializer.toByteArray(of.createNotificaScarto(ns));
                        break;
                    }
                    case NE: {
                        NotificaEsitoType ne = (NotificaEsitoType)ctxMessaggio;
                        xmlNotifica = serializer.toByteArray(of.createNotificaEsito(ne));
                        break;
                    }
                    case DT: {
                        NotificaDecorrenzaTerminiType dt = (NotificaDecorrenzaTerminiType)ctxMessaggio;
                        xmlNotifica = serializer.toByteArray(of.createNotificaDecorrenzaTermini(dt));
                        break;
                    }
                    case AT: {
                        AttestazioneTrasmissioneFatturaType at = (AttestazioneTrasmissioneFatturaType)ctxMessaggio;
                        xmlNotifica = serializer.toByteArray(of.createAttestazioneTrasmissioneFattura(at));
                        break;
                    }
                }
            } else if (TipiMessaggi.AT.equals(tipoMessaggio) && SDIProperties.getInstance(this.bustaBuilder.getLog()).isEnableAccessoMessaggi().booleanValue()) {
                Object oZip = msg.removeContextProperty(SDICostanti.SDI_MESSAGE_CONTEXT_AT_ARCHIVIO_ZIP);
                if (oZip != null) {
                    zip = (byte[])oZip;
                } else {
                    Object oXml = msg.removeContextProperty(SDICostanti.SDI_MESSAGE_CONTEXT_AT_ARCHIVIO_XML);
                    if (oXml == null) throw new Exception("Contenuto della notifica di Attestazione Trasmissione per Impossibilit\u00e0 di Recapito");
                    xmlNotifica = (byte[])oXml;
                }
            } else {
                SOAPElement elementBody = SoapUtils.getNotEmptyFirstChildSOAPElement((SOAPElement)soapBody);
                List childs = SoapUtils.getNotEmptyChildNodes((OpenSPCoop2MessageFactory)messageFactory, (Node)elementBody, (boolean)false);
                for (int i = 0; i < childs.size(); ++i) {
                    Node child = (Node)childs.get(i);
                    if (!"File".equals(child.getLocalName())) continue;
                    Element e = MTOMUtilities.getIfExistsXomReference((OpenSPCoop2MessageFactory)messageFactory, (Element)((Element)child));
                    if (e != null) {
                        AttachmentPart ap = this.getAttachmentPart(msg, e);
                        if (ap == null) continue;
                        xmlNotifica = Utilities.getAsByteArray((InputStream)ap.getDataHandler().getInputStream());
                        continue;
                    }
                    xmlNotifica = Base64Utilities.decode((String)child.getTextContent());
                }
                if (TipiMessaggi.AT.equals(tipoMessaggio)) {
                    zip = xmlNotifica;
                }
            }
            soapBody.removeContents();
            if (msg.countAttachments() > 0) {
                msg.removeAllAttachments();
            }
            msg.setContentType(MessageUtilities.getDefaultContentType((MessageType)msg.getMessageType()));
            if (zip != null) {
                TunnelSoapUtils.imbustamentoMessaggioConAttachment((OpenSPCoop2Message)msg, (byte[])zip, (String)"application/openspcoop2", (boolean)MailcapActivationReader.existsDataContentHandler((String)"application/openspcoop2"), (String)"application/zip", (String)"www.openspcoop2.org/protocols/sdi");
                DumpSoapMessageUtils.dumpMessage((OpenSPCoop2SoapMessage)msg, (boolean)true);
                return element;
            } else {
                TunnelSoapUtils.imbustamentoMessaggioConAttachment((OpenSPCoop2Message)msg, (byte[])xmlNotifica, (String)"application/openspcoop2", (boolean)MailcapActivationReader.existsDataContentHandler((String)"application/openspcoop2"), (String)"text/xml", (String)"www.openspcoop2.org/protocols/sdi");
                DumpSoapMessageUtils.dumpMessage((OpenSPCoop2SoapMessage)msg, (boolean)true);
            }
            return element;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    private AttachmentPart getAttachmentPart(OpenSPCoop2SoapMessage msg, Element e) throws MessageException, MessageNotSupportedException {
        String contentId = MTOMUtilities.getCidXomReference((Element)e);
        MimeHeaders mhs = new MimeHeaders();
        mhs.addHeader("Content-ID", contentId);
        Iterator itAttachments = msg.getAttachments(mhs);
        if (itAttachments == null || !itAttachments.hasNext()) {
            throw new MessageException("Found XOM Reference with attribute [href]=[" + contentId + "] but the message hasn't attachments");
        }
        AttachmentPart ap = null;
        while (itAttachments.hasNext()) {
            if (ap != null) {
                throw new MessageException("Found XOM Reference with attribute [href]=[" + contentId + "] but exists more than one attachment with same id");
            }
            ap = (AttachmentPart)itAttachments.next();
        }
        return ap;
    }
}

