/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdi.validator;

import it.gov.agenziaentrate.ivaservizi.docs.xsd.fattura.messaggi.v1_0.utils.XSDValidatorWithSignature;
import it.gov.fatturapa.sdi.fatturapa.v1_1.utils.XMLUtils;
import it.gov.fatturapa.sdi.messaggi.v1_0.NotificaDecorrenzaTerminiType;
import it.gov.fatturapa.sdi.messaggi.v1_0.constants.TipiMessaggi;
import it.gov.fatturapa.sdi.messaggi.v1_0.utils.serializer.JaxbDeserializer;
import it.gov.fatturapa.sdi.ws.ricezione.v1_0.types.utils.ProjectInfo;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPElement;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.soap.SoapUtils;
import org.openspcoop2.message.soap.mtom.MTOMUtilities;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.protocol.sdi.config.SDIProperties;
import org.openspcoop2.protocol.sdi.constants.SDICostanti;
import org.openspcoop2.protocol.sdi.constants.SDICostantiServizioRicezioneFatture;
import org.openspcoop2.protocol.sdi.utils.P7MInfo;
import org.openspcoop2.protocol.sdi.utils.SDICompatibilitaNamespaceErrati;
import org.openspcoop2.protocol.sdi.utils.SDIFatturaUtils;
import org.openspcoop2.protocol.sdi.validator.SDIValidatoreNomeFile;
import org.openspcoop2.protocol.sdi.validator.SDIValidazioneSemantica;
import org.openspcoop2.protocol.sdi.validator.SDIValidazioneSintattica;
import org.openspcoop2.protocol.sdi.validator.SDIValidazioneUtils;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Eccezione;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.protocol.sdk.validator.ProprietaValidazione;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.beans.BaseBean;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.xml.AbstractValidatoreXSD;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SDIValidatoreServizioRicezioneFatture {
    private SDIValidazioneSintattica sdiValidazioneSintattica;
    private SDIValidazioneSemantica sdiValidazioneSemantica;
    private ProprietaValidazione proprietaValidazioneSemantica;
    private OpenSPCoop2Message msg;
    private OpenSPCoop2MessageFactory messageFactory;
    private boolean isRichiesta;
    private SOAPElement sdiMessage;
    private String namespace;
    private Busta busta;

    public SDIValidatoreServizioRicezioneFatture(SDIValidazioneSintattica sdiValidazioneSintattica, OpenSPCoop2Message msg, boolean isRichiesta, SOAPElement sdiMessage, Busta busta) {
        this.sdiValidazioneSintattica = sdiValidazioneSintattica;
        this.msg = msg;
        this.messageFactory = this.msg != null ? this.msg.getFactory() : OpenSPCoop2MessageFactory.getDefaultMessageFactory();
        this.isRichiesta = isRichiesta;
        this.sdiMessage = sdiMessage;
        this.namespace = ProjectInfo.getInstance().getProjectNamespace();
        this.busta = busta;
    }

    public SDIValidatoreServizioRicezioneFatture(SDIValidazioneSemantica sdiValidazioneSemantica, ProprietaValidazione proprietaValidazione, OpenSPCoop2Message msg, boolean isRichiesta, SOAPElement sdiMessage, Busta busta) {
        this.sdiValidazioneSemantica = sdiValidazioneSemantica;
        this.proprietaValidazioneSemantica = proprietaValidazione;
        this.msg = msg;
        this.messageFactory = this.msg != null ? this.msg.getFactory() : OpenSPCoop2MessageFactory.getDefaultMessageFactory();
        this.isRichiesta = isRichiesta;
        this.sdiMessage = sdiMessage;
        this.namespace = SDICostantiServizioRicezioneFatture.RICEZIONE_SERVIZIO_RICEZIONE_FATTURE_NAMESPACE;
        this.busta = busta;
    }

    private boolean checkServiceNamespace() throws Exception {
        if (!this.namespace.equals(this.sdiMessage.getNamespaceURI())) {
            this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Namespace [" + this.sdiMessage.getNamespaceURI() + "] differente da quello atteso [" + this.namespace + "]"));
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validaRiceviFatture() throws Exception {
        if (!this.checkServiceNamespace()) {
            return;
        }
        if (this.sdiValidazioneSintattica != null) {
            if (!this.isRichiesta) throw new Exception("NotImplemented");
            this._validazioneSintattica_RiceviFatture_richiesta();
            return;
        } else {
            if (!this.isRichiesta) throw new Exception("NotImplemented");
            this._validazioneSemantica_RiceviFatture_richiesta();
        }
    }

    private void _validazioneSintattica_RiceviFatture_richiesta() throws Exception {
        String nomeFileMetadati;
        String nomeFile;
        String identificativoSdI;
        block33: {
            block32: {
                if (!"fileSdIConMetadati".equals(this.sdiMessage.getLocalName())) {
                    this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "LocalName [" + this.sdiMessage.getLocalName() + "] differente da quello atteso [fileSdIConMetadati]"));
                    return;
                }
                List elementChilds = SoapUtils.getNotEmptyChildSOAPElement((SOAPElement)this.sdiMessage);
                if (elementChilds == null || elementChilds.size() <= 0) {
                    this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "RootElement [{" + this.namespace + "}" + this.sdiMessage.getLocalName() + "] non contiene elementi"));
                    return;
                }
                identificativoSdI = null;
                nomeFile = null;
                Boolean fileRead = null;
                nomeFileMetadati = null;
                Boolean metadatiRead = null;
                for (int i = 0; i < elementChilds.size(); ++i) {
                    SOAPElement child = (SOAPElement)elementChilds.get(i);
                    if ("IdentificativoSdI".equals(child.getLocalName())) {
                        if (identificativoSdI != null) {
                            this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.IDENTIFICATIVO_MESSAGGIO_PRESENTE_PIU_VOLTE));
                            return;
                        }
                        if (child.getTextContent() == null) {
                            this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.IDENTIFICATIVO_MESSAGGIO_NON_VALORIZZATO));
                            return;
                        }
                        identificativoSdI = child.getTextContent();
                    } else if ("NomeFile".equals(child.getLocalName())) {
                        if (nomeFile != null) {
                            this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [NomeFile] presente piu' volte"));
                            return;
                        }
                        if (child.getTextContent() == null) {
                            this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [NomeFile] non valorizzato"));
                            return;
                        }
                        nomeFile = child.getTextContent();
                    } else if ("File".equals(child.getLocalName())) {
                        if (fileRead != null) {
                            this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] presente piu' volte"));
                            return;
                        }
                        fileRead = true;
                    } else if ("NomeFileMetadati".equals(child.getLocalName())) {
                        if (nomeFileMetadati != null) {
                            this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [NomeFileMetadati] presente piu' volte"));
                            return;
                        }
                        if (child.getTextContent() == null) {
                            this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [NomeFileMetadati] non valorizzato"));
                            return;
                        }
                        nomeFileMetadati = child.getTextContent();
                    } else if ("Metadati".equals(child.getLocalName())) {
                        if (metadatiRead != null) {
                            this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [Metadati] presente piu' volte"));
                            return;
                        }
                        metadatiRead = true;
                    } else {
                        this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Element [" + child.getLocalName() + "] sconosciuto"));
                        return;
                    }
                    if (child.getNamespaceURI() == null) continue;
                    this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Element [" + child.getLocalName() + "] appartiene al namespace (" + child.getNamespaceURI() + "). Era atteso un elemento senza namespace"));
                    return;
                }
                if (identificativoSdI == null) {
                    this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.IDENTIFICATIVO_MESSAGGIO_NON_PRESENTE));
                    return;
                }
                if (nomeFile == null) {
                    this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [NomeFile] non presente"));
                    return;
                }
                if (fileRead == null) {
                    this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] non presente"));
                    return;
                }
                if (nomeFileMetadati == null) {
                    this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [NomeFileMetadati] non presente"));
                    return;
                }
                if (metadatiRead == null) {
                    this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [Metadati] non presente"));
                    return;
                }
                try {
                    SDIValidatoreNomeFile.validaNomeFileFattura(nomeFile, true);
                    if (nomeFile.toLowerCase().endsWith("xml.p7m")) {
                        this.busta.addProperty("FormatoArchivioInvioFattura", "P7M");
                    } else {
                        this.busta.addProperty("FormatoArchivioInvioFattura", "XML");
                    }
                }
                catch (Exception e) {
                    this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [NomeFile] non valido: " + e.getMessage(), e, this.sdiValidazioneSintattica.sdiProperties.isEnableValidazioneNomeFile() == false));
                    if (!this.sdiValidazioneSintattica.sdiProperties.isEnableValidazioneNomeFile().booleanValue()) break block32;
                    return;
                }
            }
            try {
                SDIValidatoreNomeFile.validaNomeFileMessaggi(nomeFile, nomeFileMetadati, TipiMessaggi.MT);
            }
            catch (Exception e) {
                this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [NomeFileMetadati] non valido: " + e.getMessage(), e, this.sdiValidazioneSintattica.sdiProperties.isEnableValidazioneNomeFile() == false));
                if (!this.sdiValidazioneSintattica.sdiProperties.isEnableValidazioneNomeFile().booleanValue()) break block33;
                return;
            }
        }
        this.busta.addProperty("IdentificativoSdI", identificativoSdI);
        this.busta.addProperty("NomeFile", nomeFile);
        this.busta.addProperty("NomeFileMetadati", nomeFileMetadati);
    }

    private void _validazioneSemantica_RiceviFatture_richiesta() throws Exception {
        if (this.busta.getProperty("MessageId") == null) {
            P7MInfo infoP7M2;
            byte[] fattura;
            block48: {
                byte[] metadati;
                block47: {
                    metadati = null;
                    try {
                        QName qnameMetadati = new QName("Metadati");
                        Iterator nodeMetadatiIt = this.sdiMessage.getChildElements(qnameMetadati);
                        SOAPElement nodeMetadati = (SOAPElement)nodeMetadatiIt.next();
                        Element xomReference = MTOMUtilities.getIfExistsXomReference((OpenSPCoop2MessageFactory)this.messageFactory, (Element)nodeMetadati);
                        if (xomReference != null) {
                            try {
                                String cid = MTOMUtilities.getCidXomReference((Element)xomReference);
                                if (cid == null) {
                                    throw new Exception("XomReference without cid reference");
                                }
                                AttachmentPart ap = MTOMUtilities.getAttachmentPart((OpenSPCoop2Message)this.msg, (String)cid);
                                metadati = Utilities.getAsByteArray((InputStream)ap.getDataHandler().getInputStream());
                                if (metadati == null || metadati.length <= 0) {
                                    throw new Exception("Contenuto non presente");
                                }
                                break block47;
                            }
                            catch (Exception e) {
                                this.sdiValidazioneSemantica.erroriValidazione.add(this.sdiValidazioneSemantica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] non valorizzato correttamente: " + e.getMessage(), e));
                                return;
                            }
                        }
                        if (nodeMetadati.getTextContent() == null) {
                            this.sdiValidazioneSemantica.erroriValidazione.add(this.sdiValidazioneSemantica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [Metadati] non valorizzato"));
                            return;
                        }
                        String base64Metadati = nodeMetadati.getTextContent();
                        if (base64Metadati == null || "".equals(base64Metadati)) {
                            throw new Exception("Codifica Base64 non presente");
                        }
                        try {
                            metadati = Base64Utilities.decode((String)base64Metadati);
                        }
                        catch (Exception e) {
                            this.sdiValidazioneSemantica.erroriValidazione.add(this.sdiValidazioneSemantica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [Metadati] decodifica base64 non riuscita: " + e.getMessage(), e));
                            return;
                        }
                    }
                    catch (Exception e) {
                        this.sdiValidazioneSemantica.erroriValidazione.add(this.sdiValidazioneSemantica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [Metadati] non accessibile: " + e.getMessage(), e));
                        return;
                    }
                }
                boolean validazioneMetadatiOk = this._validazioneMetadati(metadati, this.sdiValidazioneSemantica.sdiProperties, this.sdiValidazioneSemantica.erroriValidazione, this.sdiValidazioneSemantica.validazioneUtils, this.sdiValidazioneSemantica.getProtocolFactory());
                if (!validazioneMetadatiOk) {
                    return;
                }
                if (metadati != null && this.sdiValidazioneSemantica.sdiProperties.isEnable_fatturazionePassiva_consegnaFileMetadati().booleanValue()) {
                    this.msg.forceTransportHeader("GovWay-SDI-FileMetadati", Base64Utilities.encodeAsString((byte[])metadati));
                }
                fattura = null;
                try {
                    QName qnameFattura = new QName("File");
                    Iterator nodeFatturaIt = this.sdiMessage.getChildElements(qnameFattura);
                    SOAPElement nodeFattura = (SOAPElement)nodeFatturaIt.next();
                    Element xomReference = MTOMUtilities.getIfExistsXomReference((OpenSPCoop2MessageFactory)this.messageFactory, (Element)nodeFattura);
                    if (xomReference != null) {
                        try {
                            String cid = MTOMUtilities.getCidXomReference((Element)xomReference);
                            if (cid == null) {
                                throw new Exception("XomReference without cid reference");
                            }
                            AttachmentPart ap = MTOMUtilities.getAttachmentPart((OpenSPCoop2Message)this.msg, (String)cid);
                            fattura = Utilities.getAsByteArray((InputStream)ap.getDataHandler().getInputStream());
                            if (fattura == null || fattura.length <= 0) {
                                throw new Exception("Contenuto non presente");
                            }
                            break block48;
                        }
                        catch (Exception e) {
                            this.sdiValidazioneSemantica.erroriValidazione.add(this.sdiValidazioneSemantica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] non valorizzato correttamente: " + e.getMessage(), e));
                            return;
                        }
                    }
                    if (nodeFattura.getTextContent() == null) {
                        this.sdiValidazioneSemantica.erroriValidazione.add(this.sdiValidazioneSemantica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] non valorizzato"));
                        return;
                    }
                    String base64Fattura = nodeFattura.getTextContent();
                    if (base64Fattura == null || "".equals(base64Fattura)) {
                        throw new Exception("Codifica Base64 non presente");
                    }
                    try {
                        fattura = Base64Utilities.decode((String)base64Fattura);
                    }
                    catch (Exception e) {
                        this.sdiValidazioneSemantica.erroriValidazione.add(this.sdiValidazioneSemantica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] decodifica base64 non riuscita: " + e.getMessage(), e));
                        return;
                    }
                }
                catch (Exception e) {
                    this.sdiValidazioneSemantica.erroriValidazione.add(this.sdiValidazioneSemantica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] non accessibile: " + e.getMessage(), e));
                    return;
                }
            }
            String formato = this.busta.getProperty("FormatoArchivioInvioFattura");
            byte[] tmpFatturaP7M = null;
            if (formato == null) {
                try {
                    if (it.gov.fatturapa.sdi.fatturapa.v1_0.utils.XMLUtils.isFattura(fattura)) {
                        this.busta.addProperty("FormatoArchivioInvioFattura", "XML");
                        formato = "XML";
                    }
                }
                catch (Throwable nodeFattura) {
                    // empty catch block
                }
                if (formato == null) {
                    try {
                        if (XMLUtils.isFattura(fattura)) {
                            this.busta.addProperty("FormatoArchivioInvioFattura", "XML");
                            formato = "XML";
                        }
                    }
                    catch (Throwable nodeFattura) {
                        // empty catch block
                    }
                }
                if (formato == null) {
                    try {
                        if (it.gov.agenziaentrate.ivaservizi.docs.xsd.fatture.v1_2.utils.XMLUtils.isFattura(fattura)) {
                            this.busta.addProperty("FormatoArchivioInvioFattura", "XML");
                            formato = "XML";
                        }
                    }
                    catch (Throwable nodeFattura) {
                        // empty catch block
                    }
                }
                if (formato == null) {
                    try {
                        infoP7M2 = new P7MInfo(fattura, this.sdiValidazioneSemantica.getProtocolFactory().getLogger());
                        tmpFatturaP7M = infoP7M2.getXmlDecoded();
                        if (tmpFatturaP7M != null) {
                            this.busta.addProperty("FormatoArchivioInvioFattura", "P7M");
                            this.busta.addProperty("FormatoArchivioBase64", "" + infoP7M2.isBase64Encoded());
                            formato = "P7M";
                        }
                    }
                    catch (Throwable infoP7M2) {
                        // empty catch block
                    }
                }
                if (formato == null) {
                    this.sdiValidazioneSemantica.erroriValidazione.add(this.sdiValidazioneSemantica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] decodifica non riuscita: formato non conosciuto"));
                    return;
                }
            }
            if (formato.equals("P7M") && (this.sdiValidazioneSemantica.sdiProperties.isEnableAccessoFattura().booleanValue() || this.sdiValidazioneSemantica.sdiProperties.isEnableValidazioneXsdFattura().booleanValue())) {
                if (tmpFatturaP7M == null) {
                    try {
                        infoP7M2 = new P7MInfo(fattura, this.sdiValidazioneSemantica.getProtocolFactory().getLogger());
                        fattura = infoP7M2.getXmlDecoded();
                        this.busta.addProperty("FormatoArchivioBase64", "" + infoP7M2.isBase64Encoded());
                    }
                    catch (Throwable e) {
                        this.sdiValidazioneSemantica.erroriValidazione.add(this.sdiValidazioneSemantica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] decodifica p7m non riuscita: " + e.getMessage(), e));
                        return;
                    }
                } else {
                    fattura = tmpFatturaP7M;
                }
            }
            SDIFatturaUtils.validazioneFattura(fattura, this.sdiValidazioneSemantica.sdiProperties, this.sdiValidazioneSemantica.erroriValidazione, this.sdiValidazioneSemantica.validazioneUtils, this.sdiValidazioneSemantica.getProtocolFactory(), this.busta, this.msg, true, true, false);
            this.busta.addProperty("PosizioneFatturaPA", "1");
        }
    }

    private boolean _validazioneMetadati(byte[] metadati, SDIProperties sdiProperties, List<Eccezione> eccezioniValidazione, SDIValidazioneUtils validazioneUtils, IProtocolFactory<?> protocolFactory) throws Exception {
        BaseBean metadatiObject;
        boolean forceEccezioneLivelloInfo = false;
        if (!sdiProperties.isEnableAccessoMetadati().booleanValue()) {
            return true;
        }
        if (sdiProperties.isEnableAccessoMetadatiWarningMode().booleanValue()) {
            forceEccezioneLivelloInfo = true;
        }
        boolean fatturaB2B = false;
        if (it.gov.agenziaentrate.ivaservizi.docs.xsd.fattura.messaggi.v1_0.utils.XMLUtils.isNotificaB2B(metadati)) {
            fatturaB2B = true;
        } else if (it.gov.fatturapa.sdi.messaggi.v1_0.utils.XMLUtils.isNotificaPA(metadati, (boolean)sdiProperties.isEnableValidazioneMessaggiCompatibilitaNamespaceSenzaGov())) {
            fatturaB2B = false;
        } else {
            String namespace = null;
            Throwable eMalformato = null;
            try {
                MessageXMLUtils xmlUtils = MessageXMLUtils.getInstance((OpenSPCoop2MessageFactory)this.messageFactory);
                Document docXML = xmlUtils.newDocument(metadati);
                Element elemXML = docXML.getDocumentElement();
                namespace = elemXML.getNamespaceURI();
            }
            catch (Throwable t) {
                eMalformato = t;
            }
            if (namespace != null) {
                eccezioniValidazione.add(validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [Metadati] contiene un namespace (" + namespace + ") sconosciuto", forceEccezioneLivelloInfo));
            } else {
                eccezioniValidazione.add(validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [Metadati] contiene un xml malformato: " + eMalformato.getMessage(), eMalformato, forceEccezioneLivelloInfo));
            }
            return false;
        }
        if (sdiProperties.isEnableValidazioneXsdMetadati().booleanValue()) {
            try {
                AbstractValidatoreXSD validatore;
                if (fatturaB2B) {
                    validatore = XSDValidatorWithSignature.getOpenSPCoop2MessageXSDValidator(protocolFactory.getLogger());
                    validatore.valida((InputStream)new ByteArrayInputStream(metadati));
                } else {
                    validatore = it.gov.fatturapa.sdi.messaggi.v1_0.utils.XSDValidatorWithSignature.getOpenSPCoop2MessageXSDValidator(protocolFactory.getLogger());
                    validatore.valida((InputStream)new ByteArrayInputStream(metadati));
                }
            }
            catch (Exception e) {
                eccezioniValidazione.add(validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [Metadati] contiene un file Metadati non valido rispetto allo schema XSD: " + e.getMessage(), e, forceEccezioneLivelloInfo));
                return false;
            }
        }
        if (fatturaB2B) {
            String nomeFileLettoInValidazioneSintattica;
            metadatiObject = null;
            try {
                it.gov.agenziaentrate.ivaservizi.docs.xsd.fattura.messaggi.v1_0.utils.serializer.JaxbDeserializer deserializer = new it.gov.agenziaentrate.ivaservizi.docs.xsd.fattura.messaggi.v1_0.utils.serializer.JaxbDeserializer();
                metadatiObject = deserializer.readFileMetadatiType(metadati);
                if (sdiProperties.isSaveFatturaInContext().booleanValue()) {
                    this.msg.addContextProperty(SDICostanti.SDI_MESSAGE_CONTEXT_FATTURA_METADATI, (Object)metadatiObject);
                    this.msg.addContextProperty(SDICostanti.SDI_MESSAGE_CONTEXT_FATTURA_METADATI_BYTES, (Object)metadati);
                }
            }
            catch (Exception e) {
                eccezioniValidazione.add(validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [Metadati] contiene un file Metadati non valido: " + e.getMessage(), e, forceEccezioneLivelloInfo));
                return false;
            }
            String identificativoSdILettoInValidazioneSintattica = this.busta.getProperty("IdentificativoSdI");
            if (!identificativoSdILettoInValidazioneSintattica.equals(metadatiObject.getIdentificativoSdI().toString())) {
                eccezioniValidazione.add(validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.IDENTIFICATIVO_MESSAGGIO_NON_VALIDO, "Identificativo presente nel messaggio SdI [" + identificativoSdILettoInValidazioneSintattica + "] differente da quello presente nel file Metadati [" + metadatiObject.getIdentificativoSdI().toString() + "]", sdiProperties.isEnableValidazioneCampiInterniMetadati() == false));
                if (sdiProperties.isEnableValidazioneCampiInterniMetadati().booleanValue()) {
                    return false;
                }
            }
            if (!(nomeFileLettoInValidazioneSintattica = this.busta.getProperty("NomeFile")).equals(metadatiObject.getNomeFile())) {
                eccezioniValidazione.add(validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "NomeFile presente nel messaggio SdI [" + nomeFileLettoInValidazioneSintattica + "] differente da quello presente nel file Metadati [" + metadatiObject.getNomeFile() + "]", sdiProperties.isEnableValidazioneCampiInterniMetadati() == false));
                if (sdiProperties.isEnableValidazioneCampiInterniMetadati().booleanValue()) {
                    return false;
                }
            }
            if (metadatiObject.getHash() != null) {
                this.busta.addProperty("HashNotifica", metadatiObject.getHash());
            }
            this.busta.addProperty("CodiceDestinatario", metadatiObject.getCodiceDestinatario());
            String formatoFattura = metadatiObject.getFormato();
            if (!(SDICostanti.SDI_VERSIONE_FATTURA_PA_10.equals(formatoFattura) || SDICostanti.SDI_VERSIONE_FATTURA_PA_11.equals(formatoFattura) || SDICostanti.SDI_VERSIONE_FATTURA_SEMPLIFICATA_10.equals(formatoFattura) || SDICostanti.SDI_VERSIONE_FATTURA_PA_12.equals(formatoFattura) || SDICostanti.SDI_VERSIONE_FATTURA_PR_12.equals(formatoFattura))) {
                eccezioniValidazione.add(validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "FormatoFattura presente nei metadati [" + formatoFattura + "] non valido"));
                return false;
            }
            this.busta.addProperty("FormatoFatturaPA", formatoFattura);
            this.busta.addProperty("TentativiInvio", metadatiObject.getTentativiInvio().toString());
            this.busta.addProperty("MessageId", metadatiObject.getMessageId());
            if (metadatiObject.getNote() != null) {
                this.busta.addProperty("Note", metadatiObject.getNote());
            }
        } else {
            String nomeFileLettoInValidazioneSintattica;
            metadatiObject = null;
            try {
                JaxbDeserializer deserializer = new JaxbDeserializer();
                metadatiObject = deserializer.readMetadatiInvioFileType(metadati);
                if (sdiProperties.isSaveFatturaInContext().booleanValue()) {
                    this.msg.addContextProperty(SDICostanti.SDI_MESSAGE_CONTEXT_FATTURA_METADATI, (Object)metadatiObject);
                    this.msg.addContextProperty(SDICostanti.SDI_MESSAGE_CONTEXT_FATTURA_METADATI_BYTES, (Object)metadati);
                }
            }
            catch (Exception e) {
                eccezioniValidazione.add(validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [Metadati] contiene un file Metadati non valido: " + e.getMessage(), e, forceEccezioneLivelloInfo));
                return false;
            }
            String identificativoSdILettoInValidazioneSintattica = this.busta.getProperty("IdentificativoSdI");
            if (!identificativoSdILettoInValidazioneSintattica.equals(metadatiObject.getIdentificativoSdI().toString())) {
                eccezioniValidazione.add(validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.IDENTIFICATIVO_MESSAGGIO_NON_VALIDO, "Identificativo presente nel messaggio SdI [" + identificativoSdILettoInValidazioneSintattica + "] differente da quello presente nel file Metadati [" + metadatiObject.getIdentificativoSdI().toString() + "]", sdiProperties.isEnableValidazioneCampiInterniMetadati() == false));
                if (sdiProperties.isEnableValidazioneCampiInterniMetadati().booleanValue()) {
                    return false;
                }
            }
            if (!(nomeFileLettoInValidazioneSintattica = this.busta.getProperty("NomeFile")).equals(metadatiObject.getNomeFile())) {
                eccezioniValidazione.add(validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "NomeFile presente nel messaggio SdI [" + nomeFileLettoInValidazioneSintattica + "] differente da quello presente nel file Metadati [" + metadatiObject.getNomeFile() + "]", sdiProperties.isEnableValidazioneCampiInterniMetadati() == false));
                if (sdiProperties.isEnableValidazioneCampiInterniMetadati().booleanValue()) {
                    return false;
                }
            }
            this.busta.addProperty("CodiceDestinatario", metadatiObject.getCodiceDestinatario());
            String formatoFattura = metadatiObject.getFormato();
            if (!(SDICostanti.SDI_VERSIONE_FATTURA_PA_10.equals(formatoFattura) || SDICostanti.SDI_VERSIONE_FATTURA_PA_11.equals(formatoFattura) || SDICostanti.SDI_VERSIONE_FATTURA_SEMPLIFICATA_10.equals(formatoFattura) || SDICostanti.SDI_VERSIONE_FATTURA_PA_12.equals(formatoFattura) || SDICostanti.SDI_VERSIONE_FATTURA_PR_12.equals(formatoFattura))) {
                eccezioniValidazione.add(validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "FormatoFattura presente nei metadati [" + formatoFattura + "] non valido"));
                return false;
            }
            this.busta.addProperty("FormatoFatturaPA", formatoFattura);
            this.busta.addProperty("TentativiInvio", metadatiObject.getTentativiInvio().toString());
            this.busta.addProperty("MessageId", metadatiObject.getMessageId());
            if (metadatiObject.getNote() != null) {
                this.busta.addProperty("Note", metadatiObject.getNote());
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validaNotificaDecorrenzaTermini() throws Exception {
        if (!this.checkServiceNamespace()) {
            return;
        }
        if (this.sdiValidazioneSintattica != null) {
            if (!this.isRichiesta) throw new Exception("NotImplemented");
            this._validazioneSintattica_FileSdiType_richiesta("fileSdI", TipiMessaggi.DT);
            return;
        } else {
            if (!this.isRichiesta) throw new Exception("NotImplemented");
            this._validazioneSemantica_FileSdiType_richiesta(TipiMessaggi.DT);
        }
    }

    private void _validazioneSintattica_FileSdiType_richiesta(String rootElement, TipiMessaggi tipoMessaggio) throws Exception {
        String nomeFile;
        String identificativoSdI;
        block19: {
            if (!rootElement.equals(this.sdiMessage.getLocalName())) {
                this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "LocalName [" + this.sdiMessage.getLocalName() + "] differente da quello atteso [" + rootElement + "]"));
                return;
            }
            List elementChilds = SoapUtils.getNotEmptyChildSOAPElement((SOAPElement)this.sdiMessage);
            if (elementChilds == null || elementChilds.size() <= 0) {
                this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "RootElement [{" + this.namespace + "}" + this.sdiMessage.getLocalName() + "] non contiene elementi"));
                return;
            }
            identificativoSdI = null;
            nomeFile = null;
            Boolean fileRead = null;
            for (int i = 0; i < elementChilds.size(); ++i) {
                SOAPElement child = (SOAPElement)elementChilds.get(i);
                if ("IdentificativoSdI".equals(child.getLocalName())) {
                    if (identificativoSdI != null) {
                        this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.IDENTIFICATIVO_MESSAGGIO_PRESENTE_PIU_VOLTE));
                        return;
                    }
                    if (child.getTextContent() == null) {
                        this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.IDENTIFICATIVO_MESSAGGIO_NON_VALORIZZATO));
                        return;
                    }
                    identificativoSdI = child.getTextContent();
                } else if ("NomeFile".equals(child.getLocalName())) {
                    if (nomeFile != null) {
                        this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [NomeFile] presente piu' volte"));
                        return;
                    }
                    if (child.getTextContent() == null) {
                        this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [NomeFile] non valorizzato"));
                        return;
                    }
                    nomeFile = child.getTextContent();
                } else if ("File".equals(child.getLocalName())) {
                    if (fileRead != null) {
                        this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] presente piu' volte"));
                        return;
                    }
                    fileRead = true;
                } else {
                    this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Element [" + child.getLocalName() + "] sconosciuto"));
                    return;
                }
                if (child.getNamespaceURI() == null) continue;
                this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Element [" + child.getLocalName() + "] appartiene al namespace (" + child.getNamespaceURI() + "). Era atteso un elemento senza namespace"));
                return;
            }
            if (identificativoSdI == null) {
                this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.IDENTIFICATIVO_MESSAGGIO_NON_PRESENTE));
                return;
            }
            if (nomeFile == null) {
                this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [NomeFile] non presente"));
                return;
            }
            if (fileRead == null) {
                this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] non presente"));
                return;
            }
            try {
                SDIValidatoreNomeFile.validaNomeFileMessaggi(nomeFile, tipoMessaggio);
            }
            catch (Exception e) {
                this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [NomeFile] non valido: " + e.getMessage(), e, this.sdiValidazioneSintattica.sdiProperties.isEnableValidazioneNomeFile() == false));
                if (!this.sdiValidazioneSintattica.sdiProperties.isEnableValidazioneNomeFile().booleanValue()) break block19;
                return;
            }
        }
        this.busta.addProperty("IdentificativoSdI", identificativoSdI);
        this.busta.addProperty("NomeFile", nomeFile);
    }

    private void _validazioneSemantica_FileSdiType_richiesta(TipiMessaggi tipoMessaggio) throws Exception {
        byte[] xml;
        block17: {
            xml = null;
            try {
                QName qnameFile = new QName("File");
                Iterator nodeFileIt = this.sdiMessage.getChildElements(qnameFile);
                SOAPElement nodeFile = (SOAPElement)nodeFileIt.next();
                Element xomReference = MTOMUtilities.getIfExistsXomReference((OpenSPCoop2MessageFactory)this.messageFactory, (Element)nodeFile);
                if (xomReference != null) {
                    try {
                        String cid = MTOMUtilities.getCidXomReference((Element)xomReference);
                        if (cid == null) {
                            throw new Exception("XomReference without cid reference");
                        }
                        AttachmentPart ap = MTOMUtilities.getAttachmentPart((OpenSPCoop2Message)this.msg, (String)cid);
                        xml = Utilities.getAsByteArray((InputStream)ap.getDataHandler().getInputStream());
                        if (xml == null || xml.length <= 0) {
                            throw new Exception("Contenuto non presente");
                        }
                        break block17;
                    }
                    catch (Exception e) {
                        this.sdiValidazioneSemantica.erroriValidazione.add(this.sdiValidazioneSemantica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] non valorizzato correttamente: " + e.getMessage(), e));
                        return;
                    }
                }
                if (nodeFile.getTextContent() == null) {
                    this.sdiValidazioneSemantica.erroriValidazione.add(this.sdiValidazioneSemantica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] non valorizzato"));
                    return;
                }
                String base64File = nodeFile.getTextContent();
                if (base64File == null || "".equals(base64File)) {
                    throw new Exception("Codifica Base64 non presente");
                }
                try {
                    xml = Base64Utilities.decode((String)base64File);
                }
                catch (Exception e) {
                    this.sdiValidazioneSemantica.erroriValidazione.add(this.sdiValidazioneSemantica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] decodifica base64 non riuscita: " + e.getMessage(), e));
                    return;
                }
            }
            catch (Exception e) {
                this.sdiValidazioneSemantica.erroriValidazione.add(this.sdiValidazioneSemantica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] non accessibile: " + e.getMessage(), e));
                return;
            }
        }
        switch (tipoMessaggio) {
            case DT: {
                this._validazioneDT(xml, this.sdiValidazioneSemantica.sdiProperties, this.sdiValidazioneSemantica.erroriValidazione, this.sdiValidazioneSemantica.validazioneUtils, this.sdiValidazioneSemantica.getProtocolFactory());
                break;
            }
        }
        String identificativoSdI = this.busta.getProperty("IdentificativoSdI");
        if (identificativoSdI != null && this.sdiValidazioneSemantica.sdiProperties.isEnable_fatturazionePassiva_notifiche_enrichInfoFromFattura().booleanValue()) {
            try {
                this.sdiValidazioneSemantica.validazioneUtils.readInformazioniFatturaRiferita(this.busta, identificativoSdI, "RicezioneFatture", "RiceviFatture", false, false, this.proprietaValidazioneSemantica != null ? this.proprietaValidazioneSemantica.getTracceState() : null);
            }
            catch (Exception e) {
                this.sdiValidazioneSemantica.getLog().error("Traccia di una precedente fattura ricevuta, con identificativo SDI [" + identificativoSdI + "], non rilevata: " + e.getMessage(), (Throwable)e);
                this.sdiValidazioneSemantica.erroriValidazione.add(this.sdiValidazioneSemantica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Traccia di una precedente fattura ricevuta, con identificativo SDI [" + identificativoSdI + "], non rilevata: " + e.getMessage(), e, true));
            }
        }
    }

    private void _validazioneDT(byte[] xmlDoc, SDIProperties sdiProperties, List<Eccezione> eccezioniValidazione, SDIValidazioneUtils validazioneUtils, IProtocolFactory<?> protocolFactory) throws Exception {
        boolean forceEccezioneLivelloInfo = false;
        if (!sdiProperties.isEnableAccessoMessaggi().booleanValue()) {
            return;
        }
        if (sdiProperties.isEnableAccessoMessaggiWarningMode().booleanValue()) {
            forceEccezioneLivelloInfo = true;
        }
        String tipoXml = "Notifica di Decorrenza Termini";
        byte[] xml = xmlDoc;
        if (sdiProperties.isEnableValidazioneMessaggiCompatibilitaNamespaceSenzaGov().booleanValue()) {
            xml = SDICompatibilitaNamespaceErrati.convertiXmlNamespaceSenzaGov(protocolFactory.getLogger(), xml);
        }
        if (sdiProperties.isEnableValidazioneXsdMessaggi().booleanValue()) {
            try {
                AbstractValidatoreXSD validatore = it.gov.fatturapa.sdi.messaggi.v1_0.utils.XSDValidatorWithSignature.getOpenSPCoop2MessageXSDValidator(protocolFactory.getLogger());
                validatore.valida((InputStream)new ByteArrayInputStream(xml));
            }
            catch (Exception e) {
                eccezioniValidazione.add(validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] contiene un file " + tipoXml + " non valido rispetto allo schema XSD: " + e.getMessage(), e, forceEccezioneLivelloInfo));
                return;
            }
        }
        NotificaDecorrenzaTerminiType xmlObject = null;
        try {
            JaxbDeserializer deserializer = new JaxbDeserializer();
            xmlObject = deserializer.readNotificaDecorrenzaTerminiType(xml);
            if (sdiProperties.isSaveMessaggiInContext().booleanValue()) {
                this.msg.addContextProperty(SDICostanti.SDI_MESSAGE_CONTEXT_MESSAGGIO_SERVIZIO_SDI, (Object)xmlObject);
            }
        }
        catch (Exception e) {
            eccezioniValidazione.add(validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] contiene un file " + tipoXml + " non valido: " + e.getMessage(), e, forceEccezioneLivelloInfo));
            return;
        }
        if (xmlObject.getIdentificativoSdI() != null) {
            this.busta.addProperty("IdentificativoSdIFattura", xmlObject.getIdentificativoSdI());
        }
        if (xmlObject.getRiferimentoFattura() != null) {
            if (xmlObject.getRiferimentoFattura().getAnnoFattura() != null) {
                this.busta.addProperty("RiferimentoFattura-Anno", "" + xmlObject.getRiferimentoFattura().getAnnoFattura());
            }
            if (xmlObject.getRiferimentoFattura().getNumeroFattura() != null) {
                this.busta.addProperty("RiferimentoFattura-Numero", xmlObject.getRiferimentoFattura().getNumeroFattura());
            }
            if (xmlObject.getRiferimentoFattura().getPosizioneFattura() != null) {
                this.busta.addProperty("RiferimentoFattura-Posizione", "" + xmlObject.getRiferimentoFattura().getPosizioneFattura());
            }
        }
        if (xmlObject.getNomeFile() != null) {
            this.busta.addProperty("NomeFileInternoNotifica", xmlObject.getNomeFile());
        }
        if (xmlObject.getDescrizione() != null) {
            this.busta.addProperty("Descrizione", xmlObject.getDescrizione());
        }
        if (xmlObject.getMessageId() != null) {
            this.busta.addProperty("MessageId", xmlObject.getMessageId());
        }
        if (xmlObject.getNote() != null) {
            this.busta.addProperty("Note", xmlObject.getNote());
        }
    }
}

