/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdi.validator;

import it.gov.agenziaentrate.ivaservizi.docs.xsd.fattura.messaggi.v1_0.utils.XSDValidatorWithSignature;
import it.gov.fatturapa.sdi.messaggi.v1_0.AttestazioneTrasmissioneFatturaType;
import it.gov.fatturapa.sdi.messaggi.v1_0.ErroreType;
import it.gov.fatturapa.sdi.messaggi.v1_0.NotificaDecorrenzaTerminiType;
import it.gov.fatturapa.sdi.messaggi.v1_0.NotificaEsitoType;
import it.gov.fatturapa.sdi.messaggi.v1_0.constants.TipiMessaggi;
import it.gov.fatturapa.sdi.messaggi.v1_0.utils.XMLUtils;
import it.gov.fatturapa.sdi.messaggi.v1_0.utils.serializer.JaxbDeserializer;
import it.gov.fatturapa.sdi.messaggi.v1_0.utils.serializer.JaxbSerializer;
import it.gov.fatturapa.sdi.ws.trasmissione.v1_0.types.utils.ProjectInfo;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPElement;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.soap.SoapUtils;
import org.openspcoop2.message.soap.mtom.MTOMUtilities;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.protocol.sdi.config.SDIProperties;
import org.openspcoop2.protocol.sdi.constants.SDICostanti;
import org.openspcoop2.protocol.sdi.utils.SDICompatibilitaNamespaceErrati;
import org.openspcoop2.protocol.sdi.validator.SDIValidatoreNomeFile;
import org.openspcoop2.protocol.sdi.validator.SDIValidazioneSemantica;
import org.openspcoop2.protocol.sdi.validator.SDIValidazioneSintattica;
import org.openspcoop2.protocol.sdi.validator.SDIValidazioneUtils;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Eccezione;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.protocol.sdk.validator.ProprietaValidazione;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.beans.BaseBean;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.io.ZipUtilities;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.xml.AbstractValidatoreXSD;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SDIValidatoreServizioTrasmissioneFatture {
    private SDIValidazioneSintattica sdiValidazioneSintattica;
    private SDIValidazioneSemantica sdiValidazioneSemantica;
    private ProprietaValidazione proprietaValidazioneSemantica;
    private OpenSPCoop2Message msg;
    private OpenSPCoop2MessageFactory messageFactory;
    private boolean isRichiesta;
    private SOAPElement sdiMessage;
    private String namespace;
    private Busta busta;

    public SDIValidatoreServizioTrasmissioneFatture(SDIValidazioneSintattica sdiValidazioneSintattica, OpenSPCoop2Message msg, boolean isRichiesta, SOAPElement sdiMessage, Busta busta) {
        this.sdiValidazioneSintattica = sdiValidazioneSintattica;
        this.msg = msg;
        this.messageFactory = this.msg != null ? this.msg.getFactory() : OpenSPCoop2MessageFactory.getDefaultMessageFactory();
        this.isRichiesta = isRichiesta;
        this.sdiMessage = sdiMessage;
        this.namespace = ProjectInfo.getInstance().getProjectNamespace();
        this.busta = busta;
    }

    public SDIValidatoreServizioTrasmissioneFatture(SDIValidazioneSemantica sdiValidazioneSemantica, ProprietaValidazione proprietaValidazione, OpenSPCoop2Message msg, boolean isRichiesta, SOAPElement sdiMessage, Busta busta) {
        this.sdiValidazioneSemantica = sdiValidazioneSemantica;
        this.proprietaValidazioneSemantica = proprietaValidazione;
        this.msg = msg;
        this.messageFactory = this.msg != null ? this.msg.getFactory() : OpenSPCoop2MessageFactory.getDefaultMessageFactory();
        this.isRichiesta = isRichiesta;
        this.sdiMessage = sdiMessage;
        this.namespace = ProjectInfo.getInstance().getProjectNamespace();
        this.busta = busta;
    }

    private boolean checkServiceNamespace() throws Exception {
        if (!this.namespace.equals(this.sdiMessage.getNamespaceURI())) {
            this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Namespace [" + this.sdiMessage.getNamespaceURI() + "] differente da quello atteso [" + this.namespace + "]"));
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validaRicevutaConsegna() throws Exception {
        if (!this.checkServiceNamespace()) {
            return;
        }
        if (this.sdiValidazioneSintattica != null) {
            if (!this.isRichiesta) throw new Exception("NotImplemented");
            this._validazioneSintattica_FileSdiType_richiesta("ricevutaConsegna", TipiMessaggi.RC);
            return;
        } else {
            if (!this.isRichiesta) throw new Exception("NotImplemented");
            this._validazioneSemantica_FileSdiType_richiesta(TipiMessaggi.RC);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validaNotificaMancataConsegna() throws Exception {
        if (!this.checkServiceNamespace()) {
            return;
        }
        if (this.sdiValidazioneSintattica != null) {
            if (!this.isRichiesta) throw new Exception("NotImplemented");
            this._validazioneSintattica_FileSdiType_richiesta("notificaMancataConsegna", TipiMessaggi.MC);
            return;
        } else {
            if (!this.isRichiesta) throw new Exception("NotImplemented");
            this._validazioneSemantica_FileSdiType_richiesta(TipiMessaggi.MC);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validaNotificaScarto() throws Exception {
        if (!this.checkServiceNamespace()) {
            return;
        }
        if (this.sdiValidazioneSintattica != null) {
            if (!this.isRichiesta) throw new Exception("NotImplemented");
            this._validazioneSintattica_FileSdiType_richiesta("notificaScarto", TipiMessaggi.NS);
            return;
        } else {
            if (!this.isRichiesta) throw new Exception("NotImplemented");
            this._validazioneSemantica_FileSdiType_richiesta(TipiMessaggi.NS);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validaNotificaEsito() throws Exception {
        if (!this.checkServiceNamespace()) {
            return;
        }
        if (this.sdiValidazioneSintattica != null) {
            if (!this.isRichiesta) throw new Exception("NotImplemented");
            this._validazioneSintattica_FileSdiType_richiesta("notificaEsito", TipiMessaggi.NE);
            return;
        } else {
            if (!this.isRichiesta) throw new Exception("NotImplemented");
            this._validazioneSemantica_FileSdiType_richiesta(TipiMessaggi.NE);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validaNotificaDecorrenzaTermini() throws Exception {
        if (!this.checkServiceNamespace()) {
            return;
        }
        if (this.sdiValidazioneSintattica != null) {
            if (!this.isRichiesta) throw new Exception("NotImplemented");
            this._validazioneSintattica_FileSdiType_richiesta("notificaDecorrenzaTermini", TipiMessaggi.DT);
            return;
        } else {
            if (!this.isRichiesta) throw new Exception("NotImplemented");
            this._validazioneSemantica_FileSdiType_richiesta(TipiMessaggi.DT);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validaAttestazioneTrasmissioneFattura() throws Exception {
        if (!this.checkServiceNamespace()) {
            return;
        }
        if (this.sdiValidazioneSintattica != null) {
            if (!this.isRichiesta) throw new Exception("NotImplemented");
            this._validazioneSintattica_FileSdiType_richiesta("attestazioneTrasmissioneFattura", TipiMessaggi.AT);
            return;
        } else {
            if (!this.isRichiesta) throw new Exception("NotImplemented");
            this._validazioneSemantica_FileSdiType_richiesta(TipiMessaggi.AT);
        }
    }

    private void _validazioneSintattica_FileSdiType_richiesta(String rootElement, TipiMessaggi tipoMessaggio) throws Exception {
        String nomeFile;
        String identificativoSdI;
        block19: {
            if (!rootElement.equals(this.sdiMessage.getLocalName())) {
                this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "LocalName [" + this.sdiMessage.getLocalName() + "] differente da quello atteso [" + rootElement + "]"));
                return;
            }
            List elementChilds = SoapUtils.getNotEmptyChildSOAPElement((SOAPElement)this.sdiMessage);
            if (elementChilds == null || elementChilds.size() <= 0) {
                this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "RootElement [{" + this.namespace + "}" + this.sdiMessage.getLocalName() + "] non contiene elementi"));
                return;
            }
            identificativoSdI = null;
            nomeFile = null;
            Boolean fileRead = null;
            for (int i = 0; i < elementChilds.size(); ++i) {
                SOAPElement child = (SOAPElement)elementChilds.get(i);
                if ("IdentificativoSdI".equals(child.getLocalName())) {
                    if (identificativoSdI != null) {
                        this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.IDENTIFICATIVO_MESSAGGIO_PRESENTE_PIU_VOLTE));
                        return;
                    }
                    if (child.getTextContent() == null) {
                        this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.IDENTIFICATIVO_MESSAGGIO_NON_VALORIZZATO));
                        return;
                    }
                    identificativoSdI = child.getTextContent();
                } else if ("NomeFile".equals(child.getLocalName())) {
                    if (nomeFile != null) {
                        this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [NomeFile] presente piu' volte"));
                        return;
                    }
                    if (child.getTextContent() == null) {
                        this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [NomeFile] non valorizzato"));
                        return;
                    }
                    nomeFile = child.getTextContent();
                } else if ("File".equals(child.getLocalName())) {
                    if (fileRead != null) {
                        this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] presente piu' volte"));
                        return;
                    }
                    fileRead = true;
                } else {
                    this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Element [" + child.getLocalName() + "] sconosciuto"));
                    return;
                }
                if (child.getNamespaceURI() == null) continue;
                this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Element [" + child.getLocalName() + "] appartiene al namespace (" + child.getNamespaceURI() + "). Era atteso un elemento senza namespace"));
                return;
            }
            if (identificativoSdI == null) {
                this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.IDENTIFICATIVO_MESSAGGIO_NON_PRESENTE));
                return;
            }
            if (nomeFile == null) {
                this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [NomeFile] non presente"));
                return;
            }
            if (fileRead == null) {
                this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] non presente"));
                return;
            }
            try {
                SDIValidatoreNomeFile.validaNomeFileMessaggi(nomeFile, tipoMessaggio);
            }
            catch (Exception e) {
                this.sdiValidazioneSintattica.erroriValidazione.add(this.sdiValidazioneSintattica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [NomeFile] non valido: " + e.getMessage(), e, this.sdiValidazioneSintattica.sdiProperties.isEnableValidazioneNomeFile() == false));
                if (!this.sdiValidazioneSintattica.sdiProperties.isEnableValidazioneNomeFile().booleanValue()) break block19;
                return;
            }
        }
        this.busta.addProperty("IdentificativoSdI", identificativoSdI);
        this.busta.addProperty("NomeFile", nomeFile);
    }

    private void _validazioneSemantica_FileSdiType_richiesta(TipiMessaggi tipoMessaggio) throws Exception {
        byte[] xml;
        block22: {
            xml = null;
            try {
                QName qnameFile = new QName("File");
                Iterator nodeFileIt = this.sdiMessage.getChildElements(qnameFile);
                SOAPElement nodeFile = (SOAPElement)nodeFileIt.next();
                Element xomReference = MTOMUtilities.getIfExistsXomReference((OpenSPCoop2MessageFactory)this.messageFactory, (Element)nodeFile);
                if (xomReference != null) {
                    try {
                        String cid = MTOMUtilities.getCidXomReference((Element)xomReference);
                        if (cid == null) {
                            throw new Exception("XomReference without cid reference");
                        }
                        AttachmentPart ap = MTOMUtilities.getAttachmentPart((OpenSPCoop2Message)this.msg, (String)cid);
                        xml = Utilities.getAsByteArray((InputStream)ap.getDataHandler().getInputStream());
                        if (xml == null || xml.length <= 0) {
                            throw new Exception("Contenuto non presente");
                        }
                        break block22;
                    }
                    catch (Exception e) {
                        this.sdiValidazioneSemantica.erroriValidazione.add(this.sdiValidazioneSemantica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] non valorizzato correttamente: " + e.getMessage(), e));
                        return;
                    }
                }
                if (nodeFile.getTextContent() == null) {
                    this.sdiValidazioneSemantica.erroriValidazione.add(this.sdiValidazioneSemantica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] non valorizzato"));
                    return;
                }
                String base64File = nodeFile.getTextContent();
                if (base64File == null || "".equals(base64File)) {
                    throw new Exception("Codifica Base64 non presente");
                }
                try {
                    xml = Base64Utilities.decode((String)base64File);
                }
                catch (Exception e) {
                    this.sdiValidazioneSemantica.erroriValidazione.add(this.sdiValidazioneSemantica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] decodifica base64 non riuscita: " + e.getMessage(), e));
                    return;
                }
            }
            catch (Exception e) {
                this.sdiValidazioneSemantica.erroriValidazione.add(this.sdiValidazioneSemantica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] non accessibile: " + e.getMessage(), e));
                return;
            }
        }
        switch (tipoMessaggio) {
            case RC: {
                this._validazioneRC(xml, this.sdiValidazioneSemantica.sdiProperties, this.sdiValidazioneSemantica.erroriValidazione, this.sdiValidazioneSemantica.validazioneUtils, this.sdiValidazioneSemantica.getProtocolFactory());
                break;
            }
            case MC: {
                this._validazioneMC(xml, this.sdiValidazioneSemantica.sdiProperties, this.sdiValidazioneSemantica.erroriValidazione, this.sdiValidazioneSemantica.validazioneUtils, this.sdiValidazioneSemantica.getProtocolFactory());
                break;
            }
            case NS: {
                this._validazioneNS(xml, this.sdiValidazioneSemantica.sdiProperties, this.sdiValidazioneSemantica.erroriValidazione, this.sdiValidazioneSemantica.validazioneUtils, this.sdiValidazioneSemantica.getProtocolFactory());
                break;
            }
            case NE: {
                this._validazioneNE(xml, this.sdiValidazioneSemantica.sdiProperties, this.sdiValidazioneSemantica.erroriValidazione, this.sdiValidazioneSemantica.validazioneUtils, this.sdiValidazioneSemantica.getProtocolFactory());
                break;
            }
            case DT: {
                this._validazioneDT(xml, this.sdiValidazioneSemantica.sdiProperties, this.sdiValidazioneSemantica.erroriValidazione, this.sdiValidazioneSemantica.validazioneUtils, this.sdiValidazioneSemantica.getProtocolFactory());
                break;
            }
            case AT: {
                this._validazioneAT(xml, this.sdiValidazioneSemantica.sdiProperties, this.sdiValidazioneSemantica.erroriValidazione, this.sdiValidazioneSemantica.validazioneUtils, this.sdiValidazioneSemantica.getProtocolFactory());
                break;
            }
        }
        String identificativoSdI = this.busta.getProperty("IdentificativoSdI");
        if (identificativoSdI != null && this.sdiValidazioneSemantica.sdiProperties.isEnable_fatturazioneAttiva_notifiche_enrichInfoFromFattura().booleanValue()) {
            try {
                this.sdiValidazioneSemantica.validazioneUtils.readInformazioniFatturaRiferita(this.busta, identificativoSdI, "SdIRiceviFile", "RiceviFile", true, true, this.proprietaValidazioneSemantica != null ? this.proprietaValidazioneSemantica.getTracceState() : null);
            }
            catch (Exception e) {
                this.sdiValidazioneSemantica.getLog().error("Traccia di una precedente fattura inviata, con identificativo SDI [" + identificativoSdI + "], non rilevata: " + e.getMessage(), (Throwable)e);
                this.sdiValidazioneSemantica.erroriValidazione.add(this.sdiValidazioneSemantica.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Traccia di una precedente fattura inviata, con identificativo SDI [" + identificativoSdI + "], non rilevata: " + e.getMessage(), e, true));
            }
        }
    }

    private void _validazioneRC(byte[] xmlDoc, SDIProperties sdiProperties, List<Eccezione> eccezioniValidazione, SDIValidazioneUtils validazioneUtils, IProtocolFactory<?> protocolFactory) throws Exception {
        BaseBean xmlObject;
        boolean forceEccezioneLivelloInfo = false;
        if (!sdiProperties.isEnableAccessoMessaggi().booleanValue()) {
            return;
        }
        if (sdiProperties.isEnableAccessoMessaggiWarningMode().booleanValue()) {
            forceEccezioneLivelloInfo = true;
        }
        boolean fatturaB2B = false;
        String tipoXml = null;
        if (it.gov.agenziaentrate.ivaservizi.docs.xsd.fattura.messaggi.v1_0.utils.XMLUtils.isNotificaB2B(xmlDoc)) {
            fatturaB2B = true;
            tipoXml = "Ricevuta di Consegna";
        } else if (XMLUtils.isNotificaPA(xmlDoc, (boolean)sdiProperties.isEnableValidazioneMessaggiCompatibilitaNamespaceSenzaGov())) {
            fatturaB2B = false;
            tipoXml = "Ricevuta di Consegna";
        } else {
            String namespace = null;
            Throwable eMalformato = null;
            try {
                MessageXMLUtils xmlUtils = MessageXMLUtils.getInstance((OpenSPCoop2MessageFactory)this.messageFactory);
                Document docXML = xmlUtils.newDocument(xmlDoc);
                Element elemXML = docXML.getDocumentElement();
                namespace = elemXML.getNamespaceURI();
            }
            catch (Throwable t) {
                eMalformato = t;
            }
            if (namespace != null) {
                eccezioniValidazione.add(validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] contiene un namespace (" + namespace + ") sconosciuto", forceEccezioneLivelloInfo));
            } else {
                eccezioniValidazione.add(validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] contiene un xml malformato: " + eMalformato.getMessage(), eMalformato, forceEccezioneLivelloInfo));
            }
            return;
        }
        byte[] xml = xmlDoc;
        if (!fatturaB2B && sdiProperties.isEnableValidazioneMessaggiCompatibilitaNamespaceSenzaGov().booleanValue()) {
            xml = SDICompatibilitaNamespaceErrati.convertiXmlNamespaceSenzaGov(protocolFactory.getLogger(), xml);
        }
        if (sdiProperties.isEnableValidazioneXsdMessaggi().booleanValue()) {
            try {
                AbstractValidatoreXSD validatore;
                if (fatturaB2B) {
                    validatore = XSDValidatorWithSignature.getOpenSPCoop2MessageXSDValidator(protocolFactory.getLogger());
                    validatore.valida((InputStream)new ByteArrayInputStream(xml));
                } else {
                    validatore = it.gov.fatturapa.sdi.messaggi.v1_0.utils.XSDValidatorWithSignature.getOpenSPCoop2MessageXSDValidator(protocolFactory.getLogger());
                    validatore.valida((InputStream)new ByteArrayInputStream(xml));
                }
            }
            catch (Exception e) {
                eccezioniValidazione.add(validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] contiene un file " + tipoXml + " non valido rispetto allo schema XSD: " + e.getMessage(), e, forceEccezioneLivelloInfo));
                return;
            }
        }
        if (fatturaB2B) {
            xmlObject = null;
            try {
                it.gov.agenziaentrate.ivaservizi.docs.xsd.fattura.messaggi.v1_0.utils.serializer.JaxbDeserializer deserializer = new it.gov.agenziaentrate.ivaservizi.docs.xsd.fattura.messaggi.v1_0.utils.serializer.JaxbDeserializer();
                xmlObject = deserializer.readRicevutaConsegnaType(xml);
                if (sdiProperties.isSaveMessaggiInContext().booleanValue()) {
                    this.msg.addContextProperty(SDICostanti.SDI_MESSAGE_CONTEXT_MESSAGGIO_SERVIZIO_SDI, (Object)xmlObject);
                }
            }
            catch (Exception e) {
                eccezioniValidazione.add(validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] contiene un file " + tipoXml + " non valido: " + e.getMessage(), e, forceEccezioneLivelloInfo));
                return;
            }
            String idSdi = null;
            String idSdiRifArchivio = null;
            if (xmlObject.getIdentificativoSdI() != null) {
                idSdi = xmlObject.getIdentificativoSdI();
                this.busta.addProperty("IdentificativoSdIFattura", xmlObject.getIdentificativoSdI());
            }
            if (xmlObject.getNomeFile() != null) {
                this.busta.addProperty("NomeFileInternoNotifica", xmlObject.getNomeFile());
            }
            if (xmlObject.getHash() != null) {
                this.busta.addProperty("HashNotifica", xmlObject.getHash());
            }
            if (xmlObject.getDataOraRicezione() != null) {
                this.busta.addProperty("DataOraRicezione", xmlObject.getDataOraRicezione().toString());
            }
            if (xmlObject.getDataOraConsegna() != null) {
                this.busta.addProperty("DataOraConsegna", xmlObject.getDataOraConsegna().toString());
            }
            if (xmlObject.getDestinatario() != null) {
                if (xmlObject.getDestinatario().getCodice() != null) {
                    this.busta.addProperty("Destinatario-Codice", xmlObject.getDestinatario().getCodice());
                }
                if (xmlObject.getDestinatario().getDescrizione() != null) {
                    this.busta.addProperty("Destinatario-Descrizione", xmlObject.getDestinatario().getDescrizione());
                }
            }
            if (xmlObject.getRiferimentoArchivio() != null) {
                if (xmlObject.getRiferimentoArchivio().getIdentificativoSdI() != null) {
                    idSdiRifArchivio = xmlObject.getRiferimentoArchivio().getIdentificativoSdI();
                    this.busta.addProperty("RiferimentoArchivio-IdentificativoSdI", xmlObject.getRiferimentoArchivio().getIdentificativoSdI());
                }
                if (xmlObject.getRiferimentoArchivio().getNomeFile() != null) {
                    this.busta.addProperty("RiferimentoArchivio-NomeFile", xmlObject.getRiferimentoArchivio().getNomeFile());
                }
            }
            if (xmlObject.getMessageId() != null) {
                this.busta.addProperty("MessageId", xmlObject.getMessageId());
            }
            if (xmlObject.getNote() != null) {
                this.busta.addProperty("Note", xmlObject.getNote());
            }
            validazioneUtils.addHeaderIdentificativoSdiMessaggio(this.msg, idSdi, idSdiRifArchivio);
        } else {
            xmlObject = null;
            try {
                JaxbDeserializer deserializer = new JaxbDeserializer();
                xmlObject = deserializer.readRicevutaConsegnaType(xml);
                if (sdiProperties.isSaveMessaggiInContext().booleanValue()) {
                    this.msg.addContextProperty(SDICostanti.SDI_MESSAGE_CONTEXT_MESSAGGIO_SERVIZIO_SDI, (Object)xmlObject);
                }
            }
            catch (Exception e) {
                eccezioniValidazione.add(validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] contiene un file " + tipoXml + " non valido: " + e.getMessage(), e, forceEccezioneLivelloInfo));
                return;
            }
            String idSdi = null;
            String idSdiRifArchivio = null;
            if (xmlObject.getIdentificativoSdI() != null) {
                idSdi = xmlObject.getIdentificativoSdI();
                this.busta.addProperty("IdentificativoSdIFattura", idSdi);
            }
            if (xmlObject.getNomeFile() != null) {
                this.busta.addProperty("NomeFileInternoNotifica", xmlObject.getNomeFile());
            }
            if (xmlObject.getDataOraRicezione() != null) {
                this.busta.addProperty("DataOraRicezione", xmlObject.getDataOraRicezione().toString());
            }
            if (xmlObject.getDataOraConsegna() != null) {
                this.busta.addProperty("DataOraConsegna", xmlObject.getDataOraConsegna().toString());
            }
            if (xmlObject.getDestinatario() != null) {
                if (xmlObject.getDestinatario().getCodice() != null) {
                    this.busta.addProperty("Destinatario-Codice", xmlObject.getDestinatario().getCodice());
                }
                if (xmlObject.getDestinatario().getDescrizione() != null) {
                    this.busta.addProperty("Destinatario-Descrizione", xmlObject.getDestinatario().getDescrizione());
                }
            }
            if (xmlObject.getRiferimentoArchivio() != null) {
                if (xmlObject.getRiferimentoArchivio().getIdentificativoSdI() != null) {
                    idSdiRifArchivio = xmlObject.getRiferimentoArchivio().getIdentificativoSdI();
                    this.busta.addProperty("RiferimentoArchivio-IdentificativoSdI", idSdiRifArchivio);
                }
                if (xmlObject.getRiferimentoArchivio().getNomeFile() != null) {
                    this.busta.addProperty("RiferimentoArchivio-NomeFile", xmlObject.getRiferimentoArchivio().getNomeFile());
                }
            }
            if (xmlObject.getMessageId() != null) {
                this.busta.addProperty("MessageId", xmlObject.getMessageId());
            }
            if (xmlObject.getNote() != null) {
                this.busta.addProperty("Note", xmlObject.getNote());
            }
            validazioneUtils.addHeaderIdentificativoSdiMessaggio(this.msg, idSdi, idSdiRifArchivio);
        }
    }

    private void _validazioneMC(byte[] xmlDoc, SDIProperties sdiProperties, List<Eccezione> eccezioniValidazione, SDIValidazioneUtils validazioneUtils, IProtocolFactory<?> protocolFactory) throws Exception {
        BaseBean xmlObject;
        boolean forceEccezioneLivelloInfo = false;
        if (!sdiProperties.isEnableAccessoMessaggi().booleanValue()) {
            return;
        }
        if (sdiProperties.isEnableAccessoMessaggiWarningMode().booleanValue()) {
            forceEccezioneLivelloInfo = true;
        }
        boolean fatturaB2B = false;
        String tipoXml = null;
        if (it.gov.agenziaentrate.ivaservizi.docs.xsd.fattura.messaggi.v1_0.utils.XMLUtils.isNotificaB2B(xmlDoc)) {
            fatturaB2B = true;
            tipoXml = "Ricevuta di Impossibilit\u00e0 di Recapito";
        } else if (XMLUtils.isNotificaPA(xmlDoc, (boolean)sdiProperties.isEnableValidazioneMessaggiCompatibilitaNamespaceSenzaGov())) {
            fatturaB2B = false;
            tipoXml = "Notifica di Mancata Consegna";
        } else {
            String namespace = null;
            Throwable eMalformato = null;
            try {
                MessageXMLUtils xmlUtils = MessageXMLUtils.getInstance((OpenSPCoop2MessageFactory)this.messageFactory);
                Document docXML = xmlUtils.newDocument(xmlDoc);
                Element elemXML = docXML.getDocumentElement();
                namespace = elemXML.getNamespaceURI();
            }
            catch (Throwable t) {
                eMalformato = t;
            }
            if (namespace != null) {
                eccezioniValidazione.add(validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] contiene un namespace (" + namespace + ") sconosciuto", forceEccezioneLivelloInfo));
            } else {
                eccezioniValidazione.add(validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] contiene un xml malformato: " + eMalformato.getMessage(), eMalformato, forceEccezioneLivelloInfo));
            }
            return;
        }
        byte[] xml = xmlDoc;
        if (!fatturaB2B && sdiProperties.isEnableValidazioneMessaggiCompatibilitaNamespaceSenzaGov().booleanValue()) {
            xml = SDICompatibilitaNamespaceErrati.convertiXmlNamespaceSenzaGov(protocolFactory.getLogger(), xml);
        }
        if (sdiProperties.isEnableValidazioneXsdMessaggi().booleanValue()) {
            try {
                AbstractValidatoreXSD validatore;
                if (fatturaB2B) {
                    validatore = XSDValidatorWithSignature.getOpenSPCoop2MessageXSDValidator(protocolFactory.getLogger());
                    validatore.valida((InputStream)new ByteArrayInputStream(xml));
                } else {
                    validatore = it.gov.fatturapa.sdi.messaggi.v1_0.utils.XSDValidatorWithSignature.getOpenSPCoop2MessageXSDValidator(protocolFactory.getLogger());
                    validatore.valida((InputStream)new ByteArrayInputStream(xml));
                }
            }
            catch (Exception e) {
                eccezioniValidazione.add(validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] contiene un file " + tipoXml + " non valido rispetto allo schema XSD: " + e.getMessage(), e, forceEccezioneLivelloInfo));
                return;
            }
        }
        if (fatturaB2B) {
            xmlObject = null;
            try {
                it.gov.agenziaentrate.ivaservizi.docs.xsd.fattura.messaggi.v1_0.utils.serializer.JaxbDeserializer deserializer = new it.gov.agenziaentrate.ivaservizi.docs.xsd.fattura.messaggi.v1_0.utils.serializer.JaxbDeserializer();
                xmlObject = deserializer.readRicevutaImpossibilitaRecapitoType(xml);
                if (sdiProperties.isSaveMessaggiInContext().booleanValue()) {
                    this.msg.addContextProperty(SDICostanti.SDI_MESSAGE_CONTEXT_MESSAGGIO_SERVIZIO_SDI, (Object)xmlObject);
                }
            }
            catch (Exception e) {
                eccezioniValidazione.add(validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] contiene un file " + tipoXml + " non valido: " + e.getMessage(), e, forceEccezioneLivelloInfo));
                return;
            }
            String idSdi = null;
            String idSdiRifArchivio = null;
            if (xmlObject.getIdentificativoSdI() != null) {
                idSdi = xmlObject.getIdentificativoSdI();
                this.busta.addProperty("IdentificativoSdIFattura", xmlObject.getIdentificativoSdI());
            }
            if (xmlObject.getNomeFile() != null) {
                this.busta.addProperty("NomeFileInternoNotifica", xmlObject.getNomeFile());
            }
            if (xmlObject.getHash() != null) {
                this.busta.addProperty("HashNotifica", xmlObject.getHash());
            }
            if (xmlObject.getDataOraRicezione() != null) {
                this.busta.addProperty("DataOraRicezione", xmlObject.getDataOraRicezione().toString());
            }
            if (xmlObject.getDataMessaADisposizione() != null) {
                this.busta.addProperty("DataMessaADisposizione", xmlObject.getDataMessaADisposizione().toString());
            }
            if (xmlObject.getRiferimentoArchivio() != null) {
                if (xmlObject.getRiferimentoArchivio().getIdentificativoSdI() != null) {
                    idSdiRifArchivio = xmlObject.getRiferimentoArchivio().getIdentificativoSdI();
                    this.busta.addProperty("RiferimentoArchivio-IdentificativoSdI", xmlObject.getRiferimentoArchivio().getIdentificativoSdI());
                }
                if (xmlObject.getRiferimentoArchivio().getNomeFile() != null) {
                    this.busta.addProperty("RiferimentoArchivio-NomeFile", xmlObject.getRiferimentoArchivio().getNomeFile());
                }
            }
            if (xmlObject.getDescrizione() != null) {
                this.busta.addProperty("Descrizione", xmlObject.getDescrizione());
            }
            if (xmlObject.getMessageId() != null) {
                this.busta.addProperty("MessageId", xmlObject.getMessageId());
            }
            if (xmlObject.getNote() != null) {
                this.busta.addProperty("Note", xmlObject.getNote());
            }
            validazioneUtils.addHeaderIdentificativoSdiMessaggio(this.msg, idSdi, idSdiRifArchivio);
        } else {
            xmlObject = null;
            try {
                JaxbDeserializer deserializer = new JaxbDeserializer();
                xmlObject = deserializer.readNotificaMancataConsegnaType(xml);
                if (sdiProperties.isSaveMessaggiInContext().booleanValue()) {
                    this.msg.addContextProperty(SDICostanti.SDI_MESSAGE_CONTEXT_MESSAGGIO_SERVIZIO_SDI, (Object)xmlObject);
                }
            }
            catch (Exception e) {
                eccezioniValidazione.add(validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] contiene un file " + tipoXml + " non valido: " + e.getMessage(), e, forceEccezioneLivelloInfo));
                return;
            }
            String idSdi = null;
            String idSdiRifArchivio = null;
            if (xmlObject.getIdentificativoSdI() != null) {
                idSdi = xmlObject.getIdentificativoSdI();
                this.busta.addProperty("IdentificativoSdIFattura", idSdi);
            }
            if (xmlObject.getNomeFile() != null) {
                this.busta.addProperty("NomeFileInternoNotifica", xmlObject.getNomeFile());
            }
            if (xmlObject.getDataOraRicezione() != null) {
                this.busta.addProperty("DataOraRicezione", xmlObject.getDataOraRicezione().toString());
            }
            if (xmlObject.getRiferimentoArchivio() != null) {
                if (xmlObject.getRiferimentoArchivio().getIdentificativoSdI() != null) {
                    idSdiRifArchivio = xmlObject.getRiferimentoArchivio().getIdentificativoSdI();
                    this.busta.addProperty("RiferimentoArchivio-IdentificativoSdI", idSdiRifArchivio);
                }
                if (xmlObject.getRiferimentoArchivio().getNomeFile() != null) {
                    this.busta.addProperty("RiferimentoArchivio-NomeFile", xmlObject.getRiferimentoArchivio().getNomeFile());
                }
            }
            if (xmlObject.getDescrizione() != null) {
                this.busta.addProperty("Descrizione", xmlObject.getDescrizione());
            }
            if (xmlObject.getMessageId() != null) {
                this.busta.addProperty("MessageId", xmlObject.getMessageId());
            }
            if (xmlObject.getNote() != null) {
                this.busta.addProperty("Note", xmlObject.getNote());
            }
            validazioneUtils.addHeaderIdentificativoSdiMessaggio(this.msg, idSdi, idSdiRifArchivio);
        }
    }

    private void _validazioneNS(byte[] xmlDoc, SDIProperties sdiProperties, List<Eccezione> eccezioniValidazione, SDIValidazioneUtils validazioneUtils, IProtocolFactory<?> protocolFactory) throws Exception {
        BaseBean xmlObject;
        boolean forceEccezioneLivelloInfo = false;
        if (!sdiProperties.isEnableAccessoMessaggi().booleanValue()) {
            return;
        }
        if (sdiProperties.isEnableAccessoMessaggiWarningMode().booleanValue()) {
            forceEccezioneLivelloInfo = true;
        }
        boolean fatturaB2B = false;
        String tipoXml = null;
        if (it.gov.agenziaentrate.ivaservizi.docs.xsd.fattura.messaggi.v1_0.utils.XMLUtils.isNotificaB2B(xmlDoc)) {
            fatturaB2B = true;
            tipoXml = "Ricevuta di Scarto";
        } else if (XMLUtils.isNotificaPA(xmlDoc, (boolean)sdiProperties.isEnableValidazioneMessaggiCompatibilitaNamespaceSenzaGov())) {
            fatturaB2B = false;
            tipoXml = "Notifica di Scarto";
        } else {
            String namespace = null;
            Throwable eMalformato = null;
            try {
                MessageXMLUtils xmlUtils = MessageXMLUtils.getInstance((OpenSPCoop2MessageFactory)this.messageFactory);
                Document docXML = xmlUtils.newDocument(xmlDoc);
                Element elemXML = docXML.getDocumentElement();
                namespace = elemXML.getNamespaceURI();
            }
            catch (Throwable t) {
                eMalformato = t;
            }
            if (namespace != null) {
                eccezioniValidazione.add(validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] contiene un namespace (" + namespace + ") sconosciuto", forceEccezioneLivelloInfo));
            } else {
                eccezioniValidazione.add(validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] contiene un xml malformato: " + eMalformato.getMessage(), eMalformato, forceEccezioneLivelloInfo));
            }
            return;
        }
        byte[] xml = xmlDoc;
        if (!fatturaB2B && sdiProperties.isEnableValidazioneMessaggiCompatibilitaNamespaceSenzaGov().booleanValue()) {
            xml = SDICompatibilitaNamespaceErrati.convertiXmlNamespaceSenzaGov(protocolFactory.getLogger(), xml);
        }
        if (sdiProperties.isEnableValidazioneXsdMessaggi().booleanValue()) {
            try {
                AbstractValidatoreXSD validatore;
                if (fatturaB2B) {
                    validatore = XSDValidatorWithSignature.getOpenSPCoop2MessageXSDValidator(protocolFactory.getLogger());
                    validatore.valida((InputStream)new ByteArrayInputStream(xml));
                } else {
                    validatore = it.gov.fatturapa.sdi.messaggi.v1_0.utils.XSDValidatorWithSignature.getOpenSPCoop2MessageXSDValidator(protocolFactory.getLogger());
                    validatore.valida((InputStream)new ByteArrayInputStream(xml));
                }
            }
            catch (Exception e) {
                eccezioniValidazione.add(validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] contiene un file " + tipoXml + " non valido rispetto allo schema XSD: " + e.getMessage(), e, forceEccezioneLivelloInfo));
                return;
            }
        }
        if (fatturaB2B) {
            xmlObject = null;
            try {
                it.gov.agenziaentrate.ivaservizi.docs.xsd.fattura.messaggi.v1_0.utils.serializer.JaxbDeserializer deserializer = new it.gov.agenziaentrate.ivaservizi.docs.xsd.fattura.messaggi.v1_0.utils.serializer.JaxbDeserializer();
                xmlObject = deserializer.readRicevutaScartoType(xml);
                if (sdiProperties.isSaveMessaggiInContext().booleanValue()) {
                    this.msg.addContextProperty(SDICostanti.SDI_MESSAGE_CONTEXT_MESSAGGIO_SERVIZIO_SDI, (Object)xmlObject);
                }
            }
            catch (Exception e) {
                eccezioniValidazione.add(validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] contiene un file " + tipoXml + " non valido: " + e.getMessage(), e, forceEccezioneLivelloInfo));
                return;
            }
            String idSdi = null;
            String idSdiRifArchivio = null;
            if (xmlObject.getIdentificativoSdI() != null) {
                idSdi = xmlObject.getIdentificativoSdI();
                this.busta.addProperty("IdentificativoSdIFattura", xmlObject.getIdentificativoSdI());
            }
            if (xmlObject.getNomeFile() != null) {
                this.busta.addProperty("NomeFileInternoNotifica", xmlObject.getNomeFile());
            }
            if (xmlObject.getHash() != null) {
                this.busta.addProperty("HashNotifica", xmlObject.getHash());
            }
            if (xmlObject.getDataOraRicezione() != null) {
                this.busta.addProperty("DataOraRicezione", xmlObject.getDataOraRicezione().toString());
            }
            if (xmlObject.getRiferimentoArchivio() != null) {
                if (xmlObject.getRiferimentoArchivio().getIdentificativoSdI() != null) {
                    idSdiRifArchivio = xmlObject.getRiferimentoArchivio().getIdentificativoSdI();
                    this.busta.addProperty("RiferimentoArchivio-IdentificativoSdI", xmlObject.getRiferimentoArchivio().getIdentificativoSdI());
                }
                if (xmlObject.getRiferimentoArchivio().getNomeFile() != null) {
                    this.busta.addProperty("RiferimentoArchivio-NomeFile", xmlObject.getRiferimentoArchivio().getNomeFile());
                }
            }
            if (xmlObject.getListaErrori() != null && xmlObject.getListaErrori().sizeErroreList() > 0) {
                StringBuilder bf = new StringBuilder();
                bf.append(xmlObject.getListaErrori().sizeErroreList() + " errori rilevati: ");
                for (int i = 0; i < xmlObject.getListaErrori().sizeErroreList(); ++i) {
                    it.gov.agenziaentrate.ivaservizi.docs.xsd.fattura.messaggi.v1_0.ErroreType errore = xmlObject.getListaErrori().getErrore(i);
                    bf.append("\n\t- [" + errore.getCodice() + "] " + errore.getDescrizione());
                    if (errore.getSuggerimento() == null) continue;
                    bf.append(" (").append(errore.getSuggerimento()).append(")");
                }
                this.busta.addProperty("Errori", bf.toString());
            }
            if (xmlObject.getMessageId() != null) {
                this.busta.addProperty("MessageId", xmlObject.getMessageId());
            }
            if (xmlObject.getNote() != null) {
                this.busta.addProperty("Note", xmlObject.getNote());
            }
            validazioneUtils.addHeaderIdentificativoSdiMessaggio(this.msg, idSdi, idSdiRifArchivio);
        } else {
            xmlObject = null;
            try {
                JaxbDeserializer deserializer = new JaxbDeserializer();
                xmlObject = deserializer.readNotificaScartoType(xml);
                if (sdiProperties.isSaveMessaggiInContext().booleanValue()) {
                    this.msg.addContextProperty(SDICostanti.SDI_MESSAGE_CONTEXT_MESSAGGIO_SERVIZIO_SDI, (Object)xmlObject);
                }
            }
            catch (Exception e) {
                eccezioniValidazione.add(validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] contiene un file " + tipoXml + " non valido: " + e.getMessage(), e, forceEccezioneLivelloInfo));
                return;
            }
            String idSdi = null;
            String idSdiRifArchivio = null;
            if (xmlObject.getIdentificativoSdI() != null) {
                idSdi = xmlObject.getIdentificativoSdI();
                this.busta.addProperty("IdentificativoSdIFattura", idSdi);
            }
            if (xmlObject.getNomeFile() != null) {
                this.busta.addProperty("NomeFileInternoNotifica", xmlObject.getNomeFile());
            }
            if (xmlObject.getDataOraRicezione() != null) {
                this.busta.addProperty("DataOraRicezione", xmlObject.getDataOraRicezione().toString());
            }
            if (xmlObject.getRiferimentoArchivio() != null) {
                if (xmlObject.getRiferimentoArchivio().getIdentificativoSdI() != null) {
                    idSdiRifArchivio = xmlObject.getRiferimentoArchivio().getIdentificativoSdI();
                    this.busta.addProperty("RiferimentoArchivio-IdentificativoSdI", idSdiRifArchivio);
                }
                if (xmlObject.getRiferimentoArchivio().getNomeFile() != null) {
                    this.busta.addProperty("RiferimentoArchivio-NomeFile", xmlObject.getRiferimentoArchivio().getNomeFile());
                }
            }
            if (xmlObject.getListaErrori() != null && xmlObject.getListaErrori().sizeErroreList() > 0) {
                StringBuilder bf = new StringBuilder();
                bf.append(xmlObject.getListaErrori().sizeErroreList() + " errori rilevati: ");
                for (int i = 0; i < xmlObject.getListaErrori().sizeErroreList(); ++i) {
                    ErroreType errore = xmlObject.getListaErrori().getErrore(i);
                    bf.append("\n\t- [" + errore.getCodice() + "] " + errore.getDescrizione());
                }
                this.busta.addProperty("Errori", bf.toString());
            }
            if (xmlObject.getMessageId() != null) {
                this.busta.addProperty("MessageId", xmlObject.getMessageId());
            }
            if (xmlObject.getNote() != null) {
                this.busta.addProperty("Note", xmlObject.getNote());
            }
            validazioneUtils.addHeaderIdentificativoSdiMessaggio(this.msg, idSdi, idSdiRifArchivio);
        }
    }

    private void _validazioneNE(byte[] xmlDoc, SDIProperties sdiProperties, List<Eccezione> eccezioniValidazione, SDIValidazioneUtils validazioneUtils, IProtocolFactory<?> protocolFactory) throws Exception {
        boolean forceEccezioneLivelloInfo = false;
        if (!sdiProperties.isEnableAccessoMessaggi().booleanValue()) {
            return;
        }
        if (sdiProperties.isEnableAccessoMessaggiWarningMode().booleanValue()) {
            forceEccezioneLivelloInfo = true;
        }
        String tipoXml = "Notifica di Esito (Cedente)";
        byte[] xml = xmlDoc;
        if (sdiProperties.isEnableValidazioneMessaggiCompatibilitaNamespaceSenzaGov().booleanValue()) {
            xml = SDICompatibilitaNamespaceErrati.convertiXmlNamespaceSenzaGov(protocolFactory.getLogger(), xml);
        }
        if (sdiProperties.isEnableValidazioneXsdMessaggi().booleanValue()) {
            try {
                AbstractValidatoreXSD validatore = it.gov.fatturapa.sdi.messaggi.v1_0.utils.XSDValidatorWithSignature.getOpenSPCoop2MessageXSDValidator(protocolFactory.getLogger());
                validatore.valida((InputStream)new ByteArrayInputStream(xml));
            }
            catch (Exception e) {
                eccezioniValidazione.add(validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] contiene un file " + tipoXml + " non valido rispetto allo schema XSD: " + e.getMessage(), e, forceEccezioneLivelloInfo));
                return;
            }
        }
        NotificaEsitoType xmlObject = null;
        try {
            JaxbDeserializer deserializer = new JaxbDeserializer();
            xmlObject = deserializer.readNotificaEsitoType(xml);
            if (sdiProperties.isSaveMessaggiInContext().booleanValue()) {
                this.msg.addContextProperty(SDICostanti.SDI_MESSAGE_CONTEXT_MESSAGGIO_SERVIZIO_SDI, (Object)xmlObject);
            }
        }
        catch (Exception e) {
            eccezioniValidazione.add(validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] contiene un file " + tipoXml + " non valido: " + e.getMessage(), e, forceEccezioneLivelloInfo));
            return;
        }
        String idSdi = null;
        String idSdiRifArchivio = null;
        if (xmlObject.getIdentificativoSdI() != null) {
            idSdi = xmlObject.getIdentificativoSdI();
            this.busta.addProperty("IdentificativoSdIFattura", idSdi);
        }
        if (xmlObject.getNomeFile() != null) {
            this.busta.addProperty("NomeFileInternoNotifica", xmlObject.getNomeFile());
        }
        if (xmlObject.getEsitoCommittente() != null) {
            JaxbSerializer serializer = new JaxbSerializer();
            this.busta.addProperty("EsitoCommittente", serializer.toString(xmlObject.getEsitoCommittente()));
        }
        if (xmlObject.getMessageId() != null) {
            this.busta.addProperty("MessageId", xmlObject.getMessageId());
        }
        if (xmlObject.getNote() != null) {
            this.busta.addProperty("Note", xmlObject.getNote());
        }
        validazioneUtils.addHeaderIdentificativoSdiMessaggio(this.msg, idSdi, idSdiRifArchivio);
    }

    private void _validazioneDT(byte[] xmlDoc, SDIProperties sdiProperties, List<Eccezione> eccezioniValidazione, SDIValidazioneUtils validazioneUtils, IProtocolFactory<?> protocolFactory) throws Exception {
        boolean forceEccezioneLivelloInfo = false;
        if (!sdiProperties.isEnableAccessoMessaggi().booleanValue()) {
            return;
        }
        if (sdiProperties.isEnableAccessoMessaggiWarningMode().booleanValue()) {
            forceEccezioneLivelloInfo = true;
        }
        String tipoXml = "Notifica di Decorrenza Termini";
        byte[] xml = xmlDoc;
        if (sdiProperties.isEnableValidazioneMessaggiCompatibilitaNamespaceSenzaGov().booleanValue()) {
            xml = SDICompatibilitaNamespaceErrati.convertiXmlNamespaceSenzaGov(protocolFactory.getLogger(), xml);
        }
        if (sdiProperties.isEnableValidazioneXsdMessaggi().booleanValue()) {
            try {
                AbstractValidatoreXSD validatore = it.gov.fatturapa.sdi.messaggi.v1_0.utils.XSDValidatorWithSignature.getOpenSPCoop2MessageXSDValidator(protocolFactory.getLogger());
                validatore.valida((InputStream)new ByteArrayInputStream(xml));
            }
            catch (Exception e) {
                eccezioniValidazione.add(validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] contiene un file " + tipoXml + " non valido rispetto allo schema XSD: " + e.getMessage(), e, forceEccezioneLivelloInfo));
                return;
            }
        }
        NotificaDecorrenzaTerminiType xmlObject = null;
        try {
            JaxbDeserializer deserializer = new JaxbDeserializer();
            xmlObject = deserializer.readNotificaDecorrenzaTerminiType(xml);
            if (sdiProperties.isSaveMessaggiInContext().booleanValue()) {
                this.msg.addContextProperty(SDICostanti.SDI_MESSAGE_CONTEXT_MESSAGGIO_SERVIZIO_SDI, (Object)xmlObject);
            }
        }
        catch (Exception e) {
            eccezioniValidazione.add(validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] contiene un file " + tipoXml + " non valido: " + e.getMessage(), e, forceEccezioneLivelloInfo));
            return;
        }
        String idSdi = null;
        String idSdiRifArchivio = null;
        if (xmlObject.getIdentificativoSdI() != null) {
            idSdi = xmlObject.getIdentificativoSdI();
            this.busta.addProperty("IdentificativoSdIFattura", idSdi);
        }
        if (xmlObject.getRiferimentoFattura() != null) {
            if (xmlObject.getRiferimentoFattura().getAnnoFattura() != null) {
                this.busta.addProperty("RiferimentoFattura-Anno", "" + xmlObject.getRiferimentoFattura().getAnnoFattura());
            }
            if (xmlObject.getRiferimentoFattura().getNumeroFattura() != null) {
                this.busta.addProperty("RiferimentoFattura-Numero", xmlObject.getRiferimentoFattura().getNumeroFattura());
            }
            if (xmlObject.getRiferimentoFattura().getPosizioneFattura() != null) {
                this.busta.addProperty("RiferimentoFattura-Posizione", "" + xmlObject.getRiferimentoFattura().getPosizioneFattura());
            }
        }
        if (xmlObject.getNomeFile() != null) {
            this.busta.addProperty("NomeFileInternoNotifica", xmlObject.getNomeFile());
        }
        if (xmlObject.getDescrizione() != null) {
            this.busta.addProperty("Descrizione", xmlObject.getDescrizione());
        }
        if (xmlObject.getMessageId() != null) {
            this.busta.addProperty("MessageId", xmlObject.getMessageId());
        }
        if (xmlObject.getNote() != null) {
            this.busta.addProperty("Note", xmlObject.getNote());
        }
        validazioneUtils.addHeaderIdentificativoSdiMessaggio(this.msg, idSdi, idSdiRifArchivio);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _validazioneAT(byte[] zip, SDIProperties sdiProperties, List<Eccezione> eccezioniValidazione, SDIValidazioneUtils validazioneUtils, IProtocolFactory<?> protocolFactory) throws Exception {
        byte[] xmlAT;
        byte[] xmlATDoc;
        boolean consegnaAttestato;
        String tipoXml;
        block60: {
            boolean forceEccezioneLivelloInfo = false;
            if (!sdiProperties.isEnableAccessoMessaggi().booleanValue()) {
                return;
            }
            if (sdiProperties.isEnableAccessoMessaggiWarningMode().booleanValue()) {
                forceEccezioneLivelloInfo = true;
            }
            tipoXml = "Attestazione di avvenuta trasmissione con impossibilit\u00e0 di recapito";
            consegnaAttestato = sdiProperties.isNotificaATConsegnaSoloAttestato();
            File tmpZipFile = null;
            try {
                tmpZipFile = FileSystemUtilities.createTempFile((String)"AttestazioneTrasmissione", (String)".zip");
                FileSystemUtilities.writeFile((File)tmpZipFile, (byte[])zip);
            }
            catch (Exception e) {
                this.sdiValidazioneSemantica.getProtocolFactory().getLogger().error("Operazione di unzip non riuscita: " + e.getMessage(), (Throwable)e);
                eccezioniValidazione.add(validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] contiene un file " + tipoXml + " non valido; \u00e8 avvenuto un erorre durante il salvataggio dell'archivio zip: " + e.getMessage(), e, forceEccezioneLivelloInfo));
                try {
                    if (tmpZipFile == null) return;
                    if (tmpZipFile.delete()) return;
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            File tmpZipFileDir = null;
            xmlATDoc = null;
            boolean xmlFatturaRead = false;
            try {
                tmpZipFileDir = new File(tmpZipFile.getAbsolutePath() + ".unzip");
                ZipUtilities.unzipFile((String)tmpZipFile.getAbsolutePath(), (String)tmpZipFileDir.getAbsolutePath());
                File[] xmls = tmpZipFileDir.listFiles();
                if (xmls == null) throw new Exception("Archivio decompresso non contiene files");
                if (xmls.length <= 0) {
                    throw new Exception("Archivio decompresso non contiene files");
                }
                if (xmls.length != 2) {
                    throw new Exception("Archivio decompresso contiene un numero di files (" + xmls.length + ") differente dal numero atteso (2)");
                }
                for (int i = 0; i < xmls.length; ++i) {
                    if (xmls[i].getName().contains("_AT_")) {
                        if (xmlATDoc != null) {
                            throw new Exception("Archivio decompresso non contiene l'xml della fattura non recapitata");
                        }
                        xmlATDoc = FileSystemUtilities.readBytesFromFile((File)xmls[i]);
                        continue;
                    }
                    if (xmlFatturaRead) {
                        throw new Exception("Archivio decompresso non contiene l'xml di attestazione di avvenuta trasmissione con impossibilit\u00e0 di recapito");
                    }
                    xmlFatturaRead = true;
                }
            }
            catch (Exception e) {
                this.sdiValidazioneSemantica.getProtocolFactory().getLogger().error("Operazione di unzip non riuscita: " + e.getMessage(), (Throwable)e);
                eccezioniValidazione.add(validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] contiene un file " + tipoXml + " non valido; \u00e8 avvenuto un erorre durante la lettura dell'archivio zip: " + e.getMessage(), e, !consegnaAttestato));
                if (consegnaAttestato) {
                    return;
                }
            }
            finally {
                try {
                    if (tmpZipFile != null && tmpZipFile.delete()) {
                        // empty if block
                    }
                }
                catch (Exception i) {}
                try {
                    if (tmpZipFileDir != null) {
                        FileSystemUtilities.deleteDir((File)tmpZipFileDir);
                    }
                }
                catch (Exception i) {}
            }
            xmlAT = null;
            if (xmlATDoc != null) {
                xmlAT = xmlATDoc;
                if (sdiProperties.isEnableValidazioneMessaggiCompatibilitaNamespaceSenzaGov().booleanValue()) {
                    xmlAT = SDICompatibilitaNamespaceErrati.convertiXmlNamespaceSenzaGov(protocolFactory.getLogger(), xmlAT);
                }
                if (sdiProperties.isEnableValidazioneXsdMessaggi().booleanValue()) {
                    try {
                        AbstractValidatoreXSD validatore = it.gov.fatturapa.sdi.messaggi.v1_0.utils.XSDValidatorWithSignature.getOpenSPCoop2MessageXSDValidator(protocolFactory.getLogger());
                        validatore.valida((InputStream)new ByteArrayInputStream(xmlAT));
                    }
                    catch (Exception e) {
                        eccezioniValidazione.add(validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] contiene un file " + tipoXml + " non valido rispetto allo schema XSD: " + e.getMessage(), e, !consegnaAttestato));
                        if (!consegnaAttestato) break block60;
                        return;
                    }
                }
            }
        }
        AttestazioneTrasmissioneFatturaType xmlObject = null;
        if (xmlAT != null) {
            block61: {
                try {
                    JaxbDeserializer deserializer = new JaxbDeserializer();
                    xmlObject = deserializer.readAttestazioneTrasmissioneFatturaType(xmlAT);
                }
                catch (Exception e) {
                    eccezioniValidazione.add(validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Elemento [File] contiene un file " + tipoXml + " non valido: " + e.getMessage(), e, !consegnaAttestato));
                    if (!consegnaAttestato) break block61;
                    return;
                }
            }
            String idSdi = null;
            String idSdiRifArchivio = null;
            if (xmlObject != null) {
                if (xmlObject.getIdentificativoSdI() != null) {
                    idSdi = xmlObject.getIdentificativoSdI();
                    this.busta.addProperty("IdentificativoSdIFattura", idSdi);
                }
                if (xmlObject.getNomeFile() != null) {
                    this.busta.addProperty("NomeFileInternoNotifica", xmlObject.getNomeFile());
                }
                if (xmlObject.getDataOraRicezione() != null) {
                    this.busta.addProperty("DataOraRicezione", xmlObject.getDataOraRicezione().toString());
                }
                if (xmlObject.getRiferimentoArchivio() != null) {
                    if (xmlObject.getRiferimentoArchivio().getIdentificativoSdI() != null) {
                        idSdiRifArchivio = xmlObject.getRiferimentoArchivio().getIdentificativoSdI();
                        this.busta.addProperty("RiferimentoArchivio-IdentificativoSdI", idSdiRifArchivio);
                    }
                    if (xmlObject.getRiferimentoArchivio().getNomeFile() != null) {
                        this.busta.addProperty("RiferimentoArchivio-NomeFile", xmlObject.getRiferimentoArchivio().getNomeFile());
                    }
                }
                if (xmlObject.getDestinatario() != null) {
                    if (xmlObject.getDestinatario().getCodice() != null) {
                        this.busta.addProperty("Destinatario-Codice", xmlObject.getDestinatario().getCodice());
                    }
                    if (xmlObject.getDestinatario().getDescrizione() != null) {
                        this.busta.addProperty("Destinatario-Descrizione", xmlObject.getDestinatario().getDescrizione());
                    }
                }
                if (xmlObject.getMessageId() != null) {
                    this.busta.addProperty("MessageId", xmlObject.getMessageId());
                }
                if (xmlObject.getNote() != null) {
                    this.busta.addProperty("Note", xmlObject.getNote());
                }
                if (xmlObject.getHashFileOriginale() != null) {
                    this.busta.addProperty("HashFileOriginale", xmlObject.getHashFileOriginale());
                }
            }
            validazioneUtils.addHeaderIdentificativoSdiMessaggio(this.msg, idSdi, idSdiRifArchivio);
        }
        if (!consegnaAttestato) {
            this.msg.addContextProperty(SDICostanti.SDI_MESSAGE_CONTEXT_AT_ARCHIVIO_ZIP, (Object)zip);
            return;
        }
        if (xmlObject != null && sdiProperties.isSaveMessaggiInContext().booleanValue()) {
            this.msg.addContextProperty(SDICostanti.SDI_MESSAGE_CONTEXT_MESSAGGIO_SERVIZIO_SDI, (Object)xmlObject);
            return;
        }
        this.msg.addContextProperty(SDICostanti.SDI_MESSAGE_CONTEXT_AT_ARCHIVIO_XML, (Object)xmlATDoc);
    }
}

