/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdi.validator;

import it.gov.fatturapa.sdi.ws.trasmissione.v1_0.types.utils.SdIXSDValidator;
import java.util.ArrayList;
import java.util.List;
import javax.xml.soap.SOAPElement;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.soap.SoapUtils;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.protocol.basic.validator.ValidazioneConSchema;
import org.openspcoop2.protocol.sdi.constants.SDICostantiServizioRiceviFile;
import org.openspcoop2.protocol.sdi.constants.SDICostantiServizioRiceviNotifica;
import org.openspcoop2.protocol.sdi.constants.SDICostantiServizioRicezioneFatture;
import org.openspcoop2.protocol.sdi.constants.SDICostantiServizioTrasmissioneFatture;
import org.openspcoop2.protocol.sdk.Eccezione;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.ContestoCodificaEccezione;
import org.openspcoop2.protocol.sdk.constants.LivelloRilevanza;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.utils.xml.AbstractValidatoreXSD;
import org.w3c.dom.Node;

public class SDIValidazioneConSchema
extends ValidazioneConSchema {
    private List<Eccezione> erroriValidazione;
    private List<Eccezione> erroriProcessamento;

    public SDIValidazioneConSchema(IProtocolFactory<?> factory, IState state) throws ProtocolException {
        super(factory, state);
    }

    public boolean initialize(OpenSPCoop2MessageFactory messageFactory) {
        return true;
    }

    public List<Eccezione> getEccezioniValidazione() {
        return this.erroriValidazione;
    }

    public List<Eccezione> getEccezioniProcessamento() {
        return this.erroriProcessamento;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valida(OpenSPCoop2Message messageParam, boolean isErroreProcessamento, boolean isErroreIntestazione, boolean isMessaggioConAttachments, boolean validazioneManifestAttachments) throws ProtocolException {
        Eccezione ecc;
        this.erroriValidazione = new ArrayList<Eccezione>();
        this.erroriProcessamento = new ArrayList<Eccezione>();
        List references = null;
        try {
            OpenSPCoop2SoapMessage message = messageParam.castAsSoap();
            references = message.mtomFastUnpackagingForXSDConformance();
            SOAPElement child = SoapUtils.getNotEmptyFirstChildSOAPElement((SOAPElement)message.getSOAPBody());
            String namespace = child.getNamespaceURI();
            if (SDICostantiServizioRiceviFile.SDI_SERVIZIO_RICEVI_FILE_NAMESPACE.equals(namespace) || SDICostantiServizioTrasmissioneFatture.TRASMISSIONE_SERVIZIO_TRASMISSIONE_FATTURE_NAMESPACE.equals(namespace)) {
                AbstractValidatoreXSD validator = null;
                validator = "fileSdIAccoglienza".equals(child.getLocalName()) ? SdIXSDValidator.getXSDValidatorTrasmissione_1_0(MessageXMLUtils.class, this.log) : SdIXSDValidator.getXSDValidatorTrasmissione_1_1(MessageXMLUtils.class, this.log);
                try {
                    validator.valida((Node)child);
                }
                catch (Exception e) {
                    this.log.error("Validazione con schema xsd fallita", (Throwable)e);
                    Eccezione ecc2 = new Eccezione();
                    ecc2.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc2.setCodiceEccezione(CodiceErroreCooperazione.FORMATO_INTESTAZIONE_NON_CORRETTO);
                    ecc2.setRilevanza(LivelloRilevanza.ERROR);
                    ecc2.setDescrizione(e.getMessage());
                    this.erroriValidazione.add(ecc2);
                }
            } else if (SDICostantiServizioRiceviNotifica.SDI_SERVIZIO_RICEVI_NOTIFICA_NAMESPACE.equals(namespace) || SDICostantiServizioRicezioneFatture.RICEZIONE_SERVIZIO_RICEZIONE_FATTURE_NAMESPACE.equals(namespace)) {
                AbstractValidatoreXSD validator = it.gov.fatturapa.sdi.ws.ricezione.v1_0.types.utils.SdIXSDValidator.getXSDValidator(MessageXMLUtils.class, this.log);
                try {
                    validator.valida((Node)child);
                }
                catch (Exception e) {
                    this.log.error("Validazione con schema xsd fallita", (Throwable)e);
                    Eccezione ecc3 = new Eccezione();
                    ecc3.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc3.setCodiceEccezione(CodiceErroreCooperazione.FORMATO_INTESTAZIONE_NON_CORRETTO);
                    ecc3.setRilevanza(LivelloRilevanza.ERROR);
                    ecc3.setDescrizione(e.getMessage());
                    this.erroriValidazione.add(ecc3);
                }
            }
        }
        catch (Exception e) {
            this.log.error("Validazione con schema xsd non riuscita non riuscita", (Throwable)e);
            ecc = new Eccezione();
            ecc.setContestoCodifica(ContestoCodificaEccezione.PROCESSAMENTO);
            ecc.setCodiceEccezione(CodiceErroreCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO);
            ecc.setRilevanza(LivelloRilevanza.ERROR);
            ecc.setDescrizione("Validazione con schema xsd non riuscita: errore di processamento");
            this.erroriProcessamento.add(ecc);
        }
        finally {
            try {
                OpenSPCoop2SoapMessage message = messageParam.castAsSoap();
                message.mtomRestoreAfterXSDConformance(references);
            }
            catch (Exception e) {
                this.log.error("Validazione con schema xsd non riuscita non riuscita", (Throwable)e);
                ecc = new Eccezione();
                ecc.setContestoCodifica(ContestoCodificaEccezione.PROCESSAMENTO);
                ecc.setCodiceEccezione(CodiceErroreCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO);
                ecc.setRilevanza(LivelloRilevanza.ERROR);
                ecc.setDescrizione("Validazione con schema xsd non riuscita: errore di processamento");
                this.erroriProcessamento.add(ecc);
            }
        }
    }
}

