/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.rs.server.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import javax.validation.Valid;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.openspcoop2.core.config.rs.server.model.ContestoEnum;
import org.openspcoop2.core.config.rs.server.model.FonteEnum;
import org.openspcoop2.core.config.rs.server.model.ListaRuoli;
import org.openspcoop2.core.config.rs.server.model.Problem;
import org.openspcoop2.core.config.rs.server.model.Ruolo;

@Path(value="/")
public interface RuoliApi {
    @POST
    @Path(value="/ruoli")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Creazione di un ruolo", tags={"ruoli"})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Resource created"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="409", description="Conflict (L'entit\u00e0 che si vuole creare risulta gi\u00e0 esistente)", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public void createRuolo(@Valid Ruolo var1);

    @DELETE
    @Path(value="/ruoli/{nome}")
    @Produces(value={"application/problem+json"})
    @Operation(summary="Elimina un ruolo", tags={"ruoli"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Ruolo eliminato con successo"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public void deleteRuolo(@PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var1);

    @GET
    @Path(value="/ruoli")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Ricerca ruoli", tags={"ruoli"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ricerca eseguita correttamente", content={@Content(schema=@Schema(implementation=ListaRuoli.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public ListaRuoli findAllRuoli(@QueryParam(value="q") String var1, @QueryParam(value="limit") Integer var2, @QueryParam(value="offset") @DefaultValue(value="0") Integer var3, @QueryParam(value="fonte") FonteEnum var4, @QueryParam(value="contesto") ContestoEnum var5);

    @GET
    @Path(value="/ruoli/{nome}")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce il dettaglio di un ruolo", tags={"ruoli"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Dati del ruolo restituiti con successo", content={@Content(schema=@Schema(implementation=Ruolo.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public Ruolo getRuolo(@PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var1);

    @PUT
    @Path(value="/ruoli/{nome}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Modifica i dati di un ruolo", tags={"ruoli"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Il Ruolo \u00e8 stato aggiornato correttamente"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public void updateRuolo(@Valid Ruolo var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2);
}

