/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.rs.server.api.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.config.constants.CredenzialeTipo;
import org.openspcoop2.core.config.rs.server.api.impl.ApiKeyInfo;
import org.openspcoop2.core.config.rs.server.api.impl.HttpRequestWrapper;
import org.openspcoop2.core.config.rs.server.config.ServerProperties;
import org.openspcoop2.core.config.rs.server.model.AuthenticationApiKey;
import org.openspcoop2.core.config.rs.server.model.AuthenticationHttpBasic;
import org.openspcoop2.core.config.rs.server.model.AuthenticationHttps;
import org.openspcoop2.core.config.rs.server.model.AuthenticationHttpsBaseCertificato;
import org.openspcoop2.core.config.rs.server.model.AuthenticationHttpsCertificato;
import org.openspcoop2.core.config.rs.server.model.AuthenticationHttpsConfigurazioneManuale;
import org.openspcoop2.core.config.rs.server.model.AuthenticationPrincipal;
import org.openspcoop2.core.config.rs.server.model.AuthenticationToken;
import org.openspcoop2.core.config.rs.server.model.AuthenticationTokenBase;
import org.openspcoop2.core.config.rs.server.model.ModalitaAccessoEnum;
import org.openspcoop2.core.config.rs.server.model.OneOfBaseCredenzialiCredenziali;
import org.openspcoop2.core.config.rs.server.model.TipoAutenticazioneHttps;
import org.openspcoop2.core.config.rs.server.model.TipoKeystore;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.CredenzialiSoggetto;
import org.openspcoop2.core.registry.beans.AccordoServizioParteComuneSintetico;
import org.openspcoop2.core.registry.constants.ServiceBinding;
import org.openspcoop2.core.registry.constants.StatoFunzionalita;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.ArchiveLoader;
import org.openspcoop2.utils.certificate.ArchiveType;
import org.openspcoop2.utils.certificate.CertificateInfo;
import org.openspcoop2.utils.mime.MimeTypes;
import org.openspcoop2.utils.service.beans.Lista;
import org.openspcoop2.utils.service.beans.ProfiloEnum;
import org.openspcoop2.utils.service.beans.utils.BaseHelper;
import org.openspcoop2.utils.service.context.IContext;
import org.openspcoop2.utils.service.fault.jaxrs.FaultCode;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.servlet.ConsoleHelper;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneCore;
import org.openspcoop2.web.ctrlstat.servlet.connettori.ConnettoriCostanti;
import org.openspcoop2.web.lib.mvc.BinaryParameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;

public class Helper
extends BaseHelper {
    public static final Map<CredenzialeTipo, ModalitaAccessoEnum> modalitaAccessoFromCredenzialeTipo = new HashMap<CredenzialeTipo, ModalitaAccessoEnum>();
    public static final Map<ModalitaAccessoEnum, CredenzialeTipo> credenzialeTipoFromModalitaAccesso;
    public static final Map<ModalitaAccessoEnum, String> tipoAuthFromModalitaAccesso;
    public static final Map<String, String> tipoAuthSAFromModalita;

    public static <T extends Lista> T returnOrNotFound(T ret) throws UtilsException {
        boolean throwIfEmpty = ServerProperties.getInstance().isFindall404();
        if ((ret == null || ret.getTotal() <= 0L) && throwIfEmpty) {
            throw FaultCode.NOT_FOUND.toException("Nessun elemento corrisponde ai criteri di ricerca");
        }
        return ret;
    }

    public static final <E1 extends Enum<E1>, E2 extends Enum<E2>> E2 apiEnumToGovway(E1 aenum, Class<E2> toClass) {
        try {
            return Enum.valueOf(toClass, aenum.name());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ProfiloEnum getProfiloDefault() throws UtilsException {
        ServerProperties serverProperties = ServerProperties.getInstance();
        return (ProfiloEnum)profiloFromTipoProtocollo.get(serverProperties.getProtocolloDefault());
    }

    public static String getProtocolloOrDefault(ProfiloEnum profilo) throws UtilsException {
        ServerProperties serverProperties = ServerProperties.getInstance();
        String tipo_protocollo = null;
        String modalita = profilo != null ? profilo.toString() : null;
        tipo_protocollo = modalita == null || modalita.length() == 0 ? serverProperties.getProtocolloDefault() : (String)tipoProtocolloFromProfilo.get(profilo);
        if (tipo_protocollo == null) {
            StringBuilder sb = new StringBuilder("Impossible recuperare il profilo di interoperabilit\u00e0 dalla modalit\u00e0: ");
            sb.append(modalita);
            throw FaultCode.RICHIESTA_NON_VALIDA.toException(sb.toString());
        }
        return tipo_protocollo;
    }

    public static final String getSoggettoOrDefault(String soggetto, ProfiloEnum profilo) throws UtilsException {
        if (soggetto == null || soggetto.length() == 0) {
            ServerProperties serverProperties = ServerProperties.getInstance();
            soggetto = serverProperties.getSoggettoDefault(profilo != null ? profilo.toString() : null);
        }
        return soggetto;
    }

    public static void overrideAuthParams(HttpRequestWrapper wrap, ConsoleHelper consoleHelper, OneOfBaseCredenzialiCredenziali credenziali, ApiKeyInfo apiKeyInfo, boolean updateKey) {
        ModalitaAccessoEnum modalitaAccesso = credenziali.getModalitaAccesso();
        if (modalitaAccesso == null) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException("Modalit\u00e0 di accesso delle credenziali non indicata");
        }
        switch (modalitaAccesso) {
            case HTTP_BASIC: {
                if (!(credenziali instanceof AuthenticationHttpBasic)) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Credenziali '" + credenziali.getClass().getName() + "' non compatibili con la modalit\u00e0 '+" + modalitaAccesso.toString() + "+'");
                }
                AuthenticationHttpBasic c = (AuthenticationHttpBasic)credenziali;
                wrap.overrideParameter("utenteCredenziali", c.getUsername());
                wrap.overrideParameter("passwordCredenziali", c.getPassword());
                if (c.getPassword() == null || !StringUtils.isNotEmpty((String)c.getPassword())) break;
                wrap.overrideParameter("changepwd", "config_enable");
                break;
            }
            case API_KEY: {
                if (!(credenziali instanceof AuthenticationApiKey)) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Credenziali '" + credenziali.getClass().getName() + "' non compatibili con la modalit\u00e0 '+" + modalitaAccesso.toString() + "+'");
                }
                AuthenticationApiKey c = (AuthenticationApiKey)credenziali;
                boolean appId = Helper.isAppId(c.isAppId());
                wrap.overrideParameter("apiKeyMultipleCred", appId ? "config_enable" : "config_disable");
                wrap.overrideParameter("appIdCred", apiKeyInfo.getAppId());
                wrap.overrideParameter("apiKeyCred", apiKeyInfo.getApiKey());
                wrap.overrideParameter("passwordCredenziali", apiKeyInfo.getPassword());
                if (!updateKey) break;
                wrap.overrideParameter("changepwd", "config_enable");
                break;
            }
            case HTTPS: {
                if (!(credenziali instanceof AuthenticationHttps)) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Credenziali '" + credenziali.getClass().getName() + "' non compatibili con la modalit\u00e0 '+" + modalitaAccesso.toString() + "+'");
                }
                AuthenticationHttps c = (AuthenticationHttps)credenziali;
                wrap.overrideParameter("confSSLCredWizStep", "0");
                switch (c.getCertificato().getTipo()) {
                    case CERTIFICATO: {
                        if (c.getCertificato() instanceof AuthenticationHttpsCertificato) {
                            wrap.overrideParameter("confSSLCredenziali", "uploadCert");
                            AuthenticationHttpsCertificato certificate = (AuthenticationHttpsCertificato)c.getCertificato();
                            consoleHelper.registerBinaryParameter("confSSLCredFileCert", certificate.getArchivio());
                            wrap.overrideParameter("confSSLCredTipoArch", certificate.getTipoCertificato().toString());
                            wrap.overrideParameter("confSSLCredAliasCert", certificate.getAlias());
                            wrap.overrideParameter("confSSLCredFileCertPwd", certificate.getPassword());
                            wrap.overrideParameter("confSSLCredVerifTutti", certificate.isStrictVerification() != false ? "yes" : "config_disable");
                            break;
                        }
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("Certificato fornito '" + c.getCertificato().getClass().getName() + "' non compatibile con il tipo '" + c.getCertificato().getTipo() + "' ");
                    }
                    case CONFIGURAZIONE_MANUALE: {
                        if (c.getCertificato() instanceof AuthenticationHttpsConfigurazioneManuale) {
                            wrap.overrideParameter("confSSLCredenziali", "confMan");
                            AuthenticationHttpsConfigurazioneManuale creManuale = (AuthenticationHttpsConfigurazioneManuale)c.getCertificato();
                            wrap.overrideParameter("subjectCredenziali", creManuale.getSubject());
                            wrap.overrideParameter("subjectIssuer", creManuale.getIssuer());
                            break;
                        }
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("Certificato fornito '" + c.getCertificato().getClass().getName() + "' non compatibile con il tipo '" + c.getCertificato().getTipo() + "' ");
                    }
                }
                if (c.getToken() == null) break;
                wrap.overrideParameter("tokenClientIdCred", c.getToken().getIdentificativo());
                wrap.overrideParameter("tokenPolicyCred", c.getToken().getTokenPolicy());
                break;
            }
            case PRINCIPAL: {
                if (!(credenziali instanceof AuthenticationPrincipal)) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Credenziali '" + credenziali.getClass().getName() + "' non compatibili con la modalit\u00e0 '+" + modalitaAccesso.toString() + "+'");
                }
                AuthenticationPrincipal c = (AuthenticationPrincipal)credenziali;
                wrap.overrideParameter("principalCredenziali", c.getUserid());
                break;
            }
            case TOKEN: {
                if (!(credenziali instanceof AuthenticationToken)) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Credenziali '" + credenziali.getClass().getName() + "' non compatibili con la modalit\u00e0 '+" + modalitaAccesso.toString() + "+'");
                }
                AuthenticationToken c = (AuthenticationToken)credenziali;
                wrap.overrideParameter("tokenClientIdCred", c.getIdentificativo());
                wrap.overrideParameter("tokenPolicyCred", c.getTokenPolicy());
                break;
            }
        }
    }

    public static OneOfBaseCredenzialiCredenziali translateCredenziali(OneOfBaseCredenzialiCredenziali creds, boolean create) {
        if (creds == null || creds.getModalitaAccesso() == null) {
            return null;
        }
        OneOfBaseCredenzialiCredenziali ret = null;
        ModalitaAccessoEnum tipoAuth = creds.getModalitaAccesso();
        switch (tipoAuth) {
            case HTTP_BASIC: {
                OneOfBaseCredenzialiCredenziali basic;
                ret = (AuthenticationHttpBasic)creds;
                if (!create || ((AuthenticationHttpBasic)(basic = ret)).getPassword() != null && !StringUtils.isEmpty((String)((AuthenticationHttpBasic)basic).getPassword())) break;
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Nell'operazione richiesta \u00e8 obbligatorio indicare la password per il tipo di autenticazione '" + tipoAuth + "'");
            }
            case HTTPS: {
                ret = (AuthenticationHttps)creds;
                break;
            }
            case PRINCIPAL: {
                ret = (AuthenticationPrincipal)creds;
                break;
            }
            case API_KEY: {
                ret = (AuthenticationApiKey)creds;
                break;
            }
            case TOKEN: {
                ret = (AuthenticationToken)creds;
                break;
            }
            default: {
                ret = null;
            }
        }
        return ret;
    }

    public static <T, E> List<T> apiCredenzialiToGovwayCred(Object creds, ModalitaAccessoEnum tipoAuth, Class<T> credClass, Class<E> enumClass, ApiKeyInfo keyInfo) throws IllegalAccessException, InvocationTargetException, InstantiationException, UtilsException {
        if (!enumClass.isEnum()) {
            throw new IllegalArgumentException("Il parametro enumClass deve essere un'enumerazione");
        }
        ArrayList<Object> lstRet = new ArrayList<Object>();
        Object ret = Utilities.newInstance(credClass);
        switch (tipoAuth) {
            case HTTP_BASIC: {
                if (!(creds instanceof AuthenticationHttpBasic)) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Credenziali '" + creds.getClass().getName() + "' non compatibili con la modalit\u00e0 '+" + tipoAuth.toString() + "+'");
                }
                AuthenticationHttpBasic auth = (AuthenticationHttpBasic)creds;
                BeanUtils.setProperty((Object)ret, (String)"tipo", Enum.valueOf(enumClass, "BASIC"));
                BeanUtils.setProperty((Object)ret, (String)"user", (Object)auth.getUsername());
                BeanUtils.setProperty((Object)ret, (String)"password", (Object)auth.getPassword());
                lstRet.add(ret);
                break;
            }
            case HTTPS: {
                if (!(creds instanceof AuthenticationHttps)) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Credenziali '" + creds.getClass().getName() + "' non compatibili con la modalit\u00e0 '+" + tipoAuth.toString() + "+'");
                }
                AuthenticationHttps auth = (AuthenticationHttps)creds;
                BeanUtils.setProperty((Object)ret, (String)"tipo", Enum.valueOf(enumClass, "SSL"));
                switch (auth.getCertificato().getTipo()) {
                    case CERTIFICATO: {
                        AuthenticationHttpsCertificato cre = (AuthenticationHttpsCertificato)auth.getCertificato();
                        ArchiveType type = ArchiveType.CER;
                        String alias = cre.getAlias();
                        String password = cre.getPassword();
                        if (cre.getTipoCertificato() != null) {
                            type = ArchiveType.valueOf((String)cre.getTipoCertificato().toString());
                        }
                        CertificateInfo cInfo = ArchiveLoader.load((ArchiveType)type, (byte[])cre.getArchivio(), (String)alias, (String)password).getCertificate();
                        BeanUtils.setProperty((Object)ret, (String)"certificate", (Object)cre.getArchivio());
                        BeanUtils.setProperty((Object)ret, (String)"certificateStrictVerification", (Object)cre.isStrictVerification());
                        BeanUtils.setProperty((Object)ret, (String)"cnSubject", (Object)cInfo.getSubject().getCN());
                        BeanUtils.setProperty((Object)ret, (String)"cnIssuer", (Object)cInfo.getIssuer().getCN());
                        lstRet.add(ret);
                        List<AuthenticationHttpsBaseCertificato> certificati = auth.getCertificati();
                        if (certificati == null || certificati.size() <= 0) break;
                        for (AuthenticationHttpsBaseCertificato secondaryCre : certificati) {
                            Object cert = Utilities.newInstance(credClass);
                            BeanUtils.setProperty((Object)cert, (String)"tipo", Enum.valueOf(enumClass, "SSL"));
                            ArchiveType secondaryType = ArchiveType.CER;
                            String secondaryAlias = secondaryCre.getAlias();
                            String secondaryPassword = secondaryCre.getPassword();
                            if (secondaryCre.getTipoCertificato() != null) {
                                secondaryType = ArchiveType.valueOf((String)secondaryCre.getTipoCertificato().toString());
                            }
                            CertificateInfo secondaryCInfo = ArchiveLoader.load((ArchiveType)secondaryType, (byte[])secondaryCre.getArchivio(), (String)secondaryAlias, (String)secondaryPassword).getCertificate();
                            BeanUtils.setProperty((Object)cert, (String)"certificate", (Object)secondaryCre.getArchivio());
                            BeanUtils.setProperty((Object)cert, (String)"certificateStrictVerification", (Object)secondaryCre.isStrictVerification());
                            BeanUtils.setProperty((Object)cert, (String)"cnSubject", (Object)secondaryCInfo.getSubject().getCN());
                            BeanUtils.setProperty((Object)cert, (String)"cnIssuer", (Object)secondaryCInfo.getIssuer().getCN());
                            lstRet.add(cert);
                        }
                        break;
                    }
                    case CONFIGURAZIONE_MANUALE: {
                        AuthenticationHttpsConfigurazioneManuale creManuale = (AuthenticationHttpsConfigurazioneManuale)auth.getCertificato();
                        BeanUtils.setProperty((Object)ret, (String)"subject", (Object)creManuale.getSubject());
                        BeanUtils.setProperty((Object)ret, (String)"issuer", (Object)creManuale.getIssuer());
                        lstRet.add(ret);
                    }
                }
                if (auth.getToken() == null) break;
                BeanUtils.setProperty((Object)ret, (String)"user", (Object)auth.getToken().getIdentificativo());
                BeanUtils.setProperty((Object)ret, (String)"tokenPolicy", (Object)auth.getToken().getTokenPolicy());
                break;
            }
            case PRINCIPAL: {
                if (!(creds instanceof AuthenticationPrincipal)) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Credenziali '" + creds.getClass().getName() + "' non compatibili con la modalit\u00e0 '+" + tipoAuth.toString() + "+'");
                }
                AuthenticationPrincipal auth = (AuthenticationPrincipal)creds;
                BeanUtils.setProperty((Object)ret, (String)"tipo", Enum.valueOf(enumClass, "PRINCIPAL"));
                BeanUtils.setProperty((Object)ret, (String)"user", (Object)auth.getUserid());
                lstRet.add(ret);
                break;
            }
            case API_KEY: {
                if (!(creds instanceof AuthenticationApiKey)) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Credenziali '" + creds.getClass().getName() + "' non compatibili con la modalit\u00e0 '+" + tipoAuth.toString() + "+'");
                }
                if (keyInfo == null) {
                    throw new UtilsException("KeyInfo unavailable");
                }
                AuthenticationApiKey auth = (AuthenticationApiKey)creds;
                BeanUtils.setProperty((Object)ret, (String)"tipo", Enum.valueOf(enumClass, "APIKEY"));
                BeanUtils.setProperty((Object)ret, (String)"user", (Object)keyInfo.getAppId());
                BeanUtils.setProperty((Object)ret, (String)"password", (Object)keyInfo.getPassword());
                boolean appId = Helper.isAppId(auth.isAppId());
                BeanUtils.setProperty((Object)ret, (String)"appId", (Object)appId);
                BeanUtils.setProperty((Object)ret, (String)"certificateStrictVerification", (Object)keyInfo.isCifrata());
                lstRet.add(ret);
                break;
            }
            case TOKEN: {
                if (!(creds instanceof AuthenticationToken)) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Credenziali '" + creds.getClass().getName() + "' non compatibili con la modalit\u00e0 '+" + tipoAuth.toString() + "+'");
                }
                AuthenticationToken auth = (AuthenticationToken)creds;
                BeanUtils.setProperty((Object)ret, (String)"tipo", Enum.valueOf(enumClass, "TOKEN"));
                BeanUtils.setProperty((Object)ret, (String)"user", (Object)auth.getIdentificativo());
                BeanUtils.setProperty((Object)ret, (String)"tokenPolicy", (Object)auth.getTokenPolicy());
                lstRet.add(ret);
                break;
            }
            default: {
                BeanUtils.setProperty((Object)ret, (String)"tipo", null);
                lstRet.add(ret);
            }
        }
        return lstRet;
    }

    public static final <T, E> OneOfBaseCredenzialiCredenziali govwayCredenzialiToApi(List<?> govwayCredsList, Class<T> credClass, Class<E> enumClass) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (!enumClass.isEnum()) {
            throw new IllegalArgumentException("Il parametro enumClass deve essere un'enumerazione");
        }
        OneOfBaseCredenzialiCredenziali ret = null;
        if (govwayCredsList == null || govwayCredsList.isEmpty()) {
            return ret;
        }
        Object govwayCreds = govwayCredsList.get(0);
        String tipo = BeanUtils.getProperty(govwayCreds, (String)"tipo");
        if ("basic".equals(tipo)) {
            AuthenticationHttpBasic auth = new AuthenticationHttpBasic();
            auth.setUsername(BeanUtils.getProperty(govwayCreds, (String)"user"));
            Method mCertificateStrictVerification = credClass.getMethod("isCertificateStrictVerification", new Class[0]);
            boolean cifrata = (Boolean)mCertificateStrictVerification.invoke(govwayCreds, new Object[0]);
            if (!cifrata) {
                auth.setPassword(BeanUtils.getProperty(govwayCreds, (String)"password"));
            }
            auth.setModalitaAccesso(ModalitaAccessoEnum.HTTP_BASIC);
            ret = auth;
        } else if ("ssl".equals(tipo)) {
            String credenzialiSoggettoClassName;
            AuthenticationHttps auth = new AuthenticationHttps();
            Method mCertificate = credClass.getMethod("getCertificate", new Class[0]);
            Object oCertificate = mCertificate.invoke(govwayCreds, new Object[0]);
            if (oCertificate == null) {
                AuthenticationHttpsConfigurazioneManuale manuale = new AuthenticationHttpsConfigurazioneManuale();
                manuale.setTipo(TipoAutenticazioneHttps.CONFIGURAZIONE_MANUALE);
                manuale.setSubject(BeanUtils.getProperty(govwayCreds, (String)"subject"));
                manuale.setIssuer(BeanUtils.getProperty(govwayCreds, (String)"issuer"));
                auth.setCertificato(manuale);
            } else {
                AuthenticationHttpsCertificato certificato = new AuthenticationHttpsCertificato();
                certificato.setTipo(TipoAutenticazioneHttps.CERTIFICATO);
                certificato.setTipoCertificato(TipoKeystore.CER);
                certificato.setArchivio((byte[])oCertificate);
                Method mCertificateStrictVerification = credClass.getMethod("isCertificateStrictVerification", new Class[0]);
                certificato.setStrictVerification((Boolean)mCertificateStrictVerification.invoke(govwayCreds, new Object[0]));
                auth.setCertificato(certificato);
            }
            auth.setModalitaAccesso(ModalitaAccessoEnum.HTTPS);
            if (govwayCredsList.size() > 1) {
                ArrayList<AuthenticationHttpsBaseCertificato> certificati = new ArrayList<AuthenticationHttpsBaseCertificato>();
                for (int i = 1; i < govwayCredsList.size(); ++i) {
                    Object govwayCredsCertificato = govwayCredsList.get(i);
                    AuthenticationHttpsBaseCertificato certificato = new AuthenticationHttpsBaseCertificato();
                    certificato.setTipoCertificato(TipoKeystore.CER);
                    Object oCertificateCertificato = mCertificate.invoke(govwayCredsCertificato, new Object[0]);
                    certificato.setArchivio((byte[])oCertificateCertificato);
                    Method mCertificateStrictVerification = credClass.getMethod("isCertificateStrictVerification", new Class[0]);
                    certificato.setStrictVerification((Boolean)mCertificateStrictVerification.invoke(govwayCredsCertificato, new Object[0]));
                    certificati.add(certificato);
                }
                auth.setCertificati(certificati);
            }
            if (!(credenzialiSoggettoClassName = CredenzialiSoggetto.class.getName()).equals(credClass.getName())) {
                String identificativo = BeanUtils.getProperty(govwayCreds, (String)"user");
                String tokenPolicy = BeanUtils.getProperty(govwayCreds, (String)"tokenPolicy");
                if (tokenPolicy != null && identificativo != null) {
                    AuthenticationTokenBase modiToken = new AuthenticationTokenBase();
                    modiToken.setIdentificativo(identificativo);
                    modiToken.setTokenPolicy(tokenPolicy);
                    auth.setToken(modiToken);
                }
            }
            ret = auth;
        } else if ("principal".equals(tipo)) {
            AuthenticationPrincipal auth = new AuthenticationPrincipal();
            auth.setUserid(BeanUtils.getProperty(govwayCreds, (String)"user"));
            auth.setModalitaAccesso(ModalitaAccessoEnum.PRINCIPAL);
            ret = auth;
        } else if ("apikey".equals(tipo)) {
            AuthenticationApiKey auth = new AuthenticationApiKey();
            Method mAppId = credClass.getMethod("isAppId", new Class[0]);
            boolean appId = (Boolean)mAppId.invoke(govwayCreds, new Object[0]);
            auth.setAppId(appId);
            auth.setModalitaAccesso(ModalitaAccessoEnum.API_KEY);
            ret = auth;
        } else if ("token".equals(tipo)) {
            AuthenticationToken auth = new AuthenticationToken();
            auth.setIdentificativo(BeanUtils.getProperty(govwayCreds, (String)"user"));
            auth.setTokenPolicy(BeanUtils.getProperty(govwayCreds, (String)"tokenPolicy"));
            auth.setModalitaAccesso(ModalitaAccessoEnum.TOKEN);
            ret = auth;
        }
        return ret;
    }

    public static final ModalitaAccessoEnum credenzialiToModalita(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof AuthenticationHttpBasic) {
            return ModalitaAccessoEnum.HTTP_BASIC;
        }
        if (obj instanceof AuthenticationHttps) {
            return ModalitaAccessoEnum.HTTPS;
        }
        if (obj instanceof AuthenticationPrincipal) {
            return ModalitaAccessoEnum.PRINCIPAL;
        }
        throw new IllegalArgumentException("credenzialiToModalita(): Tipo argomento sconosciuto");
    }

    public static final ConsoleSearch setupRicercaPaginata(String q, Integer limit, Integer offset, int idLista) {
        ConsoleSearch ricerca = new ConsoleSearch();
        if (limit != null && limit != 0) {
            ricerca.setPageSize(idLista, limit.intValue());
        }
        if (offset != null) {
            ricerca.setIndexIniziale(idLista, offset.intValue());
        }
        if (q == null) {
            q = "";
        }
        if ((q = q.trim()).equals("")) {
            ricerca.setSearchString(idLista, "undefined");
        } else {
            ricerca.setSearchString(idLista, q);
        }
        return ricerca;
    }

    public static final ConsoleSearch setupRicercaPaginata(String q, Integer limit, Integer offset, int idLista, IDSoggetto idSoggetto, String tipo_protocollo) {
        ConsoleSearch ricerca = Helper.setupRicercaPaginata(q, limit, offset, idLista);
        ricerca.addFilter(idLista, "filtroSoggetto", idSoggetto.toString());
        ricerca.addFilter(idLista, "filtroProtocollo", tipo_protocollo);
        return ricerca;
    }

    public static final boolean statoFunzionalitaToBool(StatoFunzionalita sf) {
        if (sf == null) {
            return false;
        }
        switch (sf) {
            case ABILITATO: {
                return true;
            }
            case DISABILITATO: {
                return false;
            }
        }
        return false;
    }

    public static final boolean statoFunzionalitaConfToBool(org.openspcoop2.core.config.constants.StatoFunzionalita sf) {
        if (sf == null) {
            return false;
        }
        switch (sf) {
            case ABILITATO: {
                return true;
            }
            case DISABILITATO: {
                return false;
            }
        }
        return false;
    }

    @Deprecated
    public static final String boolToYesNo(boolean v) {
        return ServletUtils.boolToCheckBoxStatus((Boolean)v);
    }

    public static final StatoFunzionalita boolToStatoFunzionalita(Boolean v) {
        return v != false ? StatoFunzionalita.ABILITATO : StatoFunzionalita.DISABILITATO;
    }

    public static final org.openspcoop2.core.config.constants.StatoFunzionalita boolToStatoFunzionalitaConf(Boolean v) {
        if (v == null) {
            v = false;
        }
        return v != false ? org.openspcoop2.core.config.constants.StatoFunzionalita.ABILITATO : org.openspcoop2.core.config.constants.StatoFunzionalita.DISABILITATO;
    }

    public static final BinaryParameter toBinaryParameter(byte[] value) {
        BinaryParameter ret = new BinaryParameter();
        ret.setValue(value);
        return ret;
    }

    public static final AccordoServizioParteComune getAccordoFull(String nome, int versione, IDSoggetto idSoggReferente, AccordiServizioParteComuneCore apcCore) {
        return (AccordoServizioParteComune)Helper.evalnull(() -> apcCore.getAccordoServizioFull(IDAccordoFactory.getInstance().getIDAccordoFromValues(nome, idSoggReferente, Integer.valueOf(versione))));
    }

    public static final AccordoServizioParteComuneSintetico getAccordoSintetico(String nome, int versione, IDSoggetto idSoggReferente, AccordiServizioParteComuneCore apcCore) {
        return (AccordoServizioParteComuneSintetico)Helper.evalnull(() -> apcCore.getAccordoServizioSintetico(IDAccordoFactory.getInstance().getIDAccordoFromValues(nome, idSoggReferente, Integer.valueOf(versione))));
    }

    public static final org.openspcoop2.protocol.manifest.constants.ServiceBinding toManifestServiceBinding(ServiceBinding serviceBinding) {
        switch (serviceBinding) {
            case REST: {
                return org.openspcoop2.protocol.manifest.constants.ServiceBinding.REST;
            }
            case SOAP: {
                return org.openspcoop2.protocol.manifest.constants.ServiceBinding.SOAP;
            }
        }
        return null;
    }

    public static void setContentType(IContext context, String fileName) throws UtilsException {
        String mimeType = null;
        if (fileName.contains(".")) {
            String ext = null;
            try {
                ext = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length());
            }
            catch (Exception exception) {
                // empty catch block
            }
            MimeTypes mimeTypes = MimeTypes.getInstance();
            mimeType = ext != null && mimeTypes.existsExtension(ext) ? mimeTypes.getMimeType(ext) : "application/x-download";
        } else {
            mimeType = "application/x-download";
        }
        context.getServletResponse().setContentType(mimeType);
    }

    public static boolean isAppId(Boolean appIdObject) {
        boolean appId = false;
        if (appIdObject != null) {
            appId = appIdObject;
        }
        return appId;
    }

    static {
        modalitaAccessoFromCredenzialeTipo.put(CredenzialeTipo.BASIC, ModalitaAccessoEnum.HTTP_BASIC);
        modalitaAccessoFromCredenzialeTipo.put(CredenzialeTipo.PRINCIPAL, ModalitaAccessoEnum.PRINCIPAL);
        modalitaAccessoFromCredenzialeTipo.put(CredenzialeTipo.SSL, ModalitaAccessoEnum.HTTPS);
        modalitaAccessoFromCredenzialeTipo.put(CredenzialeTipo.APIKEY, ModalitaAccessoEnum.API_KEY);
        modalitaAccessoFromCredenzialeTipo.put(CredenzialeTipo.TOKEN, ModalitaAccessoEnum.TOKEN);
        credenzialeTipoFromModalitaAccesso = new HashMap<ModalitaAccessoEnum, CredenzialeTipo>();
        modalitaAccessoFromCredenzialeTipo.forEach((cred, mod) -> credenzialeTipoFromModalitaAccesso.put((ModalitaAccessoEnum)((Object)mod), (CredenzialeTipo)cred));
        tipoAuthFromModalitaAccesso = new HashMap<ModalitaAccessoEnum, String>();
        tipoAuthFromModalitaAccesso.put(ModalitaAccessoEnum.HTTPS, ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL);
        tipoAuthFromModalitaAccesso.put(ModalitaAccessoEnum.HTTP_BASIC, ConnettoriCostanti.AUTENTICAZIONE_TIPO_BASIC);
        tipoAuthFromModalitaAccesso.put(ModalitaAccessoEnum.PRINCIPAL, ConnettoriCostanti.AUTENTICAZIONE_TIPO_PRINCIPAL);
        tipoAuthFromModalitaAccesso.put(ModalitaAccessoEnum.API_KEY, ConnettoriCostanti.AUTENTICAZIONE_TIPO_APIKEY);
        tipoAuthFromModalitaAccesso.put(ModalitaAccessoEnum.TOKEN, ConnettoriCostanti.AUTENTICAZIONE_TIPO_TOKEN);
        tipoAuthFromModalitaAccesso.put(null, "nessuna");
        tipoAuthSAFromModalita = Stream.of(new AbstractMap.SimpleEntry<String, String>("http-basic", ConnettoriCostanti.AUTENTICAZIONE_TIPO_BASIC), new AbstractMap.SimpleEntry<String, String>("https", ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL), new AbstractMap.SimpleEntry<String, String>("principal", ConnettoriCostanti.AUTENTICAZIONE_TIPO_PRINCIPAL), new AbstractMap.SimpleEntry<String, String>("api-key", ConnettoriCostanti.AUTENTICAZIONE_TIPO_APIKEY), new AbstractMap.SimpleEntry<String, String>("token", ConnettoriCostanti.AUTENTICAZIONE_TIPO_TOKEN), new AbstractMap.SimpleEntry<String, String>("custom", "nessuna")).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }
}

