/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.rs.server.api.impl.applicativi_server;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringEscapeUtils;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.Connettore;
import org.openspcoop2.core.config.InvocazioneCredenziali;
import org.openspcoop2.core.config.InvocazioneServizio;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.constants.InvocazioneServizioTipoAutenticazione;
import org.openspcoop2.core.config.rs.server.api.ApplicativiServerApi;
import org.openspcoop2.core.config.rs.server.api.impl.Helper;
import org.openspcoop2.core.config.rs.server.api.impl.HttpRequestWrapper;
import org.openspcoop2.core.config.rs.server.api.impl.applicativi.ApplicativiApiHelper;
import org.openspcoop2.core.config.rs.server.api.impl.applicativi.ApplicativiEnv;
import org.openspcoop2.core.config.rs.server.api.impl.erogazioni.ConnettoreAPIHelper;
import org.openspcoop2.core.config.rs.server.api.impl.erogazioni.ErogazioniEnv;
import org.openspcoop2.core.config.rs.server.config.ServerProperties;
import org.openspcoop2.core.config.rs.server.model.ApplicativoServer;
import org.openspcoop2.core.config.rs.server.model.ConnettoreConfigurazioneHttpBasic;
import org.openspcoop2.core.config.rs.server.model.ConnettoreEnum;
import org.openspcoop2.core.config.rs.server.model.ConnettoreHttp;
import org.openspcoop2.core.config.rs.server.model.ListaApplicativiServer;
import org.openspcoop2.core.config.rs.server.model.Proprieta4000;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.utils.service.BaseImpl;
import org.openspcoop2.utils.service.authorization.AuthorizationConfig;
import org.openspcoop2.utils.service.authorization.AuthorizationManager;
import org.openspcoop2.utils.service.beans.ProfiloEnum;
import org.openspcoop2.utils.service.beans.utils.BaseHelper;
import org.openspcoop2.utils.service.beans.utils.ListaUtils;
import org.openspcoop2.utils.service.context.IContext;
import org.openspcoop2.utils.service.fault.jaxrs.FaultCode;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.servlet.ConsoleHelper;
import org.openspcoop2.web.ctrlstat.servlet.sa.ServiziApplicativiCore;
import org.openspcoop2.web.ctrlstat.servlet.sa.ServiziApplicativiGeneralInfo;
import org.openspcoop2.web.ctrlstat.servlet.sa.ServiziApplicativiHelper;
import org.openspcoop2.web.ctrlstat.servlet.sa.ServiziApplicativiUtilities;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.LoggerFactory;

public class ApplicativiServerApiServiceImpl
extends BaseImpl
implements ApplicativiServerApi {
    public ApplicativiServerApiServiceImpl() {
        super(LoggerFactory.getLogger(ApplicativiServerApiServiceImpl.class));
    }

    private AuthorizationConfig getAuthorizationConfig() throws Exception {
        return new AuthorizationConfig(ServerProperties.getInstance().getProperties());
    }

    @Override
    public void createApplicativoServer(ApplicativoServer body, ProfiloEnum profilo, String soggetto) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            ApplicativoServer applicativo = body;
            HttpRequestWrapper wrap = new HttpRequestWrapper(context.getServletRequest());
            ApplicativiEnv env = new ApplicativiEnv((HttpServletRequest)wrap, profilo, soggetto, context);
            ErogazioniEnv erogEnv = new ErogazioniEnv((HttpServletRequest)wrap, profilo, soggetto, context);
            String protocollo = env.protocolFactory.getProtocol();
            String tipo_soggetto = (String)ProtocolFactoryManager.getInstance().getDefaultOrganizationTypes().get((Object)protocollo);
            IDSoggetto idSoggetto = new IDSoggetto(tipo_soggetto, env.idSoggetto.getNome());
            IDServizioApplicativo idSA = new IDServizioApplicativo();
            idSA.setIdSoggettoProprietario(idSoggetto);
            idSA.setNome(applicativo.getNome());
            ServizioApplicativo sa = ApplicativiApiHelper.applicativoToServizioApplicativo(applicativo, env.tipo_protocollo, env.idSoggetto.getNome(), env.stationCore);
            if (ApplicativiApiHelper.isApplicativoDuplicato(sa, env.saCore)) {
                throw FaultCode.CONFLITTO.toException("Applicativo server " + sa.getNome() + " gi\u00e0 registrato per il soggetto scelto.");
            }
            ApplicativiApiHelper.overrideSAParametersApplicativoServer(env.requestWrapper, (ConsoleHelper)env.saHelper, sa, false);
            wrap.overrideParameter("protocollo", env.tipo_protocollo);
            List listaTipiProtocollo = ProtocolFactoryManager.getInstance().getProtocolNamesAsList();
            IDSoggetto soggettoMultitenantSelezionato = new IDSoggetto(env.idSoggetto.getTipo(), env.idSoggetto.getNome());
            String dominio = null;
            if (!env.isDominioInterno(idSoggetto)) {
                if (profilo != null && !profilo.equals((Object)ProfiloEnum.MODI) && !profilo.equals((Object)ProfiloEnum.MODIPA)) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Impossibile creare un applicativo per un soggetto esterno col profilo [" + profilo + "]");
                }
                dominio = "esterno";
            }
            ServiziApplicativiGeneralInfo generalInfo = ServiziApplicativiUtilities.getGeneralInfo((boolean)false, (String)env.idSoggetto.getId().toString(), (List)listaTipiProtocollo, (ServiziApplicativiCore)env.saCore, (ServiziApplicativiHelper)env.saHelper, (String)env.userLogin, (boolean)true, (String)soggettoMultitenantSelezionato.toString(), (String)dominio);
            List listExtendedConnettore = null;
            InvocazioneServizio is = sa.getInvocazioneServizio();
            InvocazioneCredenziali credenziali_is = is.getCredenziali();
            Connettore connis = is.getConnettore();
            String oldConnT = connis.getTipo();
            if (connis.getCustom() != null && connis.getCustom().booleanValue() && !connis.getTipo().equals(TipiConnettore.HTTPS.toString()) && !connis.getTipo().equals(TipiConnettore.FILE.toString()) && !connis.getTipo().equals(TipiConnettore.STATUS.toString())) {
                oldConnT = TipiConnettore.CUSTOM.toString();
            }
            if (!ConnettoreAPIHelper.connettoreCheckData(body.getConnettore(), erogEnv, true)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml((String)env.pd.getMessage()));
            }
            ConnettoreAPIHelper.fillConnettoreConfigurazione(sa, erogEnv, body.getConnettore(), oldConnT);
            if (body.getConnettore().getTipo().equals((Object)ConnettoreEnum.HTTP) && ((ConnettoreHttp)body.getConnettore()).getAutenticazioneHttp() != null) {
                if (credenziali_is == null) {
                    credenziali_is = new InvocazioneCredenziali();
                }
                ConnettoreConfigurazioneHttpBasic authHttp = ((ConnettoreHttp)body.getConnettore()).getAutenticazioneHttp();
                credenziali_is.setUser(authHttp.getUsername());
                credenziali_is.setPassword(authHttp.getPassword());
                is.setCredenziali(credenziali_is);
                is.setAutenticazione(InvocazioneServizioTipoAutenticazione.BASIC);
            } else {
                is.setCredenziali(null);
                is.setAutenticazione(InvocazioneServizioTipoAutenticazione.NONE);
            }
            is.setConnettore(connis);
            sa.setInvocazioneServizio(is);
            if (!env.saHelper.servizioApplicativoCheckData(TipoOperazione.ADD, generalInfo.getSoggettiList(), -1L, sa.getTipologiaFruizione(), sa.getTipologiaErogazione(), listExtendedConnettore, sa, new StringBuilder())) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml((String)env.pd.getMessage()));
            }
            env.saCore.performCreateOperation(env.userLogin, false, new Object[]{sa});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            context.getServletResponse().setStatus(201);
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void deleteApplicativoServer(String nome, ProfiloEnum profilo, String soggetto) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ApplicativiEnv env = new ApplicativiEnv(context.getServletRequest(), profilo, soggetto, context);
            IDServizioApplicativo idServizioApplicativo = null;
            ServizioApplicativo sa = null;
            try {
                idServizioApplicativo = new IDServizioApplicativo();
                idServizioApplicativo.setIdSoggettoProprietario(env.idSoggetto.toIDSoggetto());
            }
            catch (Exception e) {
                throw FaultCode.NOT_FOUND.toException("Soggetto non trovato.");
            }
            idServizioApplicativo.setNome(nome);
            try {
                sa = env.saCore.getServizioApplicativo(idServizioApplicativo);
                if (!sa.getTipo().equals("server")) {
                    sa = null;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (sa != null) {
                StringBuilder inUsoMessage = new StringBuilder();
                ServiziApplicativiUtilities.deleteServizioApplicativo((ServizioApplicativo)sa, (String)env.userLogin, (ServiziApplicativiCore)env.saCore, (ServiziApplicativiHelper)env.saHelper, (StringBuilder)inUsoMessage, (String)"\n");
                if (inUsoMessage.length() > 0) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml((String)inUsoMessage.toString()));
                }
            } else if (env.delete_404) {
                throw FaultCode.NOT_FOUND.toException("Applicativo server con nome: " + nome + " non trovato.");
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ListaApplicativiServer findAllApplicativiServer(ProfiloEnum profilo, String soggetto, String q, Integer limit, Integer offset, Boolean profiloQualsiasi, Boolean soggettoQualsiasi) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ApplicativiEnv env = new ApplicativiEnv(context.getServletRequest(), profilo, soggetto, context);
            int idLista = Liste.SERVIZIO_APPLICATIVO;
            ConsoleSearch ricerca = Helper.setupRicercaPaginata(q, limit, offset, idLista, env.idSoggetto.toIDSoggetto(), env.tipo_protocollo);
            if (profiloQualsiasi != null && profiloQualsiasi.booleanValue()) {
                ricerca.clearFilter(idLista, "filtroProtocollo");
            }
            if (soggettoQualsiasi != null && soggettoQualsiasi.booleanValue()) {
                ricerca.clearFilter(idLista, "filtroSoggetto");
            }
            ricerca.addFilter(idLista, "filtroTipoSA", "server");
            List saLista = env.saCore.soggettiServizioApplicativoList(null, (ISearch)ricerca);
            ListaApplicativiServer ret = (ListaApplicativiServer)ListaUtils.costruisciListaPaginata((UriInfo)context.getUriInfo(), (Integer)ricerca.getIndexIniziale(idLista), (Integer)ricerca.getPageSize(idLista), (long)ricerca.getNumEntries(idLista), ListaApplicativiServer.class);
            saLista.forEach(sa -> ret.addItemsItem(ApplicativiApiHelper.servizioApplicativoToApplicativoServerItem(sa)));
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return Helper.returnOrNotFound(ret);
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ApplicativoServer getApplicativoServer(String nome, ProfiloEnum profilo, String soggetto) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ApplicativiEnv env = new ApplicativiEnv(context.getServletRequest(), profilo, soggetto, context);
            ServizioApplicativo sa = null;
            try {
                IDServizioApplicativo idServizioApplicativo = new IDServizioApplicativo();
                idServizioApplicativo.setIdSoggettoProprietario(env.idSoggetto.toIDSoggetto());
                idServizioApplicativo.setNome(nome);
                sa = env.saCore.getServizioApplicativo(idServizioApplicativo);
                if (!sa.getTipo().equals("server")) {
                    throw new Exception("Applicativo non di tipo server: " + sa.getTipo());
                }
            }
            catch (Exception e) {
                throw FaultCode.NOT_FOUND.toException("Applicativo server con nome: " + nome + " non trovato.");
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            ApplicativoServer applicativo = ApplicativiApiHelper.servizioApplicativoToApplicativoServer(sa);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return applicativo;
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateApplicativoServer(ApplicativoServer body, String nome, ProfiloEnum profilo, String soggetto) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            ApplicativoServer applicativo = body;
            ApplicativiEnv env = new ApplicativiEnv(context.getServletRequest(), profilo, soggetto, context);
            ErogazioniEnv erogEnv = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            soggetto = env.idSoggetto.getNome();
            ServizioApplicativo oldSa = (ServizioApplicativo)BaseHelper.supplyOrNotFound(() -> ApplicativiApiHelper.getServizioApplicativo(nome, env.idSoggetto.getNome(), env.tipo_protocollo, env.saCore), (String)"Servizio Applicativo");
            if (!oldSa.getTipo().equals("server")) {
                throw FaultCode.NOT_FOUND.toException("Applicativo server con nome " + oldSa.getNome() + " non trovato");
            }
            ServizioApplicativo tmpSa = ApplicativiApiHelper.applicativoToServizioApplicativo(applicativo, env.tipo_protocollo, soggetto, env.stationCore);
            ServizioApplicativo newSa = ApplicativiApiHelper.getServizioApplicativo(nome, env.idSoggetto.getNome(), env.tipo_protocollo, env.saCore);
            newSa.setNome(tmpSa.getNome());
            newSa.setDescrizione(tmpSa.getDescrizione());
            newSa.setIdSoggetto(tmpSa.getIdSoggetto());
            newSa.setNomeSoggettoProprietario(tmpSa.getNomeSoggettoProprietario());
            newSa.setTipoSoggettoProprietario(tmpSa.getTipoSoggettoProprietario());
            newSa.getInvocazionePorta().setCredenzialiList(tmpSa.getInvocazionePorta().getCredenzialiList());
            newSa.getInvocazionePorta().setRuoli(tmpSa.getInvocazionePorta().getRuoli());
            newSa.getProprietaList().clear();
            if (applicativo.getProprieta() != null && !applicativo.getProprieta().isEmpty()) {
                for (Proprieta4000 proprieta : applicativo.getProprieta()) {
                    Proprieta pConfig = new Proprieta();
                    pConfig.setNome(proprieta.getNome());
                    pConfig.setValore(proprieta.getValore());
                    newSa.addProprieta(pConfig);
                }
            }
            InvocazioneServizio is = newSa.getInvocazioneServizio();
            InvocazioneCredenziali credenziali_is = is.getCredenziali();
            Connettore connis = is.getConnettore();
            String oldConnT = connis.getTipo();
            if (connis.getCustom() != null && connis.getCustom().booleanValue() && !connis.getTipo().equals(TipiConnettore.HTTPS.toString()) && !connis.getTipo().equals(TipiConnettore.FILE.toString()) && !connis.getTipo().equals(TipiConnettore.STATUS.toString())) {
                oldConnT = TipiConnettore.CUSTOM.toString();
            }
            if (!ConnettoreAPIHelper.connettoreCheckData(body.getConnettore(), erogEnv, true)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml((String)env.pd.getMessage()));
            }
            ConnettoreAPIHelper.fillConnettoreConfigurazione(newSa, erogEnv, body.getConnettore(), oldConnT);
            if (body.getConnettore().getTipo().equals((Object)ConnettoreEnum.HTTP) && ((ConnettoreHttp)body.getConnettore()).getAutenticazioneHttp() != null) {
                if (credenziali_is == null) {
                    credenziali_is = new InvocazioneCredenziali();
                }
                ConnettoreConfigurazioneHttpBasic authHttp = ((ConnettoreHttp)body.getConnettore()).getAutenticazioneHttp();
                credenziali_is.setUser(authHttp.getUsername());
                credenziali_is.setPassword(authHttp.getPassword());
                is.setCredenziali(credenziali_is);
                is.setAutenticazione(InvocazioneServizioTipoAutenticazione.BASIC);
            } else {
                is.setCredenziali(null);
                is.setAutenticazione(InvocazioneServizioTipoAutenticazione.NONE);
            }
            is.setConnettore(connis);
            newSa.setInvocazioneServizio(is);
            IDServizioApplicativo oldID = new IDServizioApplicativo();
            oldID.setIdSoggettoProprietario(ApplicativiApiHelper.getIDSoggetto(oldSa.getNomeSoggettoProprietario(), env.tipo_protocollo));
            oldID.setNome(oldSa.getNome());
            newSa.setOldIDServizioApplicativoForUpdate(oldID);
            List listExtendedConnettore = null;
            ApplicativiApiHelper.overrideSAParametersApplicativoServer(env.requestWrapper, (ConsoleHelper)env.saHelper, newSa, false);
            env.requestWrapper.overrideParameter("protocollo", env.tipo_protocollo);
            if (!env.saHelper.servizioApplicativoCheckData(TipoOperazione.CHANGE, null, oldSa.getIdSoggetto().longValue(), newSa.getTipologiaFruizione(), newSa.getTipologiaErogazione(), listExtendedConnettore, newSa, new StringBuilder())) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml((String)env.pd.getMessage()));
            }
            List listOggettiDaAggiornare = ServiziApplicativiUtilities.getOggettiDaAggiornare((ServiziApplicativiCore)env.saCore, (IDServizioApplicativo)oldID, (ServizioApplicativo)newSa);
            env.saCore.performUpdateOperation(env.userLogin, false, listOggettiDaAggiornare.toArray());
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }
}

