/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.rs.server.api.impl.erogazioni;

import java.util.Map;
import org.openspcoop2.core.config.Connettore;
import org.openspcoop2.core.config.Credenziali;
import org.openspcoop2.core.config.InvocazionePorta;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.constants.CredenzialeTipo;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.rs.server.api.impl.erogazioni.AbstractConnettoreApiHelper;
import org.openspcoop2.core.config.rs.server.api.impl.erogazioni.ErogazioniEnv;
import org.openspcoop2.core.config.rs.server.model.ConnettoreConfigurazioneHttpBasic;
import org.openspcoop2.core.config.rs.server.model.ConnettoreEnum;
import org.openspcoop2.core.config.rs.server.model.ConnettoreMessageBox;
import org.openspcoop2.core.config.rs.server.model.OneOfApplicativoServerConnettore;
import org.openspcoop2.core.config.rs.server.model.OneOfConnettoreErogazioneConnettore;
import org.openspcoop2.core.config.rs.server.model.OneOfConnettoreFruizioneConnettore;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.utils.service.fault.jaxrs.FaultCode;
import org.openspcoop2.web.lib.mvc.ServletUtils;

public class ConnettoreMessageBoxApiHelper
extends AbstractConnettoreApiHelper<ConnettoreMessageBox> {
    @Override
    public boolean connettoreCheckData(ConnettoreMessageBox conn, ErogazioniEnv env, boolean erogazione) throws Exception {
        return true;
    }

    @Override
    protected Connettore buildConnettoreConfigurazione(ServizioApplicativo sa, ErogazioniEnv env, ConnettoreMessageBox connettore, String oldConnT) throws Exception {
        Credenziali credenziali = new Credenziali();
        credenziali.setTipo(CredenzialeTipo.BASIC);
        credenziali.setUser(connettore.getAutenticazioneHttp().getUsername());
        credenziali.setPassword(connettore.getAutenticazioneHttp().getPassword());
        if (sa.getInvocazionePorta() == null) {
            sa.setInvocazionePorta(new InvocazionePorta());
        }
        sa.getInvocazionePorta().addCredenziali(credenziali);
        sa.getInvocazioneServizio().setGetMessage(StatoFunzionalita.ABILITATO);
        String protocollo = env.soggettiCore.getProtocolloAssociatoTipoSoggetto(sa.getTipoSoggettoProprietario());
        env.requestWrapper.overrideParameter("getmsg", CostantiConfigurazione.ABILITATO.toString());
        env.requestWrapper.overrideParameter("utenteCredenziali", connettore.getAutenticazioneHttp().getUsername());
        env.requestWrapper.overrideParameter("passwordCredenziali", connettore.getAutenticazioneHttp().getPassword());
        env.requestWrapper.overrideParameter("sbustamento", CostantiConfigurazione.DISABILITATO.toString());
        env.requestWrapper.overrideParameter("sbustamentoInformazioniProtocolloRichiesta", CostantiConfigurazione.DISABILITATO.toString());
        env.requestWrapper.overrideParameter("endpointtype", TipiConnettore.DISABILITATO.getNome());
        boolean ok = env.saHelper.servizioApplicativoEndPointCheckData(protocollo, null, sa);
        if (!ok) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException(env.saHelper.getPd().getMessage());
        }
        return super.buildConnettoreConfigurazione(sa, env, connettore, oldConnT);
    }

    @Override
    public org.openspcoop2.core.registry.Connettore fillConnettoreRegistro(org.openspcoop2.core.registry.Connettore regConnettore, ErogazioniEnv env, ConnettoreMessageBox conn, String oldConnT) throws Exception {
        env.apsHelper.fillConnettore(regConnettore, "false", TipiConnettore.DISABILITATO.getNome(), oldConnT, "", null, null, null, null, null, null, null, null, null, null, null, null, false, true, null, null, null, null, false, null, "", null, null, null, null, null, null, null, null, null, ServletUtils.boolToCheckBoxStatus((Boolean)false), null, null, null, null, ServletUtils.boolToCheckBoxStatus((Boolean)false), null, null, null, "no", "", "", "", "", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        return regConnettore;
    }

    @Override
    public Connettore buildConnettoreConfigurazione(Connettore regConnettore, ErogazioniEnv env, ConnettoreMessageBox conn, String oldConnType) throws Exception {
        env.apsHelper.fillConnettore(regConnettore, "false", TipiConnettore.DISABILITATO.getNome(), oldConnType, "", null, null, null, null, null, null, null, null, null, null, null, null, false, true, null, null, null, null, false, null, "", null, null, null, null, null, null, null, null, null, ServletUtils.boolToCheckBoxStatus((Boolean)false), null, null, null, null, ServletUtils.boolToCheckBoxStatus((Boolean)false), null, null, null, "no", "", "", "", "", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        return regConnettore;
    }

    @Override
    protected ConnettoreMessageBox buildConnettore(ServizioApplicativo sa) {
        ConnettoreMessageBox c = new ConnettoreMessageBox();
        c.setTipo(ConnettoreEnum.MESSAGE_BOX);
        ConnettoreConfigurazioneHttpBasic autenticazioneHttp = new ConnettoreConfigurazioneHttpBasic();
        if (sa.getInvocazionePorta().getCredenzialiList().size() > 0) {
            autenticazioneHttp.setUsername(sa.getInvocazionePorta().getCredenziali(0).getUser());
            autenticazioneHttp.setPassword(sa.getInvocazionePorta().getCredenziali(0).getPassword());
        }
        c.setAutenticazioneHttp(autenticazioneHttp);
        return c;
    }

    @Override
    public ConnettoreMessageBox buildConnettore(Map<String, String> props, String tipo) {
        return null;
    }

    @Override
    public String getUrlConnettore(Map<String, String> props, String tipoConnettore) throws Exception {
        return "disabilitato [MessageBox]";
    }

    @Override
    protected ConnettoreMessageBox getConnettore(OneOfConnettoreErogazioneConnettore conn) throws Exception {
        return (ConnettoreMessageBox)conn;
    }

    @Override
    protected ConnettoreMessageBox getConnettore(OneOfConnettoreFruizioneConnettore conn) throws Exception {
        return (ConnettoreMessageBox)((Object)conn);
    }

    @Override
    protected ConnettoreMessageBox getConnettore(OneOfApplicativoServerConnettore conn) throws Exception {
        return (ConnettoreMessageBox)conn;
    }
}

