/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.rs.server.api.impl.erogazioni;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.Connettore;
import org.openspcoop2.core.config.InvocazioneCredenziali;
import org.openspcoop2.core.config.InvocazioneServizio;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaApplicativaAzione;
import org.openspcoop2.core.config.PortaApplicativaServizioApplicativo;
import org.openspcoop2.core.config.RispostaAsincrona;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.constants.InvocazioneServizioTipoAutenticazione;
import org.openspcoop2.core.config.constants.PortaApplicativaAzioneIdentificazione;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.constants.TipologiaErogazione;
import org.openspcoop2.core.config.constants.TipologiaFruizione;
import org.openspcoop2.core.config.rs.server.api.ErogazioniApi;
import org.openspcoop2.core.config.rs.server.api.impl.Helper;
import org.openspcoop2.core.config.rs.server.api.impl.IdServizio;
import org.openspcoop2.core.config.rs.server.api.impl.applicativi.ApplicativiEnv;
import org.openspcoop2.core.config.rs.server.api.impl.erogazioni.ConnettoreAPIHelper;
import org.openspcoop2.core.config.rs.server.api.impl.erogazioni.ErogazioniApiHelper;
import org.openspcoop2.core.config.rs.server.api.impl.erogazioni.ErogazioniEnv;
import org.openspcoop2.core.config.rs.server.api.impl.erogazioni.ModiErogazioniApiHelper;
import org.openspcoop2.core.config.rs.server.config.ServerProperties;
import org.openspcoop2.core.config.rs.server.model.ApiDescrizione;
import org.openspcoop2.core.config.rs.server.model.ApiImplAllegato;
import org.openspcoop2.core.config.rs.server.model.ApiImplInformazioniGenerali;
import org.openspcoop2.core.config.rs.server.model.ApiImplInformazioniGeneraliView;
import org.openspcoop2.core.config.rs.server.model.ApiImplUrlInvocazione;
import org.openspcoop2.core.config.rs.server.model.ApiImplUrlInvocazioneView;
import org.openspcoop2.core.config.rs.server.model.ApiImplVersioneApi;
import org.openspcoop2.core.config.rs.server.model.ApiImplVersioneApiView;
import org.openspcoop2.core.config.rs.server.model.ConnettoreApplicativoServer;
import org.openspcoop2.core.config.rs.server.model.ConnettoreConfigurazioneHttpBasic;
import org.openspcoop2.core.config.rs.server.model.ConnettoreEnum;
import org.openspcoop2.core.config.rs.server.model.ConnettoreErogazione;
import org.openspcoop2.core.config.rs.server.model.ConnettoreHttp;
import org.openspcoop2.core.config.rs.server.model.ConnettoreMessageBox;
import org.openspcoop2.core.config.rs.server.model.Erogazione;
import org.openspcoop2.core.config.rs.server.model.ErogazioneModI;
import org.openspcoop2.core.config.rs.server.model.ErogazioneViewItem;
import org.openspcoop2.core.config.rs.server.model.ListaApiImplAllegati;
import org.openspcoop2.core.config.rs.server.model.ListaErogazioni;
import org.openspcoop2.core.config.rs.server.model.ModalitaIdentificazioneAzioneEnum;
import org.openspcoop2.core.config.rs.server.model.OneOfConnettoreErogazioneConnettore;
import org.openspcoop2.core.config.rs.server.model.TipoApiEnum;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mapping.MappingErogazionePortaApplicativa;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.ProtocolProperty;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.beans.AccordoServizioParteComuneSintetico;
import org.openspcoop2.core.registry.beans.OperationSintetica;
import org.openspcoop2.core.registry.beans.PortTypeSintetico;
import org.openspcoop2.core.registry.constants.ServiceBinding;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.protocol.sdk.constants.ConsoleInterfaceType;
import org.openspcoop2.protocol.sdk.constants.ConsoleOperationType;
import org.openspcoop2.protocol.sdk.properties.ProtocolProperties;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesUtils;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.service.BaseImpl;
import org.openspcoop2.utils.service.authorization.AuthorizationConfig;
import org.openspcoop2.utils.service.authorization.AuthorizationManager;
import org.openspcoop2.utils.service.beans.ProfiloEnum;
import org.openspcoop2.utils.service.beans.utils.BaseHelper;
import org.openspcoop2.utils.service.beans.utils.ListaUtils;
import org.openspcoop2.utils.service.context.IContext;
import org.openspcoop2.utils.service.fault.jaxrs.FaultCode;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.plugins.IExtendedListServlet;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaCore;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaHelper;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaUtilities;
import org.openspcoop2.web.ctrlstat.servlet.sa.ServiziApplicativiCore;
import org.openspcoop2.web.ctrlstat.servlet.sa.ServiziApplicativiUtilities;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.LoggerFactory;

public class ErogazioniApiServiceImpl
extends BaseImpl
implements ErogazioniApi {
    public ErogazioniApiServiceImpl() {
        super(LoggerFactory.getLogger(ErogazioniApiServiceImpl.class));
    }

    private AuthorizationConfig getAuthorizationConfig() throws Exception {
        return new AuthorizationConfig(ServerProperties.getInstance().getProperties());
    }

    @Override
    public void createErogazione(Erogazione body, ProfiloEnum profilo, String soggetto) {
        IContext context = this.getContext();
        try {
            AccordoServizioParteSpecifica asps;
            IDServizio idAps;
            boolean alreadyExists;
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            Soggetto soggettoErogatore = env.soggettiCore.getSoggettoRegistro(env.idSoggetto.toIDSoggetto());
            IDSoggetto idReferente = ErogazioniApiHelper.getIdReferente(body, env);
            AccordoServizioParteComuneSintetico as = Helper.getAccordoSintetico(body.getApiNome(), body.getApiVersione(), idReferente, env.apcCore);
            Object referente = "";
            if (env.apcCore.isSupportatoSoggettoReferente(env.tipo_protocollo) && idReferente != null) {
                referente = " (referente: " + idReferente + ")";
            }
            if (as == null) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Nessuna Api registrata con nome " + body.getApiNome() + " e versione " + body.getApiVersione() + (String)referente);
            }
            if (ServiceBinding.SOAP.equals((Object)as.getServiceBinding())) {
                if (StringUtils.isEmpty((String)body.getApiSoapServizio())) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Per una API di tipo SOAP il claim 'api_soap_servizio' deve essere obbligatoriamente fornito");
                }
                boolean ptFind = false;
                if (as.getPortType() != null && !as.getPortType().isEmpty()) {
                    for (PortTypeSintetico pt : as.getPortType()) {
                        if (!pt.getNome().equals(body.getApiSoapServizio())) continue;
                        ptFind = true;
                        break;
                    }
                }
                if (!ptFind) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Nel claim 'api_soap_servizio' \u00e8 stato indicato un servizio non esistente nell'API " + body.getApiNome() + " v" + body.getApiVersione() + (String)referente);
                }
            }
            if (alreadyExists = env.apsCore.existsAccordoServizioParteSpecifica(idAps = env.idServizioFactory.getIDServizioFromValues((asps = ErogazioniApiHelper.apiImplToAps(body, soggettoErogatore, as, env)).getTipo(), asps.getNome(), new IDSoggetto(asps.getTipoSoggettoErogatore(), asps.getNomeSoggettoErogatore()), asps.getVersione().intValue()))) {
                asps = env.apsCore.getServizio(idAps);
            }
            env.apsCore.setDataCreazioneServizio(asps);
            ProtocolProperties protocolProperties = null;
            if (profilo != null) {
                AccordoServizioParteComune accordoFull = null;
                boolean required = false;
                if (env.isProfiloModi() && (accordoFull = Helper.getAccordoFull(body.getApiNome(), body.getApiVersione(), idReferente, env.apcCore)).sizeProtocolPropertyList() > 0) {
                    for (ProtocolProperty pp : accordoFull.getProtocolPropertyList()) {
                        String v;
                        if (!"modipaSecurityMessageProfile".equals(pp.getName()) || (v = pp.getValue()) == null || !StringUtils.isNotEmpty((String)v) || "-".equals(v)) continue;
                        required = true;
                    }
                }
                if ((protocolProperties = ErogazioniApiHelper.getProtocolProperties(body, profilo, accordoFull, asps, env, required)) != null) {
                    asps.setProtocolPropertyList(ProtocolPropertiesUtils.toProtocolPropertiesRegistry((ProtocolProperties)protocolProperties, (ConsoleOperationType)ConsoleOperationType.ADD, null));
                }
            }
            ServletUtils.setObjectIntoSession((HttpServletRequest)context.getServletRequest(), (HttpSession)context.getServletRequest().getSession(), (Object)"erogazione", (String)"_tabKey_tipologiaErogazione");
            ErogazioniApiHelper.serviziCheckData(TipoOperazione.ADD, env, as, asps, Optional.empty(), body);
            ErogazioniApiHelper.validateProperties(env, protocolProperties, asps, ConsoleOperationType.ADD);
            org.openspcoop2.core.registry.Connettore regConnettore = ErogazioniApiHelper.buildConnettoreRegistro(env, body.getConnettore());
            ErogazioniApiHelper.createAps(env, asps, regConnettore, body, alreadyExists, true);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            context.getServletResponse().setStatus(201);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void createErogazioneAllegato(ApiImplAllegato body, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfErogazione(tipoServizio, nome, versione, env.idSoggetto.toIDSoggetto(), env), (String)"Erogazione");
            ErogazioniApiHelper.createAllegatoAsps(body, env, asps);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            context.getServletResponse().setStatus(201);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void deleteErogazione(String nome, Integer versione, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.evalnull(() -> ErogazioniApiHelper.getServizioIfErogazione(tipoServizio, nome, versione, env.idSoggetto.toIDSoggetto(), env));
            if (asps != null) {
                IDServizio idServizio = env.idServizioFactory.getIDServizioFromAccordo(asps);
                StringBuilder inUsoMessage = new StringBuilder();
                AccordiServizioParteSpecificaUtilities.deleteAccordoServizioParteSpecifica((AccordoServizioParteSpecifica)asps, (boolean)false, (boolean)true, null, (IDServizio)idServizio, (IExtendedListServlet)env.paCore.getExtendedServletPortaApplicativa(), (String)env.userLogin, (AccordiServizioParteSpecificaCore)env.apsCore, (AccordiServizioParteSpecificaHelper)env.apsHelper, (StringBuilder)inUsoMessage, (String)"\n");
                if (inUsoMessage.length() > 0) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml((String)inUsoMessage.toString()));
                }
            } else if (env.delete_404) {
                throw FaultCode.NOT_FOUND.toException("Erogazione non presente");
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void deleteErogazioneAllegato(String nome, Integer versione, String nomeAllegato, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfErogazione(tipoServizio, nome, versione, env.idSoggetto.toIDSoggetto(), env), (String)"Erogazione");
            ErogazioniApiHelper.deleteAllegato(nomeAllegato, env, asps);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public byte[] downloadErogazioneAllegato(String nome, Integer versione, String nomeAllegato, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfErogazione(tipoServizio, nome, versione, env.idSoggetto.toIDSoggetto(), env), (String)"Erogazione");
            Optional<Long> idDoc = ErogazioniApiHelper.getIdDocumento(nomeAllegato, asps);
            if (!idDoc.isPresent()) {
                throw FaultCode.NOT_FOUND.toException("Allegato di nome " + nomeAllegato + " non presente.");
            }
            Documento allegato = env.archiviCore.getDocumento(idDoc.get().longValue(), true);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            Helper.setContentType(context, allegato.getFile());
            return allegato.getByteContenuto();
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ListaErogazioni findAllErogazioni(ProfiloEnum profilo, String soggetto, String q, Integer limit, Integer offset, TipoApiEnum tipoApi, String tag, String uriApiImplementata, Boolean profiloQualsiasi, Boolean soggettoQualsiasi) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            int idLista = Liste.SERVIZI;
            ConsoleSearch ricerca = Helper.setupRicercaPaginata(q, limit, offset, idLista, env.idSoggetto.toIDSoggetto(), env.tipo_protocollo);
            if (profiloQualsiasi != null && profiloQualsiasi.booleanValue()) {
                ricerca.clearFilter(idLista, "filtroProtocollo");
            }
            if (soggettoQualsiasi != null && soggettoQualsiasi.booleanValue()) {
                ricerca.clearFilter(idLista, "filtroSoggetto");
            }
            if (tipoApi != null) {
                ricerca.addFilter(idLista, "filtroServiceBinding", tipoApi.toString().toLowerCase());
            }
            if (tag != null) {
                ricerca.addFilter(idLista, "filtroGruppo", tag);
            }
            if (uriApiImplementata != null) {
                ErogazioniApiHelper.setFiltroApiImplementata(uriApiImplementata, idLista, ricerca, env);
            }
            List lista = env.apsCore.soggettiServizioList(null, (ISearch)ricerca, null, false, true);
            if (env.findall_404 && lista.isEmpty()) {
                throw FaultCode.NOT_FOUND.toException("Nessuna erogazione presente");
            }
            ListaErogazioni ret = (ListaErogazioni)ListaUtils.costruisciListaPaginata((UriInfo)context.getUriInfo(), (Integer)ricerca.getIndexIniziale(idLista), (Integer)ricerca.getPageSize(idLista), (long)ricerca.getNumEntries(idLista), ListaErogazioni.class);
            lista.forEach(asps -> ret.addItemsItem(ErogazioniApiHelper.erogazioneViewItemToErogazioneItem(ErogazioniApiHelper.aspsToErogazioneViewItem(env, asps))));
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return Helper.returnOrNotFound(ret);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ListaApiImplAllegati findAllErogazioneAllegati(String nome, Integer versione, ProfiloEnum profilo, String soggetto, String tipoServizio, String q, Integer limit, Integer offset) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfErogazione(tipoServizio, nome, versione, env.idSoggetto.toIDSoggetto(), env), (String)"Erogazione");
            ListaApiImplAllegati ret = ErogazioniApiHelper.findAllAllegati(q, limit, offset, context.getUriInfo(), env, asps);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ErogazioneViewItem getErogazione(String nome, Integer versione, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfErogazione(tipoServizio, nome, versione, env.idSoggetto.toIDSoggetto(), env), (String)"Erogazione");
            ErogazioneViewItem ret = ErogazioniApiHelper.aspsToErogazioneViewItem(env, asps);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ApiImplVersioneApiView getErogazioneAPI(String nome, Integer versione, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfErogazione(tipoServizio, nome, versione, env.idSoggetto.toIDSoggetto(), env), (String)"Erogazione");
            ApiImplVersioneApiView ret = ErogazioniApiHelper.aspsToApiImplVersioneApiView(env, asps);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ApiImplAllegato getErogazioneAllegato(String nome, Integer versione, String nomeAllegato, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfErogazione(tipoServizio, nome, versione, env.idSoggetto.toIDSoggetto(), env), (String)"Erogazione");
            Optional<Long> idDoc = ErogazioniApiHelper.getIdDocumento(nomeAllegato, asps);
            if (!idDoc.isPresent()) {
                throw FaultCode.NOT_FOUND.toException("Allegato di nome " + nomeAllegato + " non presente.");
            }
            Documento doc = env.archiviCore.getDocumento(idDoc.get().longValue(), true);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ErogazioniApiHelper.documentoToImplAllegato(doc);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ConnettoreErogazione getErogazioneConnettore(String nome, Integer versione, ProfiloEnum profilo, String soggetto, String tipoServizio, String gruppo) {
        IContext context = this.getContext();
        try {
            ConnettoreErogazione ret;
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfErogazione(tipoServizio, nome, versione, env.idSoggetto.toIDSoggetto(), env), (String)"Erogazione");
            IdServizio idAsps = new IdServizio(env.idServizioFactory.getIDServizioFromAccordo(asps), asps.getId());
            if (ErogazioniApiHelper.isConnettoreApplicativoServer(idAsps, env.idServizioFactory.getIDServizioFromAccordo(asps), env, gruppo)) {
                ServizioApplicativo sa = ErogazioniApiHelper.getServizioApplicativo(idAsps, env.idServizioFactory.getIDServizioFromAccordo(asps), env, gruppo);
                ret = new ConnettoreErogazione();
                ConnettoreApplicativoServer con = new ConnettoreApplicativoServer();
                con.setTipo(ConnettoreEnum.APPLICATIVO_SERVER);
                con.setApplicativo(sa.getNome());
                ret.setConnettore(con);
            } else {
                ServizioApplicativo sa = ErogazioniApiHelper.getServizioApplicativo(idAsps, env.idServizioFactory.getIDServizioFromAccordo(asps), env, gruppo);
                ret = ConnettoreAPIHelper.buildConnettoreErogazione(sa);
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ApiDescrizione getErogazioneDescrizione(String nome, Integer versione, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfErogazione(tipoServizio, nome, versione, env.idSoggetto.toIDSoggetto(), env), (String)"Erogazione");
            ApiDescrizione descr = new ApiDescrizione();
            descr.setDescrizione(asps.getDescrizione());
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return descr;
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ApiImplInformazioniGeneraliView getErogazioneInformazioniGenerali(String nome, Integer versione, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfErogazione(tipoServizio, nome, versione, env.idSoggetto.toIDSoggetto(), env), (String)"Erogazione");
            ApiImplInformazioniGeneraliView ret = ErogazioniApiHelper.erogazioneToApiImplInformazioniGeneraliView(env, asps);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ErogazioneModI getErogazioneModI(String nome, Integer versione, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfErogazione(tipoServizio, nome, versione, env.idSoggetto.toIDSoggetto(), env), (String)"Erogazione");
            IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(asps.getAccordoServizioParteComune());
            AccordoServizioParteComune aspc = Helper.getAccordoFull(idAccordo.getNome(), idAccordo.getVersione(), idAccordo.getSoggettoReferente(), env.apcCore);
            ErogazioneModI ret = ModiErogazioniApiHelper.getErogazioneModi(aspc, asps, env, profilo, ErogazioniApiHelper.getProtocolPropertiesMap(asps, env));
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ApiImplUrlInvocazioneView getErogazioneUrlInvocazione(String nome, Integer versione, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfErogazione(tipoServizio, nome, versione, env.idSoggetto.toIDSoggetto(), env), (String)"Erogazione");
            PortaApplicativa pa = env.paCore.getPortaApplicativa(env.paCore.getIDPortaApplicativaAssociataDefault(env.idServizioFactory.getIDServizioFromAccordo(asps)));
            PortaApplicativaAzione paAzione = pa.getAzione();
            AccordoServizioParteComuneSintetico aspc = env.apcCore.getAccordoServizioSintetico(asps.getIdAccordo().longValue());
            String urlInvocazione = ErogazioniApiHelper.getUrlInvocazioneErogazione(asps, env);
            ApiImplUrlInvocazioneView ret = new ApiImplUrlInvocazioneView();
            Map azioni = env.paCore.getAzioniConLabel(asps, aspc, false, true, new ArrayList());
            ret.setAzioni(Arrays.asList(azioni.keySet().toArray(new String[azioni.size()])));
            ret.setForceInterface(Helper.statoFunzionalitaConfToBool(paAzione.getForceInterfaceBased()));
            ret.setModalita(Enum.valueOf(ModalitaIdentificazioneAzioneEnum.class, paAzione.getIdentificazione().name()));
            switch (ret.getModalita()) {
                case CONTENT_BASED: 
                case URL_BASED: {
                    ret.setPattern(paAzione.getPattern());
                    break;
                }
                case HEADER_BASED: {
                    ret.setNome(paAzione.getPattern());
                    break;
                }
                case INPUT_BASED: 
                case PROTOCOL_BASED: 
                case SOAP_ACTION_BASED: {
                    break;
                }
                case STATIC: 
                case INTERFACE_BASED: {
                    ret.setForceInterface(false);
                }
            }
            ret.setUrlInvocazione(urlInvocazione);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateErogazioneAPI(ApiImplVersioneApi body, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfErogazione(tipoServizio, nome, versione, env.idSoggetto.toIDSoggetto(), env), (String)"Erogazione");
            AccordoServizioParteComuneSintetico as = env.apcCore.getAccordoServizioSintetico(asps.getIdAccordo().longValue());
            List asParteComuneCompatibili = env.apsCore.findAccordiParteComuneBySoggettoAndNome(as.getNome(), new IDSoggetto(as.getSoggettoReferente().getTipo(), as.getSoggettoReferente().getNome()));
            Optional newApc = BaseHelper.findFirst((Iterable)asParteComuneCompatibili, a -> a.getVersione() != null && body.getApiVersione() != null && a.getVersione().intValue() == body.getApiVersione().intValue());
            if (!newApc.isPresent()) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Nessuna api " + as.getNome() + " e versione " + body.getApiVersione() + " registrata");
            }
            asps.setAccordoServizioParteComune(env.idAccordoFactory.getUriFromAccordo((AccordoServizioParteComune)newApc.get()));
            asps.setIdAccordo(((AccordoServizioParteComune)newApc.get()).getId());
            asps.setOldIDServizioForUpdate(env.idServizioFactory.getIDServizioFromAccordo(asps));
            ErogazioniApiHelper.serviziUpdateCheckData(as, asps, true, env);
            List oggettiDaAggiornare = AccordiServizioParteSpecificaUtilities.getOggettiDaAggiornare((AccordoServizioParteSpecifica)asps, (AccordiServizioParteSpecificaCore)env.apsCore);
            env.apsCore.performUpdateOperation(env.userLogin, false, oggettiDaAggiornare.toArray());
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateErogazioneAllegato(ApiImplAllegato body, String nome, Integer versione, String nomeAllegato, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfErogazione(tipoServizio, nome, versione, env.idSoggetto.toIDSoggetto(), env), (String)"Erogazione");
            ErogazioniApiHelper.updateAllegatoAsps(body, nomeAllegato, env, asps);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateErogazioneConnettore(ConnettoreErogazione body, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String tipoServizio, String gruppo) {
        IContext context = this.getContext();
        try {
            PortaApplicativa pa;
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            if (body == null) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Specificare un body");
            }
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfErogazione(tipoServizio, nome, versione, env.idSoggetto.toIDSoggetto(), env), (String)"Erogazione");
            IdServizio idAsps = new IdServizio(env.idServizioFactory.getIDServizioFromAccordo(asps), asps.getId());
            IDServizio idServizio = env.idServizioFactory.getIDServizioFromAccordo(asps);
            IDPortaApplicativa idPaDefault = env.paCore.getIDPortaApplicativaAssociataDefault(idServizio);
            PortaApplicativa paDefault = env.paCore.getPortaApplicativa(idPaDefault);
            boolean creaNuovoConnettore = false;
            IDPortaApplicativa idPa = null;
            if (gruppo != null) {
                idPa = (IDPortaApplicativa)BaseHelper.supplyOrNonValida(() -> ErogazioniApiHelper.getIDGruppoPA(gruppo, idAsps, env.apsCore), (String)"Gruppo per l'erogazione scelta");
                pa = env.paCore.getPortaApplicativa(idPa);
                creaNuovoConnettore = !env.apsHelper.isConnettoreRidefinito(paDefault, (PortaApplicativaServizioApplicativo)paDefault.getServizioApplicativoList().get(0), pa, (PortaApplicativaServizioApplicativo)pa.getServizioApplicativoList().get(0), pa.getServizioApplicativoList());
            } else {
                idPa = idPaDefault;
                pa = paDefault;
            }
            if (this.isConnettoreMessageBox(body.getConnettore(), profilo, soggetto, context)) {
                AccordoServizioParteComuneSintetico apc = env.apcCore.getAccordoServizioSintetico(asps.getIdAccordo().longValue());
                org.openspcoop2.message.constants.ServiceBinding serviceBinding = env.apcCore.toMessageServiceBinding(apc.getServiceBinding());
                MappingErogazionePortaApplicativa mappingErogazionePortaApplicativa = env.paCore.getMappingErogazionePortaApplicativa(pa);
                boolean isSoapOneWay = env.saHelper.isSoapOneWay(pa, mappingErogazionePortaApplicativa, asps, apc, serviceBinding);
                if (!isSoapOneWay) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Impossibile associare un connettore di tipo message-box a una erogazione (o gruppo) che non sia composto da tutte e sole Operation SOAP OneWay");
                }
            }
            String erogazioneServizioApplicativoServer = null;
            if (body.getConnettore().getTipo().equals((Object)ConnettoreEnum.APPLICATIVO_SERVER)) {
                ConnettoreApplicativoServer connAppServer = (ConnettoreApplicativoServer)body.getConnettore();
                erogazioneServizioApplicativoServer = connAppServer.getApplicativo();
                IDServizioApplicativo idServizioApplicativo = new IDServizioApplicativo();
                idServizioApplicativo.setIdSoggettoProprietario(env.idSoggetto.toIDSoggetto());
                idServizioApplicativo.setNome(erogazioneServizioApplicativoServer);
                ServizioApplicativo sa = env.saCore.getServizioApplicativo(idServizioApplicativo);
                if (!ErogazioniApiHelper.isConnettoreApplicativoServer(sa)) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Applicativo [" + connAppServer.getApplicativo() + "] non di tipo server: " + sa.getTipo());
                }
            }
            ServizioApplicativo sa = null;
            if (creaNuovoConnettore) {
                ArrayList<ServizioApplicativo> listaOggettiDaCreare = new ArrayList<ServizioApplicativo>();
                ArrayList<PortaApplicativa> listaOggettiDaModificare = new ArrayList<PortaApplicativa>();
                String nomeServizioApplicativoErogatore = pa.getNome();
                sa = new ServizioApplicativo();
                sa.setNome(nomeServizioApplicativoErogatore);
                sa.setTipologiaFruizione(TipologiaFruizione.DISABILITATO.getValue());
                sa.setTipologiaErogazione(TipologiaErogazione.TRASPARENTE.getValue());
                sa.setIdSoggetto(pa.getIdSoggetto());
                sa.setTipoSoggettoProprietario(pa.getTipoSoggettoProprietario());
                sa.setNomeSoggettoProprietario(pa.getNomeSoggettoProprietario());
                RispostaAsincrona rispostaAsinc = new RispostaAsincrona();
                rispostaAsinc.setAutenticazione(InvocazioneServizioTipoAutenticazione.NONE);
                rispostaAsinc.setGetMessage(CostantiConfigurazione.DISABILITATO);
                Connettore conn = new Connettore();
                conn.setTipo(TipiConnettore.DISABILITATO.toString());
                rispostaAsinc.setConnettore(conn);
                sa.setRispostaAsincrona(rispostaAsinc);
                InvocazioneServizio invServizio = new InvocazioneServizio();
                invServizio.setAutenticazione(InvocazioneServizioTipoAutenticazione.NONE);
                invServizio.setGetMessage(CostantiConfigurazione.DISABILITATO);
                Connettore conn1 = new Connettore();
                conn1.setTipo(TipiConnettore.DISABILITATO.toString());
                invServizio.setConnettore(conn1);
                sa.setInvocazioneServizio(invServizio);
                listaOggettiDaCreare.add(sa);
                pa.getServizioApplicativoList().clear();
                PortaApplicativaServizioApplicativo paSA = new PortaApplicativaServizioApplicativo();
                paSA.setNome(nomeServizioApplicativoErogatore);
                pa.getServizioApplicativoList().add(paSA);
                listaOggettiDaModificare.add(pa);
                env.paCore.performCreateOperation(env.userLogin, false, listaOggettiDaCreare.toArray());
                env.paCore.performUpdateOperation(env.userLogin, false, listaOggettiDaModificare.toArray());
            }
            if (sa == null) {
                sa = (ServizioApplicativo)BaseHelper.supplyOrNotFound(() -> env.saCore.getServizioApplicativo(env.saCore.getIdServizioApplicativo(env.idSoggetto.toIDSoggetto(), ((PortaApplicativaServizioApplicativo)pa.getServizioApplicativoList().get(0)).getNome())), (String)"Applicativo");
            }
            String oldErogazioneServizioApplicativoServer = null;
            if (ErogazioniApiHelper.isConnettoreApplicativoServer(sa)) {
                oldErogazioneServizioApplicativoServer = sa.getNome();
            }
            if (erogazioneServizioApplicativoServer != null) {
                if (oldErogazioneServizioApplicativoServer == null || !erogazioneServizioApplicativoServer.equals(oldErogazioneServizioApplicativoServer)) {
                    PortaApplicativaServizioApplicativo paSAtmp = null;
                    for (PortaApplicativaServizioApplicativo paSA : pa.getServizioApplicativoList()) {
                        if (!paSA.getNome().equals(sa.getNome())) continue;
                        paSAtmp = paSA;
                        break;
                    }
                    if (paSAtmp != null) {
                        if ("server".equals(sa.getTipo())) {
                            pa.getServizioApplicativoList().remove(paSAtmp);
                        } else {
                            pa.getServizioApplicativoList().remove(paSAtmp);
                            pa.setServizioApplicativoDefault(sa.getNome());
                        }
                    }
                    PortaApplicativaServizioApplicativo paSA = new PortaApplicativaServizioApplicativo();
                    paSA.setNome(erogazioneServizioApplicativoServer);
                    pa.getServizioApplicativoList().add(paSA);
                    env.saHelper.impostaSAServerAlleConfigurazioniCheUsanoConnettoreDelMappingDiDefault("" + asps.getId(), erogazioneServizioApplicativoServer, pa, sa, Arrays.asList(pa));
                    env.paCore.performUpdateOperation(env.userLogin, false, new Object[]{pa});
                }
            } else {
                if (oldErogazioneServizioApplicativoServer != null) {
                    String oldServizioApplicativoDefault = pa.getServizioApplicativoDefault();
                    String oldNomeSA = sa.getNome();
                    String oldTipoSA = sa.getTipo();
                    PortaApplicativaServizioApplicativo paSAtmp = null;
                    for (PortaApplicativaServizioApplicativo paSA : pa.getServizioApplicativoList()) {
                        if (!paSA.getNome().equals(oldNomeSA)) continue;
                        paSAtmp = paSA;
                        break;
                    }
                    if (paSAtmp != null && "server".equals(oldTipoSA)) {
                        pa.getServizioApplicativoList().remove(paSAtmp);
                    }
                    PortaApplicativaServizioApplicativo paSA = new PortaApplicativaServizioApplicativo();
                    paSA.setNome(oldServizioApplicativoDefault);
                    pa.getServizioApplicativoList().add(paSA);
                    pa.setServizioApplicativoDefault(null);
                    env.saHelper.impostaSADefaultAlleConfigurazioniCheUsanoConnettoreDelMappingDiDefault("" + asps.getId(), pa, sa, Arrays.asList(pa));
                    IDServizioApplicativo idSA = new IDServizioApplicativo();
                    idSA.setNome(oldServizioApplicativoDefault);
                    IDSoggetto idSoggettoProprietario = new IDSoggetto();
                    idSoggettoProprietario.setTipo(pa.getTipoSoggettoProprietario());
                    idSoggettoProprietario.setNome(pa.getNomeSoggettoProprietario());
                    idSA.setIdSoggettoProprietario(idSoggettoProprietario);
                    sa = env.saCore.getServizioApplicativo(idSA);
                    env.saCore.performUpdateOperation(env.userLogin, false, new Object[]{pa});
                }
                InvocazioneServizio is = sa.getInvocazioneServizio();
                String endpointtype = this.getEndpointType(body.getConnettore());
                Connettore connis = is.getConnettore();
                String oldConnT = connis.getTipo();
                if (connis.getCustom() != null && connis.getCustom().booleanValue() && !connis.getTipo().equals(TipiConnettore.HTTPS.toString()) && !connis.getTipo().equals(TipiConnettore.FILE.toString())) {
                    oldConnT = TipiConnettore.CUSTOM.toString();
                }
                if (!ConnettoreAPIHelper.connettoreCheckData(body.getConnettore(), env, true)) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml((String)env.pd.getMessage()));
                }
                ConnettoreAPIHelper.fillConnettoreConfigurazione(sa, env, body.getConnettore(), oldConnT);
                if (body.getConnettore().getTipo().equals((Object)ConnettoreEnum.HTTP) && ((ConnettoreHttp)body.getConnettore()).getAutenticazioneHttp() != null) {
                    InvocazioneCredenziali credenziali_is = is.getCredenziali();
                    if (credenziali_is == null) {
                        credenziali_is = new InvocazioneCredenziali();
                    }
                    ConnettoreConfigurazioneHttpBasic authHttp = ((ConnettoreHttp)body.getConnettore()).getAutenticazioneHttp();
                    credenziali_is.setUser(authHttp.getUsername());
                    credenziali_is.setPassword(authHttp.getPassword());
                    is.setCredenziali(credenziali_is);
                    is.setAutenticazione(InvocazioneServizioTipoAutenticazione.BASIC);
                } else {
                    is.setCredenziali(null);
                    is.setAutenticazione(InvocazioneServizioTipoAutenticazione.NONE);
                }
                is.setConnettore(connis);
                sa.setInvocazioneServizio(is);
                if (StatoFunzionalita.ABILITATO.equals((Object)is.getGetMessage()) || !TipiConnettore.DISABILITATO.toString().equals(endpointtype)) {
                    sa.setTipologiaErogazione(TipologiaErogazione.TRASPARENTE.getValue());
                } else {
                    sa.setTipologiaErogazione(TipologiaErogazione.DISABILITATO.getValue());
                }
                StringBuilder inUsoMessage = new StringBuilder();
                ServiziApplicativiUtilities.checkStatoConnettore((ServiziApplicativiCore)env.saCore, (ServizioApplicativo)sa, (Connettore)is.getConnettore(), (StringBuilder)inUsoMessage, (String)System.lineSeparator());
                if (inUsoMessage.length() > 0) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml((String)inUsoMessage.toString()));
                }
                env.saCore.performUpdateOperation(env.userLogin, false, new Object[]{sa});
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    private boolean isConnettoreMessageBox(OneOfConnettoreErogazioneConnettore connettore, ProfiloEnum profilo, String soggetto, IContext context) throws UtilsException, Exception {
        if (connettore instanceof ConnettoreMessageBox) {
            return true;
        }
        if (!(connettore instanceof ConnettoreApplicativoServer)) {
            return false;
        }
        ApplicativiEnv env = new ApplicativiEnv(context.getServletRequest(), profilo, soggetto, context);
        ServizioApplicativo sa = null;
        ConnettoreApplicativoServer cas = (ConnettoreApplicativoServer)connettore;
        try {
            IDServizioApplicativo idServizioApplicativo = new IDServizioApplicativo();
            idServizioApplicativo.setIdSoggettoProprietario(env.idSoggetto.toIDSoggetto());
            idServizioApplicativo.setNome(cas.getApplicativo());
            sa = env.saCore.getServizioApplicativo(idServizioApplicativo);
            if (!sa.getTipo().equals("server")) {
                throw new Exception("Applicativo non di tipo server: " + sa.getTipo());
            }
            return sa.getInvocazioneServizio().getGetMessage().equals((Object)StatoFunzionalita.ABILITATO);
        }
        catch (Exception e) {
            throw FaultCode.NOT_FOUND.toException("Applicativo server con nome: " + cas.getApplicativo() + " non trovato.");
        }
    }

    private String getEndpointType(OneOfConnettoreErogazioneConnettore connettore) {
        switch (connettore.getTipo()) {
            case APPLICATIVO_SERVER: 
            case ECHO: {
                return TipiConnettore.NULLECHO.getNome();
            }
            case STATUS: {
                return TipiConnettore.STATUS.getNome();
            }
            case FILE: {
                return TipiConnettore.FILE.getNome();
            }
            case HTTP: {
                ConnettoreHttp connettoreHttp = (ConnettoreHttp)connettore;
                String endpointtype = connettoreHttp.getAutenticazioneHttp() != null ? TipiConnettore.HTTP.getNome() : TipiConnettore.DISABILITATO.getNome();
                return connettoreHttp.getAutenticazioneHttps() != null ? TipiConnettore.HTTPS.getNome() : endpointtype;
            }
            case JMS: {
                return TipiConnettore.JMS.getNome();
            }
            case MESSAGE_BOX: {
                break;
            }
            case NULL: {
                return TipiConnettore.NULL.getNome();
            }
            case PLUGIN: {
                return TipiConnettore.CUSTOM.getNome();
            }
        }
        return TipiConnettore.DISABILITATO.getNome();
    }

    @Override
    public void updateErogazioneDescrizione(ApiDescrizione body, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfErogazione(tipoServizio, nome, versione, env.idSoggetto.toIDSoggetto(), env), (String)"Erogazione");
            asps.setDescrizione(body.getDescrizione());
            IDServizio oldIDServizioForUpdate = env.idServizioFactory.getIDServizioFromAccordo(asps);
            asps.setOldIDServizioForUpdate(oldIDServizioForUpdate);
            env.apsCore.performUpdateOperation(env.userLogin, false, new Object[]{asps});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateErogazioneInformazioniGenerali(ApiImplInformazioniGenerali body, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfErogazione(tipoServizio, nome, versione, env.idSoggetto.toIDSoggetto(), env), (String)"Erogazione");
            ErogazioniApiHelper.updateInformazioniGenerali(body, env, asps, true);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateErogazioneModI(ErogazioneModI body, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            IDAccordo idAccordo;
            AccordoServizioParteComune aspc;
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfErogazione(tipoServizio, nome, versione, env.idSoggetto.toIDSoggetto(), env), (String)"Erogazione");
            ProtocolProperties protocolProperties = null;
            if (profilo != null && (protocolProperties = ModiErogazioniApiHelper.updateModiProtocolProperties(aspc = Helper.getAccordoFull((idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(asps.getAccordoServizioParteComune())).getNome(), idAccordo.getVersione(), idAccordo.getSoggettoReferente(), env.apcCore), asps, profilo, body.getModi(), env)) != null) {
                asps.setProtocolPropertyList(ProtocolPropertiesUtils.toProtocolPropertiesRegistry((ProtocolProperties)protocolProperties, (ConsoleOperationType)ConsoleOperationType.ADD, null));
            }
            asps.setOldIDServizioForUpdate(env.idServizioFactory.getIDServizioFromAccordo(asps));
            ErogazioniApiHelper.validateProperties(env, protocolProperties, asps, ConsoleOperationType.CHANGE);
            env.apsCore.setDataAggiornamentoServizio(asps);
            List oggettiDaAggiornare = AccordiServizioParteSpecificaUtilities.getOggettiDaAggiornare((AccordoServizioParteSpecifica)asps, (AccordiServizioParteSpecificaCore)env.apsCore);
            env.apsCore.performUpdateOperation(env.userLogin, false, oggettiDaAggiornare.toArray());
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateErogazioneUrlInvocazione(ApiImplUrlInvocazione body, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            org.openspcoop2.message.constants.ServiceBinding serviceBinding;
            String oldNomePA;
            AccordoServizioParteSpecifica asps;
            IDPortaApplicativa idPorta;
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            if (body.getModalita() == null) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Specificare una modalit\u00e0 di identificazione azione valida");
            }
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            PortaApplicativa pa = (PortaApplicativa)BaseHelper.supplyOrNotFound(() -> ErogazioniApiServiceImpl.lambda$updateErogazioneUrlInvocazione$25(env, idPorta = (IDPortaApplicativa)BaseHelper.supplyOrNotFound(() -> ErogazioniApiServiceImpl.lambda$updateErogazioneUrlInvocazione$24(env, asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfErogazione(tipoServizio, nome, versione, env.idSoggetto.toIDSoggetto(), env), (String)"Accordo Servizio Parte Specifica")), (String)"Porta Applicativa Default")), (String)"Porta Applicativa Default");
            PortaApplicativaAzione paa = pa.getAzione() == null ? new PortaApplicativaAzione() : pa.getAzione();
            AccordoServizioParteComuneSintetico apc = env.apcCore.getAccordoServizioSintetico(asps.getIdAccordo().longValue());
            List identModes = env.paHelper.getModalitaIdentificazionePorta(env.tipo_protocollo, env.apcCore.toMessageServiceBinding(apc.getServiceBinding()), ConsoleInterfaceType.AVANZATA);
            if (identModes.contains(PortaApplicativaAzioneIdentificazione.PROTOCOL_BASED) && identModes.size() == 1) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Non puoi modificare la url-invocazione il cui metodo di identificazione azioni pu\u00f2 essere solo " + PortaApplicativaAzioneIdentificazione.PROTOCOL_BASED.toString());
            }
            if (!identModes.contains(PortaApplicativaAzioneIdentificazione.STATIC)) {
                identModes.add(PortaApplicativaAzioneIdentificazione.STATIC);
            }
            if (!identModes.contains(PortaApplicativaAzioneIdentificazione.valueOf((String)body.getModalita().name()))) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("La modalit\u00e0 di identificazione azione deve essere una fra: " + identModes.toString());
            }
            boolean setPattern = true;
            long idAzione = -1L;
            switch (body.getModalita()) {
                case CONTENT_BASED: {
                    if (body.getPattern() == null) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("La modalit\u00e0 di identificazione azione indicata (" + body.getModalita().toString() + ") richiede che sia definito il parametro 'pattern'");
                    }
                    paa.setPattern(body.getPattern());
                    paa.setForceInterfaceBased(Helper.boolToStatoFunzionalitaConf(body.isForceInterface()));
                    break;
                }
                case HEADER_BASED: {
                    if (body.getNome() == null && body.getPattern() == null) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("La modalit\u00e0 di identificazione azione indicata (" + body.getModalita().toString() + ") richiede che sia definito il parametro 'nome'");
                    }
                    if (body.getNome() != null && body.getPattern() != null) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("La modalit\u00e0 di identificazione azione indicata (" + body.getModalita().toString() + ") richiede che sia definito solo il parametro 'nome'");
                    }
                    if (body.getNome() != null) {
                        paa.setPattern(body.getNome());
                    } else {
                        paa.setPattern(body.getPattern());
                    }
                    setPattern = true;
                    paa.setForceInterfaceBased(Helper.boolToStatoFunzionalitaConf(body.isForceInterface()));
                    break;
                }
                case INPUT_BASED: {
                    paa.setForceInterfaceBased(Helper.boolToStatoFunzionalitaConf(body.isForceInterface()));
                    break;
                }
                case INTERFACE_BASED: {
                    break;
                }
                case SOAP_ACTION_BASED: {
                    if (!ServiceBinding.SOAP.equals((Object)apc.getServiceBinding())) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("La modalit\u00e0 di identificazione azione indicata (" + body.getModalita().toString() + ") non \u00e8 permessa per API di tipo " + apc.getServiceBinding());
                    }
                    paa.setForceInterfaceBased(Helper.boolToStatoFunzionalitaConf(body.isForceInterface()));
                    break;
                }
                case URL_BASED: {
                    if (!ServiceBinding.SOAP.equals((Object)apc.getServiceBinding())) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("La modalit\u00e0 di identificazione azione indicata (" + body.getModalita().toString() + ") non \u00e8 permessa per API di tipo " + apc.getServiceBinding());
                    }
                    if (body.getPattern() == null) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("La modalit\u00e0 di identificazione azione indicata (" + body.getModalita().toString() + ") richiede che sia definito il parametro 'pattern'");
                    }
                    paa.setPattern(body.getPattern());
                    paa.setForceInterfaceBased(Helper.boolToStatoFunzionalitaConf(body.isForceInterface()));
                    break;
                }
                case PROTOCOL_BASED: {
                    break;
                }
                case STATIC: {
                    if (!ServiceBinding.SOAP.equals((Object)apc.getServiceBinding())) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("La modalit\u00e0 di identificazione azione indicata (" + body.getModalita().toString() + ") non \u00e8 permessa per API di tipo " + apc.getServiceBinding());
                    }
                    PortTypeSintetico pt = null;
                    for (Object ptCheck : apc.getPortType()) {
                        if (!ptCheck.getNome().equals(asps.getPortType())) continue;
                        pt = ptCheck;
                        break;
                    }
                    if (pt == null) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("La modalit\u00e0 di identificazione azione indicata (" + body.getModalita().toString() + ") \u00e8 permessa solamente per API di tipo SOAP che definiscono 1 sola operazione: port-type non trovato");
                    }
                    if (pt.getAzione() == null || pt.getAzione().size() <= 0) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("La modalit\u00e0 di identificazione azione indicata (" + body.getModalita().toString() + ") \u00e8 permessa solamente per API di tipo SOAP che definiscono 1 sola operazione: non sono state trovate azioni");
                    }
                    if (pt.getAzione().size() > 1) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("La modalit\u00e0 di identificazione azione indicata (" + body.getModalita().toString() + ") \u00e8 permessa solamente per API di tipo SOAP che definiscono 1 sola operazione: sono state trovate " + pt.getAzione().size() + " azioni");
                    }
                    if (body.getNome() == null) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("La modalit\u00e0 di identificazione azione indicata (" + body.getModalita().toString() + ") richiede che sia definito il parametro 'nome'");
                    }
                    boolean findAzione = false;
                    for (OperationSintetica op : pt.getAzione()) {
                        if (!op.getNome().equals(body.getNome())) continue;
                        findAzione = true;
                        idAzione = op.getId();
                        break;
                    }
                    if (!findAzione) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("La modalit\u00e0 di identificazione azione indicata (" + body.getModalita().toString() + ") riferisce una azione '" + body.getNome() + "' non esistente");
                    }
                    paa.setNome(body.getNome());
                    setPattern = false;
                }
            }
            paa.setIdentificazione(Enum.valueOf(PortaApplicativaAzioneIdentificazione.class, body.getModalita().name()));
            String servizio = pa.getTipoSoggettoProprietario() + "/" + pa.getNomeSoggettoProprietario() + " " + pa.getServizio().getTipo() + "/" + pa.getServizio().getNome() + "/" + pa.getServizio().getVersione();
            env.requestWrapper.overrideParameter("id", pa.getId().toString());
            env.requestWrapper.overrideParameter("nomePorta", pa.getNome());
            env.requestWrapper.overrideParameter("idsogg", env.idSoggetto.getId().toString());
            env.requestWrapper.overrideParameter("soggvirt", "-");
            env.requestWrapper.overrideParameter("servizio", servizio);
            env.requestWrapper.overrideParameter("par_porte_azione", setPattern ? paa.getPattern() : paa.getNome());
            env.requestWrapper.overrideParameter("azid", null);
            env.requestWrapper.overrideParameter("modeaz", paa.getIdentificazione().toString());
            env.requestWrapper.overrideParameter("xsd", null);
            env.requestWrapper.overrideParameter("behaviour", "");
            env.requestWrapper.overrideParameter("integrazione", "");
            if (idAzione > 0L) {
                env.requestWrapper.overrideParameter("azid", "" + idAzione);
            }
            if (!env.paHelper.porteAppCheckData(TipoOperazione.CHANGE, oldNomePA = pa.getNome(), env.isSupportatoAutenticazioneSoggetti, false, serviceBinding = org.openspcoop2.message.constants.ServiceBinding.valueOf((String)apc.getServiceBinding().name()))) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml((String)env.pd.getMessage()));
            }
            pa.setOldIDPortaApplicativaForUpdate(idPorta);
            pa.setAzione(paa);
            env.paCore.performUpdateOperation(env.userLogin, false, new Object[]{pa});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    private static /* synthetic */ PortaApplicativa lambda$updateErogazioneUrlInvocazione$25(ErogazioniEnv env, IDPortaApplicativa idPorta) throws Exception {
        return env.paCore.getPortaApplicativa(idPorta);
    }

    private static /* synthetic */ IDPortaApplicativa lambda$updateErogazioneUrlInvocazione$24(ErogazioniEnv env, AccordoServizioParteSpecifica asps) throws Exception {
        return env.paCore.getIDPortaApplicativaAssociataDefault(env.idServizioFactory.getIDServizioFromAccordo(asps));
    }
}

