/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.rs.server.api.impl.erogazioni.gruppi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.constants.TipoAutenticazionePrincipal;
import org.openspcoop2.core.config.rs.server.api.ErogazioniGruppiApi;
import org.openspcoop2.core.config.rs.server.api.impl.Enums;
import org.openspcoop2.core.config.rs.server.api.impl.Helper;
import org.openspcoop2.core.config.rs.server.api.impl.IdServizio;
import org.openspcoop2.core.config.rs.server.api.impl.erogazioni.ErogazioniApiHelper;
import org.openspcoop2.core.config.rs.server.api.impl.erogazioni.ErogazioniEnv;
import org.openspcoop2.core.config.rs.server.config.ServerProperties;
import org.openspcoop2.core.config.rs.server.model.ApiDescrizione;
import org.openspcoop2.core.config.rs.server.model.Gruppo;
import org.openspcoop2.core.config.rs.server.model.GruppoAzioni;
import org.openspcoop2.core.config.rs.server.model.GruppoEreditaConfigurazione;
import org.openspcoop2.core.config.rs.server.model.GruppoItem;
import org.openspcoop2.core.config.rs.server.model.GruppoNome;
import org.openspcoop2.core.config.rs.server.model.GruppoNuovaConfigurazione;
import org.openspcoop2.core.config.rs.server.model.ListaGruppi;
import org.openspcoop2.core.config.rs.server.model.ModalitaConfigurazioneGruppoEnum;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.mapping.MappingErogazionePortaApplicativa;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.utils.BooleanNullable;
import org.openspcoop2.utils.service.BaseImpl;
import org.openspcoop2.utils.service.authorization.AuthorizationConfig;
import org.openspcoop2.utils.service.authorization.AuthorizationManager;
import org.openspcoop2.utils.service.beans.ProfiloEnum;
import org.openspcoop2.utils.service.beans.utils.BaseHelper;
import org.openspcoop2.utils.service.beans.utils.ListaUtils;
import org.openspcoop2.utils.service.context.IContext;
import org.openspcoop2.utils.service.fault.jaxrs.FaultCode;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaCore;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaHelper;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaPorteApplicativeMappingInfo;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaUtilities;
import org.openspcoop2.web.ctrlstat.servlet.pa.PorteApplicativeCore;
import org.openspcoop2.web.ctrlstat.servlet.pa.PorteApplicativeHelper;
import org.openspcoop2.web.ctrlstat.servlet.pa.PorteApplicativeUtilities;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.LoggerFactory;

public class ErogazioniGruppiApiServiceImpl
extends BaseImpl
implements ErogazioniGruppiApi {
    public ErogazioniGruppiApiServiceImpl() {
        super(LoggerFactory.getLogger(ErogazioniGruppiApiServiceImpl.class));
    }

    private AuthorizationConfig getAuthorizationConfig() throws Exception {
        return new AuthorizationConfig(ServerProperties.getInstance().getProperties());
    }

    @Override
    public void addErogazioneGruppoAzioni(GruppoAzioni body, String nome, Integer versione, String nomeGruppo, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfErogazione(tipoServizio, nome, versione, env.idSoggetto.toIDSoggetto(), env), (String)"Erogazione");
            IdServizio idAsps = new IdServizio(env.idServizioFactory.getIDServizioFromAccordo(asps), asps.getId());
            IDPortaApplicativa idPa = (IDPortaApplicativa)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getIDGruppoPA(nomeGruppo, idAsps, env.apsCore), (String)"Gruppo per l'erogazione scelta");
            PortaApplicativa pa = env.paCore.getPortaApplicativa(idPa);
            List<String> azioniOccupate = ErogazioniApiHelper.getAzioniOccupateErogazione(idAsps, env.apsCore, env.paCore);
            ErogazioniApiHelper.checkAzioniAdd(body.getAzioni(), azioniOccupate, env.apcCore.getAzioni(asps, env.apcCore.getAccordoServizioSintetico(asps.getIdAccordo().longValue()), false, false, null));
            env.requestWrapper.overrideParameterValues("azioni", body.getAzioni().toArray(new String[0]));
            List listaMappingErogazione = env.apsCore.mappingServiziPorteAppList((IDServizio)idAsps, asps.getId(), null);
            if (!env.paHelper.porteAppAzioneCheckData(TipoOperazione.ADD, azioniOccupate, listaMappingErogazione)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml((String)env.pd.getMessage()));
            }
            for (String azione : body.getAzioni()) {
                pa.getAzione().addAzioneDelegata(azione);
            }
            env.paCore.performUpdateOperation(env.userLogin, false, new Object[]{pa});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            context.getServletResponse().setStatus(201);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void createErogazioneGruppo(Gruppo body, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfErogazione(tipoServizio, nome, versione, env.idSoggetto.toIDSoggetto(), env), (String)"Erogazione");
            IdServizio idAsps = new IdServizio(env.idServizioFactory.getIDServizioFromAccordo(asps), asps.getId());
            String mappingPadre = null;
            String erogazioneAutenticazione = null;
            String erogazioneAutenticazioneOpzionale = null;
            TipoAutenticazionePrincipal erogazioneAutenticazionePrincipal = null;
            List<String> erogazioneAutenticazioneParametroList = null;
            if (body.getConfigurazione().getModalita() == ModalitaConfigurazioneGruppoEnum.NUOVA) {
                GruppoNuovaConfigurazione confNuova = (GruppoNuovaConfigurazione)ErogazioniApiHelper.deserializeModalitaConfGruppo(body.getConfigurazione().getModalita(), body.getConfigurazione());
                if (confNuova.getAutenticazione() != null) {
                    erogazioneAutenticazione = Enums.toTipoAutenticazione(confNuova.getAutenticazione().getTipo()).toString();
                    BooleanNullable autenticazioneOpzionaleNullable = ErogazioniApiHelper.getAutenticazioneOpzionale(confNuova.getAutenticazione());
                    erogazioneAutenticazioneOpzionale = ServletUtils.boolToCheckBoxStatus((Boolean)(autenticazioneOpzionaleNullable != null ? autenticazioneOpzionaleNullable.getValue() : null));
                    erogazioneAutenticazionePrincipal = ErogazioniApiHelper.getTipoAutenticazionePrincipal(confNuova.getAutenticazione());
                    erogazioneAutenticazioneParametroList = ErogazioniApiHelper.getAutenticazioneParametroList(env, confNuova.getAutenticazione().getTipo(), confNuova.getAutenticazione());
                }
            } else if (body.getConfigurazione().getModalita() == ModalitaConfigurazioneGruppoEnum.EREDITA) {
                GruppoEreditaConfigurazione confEredita = (GruppoEreditaConfigurazione)ErogazioniApiHelper.deserializeModalitaConfGruppo(body.getConfigurazione().getModalita(), body.getConfigurazione());
                List<MappingErogazionePortaApplicativa> mappings = ErogazioniApiHelper.getMappingGruppiPA(confEredita.getNome(), idAsps, env.apsCore);
                if (mappings.isEmpty()) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Il gruppo " + confEredita.getNome() + " da cui ereditare \u00e8 inesistente");
                }
                mappingPadre = mappings.get(0).getNome();
            }
            AccordiServizioParteSpecificaPorteApplicativeMappingInfo mappingInfo = AccordiServizioParteSpecificaUtilities.getMappingInfo(mappingPadre, (AccordoServizioParteSpecifica)asps, (AccordiServizioParteSpecificaCore)env.apsCore);
            MappingErogazionePortaApplicativa mappingSelezionato = mappingInfo.getMappingSelezionato();
            MappingErogazionePortaApplicativa mappingDefault = mappingInfo.getMappingDefault();
            List azioniOccupate = mappingInfo.getAzioniOccupate();
            if (mappingDefault == null) {
                throw FaultCode.NOT_FOUND.toException("Nessuna erogazione trovata");
            }
            if (mappingSelezionato == null) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Gruppo scelto non trovato");
            }
            ErogazioniApiHelper.checkAzioniAdd(body.getAzioni(), azioniOccupate, env.apcCore.getAzioni(asps, env.apcCore.getAccordoServizioSintetico(asps.getIdAccordo().longValue()), false, false, null));
            if (!env.apsHelper.configurazioneErogazioneCheckData(TipoOperazione.ADD, mappingInfo.getNomeNuovaConfigurazione(), body.getNome(), body.getAzioni().toArray(new String[0]), asps, azioniOccupate, body.getConfigurazione().getModalita().toString(), null, env.isSupportatoAutenticazioneSoggetti, mappingInfo)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml((String)env.pd.getMessage()));
            }
            AccordiServizioParteSpecificaUtilities.addAccordoServizioParteSpecificaPorteApplicative((MappingErogazionePortaApplicativa)mappingDefault, (MappingErogazionePortaApplicativa)mappingSelezionato, (String)mappingInfo.getNomeNuovaConfigurazione(), (String)body.getNome(), (String[])body.getAzioni().toArray(new String[0]), (String)body.getConfigurazione().getModalita().toString(), (String)body.getConfigurazione().getModalita().toString(), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, (boolean)false, (boolean)true, null, null, null, null, (boolean)false, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, (String)"no", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, (boolean)false, null, null, (String)erogazioneAutenticazione, (String)erogazioneAutenticazioneOpzionale, (TipoAutenticazionePrincipal)erogazioneAutenticazionePrincipal, erogazioneAutenticazioneParametroList, (String)"disabilitato", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, (String)"disabilitato", null, null, null, null, null, null, null, null, null, null, null, (AccordoServizioParteSpecifica)asps, (String)env.tipo_protocollo, (String)env.userLogin, (AccordiServizioParteSpecificaCore)env.apsCore, (AccordiServizioParteSpecificaHelper)env.apsHelper, null, null, null, null, null, null, null, null, null);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            context.getServletResponse().setStatus(201);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void deleteErogazioneGruppo(String nome, Integer versione, String nomeGruppo, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfErogazione(tipoServizio, nome, versione, env.idSoggetto.toIDSoggetto(), env), (String)"Erogazione");
            IdServizio idAsps = new IdServizio(env.idServizioFactory.getIDServizioFromAccordo(asps), asps.getId());
            IDPortaApplicativa idPortaApplicativa = ErogazioniApiHelper.getIDGruppoPA(nomeGruppo, idAsps, env.apsCore);
            if (env.delete_404 && idPortaApplicativa == null) {
                throw FaultCode.NOT_FOUND.toException("Gruppo con nome " + nomeGruppo + "non trovato per l'erogazione scelta");
            }
            if (idPortaApplicativa != null) {
                StringBuilder inUsoMessage = new StringBuilder();
                AccordiServizioParteSpecificaUtilities.deleteAccordoServizioParteSpecificaPorteApplicative((IDPortaApplicativa)idPortaApplicativa, (IDServizio)idAsps, (String)env.userLogin, (AccordiServizioParteSpecificaCore)env.apsCore, (AccordiServizioParteSpecificaHelper)env.apsHelper, (StringBuilder)inUsoMessage);
                if (inUsoMessage.length() > 0) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml((String)inUsoMessage.toString()));
                }
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void deleteErogazioneGruppoAzione(String nome, Integer versione, String nomeGruppo, String nomeAzione, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfErogazione(tipoServizio, nome, versione, env.idSoggetto.toIDSoggetto(), env), (String)"Erogazione");
            IdServizio idAsps = new IdServizio(env.idServizioFactory.getIDServizioFromAccordo(asps), asps.getId());
            IDPortaApplicativa idPa = (IDPortaApplicativa)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getIDGruppoPA(nomeGruppo, idAsps, env.apsCore), (String)"Gruppo per l'erogazione scelta");
            PortaApplicativa pa = env.paCore.getPortaApplicativa(idPa);
            if (BaseHelper.findFirst((Iterable)pa.getAzione().getAzioneDelegataList(), a -> a.equals(nomeAzione)).isPresent()) {
                StringBuilder inUsoMessage = new StringBuilder();
                PorteApplicativeUtilities.deletePortaApplicativaAzioni((PortaApplicativa)pa, (PorteApplicativeCore)env.paCore, (PorteApplicativeHelper)env.paHelper, (StringBuilder)inUsoMessage, (String)"\n", new ArrayList<String>(Arrays.asList(nomeAzione)), (String)env.userLogin);
                if (inUsoMessage.length() > 0) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml((String)inUsoMessage.toString()));
                }
            } else if (env.delete_404) {
                throw FaultCode.NOT_FOUND.toException("Azione " + nomeAzione + " non presente nel gruppo " + nomeGruppo);
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ListaGruppi findAllErogazioneGruppi(String nome, Integer versione, ProfiloEnum profilo, String soggetto, String tipoServizio, Integer limit, Integer offset, String azione) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfErogazione(tipoServizio, nome, versione, env.idSoggetto.toIDSoggetto(), env), (String)"Erogazione");
            IdServizio idAsps = new IdServizio(env.idServizioFactory.getIDServizioFromAccordo(asps), asps.getId());
            int idLista = Liste.CONFIGURAZIONE_EROGAZIONE;
            ConsoleSearch ricerca = Helper.setupRicercaPaginata(null, limit, offset, idLista, env.idSoggetto.toIDSoggetto(), env.tipo_protocollo);
            if (!StringUtils.isEmpty((CharSequence)azione)) {
                ricerca.addFilter(idLista, "filtroAzione", azione);
            }
            List mappings = env.apsCore.mappingServiziPorteAppList((IDServizio)idAsps, (ISearch)ricerca);
            if (env.findall_404 && mappings.isEmpty()) {
                throw FaultCode.NOT_FOUND.toException("Nessuna porta associata al servizio: " + idAsps.toString());
            }
            ListaGruppi ret = (ListaGruppi)ListaUtils.costruisciListaPaginata((UriInfo)context.getUriInfo(), (Integer)ricerca.getIndexIniziale(idLista), (Integer)ricerca.getPageSize(idLista), (long)ricerca.getNumEntries(idLista), ListaGruppi.class);
            for (MappingErogazionePortaApplicativa m : mappings) {
                PortaApplicativa pd = env.paCore.getPortaApplicativa(m.getIdPortaApplicativa());
                GruppoItem g = new GruppoItem();
                g.setAzioni(pd.getAzione().getAzioneDelegataList());
                g.setNome(m.getDescrizione());
                g.setPredefinito(m.isDefault());
                ret.addItemsItem(g);
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ApiDescrizione getErogazioneDescrizioneGruppo(String nome, Integer versione, String nomeGruppo, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfErogazione(tipoServizio, nome, versione, env.idSoggetto.toIDSoggetto(), env), (String)"Erogazione");
            IdServizio idAsps = new IdServizio(env.idServizioFactory.getIDServizioFromAccordo(asps), asps.getId());
            IDPortaApplicativa idPa = (IDPortaApplicativa)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getIDGruppoPA(nomeGruppo, idAsps, env.apsCore), (String)"Gruppo per l'erogazione scelta");
            PortaApplicativa pa = (PortaApplicativa)BaseHelper.supplyOrNotFound(() -> env.paCore.getPortaApplicativa(idPa), (String)"Gruppo per l'erogazione scelta");
            ApiDescrizione descr = new ApiDescrizione();
            descr.setDescrizione(pa.getDescrizione());
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return descr;
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public GruppoAzioni getErogazioneGruppoAzioni(String nome, Integer versione, String nomeGruppo, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfErogazione(tipoServizio, nome, versione, env.idSoggetto.toIDSoggetto(), env), (String)"Erogazione");
            IdServizio idAsps = new IdServizio(env.idServizioFactory.getIDServizioFromAccordo(asps), asps.getId());
            IDPortaApplicativa idPa = (IDPortaApplicativa)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getIDGruppoPA(nomeGruppo, idAsps, env.apsCore), (String)"Gruppo per l'erogazione scelta");
            PortaApplicativa pa = (PortaApplicativa)BaseHelper.supplyOrNotFound(() -> env.paCore.getPortaApplicativa(idPa), (String)"Gruppo per l'erogazione scelta");
            GruppoAzioni ret = new GruppoAzioni();
            ret.setAzioni(pa.getAzione().getAzioneDelegataList());
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateErogazioneDescrizioneGruppo(ApiDescrizione body, String nome, Integer versione, String nomeGruppo, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfErogazione(tipoServizio, nome, versione, env.idSoggetto.toIDSoggetto(), env), (String)"Erogazione");
            IdServizio idAsps = new IdServizio(env.idServizioFactory.getIDServizioFromAccordo(asps), asps.getId());
            IDPortaApplicativa idPa = (IDPortaApplicativa)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getIDGruppoPA(nomeGruppo, idAsps, env.apsCore), (String)"Gruppo per l'erogazione scelta");
            PortaApplicativa pa = (PortaApplicativa)BaseHelper.supplyOrNotFound(() -> env.paCore.getPortaApplicativa(idPa), (String)"Gruppo per l'erogazione scelta");
            pa.setDescrizione(body.getDescrizione());
            env.paCore.performUpdateOperation(env.userLogin, false, new Object[]{pa});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateErogazioneGruppoNome(GruppoNome body, String nome, Integer versione, String nomeGruppo, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfErogazione(tipoServizio, nome, versione, env.idSoggetto.toIDSoggetto(), env), (String)"Erogazione");
            IdServizio idAsps = new IdServizio(env.idServizioFactory.getIDServizioFromAccordo(asps), asps.getId());
            List listaMapping = env.apsCore.mappingServiziPorteAppList((IDServizio)idAsps, idAsps.getId(), null);
            List<String> mappingUtilizzati = ErogazioniApiHelper.getDescrizioniMappingPA(listaMapping);
            BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getIDGruppoPA(nomeGruppo, idAsps, env.apsCore), (String)"Gruppo per l'erogazione scelta");
            if (mappingUtilizzati.stream().filter(m -> m.equalsIgnoreCase(body.getNome())).findFirst().isPresent()) {
                throw FaultCode.CONFLITTO.toException("Il nome gruppo indicato &egrave; gi&agrave; utilizzato in un'altra configurazione");
            }
            if (!env.paHelper.configurazioneCambiaNomeCheck(TipoOperazione.OTHER, body.getNome(), mappingUtilizzati, false)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml((String)env.pd.getMessage()));
            }
            MappingErogazionePortaApplicativa mappingErogazionePortaApplicativa = AccordiServizioParteSpecificaUtilities.getMappingPAFilterByDescription((List)listaMapping, (String)nomeGruppo);
            mappingErogazionePortaApplicativa.setDescrizione(body.getNome());
            env.paCore.aggiornaDescrizioneMappingErogazionePortaApplicativa(mappingErogazionePortaApplicativa, env.userLogin);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }
}

