/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.rs.server.api.impl.scope;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringEscapeUtils;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.rs.server.api.ScopeApi;
import org.openspcoop2.core.config.rs.server.api.impl.Enums;
import org.openspcoop2.core.config.rs.server.api.impl.Helper;
import org.openspcoop2.core.config.rs.server.api.impl.scope.ScopeApiHelper;
import org.openspcoop2.core.config.rs.server.api.impl.scope.ScopeEnv;
import org.openspcoop2.core.config.rs.server.config.ServerProperties;
import org.openspcoop2.core.config.rs.server.model.ContestoEnum;
import org.openspcoop2.core.config.rs.server.model.ListaScope;
import org.openspcoop2.core.id.IDScope;
import org.openspcoop2.core.registry.Scope;
import org.openspcoop2.utils.service.BaseImpl;
import org.openspcoop2.utils.service.authorization.AuthorizationConfig;
import org.openspcoop2.utils.service.authorization.AuthorizationManager;
import org.openspcoop2.utils.service.beans.utils.BaseHelper;
import org.openspcoop2.utils.service.beans.utils.ListaUtils;
import org.openspcoop2.utils.service.context.IContext;
import org.openspcoop2.utils.service.fault.jaxrs.FaultCode;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.servlet.scope.ScopeCore;
import org.openspcoop2.web.ctrlstat.servlet.scope.ScopeHelper;
import org.openspcoop2.web.ctrlstat.servlet.scope.ScopeUtilities;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.LoggerFactory;

public class ScopeApiServiceImpl
extends BaseImpl
implements ScopeApi {
    public ScopeApiServiceImpl() {
        super(LoggerFactory.getLogger(ScopeApiServiceImpl.class));
    }

    private AuthorizationConfig getAuthorizationConfig() throws Exception {
        return new AuthorizationConfig(ServerProperties.getInstance().getProperties());
    }

    @Override
    public void createScope(org.openspcoop2.core.config.rs.server.model.Scope body) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            ScopeEnv env = new ScopeEnv(context.getServletRequest(), context);
            ScopeApiHelper.ovverrideParameters(env.requestWrapper, body);
            Scope regScope = ScopeApiHelper.apiScopeToRegistroScope(body, env.userLogin);
            if (env.scopeCore.existsScope(regScope.getNome())) {
                throw FaultCode.CONFLITTO.toException("Un scope con nome '" + regScope.getNome() + "' risulta gi\u00e0 registrato");
            }
            if (!env.scopeHelper.scopeCheckData(TipoOperazione.ADD, null)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml((String)env.pd.getMessage()));
            }
            env.scopeCore.performCreateOperation(env.userLogin, false, new Object[]{regScope});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            context.getServletResponse().setStatus(201);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void deleteScope(String nome) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ScopeEnv sEnv = new ScopeEnv(context.getServletRequest(), context);
            Scope scope = (Scope)BaseHelper.evalnull(() -> sEnv.scopeCore.getScope(nome));
            if (scope != null) {
                StringBuilder inUsoMessage = new StringBuilder();
                ScopeUtilities.deleteScope((Scope)scope, (String)sEnv.userLogin, (ScopeCore)sEnv.scopeCore, (ScopeHelper)sEnv.scopeHelper, (StringBuilder)inUsoMessage, (String)"\n");
                if (inUsoMessage.length() > 0) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml((String)inUsoMessage.toString()));
                }
            }
            if (scope == null && sEnv.delete_404) {
                throw FaultCode.NOT_FOUND.toException("Nessuno scope da eliminare corrisponde al nome: " + nome);
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ListaScope findAllScope(String q, Integer limit, Integer offset, ContestoEnum contesto) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ScopeEnv env = new ScopeEnv(context.getServletRequest(), context);
            int idLista = Liste.SCOPE;
            ConsoleSearch ricerca = Helper.setupRicercaPaginata(q, limit, offset, idLista);
            if (contesto != null) {
                ricerca.addFilter(idLista, "filtroScopeContesto", Enums.apiContestoToRegistroContesto.get((Object)contesto).toString());
            }
            List scopes = env.scopeCore.scopeList(null, (ISearch)ricerca);
            if (env.findall_404 && scopes.isEmpty()) {
                throw FaultCode.NOT_FOUND.toException("Nessuno scope corrisponde ai criteri di ricerca specificati");
            }
            ListaScope ret = (ListaScope)ListaUtils.costruisciListaPaginata((UriInfo)context.getUriInfo(), (Integer)ricerca.getIndexIniziale(idLista), (Integer)ricerca.getPageSize(idLista), (long)ricerca.getNumEntries(idLista), ListaScope.class);
            scopes.forEach(regScope -> ret.addItemsItem(ScopeApiHelper.registroScopeToScopeItem(regScope)));
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public org.openspcoop2.core.config.rs.server.model.Scope getScope(String nome) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ScopeEnv env = new ScopeEnv(context.getServletRequest(), context);
            Scope regScope = null;
            try {
                regScope = env.scopeCore.getScope(nome);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (regScope == null) {
                throw FaultCode.NOT_FOUND.toException("Non trovato alcuno scope con nome " + nome);
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ScopeApiHelper.registroScopeToScope(regScope);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateScope(org.openspcoop2.core.config.rs.server.model.Scope body, String nome) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            ScopeEnv env = new ScopeEnv(context.getServletRequest(), context);
            ScopeApiHelper.ovverrideParameters(env.requestWrapper, body);
            Scope scopeNEW = ScopeApiHelper.apiScopeToRegistroScope(body, env.userLogin);
            Scope scopeOLD = (Scope)BaseHelper.evalnull(() -> env.scopeCore.getScope(nome));
            if (scopeOLD == null) {
                throw FaultCode.NOT_FOUND.toException("Nessuno scope corrisponde al nome " + nome);
            }
            if (!env.scopeHelper.scopeCheckData(TipoOperazione.CHANGE, scopeOLD)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml((String)env.pd.getMessage()));
            }
            scopeNEW.setOldIDScopeForUpdate(new IDScope(nome));
            ArrayList<Scope> listOggettiDaAggiornare = new ArrayList<Scope>();
            listOggettiDaAggiornare.add(scopeNEW);
            if (!scopeNEW.getNome().equals(nome)) {
                IDScope oldIdScope = scopeNEW.getOldIDScopeForUpdate();
                oldIdScope.setNome(nome);
                ScopeUtilities.findOggettiDaAggiornare((IDScope)oldIdScope, (Scope)scopeNEW, (ScopeCore)env.scopeCore, listOggettiDaAggiornare);
            }
            env.scopeCore.performUpdateOperation(env.userLogin, false, listOggettiDaAggiornare.toArray());
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }
}

