/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.rs.server.api.impl.soggetti;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.byok.BYOKUtilities;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.Soggetto;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.rs.server.api.impl.ApiKeyInfo;
import org.openspcoop2.core.config.rs.server.api.impl.Helper;
import org.openspcoop2.core.config.rs.server.api.impl.HttpRequestWrapper;
import org.openspcoop2.core.config.rs.server.api.impl.soggetti.EDeliverySoggettiApiHelper;
import org.openspcoop2.core.config.rs.server.api.impl.soggetti.FatturaPASoggettiApiHelper;
import org.openspcoop2.core.config.rs.server.api.impl.soggetti.ModiSoggettiApiHelper;
import org.openspcoop2.core.config.rs.server.api.impl.soggetti.SPCoopSoggettiApiHelper;
import org.openspcoop2.core.config.rs.server.api.impl.soggetti.SoggettiEnv;
import org.openspcoop2.core.config.rs.server.model.AuthenticationApiKey;
import org.openspcoop2.core.config.rs.server.model.DominioEnum;
import org.openspcoop2.core.config.rs.server.model.ModalitaAccessoEnum;
import org.openspcoop2.core.config.rs.server.model.OneOfBaseCredenzialiCredenziali;
import org.openspcoop2.core.config.rs.server.model.Proprieta4000OpzioneCifratura;
import org.openspcoop2.core.config.rs.server.model.SoggettoItem;
import org.openspcoop2.core.constants.CostantiDB;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.Connettore;
import org.openspcoop2.core.registry.CredenzialiSoggetto;
import org.openspcoop2.core.registry.Proprieta;
import org.openspcoop2.core.registry.RuoliSoggetto;
import org.openspcoop2.core.registry.RuoloSoggetto;
import org.openspcoop2.core.registry.constants.CredenzialeTipo;
import org.openspcoop2.core.registry.constants.PddTipologia;
import org.openspcoop2.core.registry.constants.RuoloContesto;
import org.openspcoop2.core.registry.constants.RuoloTipologia;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.FiltroRicercaRuoli;
import org.openspcoop2.pdd.core.autenticazione.ApiKey;
import org.openspcoop2.pdd.core.autenticazione.ApiKeyUtilities;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.ConsoleOperationType;
import org.openspcoop2.protocol.sdk.properties.AbstractProperty;
import org.openspcoop2.protocol.sdk.properties.ConsoleConfiguration;
import org.openspcoop2.protocol.sdk.properties.IConsoleDynamicConfiguration;
import org.openspcoop2.protocol.sdk.properties.IConsoleHelper;
import org.openspcoop2.protocol.sdk.properties.ProtocolProperties;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesUtils;
import org.openspcoop2.protocol.sdk.registry.IConfigIntegrationReader;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.UtilsRuntimeException;
import org.openspcoop2.utils.service.beans.ProfiloEnum;
import org.openspcoop2.utils.service.beans.utils.BaseHelper;
import org.openspcoop2.utils.service.fault.jaxrs.FaultCode;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.dao.PdDControlStation;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationException;
import org.openspcoop2.web.ctrlstat.servlet.ConsoleHelper;
import org.openspcoop2.web.ctrlstat.servlet.pdd.PddCore;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCore;

public class SoggettiApiHelper {
    private SoggettiApiHelper() {
    }

    public static void validateCredentials(OneOfBaseCredenzialiCredenziali creds) {
        if (creds != null && ModalitaAccessoEnum.TOKEN.equals((Object)creds.getModalitaAccesso())) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException("Non \u00e8 possibile associare credenziali di tipo '" + creds.getModalitaAccesso() + "' ad un soggetto");
        }
    }

    public static ApiKeyInfo createApiKey(OneOfBaseCredenzialiCredenziali creds, IDSoggetto idSoggetto, SoggettiCore soggettiCore, String protocollo) throws DriverConfigurazioneException {
        if (creds != null && ModalitaAccessoEnum.API_KEY.equals((Object)creds.getModalitaAccesso())) {
            AuthenticationApiKey apiKey = (AuthenticationApiKey)creds;
            boolean appId = Helper.isAppId(apiKey.isAppId());
            ApiKeyInfo keyInfo = new ApiKeyInfo();
            keyInfo.setMultipleApiKeys(appId);
            ApiKey apiKeyGenerated = null;
            if (appId) {
                apiKeyGenerated = soggettiCore.newMultipleApiKey();
                keyInfo.setAppId(soggettiCore.toAppId(protocollo, idSoggetto, appId));
            } else {
                keyInfo.setAppId(soggettiCore.toAppId(protocollo, idSoggetto, appId));
                apiKeyGenerated = soggettiCore.newApiKey(protocollo, idSoggetto);
            }
            keyInfo.setPassword(apiKeyGenerated.getPassword());
            keyInfo.setApiKey(apiKeyGenerated.getApiKey());
            return keyInfo;
        }
        return null;
    }

    public static ApiKeyInfo getApiKey(org.openspcoop2.core.registry.Soggetto soggetto, boolean setApiKey) throws Exception {
        CredenzialiSoggetto c;
        if (soggetto != null && soggetto.sizeCredenzialiList() > 0 && CredenzialeTipo.APIKEY.equals((Object)(c = soggetto.getCredenziali(0)).getTipo())) {
            ApiKeyInfo keyInfo = new ApiKeyInfo();
            keyInfo.setMultipleApiKeys(c.isAppId());
            keyInfo.setAppId(c.getUser());
            keyInfo.setPassword(c.getPassword());
            keyInfo.setCifrata(c.isCertificateStrictVerification());
            if (setApiKey) {
                if (c.isAppId()) {
                    keyInfo.setApiKey(ApiKeyUtilities.encodeMultipleApiKey((String)c.getPassword()));
                } else {
                    keyInfo.setApiKey(ApiKeyUtilities.encodeApiKey((String)c.getUser(), (String)c.getPassword()));
                }
            }
            return keyInfo;
        }
        return null;
    }

    public static final void overrideAuthParams(ConsoleHelper consoleHelper, org.openspcoop2.core.config.rs.server.model.Soggetto soggetto, HttpRequestWrapper wrap, ApiKeyInfo apiKeyInfo, boolean updateKey) {
        if (soggetto != null) {
            SoggettiApiHelper.overrideAuthParams(consoleHelper, soggetto.getCredenziali(), wrap, apiKeyInfo, updateKey);
        }
    }

    public static final void overrideAuthParams(ConsoleHelper consoleHelper, OneOfBaseCredenzialiCredenziali credenziali, HttpRequestWrapper wrap, ApiKeyInfo apiKeyInfo, boolean updateKey) {
        if (credenziali != null && credenziali.getModalitaAccesso() != null) {
            wrap.overrideParameter("tipoauthCredenziali", Helper.tipoAuthFromModalitaAccesso.get((Object)credenziali.getModalitaAccesso()));
            Helper.overrideAuthParams(wrap, consoleHelper, credenziali, apiKeyInfo, updateKey);
        }
    }

    public static void convert(org.openspcoop2.core.config.rs.server.model.Soggetto body, org.openspcoop2.core.registry.Soggetto ret, SoggettiEnv env, ApiKeyInfo keyInfo) throws DriverRegistroServiziException, DriverControlStationException, IllegalAccessException, InvocationTargetException, InstantiationException, UtilsException {
        ret.setNome(body.getNome());
        ret.setDescrizione(body.getDescrizione());
        if (body.getDominio() == DominioEnum.INTERNO) {
            if (!env.multitenant) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Per registrare un nuovo soggetto interno passare alla modalit\u00e0 multitenant");
            }
            String nomePdd = env.pddCore.pddList(null, (ISearch)new ConsoleSearch(true)).stream().filter(pdd -> PddTipologia.OPERATIVO.toString().equals(pdd.getTipo())).map(pdd -> pdd.getNome()).findFirst().orElse("");
            if (nomePdd.length() == 0) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Nessuna porta operativa da associare al soggetto interno");
            }
            ret.setPortaDominio(nomePdd);
        }
        if (env.soggettiCore.isSupportatoAutenticazioneSoggetti(env.tipo_protocollo) && body.getCredenziali() != null && body.getCredenziali().getModalitaAccesso() != null) {
            try {
                List<CredenzialiSoggetto> credenziali = Helper.apiCredenzialiToGovwayCred(body.getCredenziali(), body.getCredenziali().getModalitaAccesso(), CredenzialiSoggetto.class, CredenzialeTipo.class, keyInfo);
                ret.getCredenzialiList().clear();
                ret.getCredenzialiList().addAll(credenziali);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
            }
        }
        SoggettiApiHelper.convertPropertyList(body, ret, env);
    }

    public static void convertPropertyList(org.openspcoop2.core.config.rs.server.model.Soggetto body, org.openspcoop2.core.registry.Soggetto ret, SoggettiEnv env) throws UtilsException {
        ret.getProprietaList().clear();
        if (body.getProprieta() != null && !body.getProprieta().isEmpty()) {
            for (Proprieta4000OpzioneCifratura proprieta : body.getProprieta()) {
                Proprieta pRegistry = new Proprieta();
                pRegistry.setNome(proprieta.getNome());
                if (env.soggettiCore != null && env.soggettiCore.getDriverBYOKUtilities() != null && proprieta.isEncrypted() != null && proprieta.isEncrypted().booleanValue()) {
                    pRegistry.setValore(env.soggettiCore.getDriverBYOKUtilities().wrap(proprieta.getValore()));
                } else {
                    if (proprieta.getValore().length() > 4000) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("Il valore della propriet\u00e0 non deve superare i 4000 caratteri");
                    }
                    pRegistry.setValore(proprieta.getValore());
                }
                ret.addProprieta(pRegistry);
            }
        }
    }

    public static final org.openspcoop2.core.registry.Soggetto soggettoApiToRegistro(org.openspcoop2.core.config.rs.server.model.Soggetto body, SoggettiEnv env, ApiKeyInfo keyInfo) throws DriverRegistroServiziNotFound, DriverRegistroServiziException, DriverControlStationException, IllegalAccessException, InvocationTargetException, InstantiationException, UtilsException {
        org.openspcoop2.core.registry.Soggetto ret = new org.openspcoop2.core.registry.Soggetto();
        SoggettiApiHelper.convert(body, ret, env, keyInfo);
        String protocollo = env.tipo_protocollo;
        IDSoggetto idSoggetto = new IDSoggetto(env.tipo_soggetto, body.getNome());
        ret.setVersioneProtocollo(env.soggettiCore.getVersioneDefaultProtocollo(protocollo));
        ret.setIdentificativoPorta(env.soggettiCore.getIdentificativoPortaDefault(protocollo, idSoggetto));
        ret.setCodiceIpa(env.soggettiCore.getCodiceIPADefault(protocollo, idSoggetto, false));
        ret.setSuperUser(env.userLogin);
        ret.setTipo(env.tipo_soggetto);
        if (body.getRuoli() != null) {
            FiltroRicercaRuoli filtroRuoli = new FiltroRicercaRuoli();
            filtroRuoli.setContesto(RuoloContesto.PORTA_APPLICATIVA);
            filtroRuoli.setTipologia(RuoloTipologia.INTERNO);
            List ruoliAmmessi = env.soggettiCore.getAllRuoli(filtroRuoli);
            RuoliSoggetto ruoliSoggetto = new RuoliSoggetto();
            body.getRuoli().forEach(rname -> {
                if (!ruoliAmmessi.contains(rname)) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Non esiste alcun ruolo con nome " + rname + " da associare al soggetto.");
                }
                RuoloSoggetto rs = new RuoloSoggetto();
                rs.setNome(rname);
                ruoliSoggetto.addRuolo(rs);
            });
            ret.setRuoli(ruoliSoggetto);
        }
        ret.setPrivato(Boolean.valueOf(false));
        Connettore connettore = new Connettore();
        connettore.setTipo(CostantiDB.CONNETTORE_TIPO_DISABILITATO);
        ret.setConnettore(connettore);
        return ret;
    }

    public static final org.openspcoop2.core.config.rs.server.model.Soggetto soggettoRegistroToApi(org.openspcoop2.core.registry.Soggetto s, PddCore pddCore, SoggettiCore soggettiCore) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, DriverConfigurazioneException {
        org.openspcoop2.core.config.rs.server.model.Soggetto ret = new org.openspcoop2.core.config.rs.server.model.Soggetto();
        ret.setNome(s.getNome());
        ret.setDescrizione(s.getDescrizione());
        ret.setDominio(DominioEnum.ESTERNO);
        try {
            if (s.getPortaDominio() != null) {
                PdDControlStation p = pddCore.getPdDControlStation(s.getPortaDominio());
                if (PddTipologia.OPERATIVO.toString().equals(p.getTipo())) {
                    ret.setDominio(DominioEnum.INTERNO);
                }
            }
        }
        catch (Exception e) {
            throw new UtilsRuntimeException((Throwable)e);
        }
        if (DominioEnum.ESTERNO.equals((Object)ret.getDominio())) {
            ret.setCredenziali(Helper.govwayCredenzialiToApi(s.getCredenzialiList(), CredenzialiSoggetto.class, CredenzialeTipo.class));
        }
        ret.setRuoli(soggettiCore.soggettiRuoliList(s.getId().longValue(), (ISearch)new ConsoleSearch()));
        if (s.sizeProprietaList() > 0) {
            for (Proprieta proprieta : s.getProprietaList()) {
                Proprieta4000OpzioneCifratura p = new Proprieta4000OpzioneCifratura();
                p.setNome(proprieta.getNome());
                p.setValore(proprieta.getValore());
                p.setEncrypted(BYOKUtilities.isWrappedValue((String)p.getValore()));
                if (ret.getProprieta() == null) {
                    ret.setProprieta(new ArrayList<Proprieta4000OpzioneCifratura>());
                }
                ret.addProprietaItem(p);
            }
        }
        return ret;
    }

    public static final Soggetto soggettoRegistroToConfig(org.openspcoop2.core.registry.Soggetto s, Soggetto ret, boolean isRouter) {
        ret.setNome(s.getNome());
        ret.setTipo(s.getTipo());
        ret.setDescrizione(s.getDescrizione());
        ret.setIdentificativoPorta(s.getIdentificativoPorta());
        ret.setRouter(isRouter);
        ret.setSuperUser(s.getSuperUser());
        return ret;
    }

    public static SoggettoItem soggettoRegistroToItem(org.openspcoop2.core.registry.Soggetto s, PddCore pddCore, SoggettiCore soggettiCore) {
        SoggettoItem ret = new SoggettoItem();
        ret.setNome(s.getNome());
        ret.setDominio(DominioEnum.ESTERNO);
        try {
            if (s.getPortaDominio() != null) {
                PdDControlStation p = pddCore.getPdDControlStation(s.getPortaDominio());
                if (PddTipologia.OPERATIVO.toString().equals(p.getTipo())) {
                    ret.setDominio(DominioEnum.INTERNO);
                }
            }
            ConsoleSearch searchForCount = new ConsoleSearch(true, 1);
            soggettiCore.soggettiRuoliList(s.getId().longValue(), (ISearch)searchForCount);
            int numRuoli = searchForCount.getNumEntries(Liste.SOGGETTI_RUOLI);
            ret.setCountRuoli(numRuoli);
            String tipoProtocollo = ProtocolFactoryManager.getInstance().getProtocolByOrganizationType(s.getTipo());
            ret.setProfilo((ProfiloEnum)BaseHelper.profiloFromTipoProtocollo.get(tipoProtocollo));
        }
        catch (Exception e) {
            throw new UtilsRuntimeException((Throwable)e);
        }
        return ret;
    }

    public static ProtocolProperties getProtocolProperties(org.openspcoop2.core.config.rs.server.model.Soggetto body, ProfiloEnum profilo, org.openspcoop2.core.registry.Soggetto soggetto, SoggettiEnv env) throws Exception {
        if (!profilo.equals((Object)ProfiloEnum.MODI) && !profilo.equals((Object)ProfiloEnum.MODIPA) && body.getModi() != null) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException("Configurazione 'ModI' non conforme con il profilo '" + profilo + "' indicato");
        }
        switch (profilo) {
            case APIGATEWAY: {
                return null;
            }
            case EDELIVERY: {
                return EDeliverySoggettiApiHelper.getProtocolProperties(body);
            }
            case FATTURAPA: {
                return FatturaPASoggettiApiHelper.getProtocolProperties(body);
            }
            case MODI: 
            case MODIPA: {
                return ModiSoggettiApiHelper.getProtocolProperties(body);
            }
            case SPCOOP: {
                return SPCoopSoggettiApiHelper.getProtocolProperties(body);
            }
        }
        return null;
    }

    public static void populateProtocolInfo(org.openspcoop2.core.registry.Soggetto soggetto, org.openspcoop2.core.config.rs.server.model.Soggetto ret, SoggettiEnv env, ProfiloEnum profilo) throws Exception {
        if (profilo != null) {
            switch (profilo) {
                case APIGATEWAY: {
                    break;
                }
                case EDELIVERY: {
                    EDeliverySoggettiApiHelper.populateProtocolInfo(soggetto, env, ret);
                    break;
                }
                case FATTURAPA: {
                    FatturaPASoggettiApiHelper.populateProtocolInfo(soggetto, env, ret);
                    break;
                }
                case MODI: 
                case MODIPA: {
                    ModiSoggettiApiHelper.populateProtocolInfo(soggetto, env, ret);
                    break;
                }
                case SPCOOP: {
                    SPCoopSoggettiApiHelper.populateProtocolInfo(soggetto, env, ret);
                    break;
                }
            }
        }
    }

    public static Map<String, AbstractProperty<?>> getProtocolPropertiesMap(org.openspcoop2.core.registry.Soggetto soggetto, SoggettiEnv env) throws DriverControlStationException, UtilsException, ProtocolException, DriverConfigurazioneException {
        ProtocolProperties prop = SoggettiApiHelper.getProtocolProperties(soggetto, env);
        HashMap p = new HashMap();
        for (int i = 0; i < prop.sizeProperties(); ++i) {
            p.put(prop.getIdProperty(i), prop.getProperty(i));
        }
        return p;
    }

    public static ProtocolProperties getProtocolProperties(org.openspcoop2.core.registry.Soggetto soggetto, SoggettiEnv env) throws DriverControlStationException, UtilsException, ProtocolException, DriverConfigurazioneException {
        ConsoleConfiguration consoleConf = SoggettiApiHelper.getConsoleConfiguration(soggetto, env);
        ProtocolProperties prop = env.soggettiHelper.estraiProtocolPropertiesDaRequest(consoleConf, ConsoleOperationType.CHANGE);
        ProtocolPropertiesUtils.mergeProtocolPropertiesRegistry((ProtocolProperties)prop, (List)soggetto.getProtocolPropertyList(), (ConsoleOperationType)ConsoleOperationType.CHANGE);
        return prop;
    }

    public static ConsoleConfiguration getConsoleConfiguration(org.openspcoop2.core.registry.Soggetto soggetto, SoggettiEnv env) throws ProtocolException, DriverConfigurazioneException {
        IConsoleDynamicConfiguration consoleDynamicConfiguration = env.protocolFactory.createDynamicConfigurationConsole();
        IRegistryReader registryReader = env.soggettiCore.getRegistryReader(env.protocolFactory);
        IConfigIntegrationReader configRegistryReader = env.soggettiCore.getConfigIntegrationReader(env.protocolFactory);
        IDSoggetto idSoggetto = new IDSoggetto(env.tipo_soggetto, soggetto.getNome());
        return consoleDynamicConfiguration.getDynamicConfigSoggetto(ConsoleOperationType.ADD, (IConsoleHelper)env.soggettiHelper, registryReader, configRegistryReader, idSoggetto);
    }
}

