/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.rs.server.api.impl.soggetti;

import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.Soggetto;
import org.openspcoop2.core.config.rs.server.api.SoggettiApi;
import org.openspcoop2.core.config.rs.server.api.impl.ApiKeyInfo;
import org.openspcoop2.core.config.rs.server.api.impl.Helper;
import org.openspcoop2.core.config.rs.server.api.impl.soggetti.SoggettiApiHelper;
import org.openspcoop2.core.config.rs.server.api.impl.soggetti.SoggettiEnv;
import org.openspcoop2.core.config.rs.server.config.ServerProperties;
import org.openspcoop2.core.config.rs.server.model.AuthenticationApiKey;
import org.openspcoop2.core.config.rs.server.model.AuthenticationHttpBasic;
import org.openspcoop2.core.config.rs.server.model.BaseCredenziali;
import org.openspcoop2.core.config.rs.server.model.DominioEnum;
import org.openspcoop2.core.config.rs.server.model.ListaSoggetti;
import org.openspcoop2.core.config.rs.server.model.ModalitaAccessoEnum;
import org.openspcoop2.core.config.rs.server.model.OneOfBaseCredenzialiCredenziali;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.CredenzialiSoggetto;
import org.openspcoop2.core.registry.constants.CredenzialeTipo;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.constants.ConsoleOperationType;
import org.openspcoop2.protocol.sdk.properties.ProtocolProperties;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesUtils;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.service.BaseImpl;
import org.openspcoop2.utils.service.authorization.AuthorizationConfig;
import org.openspcoop2.utils.service.authorization.AuthorizationManager;
import org.openspcoop2.utils.service.beans.ProfiloEnum;
import org.openspcoop2.utils.service.beans.utils.BaseHelper;
import org.openspcoop2.utils.service.beans.utils.ListaUtils;
import org.openspcoop2.utils.service.context.IContext;
import org.openspcoop2.utils.service.fault.jaxrs.FaultCode;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.dao.SoggettoCtrlStat;
import org.openspcoop2.web.ctrlstat.servlet.ConsoleHelper;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCore;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiHelper;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiUtilities;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.LoggerFactory;

public class SoggettiApiServiceImpl
extends BaseImpl
implements SoggettiApi {
    public SoggettiApiServiceImpl() {
        super(LoggerFactory.getLogger(SoggettiApiServiceImpl.class));
    }

    private AuthorizationConfig getAuthorizationConfig() throws UtilsException {
        return new AuthorizationConfig(ServerProperties.getInstance().getProperties());
    }

    @Override
    public void createSoggetto(org.openspcoop2.core.config.rs.server.model.Soggetto body, ProfiloEnum profilo) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            if (profilo == null) {
                profilo = Helper.getProfiloDefault();
            }
            SoggettiEnv env = new SoggettiEnv(context.getServletRequest(), profilo, context);
            org.openspcoop2.core.config.rs.server.model.Soggetto soggetto = null;
            try {
                soggetto = body;
                if (soggetto.getCredenziali() != null && soggetto.getCredenziali().getModalitaAccesso() != null) {
                    soggetto.setCredenziali(Helper.translateCredenziali(soggetto.getCredenziali(), true));
                }
            }
            catch (WebApplicationException e) {
                throw e;
            }
            catch (Exception e) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException((Throwable)e);
            }
            String protocollo = env.protocolFactory.getProtocol();
            String tipoSoggetto = (String)ProtocolFactoryManager.getInstance().getDefaultOrganizationTypes().get((Object)protocollo);
            IDSoggetto idSoggetto = new IDSoggetto(tipoSoggetto, soggetto.getNome());
            SoggettiApiHelper.validateCredentials(soggetto.getCredenziali());
            ApiKeyInfo keyInfo = null;
            if (soggetto.getCredenziali() != null && soggetto.getCredenziali().getModalitaAccesso() != null) {
                keyInfo = SoggettiApiHelper.createApiKey(soggetto.getCredenziali(), idSoggetto, env.soggettiCore, protocollo);
                boolean updateKey = false;
                SoggettiApiHelper.overrideAuthParams((ConsoleHelper)env.soggettiHelper, soggetto, env.requestWrapper, keyInfo, updateKey);
            }
            org.openspcoop2.core.registry.Soggetto soggettoRegistro = SoggettiApiHelper.soggettoApiToRegistro(soggetto, env, keyInfo);
            ProtocolProperties protocolProperties = null;
            if (profilo != null && (protocolProperties = SoggettiApiHelper.getProtocolProperties(body, profilo, soggettoRegistro, env)) != null) {
                soggettoRegistro.setProtocolPropertyList(ProtocolPropertiesUtils.toProtocolPropertiesRegistry((ProtocolProperties)protocolProperties, (ConsoleOperationType)ConsoleOperationType.ADD, null));
            }
            IDSoggetto idSogg = new IDSoggetto();
            idSogg.setNome(soggettoRegistro.getNome());
            idSogg.setTipo(soggettoRegistro.getTipo());
            idSogg.setCodicePorta(soggettoRegistro.getIdentificativoPorta());
            if (env.soggettiCore.existsSoggetto(idSogg)) {
                throw FaultCode.CONFLITTO.toException("Esiste gi\u00e0 un soggetto con il nome e il tipo scelti");
            }
            if (env.soggettiCore.existsSoggetto(soggettoRegistro.getCodiceIpa())) {
                throw FaultCode.CONFLITTO.toException("Esiste gi\u00e0 un soggetto con codice IPA " + soggettoRegistro.getCodiceIpa());
            }
            boolean isOk = env.soggettiHelper.soggettiCheckData(TipoOperazione.ADD, null, env.tipo_soggetto, soggettoRegistro.getNome(), soggettoRegistro.getCodiceIpa(), null, null, null, false, soggettoRegistro.getDescrizione(), soggettoRegistro.getPortaDominio());
            if (!isOk) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml((String)env.pd.getMessage()));
            }
            Soggetto soggettoConfig = SoggettiApiHelper.soggettoRegistroToConfig(soggettoRegistro, new Soggetto(), false);
            SoggettoCtrlStat sog = new SoggettoCtrlStat(soggettoRegistro, soggettoConfig);
            env.soggettiCore.performCreateOperation(env.userLogin, false, new Object[]{sog});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            if (keyInfo != null) {
                context.getServletResponse().setHeader("X-Api-Key", keyInfo.getApiKey());
                if (keyInfo.isMultipleApiKeys()) {
                    context.getServletResponse().setHeader("X-App-Id", keyInfo.getAppId());
                }
            }
            context.getServletResponse().setStatus(201);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void deleteSoggetto(String nome, ProfiloEnum profilo) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            if (profilo == null) {
                profilo = Helper.getProfiloDefault();
            }
            SoggettiEnv env = new SoggettiEnv(context.getServletRequest(), profilo, context);
            IDSoggetto idSogg = new IDSoggetto(env.tipo_soggetto, nome);
            org.openspcoop2.core.registry.Soggetto soggettoRegistro = (org.openspcoop2.core.registry.Soggetto)BaseHelper.evalnull(() -> env.soggettiCore.getSoggettoRegistro(idSogg));
            Soggetto soggettoConfig = (Soggetto)BaseHelper.evalnull(() -> env.soggettiCore.getSoggetto(soggettoRegistro.getId().longValue()));
            if (soggettoRegistro != null && soggettoConfig != null) {
                StringBuilder inUsoMessage = new StringBuilder();
                SoggettiUtilities.deleteSoggetto((org.openspcoop2.core.registry.Soggetto)soggettoRegistro, (Soggetto)soggettoConfig, (String)env.userLogin, (SoggettiCore)env.soggettiCore, (SoggettiHelper)env.soggettiHelper, (StringBuilder)inUsoMessage, (String)"\n");
                if (inUsoMessage.length() > 0) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.escapeHtml((String)inUsoMessage.toString()));
                }
            } else if (env.delete_404) {
                throw FaultCode.NOT_FOUND.toException("Nessun soggetto corrisponde al nome e il profilo indicati");
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ListaSoggetti findAllSoggetti(ProfiloEnum profilo, String q, Integer limit, Integer offset, DominioEnum dominio, String ruolo, ModalitaAccessoEnum tipoCredenziali, Boolean profiloQualsiasi) {
        IContext context = this.getContext();
        try {
            List soggetti;
            String filtro;
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            if (profilo == null) {
                profilo = Helper.getProfiloDefault();
            }
            SoggettiEnv env = new SoggettiEnv(context.getServletRequest(), profilo, context);
            int idLista = Liste.SOGGETTI;
            ConsoleSearch ricerca = Helper.setupRicercaPaginata(q, limit, offset, idLista, env.idSoggetto.toIDSoggetto(), env.tipo_protocollo);
            if (profiloQualsiasi != null && profiloQualsiasi.booleanValue()) {
                ricerca.clearFilter(idLista, "filtroProtocollo");
            }
            if (dominio != null) {
                ricerca.addFilter(idLista, "filtroDominio", dominio.toString());
            }
            if (ruolo != null && ruolo.trim().length() > 0) {
                ricerca.addFilter(idLista, "filtroRuolo", ruolo.trim());
            }
            if (tipoCredenziali != null && (filtro = Helper.tipoAuthFromModalitaAccesso.get((Object)tipoCredenziali)) != null && !"".equals(filtro)) {
                ricerca.addFilter(idLista, "filtroTipoCredenziali", filtro);
            }
            if ((soggetti = env.soggettiCore.soggettiRegistroList(null, (ISearch)ricerca)).size() == 0 && env.findall_404) {
                throw FaultCode.NOT_FOUND.toException("Nessun soggetto corrisponde ai criteri di ricerca specificati");
            }
            ListaSoggetti ret = (ListaSoggetti)ListaUtils.costruisciListaPaginata((UriInfo)context.getUriInfo(), (Integer)ricerca.getIndexIniziale(idLista), (Integer)ricerca.getPageSize(idLista), (long)ricerca.getNumEntries(idLista), ListaSoggetti.class);
            soggetti.forEach(s -> ret.addItemsItem(SoggettiApiHelper.soggettoRegistroToItem(s, env.pddCore, env.soggettiCore)));
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public org.openspcoop2.core.config.rs.server.model.Soggetto getSoggetto(String nome, ProfiloEnum profilo) {
        IContext context = this.getContext();
        try {
            IDSoggetto idSogg;
            SoggettiEnv env;
            org.openspcoop2.core.registry.Soggetto soggettoReg;
            org.openspcoop2.core.config.rs.server.model.Soggetto soggettoApi;
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            if (profilo == null) {
                profilo = Helper.getProfiloDefault();
            }
            if ((soggettoApi = (org.openspcoop2.core.config.rs.server.model.Soggetto)BaseHelper.supplyOrNotFound(() -> SoggettiApiServiceImpl.lambda$getSoggetto$4(soggettoReg = (org.openspcoop2.core.registry.Soggetto)BaseHelper.supplyOrNotFound(() -> SoggettiApiServiceImpl.lambda$getSoggetto$3(env = new SoggettiEnv(context.getServletRequest(), profilo, context), idSogg = new IDSoggetto(env.tipo_soggetto, nome)), (String)("Soggetto " + idSogg.toString())), env), (String)("Soggetto " + idSogg.toString()))) == null) {
                throw FaultCode.NOT_FOUND.toException("Nessun soggetto trovato corrisponde al nome " + nome + " e profilo " + profilo.toString());
            }
            SoggettiApiHelper.populateProtocolInfo(soggettoReg, soggettoApi, env, profilo);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return soggettoApi;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateCredenzialiSoggetto(BaseCredenziali body, String nome, ProfiloEnum profilo) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            if (profilo == null) {
                profilo = Helper.getProfiloDefault();
            }
            SoggettiApiHelper.validateCredentials(body.getCredenziali());
            OneOfBaseCredenzialiCredenziali credenziali = null;
            try {
                credenziali = Helper.translateCredenziali(body.getCredenziali(), true);
            }
            catch (WebApplicationException e) {
                throw e;
            }
            catch (Throwable e) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(e);
            }
            SoggettiEnv env = new SoggettiEnv(context.getServletRequest(), profilo, context);
            IDSoggetto idSogg = new IDSoggetto(env.tipo_soggetto, nome);
            org.openspcoop2.core.registry.Soggetto oldSoggetto = null;
            try {
                oldSoggetto = env.soggettiCore.getSoggettoRegistro(idSogg);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (oldSoggetto == null) {
                throw FaultCode.NOT_FOUND.toException("Nessun soggetto trovato corrisponde al nome " + nome + " e profilo " + profilo.toString());
            }
            ApiKeyInfo keyInfo = SoggettiApiHelper.createApiKey(credenziali, idSogg, env.soggettiCore, env.protocolFactory.getProtocol());
            boolean updateKey = true;
            SoggettiApiHelper.overrideAuthParams((ConsoleHelper)env.soggettiHelper, credenziali, env.requestWrapper, keyInfo, updateKey);
            org.openspcoop2.core.registry.Soggetto newSoggetto = env.soggettiCore.getSoggettoRegistro(idSogg);
            try {
                List<CredenzialiSoggetto> newCredenziali = Helper.apiCredenzialiToGovwayCred(body.getCredenziali(), body.getCredenziali().getModalitaAccesso(), CredenzialiSoggetto.class, CredenzialeTipo.class, keyInfo);
                newSoggetto.getCredenzialiList().clear();
                newSoggetto.getCredenzialiList().addAll(newCredenziali);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
            }
            boolean isOk = env.soggettiHelper.soggettiCheckData(TipoOperazione.CHANGE, oldSoggetto.getId().toString(), env.tipo_soggetto, newSoggetto.getNome(), newSoggetto.getCodiceIpa(), null, null, oldSoggetto, false, newSoggetto.getDescrizione(), newSoggetto.getPortaDominio());
            if (!isOk) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml((String)env.pd.getMessage()));
            }
            newSoggetto.setOldIDSoggettoForUpdate(new IDSoggetto(oldSoggetto.getTipo(), oldSoggetto.getNome()));
            env.soggettiCore.performUpdateOperation(env.userLogin, false, new Object[]{newSoggetto});
            if (keyInfo != null) {
                context.getServletResponse().setHeader("X-Api-Key", keyInfo.getApiKey());
                if (keyInfo.isMultipleApiKeys()) {
                    context.getServletResponse().setHeader("X-App-Id", keyInfo.getAppId());
                }
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateSoggetto(org.openspcoop2.core.config.rs.server.model.Soggetto body, String nome, ProfiloEnum profilo) {
        IContext context = this.getContext();
        try {
            boolean isOk;
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            if (profilo == null) {
                profilo = Helper.getProfiloDefault();
            }
            SoggettiApiHelper.validateCredentials(body.getCredenziali());
            org.openspcoop2.core.config.rs.server.model.Soggetto soggetto = null;
            try {
                soggetto = body;
                soggetto.setCredenziali(Helper.translateCredenziali(soggetto.getCredenziali(), false));
            }
            catch (WebApplicationException e) {
                throw e;
            }
            catch (Throwable e) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(e);
            }
            SoggettiEnv env = new SoggettiEnv(context.getServletRequest(), profilo, context);
            IDSoggetto idSogg = new IDSoggetto(env.tipo_soggetto, nome);
            org.openspcoop2.core.registry.Soggetto oldSoggetto = null;
            try {
                oldSoggetto = env.soggettiCore.getSoggettoRegistro(idSogg);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (oldSoggetto == null) {
                throw FaultCode.NOT_FOUND.toException("Nessun soggetto trovato corrisponde al nome " + nome + " e profilo " + profilo.toString());
            }
            ApiKeyInfo keyInfo = SoggettiApiHelper.getApiKey(oldSoggetto, false);
            boolean updateKey = false;
            SoggettiApiHelper.overrideAuthParams((ConsoleHelper)env.soggettiHelper, soggetto, env.requestWrapper, keyInfo, updateKey);
            SoggettoCtrlStat oldSoggettoCtrlStat = env.soggettiCore.getSoggettoCtrlStat(oldSoggetto.getId().longValue());
            org.openspcoop2.core.registry.Soggetto newSoggetto = env.soggettiCore.getSoggettoRegistro(idSogg);
            SoggettiApiHelper.convert(body, newSoggetto, env, keyInfo);
            if (body.getCredenziali() != null && body.getCredenziali().getModalitaAccesso() != null) {
                AuthenticationApiKey apiKeyCred;
                boolean appId;
                if (ModalitaAccessoEnum.HTTP_BASIC.equals((Object)body.getCredenziali().getModalitaAccesso())) {
                    AuthenticationHttpBasic httpBasic = (AuthenticationHttpBasic)body.getCredenziali();
                    if (httpBasic.getPassword() == null || StringUtils.isEmpty((String)httpBasic.getPassword())) {
                        boolean set = false;
                        if (oldSoggetto.sizeCredenzialiList() > 0) {
                            CredenzialiSoggetto cImageDB = oldSoggetto.getCredenziali(0);
                            CredenzialiSoggetto cTmp = newSoggetto.getCredenziali(0);
                            if (cImageDB != null && cTmp != null) {
                                cTmp.setPassword(cImageDB.getPassword());
                                cTmp.setCertificateStrictVerification(cImageDB.isCertificateStrictVerification());
                                set = true;
                            }
                        }
                        if (!set) {
                            throw FaultCode.RICHIESTA_NON_VALIDA.toException("Tipo di autenticazione '" + body.getCredenziali().getModalitaAccesso() + "'; indicare la password");
                        }
                    }
                } else if (ModalitaAccessoEnum.API_KEY.equals((Object)body.getCredenziali().getModalitaAccesso()) && (appId = Helper.isAppId((apiKeyCred = (AuthenticationApiKey)body.getCredenziali()).isAppId())) != keyInfo.isMultipleApiKeys()) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Tipo di autenticazione '" + body.getCredenziali().getModalitaAccesso() + "'; modifica del tipo (appId) non consentita");
                }
            }
            ProtocolProperties protocolProperties = null;
            if (profilo != null && (protocolProperties = SoggettiApiHelper.getProtocolProperties(body, profilo, newSoggetto, env)) != null) {
                newSoggetto.setProtocolPropertyList(ProtocolPropertiesUtils.toProtocolPropertiesRegistry((ProtocolProperties)protocolProperties, (ConsoleOperationType)ConsoleOperationType.ADD, null));
            }
            if (!(isOk = env.soggettiHelper.soggettiCheckData(TipoOperazione.CHANGE, oldSoggetto.getId().toString(), env.tipo_soggetto, newSoggetto.getNome(), newSoggetto.getCodiceIpa(), null, null, oldSoggetto, false, newSoggetto.getDescrizione(), newSoggetto.getPortaDominio()))) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml((String)env.pd.getMessage()));
            }
            Soggetto soggettoConfig = SoggettiApiHelper.soggettoRegistroToConfig(newSoggetto, oldSoggettoCtrlStat.getSoggettoConf(), false);
            newSoggetto.setOldIDSoggettoForUpdate(new IDSoggetto(oldSoggetto.getTipo(), oldSoggetto.getNome()));
            soggettoConfig.setOldIDSoggettoForUpdate(new IDSoggetto(oldSoggetto.getTipo(), oldSoggetto.getNome()));
            SoggettoCtrlStat sog = new SoggettoCtrlStat(newSoggetto, soggettoConfig);
            sog.setOldNomeForUpdate(oldSoggetto.getNome());
            sog.setOldTipoForUpdate(oldSoggetto.getTipo());
            List listOggettiDaAggiornare = SoggettiUtilities.getOggettiDaAggiornare((SoggettiCore)env.soggettiCore, (String)oldSoggetto.getNome(), (String)newSoggetto.getNome(), (String)oldSoggetto.getTipo(), (String)newSoggetto.getTipo(), (SoggettoCtrlStat)sog);
            env.soggettiCore.performUpdateOperation(env.userLogin, false, listOggettiDaAggiornare.toArray());
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    private static /* synthetic */ org.openspcoop2.core.config.rs.server.model.Soggetto lambda$getSoggetto$4(org.openspcoop2.core.registry.Soggetto soggettoReg, SoggettiEnv env) throws Exception {
        return SoggettiApiHelper.soggettoRegistroToApi(soggettoReg, env.pddCore, env.soggettiCore);
    }

    private static /* synthetic */ org.openspcoop2.core.registry.Soggetto lambda$getSoggetto$3(SoggettiEnv env, IDSoggetto idSogg) throws Exception {
        return env.soggettiCore.getSoggettoRegistro(idSogg);
    }
}

