/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.renderkit;

import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.faces.FactoryFinder;
import javax.faces.application.ApplicationFactory;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import javax.faces.render.ResponseStateManager;
import org.ajax4jsf.renderkit.ChameleonRenderKit;
import org.ajax4jsf.renderkit.ChameleonRenderer;

public class ChameleonRenderKitImpl
extends RenderKit
implements ChameleonRenderKit {
    private RenderKit defaultRenderKit = null;
    public static final String RENDER_KIT_ID = "AJAX_HTML_BASIC";
    private Map<String, Renderer> renderers = new HashMap<String, Renderer>();

    private String key(String componentFamily, String rendererType) {
        return componentFamily + "." + rendererType;
    }

    public void addRenderer(String family, String rendererType, Renderer renderer) {
        if (renderer instanceof ChameleonRenderer) {
            // empty if block
        }
        this.renderers.put(this.key(family, rendererType), renderer);
    }

    public ResponseWriter createResponseWriter(Writer writer, String contentTypeList, String characterEncoding) {
        return this.getDefaultRenderKit().createResponseWriter(writer, contentTypeList, characterEncoding);
    }

    public Renderer getRenderer(String family, String rendererType) {
        Renderer renderer = this.renderers.get(this.key(family, rendererType));
        if (renderer != null) {
            return renderer;
        }
        return this.getDefaultRenderKit().getRenderer(family, rendererType);
    }

    public ResponseStateManager getResponseStateManager() {
        return this.getDefaultRenderKit().getResponseStateManager();
    }

    public ResponseStream createResponseStream(OutputStream out) {
        return this.getDefaultRenderKit().createResponseStream(out);
    }

    protected RenderKit getDefaultRenderKit() {
        if (this.defaultRenderKit == null) {
            String defaultRenderkitId = null;
            FacesContext context = null;
            RenderKitFactory rdf = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
            try {
                context = FacesContext.getCurrentInstance();
                if (null != context) {
                    defaultRenderkitId = context.getApplication().getDefaultRenderKitId();
                } else {
                    ApplicationFactory appFactory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
                    defaultRenderkitId = appFactory.getApplication().getDefaultRenderKitId();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (defaultRenderkitId == null) {
                defaultRenderkitId = "HTML_BASIC";
            }
            this.defaultRenderKit = rdf.getRenderKit(context, defaultRenderkitId);
        }
        return this.defaultRenderKit;
    }

    public void setDefaultRenderKit(RenderKit renderKit) {
        this.defaultRenderKit = renderKit;
    }
}

