/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.renderkit.compiler;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.ajax4jsf.Messages;
import org.ajax4jsf.renderkit.RendererBase;
import org.ajax4jsf.renderkit.compiler.AttributeElement;
import org.ajax4jsf.renderkit.compiler.BreakPoint;
import org.ajax4jsf.renderkit.compiler.ChildElement;
import org.ajax4jsf.renderkit.compiler.ChildrensElement;
import org.ajax4jsf.renderkit.compiler.ClassElement;
import org.ajax4jsf.renderkit.compiler.FacetElement;
import org.ajax4jsf.renderkit.compiler.IfElement;
import org.ajax4jsf.renderkit.compiler.ImportResourceElement;
import org.ajax4jsf.renderkit.compiler.MethodCallElement;
import org.ajax4jsf.renderkit.compiler.MethodParameterElement;
import org.ajax4jsf.renderkit.compiler.PlainElementCreateRule;
import org.ajax4jsf.renderkit.compiler.PreparedTemplate;
import org.ajax4jsf.renderkit.compiler.PutAttributesRule;
import org.ajax4jsf.renderkit.compiler.ResourceElement;
import org.ajax4jsf.renderkit.compiler.RootElement;
import org.ajax4jsf.renderkit.compiler.SelectorElement;
import org.ajax4jsf.renderkit.compiler.TemplateContext;
import org.ajax4jsf.renderkit.compiler.TextElement;
import org.ajax4jsf.renderkit.compiler.ValueMethodCallElement;
import org.ajax4jsf.renderkit.compiler.WithDefaultsRulesWrapper;
import org.ajax4jsf.resource.util.URLToStreamHelper;
import org.apache.commons.digester.AbstractObjectCreationFactory;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.ObjectCreationFactory;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.Rules;
import org.apache.commons.digester.RulesBase;
import org.apache.commons.digester.SetNextRule;
import org.apache.commons.digester.SetPropertiesRule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

public class HtmlCompiler {
    public static final String NS_PREFIX = "f:";
    public static final String NS_UTIL_PREFIX = "u:";
    public static final String ROOT_TAG = "template";
    public static final String CALL_TAG = "call";
    public static final String VALUE_CALL_TAG = "valueCall";
    public static final String CALL_PARAM_TAG = "parameter";
    public static final String VERBATUM_TAG = "verbatim";
    public static final String BREAK_TAG = "break";
    public static final String FACET_TAG = "insertFacet";
    public static final String CHILDREN_TAG = "insertChildren";
    public static final String IF_TAG = "if";
    public static final String CHILD_TAG = "insertChild";
    public static final String STYLE_TAG = "style";
    public static final String CHILD_METHOD = "addChild";
    public static final String RESOURCE_TAG = "resource";
    public static final String ATTRIBUTE_TAG = "attribute";
    public static final String CHILD_PARAM_METHOD = "addParameter";
    public static final String ANY_PARENT = "*/";
    public static final String SELECTOR_TAG = "selector";
    public static final String IMPORT_RESOURCE_TAG = "importResource";
    private static final Log log = LogFactory.getLog(HtmlCompiler.class);
    private Digester digestr = new Digester();

    public HtmlCompiler() {
        WithDefaultsRulesWrapper rules = new WithDefaultsRulesWrapper((Rules)new RulesBase());
        rules.addDefault(new PlainElementCreateRule());
        rules.addDefault((Rule)new SetNextRule(CHILD_METHOD));
        this.digestr.setDocumentLocator((Locator)new LocatorImpl());
        this.digestr.setRules((Rules)rules);
        this.digestr.setValidating(false);
        this.digestr.setNamespaceAware(false);
        this.digestr.setUseContextClassLoader(true);
        this.setCustomRules(this.digestr);
    }

    protected void setCustomRules(Digester digestr) {
        String pattern = "f:template";
        digestr.addSetProperties(pattern);
        pattern = "*/f:call";
        digestr.addObjectCreate(pattern, MethodCallElement.class);
        digestr.addSetNext(pattern, CHILD_METHOD);
        digestr.addSetProperties(pattern);
        pattern = "*/f:valueCall";
        digestr.addObjectCreate(pattern, ValueMethodCallElement.class);
        digestr.addSetNext(pattern, CHILD_METHOD);
        digestr.addSetProperties(pattern);
        pattern = "*/f:parameter";
        digestr.addObjectCreate(pattern, MethodParameterElement.class);
        digestr.addSetNext(pattern, CHILD_PARAM_METHOD);
        digestr.addSetProperties(pattern);
        pattern = "*/f:verbatim";
        digestr.addObjectCreate(pattern, TextElement.class);
        digestr.addSetNext(pattern, CHILD_METHOD);
        digestr.addSetProperties(pattern);
        digestr.addBeanPropertySetter(pattern, "text");
        pattern = "*/f:resource";
        digestr.addObjectCreate(pattern, ResourceElement.class);
        digestr.addSetNext(pattern, CHILD_METHOD);
        PutAttributesRule rule = new PutAttributesRule(digestr, new String[]{"f:key", "f:property", "f:baseSkin", "f:skin", "f:context"});
        digestr.addRule(pattern, (Rule)rule);
        rule = new SetPropertiesRule(new String[]{"f:key", "f:property", "f:baseSkin", "f:skin", "f:context"}, new String[]{"value", "property", "baseSkin", "skin", "context"});
        digestr.addRule(pattern, (Rule)rule);
        pattern = "*/f:attribute";
        digestr.addObjectCreate(pattern, AttributeElement.class);
        digestr.addSetNext(pattern, CHILD_METHOD);
        digestr.addSetProperties(pattern);
        pattern = "*/f:break";
        digestr.addObjectCreate(pattern, BreakPoint.class);
        digestr.addSetProperties(pattern);
        digestr.addSetNext(pattern, CHILD_METHOD);
        pattern = "*/f:if";
        digestr.addObjectCreate(pattern, IfElement.class);
        digestr.addSetProperties(pattern);
        digestr.addSetNext(pattern, CHILD_METHOD);
        pattern = "*/f:importResource";
        digestr.addFactoryCreate(pattern, (ObjectCreationFactory)new AbstractObjectCreationFactory(){

            public Object createObject(Attributes attributes) throws Exception {
                if (attributes == null) {
                    throw new IllegalArgumentException("Attributes set is null for importResource element. Can not obtain required 'src' attribute!");
                }
                String value = attributes.getValue("src");
                if (value == null || value.length() == 0) {
                    throw new IllegalArgumentException("Missing required 'src' attribute for importResource element!");
                }
                return new ImportResourceElement(value);
            }
        });
        digestr.addSetNext(pattern, CHILD_METHOD);
        pattern = "*/u:insertFacet";
        digestr.addObjectCreate(pattern, FacetElement.class);
        digestr.addSetProperties(pattern);
        digestr.addSetNext(pattern, CHILD_METHOD);
        pattern = "*/u:insertChildren";
        digestr.addObjectCreate(pattern, ChildrensElement.class);
        digestr.addSetNext(pattern, CHILD_METHOD);
        rule = new SetPropertiesRule(new String[]{"f:key", "f:property", "f:skin", "f:context"}, new String[]{"value", "property", "skin", "context"});
        digestr.addRule(pattern, (Rule)rule);
        pattern = "*/u:style";
        digestr.addObjectCreate(pattern, ClassElement.class);
        digestr.addSetProperties(pattern);
        digestr.addSetNext(pattern, CHILD_METHOD);
        pattern = "*/u:insertChild";
        digestr.addObjectCreate(pattern, ChildElement.class);
        digestr.addSetProperties(pattern);
        digestr.addSetNext(pattern, CHILD_METHOD);
        pattern = "*/u:selector";
        digestr.addObjectCreate(pattern, SelectorElement.class);
        digestr.addSetProperties(pattern);
        digestr.addSetNext(pattern, CHILD_METHOD);
    }

    public PreparedTemplate compile(String xml) {
        StringReader input = new StringReader(xml);
        return this.compile(input);
    }

    public Map compileResources(Class base, String[] templates) {
        HashMap<String, PreparedTemplate> result = new HashMap<String, PreparedTemplate>(templates.length);
        for (int i = 0; i < templates.length; ++i) {
            String template = templates[i];
            result.put(template, HtmlCompiler.compileResource(base, template));
        }
        return result;
    }

    public static PreparedTemplate compileResource(Class base, String resource) {
        String path = resource.startsWith("/") ? base.getPackage().getName().replace('.', '/') + resource : base.getPackage().getName().replace('.', '/') + "/" + resource;
        return HtmlCompiler.compileResource(path);
    }

    public static PreparedTemplate compileResource(String resource) {
        HtmlCompiler compiler = new HtmlCompiler();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream input = URLToStreamHelper.urlToStreamSafe((URL)loader.getResource(resource));
        PreparedTemplate compile = compiler.compile(input, resource);
        if (null != input) {
            try {
                input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return compile;
    }

    public PreparedTemplate compile(Reader input) {
        PreparedTemplate result = null;
        try {
            this.digestr.clear();
            this.digestr.push((Object)new RootElement());
            result = (PreparedTemplate)this.digestr.parse(input);
        }
        catch (SAXParseException e) {
            String errorstr = Messages.getMessage((String)"PARSING_TEMPLATE_ERROR", (Object[])new Object[]{"" + e.getLineNumber(), "" + e.getColumnNumber(), e.toString()});
            log.error((Object)errorstr, (Throwable)e);
            result = new CompiledError(errorstr.toString(), e);
        }
        catch (IOException e) {
            String errorstr = Messages.getMessage((String)"TEMPLATE_IO_ERROR", (Object)e.toString());
            log.error((Object)errorstr, (Throwable)e);
            result = new CompiledError(errorstr.toString(), e);
        }
        catch (SAXException e) {
            String errorstr = Messages.getMessage((String)"PARSING_TEMPLATE_ERROR_2", (Object)e.toString());
            log.error((Object)errorstr, (Throwable)e);
            result = new CompiledError(errorstr.toString(), e);
        }
        return result;
    }

    public PreparedTemplate compile(InputStream input, String sourcename) {
        PreparedTemplate result = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage((String)"START_COMPILE_TEMPLATE_INFO", (Object)sourcename));
            }
            this.digestr.clear();
            RootElement root = new RootElement();
            root.setTemplateName(sourcename);
            this.digestr.push((Object)root);
            result = (PreparedTemplate)this.digestr.parse(input);
        }
        catch (SAXParseException e) {
            String errorstr = Messages.getMessage((String)"PARSING_TEMPLATE_ERROR_a", (Object[])new Object[]{sourcename, "" + e.getLineNumber(), "" + e.getColumnNumber(), e.toString()});
            log.error((Object)errorstr, (Throwable)e);
            result = new CompiledError(errorstr.toString(), e);
        }
        catch (IOException e) {
            String errorstr = Messages.getMessage((String)"TEMPLATE_IO_ERROR_a", (Object)sourcename, (Object)e.toString());
            log.error((Object)errorstr, (Throwable)e);
            result = new CompiledError(errorstr.toString(), e);
        }
        catch (SAXException e) {
            String errorstr = Messages.getMessage((String)"PARSING_TEMPLATE_ERROR_2a", (Object)sourcename, (Object)e.toString());
            log.error((Object)errorstr, (Throwable)e);
            result = new CompiledError(errorstr.toString(), e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage((String)"FINISH_COMPILE_TEMPLATE_INFO", (Object)sourcename));
        }
        return result;
    }

    private static class CompiledError
    implements PreparedTemplate {
        private Exception cause = null;
        private String message = Messages.getMessage((String)"TEMPLATE_NOT_COMPILED_ERROR");

        public CompiledError(String message, Exception cause) {
            this.cause = cause;
            this.message = message;
        }

        CompiledError(Exception cause) {
            this.cause = cause;
        }

        public void encode(RendererBase renderer, FacesContext context, UIComponent component) throws IOException {
            throw new FacesException(this.message, (Throwable)this.cause);
        }

        public List getChildren() {
            return Collections.EMPTY_LIST;
        }

        public void addChild(PreparedTemplate child) throws SAXException {
            throw new SAXException(Messages.getMessage((String)"NO_CHILD_ALLOWED"));
        }

        public void encode(TemplateContext context) throws IOException {
            throw new FacesException(this.message, (Throwable)this.cause);
        }

        public void encode(TemplateContext context, String breakPoint) throws IOException {
            throw new FacesException(this.message, (Throwable)this.cause);
        }

        public void setParent(PreparedTemplate parent) {
        }

        public String getTag() {
            return "f:error";
        }

        public Object getValue(TemplateContext context) {
            return null;
        }
    }
}

