/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.request;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.ajax4jsf.exception.FileUploadException;
import org.ajax4jsf.request.ByteSequenceMatcher;
import org.ajax4jsf.request.FileParam;
import org.ajax4jsf.request.MultipartRequestRegistry;
import org.ajax4jsf.request.Param;
import org.ajax4jsf.request.ValueParam;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.model.UploadItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipartRequest
extends HttpServletRequestWrapper {
    private static final String PARAM_NAME = "name";
    private static final String PARAM_FILENAME = "filename";
    private static final String PARAM_CONTENT_TYPE = "Content-Type";
    private static final int BUFFER_SIZE = 2048;
    private static final int CHUNK_SIZE = 1024;
    private static final int MAX_HEADER_SIZE = 32768;
    private static final Log logger = LogFactory.getLog(MultipartRequest.class);
    private boolean createTempFiles;
    private String uid;
    private String encoding = null;
    private Integer contentLength = 0;
    private int bytesRead = 0;
    private volatile boolean canStop = false;
    private Map<String, Param> parameters = null;
    private Map<String, Object> percentMap = null;
    private Map<String, Integer> requestSizeMap = null;
    private Map<String, String> requestKeysMap = null;
    private String requestKey = null;
    private MultipartRequestRegistry requestRegistry;
    private List<String> keys = new ArrayList<String>();
    private byte[] boundaryMarker;
    private ByteSequenceMatcher sequenceMatcher;
    private static final byte CR = 13;
    private static final byte LF = 10;
    private static final byte[] CR_LF = new byte[]{13, 10};
    private static final byte[] HYPHENS = new byte[]{45, 45};
    private boolean shouldStop = false;
    private boolean canceled;
    private boolean initialized = false;
    private static final ByteSequenceMatcher.BytesHandler NOOP_HANDLER = new ByteSequenceMatcher.BytesHandler(){

        public void handle(byte[] bytes, int length) {
        }
    };
    private HeadersHandler headersHandler = null;
    private static final Pattern PARAM_VALUE_PATTERN = Pattern.compile("^\\s*([^\\s=]+)\\s*[=:]\\s*(.+)\\s*$");
    private static final Pattern FILE_NAME_PATTERN = Pattern.compile(".*filename=\"(.*)\"");

    public MultipartRequest(HttpServletRequest request, boolean createTempFiles, int maxRequestSize, String uid) {
        super(request);
        this.createTempFiles = createTempFiles;
        this.uid = uid;
        String contentLength = request.getHeader("Content-Length");
        this.contentLength = Integer.parseInt(contentLength);
        if (contentLength == null || maxRequestSize <= 0 || this.contentLength > maxRequestSize) {
            // empty if block
        }
    }

    private String decodeFileName(String name) {
        String fileName = null;
        try {
            if (this.getRequest().getParameter("_richfaces_send_http_error") != null) {
                fileName = new String(name.getBytes(this.encoding), "UTF-8");
            } else {
                StringBuffer buffer = new StringBuffer();
                String[] codes = name.split(";");
                if (codes != null) {
                    for (String code : codes) {
                        if (code.startsWith("&")) {
                            String sCode = code.replaceAll("[&#]*", "");
                            Integer iCode = Integer.parseInt(sCode);
                            buffer.append(Character.toChars(iCode));
                            continue;
                        }
                        buffer.append(code);
                    }
                    fileName = buffer.toString();
                }
            }
        }
        catch (Exception e) {
            fileName = name;
        }
        return fileName;
    }

    public void cancel() {
        this.canceled = true;
        if (this.parameters != null) {
            for (Param p : this.parameters.values()) {
                if (!(p instanceof FileParam)) continue;
                ((FileParam)p).deleteFile();
            }
        }
    }

    private void readNext() throws IOException {
        Param p = this.readHeader();
        if (p != null) {
            try {
                this.readData(p);
            }
            finally {
                try {
                    p.complete();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private Param createParam(Map<String, String> headers) {
        Param param = null;
        String paramName = headers.get(PARAM_NAME);
        if (paramName != null) {
            if (headers.containsKey(PARAM_FILENAME)) {
                FileParam fp = new FileParam(paramName);
                this.keys.add(paramName);
                if (this.createTempFiles) {
                    fp.createTempFile();
                }
                fp.setContentType(headers.get(PARAM_CONTENT_TYPE));
                fp.setFilename(this.decodeFileName(headers.get(PARAM_FILENAME)));
                param = fp;
            } else {
                param = this.parameters.containsKey(paramName) ? this.parameters.get(paramName) : new ValueParam(paramName, this.encoding);
            }
            if (!this.parameters.containsKey(paramName)) {
                this.parameters.put(paramName, param);
            }
        }
        return param;
    }

    private Param readHeader() throws IOException {
        if (this.sequenceMatcher.isEOF()) {
            return null;
        }
        if (this.headersHandler == null) {
            this.headersHandler = new HeadersHandler();
        } else {
            this.headersHandler.reset();
        }
        this.sequenceMatcher.setBytesHandler(this.headersHandler);
        this.sequenceMatcher.findSequence(-1, new byte[][]{CR_LF});
        if (this.sequenceMatcher.isMatchedAndNotEOF() && !this.headersHandler.dataEquals(HYPHENS)) {
            String[] split;
            this.headersHandler.reset();
            this.sequenceMatcher.findSequence(-1, CR_LF, CR_LF);
            if (!this.sequenceMatcher.isMatchedAndNotEOF()) {
                throw new IOException("Request header cannot be read");
            }
            String headersString = this.headersHandler.asString();
            HashMap<String, String> headers = new HashMap<String, String>();
            for (String headerString : split = headersString.split("\r\n")) {
                this.parseParams(headerString, "; ", headers);
            }
            return this.createParam(headers);
        }
        return null;
    }

    private void readProlog() throws IOException {
        this.sequenceMatcher.setBytesHandler(NOOP_HANDLER);
        this.sequenceMatcher.findSequence(-1, HYPHENS, this.boundaryMarker);
        if (!this.sequenceMatcher.isMatchedAndNotEOF()) {
            throw new IOException("Request prolog cannot be read");
        }
    }

    private void readData(Param param) throws IOException {
        this.sequenceMatcher.setBytesHandler(param);
        this.sequenceMatcher.findSequence(1024, CR_LF, HYPHENS, this.boundaryMarker);
        if (!this.sequenceMatcher.isMatchedAndNotEOF()) {
            throw new IOException("Request data cannot be read");
        }
    }

    private void initialize() throws IOException {
        if (!this.initialized) {
            this.initialized = true;
            this.boundaryMarker = this.getBoundaryMarker(super.getContentType());
            if (this.boundaryMarker == null) {
                throw new FileUploadException("The request was rejected because no multipart boundary was found");
            }
            if (HYPHENS.length + this.boundaryMarker.length + 1024 + CR_LF.length > 2048) {
                throw new FileUploadException("Boundary marker is too long");
            }
            this.encoding = this.getCharacterEncoding();
            this.parameters = new HashMap<String, Param>();
            ControlledProgressInputStream input = new ControlledProgressInputStream((InputStream)this.getInputStream());
            this.sequenceMatcher = new ByteSequenceMatcher(input, 2048);
            this.setupProgressData();
            this.readProlog();
        }
    }

    public void parseRequest() {
        this.canStop = true;
        this.setupProgressData();
        try {
            this.initialize();
            while (!this.sequenceMatcher.isEOF()) {
                this.readNext();
            }
        }
        catch (IOException e) {
            this.cancel();
            if (!this.shouldStop) {
                throw new FileUploadException("IO Error parsing multipart request", e);
            }
        }
        finally {
            this.canStop = false;
        }
    }

    public static MultipartRequest lookupRequest(FacesContext context, String uploadId) {
        MultipartRequest request;
        MultipartRequestRegistry requestRegistry;
        String requestKey;
        Map sessionMap = context.getExternalContext().getSessionMap();
        Map requestKeys = (Map)sessionMap.get("_richfaces_request_keys");
        if (requestKeys != null && (requestKey = (String)requestKeys.get(uploadId)) != null && (requestRegistry = MultipartRequestRegistry.getInstance(context)) != null && (request = requestRegistry.getRequest(requestKey)) != null) {
            return request;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupProgressData() {
        Map sessionMap;
        ExternalContext externalContext;
        FacesContext facesContext;
        if ((this.percentMap == null || this.requestSizeMap == null || this.requestKeysMap == null) && (facesContext = FacesContext.getCurrentInstance()) != null && (externalContext = facesContext.getExternalContext()) != null && (sessionMap = externalContext.getSessionMap()) != null) {
            String uploadId = this.getUploadId();
            Map map = sessionMap;
            synchronized (map) {
                if (this.percentMap == null) {
                    this.percentMap = (Map)sessionMap.get("_richfaces_upload_percents");
                    if (this.percentMap == null) {
                        this.percentMap = new ConcurrentHashMap<String, Object>();
                        sessionMap.put("_richfaces_upload_percents", this.percentMap);
                    }
                }
                if (this.requestSizeMap == null) {
                    this.requestSizeMap = (Map)sessionMap.get("_richfaces_request_size");
                    if (this.requestSizeMap == null) {
                        this.requestSizeMap = new ConcurrentHashMap<String, Integer>();
                        sessionMap.put("_richfaces_request_size", this.requestSizeMap);
                    }
                }
                if (this.requestKeysMap == null) {
                    this.requestKeysMap = (Map)sessionMap.get("_richfaces_request_keys");
                    if (this.requestKeysMap == null) {
                        this.requestKeysMap = new ConcurrentHashMap<String, String>();
                        sessionMap.put("_richfaces_request_keys", this.requestKeysMap);
                    }
                }
            }
            this.percentMap.put(uploadId, 0.0);
            this.requestSizeMap.put(uploadId, this.getSize());
            this.requestRegistry = MultipartRequestRegistry.getInstance(facesContext);
            this.requestKey = this.requestRegistry.registerRequest(this);
            this.requestKeysMap.put(uploadId, this.requestKey);
        }
    }

    private void fillProgressInfo() {
        this.setupProgressData();
        if (this.percentMap != null) {
            Double percent = 100.0 * (double)this.bytesRead / (double)this.contentLength.intValue();
            this.percentMap.put(this.uid, percent);
        }
    }

    private byte[] getBoundaryMarker(String contentType) {
        Map<String, String> params = this.parseParams(contentType, ";");
        String boundaryStr = params.get("boundary");
        if (boundaryStr == null) {
            return null;
        }
        try {
            return boundaryStr.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            return boundaryStr.getBytes();
        }
    }

    private Map<String, String> parseParams(String paramStr, String separator) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        this.parseParams(paramStr, separator, paramMap);
        return paramMap;
    }

    private void parseParams(String paramStr, String separator, Map<String, String> paramMap) {
        String[] parts;
        for (String part : parts = paramStr.split(separator)) {
            Matcher m = PARAM_VALUE_PATTERN.matcher(part);
            if (!m.matches()) continue;
            String key = m.group(1);
            String value = m.group(2);
            if (value.startsWith("\"") && value.endsWith("\"")) {
                value = value.substring(1, value.length() - 1);
            }
            if (!PARAM_FILENAME.equals(key)) {
                paramMap.put(key, value);
                continue;
            }
            paramMap.put(key, this.parseFileName(paramStr));
        }
    }

    private String parseFileName(String parseStr) {
        Matcher m = FILE_NAME_PATTERN.matcher(parseStr);
        if (m.matches()) {
            String name = m.group(1);
            if (name.startsWith("&")) {
                return this.decodeFileName(name);
            }
            return name;
        }
        return null;
    }

    private Param getParam(String name) {
        Param param = null;
        if (this.parameters != null) {
            param = this.parameters.get(name);
        }
        if (param == null && !this.canceled) {
            try {
                this.initialize();
                while (param == null && !this.sequenceMatcher.isEOF()) {
                    this.readNext();
                    param = this.parameters.get(name);
                }
            }
            catch (IOException e) {
                this.cancel();
                throw new FileUploadException("IO Error parsing multipart request", e);
            }
        }
        return param;
    }

    public Integer getSize() {
        return this.contentLength;
    }

    public Enumeration getParameterNames() {
        if (this.parameters == null) {
            this.parseRequest();
        }
        return Collections.enumeration(this.parameters.keySet());
    }

    public byte[] getFileBytes(String name) {
        Param p = this.getParam(name);
        return p != null && p instanceof FileParam ? ((FileParam)p).getData() : null;
    }

    public InputStream getFileInputStream(String name) {
        Param p = this.getParam(name);
        return p != null && p instanceof FileParam ? ((FileParam)p).getInputStream() : null;
    }

    public String getFileContentType(String name) {
        Param p = this.getParam(name);
        return p != null && p instanceof FileParam ? ((FileParam)p).getContentType() : null;
    }

    public Object getFile(String name) {
        Param p = this.getParam(name);
        return p != null && p instanceof FileParam ? ((FileParam)p).getFile() : null;
    }

    public String getFileName(String name) {
        Param p = this.getParam(name);
        return p != null && p instanceof FileParam ? ((FileParam)p).getFilename() : null;
    }

    public int getFileSize(String name) {
        Param p = this.getParam(name);
        return p != null && p instanceof FileParam ? ((FileParam)p).getFileSize() : -1;
    }

    public String getParameter(String name) {
        Param p = this.getParam(name);
        if (p != null && p instanceof ValueParam) {
            ValueParam vp = (ValueParam)p;
            if (vp.getValue() instanceof String) {
                return (String)vp.getValue();
            }
        } else {
            if (p != null && p instanceof FileParam) {
                return "---BINARY DATA---";
            }
            return super.getParameter(name);
        }
        return null;
    }

    public String[] getParameterValues(String name) {
        this.parseRequest();
        Param p = this.getParam(name);
        if (p != null && p instanceof ValueParam) {
            ValueParam vp = (ValueParam)p;
            if (vp.getValue() instanceof List) {
                List vals = (List)vp.getValue();
                String[] values = new String[vals.size()];
                vals.toArray(values);
                return values;
            }
            return new String[]{(String)vp.getValue()};
        }
        return super.getParameterValues(name);
    }

    public Map getParameterMap() {
        if (this.parameters == null) {
            this.parseRequest();
        }
        HashMap<String, Object> params = new HashMap<String, Object>(super.getParameterMap());
        for (String name : this.parameters.keySet()) {
            Param p = this.parameters.get(name);
            if (!(p instanceof ValueParam)) continue;
            ValueParam vp = (ValueParam)p;
            if (vp.getValue() instanceof String) {
                params.put(name, vp.getValue());
                continue;
            }
            if (!(vp.getValue() instanceof List)) continue;
            params.put(name, this.getParameterValues(name));
        }
        return params;
    }

    public List<UploadItem> getUploadItems() {
        ArrayList<UploadItem> uploadItems = new ArrayList<UploadItem>();
        for (String k : this.keys) {
            uploadItems.add(new UploadItem(this.getFileName(k), this.getFileSize(k), this.getFileContentType(k), this.getFile(k)));
        }
        return uploadItems;
    }

    public boolean isFormUpload() {
        return "_richfaces_form_upload".equals(this.uid);
    }

    public String getHeader(String name) {
        if (!"Accept".equals(name)) {
            return super.getHeader(name);
        }
        return "text/html";
    }

    public void stop() {
        if (this.canStop) {
            this.shouldStop = true;
        }
    }

    public boolean isStopped() {
        return this.shouldStop;
    }

    public boolean isDone() {
        return !this.shouldStop || !this.canceled && (this.contentLength == null || this.contentLength == this.bytesRead);
    }

    public String getContentType() {
        return "application/x-www-form-urlencoded";
    }

    protected String getUploadId() {
        return this.uid;
    }

    public void clearRequestData() {
        String uploadId = this.getUploadId();
        if (this.percentMap != null) {
            this.percentMap.remove(uploadId);
        }
        if (this.requestSizeMap != null) {
            this.requestSizeMap.remove(uploadId);
        }
        if (this.requestKeysMap != null) {
            this.requestKeysMap.remove(uploadId);
        }
        if (this.requestRegistry != null) {
            this.requestRegistry.removeRequest(this.requestKey);
        }
    }

    private class HeadersHandler
    implements ByteSequenceMatcher.BytesHandler {
        private ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);

        private HeadersHandler() {
        }

        public void handle(byte[] bytes, int length) throws IOException {
            if (length != 0) {
                if (this.baos.size() + length > 32768) {
                    throw new IOException("Header section is too big");
                }
                this.baos.write(bytes, 0, length);
            }
        }

        public boolean dataEquals(byte[] bytes) {
            return this.baos.size() == bytes.length && Arrays.equals(HYPHENS, this.baos.toByteArray());
        }

        public String asString() throws UnsupportedEncodingException {
            if (MultipartRequest.this.encoding != null) {
                return this.baos.toString(MultipartRequest.this.encoding);
            }
            return this.baos.toString();
        }

        public void reset() {
            this.baos.reset();
        }
    }

    private class ControlledProgressInputStream
    extends FilterInputStream {
        protected ControlledProgressInputStream(InputStream in) {
            super(in);
        }

        public int read() throws IOException {
            int read = super.read();
            if (read >= 0) {
                MultipartRequest.this.bytesRead++;
                MultipartRequest.this.fillProgressInfo();
            }
            return read;
        }

        public int read(byte[] b) throws IOException {
            int read = super.read(b);
            if (read > 0) {
                MultipartRequest.this.bytesRead = MultipartRequest.this.bytesRead + read;
                MultipartRequest.this.fillProgressInfo();
            }
            return read;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int read = super.read(b, off, len);
            if (read > 0) {
                MultipartRequest.this.bytesRead = MultipartRequest.this.bytesRead + read;
                MultipartRequest.this.fillProgressInfo();
            }
            return read;
        }
    }
}

