/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.webapp;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Map;
import javax.faces.FactoryFinder;
import javax.faces.application.ViewExpiredException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ajax4jsf.Messages;
import org.ajax4jsf.webapp.BaseFilter;
import org.ajax4jsf.webapp.FilterServletResponseWrapper;
import org.ajax4jsf.webapp.HtmlParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

public abstract class BaseXMLFilter {
    public static final String AJAX_EXPIRED = "Ajax-Expired";
    private static final Log log = LogFactory.getLog(BaseXMLFilter.class);
    public static final String APPLICATION_SCOPE_KEY = BaseXMLFilter.class.getName();
    private String mimetype = "text/xml";
    private String publicid = "-//W3C//DTD XHTML 1.0 Transitional//EN";
    private String systemid = "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd";
    private String namespace = "http://www.w3.org/1999/xhtml";
    private static final String MIME_TYPE_PARAMETER = "mime-type";
    private static final String PUBLICID_PARAMETER = "publicid";
    private static final String SYSTEMID_PARAMETER = "systemid";
    private static final String NAMESPACE_PARAMETER = "namespace";
    private boolean forcexml = false;
    private boolean forceNotRf = true;
    private static final String FORCEXML_PARAMETER = "forceparser";
    private static final String FORCENOTRF_PARAMETER = "forcenotrf";
    private static final String INIT_PARAMETER_PREFIX = "org.ajax4jsf.xmlfilter.";
    public static final String TEXT_HTML = "text/html";
    public static final String APPLICATION_XHTML_XML = "application/xhtml+xml";
    private boolean handleViewExpiredOnClient = false;
    public BaseFilter filter;

    public void setFilter(BaseFilter filter) {
        this.filter = filter;
    }

    public void init(FilterConfig config) throws ServletException {
        String forceXmlParameter;
        if (log.isDebugEnabled()) {
            log.debug((Object)("init XML filter service with class " + this.getClass().getName()));
        }
        if ((forceXmlParameter = config.getInitParameter(FORCEXML_PARAMETER)) == null) {
            forceXmlParameter = config.getServletContext().getInitParameter("org.ajax4jsf.xmlfilter.forceparser");
        }
        this.setupForceXml(forceXmlParameter);
        String forceNotRfParameter = config.getInitParameter(FORCENOTRF_PARAMETER);
        if (forceNotRfParameter == null) {
            forceNotRfParameter = config.getServletContext().getInitParameter("org.ajax4jsf.xmlfilter.forcenotrf");
        }
        this.setupForcenotrf(forceNotRfParameter);
        this.setMimetype((String)this.nz(config.getInitParameter(MIME_TYPE_PARAMETER), "text/xml"));
        this.setPublicid((String)this.nz(config.getInitParameter(PUBLICID_PARAMETER), this.getPublicid()));
        this.setSystemid((String)this.nz(config.getInitParameter(SYSTEMID_PARAMETER), this.getSystemid()));
        this.setNamespace((String)this.nz(config.getInitParameter(NAMESPACE_PARAMETER), this.getNamespace()));
        this.handleViewExpiredOnClient = Boolean.parseBoolean(config.getServletContext().getInitParameter("org.ajax4jsf.handleViewExpiredOnClient"));
        this.checkJSFVersion();
    }

    private void checkJSFVersion() {
        boolean jsf2 = false;
        try {
            Object factory = FactoryFinder.getFactory((String)"javax.faces.context.PartialViewContextFactory");
            jsf2 = true;
        }
        catch (Exception factory) {
            // empty catch block
        }
        boolean jsf2compatible = false;
        try {
            Thread.currentThread().getContextClassLoader().loadClass("org.richfaces.JSF2Compatible");
            jsf2compatible = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (jsf2compatible && !jsf2) {
            log.warn((Object)"This version of RichFaces implementation compatible for JSF2.0, but running under JSF1.2");
        }
        if (!jsf2compatible && jsf2) {
            log.warn((Object)"This version of RichFaces implementation compatible for JSF1.2, but running under JSF2.0");
        }
    }

    private Boolean stringToBoolean(String s) {
        if ("false".equalsIgnoreCase(s)) {
            return Boolean.FALSE;
        }
        if ("true".equalsIgnoreCase(s)) {
            return Boolean.TRUE;
        }
        return null;
    }

    private void setupForcenotrf(String paramValue) {
        Boolean val = this.stringToBoolean(paramValue);
        if (val != null) {
            this.forceNotRf = val;
        }
    }

    private void setupForceXml(String forceXmlParameter) {
        Boolean val = this.stringToBoolean(forceXmlParameter);
        if (val != null) {
            this.forcexml = val;
        }
    }

    protected void doXmlFilter(FilterChain chain, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Writer output;
        if (log.isDebugEnabled()) {
            log.debug((Object)"XML filter service start processing request");
        }
        FilterServletResponseWrapper servletResponseWrapper = this.getWrapper(response);
        try {
            request.setAttribute("com.exade.vcp.Filter.ResponseWrapper", (Object)servletResponseWrapper);
            chain.doFilter((ServletRequest)request, (ServletResponse)servletResponseWrapper);
        }
        catch (ServletException e) {
            if (this.handleViewExpiredOnClient && (this.isViewExpired(e) || this.isViewExpired(e.getRootCause())) && this.isAjaxRequest((ServletRequest)request)) {
                log.debug((Object)"ViewExpiredException in the filter chain - will be handled on the client", (Throwable)e);
                Writer output2 = this.resetResponse(response, servletResponseWrapper, "true");
                String message = Messages.getMessage((String)"AJAX_VIEW_EXPIRED");
                response.setHeader(AJAX_EXPIRED, message);
                output2.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<html xmlns=\"http://www.w3.org/1999/xhtml\"><head><meta name=\"Ajax-Response\" content=\"true\" /><meta name=\"Ajax-Expired\" content=\"" + message + "\" /></head></html>");
                output2.flush();
                response.flushBuffer();
                return;
            }
            log.error((Object)"Exception in the filter chain", (Throwable)e);
            throw e;
        }
        finally {
            request.removeAttribute("com.exade.vcp.Filter.ResponseWrapper");
        }
        String viewId = (String)request.getAttribute("org.ajax4jsf.VIEW_ID");
        Node[] headEvents = (Node[])request.getAttribute("org.ajax4jsf.framework.HEAD_EVENTS_LIST");
        HtmlParser parser = null;
        String redirectLocation = servletResponseWrapper.getRedirectLocation();
        String characterEncoding = servletResponseWrapper.getCharacterEncoding();
        int responseStatus = servletResponseWrapper.getStatus();
        if (null != redirectLocation) {
            if (this.isAjaxRequest((ServletRequest)request)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Create AJAX redirect response to url: " + redirectLocation));
                }
                Writer output3 = this.resetResponse(response, servletResponseWrapper, "redirect");
                response.setHeader("Location", redirectLocation);
                output3.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<html xmlns=\"http://www.w3.org/1999/xhtml\"><head><meta name=\"Ajax-Response\" content=\"redirect\" /><meta name=\"Location\" content=\"" + redirectLocation + "\" /></head></html>");
                output3.flush();
                response.flushBuffer();
            } else {
                response.sendRedirect(redirectLocation);
            }
            return;
        }
        if (204 == responseStatus || 304 == responseStatus) {
            return;
        }
        if ("true".equals(servletResponseWrapper.getHeaders().get("Ajax-Response"))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Process response to well-formed XML for AJAX XMLHttpRequest parser");
            }
            response.setHeader("Cache-Control", "no-cache, must-revalidate, max_age=0, no-store");
            response.setHeader("Expires", "0");
            response.setHeader("Pragma", "no-cache");
            String outputEncoding = "UTF-8";
            String contentType = this.getMimetype() + ";charset=" + outputEncoding;
            response.setContentType(contentType);
            parser = this.getParser(this.getMimetype(), true, viewId);
            if (null == parser) {
                throw new ServletException(Messages.getMessage((String)"PARSER_NOT_INSTANTIATED_ERROR", (Object)contentType));
            }
            output = this.createOutputWriter(response, outputEncoding);
            parser.setDoctype(this.getPublicid());
            parser.setInputEncoding(characterEncoding);
            parser.setOutputEncoding(outputEncoding);
            parser.setViewState((String)request.getAttribute("org.ajax4jsf.view.serializedstate"));
        } else {
            boolean forcenotrf;
            String contentType;
            String contentTypeCharset = contentType = servletResponseWrapper.getContentType();
            if (log.isDebugEnabled()) {
                log.debug((Object)("create HTML/XML parser for content type: " + contentType));
            }
            if ((forcenotrf = this.isForcenotrf()) || !servletResponseWrapper.isError()) {
                if (forcenotrf || headEvents != null && headEvents.length != 0) {
                    if (contentTypeCharset != null) {
                        if (contentTypeCharset.indexOf("charset") < 0 && null != characterEncoding) {
                            contentTypeCharset = contentTypeCharset + ";charset=" + characterEncoding;
                        }
                        if (null == (parser = this.getParser(contentTypeCharset, false, viewId)) && log.isDebugEnabled()) {
                            log.debug((Object)"Parser not have support for the such content type, send response as-is");
                        }
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)"No resource inclusions detected, send response as-is");
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Servlet error occured, send response as-is");
            }
            if (null == parser) {
                if (servletResponseWrapper.isUseWriter()) {
                    if (contentTypeCharset != null) {
                        response.setContentType(contentTypeCharset);
                    }
                    Writer output4 = this.createOutputWriter(response, characterEncoding);
                    servletResponseWrapper.sendContent(output4);
                } else if (servletResponseWrapper.isUseStream()) {
                    if (contentType != null) {
                        response.setContentType(contentType);
                    }
                    ServletOutputStream out = response.getOutputStream();
                    servletResponseWrapper.sendContent(out);
                }
                return;
            }
            if (contentTypeCharset != null) {
                response.setContentType(contentTypeCharset);
            }
            output = this.createOutputWriter(response, characterEncoding);
            parser.setInputEncoding(characterEncoding);
            parser.setOutputEncoding(characterEncoding);
        }
        try {
            parser.setHeadNodes(headEvents);
            long startTimeMills = System.currentTimeMillis();
            servletResponseWrapper.parseContent(output, parser);
            if (log.isDebugEnabled()) {
                startTimeMills = System.currentTimeMillis() - startTimeMills;
                log.debug((Object)Messages.getMessage((String)"PARSING_TIME_INFO", (Object)("" + startTimeMills)));
            }
        }
        catch (Exception e) {
            throw new ServletException(Messages.getMessage((String)"JTIDY_PARSING_ERROR"), (Throwable)e);
        }
        finally {
            this.reuseParser(parser);
        }
    }

    private Writer resetResponse(HttpServletResponse response, FilterServletResponseWrapper servletResponseWrapper, String ajaxResponseType) throws IOException, UnsupportedEncodingException {
        response.reset();
        for (Cookie cookie : servletResponseWrapper.getCookies()) {
            response.addCookie(cookie);
        }
        Map<String, Object> headers = servletResponseWrapper.getHeaders();
        for (Map.Entry<String, Object> header : headers.entrySet()) {
            response.setHeader(header.getKey(), (String)header.getValue());
        }
        response.setHeader("Ajax-Response", ajaxResponseType);
        response.setHeader("Cache-Control", "no-cache, must-revalidate, max_age=0, no-store");
        response.setHeader("Expires", "0");
        response.setHeader("Pragma", "no-cache");
        response.setContentType(this.getMimetype() + ";charset=UTF-8");
        Writer output = this.createOutputWriter(response, "UTF-8");
        return output;
    }

    private boolean isViewExpired(Throwable e) {
        while (null != e) {
            if (e instanceof ViewExpiredException) {
                return true;
            }
            e = e.getCause();
        }
        return false;
    }

    protected FilterServletResponseWrapper getWrapper(HttpServletResponse response) throws ServletException {
        return new FilterServletResponseWrapper(response);
    }

    protected boolean isAjaxRequest(ServletRequest request) {
        try {
            return null != request.getParameter("AJAXREQUEST");
        }
        catch (Exception e) {
            return false;
        }
    }

    private Writer createOutputWriter(HttpServletResponse response, String characterEncoding) throws IOException, UnsupportedEncodingException {
        Writer output;
        try {
            output = response.getWriter();
        }
        catch (IllegalStateException e) {
            output = null != characterEncoding ? new OutputStreamWriter((OutputStream)response.getOutputStream(), characterEncoding) : new OutputStreamWriter((OutputStream)response.getOutputStream());
        }
        return output;
    }

    protected abstract void reuseParser(HtmlParser var1);

    protected abstract HtmlParser getParser(String var1, boolean var2, String var3);

    protected void setPublicid(String publicid) {
        this.publicid = publicid;
    }

    public String getPublicid() {
        return this.publicid;
    }

    protected void setSystemid(String systemid) {
        this.systemid = systemid;
    }

    public String getSystemid() {
        return this.systemid;
    }

    protected void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    protected void setMimetype(String mimetype) {
        this.mimetype = mimetype;
    }

    public String getMimetype() {
        return this.mimetype;
    }

    public boolean isForcexml() {
        return this.forcexml;
    }

    public boolean isForcenotrf() {
        return this.forceNotRf;
    }

    protected void setForcexml(boolean forcexml) {
        this.forcexml = forcexml;
    }

    protected void setForcenotrf(boolean forcenotrf) {
        this.forceNotRf = forcenotrf;
    }

    private Object nz(Object param, Object def) {
        return param != null ? param : def;
    }
}

