/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.loader.config;

import java.io.InputStream;
import java.util.Properties;
import org.openspcoop2.pdd.config.OpenSPCoop2ConfigurationException;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.web.loader.config.DatasourceInstanceProperties;
import org.slf4j.Logger;

public class DatasourceProperties {
    private Logger log = null;
    private DatasourceInstanceProperties reader;
    private static DatasourceProperties datasourceProperties = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatasourceProperties(String confDir, Logger log) throws UtilsException {
        this.log = log != null ? log : LoggerWrapperFactory.getLogger(DatasourceProperties.class);
        Properties propertiesReader = new Properties();
        InputStream properties = null;
        try {
            properties = DatasourceProperties.class.getResourceAsStream("/loader.datasource.properties");
            if (properties == null) {
                throw new UtilsException("File '/loader.datasource.properties' not found");
            }
            propertiesReader.load(properties);
        }
        catch (Exception e) {
            this.doError(e);
        }
        finally {
            try {
                if (properties != null) {
                    properties.close();
                }
            }
            catch (Exception exception) {}
        }
        this.reader = new DatasourceInstanceProperties(propertiesReader, this.log, confDir);
    }

    private void doError(Exception e) throws UtilsException {
        String msg = "Riscontrato errore durante la lettura del file 'loader.datasource.properties': " + e.getMessage();
        this.log.error(msg, (Throwable)e);
        throw new UtilsException("ConsoleProperties initialize error: " + e.getMessage(), (Throwable)e);
    }

    public static boolean initialize(String confDir, Logger log) {
        try {
            datasourceProperties = new DatasourceProperties(confDir, log);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static DatasourceProperties getInstance() throws OpenSPCoop2ConfigurationException {
        if (datasourceProperties == null) {
            Class<DatasourceProperties> clazz = DatasourceProperties.class;
            synchronized (DatasourceProperties.class) {
                throw new OpenSPCoop2ConfigurationException("DatasourceProperties non inizializzato");
            }
        }
        return datasourceProperties;
    }

    public static void updateLocalImplementation(Properties prop) {
        DatasourceProperties.datasourceProperties.reader.setLocalObjectImplementation(prop);
    }

    private String readProperty(boolean required, String property) throws UtilsException {
        String tmp = this.reader.getValueConvertEnvProperties(property);
        if (tmp == null) {
            if (required) {
                throw new UtilsException("Property [" + property + "] not found");
            }
            return null;
        }
        return tmp.trim();
    }

    public String getRegistroServiziDataSource() throws UtilsException {
        return this.readProperty(true, "registroServizi.dataSource");
    }

    public Properties getRegistroServiziDataSourceContext() throws UtilsException {
        return this.reader.readPropertiesConvertEnvProperties("registroServizi.dataSource.property.");
    }

    public String getRegistroServiziTipoDatabase() throws UtilsException {
        return this.readProperty(true, "registroServizi.tipoDatabase");
    }

    public String getConfigurazioneDataSource() throws UtilsException {
        return this.readProperty(true, "configPdD.dataSource");
    }

    public Properties getConfigurazioneDataSourceContext() throws UtilsException {
        return this.reader.readPropertiesConvertEnvProperties("configPdD.dataSource.property.");
    }

    public String getConfigurazioneTipoDatabase() throws UtilsException {
        return this.readProperty(true, "configPdD.tipoDatabase");
    }
}

