/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.loader.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.properties.CollectionProperties;
import org.openspcoop2.utils.properties.PropertiesUtilities;
import org.slf4j.Logger;

public class LoaderLogger {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(Logger logConsole, String rootDirectory, Properties objectProperties, boolean appendActualConfiguration) throws IOException, UtilsException {
        String value;
        String key;
        Enumeration<Object> ridefinito;
        Properties loggerProperties = new Properties();
        File loggerFile = null;
        loggerFile = rootDirectory != null ? new File(rootDirectory + "loader.log4j2.properties") : new File("loader.log4j2.properties");
        if (!loggerFile.exists()) {
            loggerProperties.load(OpenSPCoop2Logger.class.getResourceAsStream("/loader.log4j2.properties"));
        } else {
            FileInputStream fin = null;
            try {
                fin = new FileInputStream(loggerFile);
                loggerProperties.load(fin);
            }
            finally {
                try {
                    if (fin != null) {
                        fin.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        CollectionProperties loggerPropertiesRidefinito = PropertiesUtilities.searchLocalImplementation((String)"GOVWAY_HOME", (Logger)logConsole, (String)"OPENSPCOOP2_LOADER_LOG_PROPERTIES", (String)"loader_local.log4j2.properties", (String)rootDirectory);
        if (loggerPropertiesRidefinito != null && loggerPropertiesRidefinito.size() > 0) {
            ridefinito = loggerPropertiesRidefinito.keys();
            while (ridefinito.hasMoreElements()) {
                key = (String)ridefinito.nextElement();
                value = loggerPropertiesRidefinito.get(key);
                if (loggerProperties.containsKey(key)) {
                    loggerProperties.remove(key);
                }
                loggerProperties.put(key, value);
            }
        }
        if (objectProperties != null && objectProperties.size() > 0) {
            ridefinito = objectProperties.keys();
            while (ridefinito.hasMoreElements()) {
                key = (String)ridefinito.nextElement();
                value = (String)objectProperties.get(key);
                if (loggerProperties.containsKey(key)) {
                    loggerProperties.remove(key);
                }
                loggerProperties.put(key, value);
            }
        }
        if (appendActualConfiguration) {
            System.out.println("[govwayLoader] Attendo inizializzazione GovWay prima di appender la configurazione Log4J ...");
            int i = 0;
            int limit = 60;
            while (!OpenSPCoop2Startup.initialize && i < limit) {
                Utilities.sleep((long)1000L);
                if (++i % 10 != 0) continue;
                System.out.println("[govwayLoader] Attendo inizializzazione GovWay ...");
            }
            if (!OpenSPCoop2Startup.initialize) {
                throw new UtilsException("[govwayLoader] Inizializzazione GovWay non rilevata");
            }
            System.out.println("[govwayLoader] Configurazione Log4J ...");
            LoggerWrapperFactory.setLogConfiguration((Properties)loggerProperties, (boolean)true);
            System.out.println("[govwayLoader] Configurazione Log4J aggiunta");
        } else {
            LoggerWrapperFactory.setLogConfiguration((Properties)loggerProperties);
        }
    }
}

