/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.loader.servlet.about;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.utils.IVersionInfo;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementType;
import org.openspcoop2.web.lib.mvc.MessageType;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.TargetType;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.openspcoop2.web.loader.core.LoaderCore;
import org.openspcoop2.web.loader.servlet.LoaderHelper;

public class AboutHelper
extends LoaderHelper {
    public AboutHelper(HttpServletRequest request, PageData pd, HttpSession session) throws Exception {
        super(request, pd, session);
    }

    public List<DataElement> addAboutToDati(List<DataElement> dati, TipoOperazione tipoOperazione, String userLogin) throws UtilsException {
        IVersionInfo versionInfo = null;
        try {
            versionInfo = this.core.getInfoVersion(this.request, this.session);
        }
        catch (Exception e) {
            LoaderCore.log.error("Errore durante la lettura delle informazioni sulla versione: " + e.getMessage(), (Throwable)e);
        }
        if (versionInfo != null) {
            if (!StringUtils.isEmpty((String)versionInfo.getErrorMessage(new Object[0]))) {
                this.pd.setMessage(versionInfo.getErrorMessage(new Object[0]), MessageType.ERROR);
            } else if (!StringUtils.isEmpty((String)versionInfo.getWarningMessage(new Object[0]))) {
                this.pd.setMessage(versionInfo.getWarningMessage(new Object[0]), MessageType.INFO);
            }
        }
        DataElement de = new DataElement();
        de.setLabel("Prodotto");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Versione");
        de.setType(DataElementType.TEXT);
        de.setValue(this.core.getProductVersion());
        dati.add(de);
        de = new DataElement();
        de.setLabelLink("Sito");
        de.setType(DataElementType.LINK);
        de.setTarget(TargetType.BLANK);
        if (versionInfo != null && !StringUtils.isEmpty((String)versionInfo.getWebSite(new Object[0]))) {
            de.setValue(versionInfo.getWebSite(new Object[0]));
            de.setUrl(versionInfo.getWebSite(new Object[0]));
        } else {
            de.setValue("https://govway.org");
            de.setUrl("https://govway.org");
        }
        dati.add(de);
        de = new DataElement();
        de.setLabel("Copyright");
        de.setType(DataElementType.TEXT);
        if (versionInfo != null && !StringUtils.isEmpty((String)versionInfo.getCopyright(new Object[0]))) {
            de.setValue(versionInfo.getCopyright(new Object[0]));
        } else {
            de.setValue("2005-2026 Link.it srl");
        }
        dati.add(de);
        de = new DataElement();
        de.setLabel("Licenza");
        de.setType(DataElementType.TEXT_AREA_NO_EDIT);
        de.setCols(70);
        if (versionInfo != null) {
            String info = versionInfo.getInfo(new Object[0]);
            String[] split = info.split("\n");
            de.setValue(info);
            if (split == null || split.length > 11) {
                de.setRows(11);
            } else {
                de.setRows(split.length + 1);
            }
        } else {
            de.setValue("This program is free software: you can redistribute it and/or modify\nit under the terms of the GNU General Public License version 3, as published by\nthe Free Software Foundation.\n\nThis program is distributed in the hope that it will be useful,\nbut WITHOUT ANY WARRANTY; without even the implied warranty of\nMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\nGNU General Public License for more details.\n\nYou should have received a copy of the GNU General Public License\nalong with this program.  If not, see <http://www.gnu.org/licenses/>.");
            de.setRows(11);
        }
        dati.add(de);
        return dati;
    }
}

