/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.loader.servlet.archivi;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.upload.FormFile;
import org.openspcoop2.core.config.AccessoConfigurazionePdD;
import org.openspcoop2.core.config.AccessoRegistroRegistro;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.registry.driver.utils.PdDConfig;
import org.openspcoop2.core.registry.driver.utils.XMLDataConverter;
import org.openspcoop2.web.lib.mvc.Costanti;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.loader.core.LoaderCore;
import org.openspcoop2.web.loader.servlet.FileUploadForm;
import org.openspcoop2.web.loader.servlet.GeneralHelper;
import org.openspcoop2.web.loader.servlet.LoaderHelper;
import org.slf4j.Logger;

public class ImportaXML
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        String tipoxml = null;
        try {
            AccessoRegistroRegistro accesso;
            LoaderHelper loaderHelper = new LoaderHelper(request, pd, session);
            LoaderCore core = new LoaderCore();
            tipoxml = request.getParameter("tipoxml");
            if (tipoxml == null) {
                tipoxml = "registroServizi";
            }
            loaderHelper.makeMenu();
            if (loaderHelper.isEditModeInProgress()) {
                ServletUtils.setPageDataTitle((PageData)pd, (Parameter[])new Parameter[]{new Parameter("Importa", "importaXml.do")});
                ArrayList<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                loaderHelper.addImportaXMLtoDati(dati, tipoxml);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"importaXml", (ForwardParams)org.openspcoop2.web.loader.core.Costanti.TIPO_OPERAZIONE_ARCHIVI_IMPORTA_XML);
            }
            StringBuilder errorBuffer = new StringBuilder();
            FileUploadForm fileUpload = (FileUploadForm)form;
            FormFile ff = fileUpload.getTheFile();
            boolean ok = loaderHelper.validateFileXml(LoaderCore.getLog(), ff, errorBuffer, tipoxml);
            if (!ok) {
                ServletUtils.setPageDataTitle((PageData)pd, (Parameter[])new Parameter[]{new Parameter("Importa", "importaXml.do")});
                ArrayList<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                loaderHelper.addImportaXMLtoDati(dati, tipoxml);
                pd.setDati(dati);
                pd.setMessage("File non valido: " + errorBuffer.toString());
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"importaXml", (ForwardParams)org.openspcoop2.web.loader.core.Costanti.TIPO_OPERAZIONE_ARCHIVI_IMPORTA_XML);
            }
            String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
            byte[] data = core.readBytes(ff);
            String errore = null;
            if ("registroServizi".equals(tipoxml)) {
                accesso = new AccessoRegistroRegistro();
                accesso.setLocation(core.getDataSourceRegistroServizi());
                accesso.setNome("Registro");
                accesso.setTipo(CostantiConfigurazione.REGISTRO_DB);
                accesso.setTipoDatabase(core.getTipoDatabaseRegistroServizi());
                Properties ctx = core.getCtxDatasourceRegistroServizi();
                Enumeration<Object> ctxNames = ctx.keys();
                while (ctxNames.hasMoreElements()) {
                    String name = (String)ctxNames.nextElement();
                    String value = ctx.getProperty(name);
                    accesso.getGenericPropertiesMap().put(name, value);
                }
                try {
                    XMLDataConverter dataConverter = new XMLDataConverter(data, accesso, userLogin, core.getProtocolloDefault(), LoaderCore.getLog());
                    PdDConfig pddConfig = new PdDConfig();
                    pddConfig.setPddOperativaCtrlstatSinglePdd(core.getNomePdDOperativaCtrlstatSinglePdD());
                    pddConfig.setTipoPdd(core.getTipoPdD());
                    dataConverter.convertXML(false, pddConfig, core.isMantieniFruitoriServizi(), core.isGestioneSoggetti(), core.getStatoAccordo());
                }
                catch (Exception e) {
                    errore = e.getMessage();
                    LoaderCore.getLog().error(e.getMessage(), (Throwable)e);
                }
            } else {
                accesso = new AccessoConfigurazionePdD();
                accesso.setLocation(core.getDataSourceConfigurazionePdD());
                accesso.setTipo(CostantiConfigurazione.REGISTRO_DB.toString());
                accesso.setTipoDatabase(core.getTipoDatabaseConfigurazionePdD());
                accesso.setContext(core.getCtxDatasourceConfigurazionePdD());
                try {
                    org.openspcoop2.core.config.driver.utils.XMLDataConverter dataConverter = new org.openspcoop2.core.config.driver.utils.XMLDataConverter(data, (AccessoConfigurazionePdD)accesso, false, false, userLogin, core.getProtocolloDefault(), LoaderCore.getLog());
                    dataConverter.convertXML(false, core.isGestioneSoggetti(), true);
                }
                catch (Exception e) {
                    errore = e.getMessage();
                    LoaderCore.getLog().error(e.getMessage(), (Throwable)e);
                }
            }
            if (errore != null) {
                pd.setMessage(errore);
            } else {
                pd.setMessage("L'importazione dei dati, contenuti nel file xml, \u00e8 avvenuta con successo", Costanti.MESSAGE_TYPE_INFO);
            }
            ServletUtils.setPageDataTitle((PageData)pd, (Parameter[])new Parameter[]{new Parameter("Importa", "importaXml.do")});
            ArrayList<DataElement> dati = new ArrayList<DataElement>();
            dati.add(ServletUtils.getDataElementForEditModeFinished());
            loaderHelper.addImportaXMLtoDati(dati, tipoxml);
            pd.setDati(dati);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            if (errore != null) {
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"importaXml", (ForwardParams)org.openspcoop2.web.loader.core.Costanti.TIPO_OPERAZIONE_ARCHIVI_IMPORTA_XML);
            }
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"importaXml", (ForwardParams)org.openspcoop2.web.loader.core.Costanti.TIPO_OPERAZIONE_ARCHIVI_IMPORTA_XML);
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)LoaderCore.log, (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"importaXml", (ForwardParams)org.openspcoop2.web.loader.core.Costanti.TIPO_OPERAZIONE_ARCHIVI_IMPORTA_XML);
        }
    }
}

