/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.alarm;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.monitor.engine.alarm.AlarmConfigProperties;
import org.openspcoop2.utils.mail.SenderType;
import org.openspcoop2.utils.transport.http.SSLConfig;
import org.slf4j.Logger;

public class AlarmEngineConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String activeAlarm_serviceUrl;
    private String activeAlarm_serviceUrl_manager_username;
    private String activeAlarm_serviceUrl_manager_password;
    private Integer activeAlarm_serviceUrl_connectionTimeout = 10000;
    private Integer activeAlarm_serviceUrl_readConnectionTimeout = 120000;
    private boolean activeAlarm_serviceUrl_https = false;
    private boolean activeAlarm_serviceUrl_https_verificaHostName = true;
    private boolean activeAlarm_serviceUrl_https_autenticazioneServer = true;
    private String activeAlarm_serviceUrl_https_truststorePath = null;
    private String activeAlarm_serviceUrl_https_truststoreType = null;
    private String activeAlarm_serviceUrl_https_truststorePassword = null;
    private boolean historyEnabled = true;
    private SenderType mailSenderType;
    private Integer mailSenderConnectionTimeout;
    private Integer mailSenderReadTimeout;
    private String mailHost;
    private Integer mailPort;
    private String mailUsername;
    private String mailPassword;
    private SSLConfig mailSSLConfig;
    private boolean mailStartTls;
    private String mailAgent;
    private String mailFrom;
    private String mailSubject;
    private String mailBody;
    private boolean mailDebug;
    private boolean mailSendChangeStatusOk;
    private boolean mailCheckAcknowledgedStatus;
    private boolean mailShowAllOptions;
    private String defaultScriptPath;
    private String defaultScriptArgs;
    private boolean scriptDebug;
    private boolean scriptSendChangeStatusOk;
    private boolean scriptCheckAcknowledgedStatus;
    private boolean scriptShowAllOptions;
    private boolean optionsUpdateStateActiveAlarm;
    private boolean optionsUpdateStatePassiveAlarm;
    private boolean optionsUpdateAckCriteriaActiveAlarm;
    private boolean optionsUpdateAckCriteriaPassiveAlarm;
    private boolean optionsAcknowledgedStatusAssociation;
    private boolean optionsGroupByApi;
    private boolean optionsFilterApi;
    private boolean optionsFilterApiOrganization;

    public boolean isHistoryEnabled() {
        return this.historyEnabled;
    }

    public void setHistoryEnabled(boolean historyEnabled) {
        this.historyEnabled = historyEnabled;
    }

    public SenderType getMailSenderType() {
        return this.mailSenderType;
    }

    public void setMailSenderType(SenderType mailSenderType) {
        this.mailSenderType = mailSenderType;
    }

    public Integer getMailSenderConnectionTimeout() {
        return this.mailSenderConnectionTimeout;
    }

    public void setMailSenderConnectionTimeout(Integer mailSenderConnectionTimeout) {
        this.mailSenderConnectionTimeout = mailSenderConnectionTimeout;
    }

    public Integer getMailSenderReadTimeout() {
        return this.mailSenderReadTimeout;
    }

    public void setMailSenderReadTimeout(Integer mailSenderReadTimeout) {
        this.mailSenderReadTimeout = mailSenderReadTimeout;
    }

    public String getMailHost() {
        return this.mailHost;
    }

    public void setMailHost(String mailHost) {
        this.mailHost = mailHost;
    }

    public Integer getMailPort() {
        return this.mailPort;
    }

    public void setMailPort(Integer mailPort) {
        this.mailPort = mailPort;
    }

    public String getMailUsername() {
        return this.mailUsername;
    }

    public void setMailUsername(String mailUsername) {
        this.mailUsername = mailUsername;
    }

    public String getMailPassword() {
        return this.mailPassword;
    }

    public void setMailPassword(String mailPassword) {
        this.mailPassword = mailPassword;
    }

    public SSLConfig getMailSSLConfig() {
        return this.mailSSLConfig;
    }

    public void setMailSSLConfig(SSLConfig mailSSLConfig) {
        this.mailSSLConfig = mailSSLConfig;
    }

    public boolean isMailStartTls() {
        return this.mailStartTls;
    }

    public void setMailStartTls(boolean mailStartTls) {
        this.mailStartTls = mailStartTls;
    }

    public String getMailAgent() {
        return this.mailAgent;
    }

    public void setMailAgent(String mailAgent) {
        this.mailAgent = mailAgent;
    }

    public String getMailFrom() {
        return this.mailFrom;
    }

    public void setMailFrom(String mailFrom) {
        this.mailFrom = mailFrom;
    }

    public String getMailSubject() {
        return this.mailSubject;
    }

    public void setMailSubject(String mailSubject) {
        this.mailSubject = mailSubject;
    }

    public String getMailBody() {
        return this.mailBody;
    }

    public void setMailBody(String mailBody) {
        this.mailBody = mailBody;
    }

    public String getDefaultScriptPath() {
        return this.defaultScriptPath;
    }

    public void setDefaultScriptPath(String defaultScriptPath) {
        this.defaultScriptPath = defaultScriptPath;
    }

    public String getDefaultScriptArgs() {
        return this.defaultScriptArgs;
    }

    public void setDefaultScriptArgs(String defaultScriptArgs) {
        this.defaultScriptArgs = defaultScriptArgs;
    }

    public boolean isMailCheckAcknowledgedStatus() {
        return this.mailCheckAcknowledgedStatus;
    }

    public void setMailCheckAcknowledgedStatus(boolean mailCheckAcknowledgedStatus) {
        this.mailCheckAcknowledgedStatus = mailCheckAcknowledgedStatus;
    }

    public boolean isMailSendChangeStatusOk() {
        return this.mailSendChangeStatusOk;
    }

    public void setMailSendChangeStatusOk(boolean mailSendChangeStatusOk) {
        this.mailSendChangeStatusOk = mailSendChangeStatusOk;
    }

    public boolean isMailShowAllOptions() {
        return this.mailShowAllOptions;
    }

    public void setMailShowAllOptions(boolean mailShowAllOptions) {
        this.mailShowAllOptions = mailShowAllOptions;
    }

    public boolean isMailDebug() {
        return this.mailDebug;
    }

    public void setMailDebug(boolean mailDebug) {
        this.mailDebug = mailDebug;
    }

    public boolean isScriptDebug() {
        return this.scriptDebug;
    }

    public void setScriptDebug(boolean scriptDebug) {
        this.scriptDebug = scriptDebug;
    }

    public boolean isScriptCheckAcknowledgedStatus() {
        return this.scriptCheckAcknowledgedStatus;
    }

    public void setScriptCheckAcknowledgedStatus(boolean scriptCheckAcknowledgedStatus) {
        this.scriptCheckAcknowledgedStatus = scriptCheckAcknowledgedStatus;
    }

    public boolean isScriptSendChangeStatusOk() {
        return this.scriptSendChangeStatusOk;
    }

    public void setScriptSendChangeStatusOk(boolean scriptSendChangeStatusOk) {
        this.scriptSendChangeStatusOk = scriptSendChangeStatusOk;
    }

    public boolean isScriptShowAllOptions() {
        return this.scriptShowAllOptions;
    }

    public void setScriptShowAllOptions(boolean scriptShowAllOptions) {
        this.scriptShowAllOptions = scriptShowAllOptions;
    }

    public String getActiveAlarm_serviceUrl() {
        return this.activeAlarm_serviceUrl;
    }

    public void setActiveAlarm_serviceUrl(String activeAlarm_serviceUrl) {
        this.activeAlarm_serviceUrl = activeAlarm_serviceUrl;
    }

    public String getActiveAlarm_serviceUrl_manager_username() {
        return this.activeAlarm_serviceUrl_manager_username;
    }

    public void setActiveAlarm_serviceUrl_manager_username(String activeAlarm_serviceUrl_manager_username) {
        this.activeAlarm_serviceUrl_manager_username = activeAlarm_serviceUrl_manager_username;
    }

    public String getActiveAlarm_serviceUrl_manager_password() {
        return this.activeAlarm_serviceUrl_manager_password;
    }

    public void setActiveAlarm_serviceUrl_manager_password(String activeAlarm_serviceUrl_manager_password) {
        this.activeAlarm_serviceUrl_manager_password = activeAlarm_serviceUrl_manager_password;
    }

    public Integer getActiveAlarm_serviceUrl_connectionTimeout() {
        return this.activeAlarm_serviceUrl_connectionTimeout;
    }

    public void setActiveAlarm_serviceUrl_connectionTimeout(Integer activeAlarm_serviceUrl_connectionTimeout) {
        this.activeAlarm_serviceUrl_connectionTimeout = activeAlarm_serviceUrl_connectionTimeout;
    }

    public Integer getActiveAlarm_serviceUrl_readConnectionTimeout() {
        return this.activeAlarm_serviceUrl_readConnectionTimeout;
    }

    public void setActiveAlarm_serviceUrl_readConnectionTimeout(Integer activeAlarm_serviceUrl_readConnectionTimeout) {
        this.activeAlarm_serviceUrl_readConnectionTimeout = activeAlarm_serviceUrl_readConnectionTimeout;
    }

    public boolean isActiveAlarm_serviceUrl_https() {
        return this.activeAlarm_serviceUrl_https;
    }

    public void setActiveAlarm_serviceUrl_https(boolean activeAlarm_serviceUrl_https) {
        this.activeAlarm_serviceUrl_https = activeAlarm_serviceUrl_https;
    }

    public boolean isActiveAlarm_serviceUrl_https_verificaHostName() {
        return this.activeAlarm_serviceUrl_https_verificaHostName;
    }

    public void setActiveAlarm_serviceUrl_https_verificaHostName(boolean activeAlarm_serviceUrl_https_verificaHostName) {
        this.activeAlarm_serviceUrl_https_verificaHostName = activeAlarm_serviceUrl_https_verificaHostName;
    }

    public boolean isActiveAlarm_serviceUrl_https_autenticazioneServer() {
        return this.activeAlarm_serviceUrl_https_autenticazioneServer;
    }

    public void setActiveAlarm_serviceUrl_https_autenticazioneServer(boolean activeAlarm_serviceUrl_https_autenticazioneServer) {
        this.activeAlarm_serviceUrl_https_autenticazioneServer = activeAlarm_serviceUrl_https_autenticazioneServer;
    }

    public String getActiveAlarm_serviceUrl_https_truststorePath() {
        return this.activeAlarm_serviceUrl_https_truststorePath;
    }

    public void setActiveAlarm_serviceUrl_https_truststorePath(String activeAlarm_serviceUrl_https_truststorePath) {
        this.activeAlarm_serviceUrl_https_truststorePath = activeAlarm_serviceUrl_https_truststorePath;
    }

    public String getActiveAlarm_serviceUrl_https_truststoreType() {
        return this.activeAlarm_serviceUrl_https_truststoreType;
    }

    public void setActiveAlarm_serviceUrl_https_truststoreType(String activeAlarm_serviceUrl_https_truststoreType) {
        this.activeAlarm_serviceUrl_https_truststoreType = activeAlarm_serviceUrl_https_truststoreType;
    }

    public String getActiveAlarm_serviceUrl_https_truststorePassword() {
        return this.activeAlarm_serviceUrl_https_truststorePassword;
    }

    public void setActiveAlarm_serviceUrl_https_truststorePassword(String activeAlarm_serviceUrl_https_truststorePassword) {
        this.activeAlarm_serviceUrl_https_truststorePassword = activeAlarm_serviceUrl_https_truststorePassword;
    }

    public boolean isOptionsUpdateStateActiveAlarm() {
        return this.optionsUpdateStateActiveAlarm;
    }

    public void setOptionsUpdateStateActiveAlarm(boolean optionsUpdateState) {
        this.optionsUpdateStateActiveAlarm = optionsUpdateState;
    }

    public boolean isOptionsUpdateStatePassiveAlarm() {
        return this.optionsUpdateStatePassiveAlarm;
    }

    public void setOptionsUpdateStatePassiveAlarm(boolean optionsUpdateState) {
        this.optionsUpdateStatePassiveAlarm = optionsUpdateState;
    }

    public boolean isOptionsUpdateAckCriteriaActiveAlarm() {
        return this.optionsUpdateAckCriteriaActiveAlarm;
    }

    public void setOptionsUpdateAckCriteriaActiveAlarm(boolean optionsUpdateAckCriteria) {
        this.optionsUpdateAckCriteriaActiveAlarm = optionsUpdateAckCriteria;
    }

    public boolean isOptionsUpdateAckCriteriaPassiveAlarm() {
        return this.optionsUpdateAckCriteriaPassiveAlarm;
    }

    public void setOptionsUpdateAckCriteriaPassiveAlarm(boolean optionsUpdateAckCriteria) {
        this.optionsUpdateAckCriteriaPassiveAlarm = optionsUpdateAckCriteria;
    }

    public boolean isOptionsAcknowledgedStatusAssociation() {
        return this.optionsAcknowledgedStatusAssociation;
    }

    public void setOptionsAcknowledgedStatusAssociation(boolean optionsAcknowledgedStatusAssociation) {
        this.optionsAcknowledgedStatusAssociation = optionsAcknowledgedStatusAssociation;
    }

    public boolean isOptionsGroupByApi() {
        return this.optionsGroupByApi;
    }

    public void setOptionsGroupByApi(boolean optionsGroupByApi) {
        this.optionsGroupByApi = optionsGroupByApi;
    }

    public boolean isOptionsFilterApi() {
        return this.optionsFilterApi;
    }

    public void setOptionsFilterApi(boolean optionsFilterApi) {
        this.optionsFilterApi = optionsFilterApi;
    }

    public boolean isOptionsFilterApiOrganization() {
        return this.optionsFilterApiOrganization;
    }

    public void setOptionsFilterApiOrganization(boolean optionsFilterApiOrganization) {
        this.optionsFilterApiOrganization = optionsFilterApiOrganization;
    }

    protected static AlarmEngineConfig readAlarmEngineConfig(Logger log, AlarmConfigProperties alarmConfigProperties) throws Exception {
        String alarmScript;
        String mailSenderHost;
        String alarmHistoryEnabled;
        String https;
        String connectionTimeout;
        AlarmEngineConfig config = new AlarmEngineConfig();
        config.setActiveAlarm_serviceUrl(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.active.service.url", true, true));
        config.setActiveAlarm_serviceUrl_manager_username(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.active.service.manager.username", true, true));
        config.setActiveAlarm_serviceUrl_manager_password(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.active.service.manager.password", true, true));
        String readConnectionTimeout = alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.active.service.readConnectionTimeout", false, true);
        if (StringUtils.isNotEmpty((String)readConnectionTimeout)) {
            config.setActiveAlarm_serviceUrl_readConnectionTimeout(Integer.valueOf(readConnectionTimeout));
        }
        if (StringUtils.isNotEmpty((String)(connectionTimeout = alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.active.service.connectionTimeout", false, true)))) {
            config.setActiveAlarm_serviceUrl_readConnectionTimeout(Integer.valueOf(connectionTimeout));
        }
        if ((https = alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.active.service.https", false, true)) != null) {
            config.setActiveAlarm_serviceUrl_https(Boolean.parseBoolean(https));
        }
        if (config.isActiveAlarm_serviceUrl_https()) {
            String serverAuth;
            String hostnameVerifier = alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.active.service.https.hostnameVerifier", false, true);
            if (hostnameVerifier != null) {
                config.setActiveAlarm_serviceUrl_https_verificaHostName(Boolean.parseBoolean(hostnameVerifier));
            }
            if ((serverAuth = alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.active.service.https.serverAuth", false, true)) != null) {
                config.setActiveAlarm_serviceUrl_https_autenticazioneServer(Boolean.parseBoolean(serverAuth));
            }
            if (config.isActiveAlarm_serviceUrl_https_autenticazioneServer()) {
                config.setActiveAlarm_serviceUrl_https_truststorePath(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.active.service.https.serverAuth.truststorePath", true, true));
                config.setActiveAlarm_serviceUrl_https_truststoreType(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.active.service.https.serverAuth.truststoreType", true, true));
                config.setActiveAlarm_serviceUrl_https_truststorePassword(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.active.service.https.serverAuth.truststorePassword", true, true));
            }
        }
        if ((alarmHistoryEnabled = alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.history.enabled", false, true)) != null) {
            config.setHistoryEnabled(Boolean.parseBoolean(alarmHistoryEnabled));
        }
        if ((mailSenderHost = alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.mail.host", false, true)) != null) {
            String mailSenderSSLType;
            String mailSenderPassword;
            String mailSenderReadTimeout;
            config.setMailHost(mailSenderHost);
            String mailSenderType = alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.mailSender.type", true, true);
            config.setMailSenderType(SenderType.valueOf((String)mailSenderType));
            String mailSenderConnectionTimeout = alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.mailSender.connectionTimeout", false, true);
            if (mailSenderConnectionTimeout != null) {
                config.setMailSenderConnectionTimeout(Integer.parseInt(mailSenderConnectionTimeout));
            }
            if ((mailSenderReadTimeout = alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.mailSender.readTimeout", false, true)) != null) {
                config.setMailSenderReadTimeout(Integer.parseInt(mailSenderReadTimeout));
            }
            config.setMailPort(Integer.parseInt(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.mail.port", true, true)));
            String mailSenderUsername = alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.mail.username", false, true);
            if (mailSenderUsername != null) {
                config.setMailUsername(mailSenderUsername);
            }
            if ((mailSenderPassword = alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.mail.password", false, true)) != null) {
                config.setMailPassword(mailSenderPassword);
            }
            if ((mailSenderSSLType = alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.mail.ssl.type", false, true)) != null) {
                SSLConfig mailSSLConfig = new SSLConfig();
                mailSSLConfig.setSslType(mailSenderSSLType);
                mailSSLConfig.setHostnameVerifier(Boolean.parseBoolean(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.mail.ssl.hostnameVerifier", true, true)));
                boolean serverAuth = Boolean.parseBoolean(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.mail.ssl.serverAuth", true, true));
                if (serverAuth) {
                    mailSSLConfig.setTrustStoreLocation(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.mail.ssl.trustStore.location", true, true));
                    mailSSLConfig.setTrustStoreType(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.mail.ssl.trustStore.type", true, true));
                    mailSSLConfig.setTrustStorePassword(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.mail.ssl.trustStore.password", true, true));
                    mailSSLConfig.setTrustManagementAlgorithm(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.mail.ssl.trustStore.managementAlgorithm", true, true));
                } else {
                    mailSSLConfig.setTrustAllCerts(true);
                }
                config.setMailStartTls(Boolean.parseBoolean(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.mail.ssl.startTls", true, true)));
                config.setMailSSLConfig(mailSSLConfig);
            }
            config.setMailAgent(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.mail.agent", false, true));
            config.setMailFrom(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.mail.from", true, true));
            config.setMailSubject(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.mail.subject", true, true));
            config.setMailBody(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.mail.body", true, true));
            config.setMailDebug(Boolean.parseBoolean(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.mail.debug", true, true)));
            config.setMailCheckAcknowledgedStatus(Boolean.parseBoolean(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.mail.checkAcknowledgedStatus", true, true)));
            config.setMailSendChangeStatusOk(Boolean.parseBoolean(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.mail.sendChangeStatusOk", true, true)));
            config.setMailShowAllOptions(Boolean.parseBoolean(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.mail.showAllOptions", true, true)));
        }
        if ((alarmScript = alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.script.path", false, true)) != null) {
            config.setDefaultScriptPath(alarmScript);
            config.setDefaultScriptArgs(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.script.args", true, true));
        }
        config.setScriptDebug(Boolean.parseBoolean(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.script.debug", true, true)));
        config.setScriptCheckAcknowledgedStatus(Boolean.parseBoolean(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.script.checkAcknowledgedStatus", true, true)));
        config.setScriptSendChangeStatusOk(Boolean.parseBoolean(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.script.sendChangeStatusOk", true, true)));
        config.setScriptShowAllOptions(Boolean.parseBoolean(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.script.showAllOptions", true, true)));
        config.setOptionsUpdateStateActiveAlarm(Boolean.parseBoolean(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.govwayMonitor.updateStateActiveAlarm", true, true)));
        config.setOptionsUpdateStatePassiveAlarm(Boolean.parseBoolean(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.govwayMonitor.updateStatePassiveAlarm", true, true)));
        config.setOptionsAcknowledgedStatusAssociation(Boolean.parseBoolean(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.acknowledged.statusAssociation", true, true)));
        String s = alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.govwayMonitor.updateAckCriteriaActiveAlarm", false, true);
        if (StringUtils.isNotEmpty((String)s)) {
            config.setOptionsUpdateAckCriteriaActiveAlarm(Boolean.parseBoolean(s));
        } else {
            config.setOptionsUpdateAckCriteriaActiveAlarm(true);
        }
        s = alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.govwayMonitor.updateAckCriteriaPassiveAlarm", false, true);
        if (StringUtils.isNotEmpty((String)s)) {
            config.setOptionsUpdateAckCriteriaPassiveAlarm(Boolean.parseBoolean(s));
        } else {
            config.setOptionsUpdateAckCriteriaPassiveAlarm(false);
        }
        config.setOptionsGroupByApi(Boolean.parseBoolean(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.groupBy.api", true, true)));
        config.setOptionsFilterApi(Boolean.parseBoolean(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.filter.api", true, true)));
        config.setOptionsFilterApiOrganization(Boolean.parseBoolean(alarmConfigProperties.getProperty("org.openspcoop2.monitor.alarm.filter.api.organization", true, true)));
        return config;
    }
}

