/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.alarm;

import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.allarmi.Allarme;
import org.openspcoop2.core.allarmi.AllarmeHistory;
import org.openspcoop2.core.allarmi.AllarmeNotifica;
import org.openspcoop2.core.allarmi.AllarmeParametro;
import org.openspcoop2.core.allarmi.IdAllarme;
import org.openspcoop2.core.allarmi.constants.StatoAllarme;
import org.openspcoop2.core.allarmi.dao.IAllarmeHistoryService;
import org.openspcoop2.core.allarmi.dao.IAllarmeNotificaService;
import org.openspcoop2.core.allarmi.dao.IAllarmeService;
import org.openspcoop2.core.allarmi.dao.IAllarmeServiceSearch;
import org.openspcoop2.core.allarmi.dao.IServiceManager;
import org.openspcoop2.core.allarmi.utils.AllarmiConverterUtils;
import org.openspcoop2.core.allarmi.utils.ProjectInfo;
import org.openspcoop2.core.allarmi.utils.serializer.JaxbSerializer;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.plugins.IdPlugin;
import org.openspcoop2.core.plugins.Plugin;
import org.openspcoop2.core.plugins.constants.TipoPlugin;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.monitor.engine.alarm.AlarmContext;
import org.openspcoop2.monitor.engine.alarm.AlarmEngineConfig;
import org.openspcoop2.monitor.engine.alarm.AlarmImpl;
import org.openspcoop2.monitor.engine.alarm.AlarmLogger;
import org.openspcoop2.monitor.engine.alarm.AlarmStatusWithAck;
import org.openspcoop2.monitor.engine.dynamic.DynamicFactory;
import org.openspcoop2.monitor.engine.dynamic.IDynamicLoader;
import org.openspcoop2.monitor.sdk.alarm.AlarmStatus;
import org.openspcoop2.monitor.sdk.alarm.IAlarm;
import org.openspcoop2.monitor.sdk.alarm.IAlarmLogger;
import org.openspcoop2.monitor.sdk.condition.Context;
import org.openspcoop2.monitor.sdk.constants.AlarmStateValues;
import org.openspcoop2.monitor.sdk.exceptions.AlarmException;
import org.openspcoop2.monitor.sdk.exceptions.AlarmNotifyException;
import org.openspcoop2.monitor.sdk.parameters.Parameter;
import org.openspcoop2.monitor.sdk.plugins.IAlarmProcessing;
import org.openspcoop2.utils.UtilsMultiException;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.mail.Mail;
import org.openspcoop2.utils.mail.Sender;
import org.openspcoop2.utils.mail.SenderFactory;
import org.openspcoop2.utils.mail.SenderType;
import org.openspcoop2.utils.resources.ScriptInvoker;
import org.slf4j.Logger;

public class AlarmManager {
    private static AlarmEngineConfig alarmEngineConfig;

    public static AlarmEngineConfig getAlarmEngineConfig() {
        return alarmEngineConfig;
    }

    public static void setAlarmEngineConfig(AlarmEngineConfig alarmEngineConfig) {
        AlarmManager.alarmEngineConfig = alarmEngineConfig;
    }

    public static IAlarm getAlarm(String idAllarme, Logger log, DAOFactory daoFactory) throws AlarmException {
        AlarmImpl alarm = null;
        try {
            IServiceManager pluginSM = (IServiceManager)daoFactory.getServiceManager((IProjectInfo)ProjectInfo.getInstance());
            IAllarmeServiceSearch allarmeDAO = pluginSM.getAllarmeServiceSearch();
            IExpression expr = allarmeDAO.newExpression();
            expr.equals(Allarme.model().NOME, (Object)idAllarme);
            Allarme allarme = null;
            try {
                allarme = (Allarme)allarmeDAO.find(expr);
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            if (allarme == null) {
                throw new AlarmException("Allarme -" + idAllarme + "- non esistente");
            }
            alarm = (AlarmImpl)AlarmManager.getAlarm(allarme, log, daoFactory);
        }
        catch (Exception e) {
            log.error("AlarmManager.getAlarm(" + idAllarme + ") ha rilevato un errore: " + e.getMessage(), (Throwable)e);
            throw new AlarmException(e.getMessage(), (Throwable)e);
        }
        return alarm;
    }

    public static IAlarm getAlarm(Allarme allarme, Logger log, DAOFactory daoFactory) throws AlarmException {
        return AlarmManager._getAlarm(allarme, log, daoFactory, null);
    }

    public static IAlarm getAlarm(Allarme allarme, Logger log, DAOFactory daoFactory, org.openspcoop2.core.plugins.dao.IServiceManager pluginSM) throws AlarmException {
        return AlarmManager._getAlarm(allarme, log, daoFactory, pluginSM);
    }

    private static IAlarm _getAlarm(Allarme allarme, Logger log, DAOFactory daoFactory, org.openspcoop2.core.plugins.dao.IServiceManager pluginSM) throws AlarmException {
        AlarmImpl alarm;
        block12: {
            alarm = null;
            try {
                if (allarme != null) {
                    alarm = new AlarmImpl(allarme, log, daoFactory);
                    AlarmStateValues statusValue = null;
                    StatoAllarme statoAllarme = AllarmiConverterUtils.toStatoAllarme((Integer)allarme.getStato());
                    switch (statoAllarme) {
                        case OK: {
                            statusValue = AlarmStateValues.OK;
                            break;
                        }
                        case WARNING: {
                            statusValue = AlarmStateValues.WARNING;
                            break;
                        }
                        case ERROR: {
                            statusValue = AlarmStateValues.ERROR;
                        }
                    }
                    AlarmStatus alarmStatus = new AlarmStatus();
                    alarmStatus.setStatus(statusValue);
                    alarmStatus.setDetail(allarme.getDettaglioStato());
                    alarm.setStatus(alarmStatus);
                    if (pluginSM == null) {
                        pluginSM = (org.openspcoop2.core.plugins.dao.IServiceManager)daoFactory.getServiceManager((IProjectInfo)org.openspcoop2.core.plugins.utils.ProjectInfo.getInstance());
                    }
                    TipoPlugin tipoPlugin = TipoPlugin.ALLARME;
                    IdPlugin idPlugin = new IdPlugin();
                    idPlugin.setTipoPlugin(tipoPlugin.getValue());
                    idPlugin.setTipo(allarme.getTipo());
                    Plugin plugin = (Plugin)pluginSM.getPluginServiceSearch().get((Object)idPlugin);
                    alarm.setPluginClassName(plugin.getClassName());
                    IDynamicLoader cAllarme = DynamicFactory.getInstance().newDynamicLoader(tipoPlugin, allarme.getTipo(), plugin.getClassName(), log);
                    IAlarmProcessing alarmProc = (IAlarmProcessing)cAllarme.newInstance();
                    alarm.setManuallyUpdateState(alarmProc.isManuallyUpdateState());
                    alarm.setManuallyAckCriteria(alarmProc.isManuallyAckCriteria());
                    AlarmContext ctx = new AlarmContext(allarme, log, daoFactory);
                    List listParameters = alarmProc.getParameters((Context)ctx);
                    block7: for (AllarmeParametro parametro : allarme.getAllarmeParametroList()) {
                        for (Parameter parameter : listParameters) {
                            if (!parameter.getId().equals(parametro.getIdParametro())) continue;
                            parameter.setValueAsString(parametro.getValore());
                            continue block7;
                        }
                    }
                    for (Parameter parameter : listParameters) {
                        alarm.addParameter(parameter);
                    }
                    break block12;
                }
                throw new AlarmException("Allarme non valido");
            }
            catch (Exception e) {
                log.error("AlarmManager.getAlarm(" + (allarme != null ? allarme.getNome() : "Alarm undefined") + ") ha rilevato un errore: " + e.getMessage(), (Throwable)e);
                throw new AlarmException(e.getMessage(), (Throwable)e);
            }
        }
        return alarm;
    }

    protected static void changeStatus(AlarmStatus newStatoAllarme, IAlarm allarme, IServiceManager allarmiSM, String username, boolean statusChanged, List<AllarmeHistory> repositoryHistory) throws AlarmException {
        block17: {
            try {
                Allarme oldConfig = allarme.getConfigAllarme();
                IAllarmeServiceSearch allarmeSearchDAO = allarmiSM.getAllarmeServiceSearch();
                IAllarmeService allarmeDAO = allarmiSM.getAllarmeService();
                IAllarmeHistoryService allarmeHistoryDAO = allarmiSM.getAllarmeHistoryService();
                IExpression expr = allarmeSearchDAO.newExpression();
                expr.equals(Allarme.model().NOME, (Object)allarme.getId());
                Allarme confAllarme = (Allarme)allarmeSearchDAO.find(expr);
                if (confAllarme != null) {
                    boolean registraHistory;
                    boolean autoChangeAck = true;
                    if (newStatoAllarme instanceof AlarmStatusWithAck) {
                        AlarmStatusWithAck withAck = (AlarmStatusWithAck)newStatoAllarme;
                        if (withAck.isAck()) {
                            confAllarme.setAcknowledged(Integer.valueOf(1));
                            oldConfig.setAcknowledged(Integer.valueOf(1));
                        } else {
                            confAllarme.setAcknowledged(Integer.valueOf(0));
                            oldConfig.setAcknowledged(Integer.valueOf(0));
                        }
                        autoChangeAck = false;
                    }
                    if (statusChanged && confAllarme.getStato() != null) {
                        confAllarme.setStatoPrecedente(confAllarme.getStato());
                        oldConfig.setStatoPrecedente(confAllarme.getStato());
                    }
                    switch (newStatoAllarme.getStatus()) {
                        case OK: {
                            confAllarme.setStato(Integer.valueOf(AllarmiConverterUtils.toIntegerValue((StatoAllarme)StatoAllarme.OK)));
                            break;
                        }
                        case WARNING: {
                            confAllarme.setStato(Integer.valueOf(AllarmiConverterUtils.toIntegerValue((StatoAllarme)StatoAllarme.WARNING)));
                            break;
                        }
                        default: {
                            confAllarme.setStato(Integer.valueOf(AllarmiConverterUtils.toIntegerValue((StatoAllarme)StatoAllarme.ERROR)));
                        }
                    }
                    oldConfig.setStato(confAllarme.getStato());
                    confAllarme.setLasttimestampUpdate(DateManager.getDate());
                    oldConfig.setLasttimestampUpdate(confAllarme.getLasttimestampUpdate());
                    if (statusChanged && autoChangeAck) {
                        confAllarme.setAcknowledged(Integer.valueOf(0));
                        oldConfig.setAcknowledged(Integer.valueOf(0));
                    }
                    confAllarme.setDettaglioStato(newStatoAllarme.getDetail());
                    oldConfig.setDettaglioStato(confAllarme.getDettaglioStato());
                    IdAllarme idConfAllarme = new IdAllarme();
                    idConfAllarme.setId(confAllarme.getId());
                    idConfAllarme.setNome(confAllarme.getNome());
                    Allarme allarmeImmagineDB = (Allarme)allarmeDAO.get((Object)idConfAllarme);
                    allarmeDAO.update((Object)idConfAllarme, (Object)confAllarme);
                    boolean checkHistory = false;
                    if (repositoryHistory != null) {
                        checkHistory = true;
                    } else {
                        AlarmEngineConfig alarmEngineConfig = AlarmManager.getAlarmEngineConfig();
                        checkHistory = alarmEngineConfig.isHistoryEnabled();
                    }
                    if (checkHistory && (registraHistory = AlarmManager.registraHistory(confAllarme, allarmeImmagineDB))) {
                        AllarmeHistory history = new AllarmeHistory();
                        history.setEnabled(confAllarme.getEnabled());
                        history.setAcknowledged(confAllarme.getAcknowledged());
                        history.setDettaglioStato(confAllarme.getDettaglioStato());
                        history.setStato(confAllarme.getStato());
                        IdAllarme idAllarme = new IdAllarme();
                        idAllarme.setNome(confAllarme.getNome());
                        history.setIdAllarme(idAllarme);
                        history.setUtente(username);
                        history.setTimestampUpdate(confAllarme.getLasttimestampUpdate());
                        if (repositoryHistory != null) {
                            repositoryHistory.add(history);
                        } else {
                            allarmeHistoryDAO.create((Object)history);
                        }
                    }
                    break block17;
                }
                throw new AlarmException("Allarme -" + allarme.getId() + "- non esistente");
            }
            catch (Exception e) {
                allarme.getLogger().error("AlarmManager.changeStatus() ha rilevato un errore: " + e.getMessage(), (Throwable)e);
                throw new AlarmException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static boolean registraHistory(Allarme confAllarme, Allarme allarmeImmagineDB) {
        if (confAllarme.getEnabled() != null) {
            if (allarmeImmagineDB.getEnabled() == null) {
                return true;
            }
            if (allarmeImmagineDB.getEnabled() != null && confAllarme.getEnabled() != null && allarmeImmagineDB.getEnabled().intValue() != confAllarme.getEnabled().intValue()) {
                return true;
            }
        } else if (allarmeImmagineDB.getEnabled() != null) {
            return true;
        }
        if (confAllarme.getAcknowledged() != null) {
            if (allarmeImmagineDB.getAcknowledged() == null) {
                return true;
            }
            if (allarmeImmagineDB.getAcknowledged() != null && confAllarme.getAcknowledged() != null && allarmeImmagineDB.getAcknowledged().intValue() != confAllarme.getAcknowledged().intValue()) {
                return true;
            }
        } else if (allarmeImmagineDB.getAcknowledged() != null) {
            return true;
        }
        if (confAllarme.getStato() != null) {
            if (allarmeImmagineDB.getStato() == null) {
                return true;
            }
            if (!allarmeImmagineDB.getStato().equals(confAllarme.getStato())) {
                return true;
            }
        } else if (allarmeImmagineDB.getStato() != null) {
            return true;
        }
        return false;
    }

    protected static void sendMail(Allarme configAllarme, IAlarmLogger alarmLog, List<String> logEvents) throws Exception {
        String[] tmp;
        AlarmEngineConfig alarmEngineConfig = AlarmManager.getAlarmEngineConfig();
        if (alarmEngineConfig == null) {
            throw new Exception("Configurazione Mail non fornita, utilizzare il metodo AlarmManager.setAlarmEngineConfig(...)");
        }
        ArrayList<String> destinatari = new ArrayList<String>();
        if (configAllarme.getMail() != null && configAllarme.getMail().getDestinatari() != null && (tmp = configAllarme.getMail().getDestinatari().split(",")) != null && tmp.length > 0) {
            for (int i = 0; i < tmp.length; ++i) {
                destinatari.add(tmp[i].trim());
            }
        }
        if (destinatari.size() > 0) {
            Sender sender = null;
            if (alarmEngineConfig.getMailSenderType() == null) {
                throw new Exception("Configurazione mail errata [Parametro 'SenderType' non definito]");
            }
            sender = SenderFactory.newSender((SenderType)alarmEngineConfig.getMailSenderType(), (Logger)alarmLog.getInternalLogger());
            if (alarmEngineConfig.getMailSenderConnectionTimeout() != null) {
                sender.setConnectionTimeout(alarmEngineConfig.getMailSenderConnectionTimeout().intValue());
            }
            if (alarmEngineConfig.getMailSenderReadTimeout() != null) {
                sender.setReadTimeout(alarmEngineConfig.getMailSenderReadTimeout().intValue());
            }
            for (String destinatario : destinatari) {
                Mail mail = new Mail();
                mail.setUserAgent(alarmEngineConfig.getMailAgent());
                if (alarmEngineConfig.getMailFrom() == null) {
                    throw new Exception("Configurazione mail errata [Parametro 'From' non definito]");
                }
                mail.setFrom(alarmEngineConfig.getMailFrom());
                mail.setTo(destinatario);
                if (alarmEngineConfig.getMailHost() == null) {
                    throw new Exception("Configurazione mail errata [Parametro 'Hostname' non definito]");
                }
                mail.setServerHost(alarmEngineConfig.getMailHost());
                if (alarmEngineConfig.getMailPort() == null) {
                    throw new Exception("Configurazione mail errata [Parametro 'Port' non definito]");
                }
                mail.setServerPort(alarmEngineConfig.getMailPort().intValue());
                if (alarmEngineConfig.getMailUsername() != null) {
                    mail.setUsername(alarmEngineConfig.getMailUsername());
                }
                if (alarmEngineConfig.getMailPassword() != null) {
                    mail.setPassword(alarmEngineConfig.getMailPassword());
                }
                mail.setSslConfig(alarmEngineConfig.getMailSSLConfig());
                mail.setStartTls(alarmEngineConfig.isMailStartTls());
                String templateSubjectMail = null;
                if (configAllarme.getMail() != null && configAllarme.getMail().getSubject() != null) {
                    templateSubjectMail = configAllarme.getMail().getSubject();
                }
                if ((templateSubjectMail == null || "".equals(templateSubjectMail)) && (templateSubjectMail = alarmEngineConfig.getMailSubject()) == null) {
                    throw new Exception("Configurazione mail errata [Parametro 'Subject' non definito]");
                }
                mail.setSubject(AlarmManager.replaceKeywordTemplate(templateSubjectMail, configAllarme, false));
                String templateBodyMail = null;
                if (configAllarme.getMail() != null && configAllarme.getMail().getBody() != null) {
                    templateBodyMail = configAllarme.getMail().getBody();
                }
                if ((templateBodyMail == null || "".equals(templateBodyMail)) && (templateBodyMail = alarmEngineConfig.getMailBody()) == null) {
                    throw new Exception("Configurazione mail errata [Parametro 'Body' non definito]");
                }
                mail.getBody().setMessage(AlarmManager.replaceKeywordTemplate(templateBodyMail, configAllarme, false));
                sender.send(mail, alarmEngineConfig.isMailDebug());
                if (!alarmEngineConfig.isMailDebug()) continue;
                logEvents.add("eMail per notifica stato [" + configAllarme.getStato() + "] inviata correttamente al destinatario [" + destinatario + "]");
            }
        }
    }

    protected static void invokeScript(Allarme configAllarme, IAlarmLogger alarmLog, List<String> logEvents) throws Exception {
        AlarmEngineConfig alarmEngineConfig = AlarmManager.getAlarmEngineConfig();
        if (alarmEngineConfig == null) {
            throw new Exception("Configurazione Script non fornita, utilizzare il metodo AlarmManager.setAlarmEngineConfig(...)");
        }
        String path = null;
        if (configAllarme.getScript() != null) {
            path = configAllarme.getScript().getCommand();
        }
        if ((path == null || "".equals(path)) && (path = alarmEngineConfig.getDefaultScriptPath()) == null) {
            throw new Exception("Configurazione script errata [Parametro 'Path' non definito]");
        }
        String args = null;
        if (configAllarme.getScript() != null) {
            args = configAllarme.getScript().getArgs();
        }
        if ((args == null || "".equals(args)) && (args = alarmEngineConfig.getDefaultScriptArgs()) == null) {
            throw new Exception("Configurazione script errata [Parametro 'Args' non definito]");
        }
        args = AlarmManager.replaceKeywordTemplate(args, configAllarme, true);
        ScriptInvoker invoker = new ScriptInvoker(path);
        ArrayList<String> arguments = new ArrayList<String>();
        StringBuilder bfUtils = null;
        if (args != null && !"".equals(args)) {
            String[] tmp = args.trim().split(" ");
            for (int i = 0; i < tmp.length; ++i) {
                String s = tmp[i].trim();
                if (bfUtils == null) {
                    if (s.startsWith("\"")) {
                        if (s.endsWith("\"")) {
                            if (s.length() > 2) {
                                arguments.add(s.substring(1, s.length() - 1));
                                continue;
                            }
                            arguments.add(s);
                            continue;
                        }
                        bfUtils = new StringBuilder(s.substring(1));
                        continue;
                    }
                    arguments.add(s);
                    continue;
                }
                if (s.endsWith("\"")) {
                    bfUtils.append(" ").append(s.substring(0, s.length() - 1));
                    arguments.add(bfUtils.toString());
                    bfUtils = null;
                    continue;
                }
                bfUtils.append(" ").append(s);
            }
        }
        if (arguments.size() > 0) {
            invoker.run(arguments.toArray(new String[1]));
        } else {
            invoker.run();
        }
        String msg = "Invocazione script [" + path + "] (args: " + args + ") ha ritornato un codice di uscita [" + invoker.getExitValue() + "]\nOutputStream: " + invoker.getOutputStream() + "\nErrorStream: " + invoker.getErrorStream();
        if (invoker.getExitValue() != 0) {
            throw new Exception(msg);
        }
        if (alarmEngineConfig.isScriptDebug()) {
            logEvents.add(msg);
        }
    }

    public static String replaceKeywordTemplate(String original, Allarme configAllarme, boolean script) {
        String newS = original.replace("@NOME_ALLARME@", configAllarme.getAlias());
        newS = newS.replace("@ID_ALLARME@", configAllarme.getNome());
        StatoAllarme statoAllarme = AllarmiConverterUtils.toStatoAllarme((Integer)configAllarme.getStato());
        switch (statoAllarme) {
            case OK: {
                newS = newS.replace("@STATO_ALLARME@", "Ok");
                break;
            }
            case WARNING: {
                newS = newS.replace("@STATO_ALLARME@", "Warning");
                break;
            }
            case ERROR: {
                newS = newS.replace("@STATO_ALLARME@", "Error");
            }
        }
        String details = configAllarme.getDettaglioStato();
        if (details == null) {
            details = "";
        }
        newS = script ? newS.replace("@DETTAGLIO_ALLARME@", "\"" + details + "\"") : newS.replace("@DETTAGLIO_ALLARME@", details);
        return newS;
    }

    public static void notifyChangeStatus(AlarmEngineConfig alarmEngineConfig, Allarme allarme, IAlarm alarm, String pluginClassName, String threadName, AlarmLogger alarmLogger, AlarmStatus oldStatus, AlarmStatus nuovoStatoAllarme, boolean checkAcknowledState) throws AlarmException, AlarmNotifyException {
        boolean statusChanged = false;
        Object prefix = null;
        try {
            statusChanged = oldStatus == null || oldStatus.getStatus() == null ? true : !oldStatus.getStatus().equals((Object)nuovoStatoAllarme.getStatus());
            boolean statusWarningError = false;
            if (nuovoStatoAllarme != null) {
                boolean bl = statusWarningError = AlarmStateValues.WARNING.equals((Object)nuovoStatoAllarme.getStatus()) || AlarmStateValues.ERROR.equals((Object)nuovoStatoAllarme.getStatus());
            }
            if (!(statusChanged || statusWarningError && checkAcknowledState)) {
                alarmLogger.debug("Cambio di stato non rilevato (old:" + oldStatus + " new:" + nuovoStatoAllarme + ")");
                return;
            }
            prefix = statusChanged ? "Cambio di stato rilevato (old:" + oldStatus + " new:" + nuovoStatoAllarme + "); " : "Cambio di stato non rilevato; ";
        }
        catch (Exception e) {
            throw new AlarmException(e.getMessage(), (Throwable)e);
        }
        boolean invokePlugin = statusChanged;
        boolean sendMail = false;
        boolean invokeScript = false;
        try {
            alarmLogger.debug((String)prefix + "lettura configurazione in corso ...");
            boolean mailCheckAcknowledgedStatus = alarmEngineConfig.isMailCheckAcknowledgedStatus();
            boolean mailSendChangeStatusOk = alarmEngineConfig.isMailSendChangeStatusOk();
            boolean scriptCheckAcknowledgedStatus = alarmEngineConfig.isScriptCheckAcknowledgedStatus();
            boolean scriptSendChangeStatusOk = alarmEngineConfig.isScriptSendChangeStatusOk();
            boolean acknowledged = allarme.getAcknowledged() == null || allarme.getAcknowledged() == 1;
            alarmLogger.debug((String)prefix + "valutazione se \u00e8 necessario una notifica di cambio stato per mail/script (acknowledged:" + acknowledged + ") ...");
            alarmLogger.debug((String)prefix + "mail sendChangeStatusOk:" + mailSendChangeStatusOk + " checkAcknowledgedStatus:" + mailCheckAcknowledgedStatus);
            alarmLogger.debug((String)prefix + "script sendChangeStatusOk:" + scriptSendChangeStatusOk + " checkAcknowledgedStatus:" + scriptCheckAcknowledgedStatus);
            if (nuovoStatoAllarme != null) {
                if (AlarmStateValues.OK.equals((Object)nuovoStatoAllarme.getStatus())) {
                    if (mailSendChangeStatusOk) {
                        boolean bl = sendMail = allarme.getMail() != null && allarme.getMail().getInvia() != null && allarme.getMail().getInvia() == 1;
                    }
                    if (scriptSendChangeStatusOk) {
                        invokeScript = allarme.getScript() != null && allarme.getScript().getInvoca() != null && allarme.getScript().getInvoca() == 1;
                    }
                } else if (AlarmStateValues.WARNING.equals((Object)nuovoStatoAllarme.getStatus())) {
                    if (statusChanged || mailCheckAcknowledgedStatus && !acknowledged) {
                        boolean bl = sendMail = allarme.getMail() != null && allarme.getMail().getInvia() != null && allarme.getMail().getInvia() == 1 && allarme.getMail() != null && allarme.getMail().getInviaWarning() != null && allarme.getMail().getInviaWarning() == 1;
                    }
                    if (statusChanged || scriptCheckAcknowledgedStatus && !acknowledged) {
                        invokeScript = allarme.getScript() != null && allarme.getScript().getInvoca() != null && allarme.getScript().getInvoca() == 1 && allarme.getScript() != null && allarme.getScript().getInvocaWarning() != null && allarme.getScript().getInvocaWarning() == 1;
                    }
                } else if (AlarmStateValues.ERROR.equals((Object)nuovoStatoAllarme.getStatus())) {
                    if (statusChanged || mailCheckAcknowledgedStatus && !acknowledged) {
                        boolean bl = sendMail = allarme.getMail() != null && allarme.getMail().getInvia() != null && allarme.getMail().getInvia() == 1;
                    }
                    if (statusChanged || scriptCheckAcknowledgedStatus && !acknowledged) {
                        invokeScript = allarme.getScript() != null && allarme.getScript().getInvoca() != null && allarme.getScript().getInvoca() == 1;
                    }
                }
            }
        }
        catch (Exception e) {
            throw new AlarmException(e.getMessage(), (Throwable)e);
        }
        ArrayList<Exception> listExceptions = new ArrayList<Exception>();
        String pluginInvocationError = null;
        try {
            if (invokePlugin) {
                alarmLogger.debug((String)prefix + "notifica plugin ...");
                IDynamicLoader cPlugin = DynamicFactory.getInstance().newDynamicLoader(TipoPlugin.ALLARME, allarme.getTipo(), pluginClassName, alarmLogger.getInternalLogger());
                IAlarmProcessing alarmProc = (IAlarmProcessing)cPlugin.newInstance();
                alarmProc.changeStatusNotify(alarm, oldStatus, nuovoStatoAllarme);
                alarmLogger.debug((String)prefix + "notifica plugin terminata");
            }
        }
        catch (Exception e) {
            alarmLogger.error((String)prefix + "notifica plugin fallita: " + e.getMessage(), e);
            pluginInvocationError = e.getMessage();
            listExceptions.add(e);
        }
        String sendMailError = null;
        try {
            if (sendMail) {
                alarmLogger.debug((String)prefix + "notifica mail ...");
                ArrayList<String> logEvents = new ArrayList<String>();
                AlarmManager.sendMail(allarme, alarmLogger, logEvents);
                if (logEvents != null && !logEvents.isEmpty()) {
                    for (String string : logEvents) {
                        String prefixLog = AlarmLogger.buildPrefix(threadName, allarme.getAlias(), allarme.getNome());
                        alarmLogger.debug(prefixLog + string);
                    }
                }
                alarmLogger.debug((String)prefix + "notifica mail completata");
            }
        }
        catch (Exception e) {
            alarmLogger.error((String)prefix + "notifica mail fallita: " + e.getMessage(), e);
            sendMailError = e.getMessage();
            listExceptions.add(e);
        }
        String scriptInvocationError = null;
        try {
            if (invokeScript) {
                alarmLogger.debug((String)prefix + "notifica via script ...");
                ArrayList<String> logEvents = new ArrayList<String>();
                AlarmManager.invokeScript(allarme, alarmLogger, logEvents);
                if (logEvents != null && !logEvents.isEmpty()) {
                    for (String logEvent : logEvents) {
                        String prefixLog = AlarmLogger.buildPrefix(threadName, allarme.getAlias(), allarme.getNome());
                        alarmLogger.debug(prefixLog + logEvent);
                    }
                }
                alarmLogger.debug((String)prefix + "notifica via script completata");
            }
        }
        catch (Exception e) {
            alarmLogger.error((String)prefix + "notifica via script fallita: " + e.getMessage(), e);
            scriptInvocationError = e.getMessage();
            listExceptions.add(e);
        }
        if (!listExceptions.isEmpty()) {
            AlarmNotifyException ane = null;
            if (listExceptions.size() == 1) {
                Exception exception = (Exception)listExceptions.get(0);
                ane = new AlarmNotifyException(exception.getMessage(), (Throwable)exception);
            } else {
                UtilsMultiException utilsMultiException = new UtilsMultiException((Throwable[])listExceptions.toArray(new Exception[listExceptions.size()]));
                ane = new AlarmNotifyException("Notifiche di cambio stato fallite", (Throwable)utilsMultiException);
            }
            ane.setPluginInvocationError(pluginInvocationError);
            ane.setSendMailError(sendMailError);
            ane.setScriptInvocationError(scriptInvocationError);
            throw ane;
        }
    }

    protected static void registraNotifica(AlarmLogger alarmLogger, Allarme allarme, AlarmStatus oldStatoAllarme, AlarmStatus newStatoAllarme, AllarmeHistory repositoryHistory, IServiceManager allarmiSM) throws AlarmException {
        try {
            IAllarmeNotificaService allarmeNotificaSearchDAO = allarmiSM.getAllarmeNotificaService();
            AllarmeNotifica notifica = new AllarmeNotifica();
            notifica.setDataNotifica(DateManager.getDate());
            IdAllarme idAllarme = (IdAllarme)allarmiSM.getAllarmeServiceSearch().convertToId((Object)allarme);
            notifica.setIdAllarme(idAllarme);
            notifica.setOldStato(Integer.valueOf(AllarmiConverterUtils.toIntegerValue((StatoAllarme)StatoAllarme.valueOf((String)oldStatoAllarme.getStatus().name()))));
            notifica.setOldDettaglioStato(oldStatoAllarme.getDetail());
            notifica.setNuovoStato(Integer.valueOf(AllarmiConverterUtils.toIntegerValue((StatoAllarme)StatoAllarme.valueOf((String)newStatoAllarme.getStatus().name()))));
            notifica.setNuovoDettaglioStato(newStatoAllarme.getDetail());
            if (repositoryHistory != null) {
                JaxbSerializer serializer = new JaxbSerializer();
                notifica.setHistoryEntry(serializer.toString(repositoryHistory));
            }
            allarmeNotificaSearchDAO.create((Object)notifica);
        }
        catch (Exception e) {
            alarmLogger.error("Registrazione notifica di cambio stato fallita: " + e.getMessage(), e);
            throw new AlarmException(e.getMessage(), (Throwable)e);
        }
    }
}

