/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.condition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.impl.sql.ISQLFieldConverter;
import org.openspcoop2.monitor.engine.utils.ContentFormatter;
import org.openspcoop2.monitor.sdk.condition.IFilter;
import org.openspcoop2.monitor.sdk.condition.IStatisticFilter;
import org.openspcoop2.monitor.sdk.constants.LikeMode;
import org.openspcoop2.monitor.sdk.constants.MessageType;
import org.openspcoop2.monitor.sdk.exceptions.SearchException;
import org.openspcoop2.monitor.sdk.statistic.StatisticFilter;
import org.openspcoop2.monitor.sdk.statistic.StatisticFilterName;
import org.openspcoop2.monitor.sdk.statistic.StatisticResourceFilter;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.TipiDatabase;
import org.slf4j.Logger;

public abstract class FilterImpl
implements IStatisticFilter {
    protected IExpression expression;
    protected TipiDatabase databaseType;
    protected ISQLFieldConverter fieldConverter;
    private String idStatistic;
    protected static Logger logger = LoggerWrapperFactory.getLogger(FilterImpl.class);

    protected FilterImpl(IExpression expression, TipiDatabase databaseType, ISQLFieldConverter fieldConverter) {
        this.expression = expression;
        this.databaseType = databaseType;
        this.fieldConverter = fieldConverter;
    }

    public IExpression getExpression() {
        return this.expression;
    }

    protected abstract IStatisticFilter newIFilter() throws SearchException;

    protected abstract IExpression newIExpression() throws SearchException;

    protected abstract IField getIFieldForMessageType() throws SearchException;

    protected abstract List<IField> getIFieldForResourceName(StatisticFilterName var1) throws SearchException;

    protected abstract IField getIFieldForResourceValue(IField var1) throws SearchException;

    private void check(StatisticResourceFilter resourceStatID) throws SearchException {
        if (resourceStatID.getStatisticFilterName() == null) {
            throw new SearchException("Required StatisticFilterName undefined");
        }
        if (resourceStatID.getResourceID() == null) {
            throw new SearchException("Required ResourceID undefined");
        }
    }

    private void check(StatisticFilter resource) throws SearchException {
        if (resource.getStatisticFilterName() == null) {
            throw new SearchException("Required StatisticFilterName undefined");
        }
        if (resource.getResourceID() == null) {
            throw new SearchException("Required ResourceID undefined");
        }
        if (resource.getValue() == null) {
            throw new SearchException("Required Value undefined");
        }
    }

    public String getIdStatistic() {
        return this.idStatistic;
    }

    public void setIdStatistic(String idStatistic) {
        this.idStatistic = idStatistic;
    }

    public IStatisticFilter not() throws SearchException {
        try {
            this.expression.not();
            return this;
        }
        catch (Exception e) {
            throw new SearchException(e.getMessage(), (Throwable)e);
        }
    }

    public IStatisticFilter and() throws SearchException {
        try {
            this.expression.and();
            return this;
        }
        catch (Exception e) {
            throw new SearchException(e.getMessage(), (Throwable)e);
        }
    }

    public IStatisticFilter or() throws SearchException {
        try {
            this.expression.or();
            return this;
        }
        catch (Exception e) {
            throw new SearchException(e.getMessage(), (Throwable)e);
        }
    }

    public IFilter equals(String resourceID, Object value) throws SearchException {
        return this._equals(null, resourceID, value);
    }

    public IStatisticFilter equals(StatisticResourceFilter resourceID, Object value) throws SearchException {
        return this._equals(resourceID, null, value);
    }

    private IStatisticFilter _equals(StatisticResourceFilter resourceStatID, String resourceID, Object value) throws SearchException {
        try {
            List<IField> fieldsResourceName;
            StatisticFilterName statisticFilter = null;
            if (resourceStatID != null) {
                this.check(resourceStatID);
                statisticFilter = resourceStatID.getStatisticFilterName();
                resourceID = resourceStatID.getResourceID();
            }
            if ((fieldsResourceName = this.getIFieldForResourceName(statisticFilter)).size() == 1) {
                IExpression expr = this.newIExpression();
                expr.and();
                IField fieldResourceName = fieldsResourceName.get(0);
                expr.equals(fieldResourceName, (Object)resourceID);
                expr.equals(this.getIFieldForResourceValue(fieldResourceName), (Object)ContentFormatter.toString(value));
                this.expression.and(new IExpression[]{expr});
            } else {
                IExpression exprEsterna = this.newIExpression();
                exprEsterna.or();
                for (IField fieldResourceName : fieldsResourceName) {
                    IExpression expr = this.newIExpression();
                    expr.and();
                    expr.equals(fieldResourceName, (Object)resourceID);
                    expr.equals(this.getIFieldForResourceValue(fieldResourceName), (Object)ContentFormatter.toString(value));
                    exprEsterna.or(new IExpression[]{expr});
                }
                this.expression.and(new IExpression[]{exprEsterna});
            }
            return this;
        }
        catch (Exception e) {
            throw new SearchException(e.getMessage(), (Throwable)e);
        }
    }

    public IFilter notEquals(String resourceID, Object value) throws SearchException {
        return this._notEquals(null, resourceID, value);
    }

    public IStatisticFilter notEquals(StatisticResourceFilter resourceID, Object value) throws SearchException {
        return this._notEquals(resourceID, null, value);
    }

    private IStatisticFilter _notEquals(StatisticResourceFilter resourceStatID, String resourceID, Object value) throws SearchException {
        try {
            List<IField> fieldsResourceName;
            StatisticFilterName statisticFilter = null;
            if (resourceStatID != null) {
                this.check(resourceStatID);
                statisticFilter = resourceStatID.getStatisticFilterName();
                resourceID = resourceStatID.getResourceID();
            }
            if ((fieldsResourceName = this.getIFieldForResourceName(statisticFilter)).size() == 1) {
                IExpression expr = this.newIExpression();
                expr.and();
                IField fieldResourceName = fieldsResourceName.get(0);
                expr.equals(fieldResourceName, (Object)resourceID);
                expr.notEquals(this.getIFieldForResourceValue(fieldResourceName), (Object)ContentFormatter.toString(value));
                this.expression.and(new IExpression[]{expr});
            } else {
                IExpression exprEsterna = this.newIExpression();
                exprEsterna.or();
                for (IField fieldResourceName : fieldsResourceName) {
                    IExpression expr = this.newIExpression();
                    expr.and();
                    expr.equals(fieldResourceName, (Object)resourceID);
                    expr.notEquals(this.getIFieldForResourceValue(fieldResourceName), (Object)ContentFormatter.toString(value));
                    exprEsterna.or(new IExpression[]{expr});
                }
                this.expression.and(new IExpression[]{exprEsterna});
            }
            return this;
        }
        catch (Exception e) {
            throw new SearchException(e.getMessage(), (Throwable)e);
        }
    }

    public IFilter allEquals(Map<String, Object> propertyNameValues) throws SearchException {
        return this.allEquals(propertyNameValues, true);
    }

    public IStatisticFilter allEquals(List<StatisticFilter> propertyNameValues) throws SearchException {
        return this.allEquals(propertyNameValues, true);
    }

    public IFilter allNotEquals(Map<String, Object> propertyNameValues) throws SearchException {
        return this.allNotEquals(propertyNameValues, true);
    }

    public IStatisticFilter allNotEquals(List<StatisticFilter> propertyNameValues) throws SearchException {
        return this.allEquals(propertyNameValues, true);
    }

    public IFilter allEquals(Map<String, Object> propertyNameValues, boolean andConjunction) throws SearchException {
        try {
            if (propertyNameValues.size() > 0) {
                IExpression exprAll = this.newIExpression();
                if (andConjunction) {
                    exprAll.and();
                } else {
                    exprAll.or();
                }
                for (String resourceID : propertyNameValues.keySet()) {
                    Object value = propertyNameValues.get(resourceID);
                    FilterImpl f = (FilterImpl)this.newFilter();
                    f.equals(resourceID, value);
                    exprAll.and(new IExpression[]{f.getExpression()});
                }
                this.expression.and(new IExpression[]{exprAll});
            }
            return this;
        }
        catch (Exception e) {
            throw new SearchException(e.getMessage(), (Throwable)e);
        }
    }

    public IStatisticFilter allEquals(List<StatisticFilter> propertyNameValues, boolean andConjunction) throws SearchException {
        try {
            if (propertyNameValues.size() > 0) {
                IExpression exprAll = this.newIExpression();
                if (andConjunction) {
                    exprAll.and();
                } else {
                    exprAll.or();
                }
                for (StatisticFilter statisticsFilter : propertyNameValues) {
                    this.check(statisticsFilter);
                    FilterImpl f = (FilterImpl)this.newFilter();
                    StatisticResourceFilter sf = new StatisticResourceFilter();
                    sf.setResourceID(statisticsFilter.getResourceID());
                    sf.setStatisticFilterName(statisticsFilter.getStatisticFilterName());
                    f.equals(sf, statisticsFilter.getValue());
                    exprAll.and(new IExpression[]{f.getExpression()});
                }
                this.expression.and(new IExpression[]{exprAll});
            }
            return this;
        }
        catch (Exception e) {
            throw new SearchException(e.getMessage(), (Throwable)e);
        }
    }

    public IFilter allNotEquals(Map<String, Object> propertyNameValues, boolean andConjunction) throws SearchException {
        try {
            if (propertyNameValues.size() > 0) {
                IExpression exprAll = this.newIExpression();
                if (andConjunction) {
                    exprAll.and();
                } else {
                    exprAll.or();
                }
                for (String resourceID : propertyNameValues.keySet()) {
                    Object value = propertyNameValues.get(resourceID);
                    FilterImpl f = (FilterImpl)this.newFilter();
                    f.notEquals(resourceID, value);
                    exprAll.and(new IExpression[]{f.getExpression()});
                }
                this.expression.and(new IExpression[]{exprAll});
            }
            return this;
        }
        catch (Exception e) {
            throw new SearchException(e.getMessage(), (Throwable)e);
        }
    }

    public IStatisticFilter allNotEquals(List<StatisticFilter> propertyNameValues, boolean andConjunction) throws SearchException {
        try {
            if (propertyNameValues.size() > 0) {
                IExpression exprAll = this.newIExpression();
                if (andConjunction) {
                    exprAll.and();
                } else {
                    exprAll.or();
                }
                for (StatisticFilter statisticsFilter : propertyNameValues) {
                    this.check(statisticsFilter);
                    FilterImpl f = (FilterImpl)this.newFilter();
                    StatisticResourceFilter sf = new StatisticResourceFilter();
                    sf.setResourceID(statisticsFilter.getResourceID());
                    sf.setStatisticFilterName(statisticsFilter.getStatisticFilterName());
                    f.notEquals(sf, statisticsFilter.getValue());
                    exprAll.and(new IExpression[]{f.getExpression()});
                }
                this.expression.and(new IExpression[]{exprAll});
            }
            return this;
        }
        catch (Exception e) {
            throw new SearchException(e.getMessage(), (Throwable)e);
        }
    }

    public IFilter greaterThan(String resourceID, Object value) throws SearchException {
        return this._greaterThan(null, resourceID, value);
    }

    public IStatisticFilter greaterThan(StatisticResourceFilter resourceID, Object value) throws SearchException {
        return this._greaterThan(resourceID, null, value);
    }

    private IStatisticFilter _greaterThan(StatisticResourceFilter resourceStatID, String resourceID, Object value) throws SearchException {
        try {
            List<IField> fieldsResourceName;
            StatisticFilterName statisticFilter = null;
            if (resourceStatID != null) {
                this.check(resourceStatID);
                statisticFilter = resourceStatID.getStatisticFilterName();
                resourceID = resourceStatID.getResourceID();
            }
            if ((fieldsResourceName = this.getIFieldForResourceName(statisticFilter)).size() == 1) {
                IExpression expr = this.newIExpression();
                expr.and();
                IField fieldResourceName = fieldsResourceName.get(0);
                expr.equals(fieldResourceName, (Object)resourceID);
                expr.greaterThan(this.getIFieldForResourceValue(fieldResourceName), (Object)ContentFormatter.toString(value));
                this.expression.and(new IExpression[]{expr});
            } else {
                IExpression exprEsterna = this.newIExpression();
                exprEsterna.or();
                for (IField fieldResourceName : fieldsResourceName) {
                    IExpression expr = this.newIExpression();
                    expr.and();
                    expr.equals(fieldResourceName, (Object)resourceID);
                    expr.greaterThan(this.getIFieldForResourceValue(fieldResourceName), (Object)ContentFormatter.toString(value));
                    exprEsterna.or(new IExpression[]{expr});
                }
                this.expression.and(new IExpression[]{exprEsterna});
            }
            return this;
        }
        catch (Exception e) {
            throw new SearchException(e.getMessage(), (Throwable)e);
        }
    }

    public IFilter greaterEquals(String resourceID, Object value) throws SearchException {
        return this._greaterEquals(null, resourceID, value);
    }

    public IStatisticFilter greaterEquals(StatisticResourceFilter resourceID, Object value) throws SearchException {
        return this._greaterEquals(resourceID, null, value);
    }

    private IStatisticFilter _greaterEquals(StatisticResourceFilter resourceStatID, String resourceID, Object value) throws SearchException {
        try {
            List<IField> fieldsResourceName;
            StatisticFilterName statisticFilter = null;
            if (resourceStatID != null) {
                this.check(resourceStatID);
                statisticFilter = resourceStatID.getStatisticFilterName();
                resourceID = resourceStatID.getResourceID();
            }
            if ((fieldsResourceName = this.getIFieldForResourceName(statisticFilter)).size() == 1) {
                IExpression expr = this.newIExpression();
                expr.and();
                IField fieldResourceName = fieldsResourceName.get(0);
                expr.equals(fieldResourceName, (Object)resourceID);
                expr.greaterEquals(this.getIFieldForResourceValue(fieldResourceName), (Object)ContentFormatter.toString(value));
                this.expression.and(new IExpression[]{expr});
            } else {
                IExpression exprEsterna = this.newIExpression();
                exprEsterna.or();
                for (IField fieldResourceName : fieldsResourceName) {
                    IExpression expr = this.newIExpression();
                    expr.and();
                    expr.equals(fieldResourceName, (Object)resourceID);
                    expr.greaterEquals(this.getIFieldForResourceValue(fieldResourceName), (Object)ContentFormatter.toString(value));
                    exprEsterna.or(new IExpression[]{expr});
                }
                this.expression.and(new IExpression[]{exprEsterna});
            }
            return this;
        }
        catch (Exception e) {
            throw new SearchException(e.getMessage(), (Throwable)e);
        }
    }

    public IFilter lessThan(String resourceID, Object value) throws SearchException {
        return this._lessThan(null, resourceID, value);
    }

    public IStatisticFilter lessThan(StatisticResourceFilter resourceID, Object value) throws SearchException {
        return this._lessThan(resourceID, null, value);
    }

    private IStatisticFilter _lessThan(StatisticResourceFilter resourceStatID, String resourceID, Object value) throws SearchException {
        try {
            List<IField> fieldsResourceName;
            StatisticFilterName statisticFilter = null;
            if (resourceStatID != null) {
                this.check(resourceStatID);
                statisticFilter = resourceStatID.getStatisticFilterName();
                resourceID = resourceStatID.getResourceID();
            }
            if ((fieldsResourceName = this.getIFieldForResourceName(statisticFilter)).size() == 1) {
                IExpression expr = this.newIExpression();
                expr.and();
                IField fieldResourceName = fieldsResourceName.get(0);
                expr.equals(fieldResourceName, (Object)resourceID);
                expr.lessThan(this.getIFieldForResourceValue(fieldResourceName), (Object)ContentFormatter.toString(value));
                this.expression.and(new IExpression[]{expr});
            } else {
                IExpression exprEsterna = this.newIExpression();
                exprEsterna.or();
                for (IField fieldResourceName : fieldsResourceName) {
                    IExpression expr = this.newIExpression();
                    expr.and();
                    expr.equals(fieldResourceName, (Object)resourceID);
                    expr.lessThan(this.getIFieldForResourceValue(fieldResourceName), (Object)ContentFormatter.toString(value));
                    exprEsterna.or(new IExpression[]{expr});
                }
                this.expression.and(new IExpression[]{exprEsterna});
            }
            return this;
        }
        catch (Exception e) {
            throw new SearchException(e.getMessage(), (Throwable)e);
        }
    }

    public IFilter lessEquals(String resourceID, Object value) throws SearchException {
        return this._lessEquals(null, resourceID, value);
    }

    public IStatisticFilter lessEquals(StatisticResourceFilter resourceID, Object value) throws SearchException {
        return this._lessEquals(resourceID, null, value);
    }

    private IStatisticFilter _lessEquals(StatisticResourceFilter resourceStatID, String resourceID, Object value) throws SearchException {
        try {
            List<IField> fieldsResourceName;
            StatisticFilterName statisticFilter = null;
            if (resourceStatID != null) {
                this.check(resourceStatID);
                statisticFilter = resourceStatID.getStatisticFilterName();
                resourceID = resourceStatID.getResourceID();
            }
            if ((fieldsResourceName = this.getIFieldForResourceName(statisticFilter)).size() == 1) {
                IExpression expr = this.newIExpression();
                expr.and();
                IField fieldResourceName = fieldsResourceName.get(0);
                expr.equals(fieldResourceName, (Object)resourceID);
                expr.lessEquals(this.getIFieldForResourceValue(fieldResourceName), (Object)ContentFormatter.toString(value));
                this.expression.and(new IExpression[]{expr});
            } else {
                IExpression exprEsterna = this.newIExpression();
                exprEsterna.or();
                for (IField fieldResourceName : fieldsResourceName) {
                    IExpression expr = this.newIExpression();
                    expr.and();
                    expr.equals(fieldResourceName, (Object)resourceID);
                    expr.lessEquals(this.getIFieldForResourceValue(fieldResourceName), (Object)ContentFormatter.toString(value));
                    exprEsterna.or(new IExpression[]{expr});
                }
                this.expression.and(new IExpression[]{exprEsterna});
            }
            return this;
        }
        catch (Exception e) {
            throw new SearchException(e.getMessage(), (Throwable)e);
        }
    }

    public IFilter isNull(String resourceID) throws SearchException {
        return this._isNull(null, resourceID);
    }

    public IStatisticFilter isNull(StatisticResourceFilter resourceID) throws SearchException {
        return this._isNull(resourceID, null);
    }

    private IStatisticFilter _isNull(StatisticResourceFilter resourceStatID, String resourceID) throws SearchException {
        try {
            List<IField> fieldsResourceName;
            StatisticFilterName statisticFilter = null;
            if (resourceStatID != null) {
                this.check(resourceStatID);
                statisticFilter = resourceStatID.getStatisticFilterName();
                resourceID = resourceStatID.getResourceID();
            }
            if ((fieldsResourceName = this.getIFieldForResourceName(statisticFilter)).size() == 1) {
                IExpression expr = this.newIExpression();
                expr.and();
                IField fieldResourceName = fieldsResourceName.get(0);
                expr.equals(fieldResourceName, (Object)resourceID);
                expr.isNull(this.getIFieldForResourceValue(fieldResourceName));
                this.expression.and(new IExpression[]{expr});
            } else {
                IExpression exprEsterna = this.newIExpression();
                exprEsterna.or();
                for (IField fieldResourceName : fieldsResourceName) {
                    IExpression expr = this.newIExpression();
                    expr.and();
                    expr.equals(fieldResourceName, (Object)resourceID);
                    expr.isNull(this.getIFieldForResourceValue(fieldResourceName));
                    exprEsterna.or(new IExpression[]{expr});
                }
                this.expression.and(new IExpression[]{exprEsterna});
            }
            return this;
        }
        catch (Exception e) {
            throw new SearchException(e.getMessage(), (Throwable)e);
        }
    }

    public IFilter isNotNull(String resourceID) throws SearchException {
        return this._isNotNull(null, resourceID);
    }

    public IStatisticFilter isNotNull(StatisticResourceFilter resourceID) throws SearchException {
        return this._isNotNull(resourceID, null);
    }

    private IStatisticFilter _isNotNull(StatisticResourceFilter resourceStatID, String resourceID) throws SearchException {
        try {
            List<IField> fieldsResourceName;
            StatisticFilterName statisticFilter = null;
            if (resourceStatID != null) {
                this.check(resourceStatID);
                statisticFilter = resourceStatID.getStatisticFilterName();
                resourceID = resourceStatID.getResourceID();
            }
            if ((fieldsResourceName = this.getIFieldForResourceName(statisticFilter)).size() == 1) {
                IExpression expr = this.newIExpression();
                expr.and();
                IField fieldResourceName = fieldsResourceName.get(0);
                expr.equals(fieldResourceName, (Object)resourceID);
                expr.isNotNull(this.getIFieldForResourceValue(fieldResourceName));
                this.expression.and(new IExpression[]{expr});
            } else {
                IExpression exprEsterna = this.newIExpression();
                exprEsterna.or();
                for (IField fieldResourceName : fieldsResourceName) {
                    IExpression expr = this.newIExpression();
                    expr.and();
                    expr.equals(fieldResourceName, (Object)resourceID);
                    expr.isNotNull(this.getIFieldForResourceValue(fieldResourceName));
                    exprEsterna.or(new IExpression[]{expr});
                }
                this.expression.and(new IExpression[]{exprEsterna});
            }
            return this;
        }
        catch (Exception e) {
            throw new SearchException(e.getMessage(), (Throwable)e);
        }
    }

    public IFilter isEmpty(String resourceID) throws SearchException {
        return this._isEmpty(null, resourceID);
    }

    public IStatisticFilter isEmpty(StatisticResourceFilter resourceID) throws SearchException {
        return this._isEmpty(resourceID, null);
    }

    private IStatisticFilter _isEmpty(StatisticResourceFilter resourceStatID, String resourceID) throws SearchException {
        try {
            List<IField> fieldsResourceName;
            StatisticFilterName statisticFilter = null;
            if (resourceStatID != null) {
                this.check(resourceStatID);
                statisticFilter = resourceStatID.getStatisticFilterName();
                resourceID = resourceStatID.getResourceID();
            }
            if ((fieldsResourceName = this.getIFieldForResourceName(statisticFilter)).size() == 1) {
                IExpression expr = this.newIExpression();
                expr.and();
                IField fieldResourceName = fieldsResourceName.get(0);
                expr.equals(fieldResourceName, (Object)resourceID);
                expr.isEmpty(this.getIFieldForResourceValue(fieldResourceName));
                this.expression.and(new IExpression[]{expr});
            } else {
                IExpression exprEsterna = this.newIExpression();
                exprEsterna.or();
                for (IField fieldResourceName : fieldsResourceName) {
                    IExpression expr = this.newIExpression();
                    expr.and();
                    expr.equals(fieldResourceName, (Object)resourceID);
                    expr.isEmpty(this.getIFieldForResourceValue(fieldResourceName));
                    exprEsterna.or(new IExpression[]{expr});
                }
                this.expression.and(new IExpression[]{exprEsterna});
            }
            return this;
        }
        catch (Exception e) {
            throw new SearchException(e.getMessage(), (Throwable)e);
        }
    }

    public IFilter isNotEmpty(String resourceID) throws SearchException {
        return this._isNotEmpty(null, resourceID);
    }

    public IStatisticFilter isNotEmpty(StatisticResourceFilter resourceID) throws SearchException {
        return this._isNotEmpty(resourceID, null);
    }

    private IStatisticFilter _isNotEmpty(StatisticResourceFilter resourceStatID, String resourceID) throws SearchException {
        try {
            List<IField> fieldsResourceName;
            StatisticFilterName statisticFilter = null;
            if (resourceStatID != null) {
                this.check(resourceStatID);
                statisticFilter = resourceStatID.getStatisticFilterName();
                resourceID = resourceStatID.getResourceID();
            }
            if ((fieldsResourceName = this.getIFieldForResourceName(statisticFilter)).size() == 1) {
                IExpression expr = this.newIExpression();
                expr.and();
                IField fieldResourceName = fieldsResourceName.get(0);
                expr.equals(fieldResourceName, (Object)resourceID);
                expr.isNotEmpty(this.getIFieldForResourceValue(fieldResourceName));
                this.expression.and(new IExpression[]{expr});
            } else {
                IExpression exprEsterna = this.newIExpression();
                exprEsterna.or();
                for (IField fieldResourceName : fieldsResourceName) {
                    IExpression expr = this.newIExpression();
                    expr.and();
                    expr.equals(fieldResourceName, (Object)resourceID);
                    expr.isNotEmpty(this.getIFieldForResourceValue(fieldResourceName));
                    exprEsterna.or(new IExpression[]{expr});
                }
                this.expression.and(new IExpression[]{exprEsterna});
            }
            return this;
        }
        catch (Exception e) {
            throw new SearchException(e.getMessage(), (Throwable)e);
        }
    }

    public IFilter between(String resourceID, Object lower, Object high) throws SearchException {
        return this._between(null, resourceID, lower, high);
    }

    public IStatisticFilter between(StatisticResourceFilter resourceID, Object lower, Object high) throws SearchException {
        return this._between(resourceID, null, lower, high);
    }

    private IStatisticFilter _between(StatisticResourceFilter resourceStatID, String resourceID, Object lower, Object high) throws SearchException {
        try {
            List<IField> fieldsResourceName;
            StatisticFilterName statisticFilter = null;
            if (resourceStatID != null) {
                this.check(resourceStatID);
                statisticFilter = resourceStatID.getStatisticFilterName();
                resourceID = resourceStatID.getResourceID();
            }
            if ((fieldsResourceName = this.getIFieldForResourceName(statisticFilter)).size() == 1) {
                IExpression expr = this.newIExpression();
                expr.and();
                IField fieldResourceName = fieldsResourceName.get(0);
                expr.equals(fieldResourceName, (Object)resourceID);
                expr.between(this.getIFieldForResourceValue(fieldResourceName), (Object)ContentFormatter.toString(lower), (Object)ContentFormatter.toString(high));
                this.expression.and(new IExpression[]{expr});
            } else {
                IExpression exprEsterna = this.newIExpression();
                exprEsterna.or();
                for (IField fieldResourceName : fieldsResourceName) {
                    IExpression expr = this.newIExpression();
                    expr.and();
                    expr.equals(fieldResourceName, (Object)resourceID);
                    expr.between(this.getIFieldForResourceValue(fieldResourceName), (Object)ContentFormatter.toString(lower), (Object)ContentFormatter.toString(high));
                    exprEsterna.or(new IExpression[]{expr});
                }
                this.expression.and(new IExpression[]{exprEsterna});
            }
            return this;
        }
        catch (Exception e) {
            throw new SearchException(e.getMessage(), (Throwable)e);
        }
    }

    public IFilter like(String resourceID, String value) throws SearchException {
        return this._like(null, resourceID, value);
    }

    public IStatisticFilter like(StatisticResourceFilter resourceID, String value) throws SearchException {
        return this._like(resourceID, null, value);
    }

    private IStatisticFilter _like(StatisticResourceFilter resourceStatID, String resourceID, String value) throws SearchException {
        try {
            List<IField> fieldsResourceName;
            StatisticFilterName statisticFilter = null;
            if (resourceStatID != null) {
                this.check(resourceStatID);
                statisticFilter = resourceStatID.getStatisticFilterName();
                resourceID = resourceStatID.getResourceID();
            }
            if ((fieldsResourceName = this.getIFieldForResourceName(statisticFilter)).size() == 1) {
                IExpression expr = this.newIExpression();
                expr.and();
                IField fieldResourceName = fieldsResourceName.get(0);
                expr.equals(fieldResourceName, (Object)resourceID);
                expr.like(this.getIFieldForResourceValue(fieldResourceName), value);
                this.expression.and(new IExpression[]{expr});
            } else {
                IExpression exprEsterna = this.newIExpression();
                exprEsterna.or();
                for (IField fieldResourceName : fieldsResourceName) {
                    IExpression expr = this.newIExpression();
                    expr.and();
                    expr.equals(fieldResourceName, (Object)resourceID);
                    expr.like(this.getIFieldForResourceValue(fieldResourceName), value);
                    exprEsterna.or(new IExpression[]{expr});
                }
                this.expression.and(new IExpression[]{exprEsterna});
            }
            return this;
        }
        catch (Exception e) {
            throw new SearchException(e.getMessage(), (Throwable)e);
        }
    }

    public IFilter like(String resourceID, String value, LikeMode mode) throws SearchException {
        return this._like(null, resourceID, value, mode);
    }

    public IStatisticFilter like(StatisticResourceFilter resourceID, String value, LikeMode mode) throws SearchException {
        return this._like(resourceID, null, value, mode);
    }

    private IStatisticFilter _like(StatisticResourceFilter resourceStatID, String resourceID, String value, LikeMode mode) throws SearchException {
        try {
            List<IField> fieldsResourceName;
            StatisticFilterName statisticFilter = null;
            if (resourceStatID != null) {
                this.check(resourceStatID);
                statisticFilter = resourceStatID.getStatisticFilterName();
                resourceID = resourceStatID.getResourceID();
            }
            if ((fieldsResourceName = this.getIFieldForResourceName(statisticFilter)).size() == 1) {
                IExpression expr = this.newIExpression();
                expr.and();
                IField fieldResourceName = fieldsResourceName.get(0);
                expr.equals(fieldResourceName, (Object)resourceID);
                expr.like(this.getIFieldForResourceValue(fieldResourceName), value, mode.getLikeGenericProjectValue());
                this.expression.and(new IExpression[]{expr});
            } else {
                IExpression exprEsterna = this.newIExpression();
                exprEsterna.or();
                for (IField fieldResourceName : fieldsResourceName) {
                    IExpression expr = this.newIExpression();
                    expr.and();
                    expr.equals(fieldResourceName, (Object)resourceID);
                    expr.like(this.getIFieldForResourceValue(fieldResourceName), value, mode.getLikeGenericProjectValue());
                    exprEsterna.or(new IExpression[]{expr});
                }
                this.expression.and(new IExpression[]{exprEsterna});
            }
            return this;
        }
        catch (Exception e) {
            throw new SearchException(e.getMessage(), (Throwable)e);
        }
    }

    public IFilter ilike(String resourceID, String value) throws SearchException {
        return this._ilike(null, resourceID, value);
    }

    public IStatisticFilter ilike(StatisticResourceFilter resourceID, String value) throws SearchException {
        return this._ilike(resourceID, null, value);
    }

    private IStatisticFilter _ilike(StatisticResourceFilter resourceStatID, String resourceID, String value) throws SearchException {
        try {
            List<IField> fieldsResourceName;
            StatisticFilterName statisticFilter = null;
            if (resourceStatID != null) {
                this.check(resourceStatID);
                statisticFilter = resourceStatID.getStatisticFilterName();
                resourceID = resourceStatID.getResourceID();
            }
            if ((fieldsResourceName = this.getIFieldForResourceName(statisticFilter)).size() == 1) {
                IExpression expr = this.newIExpression();
                expr.and();
                IField fieldResourceName = fieldsResourceName.get(0);
                expr.equals(fieldResourceName, (Object)resourceID);
                expr.ilike(this.getIFieldForResourceValue(fieldResourceName), value);
                this.expression.and(new IExpression[]{expr});
            } else {
                IExpression exprEsterna = this.newIExpression();
                exprEsterna.or();
                for (IField fieldResourceName : fieldsResourceName) {
                    IExpression expr = this.newIExpression();
                    expr.and();
                    expr.equals(fieldResourceName, (Object)resourceID);
                    expr.ilike(this.getIFieldForResourceValue(fieldResourceName), value);
                    exprEsterna.or(new IExpression[]{expr});
                }
                this.expression.and(new IExpression[]{exprEsterna});
            }
            return this;
        }
        catch (Exception e) {
            throw new SearchException(e.getMessage(), (Throwable)e);
        }
    }

    public IFilter ilike(String resourceID, String value, LikeMode mode) throws SearchException {
        return this._ilike(null, resourceID, value, mode);
    }

    public IStatisticFilter ilike(StatisticResourceFilter resourceID, String value, LikeMode mode) throws SearchException {
        return this._ilike(resourceID, null, value, mode);
    }

    private IStatisticFilter _ilike(StatisticResourceFilter resourceStatID, String resourceID, String value, LikeMode mode) throws SearchException {
        try {
            List<IField> fieldsResourceName;
            StatisticFilterName statisticFilter = null;
            if (resourceStatID != null) {
                this.check(resourceStatID);
                statisticFilter = resourceStatID.getStatisticFilterName();
                resourceID = resourceStatID.getResourceID();
            }
            if ((fieldsResourceName = this.getIFieldForResourceName(statisticFilter)).size() == 1) {
                IExpression expr = this.newIExpression();
                expr.and();
                IField fieldResourceName = fieldsResourceName.get(0);
                expr.equals(fieldResourceName, (Object)resourceID);
                expr.ilike(this.getIFieldForResourceValue(fieldResourceName), value, mode.getLikeGenericProjectValue());
                this.expression.and(new IExpression[]{expr});
            } else {
                IExpression exprEsterna = this.newIExpression();
                exprEsterna.or();
                for (IField fieldResourceName : fieldsResourceName) {
                    IExpression expr = this.newIExpression();
                    expr.and();
                    expr.equals(fieldResourceName, (Object)resourceID);
                    expr.ilike(this.getIFieldForResourceValue(fieldResourceName), value, mode.getLikeGenericProjectValue());
                    exprEsterna.or(new IExpression[]{expr});
                }
                this.expression.and(new IExpression[]{exprEsterna});
            }
            return this;
        }
        catch (Exception e) {
            throw new SearchException(e.getMessage(), (Throwable)e);
        }
    }

    public IFilter in(String resourceID, Object ... values) throws SearchException {
        return this._in(null, resourceID, values);
    }

    public IStatisticFilter in(StatisticResourceFilter resourceID, Object ... values) throws SearchException {
        return this._in(resourceID, null, values);
    }

    private IStatisticFilter _in(StatisticResourceFilter resourceStatID, String resourceID, Object ... values) throws SearchException {
        try {
            List<IField> fieldsResourceName;
            StatisticFilterName statisticFilter = null;
            if (resourceStatID != null) {
                this.check(resourceStatID);
                statisticFilter = resourceStatID.getStatisticFilterName();
                resourceID = resourceStatID.getResourceID();
            }
            if ((fieldsResourceName = this.getIFieldForResourceName(statisticFilter)).size() == 1) {
                IExpression expr = this.newIExpression();
                expr.and();
                IField fieldResourceName = fieldsResourceName.get(0);
                expr.equals(fieldResourceName, (Object)resourceID);
                expr.in(this.getIFieldForResourceValue(fieldResourceName), ContentFormatter.toString(values));
                this.expression.and(new IExpression[]{expr});
            } else {
                IExpression exprEsterna = this.newIExpression();
                exprEsterna.or();
                for (IField fieldResourceName : fieldsResourceName) {
                    IExpression expr = this.newIExpression();
                    expr.and();
                    expr.equals(fieldResourceName, (Object)resourceID);
                    expr.in(this.getIFieldForResourceValue(fieldResourceName), ContentFormatter.toString(values));
                    exprEsterna.or(new IExpression[]{expr});
                }
                this.expression.and(new IExpression[]{exprEsterna});
            }
            return this;
        }
        catch (Exception e) {
            throw new SearchException(e.getMessage(), (Throwable)e);
        }
    }

    public IFilter in(String resourceID, Collection<?> values) throws SearchException {
        return this._in(null, resourceID, values);
    }

    public IStatisticFilter in(StatisticResourceFilter resourceID, Collection<?> values) throws SearchException {
        return this._in(resourceID, null, values);
    }

    private IStatisticFilter _in(StatisticResourceFilter resourceStatID, String resourceID, Collection<?> values) throws SearchException {
        try {
            List<IField> fieldsResourceName;
            ArrayList<String> collectionString = new ArrayList<String>();
            for (Object o : values) {
                collectionString.add(ContentFormatter.toString(o));
            }
            StatisticFilterName statisticFilter = null;
            if (resourceStatID != null) {
                this.check(resourceStatID);
                statisticFilter = resourceStatID.getStatisticFilterName();
                resourceID = resourceStatID.getResourceID();
            }
            if ((fieldsResourceName = this.getIFieldForResourceName(statisticFilter)).size() == 1) {
                IExpression expr = this.newIExpression();
                expr.and();
                IField fieldResourceName = fieldsResourceName.get(0);
                expr.equals(fieldResourceName, (Object)resourceID);
                expr.in(this.getIFieldForResourceValue(fieldResourceName), collectionString);
                this.expression.and(new IExpression[]{expr});
            } else {
                IExpression exprEsterna = this.newIExpression();
                exprEsterna.or();
                for (IField fieldResourceName : fieldsResourceName) {
                    IExpression expr = this.newIExpression();
                    expr.and();
                    expr.equals(fieldResourceName, (Object)resourceID);
                    expr.in(this.getIFieldForResourceValue(fieldResourceName), collectionString);
                    exprEsterna.or(new IExpression[]{expr});
                }
                this.expression.and(new IExpression[]{exprEsterna});
            }
            return this;
        }
        catch (Exception e) {
            throw new SearchException(e.getMessage(), (Throwable)e);
        }
    }

    public IStatisticFilter and(IFilter exp1, IFilter exp2) throws SearchException {
        try {
            FilterImpl f1 = (FilterImpl)exp1;
            FilterImpl f2 = (FilterImpl)exp2;
            this.expression.and(f1.expression, f2.expression);
            return this;
        }
        catch (Exception e) {
            throw new SearchException(e.getMessage(), (Throwable)e);
        }
    }

    public IStatisticFilter and(IFilter ... expressions) throws SearchException {
        try {
            if (expressions != null && expressions.length > 0) {
                IExpression[] fs = new IExpression[expressions.length];
                for (int i = 0; i < expressions.length; ++i) {
                    fs[i] = ((FilterImpl)expressions[i]).expression;
                }
                this.expression.and(fs);
            }
            return this;
        }
        catch (Exception e) {
            throw new SearchException(e.getMessage(), (Throwable)e);
        }
    }

    public IStatisticFilter or(IFilter exp1, IFilter exp2) throws SearchException {
        try {
            FilterImpl f1 = (FilterImpl)exp1;
            FilterImpl f2 = (FilterImpl)exp2;
            this.expression.or(f1.expression, f2.expression);
            return this;
        }
        catch (Exception e) {
            throw new SearchException(e.getMessage(), (Throwable)e);
        }
    }

    public IStatisticFilter or(IFilter ... expressions) throws SearchException {
        try {
            if (expressions != null && expressions.length > 0) {
                IExpression[] fs = new IExpression[expressions.length];
                for (int i = 0; i < expressions.length; ++i) {
                    fs[i] = ((FilterImpl)expressions[i]).expression;
                }
                this.expression.or(fs);
            }
            return this;
        }
        catch (Exception e) {
            throw new SearchException(e.getMessage(), (Throwable)e);
        }
    }

    public IStatisticFilter not(IFilter expression) throws SearchException {
        try {
            FilterImpl f = (FilterImpl)expression;
            this.expression.not(f.expression);
            return this;
        }
        catch (Exception e) {
            throw new SearchException(e.getMessage(), (Throwable)e);
        }
    }

    public IStatisticFilter setMessageType(MessageType messageType) throws SearchException {
        try {
            IField f = this.getIFieldForMessageType();
            if (f != null) {
                this.expression.equals(f, (Object)messageType.name());
            }
            return this;
        }
        catch (Exception e) {
            throw new SearchException(e.getMessage(), (Throwable)e);
        }
    }

    public IStatisticFilter newFilter() throws SearchException {
        return this.newIFilter();
    }
}

