/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.config;

import java.sql.Connection;
import java.util.List;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.commons.dao.DAOFactoryException;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.plugins.ConfigurazioneServizioAzione;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.exception.ExpressionNotImplementedException;
import org.openspcoop2.generic_project.exception.MultipleResultException;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.IPaginatedExpression;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.monitor.engine.config.BasicServiceLibrary;
import org.openspcoop2.monitor.engine.config.SearchServiceLibrary;
import org.openspcoop2.monitor.engine.config.ricerche.ConfigurazioneRicerca;
import org.openspcoop2.monitor.engine.config.ricerche.dao.IConfigurazioneRicercaServiceSearch;
import org.openspcoop2.monitor.engine.config.ricerche.dao.IServiceManager;
import org.openspcoop2.monitor.engine.config.ricerche.dao.jdbc.JDBCServiceManager;
import org.openspcoop2.monitor.engine.config.ricerche.utils.ProjectInfo;
import org.slf4j.Logger;

public class SearchServiceLibraryReader {
    private Connection connection;
    private DAOFactory daoFactory = null;
    private ServiceManagerProperties daoFactoryServiceManagerPropertiesPluginsRicerche = null;
    private Logger daoFactoryLogger = null;
    private IServiceManager serviceManagerPluginsRicerche;
    private boolean debug;

    public SearchServiceLibraryReader(Connection connection, DAOFactory daoFactory, ServiceManagerProperties daoFactoryServiceManagerPropertiesPluginsRicerche, Logger daoFactoryLogger, boolean debug) {
        this.connection = connection;
        this.daoFactory = daoFactory;
        this.daoFactoryServiceManagerPropertiesPluginsRicerche = daoFactoryServiceManagerPropertiesPluginsRicerche;
        this.daoFactoryLogger = daoFactoryLogger;
        this.debug = debug;
    }

    public SearchServiceLibraryReader(IServiceManager serviceManagerPluginsRicerche, boolean debug) {
        this.serviceManagerPluginsRicerche = serviceManagerPluginsRicerche;
        this.debug = debug;
    }

    public SearchServiceLibrary readConfigurazioneRicerche(BasicServiceLibrary basicServiceLibrary, Logger log) throws Exception {
        List<ConfigurazioneRicerca> searchActionAllLibrary;
        SearchServiceLibrary searchServiceLibrary;
        block6: {
            List<ConfigurazioneRicerca> searchActionLibrary;
            IDAccordo idAccordo;
            String portType;
            block5: {
                searchServiceLibrary = new SearchServiceLibrary();
                searchServiceLibrary.setBasicServiceLibrary(basicServiceLibrary);
                String azione = basicServiceLibrary.getAzione();
                portType = basicServiceLibrary.getPortType();
                idAccordo = basicServiceLibrary.getIdAccordoServizioParteComune();
                searchActionLibrary = null;
                if (basicServiceLibrary.getServiceActionLibrary() != null) {
                    try {
                        searchActionLibrary = this.getServiceActionSearchLibrary(basicServiceLibrary.getServiceActionLibrary());
                    }
                    catch (NotFoundException notFound) {
                        if (!this.debug) break block5;
                        log.debug("Non risulta configurata una ricerca personalizzata per l'azione specifica [" + azione + "] per la libreria di servizio [" + portType + "] dell'accordo [" + idAccordo.toString() + "]", (Throwable)notFound);
                    }
                }
            }
            searchServiceLibrary.setSearchActionLibrary(searchActionLibrary);
            searchActionAllLibrary = null;
            try {
                searchActionAllLibrary = this.getServiceActionSearchLibrary(basicServiceLibrary.getServiceActionAllLibrary());
            }
            catch (NotFoundException notFound) {
                if (!this.debug) break block6;
                log.debug("Non risulta configurata una ricerca personalizzata per l'azione specifica [*] per la libreria di servizio [" + portType + "] dell'accordo [" + idAccordo.toString() + "]", (Throwable)notFound);
            }
        }
        searchServiceLibrary.setSearchActionAllLibrary(searchActionAllLibrary);
        return searchServiceLibrary;
    }

    private List<ConfigurazioneRicerca> getServiceActionSearchLibrary(ConfigurazioneServizioAzione serviceActionLibrary) throws DAOFactoryException, ServiceException, NotImplementedException, NotFoundException, MultipleResultException, ExpressionNotImplementedException, ExpressionException {
        boolean autoCommit = true;
        IServiceManager serviceManager = this.serviceManagerPluginsRicerche;
        if (serviceManager == null && (serviceManager = (IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)ProjectInfo.getInstance(), this.connection, autoCommit, this.daoFactoryServiceManagerPropertiesPluginsRicerche, this.daoFactoryLogger)) instanceof JDBCServiceManager) {
            ((JDBCServiceManager)serviceManager).getJdbcProperties().setShowSql(this.debug);
        }
        IConfigurazioneRicercaServiceSearch serviceSearch = serviceManager.getConfigurazioneRicercaServiceSearch();
        IPaginatedExpression pagExpr = serviceSearch.newPaginatedExpression();
        pagExpr.and();
        pagExpr.equals(ConfigurazioneRicerca.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.ACCORDO, (Object)serviceActionLibrary.getIdConfigurazioneServizio().getAccordo());
        pagExpr.equals(ConfigurazioneRicerca.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.TIPO_SOGGETTO_REFERENTE, (Object)serviceActionLibrary.getIdConfigurazioneServizio().getTipoSoggettoReferente());
        pagExpr.equals(ConfigurazioneRicerca.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.NOME_SOGGETTO_REFERENTE, (Object)serviceActionLibrary.getIdConfigurazioneServizio().getNomeSoggettoReferente());
        pagExpr.equals(ConfigurazioneRicerca.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.VERSIONE, (Object)serviceActionLibrary.getIdConfigurazioneServizio().getVersione());
        pagExpr.equals(ConfigurazioneRicerca.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.SERVIZIO, (Object)serviceActionLibrary.getIdConfigurazioneServizio().getServizio());
        pagExpr.equals(ConfigurazioneRicerca.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.AZIONE, (Object)serviceActionLibrary.getAzione());
        return serviceSearch.findAll(pagExpr);
    }
}

