/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.transazioni.DumpContenuto;
import org.openspcoop2.core.transazioni.DumpMessaggio;
import org.openspcoop2.core.transazioni.Transazione;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.xml.MessageDynamicNamespaceContextFactory;
import org.openspcoop2.monitor.engine.config.BasicServiceLibrary;
import org.openspcoop2.monitor.engine.config.TransactionInfo;
import org.openspcoop2.monitor.engine.config.TransactionResource;
import org.openspcoop2.monitor.engine.config.transazioni.ConfigurazioneTransazione;
import org.openspcoop2.monitor.engine.config.transazioni.ConfigurazioneTransazionePlugin;
import org.openspcoop2.monitor.engine.config.transazioni.ConfigurazioneTransazioneRisorsaContenuto;
import org.openspcoop2.monitor.engine.config.transazioni.ConfigurazioneTransazioneStato;
import org.openspcoop2.monitor.engine.config.transazioni.constants.PosizioneMascheramento;
import org.openspcoop2.monitor.engine.config.transazioni.constants.TipoControllo;
import org.openspcoop2.monitor.engine.config.transazioni.constants.TipoMascheramento;
import org.openspcoop2.monitor.engine.config.transazioni.constants.TipoMessaggio;
import org.openspcoop2.monitor.engine.dynamic.DynamicFactory;
import org.openspcoop2.monitor.engine.dynamic.IDynamicLoader;
import org.openspcoop2.monitor.engine.transaction.TransactionContentUtils;
import org.openspcoop2.monitor.engine.transaction.TransactionManager;
import org.openspcoop2.monitor.sdk.plugins.ITransactionProcessing;
import org.openspcoop2.monitor.sdk.transaction.Transaction;
import org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico;
import org.openspcoop2.protocol.sdk.tracciamento.Traccia;
import org.openspcoop2.protocol.sdk.tracciamento.TracciamentoException;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;
import org.openspcoop2.utils.xml.AbstractXPathExpressionEngine;
import org.openspcoop2.utils.xml.DynamicNamespaceContext;
import org.openspcoop2.utils.xml.XPathException;
import org.openspcoop2.utils.xml.XPathNotFoundException;
import org.openspcoop2.utils.xml.XPathNotValidException;
import org.openspcoop2.utils.xml.XPathReturnType;
import org.slf4j.Logger;
import org.w3c.dom.NodeList;

public class TransactionServiceLibrary
implements Serializable {
    private static final long serialVersionUID = 1L;
    private BasicServiceLibrary basicServiceLibrary;
    private ConfigurazioneTransazione transactionActionLibrary;
    private ConfigurazioneTransazione transactionActionAllLibrary;

    public BasicServiceLibrary getBasicServiceLibrary() {
        return this.basicServiceLibrary;
    }

    public void setBasicServiceLibrary(BasicServiceLibrary basicServiceLibrary) {
        this.basicServiceLibrary = basicServiceLibrary;
    }

    public ConfigurazioneTransazione getTransactionActionLibrary() {
        return this.transactionActionLibrary;
    }

    public void setTransactionActionLibrary(ConfigurazioneTransazione transactionActionLibrary) {
        this.transactionActionLibrary = transactionActionLibrary;
    }

    public ConfigurazioneTransazione getTransactionActionAllLibrary() {
        return this.transactionActionAllLibrary;
    }

    public void setTransactionActionAllLibrary(ConfigurazioneTransazione transactionActionAllLibrary) {
        this.transactionActionAllLibrary = transactionActionAllLibrary;
    }

    public TransactionInfo readStatoAndResources(OpenSPCoop2Message msg, MessageDynamicNamespaceContextFactory dncFactory, AbstractXPathExpressionEngine xpathEngine, boolean debug, Logger log, boolean isRichiesta, String idTransazione) throws Exception {
        TransactionInfo transactionInfo = new TransactionInfo();
        this._readStatoAndResources(null, msg, dncFactory, xpathEngine, debug, log, isRichiesta, idTransazione, true, true, transactionInfo);
        return transactionInfo;
    }

    public TransactionInfo readStato(OpenSPCoop2Message msg, MessageDynamicNamespaceContextFactory dncFactory, AbstractXPathExpressionEngine xpathEngine, boolean debug, Logger log, boolean isRichiesta, String idTransazione) throws Exception {
        TransactionInfo transactionInfo = new TransactionInfo();
        this._readStatoAndResources(null, msg, dncFactory, xpathEngine, debug, log, isRichiesta, idTransazione, true, false, transactionInfo);
        return transactionInfo;
    }

    public TransactionInfo readResources(OpenSPCoop2Message msg, MessageDynamicNamespaceContextFactory dncFactory, AbstractXPathExpressionEngine xpathEngine, boolean debug, Logger log, boolean isRichiesta, String idTransazione, String stato) throws Exception {
        TransactionInfo transactionInfo = new TransactionInfo();
        transactionInfo.setStato(stato);
        this._readStatoAndResources(null, msg, dncFactory, xpathEngine, debug, log, isRichiesta, idTransazione, false, true, transactionInfo);
        return transactionInfo;
    }

    private void _readStatoAndResources(SOAPEnvelope soapEnvelope, OpenSPCoop2Message msg, MessageDynamicNamespaceContextFactory dncFactory, AbstractXPathExpressionEngine xpathEngine, boolean debug, Logger log, boolean isRichiesta, String idTransazione, boolean readStato, boolean readResources, TransactionInfo transactionInfo) throws Exception {
        DynamicNamespaceContext dnc = null;
        if (readStato && transactionInfo.getStato() == null) {
            if (this.getTransactionActionLibrary() != null) {
                if (this.getTransactionActionLibrary().sizeConfigurazioneTransazioneStatoList() > 0) {
                    if (soapEnvelope == null) {
                        soapEnvelope = msg.castAsSoap().getSOAPPart().getEnvelope();
                    }
                    if (dnc == null) {
                        dnc = MessageType.SOAP_11.equals((Object)msg.getMessageType()) ? dncFactory.getNamespaceContextFromSoapEnvelope11(soapEnvelope) : dncFactory.getNamespaceContextFromSoapEnvelope12(soapEnvelope);
                    }
                }
                this.updateTransactionState(this.getTransactionActionLibrary().getConfigurazioneTransazioneStatoList(), isRichiesta, soapEnvelope, msg, dnc, idTransazione, xpathEngine, debug, log, transactionInfo);
            }
            if (transactionInfo.getStato() == null && this.getTransactionActionAllLibrary() != null) {
                if (this.getTransactionActionAllLibrary().sizeConfigurazioneTransazioneStatoList() > 0) {
                    if (soapEnvelope == null) {
                        soapEnvelope = msg.castAsSoap().getSOAPPart().getEnvelope();
                    }
                    if (dnc == null) {
                        dnc = MessageType.SOAP_11.equals((Object)msg.getMessageType()) ? dncFactory.getNamespaceContextFromSoapEnvelope11(soapEnvelope) : dncFactory.getNamespaceContextFromSoapEnvelope12(soapEnvelope);
                    }
                }
                this.updateTransactionState(this.getTransactionActionAllLibrary().getConfigurazioneTransazioneStatoList(), isRichiesta, soapEnvelope, msg, dnc, idTransazione, xpathEngine, debug, log, transactionInfo);
            }
        }
        if (readResources) {
            List<ConfigurazioneTransazioneRisorsaContenuto> risorse = this.mergeServiceActionTransactionLibrary_resources();
            HashMap<String, String> notFoundRules = new HashMap<String, String>();
            HashMap<String, String> dirtyRules = new HashMap<String, String>();
            if (risorse.size() > 0) {
                List<TransactionResource> contenuti;
                if (soapEnvelope == null) {
                    soapEnvelope = msg.castAsSoap().getSOAPPart().getEnvelope();
                }
                if (dnc == null) {
                    dnc = MessageType.SOAP_11.equals((Object)msg.getMessageType()) ? dncFactory.getNamespaceContextFromSoapEnvelope11(soapEnvelope) : dncFactory.getNamespaceContextFromSoapEnvelope12(soapEnvelope);
                }
                if ((contenuti = this.recuperaContenuti(isRichiesta, transactionInfo.getStato(), soapEnvelope, dnc, risorse, notFoundRules, dirtyRules, xpathEngine, debug, log)) != null) {
                    for (int i = 0; i < contenuti.size(); ++i) {
                        transactionInfo.getRisorse().add(contenuti.get(i));
                    }
                }
            }
            if (debug) {
                StringBuilder sbNotFound = new StringBuilder();
                if (notFoundRules.size() > 0) {
                    sbNotFound.append("Regole non trovate:");
                    for (String k : notFoundRules.keySet()) {
                        sbNotFound.append("\n[" + k + "]");
                    }
                }
                log.debug(sbNotFound.toString());
            }
            StringBuilder sb = new StringBuilder();
            if (dirtyRules.size() > 0) {
                sb.append("\nRegole non valide:");
                for (String k : dirtyRules.keySet()) {
                    String val = "\n[" + k + "-" + (String)dirtyRules.get(k) + "]";
                    sb.append(val);
                }
            }
            if (sb.length() > 0) {
                throw new TracciamentoException(sb.toString());
            }
        }
    }

    private void updateTransactionState(List<ConfigurazioneTransazioneStato> transactionStates, boolean richiesta, SOAPEnvelope soapEnvelope, OpenSPCoop2Message msg, DynamicNamespaceContext dnc, String idTransazione, AbstractXPathExpressionEngine xpathEngine, boolean debug, Logger log, TransactionInfo transactionInfo) throws Exception {
        for (int i = 0; i < transactionStates.size(); ++i) {
            Object oString;
            ConfigurazioneTransazioneStato stato;
            block11: {
                stato = transactionStates.get(i);
                if (!stato.isEnabled()) continue;
                boolean matchTipoMessaggio = false;
                matchTipoMessaggio = richiesta ? TipoMessaggio.RICHIESTA.equals(stato.getTipoMessaggio()) : TipoMessaggio.RISPOSTA.equals(stato.getTipoMessaggio());
                if (!matchTipoMessaggio) continue;
                if (TipoControllo.EXIST.equals(stato.getTipoControllo())) {
                    block10: {
                        oString = null;
                        try {
                            oString = xpathEngine.getMatchPattern((SOAPElement)soapEnvelope, dnc, stato.getXpath(), XPathReturnType.STRING);
                        }
                        catch (XPathNotFoundException nfe) {
                            if (!debug) break block10;
                            log.debug("Stato [" + stato.getNome() + "] con tipoControllo[" + stato.getTipoControllo() + "] (xpath:" + stato.getXpath() + ") non riscontrato per la trasazione [" + idTransazione + "]: " + nfe.getMessage());
                        }
                    }
                    if (oString == null) continue;
                    if (debug) {
                        log.info("Trovato stato [" + stato.getNome() + "] con tipoControllo[" + stato.getTipoControllo() + "] (xpath:" + stato.getXpath() + ") per la trasazione [" + idTransazione + "]");
                    }
                    transactionInfo.setStato(stato.getNome());
                    break;
                }
                oString = null;
                try {
                    oString = (String)xpathEngine.getMatchPattern((SOAPElement)soapEnvelope, dnc, stato.getXpath(), XPathReturnType.STRING);
                }
                catch (XPathNotFoundException nfe) {
                    if (!debug) break block11;
                    log.debug("Stato [" + stato.getNome() + "] con tipoControllo[" + stato.getTipoControllo() + "] (xpath:" + stato.getXpath() + ") non riscontrato per la trasazione [" + idTransazione + "]: " + nfe.getMessage());
                }
            }
            if (oString == null) continue;
            if (TipoControllo.EQUALS.equals(stato.getTipoControllo())) {
                if (!((String)oString).equals(stato.getValore())) continue;
                if (debug) {
                    log.info("Trovato stato [" + stato.getNome() + "] per trasazione [" + idTransazione + "]");
                }
                transactionInfo.setStato(stato.getNome());
                break;
            }
            if (!TipoControllo.MATCH.equals(stato.getTipoControllo()) || !RegularExpressionEngine.isMatch((String)oString, (String)stato.getValore())) continue;
            if (debug) {
                log.info("Trovato stato [" + stato.getNome() + "] con tipoControllo[" + stato.getTipoControllo() + "] (xpath:" + stato.getXpath() + ") per la trasazione [" + idTransazione + "]");
            }
            transactionInfo.setStato(stato.getNome());
            break;
        }
    }

    private List<TransactionResource> recuperaContenuti(boolean richiesta, String stato, SOAPEnvelope soapEnvelope, DynamicNamespaceContext dnc, List<ConfigurazioneTransazioneRisorsaContenuto> risorse, Map<String, String> rulesNotFuond, Map<String, String> dirtyRules, AbstractXPathExpressionEngine xpathEngine, boolean debug, Logger log) throws Exception {
        ArrayList<TransactionResource> res = new ArrayList<TransactionResource>();
        if (dnc.isSoapBodyEmpty()) {
            return res;
        }
        for (int i = 0; i < risorse.size(); ++i) {
            String statoRichiestoDallaRisorsa;
            ConfigurazioneTransazioneRisorsaContenuto risorsa = risorse.get(i);
            boolean matchTipoMessaggio = false;
            matchTipoMessaggio = richiesta ? TipoMessaggio.RICHIESTA.equals(risorsa.getTipoMessaggio()) : TipoMessaggio.RISPOSTA.equals(risorsa.getTipoMessaggio());
            if (!matchTipoMessaggio || (stato != null ? risorsa.getIdConfigurazioneTransazioneStato() != null && (statoRichiestoDallaRisorsa = risorsa.getIdConfigurazioneTransazioneStato().getStato()) != null && !"*".equals(statoRichiestoDallaRisorsa) && !stato.equals(statoRichiestoDallaRisorsa) : risorsa.getIdConfigurazioneTransazioneStato() != null && (statoRichiestoDallaRisorsa = risorsa.getIdConfigurazioneTransazioneStato().getStato()) != null && !"*".equals(statoRichiestoDallaRisorsa))) continue;
            String nomeProprieta = risorsa.getNome();
            String percorsoProprieta = risorsa.getXpath();
            try {
                NodeList nodeList = null;
                Exception exceptionNodeSet = null;
                String risultato = null;
                try {
                    nodeList = (NodeList)xpathEngine.getMatchPattern((SOAPElement)soapEnvelope, dnc, percorsoProprieta, XPathReturnType.NODESET);
                    if (nodeList != null) {
                        risultato = xpathEngine.toString(nodeList);
                    }
                }
                catch (Exception e) {
                    exceptionNodeSet = e;
                }
                if (risultato == null || "".equals(risultato)) {
                    try {
                        risultato = xpathEngine.getStringMatchPattern((SOAPElement)soapEnvelope, dnc, percorsoProprieta);
                    }
                    catch (Exception e) {
                        if (exceptionNodeSet != null) {
                            log.error("Errore avvenuto durante la getStringMatchPattern(" + percorsoProprieta + ") (" + e.getMessage() + ") invocata in seguito all'errore dell'invocazione getMatchPattern(" + percorsoProprieta + ",NODESET): " + exceptionNodeSet.getMessage(), (Throwable)exceptionNodeSet);
                        }
                        if (e instanceof XPathNotFoundException) {
                            throw (XPathNotFoundException)((Object)e);
                        }
                        if (e instanceof XPathNotValidException) {
                            throw (XPathNotValidException)((Object)e);
                        }
                        if (e instanceof XPathException) {
                            throw (XPathException)((Object)e);
                        }
                        throw e;
                    }
                }
                if (risultato == null || "".equals(risultato)) {
                    if (exceptionNodeSet != null) {
                        log.error("Non sono stati trovati risultati tramite l'invocazione del metodo getStringMatchPattern(" + percorsoProprieta + ") invocato in seguito all'errore dell'invocazione getMatchPattern(" + percorsoProprieta + ",NODESET): " + exceptionNodeSet.getMessage(), (Throwable)exceptionNodeSet);
                    }
                    rulesNotFuond.put(nomeProprieta, percorsoProprieta);
                    continue;
                }
                TransactionResource risorsaCalcolata = new TransactionResource();
                if (richiesta) {
                    risorsaCalcolata.setTipoMessaggio(org.openspcoop2.core.transazioni.constants.TipoMessaggio.RICHIESTA_INGRESSO);
                } else {
                    risorsaCalcolata.setTipoMessaggio(org.openspcoop2.core.transazioni.constants.TipoMessaggio.RISPOSTA_INGRESSO);
                }
                risorsaCalcolata.setNome(nomeProprieta);
                risorsaCalcolata.setValore(risultato);
                res.add(risorsaCalcolata);
                if (!debug) continue;
                log.debug(nomeProprieta + " - " + percorsoProprieta + " : " + risultato);
                continue;
            }
            catch (XPathNotFoundException nfe) {
                rulesNotFuond.put(nomeProprieta, nfe.getMessage());
                continue;
            }
            catch (XPathNotValidException re) {
                log.error("Errore di validazione della query XPath [" + percorsoProprieta + "] durante la valutazione della proprieta [" + nomeProprieta + "]: " + re.getMessage(), (Throwable)re);
                dirtyRules.put(nomeProprieta, re.getMessage());
                continue;
            }
            catch (XPathException re) {
                log.error("Errore durante la valutazione della proprieta [" + nomeProprieta + "] query XPath [" + percorsoProprieta + "]: " + re.getMessage(), (Throwable)re);
                dirtyRules.put(nomeProprieta, re.getMessage());
                continue;
            }
            catch (Exception e) {
                throw new Exception("Errore generico durante la valutazione della proprieta [" + nomeProprieta + "] query XPath [" + percorsoProprieta + "]: " + e.getMessage(), e);
            }
        }
        return res;
    }

    public boolean processResourcesBeforeSaveOnDatabase(Transazione transazione, Traccia tracciaRichiesta, Traccia tracciaRisposta, List<MsgDiagnostico> msgDiagnostici, DumpMessaggio dumpMessaggioRichiestaIngresso, DumpMessaggio dumpMessaggioRichiestaUscita, DumpMessaggio dumpMessaggioRispostaIngresso, DumpMessaggio dumpMessaggioRispostaUscita, String stato, Logger log, DAOFactory daoFactory) throws Exception {
        return this.processResourcesBeforeSaveOnDatabase(transazione, tracciaRichiesta, tracciaRisposta, msgDiagnostici, dumpMessaggioRichiestaIngresso, dumpMessaggioRichiestaUscita, dumpMessaggioRispostaIngresso, dumpMessaggioRispostaUscita, stato, this.mergeServiceActionTransactionLibrary_resources(), this.mergeServiceActionTransactionLibrary_sdkPlugins(log), log, daoFactory);
    }

    public boolean processResourcesBeforeSaveOnDatabase(Transazione transazione, Traccia tracciaRichiesta, Traccia tracciaRisposta, List<MsgDiagnostico> msgDiagnostici, DumpMessaggio dumpMessaggioRichiestaIngresso, DumpMessaggio dumpMessaggioRichiestaUscita, DumpMessaggio dumpMessaggioRispostaIngresso, DumpMessaggio dumpMessaggioRispostaUscita, String stato, List<ConfigurazioneTransazioneRisorsaContenuto> listRisorseContenuto, List<ITransactionProcessing> listTransactionProcessing, Logger log, DAOFactory daoFactory) throws Exception {
        boolean updated;
        boolean bl = updated = this.updateDumpMessaggio(dumpMessaggioRichiestaIngresso, listRisorseContenuto, stato) && this.updateDumpMessaggio(dumpMessaggioRichiestaUscita, listRisorseContenuto, stato) && this.updateDumpMessaggio(dumpMessaggioRispostaIngresso, listRisorseContenuto, stato) && this.updateDumpMessaggio(dumpMessaggioRispostaUscita, listRisorseContenuto, stato);
        if (listTransactionProcessing != null && listTransactionProcessing.size() > 0) {
            Transaction transactionSDK = new Transaction(log, daoFactory, transazione, tracciaRichiesta, tracciaRisposta, msgDiagnostici);
            if (dumpMessaggioRichiestaIngresso != null) {
                TransactionManager.setContentResourcesInTransaction(transactionSDK, dumpMessaggioRichiestaIngresso);
            }
            if (dumpMessaggioRichiestaUscita != null) {
                TransactionManager.setContentResourcesInTransaction(transactionSDK, dumpMessaggioRichiestaUscita);
            }
            if (dumpMessaggioRispostaIngresso != null) {
                TransactionManager.setContentResourcesInTransaction(transactionSDK, dumpMessaggioRispostaIngresso);
            }
            if (dumpMessaggioRispostaUscita != null) {
                TransactionManager.setContentResourcesInTransaction(transactionSDK, dumpMessaggioRispostaUscita);
            }
            for (ITransactionProcessing iTransactionProcessing : listTransactionProcessing) {
                iTransactionProcessing.processRealTimeResourcesBeforeSaveOnDatabase(transactionSDK);
            }
            if (dumpMessaggioRichiestaIngresso != null && TransactionManager.updateResources(dumpMessaggioRichiestaIngresso, transactionSDK)) {
                updated = true;
            }
            if (dumpMessaggioRichiestaUscita != null && TransactionManager.updateResources(dumpMessaggioRichiestaUscita, transactionSDK)) {
                updated = true;
            }
            if (dumpMessaggioRispostaIngresso != null && TransactionManager.updateResources(dumpMessaggioRispostaIngresso, transactionSDK)) {
                updated = true;
            }
            if (dumpMessaggioRispostaUscita != null && TransactionManager.updateResources(dumpMessaggioRispostaUscita, transactionSDK)) {
                updated = true;
            }
        }
        return updated;
    }

    private boolean updateDumpMessaggio(DumpMessaggio dumpMessaggio, List<ConfigurazioneTransazioneRisorsaContenuto> listRisorseContenuto, String stato) throws Exception {
        boolean updated = false;
        if (dumpMessaggio != null && dumpMessaggio.sizeContenutoList() > 0) {
            block0: for (DumpContenuto dumpContenuto : dumpMessaggio.getContenutoList()) {
                for (ConfigurazioneTransazioneRisorsaContenuto configurazioneTransazioneRisorsaContenuto : listRisorseContenuto) {
                    if (configurazioneTransazioneRisorsaContenuto.getIdConfigurazioneTransazioneStato() != null && configurazioneTransazioneRisorsaContenuto.getIdConfigurazioneTransazioneStato().getStato() != null && !"".equals(configurazioneTransazioneRisorsaContenuto.getIdConfigurazioneTransazioneStato().getStato()) && !configurazioneTransazioneRisorsaContenuto.getIdConfigurazioneTransazioneStato().getStato().equals(stato) || !configurazioneTransazioneRisorsaContenuto.getTipoMessaggio().toString().equals(dumpMessaggio.getTipoMessaggio().toString()) || !configurazioneTransazioneRisorsaContenuto.getNome().equals(dumpContenuto.getNome())) continue;
                    if (configurazioneTransazioneRisorsaContenuto.getAbilitaAnonimizzazione() != null && configurazioneTransazioneRisorsaContenuto.getAbilitaAnonimizzazione() == 1 && TipoMascheramento.FISICO.equals(configurazioneTransazioneRisorsaContenuto.getTipoMascheramento())) {
                        TransactionContentUtils.setDumpContenutoValue(dumpContenuto, this.mascheramento(configurazioneTransazioneRisorsaContenuto.getCarattereMaschera(), configurazioneTransazioneRisorsaContenuto.getPosizionamentoMaschera(), configurazioneTransazioneRisorsaContenuto.getNumeroCaratteriMaschera(), TransactionContentUtils.getDumpContenutoValue(dumpContenuto)));
                        updated = true;
                    }
                    if (configurazioneTransazioneRisorsaContenuto.getAbilitaCompressione() == null || configurazioneTransazioneRisorsaContenuto.getAbilitaCompressione() != 1) continue block0;
                    TransactionContentUtils.compress(dumpContenuto, configurazioneTransazioneRisorsaContenuto.getTipoCompressione());
                    updated = true;
                    continue block0;
                }
            }
        }
        return updated;
    }

    public boolean processResourcesAfterReadFromDatabase(Transazione transazione, DumpMessaggio dumpMessaggio, String stato, Logger log, DAOFactory daoFactory) throws Exception {
        return this.processResourcesAfterReadFromDatabase(transazione, dumpMessaggio, stato, this.mergeServiceActionTransactionLibrary_resources(), this.mergeServiceActionTransactionLibrary_sdkPlugins(log), log, daoFactory);
    }

    public boolean processResourcesAfterReadFromDatabase(Transazione transazione, DumpMessaggio dumpMessaggio, String stato, List<ConfigurazioneTransazioneRisorsaContenuto> list, List<ITransactionProcessing> listTransactionProcessing, Logger log, DAOFactory daoFactory) throws Exception {
        boolean updated = false;
        if (dumpMessaggio != null) {
            if (dumpMessaggio.sizeContenutoList() > 0) {
                block0: for (DumpContenuto dumpContenuto : dumpMessaggio.getContenutoList()) {
                    for (ConfigurazioneTransazioneRisorsaContenuto configurazioneTransazioneRisorsaContenuto : list) {
                        if (configurazioneTransazioneRisorsaContenuto.getIdConfigurazioneTransazioneStato() != null && configurazioneTransazioneRisorsaContenuto.getIdConfigurazioneTransazioneStato().getStato() != null && !"".equals(configurazioneTransazioneRisorsaContenuto.getIdConfigurazioneTransazioneStato().getStato()) && !configurazioneTransazioneRisorsaContenuto.getIdConfigurazioneTransazioneStato().getStato().equals(stato) || !configurazioneTransazioneRisorsaContenuto.getTipoMessaggio().toString().equals(dumpMessaggio.getTipoMessaggio().toString()) || !configurazioneTransazioneRisorsaContenuto.getNome().equals(dumpContenuto.getNome())) continue;
                        if (configurazioneTransazioneRisorsaContenuto.getAbilitaCompressione() != null && configurazioneTransazioneRisorsaContenuto.getAbilitaCompressione() == 1) {
                            TransactionContentUtils.decompress(dumpContenuto, configurazioneTransazioneRisorsaContenuto.getTipoCompressione());
                            updated = true;
                        }
                        if (configurazioneTransazioneRisorsaContenuto.getAbilitaAnonimizzazione() == null || configurazioneTransazioneRisorsaContenuto.getAbilitaAnonimizzazione() != 1 || !TipoMascheramento.LOGICO.equals(configurazioneTransazioneRisorsaContenuto.getTipoMascheramento())) continue block0;
                        TransactionContentUtils.setDumpContenutoValue(dumpContenuto, this.mascheramento(configurazioneTransazioneRisorsaContenuto.getCarattereMaschera(), configurazioneTransazioneRisorsaContenuto.getPosizionamentoMaschera(), configurazioneTransazioneRisorsaContenuto.getNumeroCaratteriMaschera(), TransactionContentUtils.getDumpContenutoValue(dumpContenuto)));
                        updated = true;
                        continue block0;
                    }
                }
            }
            if (listTransactionProcessing != null && listTransactionProcessing.size() > 0) {
                Transaction transactionSDK = new Transaction(log, daoFactory, transazione);
                TransactionManager.setContentResourcesInTransaction(transactionSDK, dumpMessaggio);
                for (ITransactionProcessing iTransactionProcessing : listTransactionProcessing) {
                    iTransactionProcessing.processRealTimeResourcesAfterReadFromDatabase(transactionSDK);
                }
                if (TransactionManager.updateResources(dumpMessaggio, transactionSDK)) {
                    updated = true;
                }
            }
        }
        return updated;
    }

    public String toString() {
        StringBuilder bf = new StringBuilder();
        if (this.basicServiceLibrary == null) {
            bf.append("BasicServiceLibrary: notDefined");
            bf.append("\n");
        } else {
            bf.append(this.basicServiceLibrary.toString());
        }
        bf.append("TransactionActionLibrary: ");
        if (this.getTransactionActionLibrary() != null) {
            bf.append("presente size-plugins[").append(this.getTransactionActionLibrary().sizeConfigurazioneTransazionePluginList()).append("] plugins[").append(this.getTransactionActionLibrary().getConfigurazioneTransazionePluginList()).append(" size-stati[").append(this.getTransactionActionLibrary().sizeConfigurazioneTransazioneStatoList()).append("] stati[").append(this.getTransactionActionLibrary().getConfigurazioneTransazioneStatoList()).append("] size-risorse[").append(this.getTransactionActionLibrary().sizeConfigurazioneTransazioneRisorsaContenutoList()).append("] risorse[").append(this.getTransactionActionLibrary().getConfigurazioneTransazioneRisorsaContenutoList()).append("] enabled[").append(this.getTransactionActionLibrary().isEnabled()).append("]");
        } else {
            bf.append("-");
        }
        bf.append("\n");
        bf.append("TransactionActionAllLibrary: ");
        if (this.getTransactionActionAllLibrary() != null) {
            bf.append("presente size-plugins[").append(this.getTransactionActionAllLibrary().sizeConfigurazioneTransazionePluginList()).append("] plugins[").append(this.getTransactionActionAllLibrary().getConfigurazioneTransazionePluginList()).append("presente size-stati[").append(this.getTransactionActionAllLibrary().sizeConfigurazioneTransazioneStatoList()).append("] stati[").append(this.getTransactionActionAllLibrary().getConfigurazioneTransazioneStatoList()).append("] size-risorse[").append(this.getTransactionActionAllLibrary().sizeConfigurazioneTransazioneRisorsaContenutoList()).append("] risorse[").append(this.getTransactionActionAllLibrary().getConfigurazioneTransazioneRisorsaContenutoList()).append("] enabled[").append(this.getTransactionActionAllLibrary().isEnabled()).append("]");
        } else {
            bf.append("-");
        }
        bf.append("\n");
        return bf.toString();
    }

    public List<ConfigurazioneTransazioneStato> mergeServiceActionTransactionLibrary_states() throws Exception {
        ArrayList<ConfigurazioneTransazioneStato> list = new ArrayList<ConfigurazioneTransazioneStato>();
        ArrayList<String> idStati = new ArrayList<String>();
        if (this.transactionActionLibrary != null && this.transactionActionLibrary.sizeConfigurazioneTransazioneStatoList() > 0) {
            for (ConfigurazioneTransazioneStato configurazioneTransazioneStato : this.transactionActionLibrary.getConfigurazioneTransazioneStatoList()) {
                if (!configurazioneTransazioneStato.isEnabled()) continue;
                list.add(configurazioneTransazioneStato);
                idStati.add(configurazioneTransazioneStato.getNome());
            }
        }
        if (this.transactionActionAllLibrary != null && this.transactionActionAllLibrary.sizeConfigurazioneTransazioneStatoList() > 0) {
            for (ConfigurazioneTransazioneStato configurazioneTransazioneStato : this.transactionActionAllLibrary.getConfigurazioneTransazioneStatoList()) {
                String idStato;
                if (!configurazioneTransazioneStato.isEnabled() || idStati.contains(idStato = configurazioneTransazioneStato.getNome())) continue;
                list.add(configurazioneTransazioneStato);
                idStati.add(idStato);
            }
        }
        return list;
    }

    public List<ConfigurazioneTransazioneRisorsaContenuto> mergeServiceActionTransactionLibrary_resources() throws Exception {
        ArrayList<ConfigurazioneTransazioneRisorsaContenuto> list = new ArrayList<ConfigurazioneTransazioneRisorsaContenuto>();
        ArrayList<String> idRisorse = new ArrayList<String>();
        if (this.transactionActionLibrary != null && this.transactionActionLibrary.sizeConfigurazioneTransazioneRisorsaContenutoList() > 0) {
            for (ConfigurazioneTransazioneRisorsaContenuto configurazioneTransazioneRisorsaContenuto : this.transactionActionLibrary.getConfigurazioneTransazioneRisorsaContenutoList()) {
                if (!configurazioneTransazioneRisorsaContenuto.isEnabled()) continue;
                list.add(configurazioneTransazioneRisorsaContenuto);
                idRisorse.add(configurazioneTransazioneRisorsaContenuto.getNome());
            }
        }
        if (this.transactionActionAllLibrary != null && this.transactionActionAllLibrary.sizeConfigurazioneTransazioneRisorsaContenutoList() > 0) {
            for (ConfigurazioneTransazioneRisorsaContenuto configurazioneTransazioneRisorsaContenuto : this.transactionActionAllLibrary.getConfigurazioneTransazioneRisorsaContenutoList()) {
                String idRisorsa;
                if (!configurazioneTransazioneRisorsaContenuto.isEnabled() || idRisorse.contains(idRisorsa = configurazioneTransazioneRisorsaContenuto.getNome())) continue;
                list.add(configurazioneTransazioneRisorsaContenuto);
                idRisorse.add(idRisorsa);
            }
        }
        return list;
    }

    public List<ITransactionProcessing> mergeServiceActionTransactionLibrary_sdkPlugins(Logger log) throws Exception {
        ITransactionProcessing transactionProcessor;
        IDynamicLoader loader;
        String className;
        ArrayList<ITransactionProcessing> list = new ArrayList<ITransactionProcessing>();
        ArrayList<String> idRisorse = new ArrayList<String>();
        if (this.transactionActionLibrary != null && this.transactionActionLibrary.getEnabled() && this.transactionActionLibrary.getConfigurazioneTransazionePluginList() != null && this.transactionActionLibrary.getConfigurazioneTransazionePluginList().size() > 0) {
            for (ConfigurazioneTransazionePlugin configTransazionePlugin : this.transactionActionLibrary.getConfigurazioneTransazionePluginList()) {
                if (!configTransazionePlugin.isEnabled() || idRisorse.contains(className = configTransazionePlugin.getPlugin().getClassName())) continue;
                loader = DynamicFactory.getInstance().newDynamicLoader(configTransazionePlugin.getPlugin().getTipoPlugin(), configTransazionePlugin.getPlugin().getTipo(), className, log);
                transactionProcessor = (ITransactionProcessing)loader.newInstance();
                idRisorse.add(className);
                list.add(transactionProcessor);
            }
        }
        if (this.transactionActionAllLibrary != null && this.transactionActionAllLibrary.getEnabled() && this.transactionActionAllLibrary.getConfigurazioneTransazionePluginList() != null && this.transactionActionAllLibrary.getConfigurazioneTransazionePluginList().size() > 0) {
            for (ConfigurazioneTransazionePlugin configTransazionePlugin : this.transactionActionAllLibrary.getConfigurazioneTransazionePluginList()) {
                if (!configTransazionePlugin.isEnabled() || idRisorse.contains(className = configTransazionePlugin.getPlugin().getClassName())) continue;
                loader = DynamicFactory.getInstance().newDynamicLoader(configTransazionePlugin.getPlugin().getTipoPlugin(), configTransazionePlugin.getPlugin().getTipo(), className, log);
                transactionProcessor = (ITransactionProcessing)loader.newInstance();
                idRisorse.add(className);
                list.add(transactionProcessor);
            }
        }
        return list;
    }

    private String mascheramento(char carattereMascheramento, PosizioneMascheramento posizioneMascheramento, int numero, String originale) {
        StringBuilder bf = new StringBuilder();
        if (originale.length() <= numero || numero <= 0) {
            for (int i = 0; i < originale.length(); ++i) {
                bf.append(carattereMascheramento);
            }
        } else if (PosizioneMascheramento.PRIMI.equals(posizioneMascheramento)) {
            int i;
            for (i = 0; i < numero; ++i) {
                bf.append(carattereMascheramento);
            }
            while (i < originale.length()) {
                bf.append(originale.charAt(i));
                ++i;
            }
        } else {
            int i;
            for (i = 0; i < originale.length() - numero; ++i) {
                bf.append(originale.charAt(i));
            }
            while (i < originale.length()) {
                bf.append(carattereMascheramento);
                ++i;
            }
        }
        return bf.toString();
    }
}

