/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.dynamic;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.regexp.RegExpException;
import org.openspcoop2.utils.regexp.RegExpNotFoundException;
import org.openspcoop2.utils.regexp.RegExpNotValidException;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;
import org.openspcoop2.utils.resources.FileSystemUtilities;

public class PluginJar
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String nome;
    private Date date;
    private File fContent;
    private String url;
    private URL resourceURL;

    public PluginJar(String nome, Date data, byte[] contenuto) throws UtilsException, IOException {
        this.nome = nome;
        this.date = data;
        this.fContent = FileSystemUtilities.createTempFile((String)("plugin_" + this.nome), (String)".raw");
        FileSystemUtilities.writeFile((File)this.fContent, (byte[])contenuto);
        this.resourceURL = this.fContent.toURI().toURL();
    }

    public PluginJar(String nome, Date data, String url) throws RegExpException, RegExpNotValidException, RegExpNotFoundException, MalformedURLException {
        File f;
        this.nome = nome;
        this.date = data;
        this.url = url;
        String uriPattern = ".+://.+";
        boolean matchUri = RegularExpressionEngine.isMatch((String)this.url, (String)uriPattern);
        this.resourceURL = matchUri ? new URL(this.url) : ((f = new File(this.url)).exists() ? f.toURI().toURL() : new URL(this.url));
    }

    public void close() {
        if (this.fContent != null) {
            FileSystemUtilities.deleteFile((File)this.fContent);
        }
    }

    public String getNome() {
        return this.nome;
    }

    public Date getDate() {
        return this.date;
    }

    public URL getResourceURL() {
        return this.resourceURL;
    }
}

