/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.fs_recovery;

import java.io.File;
import java.sql.Connection;
import java.util.ArrayList;
import org.openspcoop2.core.diagnostica.ElencoMessaggiDiagnostici;
import org.openspcoop2.core.diagnostica.MessaggioDiagnostico;
import org.openspcoop2.core.diagnostica.utils.serializer.JaxbDeserializer;
import org.openspcoop2.monitor.engine.fs_recovery.AbstractFSRecovery;
import org.openspcoop2.protocol.sdk.diagnostica.IDiagnosticProducer;
import org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.UtilsMultiException;
import org.slf4j.Logger;

public class FSRecoveryDiagnosticiImpl
extends AbstractFSRecovery {
    private IDiagnosticProducer diagnosticoAppender;

    public FSRecoveryDiagnosticiImpl(Logger log, boolean debug, IDiagnosticProducer diagnosticoAppender, File directory, File directoryDLQ, int tentativi, long msAttesaProcessingFile, long maxFileProcessed) {
        super(log, debug, directory, directoryDLQ, tentativi, msAttesaProcessingFile, maxFileProcessed);
        this.diagnosticoAppender = diagnosticoAppender;
    }

    @Override
    public long process(Connection connection) {
        this.log.info("Recovery Diagnostici ...");
        long l = super.process(connection);
        this.log.info("Recovery Diagnostici completato");
        return l;
    }

    @Override
    public void insertObject(File file, Connection connection) throws UtilsException, UtilsMultiException {
        JaxbDeserializer deserializer = new JaxbDeserializer();
        ArrayList<MessaggioDiagnostico> msgDiagnostici = new ArrayList<MessaggioDiagnostico>();
        try {
            ElencoMessaggiDiagnostici elencoDiagnostici = deserializer.readElencoMessaggiDiagnostici(file);
            if (elencoDiagnostici != null && elencoDiagnostici.sizeMessaggioDiagnosticoList() > 0) {
                for (MessaggioDiagnostico diagnostico : elencoDiagnostici.getMessaggioDiagnosticoList()) {
                    msgDiagnostici.add(diagnostico);
                }
            }
        }
        catch (Exception t) {
            try {
                MessaggioDiagnostico diagnostico = deserializer.readMessaggioDiagnostico(file);
                msgDiagnostici.add(diagnostico);
            }
            catch (Exception tInternal) {
                throw new UtilsMultiException(new Throwable[]{t, tInternal});
            }
        }
        if (!msgDiagnostici.isEmpty()) {
            for (MessaggioDiagnostico diagnostico : msgDiagnostici) {
                MsgDiagnostico msgDiagOp2 = new MsgDiagnostico(diagnostico);
                try {
                    this.diagnosticoAppender.log(connection, msgDiagOp2);
                }
                catch (Exception e) {
                    throw new UtilsException(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

