/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.fs_recovery;

import java.io.File;
import java.sql.Connection;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.transazioni.dao.IServiceManager;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.monitor.engine.fs_recovery.FSRecoveryDiagnosticiImpl;
import org.openspcoop2.monitor.engine.fs_recovery.FSRecoveryDumpImpl;
import org.openspcoop2.monitor.engine.fs_recovery.FSRecoveryObjectType;
import org.openspcoop2.monitor.engine.fs_recovery.FSRecoveryTracceImpl;
import org.openspcoop2.monitor.engine.fs_recovery.FSRecoveryTransazioniApplicativoServerConsegnaTerminataImpl;
import org.openspcoop2.monitor.engine.fs_recovery.FSRecoveryTransazioniApplicativoServerImpl;
import org.openspcoop2.monitor.engine.fs_recovery.FSRecoveryTransazioniImpl;
import org.openspcoop2.protocol.sdk.diagnostica.IDiagnosticProducer;
import org.openspcoop2.protocol.sdk.dump.IDumpProducer;
import org.openspcoop2.protocol.sdk.tracciamento.ITracciaProducer;
import org.slf4j.Logger;

public class FSRecoveryTransazioni {
    private FSRecoveryTransazioniImpl transazioniImpl;
    private FSRecoveryTransazioniApplicativoServerImpl transazioniApplicativoServerImpl;
    private FSRecoveryTransazioniApplicativoServerConsegnaTerminataImpl transazioniApplicativoServerConsegnaTerminataImpl;
    private FSRecoveryTracceImpl tracceImpl;
    private FSRecoveryDiagnosticiImpl diagnosticiImpl;
    private FSRecoveryDumpImpl dumpImpl;

    public FSRecoveryTransazioni(Logger log, boolean debug, DAOFactory daoFactory, Logger daoFactoryLogger, ServiceManagerProperties daoFactoryServiceManagerProperties, long gestioneSerializableDBAttesaAttiva, int gestioneSerializableDBCheckInterval, IServiceManager transazioniSM, ITracciaProducer tracciamentoAppender, IDiagnosticProducer diagnosticoAppender, IDumpProducer dumpAppender, boolean transazioniRegistrazioneDumpHeadersCompactEnabled, File directoryDiagnostici, File directoryDiagnosticiDLQ, File directoryTracce, File directoryTracceDLQ, File directoryDump, File directoryDumpDLQ, File directoryTransazioniApplicativoServer, File directoryTransazioniApplicativoServerDLQ, File directoryTransazioniApplicativoServerConsegnaTerminata, File directoryTransazioniApplicativoServerConsegnaTerminataDLQ, File directoryTransazioni, File directoryTransazioniDLQ, int tentativi, long msAttesaProcessingFile, long maxFileProcessed) {
        this.transazioniImpl = new FSRecoveryTransazioniImpl(log, debug, transazioniSM, directoryTransazioni, directoryTransazioniDLQ, tentativi, msAttesaProcessingFile, maxFileProcessed);
        this.transazioniApplicativoServerImpl = new FSRecoveryTransazioniApplicativoServerImpl(log, debug, daoFactory, daoFactoryLogger, daoFactoryServiceManagerProperties, gestioneSerializableDBAttesaAttiva, gestioneSerializableDBCheckInterval, transazioniSM, directoryTransazioniApplicativoServer, directoryTransazioniApplicativoServerDLQ, tentativi, msAttesaProcessingFile, maxFileProcessed);
        this.transazioniApplicativoServerConsegnaTerminataImpl = new FSRecoveryTransazioniApplicativoServerConsegnaTerminataImpl(log, debug, daoFactory, daoFactoryLogger, daoFactoryServiceManagerProperties, gestioneSerializableDBAttesaAttiva, gestioneSerializableDBCheckInterval, transazioniSM, directoryTransazioniApplicativoServerConsegnaTerminata, directoryTransazioniApplicativoServerConsegnaTerminataDLQ, tentativi, msAttesaProcessingFile, maxFileProcessed);
        this.tracceImpl = new FSRecoveryTracceImpl(log, debug, tracciamentoAppender, directoryTracce, directoryTracceDLQ, tentativi, msAttesaProcessingFile, maxFileProcessed);
        this.dumpImpl = new FSRecoveryDumpImpl(log, debug, dumpAppender, directoryDump, directoryDumpDLQ, tentativi, msAttesaProcessingFile, maxFileProcessed);
        this.dumpImpl.setTransazioniRegistrazioneDumpHeadersCompactEnabled(transazioniRegistrazioneDumpHeadersCompactEnabled);
        this.diagnosticiImpl = new FSRecoveryDiagnosticiImpl(log, debug, diagnosticoAppender, directoryDiagnostici, directoryDiagnosticiDLQ, tentativi, msAttesaProcessingFile, maxFileProcessed);
    }

    public long process(FSRecoveryObjectType objectType, Connection connection) {
        long lInternal;
        boolean all = false;
        if (objectType == null || FSRecoveryObjectType.TRANSAZIONI_GESTIONE_COMPLETA.equals((Object)objectType)) {
            all = true;
        }
        long l = 0L;
        if (all || FSRecoveryObjectType.TRANSAZIONI.equals((Object)objectType)) {
            lInternal = this.processTransazioni(connection);
            if (lInternal < 0L) {
                return lInternal;
            }
            l += lInternal;
        }
        if (all || FSRecoveryObjectType.TRANSAZIONI_SERVER.equals((Object)objectType)) {
            lInternal = this.processTransazioniApplicativoServer(connection);
            if (lInternal < 0L) {
                return lInternal;
            }
            l += lInternal;
        }
        if (all || FSRecoveryObjectType.TRANSAZIONI_SERVER_CONSEGNA_TERMINATA.equals((Object)objectType)) {
            lInternal = this.processTransazioniApplicativoServerConsegnaTerminata(connection);
            if (lInternal < 0L) {
                return lInternal;
            }
            l += lInternal;
        }
        if (all || FSRecoveryObjectType.TRANSAZIONI_TRACCE.equals((Object)objectType)) {
            lInternal = this.processTracce(connection);
            if (lInternal < 0L) {
                return lInternal;
            }
            l += lInternal;
        }
        if (all || FSRecoveryObjectType.TRANSAZIONI_DIAGNOSTICI.equals((Object)objectType)) {
            lInternal = this.processDiagnostici(connection);
            if (lInternal < 0L) {
                return lInternal;
            }
            l += lInternal;
        }
        if (all || FSRecoveryObjectType.TRANSAZIONI_DUMP.equals((Object)objectType)) {
            lInternal = this.processDump(connection);
            if (lInternal < 0L) {
                return lInternal;
            }
            l += lInternal;
        }
        return l;
    }

    private long processTransazioni(Connection connection) {
        return this.transazioniImpl.process(connection);
    }

    private long processTransazioniApplicativoServer(Connection connection) {
        return this.transazioniApplicativoServerImpl.process(connection);
    }

    private long processTransazioniApplicativoServerConsegnaTerminata(Connection connection) {
        return this.transazioniApplicativoServerConsegnaTerminataImpl.process(connection);
    }

    private long processTracce(Connection connection) {
        return this.tracceImpl.process(connection);
    }

    private long processDiagnostici(Connection connection) {
        return this.diagnosticiImpl.process(connection);
    }

    private long processDump(Connection connection) {
        return this.dumpImpl.process(connection);
    }
}

