/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.fs_recovery;

import java.io.File;
import java.sql.Connection;
import java.util.List;
import org.openspcoop2.core.transazioni.Transazione;
import org.openspcoop2.core.transazioni.dao.IServiceManager;
import org.openspcoop2.core.transazioni.utils.serializer.JaxbDeserializer;
import org.openspcoop2.generic_project.expression.IPaginatedExpression;
import org.openspcoop2.monitor.engine.condition.EsitoUtils;
import org.openspcoop2.monitor.engine.fs_recovery.AbstractFSRecovery;
import org.openspcoop2.monitor.engine.fs_recovery.FSRecoveryFileUtils;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.UtilsMultiException;
import org.slf4j.Logger;

public class FSRecoveryTransazioniImpl
extends AbstractFSRecovery {
    private IServiceManager transazioniSM;
    private static boolean enrichEventi = false;

    public FSRecoveryTransazioniImpl(Logger log, boolean debug, IServiceManager transazioniSM, File directory, File directoryDLQ, int tentativi, long msAttesaProcessingFile, long maxFileProcessed) {
        super(log, debug, directory, directoryDLQ, tentativi, msAttesaProcessingFile, maxFileProcessed);
        this.transazioniSM = transazioniSM;
    }

    @Override
    public long process(Connection connection) {
        this.log.info("Recovery Transazioni ...");
        long l = super.process(connection);
        this.log.info("Recovery Transazioni completato");
        return l;
    }

    public static boolean isEnrichEventi() {
        return enrichEventi;
    }

    public static void setEnrichEventi(boolean enrichEventi) {
        FSRecoveryTransazioniImpl.enrichEventi = enrichEventi;
    }

    @Override
    public void insertObject(File file, Connection connection) throws UtilsException, UtilsMultiException {
        JaxbDeserializer deserializer = new JaxbDeserializer();
        Transazione transazione = null;
        try {
            transazione = deserializer.readTransazione(file);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
        if (enrichEventi) {
            if (transazione.getEventiGestione() == null || "".equals(transazione.getEventiGestione())) {
                transazione.setEventiGestione("RecoveredFileSystem");
            } else {
                transazione.setEventiGestione(transazione.getEventiGestione() + ",RecoveredFileSystem");
            }
        }
        try {
            String id = (String)this.transazioniSM.getTransazioneService().convertToId((Object)transazione);
            if (this.transazioniSM.getTransazioneService().exists((Object)id)) {
                Object o;
                IPaginatedExpression expr = this.transazioniSM.getTransazioneServiceSearch().newPaginatedExpression();
                expr.limit(1);
                expr.equals(Transazione.model().ID_TRANSAZIONE, (Object)id);
                List list = this.transazioniSM.getTransazioneServiceSearch().select(expr, Transazione.model().ESITO_CONTESTO);
                boolean update = false;
                String contesto = null;
                if (list != null && !list.isEmpty() && (o = list.get(0)) instanceof String && EsitoUtils.isFaseIntermedia(contesto = (String)o)) {
                    update = true;
                }
                if (update) {
                    this.transazioniSM.getTransazioneService().update((Object)id, (Object)transazione);
                    if (this.debug) {
                        this.logDebug("File [" + file.getName() + "] gestito tramite un aggiornamento, precedente stato: " + contesto);
                    }
                } else {
                    String newFileName = FSRecoveryFileUtils.renameToDLQ(this.directoryDLQ, file, "Transazione con id [" + id + "] gia' presente nel database.", this.log);
                    if (this.debug) {
                        this.logWarn("File [" + file.getName() + "] rinominato in [" + newFileName + "]");
                    }
                }
            } else {
                this.transazioniSM.getTransazioneService().create((Object)transazione);
            }
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
    }
}

