/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.config;

import java.util.HashMap;
import java.util.List;
import org.openspcoop2.pdd.config.ConfigurazioneNodiRuntime;
import org.openspcoop2.pdd.config.ConfigurazioneNodiRuntimeBYOKRemoteConfig;
import org.openspcoop2.pdd.core.byok.BYOKMapProperties;
import org.openspcoop2.pdd.core.dynamic.DynamicInfo;
import org.openspcoop2.pdd.core.dynamic.DynamicUtils;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.threads.BaseThread;
import org.slf4j.Logger;

public class ConfigurazioneNodiRuntimeInit
extends BaseThread {
    protected Logger log;
    protected ConfigurazioneNodiRuntime configurazioneNodiRuntime = null;
    private boolean reInitSecretMaps = false;
    private String secretsConfig;
    private boolean secretsConfigRequired;
    private boolean first = true;

    public ConfigurazioneNodiRuntimeInit(Logger log, ConfigurazioneNodiRuntime configurazioneNodiRuntime, boolean reInitSecretMaps, String secretsConfig, boolean secretsConfigRequired) {
        this.log = log;
        this.configurazioneNodiRuntime = configurazioneNodiRuntime;
        this.reInitSecretMaps = reInitSecretMaps;
        this.secretsConfig = secretsConfig;
        this.secretsConfigRequired = secretsConfigRequired;
    }

    protected void process() {
        boolean finish = false;
        while (!finish) {
            String msg;
            try {
                finish = this.analyze();
            }
            catch (Exception e) {
                String msgErrore = "Errore durante l'inizializzazione della configurazione (" + this.getDescrizione() + "): " + e.getMessage();
                this.log.error(msgErrore, (Throwable)e);
            }
            if (!finish) {
                msg = "Non \u00e8 stato possibile ottenere informazioni sulla configurazione (" + this.getDescrizione() + ") da nessun nodo runtime (prossimo controllo tra 30 secondi)";
                if (this.first) {
                    this.log.debug(msg);
                    this.first = false;
                } else {
                    this.log.error(msg);
                }
                Utilities.sleep((long)30000L);
                continue;
            }
            msg = "Configurazione (" + this.getDescrizione() + ") completata con successo";
            this.log.info(msg);
        }
        this.setStop(true);
    }

    protected String getDescrizione() {
        return "secrets";
    }

    private boolean analyze() {
        List<String> aliases;
        boolean finish = false;
        List<String> list = aliases = this.configurazioneNodiRuntime != null ? this.configurazioneNodiRuntime.getAliases() : null;
        if (aliases != null && !aliases.isEmpty()) {
            finish = this.finish(aliases);
        }
        return finish;
    }

    private boolean finish(List<String> aliases) {
        boolean finish = false;
        for (String alias : aliases) {
            boolean continueCheck = true;
            ConfigurazioneNodiRuntimeBYOKRemoteConfig remoteConfig = new ConfigurazioneNodiRuntimeBYOKRemoteConfig();
            if (!this.configurazioneNodiRuntime.isActiveNode(this.log, alias, remoteConfig)) {
                continueCheck = false;
            }
            if (continueCheck && this.reInitSecretMaps && !this.reInitSecretMaps(this.configurazioneNodiRuntime, remoteConfig)) {
                continueCheck = false;
            }
            if (!continueCheck || !this.isCompleted(alias)) continue;
            finish = true;
            break;
        }
        return finish;
    }

    protected boolean isCompleted(String alias) {
        if (alias != null) {
            // empty if block
        }
        return true;
    }

    private boolean reInitSecretMaps(ConfigurazioneNodiRuntime configurazioneNodiRuntime, ConfigurazioneNodiRuntimeBYOKRemoteConfig remoteConfig) {
        try {
            HashMap<String, Object> dynamicMap = new HashMap<String, Object>();
            DynamicInfo dynamicInfo = new DynamicInfo();
            DynamicUtils.fillDynamicMap(this.log, dynamicMap, dynamicInfo);
            configurazioneNodiRuntime.initBYOKDynamicMapRemoteGovWayNode(this.log, dynamicMap, false, true, remoteConfig);
            BYOKMapProperties.initialize(this.log, this.secretsConfig, this.secretsConfigRequired, true, dynamicMap, true);
            BYOKMapProperties secretsProperties = BYOKMapProperties.getInstance();
            secretsProperties.initEnvironment();
            String msgInit = "Environment re-inizializzato con i secrets definiti nel file '" + this.secretsConfig + "'\n\tJavaProperties: " + secretsProperties.getJavaMap().keys() + "\n\tEnvProperties: " + secretsProperties.getEnvMap().keys() + "\n\tObfuscateMode: " + secretsProperties.getObfuscateModeDescription();
            this.log.info(msgInit);
            return true;
        }
        catch (Exception e) {
            this.log.debug(e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

