/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.config;

import java.io.Serializable;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDGenericProperties;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.GruppoAccordo;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.pdd.config.ForwardProxyConfigurazione;
import org.openspcoop2.pdd.config.ForwardProxyConfigurazioneToken;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.state.RequestInfo;

public class ForwardProxy
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GOVWAY_SEPARATORE = "-";
    public static final String GOVWAY_PREFISSO_TAG_PROXY = "tag-";
    public static final String GOVWAY_PREFISSO_DOMINIO_PROXY = "dominio-";
    public static final String GOVWAY_PREFISSO_PROTOCOLLO_PROXY = "profilo-";
    public static final String GOVWAY_PROXY_ENABLED = "govway-proxy-enable";
    public static final String GOVWAY_PROXY = "govway-proxy";
    public static final String GOVWAY_FRUIZIONI_PROXY = "govway-fruizioni-proxy";
    public static final String GOVWAY_EROGAZIONI_PROXY = "govway-erogazioni-proxy";
    public static final String GOVWAY_PROXY_HEADER = "govway-proxy-header";
    public static final String GOVWAY_FRUIZIONI_PROXY_HEADER = "govway-fruizioni-proxy-header";
    public static final String GOVWAY_EROGAZIONI_PROXY_HEADER = "govway-erogazioni-proxy-header";
    public static final String GOVWAY_PROXY_HEADER_BASE64 = "govway-proxy-header-base64";
    public static final String GOVWAY_FRUIZIONI_PROXY_HEADER_BASE64 = "govway-fruizioni-proxy-header-base64";
    public static final String GOVWAY_EROGAZIONI_PROXY_HEADER_BASE64 = "govway-erogazioni-proxy-header-base64";
    public static final String GOVWAY_PROXY_QUERY = "govway-proxy-query";
    public static final String GOVWAY_FRUIZIONI_PROXY_QUERY = "govway-fruizioni-proxy-query";
    public static final String GOVWAY_EROGAZIONI_PROXY_QUERY = "govway-erogazioni-proxy-query";
    public static final String GOVWAY_PROXY_QUERY_BASE64 = "govway-proxy-query-base64";
    public static final String GOVWAY_FRUIZIONI_PROXY_QUERY_BASE64 = "govway-fruizioni-proxy-query-base64";
    public static final String GOVWAY_EROGAZIONI_PROXY_QUERY_BASE64 = "govway-erogazioni-proxy-query-base64";
    public static final String DEFAULT_GOVWAY_PROXY_HEADER = "GovWay-APIAddress";
    public static final boolean DEFAULT_GOVWAY_PROXY_HEADER_BASE64 = false;
    public static final String DEFAULT_GOVWAY_PROXY_QUERY = "govway_api_address";
    public static final boolean DEFAULT_GOVWAY_PROXY_QUERY_BASE64 = false;
    public static final String GOVWAY_PROXY_TOKEN_DYNAMIC_DISCOVERY = "govway-proxy-token-dynamic-discovery";
    public static final String GOVWAY_FRUIZIONI_PROXY_TOKEN_DYNAMIC_DISCOVERY = "govway-fruizioni-proxy-token-dynamic-discovery";
    public static final String GOVWAY_EROGAZIONI_PROXY_TOKEN_DYNAMIC_DISCOVERY = "govway-erogazioni-proxy-token-dynamic-discovery";
    public static final String GOVWAY_PROXY_TOKEN_VALIDAZIONE_JWT = "govway-proxy-token-jwt-validation";
    public static final String GOVWAY_FRUIZIONI_PROXY_TOKEN_VALIDAZIONE_JWT = "govway-fruizioni-proxy-token-jwt-validation";
    public static final String GOVWAY_EROGAZIONI_PROXY_TOKEN_VALIDAZIONE_JWT = "govway-erogazioni-proxy-token-jwt-validation";
    public static final String GOVWAY_PROXY_TOKEN_INTROSPECTION = "govway-proxy-token-introspection";
    public static final String GOVWAY_FRUIZIONI_PROXY_TOKEN_INTROSPECTION = "govway-fruizioni-proxy-token-introspection";
    public static final String GOVWAY_EROGAZIONI_PROXY_TOKEN_INTROSPECTION = "govway-erogazioni-proxy-token-introspection";
    public static final String GOVWAY_PROXY_TOKEN_USERINFO = "govway-proxy-token-userinfo";
    public static final String GOVWAY_FRUIZIONI_PROXY_TOKEN_USERINFO = "govway-fruizioni-proxy-token-userinfo";
    public static final String GOVWAY_EROGAZIONI_PROXY_TOKEN_USERINFO = "govway-erogazioni-proxy-token-userinfo";
    public static final String GOVWAY_PROXY_TOKEN_RETRIEVE = "govway-proxy-token-retrieve";
    public static final String GOVWAY_FRUIZIONI_PROXY_TOKEN_RETRIEVE = "govway-fruizioni-proxy-token-retrieve";
    public static final String GOVWAY_EROGAZIONI_PROXY_TOKEN_RETRIEVE = "govway-erogazioni-proxy-token-retrieve";
    public static final String GOVWAY_PROXY_ATTRIBUTE_AUTHORITY = "govway-proxy-attribute-authority";
    public static final String GOVWAY_FRUIZIONI_PROXY_ATTRIBUTE_AUTHORITY = "govway-fruizioni-proxy-attribute-authority";
    public static final String GOVWAY_EROGAZIONI_PROXY_ATTRIBUTE_AUTHORITY = "govway-erogazioni-proxy-attribute-authority";
    public static final String GOVWAY_PROXY_ATTRIBUTE_AUTHORITY_RESPONSE_JWT_VALIDATION = "govway-proxy-attribute-authority-response-jwt-validation";
    public static final String GOVWAY_FRUIZIONI_PROXY_ATTRIBUTE_AUTHORITY_RESPONSE_JWT_VALIDATION = "govway-fruizioni-proxy-attribute-authority-response-jwt-validation";
    public static final String GOVWAY_EROGAZIONI_PROXY_ATTRIBUTE_AUTHORITY_RESPONSE_JWT_VALIDATION = "govway-erogazioni-proxy-attribute-authority-response-jwt-validation";
    public static final boolean DEFAULT_GOVWAY_PROXY_TOKEN_DYNAMIC_DISCOVERY = false;
    public static final boolean DEFAULT_GOVWAY_PROXY_TOKEN_VALIDAZIONE_JWT = false;
    public static final boolean DEFAULT_GOVWAY_PROXY_TOKEN_INTROSPECTION = false;
    public static final boolean DEFAULT_GOVWAY_PROXY_TOKEN_USERINFO = false;
    public static final boolean DEFAULT_GOVWAY_PROXY_TOKEN_RETRIEVE = false;
    public static final boolean DEFAULT_GOVWAY_PROXY_ATTRIBUTE_AUTHORITY = false;
    public static final boolean DEFAULT_GOVWAY_PROXY_ATTRIBUTE_AUTHORITY_RESPONSE_JWT_VALIDATION = false;
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private boolean enabled = false;
    private String url;
    private ForwardProxyConfigurazione config;
    private ForwardProxyConfigurazioneToken configToken;

    public static boolean isProxyEnabled() {
        String enable = System.getProperty(GOVWAY_PROXY_ENABLED);
        if (enable != null && !"".equals(enable)) {
            return TRUE.equalsIgnoreCase(enable);
        }
        return OpenSPCoop2Properties.getInstance().isForwardProxyEnable();
    }

    public static ForwardProxy getProxyConfigurazione(boolean fruizione, IDSoggetto dominio, IDServizio idServizio, IDGenericProperties policy, RequestInfo requestInfo) throws DriverConfigurazioneException {
        try {
            ForwardProxy regola;
            ForwardProxyConfigurazione defaultConfig = ForwardProxy.readForwardProxyConfigurazione(true, dominio.getTipo(), fruizione);
            if (defaultConfig == null) {
                defaultConfig = ForwardProxy.readForwardProxyConfigurazione(true, dominio.getTipo(), null);
            }
            if (defaultConfig == null) {
                defaultConfig = ForwardProxy.readForwardProxyConfigurazione(false, null, fruizione);
            }
            if (defaultConfig == null) {
                defaultConfig = ForwardProxy.readForwardProxyConfigurazione(false, null, null);
            }
            if (defaultConfig == null) {
                defaultConfig = OpenSPCoop2Properties.getInstance().getForwardProxyConfigurazioneDefault();
            }
            ForwardProxyConfigurazioneToken defaultConfigToken = null;
            if (policy != null && policy.getNome() != null) {
                defaultConfigToken = ForwardProxy.readForwardProxyConfigurazioneToken(true, dominio.getTipo(), fruizione, policy);
                if (defaultConfigToken == null) {
                    defaultConfigToken = ForwardProxy.readForwardProxyConfigurazioneToken(true, dominio.getTipo(), null, policy);
                }
                if (defaultConfigToken == null) {
                    defaultConfigToken = ForwardProxy.readForwardProxyConfigurazioneToken(false, null, fruizione, policy);
                }
                if (defaultConfigToken == null) {
                    defaultConfigToken = ForwardProxy.readForwardProxyConfigurazioneToken(false, null, null, policy);
                }
            }
            if (defaultConfigToken == null) {
                defaultConfigToken = ForwardProxy.readForwardProxyConfigurazioneToken(true, dominio.getTipo(), fruizione, null);
            }
            if (defaultConfigToken == null) {
                defaultConfigToken = ForwardProxy.readForwardProxyConfigurazioneToken(true, dominio.getTipo(), null, null);
            }
            if (defaultConfigToken == null) {
                defaultConfigToken = ForwardProxy.readForwardProxyConfigurazioneToken(false, null, fruizione, null);
            }
            if (defaultConfigToken == null) {
                defaultConfigToken = ForwardProxy.readForwardProxyConfigurazioneToken(false, null, null, null);
            }
            if (defaultConfigToken == null) {
                defaultConfigToken = OpenSPCoop2Properties.getInstance().getForwardProxyConfigurazioneTokenDefault();
            }
            RegistroServiziManager registroServiziManager = RegistroServiziManager.getInstance();
            AccordoServizioParteSpecifica asps = registroServiziManager.getAccordoServizioParteSpecifica(idServizio, null, Boolean.valueOf(false), requestInfo);
            IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(asps.getAccordoServizioParteComune());
            AccordoServizioParteComune aspc = registroServiziManager.getAccordoServizioParteComune(idAccordo, null, Boolean.valueOf(false), Boolean.valueOf(false), requestInfo);
            if (aspc.getGruppi() != null && aspc.getGruppi().sizeGruppoList() > 0) {
                for (GruppoAccordo gruppo : aspc.getGruppi().getGruppoList()) {
                    ForwardProxy regola2 = ForwardProxy.readForwardProxyTag(gruppo.getNome(), fruizione, policy, defaultConfig, defaultConfigToken);
                    if (regola2 != null && regola2.isEnabled()) {
                        return regola2;
                    }
                    regola2 = ForwardProxy.readForwardProxyTag(gruppo.getNome(), null, policy, defaultConfig, defaultConfigToken);
                    if (regola2 == null || !regola2.isEnabled()) continue;
                    return regola2;
                }
            }
            if ((regola = ForwardProxy.readConfigurazioneDominioByTipo(dominio.getTipo(), dominio.getNome(), fruizione, policy, defaultConfig, defaultConfigToken)) != null && regola.isEnabled()) {
                return regola;
            }
            regola = ForwardProxy.readConfigurazioneDominioByTipo(dominio.getTipo(), dominio.getNome(), null, policy, defaultConfig, defaultConfigToken);
            if (regola != null && regola.isEnabled()) {
                return regola;
            }
            regola = ForwardProxy.readConfigurazioneDominioByProtocollo(dominio.getTipo(), dominio.getNome(), fruizione, policy, defaultConfig, defaultConfigToken);
            if (regola != null && regola.isEnabled()) {
                return regola;
            }
            regola = ForwardProxy.readConfigurazioneDominioByProtocollo(dominio.getTipo(), dominio.getNome(), null, policy, defaultConfig, defaultConfigToken);
            if (regola != null && regola.isEnabled()) {
                return regola;
            }
            regola = ForwardProxy.readConfigurazioneDominio(dominio.getNome(), fruizione, policy, defaultConfig, defaultConfigToken);
            if (regola != null && regola.isEnabled()) {
                return regola;
            }
            regola = ForwardProxy.readConfigurazioneDominio(dominio.getNome(), null, policy, defaultConfig, defaultConfigToken);
            if (regola != null && regola.isEnabled()) {
                return regola;
            }
            regola = ForwardProxy.readConfigurazioneProtocollo(dominio.getTipo(), fruizione, policy, defaultConfig, defaultConfigToken);
            if (regola != null && regola.isEnabled()) {
                return regola;
            }
            regola = ForwardProxy.readConfigurazioneProtocollo(dominio.getTipo(), null, policy, defaultConfig, defaultConfigToken);
            if (regola != null && regola.isEnabled()) {
                return regola;
            }
            regola = ForwardProxy.readConfigurazione(fruizione, policy, defaultConfig, defaultConfigToken);
            if (regola != null && regola.isEnabled()) {
                return regola;
            }
            return ForwardProxy.readConfigurazione(null, policy, defaultConfig, defaultConfigToken);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    private static ForwardProxyConfigurazione readForwardProxyConfigurazione(boolean byProtocollo, String tipoSoggetto, Boolean fruizione) throws ProtocolException {
        String base64;
        Object systemPropertyProxyHeader = GOVWAY_PROXY_HEADER;
        Object systemPropertyProxyHeaderBase64 = GOVWAY_PROXY_HEADER_BASE64;
        Object systemPropertyProxyQuery = GOVWAY_PROXY_QUERY;
        Object systemPropertyProxyQueryBase64 = GOVWAY_PROXY_QUERY_BASE64;
        if (fruizione != null) {
            systemPropertyProxyHeader = fruizione != false ? GOVWAY_FRUIZIONI_PROXY_HEADER : GOVWAY_EROGAZIONI_PROXY_HEADER;
            systemPropertyProxyHeaderBase64 = fruizione != false ? GOVWAY_FRUIZIONI_PROXY_HEADER_BASE64 : GOVWAY_EROGAZIONI_PROXY_HEADER_BASE64;
            systemPropertyProxyQuery = fruizione != false ? GOVWAY_FRUIZIONI_PROXY_QUERY : GOVWAY_EROGAZIONI_PROXY_QUERY;
            Object object = systemPropertyProxyQueryBase64 = fruizione != false ? GOVWAY_FRUIZIONI_PROXY_QUERY_BASE64 : GOVWAY_EROGAZIONI_PROXY_QUERY_BASE64;
        }
        if (byProtocollo) {
            String protocollo = ProtocolFactoryManager.getInstance().getProtocolByOrganizationType(tipoSoggetto);
            systemPropertyProxyHeader = GOVWAY_PREFISSO_PROTOCOLLO_PROXY + protocollo + GOVWAY_SEPARATORE + (String)systemPropertyProxyHeader;
            systemPropertyProxyHeaderBase64 = GOVWAY_PREFISSO_PROTOCOLLO_PROXY + protocollo + GOVWAY_SEPARATORE + (String)systemPropertyProxyHeaderBase64;
            systemPropertyProxyQuery = GOVWAY_PREFISSO_PROTOCOLLO_PROXY + protocollo + GOVWAY_SEPARATORE + (String)systemPropertyProxyQuery;
            systemPropertyProxyQueryBase64 = GOVWAY_PREFISSO_PROTOCOLLO_PROXY + protocollo + GOVWAY_SEPARATORE + (String)systemPropertyProxyQueryBase64;
        }
        String header = System.getProperty((String)systemPropertyProxyHeader);
        String query = System.getProperty((String)systemPropertyProxyQuery);
        if ((header == null || "".equals(header)) && (query == null || "".equals(query))) {
            return null;
        }
        ForwardProxyConfigurazione config = new ForwardProxyConfigurazione();
        if (header != null && !"".equals(header)) {
            config.setHeader(header);
            base64 = System.getProperty((String)systemPropertyProxyHeaderBase64);
            if (base64 != null && !"".equals(base64)) {
                if (TRUE.equalsIgnoreCase(base64)) {
                    config.setHeaderBase64(true);
                } else if (FALSE.equalsIgnoreCase(base64)) {
                    config.setHeaderBase64(false);
                } else {
                    config.setHeaderBase64(false);
                }
            } else {
                config.setHeaderBase64(false);
            }
        }
        if (query != null && !"".equals(query)) {
            config.setQuery(query);
            base64 = System.getProperty((String)systemPropertyProxyQueryBase64);
            if (base64 != null && !"".equals(base64)) {
                if (TRUE.equalsIgnoreCase(base64)) {
                    config.setQueryBase64(true);
                } else if (FALSE.equalsIgnoreCase(base64)) {
                    config.setQueryBase64(false);
                } else {
                    config.setQueryBase64(false);
                }
            } else {
                config.setQueryBase64(false);
            }
        }
        return config;
    }

    private static ForwardProxyConfigurazioneToken readForwardProxyConfigurazioneToken(boolean byProtocollo, String tipoSoggetto, Boolean fruizione, IDGenericProperties policy) throws ProtocolException {
        Object systemPropertyProxyTokenDynamicDiscovery = GOVWAY_PROXY_TOKEN_DYNAMIC_DISCOVERY;
        Object systemPropertyProxyTokenValidazioneJwt = GOVWAY_PROXY_TOKEN_VALIDAZIONE_JWT;
        Object systemPropertyProxyTokenIntrospection = GOVWAY_PROXY_TOKEN_INTROSPECTION;
        Object systemPropertyProxyTokenUserInfo = GOVWAY_PROXY_TOKEN_USERINFO;
        Object systemPropertyProxyTokenRetrieve = GOVWAY_PROXY_TOKEN_RETRIEVE;
        Object systemPropertyProxyAttributeAuthority = GOVWAY_PROXY_ATTRIBUTE_AUTHORITY;
        Object systemPropertyProxyAttributeAuthorityResponseJwtValidation = GOVWAY_PROXY_ATTRIBUTE_AUTHORITY_RESPONSE_JWT_VALIDATION;
        if (fruizione != null) {
            systemPropertyProxyTokenDynamicDiscovery = fruizione != false ? GOVWAY_FRUIZIONI_PROXY_TOKEN_DYNAMIC_DISCOVERY : GOVWAY_EROGAZIONI_PROXY_TOKEN_DYNAMIC_DISCOVERY;
            systemPropertyProxyTokenValidazioneJwt = fruizione != false ? GOVWAY_FRUIZIONI_PROXY_TOKEN_VALIDAZIONE_JWT : GOVWAY_EROGAZIONI_PROXY_TOKEN_VALIDAZIONE_JWT;
            systemPropertyProxyTokenIntrospection = fruizione != false ? GOVWAY_FRUIZIONI_PROXY_TOKEN_INTROSPECTION : GOVWAY_EROGAZIONI_PROXY_TOKEN_INTROSPECTION;
            systemPropertyProxyTokenUserInfo = fruizione != false ? GOVWAY_FRUIZIONI_PROXY_TOKEN_USERINFO : GOVWAY_EROGAZIONI_PROXY_TOKEN_USERINFO;
            systemPropertyProxyTokenRetrieve = fruizione != false ? GOVWAY_FRUIZIONI_PROXY_TOKEN_RETRIEVE : GOVWAY_EROGAZIONI_PROXY_TOKEN_RETRIEVE;
            systemPropertyProxyAttributeAuthority = fruizione != false ? GOVWAY_FRUIZIONI_PROXY_ATTRIBUTE_AUTHORITY : GOVWAY_EROGAZIONI_PROXY_ATTRIBUTE_AUTHORITY;
            Object object = systemPropertyProxyAttributeAuthorityResponseJwtValidation = fruizione != false ? GOVWAY_FRUIZIONI_PROXY_ATTRIBUTE_AUTHORITY_RESPONSE_JWT_VALIDATION : GOVWAY_EROGAZIONI_PROXY_ATTRIBUTE_AUTHORITY_RESPONSE_JWT_VALIDATION;
        }
        if (byProtocollo) {
            String protocollo = ProtocolFactoryManager.getInstance().getProtocolByOrganizationType(tipoSoggetto);
            systemPropertyProxyTokenDynamicDiscovery = GOVWAY_PREFISSO_PROTOCOLLO_PROXY + protocollo + GOVWAY_SEPARATORE + (String)systemPropertyProxyTokenDynamicDiscovery;
            systemPropertyProxyTokenValidazioneJwt = GOVWAY_PREFISSO_PROTOCOLLO_PROXY + protocollo + GOVWAY_SEPARATORE + (String)systemPropertyProxyTokenValidazioneJwt;
            systemPropertyProxyTokenIntrospection = GOVWAY_PREFISSO_PROTOCOLLO_PROXY + protocollo + GOVWAY_SEPARATORE + (String)systemPropertyProxyTokenIntrospection;
            systemPropertyProxyTokenUserInfo = GOVWAY_PREFISSO_PROTOCOLLO_PROXY + protocollo + GOVWAY_SEPARATORE + (String)systemPropertyProxyTokenUserInfo;
            systemPropertyProxyTokenRetrieve = GOVWAY_PREFISSO_PROTOCOLLO_PROXY + protocollo + GOVWAY_SEPARATORE + (String)systemPropertyProxyTokenRetrieve;
            systemPropertyProxyAttributeAuthority = GOVWAY_PREFISSO_PROTOCOLLO_PROXY + protocollo + GOVWAY_SEPARATORE + (String)systemPropertyProxyAttributeAuthority;
            systemPropertyProxyAttributeAuthorityResponseJwtValidation = GOVWAY_PREFISSO_PROTOCOLLO_PROXY + protocollo + GOVWAY_SEPARATORE + (String)systemPropertyProxyAttributeAuthorityResponseJwtValidation;
        }
        if (policy != null && policy.getNome() != null) {
            systemPropertyProxyTokenDynamicDiscovery = (String)systemPropertyProxyTokenDynamicDiscovery + GOVWAY_SEPARATORE + policy.getNome();
            systemPropertyProxyTokenValidazioneJwt = (String)systemPropertyProxyTokenValidazioneJwt + GOVWAY_SEPARATORE + policy.getNome();
            systemPropertyProxyTokenIntrospection = (String)systemPropertyProxyTokenIntrospection + GOVWAY_SEPARATORE + policy.getNome();
            systemPropertyProxyTokenUserInfo = (String)systemPropertyProxyTokenUserInfo + GOVWAY_SEPARATORE + policy.getNome();
            systemPropertyProxyTokenRetrieve = (String)systemPropertyProxyTokenRetrieve + GOVWAY_SEPARATORE + policy.getNome();
            systemPropertyProxyAttributeAuthority = (String)systemPropertyProxyAttributeAuthority + GOVWAY_SEPARATORE + policy.getNome();
            systemPropertyProxyAttributeAuthorityResponseJwtValidation = (String)systemPropertyProxyAttributeAuthorityResponseJwtValidation + GOVWAY_SEPARATORE + policy.getNome();
        }
        String dynamicDiscovery = System.getProperty((String)systemPropertyProxyTokenDynamicDiscovery);
        String validazioneJwt = System.getProperty((String)systemPropertyProxyTokenValidazioneJwt);
        String introspection = System.getProperty((String)systemPropertyProxyTokenIntrospection);
        String userInfo = System.getProperty((String)systemPropertyProxyTokenUserInfo);
        String retrieve = System.getProperty((String)systemPropertyProxyTokenRetrieve);
        String attributeAuthority = System.getProperty((String)systemPropertyProxyAttributeAuthority);
        String attributeAuthorityResponseJwtValidation = System.getProperty((String)systemPropertyProxyAttributeAuthorityResponseJwtValidation);
        if (!(dynamicDiscovery != null && !"".equals(dynamicDiscovery) || validazioneJwt != null && !"".equals(validazioneJwt) || introspection != null && !"".equals(introspection) || userInfo != null && !"".equals(userInfo) || retrieve != null && !"".equals(retrieve) || attributeAuthority != null && !"".equals(attributeAuthority) || attributeAuthorityResponseJwtValidation != null && !"".equals(attributeAuthorityResponseJwtValidation))) {
            return null;
        }
        ForwardProxyConfigurazioneToken config = new ForwardProxyConfigurazioneToken();
        config.tokenDynamicDiscoveryEnabled = dynamicDiscovery != null && !"".equals(dynamicDiscovery) ? (TRUE.equalsIgnoreCase(dynamicDiscovery) ? true : (FALSE.equalsIgnoreCase(dynamicDiscovery) ? false : false)) : false;
        config.tokenJwtValidationEnabled = validazioneJwt != null && !"".equals(validazioneJwt) ? (TRUE.equalsIgnoreCase(validazioneJwt) ? true : (FALSE.equalsIgnoreCase(validazioneJwt) ? false : false)) : false;
        config.tokenIntrospectionEnabled = introspection != null && !"".equals(introspection) ? (TRUE.equalsIgnoreCase(introspection) ? true : (FALSE.equalsIgnoreCase(introspection) ? false : false)) : false;
        config.tokenUserInfoEnabled = userInfo != null && !"".equals(userInfo) ? (TRUE.equalsIgnoreCase(userInfo) ? true : (FALSE.equalsIgnoreCase(userInfo) ? false : false)) : false;
        config.tokenRetrieveEnabled = retrieve != null && !"".equals(retrieve) ? (TRUE.equalsIgnoreCase(retrieve) ? true : (FALSE.equalsIgnoreCase(retrieve) ? false : false)) : false;
        config.attributeAuthorityEnabled = attributeAuthority != null && !"".equals(attributeAuthority) ? (TRUE.equalsIgnoreCase(attributeAuthority) ? true : (FALSE.equalsIgnoreCase(attributeAuthority) ? false : false)) : false;
        config.attributeAuthorityResponseJwtValidationEnabled = attributeAuthorityResponseJwtValidation != null && !"".equals(attributeAuthorityResponseJwtValidation) ? (TRUE.equalsIgnoreCase(attributeAuthorityResponseJwtValidation) ? true : (FALSE.equalsIgnoreCase(attributeAuthorityResponseJwtValidation) ? false : false)) : false;
        return config;
    }

    private static ForwardProxy readForwardProxyTag(String tag, Boolean fruizione, IDGenericProperties policy, ForwardProxyConfigurazione defaultConfig, ForwardProxyConfigurazioneToken defaultConfigToken) throws ProtocolException {
        return ForwardProxy.readForwardProxy(tag, false, null, null, fruizione, policy, defaultConfig, defaultConfigToken);
    }

    private static ForwardProxy readConfigurazioneDominioByTipo(String tipoSoggetto, String nomeSoggetto, Boolean fruizione, IDGenericProperties policy, ForwardProxyConfigurazione defaultConfig, ForwardProxyConfigurazioneToken defaultConfigToken) throws ProtocolException {
        return ForwardProxy.readForwardProxy(null, false, tipoSoggetto, nomeSoggetto, fruizione, policy, defaultConfig, defaultConfigToken);
    }

    private static ForwardProxy readConfigurazioneDominioByProtocollo(String tipoSoggetto, String nomeSoggetto, Boolean fruizione, IDGenericProperties policy, ForwardProxyConfigurazione defaultConfig, ForwardProxyConfigurazioneToken defaultConfigToken) throws ProtocolException {
        return ForwardProxy.readForwardProxy(null, true, tipoSoggetto, nomeSoggetto, fruizione, policy, defaultConfig, defaultConfigToken);
    }

    private static ForwardProxy readConfigurazioneDominio(String nomeSoggetto, Boolean fruizione, IDGenericProperties policy, ForwardProxyConfigurazione defaultConfig, ForwardProxyConfigurazioneToken defaultConfigToken) throws ProtocolException {
        return ForwardProxy.readForwardProxy(null, false, null, nomeSoggetto, fruizione, policy, defaultConfig, defaultConfigToken);
    }

    private static ForwardProxy readConfigurazioneProtocollo(String tipoSoggetto, Boolean fruizione, IDGenericProperties policy, ForwardProxyConfigurazione defaultConfig, ForwardProxyConfigurazioneToken defaultConfigToken) throws ProtocolException {
        return ForwardProxy.readForwardProxy(null, true, tipoSoggetto, null, fruizione, policy, defaultConfig, defaultConfigToken);
    }

    private static ForwardProxy readConfigurazione(Boolean fruizione, IDGenericProperties policy, ForwardProxyConfigurazione defaultConfig, ForwardProxyConfigurazioneToken defaultConfigToken) throws ProtocolException {
        return ForwardProxy.readForwardProxy(null, false, null, null, fruizione, policy, defaultConfig, defaultConfigToken);
    }

    private static ForwardProxy readForwardProxy(String tag, boolean byProtocollo, String tipoSoggetto, String nomeSoggetto, Boolean fruizione, IDGenericProperties policy, ForwardProxyConfigurazione defaultConfig, ForwardProxyConfigurazioneToken defaultConfigToken) throws ProtocolException {
        String protocollo;
        String protocollo2;
        Object systemPropertyProxy = GOVWAY_PROXY;
        Object systemPropertyProxyHeader = GOVWAY_PROXY_HEADER;
        Object systemPropertyProxyHeaderBase64 = GOVWAY_PROXY_HEADER_BASE64;
        Object systemPropertyProxyQuery = GOVWAY_PROXY_QUERY;
        Object systemPropertyProxyQueryBase64 = GOVWAY_PROXY_QUERY_BASE64;
        if (fruizione != null) {
            systemPropertyProxy = fruizione != false ? GOVWAY_FRUIZIONI_PROXY : GOVWAY_EROGAZIONI_PROXY;
            systemPropertyProxyHeader = fruizione != false ? GOVWAY_FRUIZIONI_PROXY_HEADER : GOVWAY_EROGAZIONI_PROXY_HEADER;
            systemPropertyProxyHeaderBase64 = fruizione != false ? GOVWAY_FRUIZIONI_PROXY_HEADER_BASE64 : GOVWAY_EROGAZIONI_PROXY_HEADER_BASE64;
            systemPropertyProxyQuery = fruizione != false ? GOVWAY_FRUIZIONI_PROXY_QUERY : GOVWAY_EROGAZIONI_PROXY_QUERY;
            Object object = systemPropertyProxyQueryBase64 = fruizione != false ? GOVWAY_FRUIZIONI_PROXY_QUERY_BASE64 : GOVWAY_EROGAZIONI_PROXY_QUERY_BASE64;
        }
        if (tag != null) {
            systemPropertyProxy = GOVWAY_PREFISSO_TAG_PROXY + tag + GOVWAY_SEPARATORE + (String)systemPropertyProxy;
            systemPropertyProxyHeader = GOVWAY_PREFISSO_TAG_PROXY + tag + GOVWAY_SEPARATORE + (String)systemPropertyProxyHeader;
            systemPropertyProxyHeaderBase64 = GOVWAY_PREFISSO_TAG_PROXY + tag + GOVWAY_SEPARATORE + (String)systemPropertyProxyHeaderBase64;
            systemPropertyProxyQuery = GOVWAY_PREFISSO_TAG_PROXY + tag + GOVWAY_SEPARATORE + (String)systemPropertyProxyQuery;
            systemPropertyProxyQueryBase64 = GOVWAY_PREFISSO_TAG_PROXY + tag + GOVWAY_SEPARATORE + (String)systemPropertyProxyQueryBase64;
        } else if (nomeSoggetto != null) {
            if (tipoSoggetto == null) {
                systemPropertyProxy = GOVWAY_PREFISSO_DOMINIO_PROXY + nomeSoggetto + GOVWAY_SEPARATORE + (String)systemPropertyProxy;
                systemPropertyProxyHeader = GOVWAY_PREFISSO_DOMINIO_PROXY + nomeSoggetto + GOVWAY_SEPARATORE + (String)systemPropertyProxyHeader;
                systemPropertyProxyHeaderBase64 = GOVWAY_PREFISSO_DOMINIO_PROXY + nomeSoggetto + GOVWAY_SEPARATORE + (String)systemPropertyProxyHeaderBase64;
                systemPropertyProxyQuery = GOVWAY_PREFISSO_DOMINIO_PROXY + nomeSoggetto + GOVWAY_SEPARATORE + (String)systemPropertyProxyQuery;
                systemPropertyProxyQueryBase64 = GOVWAY_PREFISSO_DOMINIO_PROXY + nomeSoggetto + GOVWAY_SEPARATORE + (String)systemPropertyProxyQueryBase64;
            } else if (byProtocollo) {
                protocollo2 = ProtocolFactoryManager.getInstance().getProtocolByOrganizationType(tipoSoggetto);
                systemPropertyProxy = GOVWAY_PREFISSO_DOMINIO_PROXY + protocollo2 + GOVWAY_SEPARATORE + nomeSoggetto + GOVWAY_SEPARATORE + (String)systemPropertyProxy;
                systemPropertyProxyHeader = GOVWAY_PREFISSO_DOMINIO_PROXY + protocollo2 + GOVWAY_SEPARATORE + nomeSoggetto + GOVWAY_SEPARATORE + (String)systemPropertyProxyHeader;
                systemPropertyProxyHeaderBase64 = GOVWAY_PREFISSO_DOMINIO_PROXY + protocollo2 + GOVWAY_SEPARATORE + nomeSoggetto + GOVWAY_SEPARATORE + (String)systemPropertyProxyHeaderBase64;
                systemPropertyProxyQuery = GOVWAY_PREFISSO_DOMINIO_PROXY + protocollo2 + GOVWAY_SEPARATORE + nomeSoggetto + GOVWAY_SEPARATORE + (String)systemPropertyProxyQuery;
                systemPropertyProxyQueryBase64 = GOVWAY_PREFISSO_DOMINIO_PROXY + protocollo2 + GOVWAY_SEPARATORE + nomeSoggetto + GOVWAY_SEPARATORE + (String)systemPropertyProxyQueryBase64;
            } else {
                systemPropertyProxy = GOVWAY_PREFISSO_DOMINIO_PROXY + tipoSoggetto + GOVWAY_SEPARATORE + nomeSoggetto + GOVWAY_SEPARATORE + (String)systemPropertyProxy;
                systemPropertyProxyHeader = GOVWAY_PREFISSO_DOMINIO_PROXY + tipoSoggetto + GOVWAY_SEPARATORE + nomeSoggetto + GOVWAY_SEPARATORE + (String)systemPropertyProxyHeader;
                systemPropertyProxyHeaderBase64 = GOVWAY_PREFISSO_DOMINIO_PROXY + tipoSoggetto + GOVWAY_SEPARATORE + nomeSoggetto + GOVWAY_SEPARATORE + (String)systemPropertyProxyHeaderBase64;
                systemPropertyProxyQuery = GOVWAY_PREFISSO_DOMINIO_PROXY + tipoSoggetto + GOVWAY_SEPARATORE + nomeSoggetto + GOVWAY_SEPARATORE + (String)systemPropertyProxyQuery;
                systemPropertyProxyQueryBase64 = GOVWAY_PREFISSO_DOMINIO_PROXY + tipoSoggetto + GOVWAY_SEPARATORE + nomeSoggetto + GOVWAY_SEPARATORE + (String)systemPropertyProxyQueryBase64;
            }
        } else if (byProtocollo) {
            protocollo2 = ProtocolFactoryManager.getInstance().getProtocolByOrganizationType(tipoSoggetto);
            systemPropertyProxy = GOVWAY_PREFISSO_PROTOCOLLO_PROXY + protocollo2 + GOVWAY_SEPARATORE + (String)systemPropertyProxy;
            systemPropertyProxyHeader = GOVWAY_PREFISSO_PROTOCOLLO_PROXY + protocollo2 + GOVWAY_SEPARATORE + (String)systemPropertyProxyHeader;
            systemPropertyProxyHeaderBase64 = GOVWAY_PREFISSO_PROTOCOLLO_PROXY + protocollo2 + GOVWAY_SEPARATORE + (String)systemPropertyProxyHeaderBase64;
            systemPropertyProxyQuery = GOVWAY_PREFISSO_PROTOCOLLO_PROXY + protocollo2 + GOVWAY_SEPARATORE + (String)systemPropertyProxyQuery;
            systemPropertyProxyQueryBase64 = GOVWAY_PREFISSO_PROTOCOLLO_PROXY + protocollo2 + GOVWAY_SEPARATORE + (String)systemPropertyProxyQueryBase64;
        }
        Object systemPropertyProxyTokenDynamicDiscovery = GOVWAY_PROXY_TOKEN_DYNAMIC_DISCOVERY;
        Object systemPropertyProxyTokenValidazioneJwt = GOVWAY_PROXY_TOKEN_VALIDAZIONE_JWT;
        Object systemPropertyProxyTokenIntrospection = GOVWAY_PROXY_TOKEN_INTROSPECTION;
        Object systemPropertyProxyTokenUserInfo = GOVWAY_PROXY_TOKEN_USERINFO;
        Object systemPropertyProxyTokenRetrieve = GOVWAY_PROXY_TOKEN_RETRIEVE;
        Object systemPropertyProxyAttributeAuthority = GOVWAY_PROXY_ATTRIBUTE_AUTHORITY;
        Object systemPropertyProxyAttributeAuthorityResponseJwtValidation = GOVWAY_PROXY_ATTRIBUTE_AUTHORITY_RESPONSE_JWT_VALIDATION;
        if (fruizione != null) {
            systemPropertyProxyTokenDynamicDiscovery = fruizione != false ? GOVWAY_FRUIZIONI_PROXY_TOKEN_DYNAMIC_DISCOVERY : GOVWAY_EROGAZIONI_PROXY_TOKEN_DYNAMIC_DISCOVERY;
            systemPropertyProxyTokenValidazioneJwt = fruizione != false ? GOVWAY_FRUIZIONI_PROXY_TOKEN_VALIDAZIONE_JWT : GOVWAY_EROGAZIONI_PROXY_TOKEN_VALIDAZIONE_JWT;
            systemPropertyProxyTokenIntrospection = fruizione != false ? GOVWAY_FRUIZIONI_PROXY_TOKEN_INTROSPECTION : GOVWAY_EROGAZIONI_PROXY_TOKEN_INTROSPECTION;
            systemPropertyProxyTokenUserInfo = fruizione != false ? GOVWAY_FRUIZIONI_PROXY_TOKEN_USERINFO : GOVWAY_EROGAZIONI_PROXY_TOKEN_USERINFO;
            systemPropertyProxyTokenRetrieve = fruizione != false ? GOVWAY_FRUIZIONI_PROXY_TOKEN_RETRIEVE : GOVWAY_EROGAZIONI_PROXY_TOKEN_RETRIEVE;
            systemPropertyProxyAttributeAuthority = fruizione != false ? GOVWAY_FRUIZIONI_PROXY_ATTRIBUTE_AUTHORITY : GOVWAY_EROGAZIONI_PROXY_ATTRIBUTE_AUTHORITY;
            Object object = systemPropertyProxyAttributeAuthorityResponseJwtValidation = fruizione != false ? GOVWAY_FRUIZIONI_PROXY_ATTRIBUTE_AUTHORITY_RESPONSE_JWT_VALIDATION : GOVWAY_EROGAZIONI_PROXY_ATTRIBUTE_AUTHORITY_RESPONSE_JWT_VALIDATION;
        }
        if (tag != null) {
            systemPropertyProxyTokenDynamicDiscovery = GOVWAY_PREFISSO_TAG_PROXY + tag + GOVWAY_SEPARATORE + (String)systemPropertyProxyTokenDynamicDiscovery;
            systemPropertyProxyTokenValidazioneJwt = GOVWAY_PREFISSO_TAG_PROXY + tag + GOVWAY_SEPARATORE + (String)systemPropertyProxyTokenValidazioneJwt;
            systemPropertyProxyTokenIntrospection = GOVWAY_PREFISSO_TAG_PROXY + tag + GOVWAY_SEPARATORE + (String)systemPropertyProxyTokenIntrospection;
            systemPropertyProxyTokenUserInfo = GOVWAY_PREFISSO_TAG_PROXY + tag + GOVWAY_SEPARATORE + (String)systemPropertyProxyTokenUserInfo;
            systemPropertyProxyTokenRetrieve = GOVWAY_PREFISSO_TAG_PROXY + tag + GOVWAY_SEPARATORE + (String)systemPropertyProxyTokenRetrieve;
            systemPropertyProxyAttributeAuthority = GOVWAY_PREFISSO_TAG_PROXY + tag + GOVWAY_SEPARATORE + (String)systemPropertyProxyAttributeAuthority;
            systemPropertyProxyAttributeAuthorityResponseJwtValidation = GOVWAY_PREFISSO_TAG_PROXY + tag + GOVWAY_SEPARATORE + (String)systemPropertyProxyAttributeAuthorityResponseJwtValidation;
        } else if (nomeSoggetto != null) {
            if (tipoSoggetto == null) {
                systemPropertyProxyTokenDynamicDiscovery = GOVWAY_PREFISSO_DOMINIO_PROXY + nomeSoggetto + GOVWAY_SEPARATORE + (String)systemPropertyProxyTokenDynamicDiscovery;
                systemPropertyProxyTokenValidazioneJwt = GOVWAY_PREFISSO_DOMINIO_PROXY + nomeSoggetto + GOVWAY_SEPARATORE + (String)systemPropertyProxyTokenValidazioneJwt;
                systemPropertyProxyTokenIntrospection = GOVWAY_PREFISSO_DOMINIO_PROXY + nomeSoggetto + GOVWAY_SEPARATORE + (String)systemPropertyProxyTokenIntrospection;
                systemPropertyProxyTokenUserInfo = GOVWAY_PREFISSO_DOMINIO_PROXY + nomeSoggetto + GOVWAY_SEPARATORE + (String)systemPropertyProxyTokenUserInfo;
                systemPropertyProxyTokenRetrieve = GOVWAY_PREFISSO_DOMINIO_PROXY + nomeSoggetto + GOVWAY_SEPARATORE + (String)systemPropertyProxyTokenRetrieve;
                systemPropertyProxyAttributeAuthority = GOVWAY_PREFISSO_DOMINIO_PROXY + nomeSoggetto + GOVWAY_SEPARATORE + (String)systemPropertyProxyAttributeAuthority;
                systemPropertyProxyAttributeAuthorityResponseJwtValidation = GOVWAY_PREFISSO_DOMINIO_PROXY + nomeSoggetto + GOVWAY_SEPARATORE + (String)systemPropertyProxyAttributeAuthorityResponseJwtValidation;
            } else if (byProtocollo) {
                protocollo = ProtocolFactoryManager.getInstance().getProtocolByOrganizationType(tipoSoggetto);
                systemPropertyProxyTokenDynamicDiscovery = GOVWAY_PREFISSO_DOMINIO_PROXY + protocollo + GOVWAY_SEPARATORE + nomeSoggetto + GOVWAY_SEPARATORE + (String)systemPropertyProxyTokenDynamicDiscovery;
                systemPropertyProxyTokenValidazioneJwt = GOVWAY_PREFISSO_DOMINIO_PROXY + protocollo + GOVWAY_SEPARATORE + nomeSoggetto + GOVWAY_SEPARATORE + (String)systemPropertyProxyTokenValidazioneJwt;
                systemPropertyProxyTokenIntrospection = GOVWAY_PREFISSO_DOMINIO_PROXY + protocollo + GOVWAY_SEPARATORE + nomeSoggetto + GOVWAY_SEPARATORE + (String)systemPropertyProxyTokenIntrospection;
                systemPropertyProxyTokenUserInfo = GOVWAY_PREFISSO_DOMINIO_PROXY + protocollo + GOVWAY_SEPARATORE + nomeSoggetto + GOVWAY_SEPARATORE + (String)systemPropertyProxyTokenUserInfo;
                systemPropertyProxyTokenRetrieve = GOVWAY_PREFISSO_DOMINIO_PROXY + protocollo + GOVWAY_SEPARATORE + nomeSoggetto + GOVWAY_SEPARATORE + (String)systemPropertyProxyTokenRetrieve;
                systemPropertyProxyAttributeAuthority = GOVWAY_PREFISSO_DOMINIO_PROXY + protocollo + GOVWAY_SEPARATORE + nomeSoggetto + GOVWAY_SEPARATORE + (String)systemPropertyProxyAttributeAuthority;
                systemPropertyProxyAttributeAuthorityResponseJwtValidation = GOVWAY_PREFISSO_DOMINIO_PROXY + protocollo + GOVWAY_SEPARATORE + nomeSoggetto + GOVWAY_SEPARATORE + (String)systemPropertyProxyAttributeAuthorityResponseJwtValidation;
            } else {
                systemPropertyProxyTokenDynamicDiscovery = GOVWAY_PREFISSO_DOMINIO_PROXY + tipoSoggetto + GOVWAY_SEPARATORE + nomeSoggetto + GOVWAY_SEPARATORE + (String)systemPropertyProxyTokenDynamicDiscovery;
                systemPropertyProxyTokenValidazioneJwt = GOVWAY_PREFISSO_DOMINIO_PROXY + tipoSoggetto + GOVWAY_SEPARATORE + nomeSoggetto + GOVWAY_SEPARATORE + (String)systemPropertyProxyTokenValidazioneJwt;
                systemPropertyProxyTokenIntrospection = GOVWAY_PREFISSO_DOMINIO_PROXY + tipoSoggetto + GOVWAY_SEPARATORE + nomeSoggetto + GOVWAY_SEPARATORE + (String)systemPropertyProxyTokenIntrospection;
                systemPropertyProxyTokenUserInfo = GOVWAY_PREFISSO_DOMINIO_PROXY + tipoSoggetto + GOVWAY_SEPARATORE + nomeSoggetto + GOVWAY_SEPARATORE + (String)systemPropertyProxyTokenUserInfo;
                systemPropertyProxyTokenRetrieve = GOVWAY_PREFISSO_DOMINIO_PROXY + tipoSoggetto + GOVWAY_SEPARATORE + nomeSoggetto + GOVWAY_SEPARATORE + (String)systemPropertyProxyTokenRetrieve;
                systemPropertyProxyAttributeAuthority = GOVWAY_PREFISSO_DOMINIO_PROXY + tipoSoggetto + GOVWAY_SEPARATORE + nomeSoggetto + GOVWAY_SEPARATORE + (String)systemPropertyProxyAttributeAuthority;
                systemPropertyProxyAttributeAuthorityResponseJwtValidation = GOVWAY_PREFISSO_DOMINIO_PROXY + tipoSoggetto + GOVWAY_SEPARATORE + nomeSoggetto + GOVWAY_SEPARATORE + (String)systemPropertyProxyAttributeAuthorityResponseJwtValidation;
            }
        } else if (byProtocollo) {
            protocollo = ProtocolFactoryManager.getInstance().getProtocolByOrganizationType(tipoSoggetto);
            systemPropertyProxyTokenDynamicDiscovery = GOVWAY_PREFISSO_PROTOCOLLO_PROXY + protocollo + GOVWAY_SEPARATORE + (String)systemPropertyProxyTokenDynamicDiscovery;
            systemPropertyProxyTokenValidazioneJwt = GOVWAY_PREFISSO_PROTOCOLLO_PROXY + protocollo + GOVWAY_SEPARATORE + (String)systemPropertyProxyTokenValidazioneJwt;
            systemPropertyProxyTokenIntrospection = GOVWAY_PREFISSO_PROTOCOLLO_PROXY + protocollo + GOVWAY_SEPARATORE + (String)systemPropertyProxyTokenIntrospection;
            systemPropertyProxyTokenUserInfo = GOVWAY_PREFISSO_PROTOCOLLO_PROXY + protocollo + GOVWAY_SEPARATORE + (String)systemPropertyProxyTokenUserInfo;
            systemPropertyProxyTokenRetrieve = GOVWAY_PREFISSO_PROTOCOLLO_PROXY + protocollo + GOVWAY_SEPARATORE + (String)systemPropertyProxyTokenRetrieve;
            systemPropertyProxyAttributeAuthority = GOVWAY_PREFISSO_PROTOCOLLO_PROXY + protocollo + GOVWAY_SEPARATORE + (String)systemPropertyProxyAttributeAuthority;
            systemPropertyProxyAttributeAuthorityResponseJwtValidation = GOVWAY_PREFISSO_PROTOCOLLO_PROXY + protocollo + GOVWAY_SEPARATORE + (String)systemPropertyProxyAttributeAuthorityResponseJwtValidation;
        }
        String systemPropertyProxyTokenDynamicDiscoveryNomePolicy = null;
        String systemPropertyProxyTokenValidazioneJwtNomePolicy = null;
        String systemPropertyProxyTokenIntrospectionNomePolicy = null;
        String systemPropertyProxyTokenUserInfoNomePolicy = null;
        String systemPropertyProxyTokenRetrieveNomePolicy = null;
        String systemPropertyProxyAttributeAuthorityNomePolicy = null;
        String systemPropertyProxyAttributeAuthorityResponseJwtValidationNomePolicy = null;
        if (policy != null && policy.getNome() != null) {
            systemPropertyProxyTokenDynamicDiscoveryNomePolicy = (String)systemPropertyProxyTokenDynamicDiscovery + GOVWAY_SEPARATORE + policy.getNome();
            systemPropertyProxyTokenValidazioneJwtNomePolicy = (String)systemPropertyProxyTokenValidazioneJwt + GOVWAY_SEPARATORE + policy.getNome();
            systemPropertyProxyTokenIntrospectionNomePolicy = (String)systemPropertyProxyTokenIntrospection + GOVWAY_SEPARATORE + policy.getNome();
            systemPropertyProxyTokenUserInfoNomePolicy = (String)systemPropertyProxyTokenUserInfo + GOVWAY_SEPARATORE + policy.getNome();
            systemPropertyProxyTokenRetrieveNomePolicy = (String)systemPropertyProxyTokenRetrieve + GOVWAY_SEPARATORE + policy.getNome();
            systemPropertyProxyAttributeAuthorityNomePolicy = (String)systemPropertyProxyAttributeAuthority + GOVWAY_SEPARATORE + policy.getNome();
            systemPropertyProxyAttributeAuthorityResponseJwtValidationNomePolicy = (String)systemPropertyProxyAttributeAuthorityResponseJwtValidation + GOVWAY_SEPARATORE + policy.getNome();
        }
        ForwardProxy sConfig = new ForwardProxy();
        String url = System.getProperty((String)systemPropertyProxy);
        if (url != null && !"".equals(url)) {
            sConfig.enabled = true;
            sConfig.url = url;
            String header = System.getProperty((String)systemPropertyProxyHeader);
            String query = System.getProperty((String)systemPropertyProxyQuery);
            if ((header == null || "".equals(header)) && (query == null || "".equals(query))) {
                sConfig.config = defaultConfig;
            } else {
                String base64;
                ForwardProxyConfigurazione config;
                sConfig.config = config = new ForwardProxyConfigurazione();
                if (header != null && !"".equals(header)) {
                    config.setHeader(header);
                    base64 = System.getProperty((String)systemPropertyProxyHeaderBase64);
                    if (base64 != null && !"".equals(base64)) {
                        if (TRUE.equalsIgnoreCase(base64)) {
                            config.setHeaderBase64(true);
                        } else if (FALSE.equalsIgnoreCase(base64)) {
                            config.setHeaderBase64(false);
                        } else {
                            config.setHeaderBase64(false);
                        }
                    } else {
                        config.setHeaderBase64(false);
                    }
                }
                if (query != null && !"".equals(query)) {
                    config.setQuery(query);
                    base64 = System.getProperty((String)systemPropertyProxyQueryBase64);
                    if (base64 != null && !"".equals(base64)) {
                        if (TRUE.equalsIgnoreCase(base64)) {
                            config.setQueryBase64(true);
                        } else if (FALSE.equalsIgnoreCase(base64)) {
                            config.setQueryBase64(false);
                        } else {
                            config.setQueryBase64(false);
                        }
                    } else {
                        config.setQueryBase64(false);
                    }
                }
            }
            String dynamicDiscovery = null;
            if (systemPropertyProxyTokenDynamicDiscoveryNomePolicy != null) {
                dynamicDiscovery = System.getProperty(systemPropertyProxyTokenDynamicDiscoveryNomePolicy);
            }
            if (dynamicDiscovery == null || "".equals(dynamicDiscovery)) {
                dynamicDiscovery = System.getProperty((String)systemPropertyProxyTokenDynamicDiscovery);
            }
            String validazioneJwt = null;
            if (systemPropertyProxyTokenValidazioneJwtNomePolicy != null) {
                validazioneJwt = System.getProperty(systemPropertyProxyTokenValidazioneJwtNomePolicy);
            }
            if (validazioneJwt == null || "".equals(validazioneJwt)) {
                validazioneJwt = System.getProperty((String)systemPropertyProxyTokenValidazioneJwt);
            }
            String introspection = null;
            if (systemPropertyProxyTokenIntrospectionNomePolicy != null) {
                introspection = System.getProperty(systemPropertyProxyTokenIntrospectionNomePolicy);
            }
            if (introspection == null || "".equals(introspection)) {
                introspection = System.getProperty((String)systemPropertyProxyTokenIntrospection);
            }
            String userInfo = null;
            if (systemPropertyProxyTokenUserInfoNomePolicy != null) {
                userInfo = System.getProperty(systemPropertyProxyTokenUserInfoNomePolicy);
            }
            if (userInfo == null || "".equals(userInfo)) {
                userInfo = System.getProperty((String)systemPropertyProxyTokenUserInfo);
            }
            String retrieve = null;
            if (systemPropertyProxyTokenRetrieveNomePolicy != null) {
                retrieve = System.getProperty(systemPropertyProxyTokenRetrieveNomePolicy);
            }
            if (retrieve == null || "".equals(retrieve)) {
                retrieve = System.getProperty((String)systemPropertyProxyTokenRetrieve);
            }
            String attributeAuthority = null;
            if (systemPropertyProxyAttributeAuthorityNomePolicy != null) {
                attributeAuthority = System.getProperty(systemPropertyProxyAttributeAuthorityNomePolicy);
            }
            if (attributeAuthority == null || "".equals(attributeAuthority)) {
                attributeAuthority = System.getProperty((String)systemPropertyProxyAttributeAuthority);
            }
            String attributeAuthorityResponseJwtValidation = null;
            if (systemPropertyProxyAttributeAuthorityResponseJwtValidationNomePolicy != null) {
                attributeAuthorityResponseJwtValidation = System.getProperty(systemPropertyProxyAttributeAuthorityResponseJwtValidationNomePolicy);
            }
            if (attributeAuthorityResponseJwtValidation == null || "".equals(attributeAuthorityResponseJwtValidation)) {
                attributeAuthorityResponseJwtValidation = System.getProperty((String)systemPropertyProxyAttributeAuthorityResponseJwtValidation);
            }
            if (!(dynamicDiscovery != null && !"".equals(dynamicDiscovery) || validazioneJwt != null && !"".equals(validazioneJwt) || introspection != null && !"".equals(introspection) || userInfo != null && !"".equals(userInfo) || retrieve != null && !"".equals(retrieve) || attributeAuthority != null && !"".equals(attributeAuthority) || attributeAuthorityResponseJwtValidation != null && !"".equals(attributeAuthorityResponseJwtValidation))) {
                sConfig.configToken = defaultConfigToken;
            } else {
                ForwardProxyConfigurazioneToken config;
                sConfig.configToken = config = new ForwardProxyConfigurazioneToken();
                config.tokenDynamicDiscoveryEnabled = dynamicDiscovery != null && !"".equals(dynamicDiscovery) ? (TRUE.equalsIgnoreCase(dynamicDiscovery) ? true : (FALSE.equalsIgnoreCase(dynamicDiscovery) ? false : false)) : false;
                config.tokenJwtValidationEnabled = validazioneJwt != null && !"".equals(validazioneJwt) ? (TRUE.equalsIgnoreCase(validazioneJwt) ? true : (FALSE.equalsIgnoreCase(validazioneJwt) ? false : false)) : false;
                config.tokenIntrospectionEnabled = introspection != null && !"".equals(introspection) ? (TRUE.equalsIgnoreCase(introspection) ? true : (FALSE.equalsIgnoreCase(introspection) ? false : false)) : false;
                config.tokenUserInfoEnabled = userInfo != null && !"".equals(userInfo) ? (TRUE.equalsIgnoreCase(userInfo) ? true : (FALSE.equalsIgnoreCase(userInfo) ? false : false)) : false;
                config.tokenRetrieveEnabled = retrieve != null && !"".equals(retrieve) ? (TRUE.equalsIgnoreCase(retrieve) ? true : (FALSE.equalsIgnoreCase(retrieve) ? false : false)) : false;
                config.attributeAuthorityEnabled = attributeAuthority != null && !"".equals(attributeAuthority) ? (TRUE.equalsIgnoreCase(attributeAuthority) ? true : (FALSE.equalsIgnoreCase(attributeAuthority) ? false : false)) : false;
                config.attributeAuthorityResponseJwtValidationEnabled = attributeAuthorityResponseJwtValidation != null && !"".equals(attributeAuthorityResponseJwtValidation) ? (TRUE.equalsIgnoreCase(attributeAuthorityResponseJwtValidation) ? true : (FALSE.equalsIgnoreCase(attributeAuthorityResponseJwtValidation) ? false : false)) : false;
            }
        }
        return sConfig;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("enabled: ").append(this.enabled);
        if (this.enabled) {
            sb.append("\n").append("url: ").append(this.url);
        }
        if (this.config != null) {
            sb.append("\n").append(this.config.toString());
        }
        if (this.configToken != null) {
            sb.append("\n").append(this.configToken.toString());
        }
        return sb.toString();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public ForwardProxyConfigurazione getConfig() {
        return this.config;
    }

    public void setConfig(ForwardProxyConfigurazione config) {
        this.config = config;
    }

    public ForwardProxyConfigurazioneToken getConfigToken() {
        return this.configToken;
    }

    public void setConfigToken(ForwardProxyConfigurazioneToken configToken) {
        this.configToken = configToken;
    }
}

