/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.config;

import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.pdd.config.ConfigurazioneNodiRuntime;
import org.openspcoop2.pdd.core.jmx.GestoreRisorseJMXGovWay;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.transport.http.HttpRequest;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.openspcoop2.utils.transport.http.HttpResponse;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.slf4j.Logger;

public class InvokerNodiRuntime {
    private ConfigurazioneNodiRuntime configurazioneNodiRuntime = null;
    private Logger log;
    public static final String RESOURCE_URL_LOCALE = "locale";
    public static final String PREFIX_HTTP_CODE = "[httpCode ";
    private static final String PREFIX_ALIAS = "[alias:";

    public InvokerNodiRuntime(Logger log, ConfigurazioneNodiRuntime config) {
        this.log = log;
        this.configurazioneNodiRuntime = config;
    }

    public boolean isJmxPdD_tipoAccessoOpenSPCoop(String alias) {
        return "openspcoop".equals(this.configurazioneNodiRuntime.getTipoAccesso(alias)) || "govway".equals(this.configurazioneNodiRuntime.getTipoAccesso(alias));
    }

    public Object getGestoreRisorseJMX(String alias) throws UtilsException {
        try {
            if (this.isJmxPdD_tipoAccessoOpenSPCoop(alias)) {
                String remoteUrl = this.configurazioneNodiRuntime.getResourceUrl(alias);
                if (remoteUrl == null) {
                    throw new Exception("Configurazione errata (pdd:" + alias + ") accesso via check. Non e' stata indicata la url");
                }
                return remoteUrl;
            }
            GestoreRisorseJMXGovWay gestoreJMX = null;
            if (this.configurazioneNodiRuntime.getResourceUrl(alias) != null && !"".equals(this.configurazioneNodiRuntime.getResourceUrl(alias)) && !RESOURCE_URL_LOCALE.equals(this.configurazioneNodiRuntime.getResourceUrl(alias))) {
                String remoteUrl = this.configurazioneNodiRuntime.getResourceUrl(alias);
                String factory = this.configurazioneNodiRuntime.getFactory(alias);
                if (factory == null) {
                    throw new UtilsException("Configurazione errata (pdd:" + alias + ") per l'accesso alla url [" + remoteUrl + "] via jmx. Non e' stata indicata una factory");
                }
                String as = this.configurazioneNodiRuntime.getAs(alias);
                if (as == null) {
                    throw new UtilsException("Configurazione errata (pdd:" + alias + ") per l'accesso alla url [" + remoteUrl + "] via jmx. Non e' stato indicato il tipo di application server");
                }
                gestoreJMX = new GestoreRisorseJMXGovWay(as, factory, remoteUrl, this.configurazioneNodiRuntime.getUsername(alias), this.configurazioneNodiRuntime.getPassword(alias), this.log);
            } else {
                gestoreJMX = new GestoreRisorseJMXGovWay(this.log);
            }
            if (this.log == null) {
                gestoreJMX.setLogActive(false);
            }
            return gestoreJMX;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
    }

    private HttpResponse invokeHttp(String urlWithParameters, String alias, Boolean slowOperation) throws UtilsException {
        String readConnectionTimeoutS;
        String username = this.configurazioneNodiRuntime.getUsername(alias);
        String password = this.configurazioneNodiRuntime.getPassword(alias);
        boolean https = this.configurazioneNodiRuntime.isHttps(alias);
        boolean httpsVerificaHostName = true;
        boolean httpsAutenticazioneServer = true;
        String httpsTruststorePath = null;
        String httpsTruststoreType = null;
        String httpsTruststorePassword = null;
        if (https) {
            httpsVerificaHostName = this.configurazioneNodiRuntime.isHttps_verificaHostName(alias);
            httpsAutenticazioneServer = this.configurazioneNodiRuntime.isHttps_autenticazioneServer(alias);
            if (httpsAutenticazioneServer) {
                httpsTruststorePath = this.configurazioneNodiRuntime.getHttps_autenticazioneServer_truststorePath(alias);
                if (StringUtils.isEmpty((String)httpsTruststorePath)) {
                    throw new UtilsException(PREFIX_ALIAS + alias + "] TLS Truststore path non fornito");
                }
                httpsTruststoreType = this.configurazioneNodiRuntime.getHttps_autenticazioneServer_truststoreType(alias);
                if (StringUtils.isEmpty((String)httpsTruststoreType)) {
                    throw new UtilsException(PREFIX_ALIAS + alias + "] TLS Truststore type non fornito");
                }
                httpsTruststorePassword = this.configurazioneNodiRuntime.getHttps_autenticazioneServer_truststorePassword(alias);
                if (StringUtils.isEmpty((String)httpsTruststorePassword)) {
                    throw new UtilsException(PREFIX_ALIAS + alias + "] TLS Truststore password non fornito");
                }
            }
        }
        Integer connectionTimeout = 5000;
        Integer readConnectionTimeout = 5000;
        String connectionTimeoutS = this.configurazioneNodiRuntime.getConnectionTimeout(alias);
        if (connectionTimeoutS != null) {
            connectionTimeout = Integer.valueOf(connectionTimeoutS);
        }
        if ((readConnectionTimeoutS = this.configurazioneNodiRuntime.getReadConnectionTimeout(alias)) != null) {
            readConnectionTimeout = Integer.valueOf(readConnectionTimeoutS);
        }
        if (slowOperation != null && slowOperation.booleanValue()) {
            String readConnectionTimeoutSlowOperationS = this.configurazioneNodiRuntime.getReadConnectionTimeout_slowOperation(alias);
            readConnectionTimeout = readConnectionTimeoutSlowOperationS != null ? Integer.valueOf(readConnectionTimeoutSlowOperationS) : Integer.valueOf(60000);
        }
        HttpResponse response = null;
        if (https) {
            HttpRequest httpRequest = new HttpRequest();
            httpRequest.setUrl(urlWithParameters);
            httpRequest.setConnectTimeout(connectionTimeout.intValue());
            httpRequest.setReadTimeout(readConnectionTimeout.intValue());
            httpRequest.setUsername(username);
            httpRequest.setPassword(password);
            httpRequest.setMethod(HttpRequestMethod.GET);
            httpRequest.setHostnameVerifier(httpsVerificaHostName);
            if (httpsAutenticazioneServer) {
                httpRequest.setTrustStorePath(httpsTruststorePath);
                httpRequest.setTrustStoreType(httpsTruststoreType);
                httpRequest.setTrustStorePassword(httpsTruststorePassword);
            } else {
                httpRequest.setTrustAllCerts(true);
            }
            response = HttpUtilities.httpInvoke((HttpRequest)httpRequest);
        } else {
            response = HttpUtilities.getHTTPResponse((String)urlWithParameters, (int)readConnectionTimeout, (int)connectionTimeout, (String)username, (String)password);
        }
        return response;
    }

    public String invokeJMXMethod(String alias, String type, String nomeRisorsa, String nomeMetodo) throws UtilsException {
        return this.invokeJMXMethodEngine(alias, type, nomeRisorsa, nomeMetodo, false, new Object[0]);
    }

    public String invokeJMXMethod(String alias, String type, String nomeRisorsa, String nomeMetodo, Boolean slowOperation) throws UtilsException {
        return this.invokeJMXMethodEngine(alias, type, nomeRisorsa, nomeMetodo, slowOperation, new Object[0]);
    }

    public String invokeJMXMethod(String alias, String type, String nomeRisorsa, String nomeMetodo, String parametro) throws UtilsException {
        return this.invokeJMXMethodEngine(alias, type, nomeRisorsa, nomeMetodo, false, parametro != null && !"".equals(parametro) ? parametro : null);
    }

    public String invokeJMXMethod(String alias, String type, String nomeRisorsa, String nomeMetodo, Boolean slowOperation, String parametro) throws UtilsException {
        return this.invokeJMXMethodEngine(alias, type, nomeRisorsa, nomeMetodo, slowOperation, parametro != null && !"".equals(parametro) ? parametro : null);
    }

    public String invokeJMXMethod(String alias, String type, String nomeRisorsa, String nomeMetodo, Object ... parametri) throws UtilsException {
        return this.invokeJMXMethodEngine(alias, type, nomeRisorsa, nomeMetodo, false, parametri);
    }

    public String invokeJMXMethod(String alias, String type, String nomeRisorsa, String nomeMetodo, Boolean slowOperation, Object ... parametri) throws UtilsException {
        return this.invokeJMXMethodEngine(alias, type, nomeRisorsa, nomeMetodo, slowOperation, parametri);
    }

    private String invokeJMXMethodEngine(String alias, String type, String nomeRisorsa, String nomeMetodo, Boolean slowOperation, Object ... parametri) throws UtilsException {
        Object gestore = this.getGestoreRisorseJMX(alias);
        try {
            if (gestore instanceof GestoreRisorseJMXGovWay) {
                String tmp;
                Object[] params = null;
                String[] signatures = null;
                if (parametri != null && parametri.length > 0) {
                    params = parametri;
                    signatures = new String[parametri.length];
                    for (int i = 0; i < parametri.length; ++i) {
                        signatures[i] = parametri[i].getClass().getName();
                    }
                }
                GestoreRisorseJMXGovWay gestoreJMXGovWay = (GestoreRisorseJMXGovWay)((Object)gestore);
                if (this.log == null) {
                    gestoreJMXGovWay.setLogActive(false);
                }
                if ((tmp = (String)gestoreJMXGovWay.invoke(this.configurazioneNodiRuntime.getDominio(alias), type, nomeRisorsa, nomeMetodo, params, signatures)).startsWith("Operazione non riuscita: ")) {
                    throw new UtilsException(tmp);
                }
                return tmp;
            }
            if (gestore instanceof String) {
                String urlWithParameters;
                HttpResponse response;
                String url = (String)gestore;
                HashMap p = new HashMap();
                TransportUtils.setParameter(p, (String)"resourceName", (String)nomeRisorsa);
                TransportUtils.setParameter(p, (String)"methodName", (String)nomeMetodo);
                if (parametri != null && parametri.length > 0) {
                    for (int i = 0; i < parametri.length; ++i) {
                        Object o = parametri[i];
                        if (o == null) continue;
                        if (o instanceof Integer) {
                            Integer intValue = (Integer)o;
                            if (i == 0) {
                                TransportUtils.setParameter(p, (String)"paramIntegerValue", (String)("" + intValue));
                                continue;
                            }
                            if (i == 1) {
                                TransportUtils.setParameter(p, (String)"paramIntegerValue2", (String)("" + intValue));
                                continue;
                            }
                            if (i == 2) {
                                TransportUtils.setParameter(p, (String)"paramIntegerValue3", (String)("" + intValue));
                                continue;
                            }
                            throw new UtilsException("Gestore di tipo [" + gestore.getClass().getName() + "] non gestisce un numero maggiore di 3 parametri");
                        }
                        if (o instanceof Long) {
                            Long longValue = (Long)o;
                            if (i == 0) {
                                TransportUtils.setParameter(p, (String)"paramLongValue", (String)("" + longValue));
                                continue;
                            }
                            if (i == 1) {
                                TransportUtils.setParameter(p, (String)"paramLongValue2", (String)("" + longValue));
                                continue;
                            }
                            if (i == 2) {
                                TransportUtils.setParameter(p, (String)"paramLongValue3", (String)("" + longValue));
                                continue;
                            }
                            throw new UtilsException("Gestore di tipo [" + gestore.getClass().getName() + "] non gestisce un numero maggiore di 3 parametri");
                        }
                        if (o instanceof Boolean) {
                            Boolean booleanValue = (Boolean)o;
                            if (i == 0) {
                                TransportUtils.setParameter(p, (String)"paramBooleanValue", (String)("" + booleanValue));
                                continue;
                            }
                            if (i == 1) {
                                TransportUtils.setParameter(p, (String)"paramBooleanValue2", (String)("" + booleanValue));
                                continue;
                            }
                            if (i == 2) {
                                TransportUtils.setParameter(p, (String)"paramBooleanValue3", (String)("" + booleanValue));
                                continue;
                            }
                            throw new UtilsException("Gestore di tipo [" + gestore.getClass().getName() + "] non gestisce un numero maggiore di 3 parametri");
                        }
                        String stringValue = o.toString();
                        if (i == 0) {
                            TransportUtils.setParameter(p, (String)"paramValue", (String)stringValue);
                            continue;
                        }
                        if (i == 1) {
                            TransportUtils.setParameter(p, (String)"paramValue2", (String)stringValue);
                            continue;
                        }
                        if (i == 2) {
                            TransportUtils.setParameter(p, (String)"paramValue3", (String)stringValue);
                            continue;
                        }
                        throw new UtilsException("Gestore di tipo [" + gestore.getClass().getName() + "] non gestisce un numero maggiore di 3 parametri");
                    }
                }
                if ((response = this.invokeHttp(urlWithParameters = TransportUtils.buildUrlWithParameters(p, (String)url), alias, slowOperation)).getResultHTTPOperation() != 200) {
                    String error = PREFIX_HTTP_CODE + response.getResultHTTPOperation() + "]";
                    if (response.getContent() != null) {
                        error = error + " " + new String(response.getContent());
                    }
                    return error;
                }
                return new String(response.getContent());
            }
            throw new UtilsException("Gestore di tipo [" + gestore.getClass().getName() + "] non gestito");
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
    }

    public String readJMXAttribute(String alias, String type, String nomeRisorsa, String nomeAttributo) throws UtilsException {
        return this.readJMXAttribute(alias, type, nomeRisorsa, nomeAttributo, false);
    }

    public String readJMXAttribute(String alias, String type, String nomeRisorsa, String nomeAttributo, Boolean slowOperation) throws UtilsException {
        Object gestore = this.getGestoreRisorseJMX(alias);
        try {
            if (gestore instanceof GestoreRisorseJMXGovWay) {
                Object t;
                GestoreRisorseJMXGovWay gestoreJMXGovWay = (GestoreRisorseJMXGovWay)((Object)gestore);
                if (this.log == null) {
                    gestoreJMXGovWay.setLogActive(false);
                }
                if ((t = gestoreJMXGovWay.getAttribute(this.configurazioneNodiRuntime.getDominio(alias), type, nomeRisorsa, nomeAttributo)) instanceof String) {
                    String tmp = (String)t;
                    if (tmp.startsWith("Operazione non riuscita: ")) {
                        throw new UtilsException(tmp);
                    }
                    return tmp;
                }
                if (t instanceof Boolean) {
                    return ((Boolean)t).toString();
                }
                return t.toString();
            }
            if (gestore instanceof String) {
                String url = (String)gestore;
                HashMap p = new HashMap();
                TransportUtils.setParameter(p, (String)"resourceName", (String)nomeRisorsa);
                TransportUtils.setParameter(p, (String)"attributeName", (String)nomeAttributo);
                String urlWithParameters = TransportUtils.buildUrlWithParameters(p, (String)url);
                HttpResponse response = this.invokeHttp(urlWithParameters, alias, slowOperation);
                if (response.getResultHTTPOperation() != 200) {
                    String error = PREFIX_HTTP_CODE + response.getResultHTTPOperation() + "]";
                    if (response.getContent() != null) {
                        error = error + " " + new String(response.getContent());
                    }
                    return error;
                }
                return new String(response.getContent());
            }
            throw new UtilsException("Gestore di tipo [" + gestore.getClass().getName() + "] non gestito");
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
    }

    public void setJMXAttribute(String alias, String type, String nomeRisorsa, String nomeAttributo, Object value) throws UtilsException {
        this.setJMXAttribute(alias, type, nomeRisorsa, nomeAttributo, value, false);
    }

    public void setJMXAttribute(String alias, String type, String nomeRisorsa, String nomeAttributo, Object value, Boolean slowOperation) throws UtilsException {
        block9: {
            Object gestore = this.getGestoreRisorseJMX(alias);
            try {
                if (gestore instanceof GestoreRisorseJMXGovWay) {
                    GestoreRisorseJMXGovWay gestoreJMXGovWay = (GestoreRisorseJMXGovWay)((Object)gestore);
                    if (this.log == null) {
                        gestoreJMXGovWay.setLogActive(false);
                    }
                    gestoreJMXGovWay.setAttribute(this.configurazioneNodiRuntime.getDominio(alias), type, nomeRisorsa, nomeAttributo, value);
                    break block9;
                }
                if (gestore instanceof String) {
                    String url = (String)gestore;
                    HashMap p = new HashMap();
                    TransportUtils.setParameter(p, (String)"resourceName", (String)nomeRisorsa);
                    TransportUtils.setParameter(p, (String)"attributeName", (String)nomeAttributo);
                    if (value instanceof Boolean) {
                        TransportUtils.setParameter(p, (String)"attributeBooleanValue", (String)value.toString());
                    } else {
                        TransportUtils.setParameter(p, (String)"attributeValue", (String)value.toString());
                    }
                    String urlWithParameters = TransportUtils.buildUrlWithParameters(p, (String)url);
                    HttpResponse response = this.invokeHttp(urlWithParameters, alias, slowOperation);
                    if (response.getResultHTTPOperation() != 200) {
                        String error = PREFIX_HTTP_CODE + response.getResultHTTPOperation() + "]";
                        if (response.getContent() != null) {
                            error = error + " " + new String(response.getContent());
                        }
                        throw new UtilsException(error);
                    }
                    break block9;
                }
                throw new UtilsException("Gestore di tipo [" + gestore.getClass().getName() + "] non gestito");
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

