/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.config;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.CostantiProprieta;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.PDNDConfig;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.utils.ModIUtils;
import org.openspcoop2.utils.Map;
import org.openspcoop2.utils.certificate.remote.RemoteStoreConfig;
import org.openspcoop2.utils.json.JsonPathExpressionEngine;
import org.openspcoop2.utils.resources.Charset;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.transport.http.ExternalResourceConfig;
import org.openspcoop2.utils.transport.http.ExternalResourceUtils;
import org.slf4j.Logger;

public class PDNDConfigUtilities {
    private PDNDConfigUtilities() {
    }

    public static List<PDNDConfig> getRemoteStoreConfig(OpenSPCoop2Properties propertiesReader) throws ProtocolException, CoreException {
        List listRSC = ModIUtils.getRemoteStoreConfig();
        ArrayList<PDNDConfig> l = null;
        if (listRSC != null && !listRSC.isEmpty()) {
            List<String> pdndNames = propertiesReader.getGestoreChiaviPDNDRemoteStoreName();
            boolean all = propertiesReader.isGestoreChiaviPDNDEventiCheckAllStores();
            for (RemoteStoreConfig r : listRSC) {
                if (!all && !pdndNames.contains(r.getStoreName())) continue;
                String pdndName = r.getStoreName();
                PDNDConfig c = new PDNDConfig();
                c.setRemoteKeyType(ModIUtils.getRemoteKeyType((String)pdndName));
                c.setRemoteStoreConfig(r);
                if (l == null) {
                    l = new ArrayList<PDNDConfig>();
                }
                l.add(c);
            }
        }
        if (l != null && !l.isEmpty()) {
            return l;
        }
        l = null;
        return l;
    }

    public static String buildUrlCheckEventi(RemoteStoreConfig remoteStore) throws ProtocolException {
        return ModIUtils.extractInfoFromMetadati((java.util.Map)remoteStore.getMetadati(), (String)"api-pdnd-eventsKeys-path", (String)"Events keys path");
    }

    private static String buildUrlClientId(RemoteStoreConfig remoteStore, String clientId) throws ProtocolException {
        String urlClients = ModIUtils.extractInfoFromMetadati((java.util.Map)remoteStore.getMetadati(), (String)"api-pdnd-clients-path", (String)"Clients path");
        return PDNDConfigUtilities.buildUrlByResourceId(urlClients, clientId);
    }

    private static String buildUrlOrganizationId(RemoteStoreConfig remoteStore, String organizationId) throws ProtocolException {
        String urlOrganizations = ModIUtils.extractInfoFromMetadati((java.util.Map)remoteStore.getMetadati(), (String)"api-pdnd-organizations-path", (String)"Organizations path");
        return PDNDConfigUtilities.buildUrlByResourceId(urlOrganizations, organizationId);
    }

    private static String buildUrlByResourceId(String url, String valueId) throws ProtocolException {
        int indexOf = ((String)url).indexOf("{");
        if (indexOf > 0) {
            url = ((String)url).substring(0, indexOf);
            try {
                url = (String)url + TransportUtils.urlEncodePath((String)valueId, (String)Charset.UTF_8.getValue());
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return url;
    }

    public static String readClientDetails(RemoteStoreConfig remoteStore, OpenSPCoop2Properties propertiesReader, Map<Object> context, String clientId, Logger log) throws CoreException {
        String responseJson = null;
        try {
            String url = PDNDConfigUtilities.buildUrlClientId(remoteStore, clientId);
            byte[] response = ExternalResourceUtils.readResource((String)url, (ExternalResourceConfig)remoteStore);
            responseJson = new String(response);
        }
        catch (Exception e) {
            if (PDNDConfigUtilities.abortTransaction(false, propertiesReader, context, log)) {
                throw new CoreException(e.getMessage(), (Throwable)e);
            }
            String msgError = "Raccolta informazioni tramite PDND sul client con id '" + clientId + "' fallita: " + e.getMessage();
            log.error(msgError);
        }
        return responseJson;
    }

    public static String readOrganizationId(RemoteStoreConfig remoteConfig, OpenSPCoop2Properties propertiesReader, Map<Object> context, String clientDetails, Logger log) throws CoreException, ProtocolException {
        String jsonPath = ModIUtils.extractInfoFromMetadati((java.util.Map)remoteConfig.getMetadati(), (String)"api-pdnd-clients-organizationJsonPath", (String)"Clients organization json path");
        boolean readErrorAbortTransaction = PDNDConfigUtilities.abortTransaction(true, propertiesReader, context, log);
        return PDNDConfigUtilities.readOrganizationId(jsonPath, readErrorAbortTransaction, clientDetails, log);
    }

    public static String readOrganizationId(String jsonPath, boolean readErrorAbortTransaction, String clientDetails, Logger log) throws CoreException {
        if (clientDetails != null) {
            try {
                return JsonPathExpressionEngine.extractAndConvertResultAsString((String)clientDetails, (String)jsonPath, (Logger)log);
            }
            catch (Exception e) {
                if (readErrorAbortTransaction) {
                    throw new CoreException(e.getMessage(), (Throwable)e);
                }
                String msgError = "Estrazione identificativo organizzazione tramite jsonPath '" + jsonPath + "' fallita (clientDetails: " + clientDetails + "): " + e.getMessage();
                log.error(msgError);
            }
        }
        return null;
    }

    public static String readOrganizationDetails(RemoteStoreConfig remoteStore, OpenSPCoop2Properties propertiesReader, Map<Object> context, String organizationId, Logger log) throws CoreException {
        String responseJson = null;
        try {
            String url = PDNDConfigUtilities.buildUrlOrganizationId(remoteStore, organizationId);
            byte[] response = ExternalResourceUtils.readResource((String)url, (ExternalResourceConfig)remoteStore);
            responseJson = new String(response);
        }
        catch (Exception e) {
            if (PDNDConfigUtilities.abortTransaction(true, propertiesReader, context, log)) {
                throw new CoreException(e.getMessage(), (Throwable)e);
            }
            String msgError = "Raccolta informazioni tramite PDND sull'organizzazione con id '" + organizationId + "' fallita: " + e.getMessage();
            log.error(msgError);
        }
        return responseJson;
    }

    private static boolean abortTransaction(boolean organization, OpenSPCoop2Properties propertiesReader, Map<Object> context, Logger log) throws CoreException {
        Object o;
        boolean abort = organization ? propertiesReader.isGestoreChiaviPDNDorganizationsErrorAbortTransaction() : propertiesReader.isGestoreChiaviPDNDclientsErrorAbortTransaction();
        RequestInfo requestInfo = null;
        if (context != null && context.containsKey(Costanti.REQUEST_INFO) && (o = context.get(Costanti.REQUEST_INFO)) instanceof RequestInfo) {
            requestInfo = (RequestInfo)o;
        }
        if (requestInfo != null && requestInfo.getProtocolContext() != null && requestInfo.getProtocolContext().getInterfaceName() != null && StringUtils.isNotEmpty((String)requestInfo.getProtocolContext().getInterfaceName())) {
            IDPortaApplicativa idPA = new IDPortaApplicativa();
            idPA.setNome(requestInfo.getProtocolContext().getInterfaceName());
            try {
                PortaApplicativa pa = ConfigurazionePdDManager.getInstance().getPortaApplicativaSafeMethod(idPA, requestInfo);
                if (pa != null && pa.sizeProprieta() > 0) {
                    abort = organization ? CostantiProprieta.isPdndReadByApiInteropOrganizationFailedAbortTransaction(pa.getProprieta(), abort) : CostantiProprieta.isPdndReadByApiInteropClientFailedAbortTransaction(pa.getProprieta(), abort);
                }
            }
            catch (Exception e) {
                log.error("Accesso porta applicativa [" + requestInfo.getProtocolContext().getInterfaceName() + "] fallito: " + e.getMessage(), (Throwable)e);
            }
        }
        return abort;
    }
}

