/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.config;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.config.AccessoRegistro;
import org.openspcoop2.core.config.AccessoRegistroRegistro;
import org.openspcoop2.core.config.Configurazione;
import org.openspcoop2.core.config.GenericProperties;
import org.openspcoop2.core.config.InoltroBusteNonRiscontrate;
import org.openspcoop2.core.config.MessaggiDiagnostici;
import org.openspcoop2.core.config.Openspcoop2;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.Soggetto;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.constants.RegistroTipo;
import org.openspcoop2.core.config.constants.Severita;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.config.driver.IDriverConfigurazioneCRUD;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.config.utils.CleanerOpenSPCoop2Extensions;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicy;
import org.openspcoop2.core.controllo_traffico.ConfigurazionePolicy;
import org.openspcoop2.core.controllo_traffico.IdActivePolicy;
import org.openspcoop2.core.controllo_traffico.IdPolicy;
import org.openspcoop2.core.controllo_traffico.utils.serializer.JaxbDeserializer;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.plugins.IdPlugin;
import org.openspcoop2.core.plugins.Plugin;
import org.openspcoop2.core.plugins.dao.IPluginService;
import org.openspcoop2.core.plugins.dao.jdbc.JDBCServiceManager;
import org.openspcoop2.core.plugins.utils.XMLUtils;
import org.openspcoop2.core.registry.RegistroServizi;
import org.openspcoop2.core.registry.constants.StatiAccordo;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.IDriverRegistroServiziCRUD;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.core.registry.driver.utils.XMLDataConverter;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.pdd.config.ConfigurazionePdDReader;
import org.openspcoop2.pdd.config.Document;
import org.openspcoop2.pdd.config.PreloadingConfiguration;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.registry.RegistroServiziReader;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.utils.ModIUtils;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.beans.WriteToSerializerType;
import org.openspcoop2.utils.io.ZipUtilities;
import org.openspcoop2.utils.regexp.RegExpException;
import org.openspcoop2.utils.regexp.RegExpNotFoundException;
import org.openspcoop2.utils.regexp.RegExpNotValidException;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.slf4j.Logger;
import org.w3c.dom.Element;

public class PreLoadingConfig {
    private static final String SOGGETTO_LOCALE = "@SOGGETTO_LOCALE@";
    private static final String GOVWAY_ENTITY_NAME = "GOVWAY_DEFAULT_ENTITY_NAME";
    private static final String VARIABLE_GOVWAY_ENTITY_NAME = "${GOVWAY_DEFAULT_ENTITY_NAME}";
    private Logger log;
    private Logger logDriver;
    private String protocolloDefault;
    private IDSoggetto dominio;
    private static final String PRELOADING_PREFIX = "PreLoading ";
    private static final String ID_PLUGIN = "Plugin";
    private static final String ID_REGISTRY = "Registry";
    private static final String ID_CONFIG = "Config";
    private static final String ID_CONTROLLO_TRAFFICO_CONFIG_POLICY = "ControlloTraffico ConfigPolicy";
    private static final String ID_CONTROLLO_TRAFFICO_ACTIVE_POLICY = "ControlloTraffico ActivePolicy";

    public PreLoadingConfig(Logger log, Logger logDriver, String protocolloDefault, IDSoggetto dominio) {
        this.log = log;
        this.logDriver = logDriver;
        this.protocolloDefault = protocolloDefault;
        this.dominio = dominio;
    }

    public Logger getLogDriver() {
        return this.logDriver;
    }

    private void logInfo(String msg) {
        if (this.log != null) {
            this.log.info(msg);
        }
    }

    private void logError(String msg, Exception e) {
        if (this.log != null) {
            this.log.error(msg, (Throwable)e);
        }
    }

    public void loadConfig(List<PreloadingConfiguration> zipContent) throws UtilsException, IOException, DriverConfigurazioneException, ServiceException, NotImplementedException, ProtocolException {
        if (zipContent != null && !zipContent.isEmpty()) {
            for (PreloadingConfiguration bs : zipContent) {
                boolean load = true;
                if (!(!bs.getName().contains("signalHubPDND") || ProtocolFactoryManager.getInstance().existsProtocolFactory("modipa") && ModIUtils.isSignalHubEnabled())) {
                    this.logInfo("Pacchetto '" + bs.getName() + "' non caricato; funzionalit\u00e0 'Signal Hub' non attiva");
                    load = false;
                } else if (!(!bs.getName().contains("tracingPDND") || ProtocolFactoryManager.getInstance().existsProtocolFactory("modipa") && ModIUtils.isTracingPDNDEnabled())) {
                    this.logInfo("Pacchetto '" + bs.getName() + "' non caricato; funzionalit\u00e0 'Tracing PDND' non attiva");
                    load = false;
                }
                if (!load) continue;
                this.loadConfig(bs.getResource());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfig(byte[] zipContent) throws UtilsException, IOException, DriverConfigurazioneException, ServiceException, NotImplementedException {
        ConfigurazionePolicy policy;
        org.openspcoop2.core.plugins.utils.CleanerOpenSPCoop2Extensions cleaner;
        IPluginService service;
        JDBCServiceManager serviceManager;
        DriverConfigurazioneDB driverConfigurazione;
        org.openspcoop2.core.plugins.utils.serializer.JaxbDeserializer deserializerCT;
        ArrayList<String> pluginNameList = new ArrayList<String>();
        ArrayList<byte[]> pluginList = new ArrayList<byte[]>();
        ArrayList<String> configNameList = new ArrayList<String>();
        ArrayList<byte[]> configList = new ArrayList<byte[]>();
        ArrayList<String> registryNameList = new ArrayList<String>();
        ArrayList<byte[]> registryList = new ArrayList<byte[]>();
        ArrayList<String> controllaTrafficoConfigPolicyNameList = new ArrayList<String>();
        ArrayList<byte[]> controllaTrafficoConfigPolicyList = new ArrayList<byte[]>();
        ArrayList<String> controllaTrafficoActivePolicyNameList = new ArrayList<String>();
        ArrayList<byte[]> controllaTrafficoActivePolicyList = new ArrayList<byte[]>();
        HashMap<String, Document> contentList = new HashMap<String, Document>();
        File fTmp = FileSystemUtilities.createTempFile((String)"preLoadConfiguration", (String)".zip");
        try {
            FileSystemUtilities.writeFile((File)fTmp, (byte[])zipContent);
            ZipFile zip = new ZipFile(fTmp);
            Iterator itZip = ZipUtilities.entries((ZipFile)zip, (boolean)true);
            while (itZip.hasNext()) {
                ZipEntry zipEntry = (ZipEntry)itZip.next();
                if (zipEntry.isDirectory()) continue;
                InputStream isZip = zip.getInputStream(zipEntry);
                try {
                    String valueSystemProperty;
                    byte[] bytes = Utilities.getAsByteArray((InputStream)isZip);
                    String sBytes = new String(bytes);
                    if (sBytes.contains(SOGGETTO_LOCALE)) {
                        while (sBytes.contains(SOGGETTO_LOCALE)) {
                            sBytes = sBytes.replace(SOGGETTO_LOCALE, this.dominio.getNome());
                        }
                        bytes = sBytes.getBytes();
                    }
                    if (sBytes.contains(VARIABLE_GOVWAY_ENTITY_NAME) && ((valueSystemProperty = this.convertVariabile(GOVWAY_ENTITY_NAME)) == null || StringUtils.isEmpty((String)valueSystemProperty))) {
                        throw new ServiceException("Una configurazione creata con la variabile '${GOVWAY_DEFAULT_ENTITY_NAME}' richiede la sua definizione come variabile di sistema o java");
                    }
                    String afterVariable = null;
                    try {
                        afterVariable = this.convertVariable(sBytes);
                    }
                    catch (Exception e) {
                        throw new UtilsException(e.getMessage(), (Throwable)e);
                    }
                    if (afterVariable != null && !afterVariable.equals(sBytes)) {
                        bytes = afterVariable.getBytes();
                    }
                    try {
                        String entryName = zipEntry.getName();
                        int indexOfWsdl = -1;
                        String name = null;
                        if (entryName.endsWith("InterfacciaConcettuale.wsdl")) {
                            indexOfWsdl = entryName.indexOf("InterfacciaConcettuale.wsdl");
                            name = "InterfacciaConcettuale.wsdl";
                        } else if (entryName.endsWith("InterfacciaLogicaErogatore.wsdl")) {
                            indexOfWsdl = entryName.indexOf("InterfacciaLogicaErogatore.wsdl");
                            name = "InterfacciaLogicaErogatore.wsdl";
                        } else if (entryName.endsWith("InterfacciaLogicaFruitore.wsdl")) {
                            indexOfWsdl = entryName.indexOf("InterfacciaLogicaFruitore.wsdl");
                            name = "InterfacciaLogicaFruitore.wsdl";
                        }
                        if (indexOfWsdl > 0) {
                            String prefixEntryName = entryName.substring(0, indexOfWsdl - 1);
                            int posizione = 0;
                            if (prefixEntryName.contains(".") && !prefixEntryName.endsWith(".")) {
                                String posizioneEntry = prefixEntryName.substring(prefixEntryName.lastIndexOf(".") + 1, prefixEntryName.length());
                                posizione = this.converPosizione(posizioneEntry);
                                prefixEntryName = prefixEntryName.substring(0, prefixEntryName.lastIndexOf("."));
                            }
                            Document d = new Document();
                            d.content = bytes;
                            d.index = posizione;
                            d.name = name;
                            contentList.put(prefixEntryName, d);
                            continue;
                        }
                        Element element = MessageXMLUtils.DEFAULT.newElement(bytes);
                        if (XMLUtils.isPlugin((Element)element)) {
                            pluginNameList.add(entryName);
                            pluginList.add(bytes);
                            continue;
                        }
                        if (org.openspcoop2.core.config.utils.XMLUtils.isConfigurazione((Element)element)) {
                            configNameList.add(entryName);
                            configList.add(bytes);
                            continue;
                        }
                        if (org.openspcoop2.core.registry.utils.XMLUtils.isRegistroServizi((Element)element)) {
                            registryNameList.add(entryName);
                            registryList.add(bytes);
                            continue;
                        }
                        if (org.openspcoop2.core.controllo_traffico.utils.XMLUtils.isConfigurazionePolicy((Element)element)) {
                            controllaTrafficoConfigPolicyNameList.add(entryName);
                            controllaTrafficoConfigPolicyList.add(bytes);
                            continue;
                        }
                        if (org.openspcoop2.core.controllo_traffico.utils.XMLUtils.isAttivazionePolicy((Element)element)) {
                            controllaTrafficoActivePolicyNameList.add(entryName);
                            controllaTrafficoActivePolicyList.add(bytes);
                            continue;
                        }
                        throw new UtilsException("unknown type");
                    }
                    catch (Exception e) {
                        this.logError("PreLoading entry [" + zipEntry.getName() + "] error: " + e.getMessage(), e);
                    }
                }
                finally {
                    try {
                        if (isZip == null) continue;
                        isZip.close();
                    }
                    catch (Exception bytes) {}
                }
            }
        }
        finally {
            try {
                Files.delete(fTmp.toPath());
            }
            catch (Exception zip) {}
        }
        if (!pluginNameList.isEmpty()) {
            deserializerCT = new org.openspcoop2.core.plugins.utils.serializer.JaxbDeserializer();
            driverConfigurazione = (DriverConfigurazioneDB)ConfigurazionePdDReader.getDriverConfigurazionePdD();
            Connection con = null;
            try {
                con = driverConfigurazione.getConnection("preloading plugins");
                ServiceManagerProperties jdbcProperties = new ServiceManagerProperties();
                jdbcProperties.setDatabaseType(driverConfigurazione.getTipoDB());
                jdbcProperties.setShowSql(true);
                serviceManager = new JDBCServiceManager(con, jdbcProperties, this.log);
                service = serviceManager.getPluginService();
                cleaner = new org.openspcoop2.core.plugins.utils.CleanerOpenSPCoop2Extensions();
                for (int i = 0; i < pluginNameList.size(); ++i) {
                    String name = (String)pluginNameList.get(i);
                    byte[] content = (byte[])pluginList.get(i);
                    try {
                        this.logInfo(this.getMessageInCorso(ID_PLUGIN, name));
                        Plugin plugin = deserializerCT.readPlugin(content);
                        IdPlugin id = new IdPlugin();
                        id.setClassName(plugin.getClassName());
                        id.setLabel(plugin.getLabel());
                        id.setTipo(plugin.getTipo());
                        id.setTipoPlugin(plugin.getTipoPlugin());
                        if (!service.exists((Object)id)) {
                            cleaner.clean(plugin);
                            service.create((Object)plugin);
                        }
                        this.logInfo(this.getMessageEffettuataConSuccesso(ID_PLUGIN, name));
                        continue;
                    }
                    catch (Exception e) {
                        this.logError(this.getMessageError(ID_PLUGIN, name, e), e);
                    }
                }
            }
            finally {
                driverConfigurazione.releaseConnection(con);
            }
        }
        if (!registryNameList.isEmpty()) {
            org.openspcoop2.core.registry.utils.serializer.JaxbDeserializer deserializerRegistry = new org.openspcoop2.core.registry.utils.serializer.JaxbDeserializer();
            Map mapRegistri = RegistroServiziReader.getDriverRegistroServizi();
            DriverRegistroServiziDB driverRegistroServizi = (DriverRegistroServiziDB)mapRegistri.values().iterator().next();
            for (int i = 0; i < registryNameList.size(); ++i) {
                String name = (String)registryNameList.get(i);
                byte[] content = (byte[])registryList.get(i);
                this.convert(contentList, content, name, deserializerRegistry, driverRegistroServizi);
            }
        }
        if (!configNameList.isEmpty()) {
            org.openspcoop2.core.config.utils.serializer.JaxbDeserializer deserializerConfig = new org.openspcoop2.core.config.utils.serializer.JaxbDeserializer();
            driverConfigurazione = (DriverConfigurazioneDB)ConfigurazionePdDReader.getDriverConfigurazionePdD();
            for (int i = 0; i < configNameList.size(); ++i) {
                String name = (String)configNameList.get(i);
                byte[] content = (byte[])configList.get(i);
                try {
                    this.logInfo(this.getMessageInCorso(ID_CONFIG, name));
                    Openspcoop2 op2 = deserializerConfig.readOpenspcoop2(content);
                    Configurazione config = op2.getConfigurazione();
                    if (config != null && config.getGenericPropertiesList() != null && !config.getGenericPropertiesList().isEmpty()) {
                        for (GenericProperties genericProperties : config.getGenericPropertiesList()) {
                            boolean exists = this.existsGenericProperties(driverConfigurazione, genericProperties);
                            if (exists) continue;
                            driverConfigurazione.createGenericProperties(genericProperties);
                        }
                    }
                    if (op2.sizeSoggettoList() > 0) {
                        this.convert(driverConfigurazione, content, config, op2);
                    }
                    this.logInfo(this.getMessageEffettuataConSuccesso(ID_CONFIG, name));
                    continue;
                }
                catch (Exception e) {
                    this.logError(this.getMessageError(ID_CONFIG, name, e), e);
                }
            }
        }
        if (!controllaTrafficoConfigPolicyNameList.isEmpty()) {
            deserializerCT = new JaxbDeserializer();
            driverConfigurazione = (DriverConfigurazioneDB)ConfigurazionePdDReader.getDriverConfigurazionePdD();
            Connection con = null;
            try {
                con = driverConfigurazione.getConnection("preloading controllaTrafficoConfigPolicies");
                ServiceManagerProperties jdbcProperties = new ServiceManagerProperties();
                jdbcProperties.setDatabaseType(driverConfigurazione.getTipoDB());
                jdbcProperties.setShowSql(true);
                serviceManager = new org.openspcoop2.core.controllo_traffico.dao.jdbc.JDBCServiceManager(con, jdbcProperties, this.log);
                service = serviceManager.getConfigurazionePolicyService();
                cleaner = new org.openspcoop2.core.controllo_traffico.utils.CleanerOpenSPCoop2Extensions();
                for (int i = 0; i < controllaTrafficoConfigPolicyNameList.size(); ++i) {
                    String name = (String)controllaTrafficoConfigPolicyNameList.get(i);
                    byte[] content = (byte[])controllaTrafficoConfigPolicyList.get(i);
                    try {
                        this.logInfo(this.getMessageInCorso(ID_CONTROLLO_TRAFFICO_CONFIG_POLICY, name));
                        policy = deserializerCT.readConfigurazionePolicy(content);
                        IdPolicy id = new IdPolicy();
                        id.setNome(policy.getIdPolicy());
                        if (!service.exists((Object)id)) {
                            cleaner.clean(policy);
                            service.create((Object)policy);
                        }
                        this.logInfo(this.getMessageEffettuataConSuccesso(ID_CONTROLLO_TRAFFICO_CONFIG_POLICY, name));
                        continue;
                    }
                    catch (Exception e) {
                        this.logError(this.getMessageError(ID_CONTROLLO_TRAFFICO_CONFIG_POLICY, name, e), e);
                    }
                }
            }
            finally {
                driverConfigurazione.releaseConnection(con);
            }
        }
        if (!controllaTrafficoActivePolicyNameList.isEmpty()) {
            deserializerCT = new JaxbDeserializer();
            driverConfigurazione = (DriverConfigurazioneDB)ConfigurazionePdDReader.getDriverConfigurazionePdD();
            Connection con = null;
            try {
                con = driverConfigurazione.getConnection("preloading controllaTrafficoActivePolicies");
                ServiceManagerProperties jdbcProperties = new ServiceManagerProperties();
                jdbcProperties.setDatabaseType(driverConfigurazione.getTipoDB());
                jdbcProperties.setShowSql(true);
                serviceManager = new org.openspcoop2.core.controllo_traffico.dao.jdbc.JDBCServiceManager(con, jdbcProperties, this.log);
                service = serviceManager.getAttivazionePolicyService();
                cleaner = new org.openspcoop2.core.controllo_traffico.utils.CleanerOpenSPCoop2Extensions();
                for (int i = 0; i < controllaTrafficoActivePolicyNameList.size(); ++i) {
                    String name = (String)controllaTrafficoActivePolicyNameList.get(i);
                    byte[] content = (byte[])controllaTrafficoActivePolicyList.get(i);
                    try {
                        this.logInfo(this.getMessageInCorso(ID_CONTROLLO_TRAFFICO_ACTIVE_POLICY, name));
                        policy = deserializerCT.readAttivazionePolicy(content);
                        IdActivePolicy id = new IdActivePolicy();
                        id.setNome(policy.getIdActivePolicy());
                        if (!service.exists((Object)id)) {
                            cleaner.clean((AttivazionePolicy)policy);
                            service.create((Object)policy);
                        }
                        this.logInfo(this.getMessageEffettuataConSuccesso(ID_CONTROLLO_TRAFFICO_ACTIVE_POLICY, name));
                        continue;
                    }
                    catch (Exception e) {
                        this.logError(this.getMessageError(ID_CONTROLLO_TRAFFICO_ACTIVE_POLICY, name, e), e);
                    }
                }
            }
            finally {
                driverConfigurazione.releaseConnection(con);
            }
        }
    }

    private int converPosizione(String posizioneEntry) throws UtilsException {
        try {
            return Integer.valueOf(posizioneEntry);
        }
        catch (Exception e) {
            throw new UtilsException("Nome file 'wsdl' con posizione non intera '" + posizioneEntry + "': " + e.getMessage());
        }
    }

    private String convertVariable(String tmp) throws RegExpException, RegExpNotValidException {
        String pattern = "\\$\\{([A-Za-z0-9_]+)\\}";
        List l = null;
        try {
            l = RegularExpressionEngine.getAllStringFindPattern((String)tmp, (String)pattern);
        }
        catch (RegExpNotFoundException regExpNotFoundException) {
            // empty catch block
        }
        return this.convertVariable(l, tmp);
    }

    private String convertVariable(List<String> l, String tmp) {
        if (l != null && !l.isEmpty()) {
            for (String varName : l) {
                String valueSystemProperty = this.convertVariabile(varName);
                if (valueSystemProperty == null) continue;
                String expr = "${" + varName + "}";
                int max = 1000;
                for (int i = 0; tmp.contains(expr) && i < max; ++i) {
                    tmp = tmp.replace(expr, valueSystemProperty);
                }
            }
        }
        return tmp;
    }

    private String convertVariabile(String varName) {
        String valueSystemProperty = System.getenv(varName);
        if (valueSystemProperty == null) {
            valueSystemProperty = System.getProperty(varName);
        }
        return valueSystemProperty;
    }

    private String getMessageInCorso(String type, String name) {
        return PRELOADING_PREFIX + type + " [" + name + "] ...";
    }

    private String getMessageEffettuataConSuccesso(String type, String name) {
        return PRELOADING_PREFIX + type + " [" + name + "] effettuato con successo";
    }

    private String getMessageError(String type, String name, Exception e) {
        return PRELOADING_PREFIX + type + " [" + name + "] failed: " + e.getMessage();
    }

    private UtilsException getUtilsExceptionDocumentoNonAssociabileApi(Document d, RegistroServizi registry) {
        return new UtilsException("Documento '" + d.name + "' non associabile all'Api; la posizione indicata '" + d.index + "' \u00e8 maggiore delle api disponibili '" + registry.sizeAccordoServizioParteComuneList() + "'");
    }

    private void convert(HashMap<String, Document> contentList, byte[] content, String name, org.openspcoop2.core.registry.utils.serializer.JaxbDeserializer deserializerRegistry, DriverRegistroServiziDB driverRegistroServizi) {
        try {
            this.logInfo(this.getMessageInCorso(ID_REGISTRY, name));
            RegistroServizi registry = deserializerRegistry.readRegistroServizi(content);
            this.setContent(contentList, name, registry);
            this.convert(registry, driverRegistroServizi);
            this.logInfo(this.getMessageEffettuataConSuccesso(ID_REGISTRY, name));
        }
        catch (Exception e) {
            this.logError(this.getMessageError(ID_REGISTRY, name, e), e);
        }
    }

    private void setContent(HashMap<String, Document> contentList, String name, RegistroServizi registry) throws UtilsException {
        if (contentList != null && contentList.containsKey(name)) {
            Document d = contentList.get(name);
            if ("InterfacciaConcettuale.wsdl".equals(d.name)) {
                if (registry.sizeAccordoServizioParteComuneList() <= d.index) {
                    throw this.getUtilsExceptionDocumentoNonAssociabileApi(d, registry);
                }
                registry.getAccordoServizioParteComune(d.index).setByteWsdlConcettuale(d.content);
            } else if ("InterfacciaLogicaErogatore.wsdl".equals(d.name)) {
                if (registry.sizeAccordoServizioParteComuneList() <= d.index) {
                    throw this.getUtilsExceptionDocumentoNonAssociabileApi(d, registry);
                }
                registry.getAccordoServizioParteComune(d.index).setByteWsdlLogicoErogatore(d.content);
            } else if ("InterfacciaLogicaFruitore.wsdl".equals(d.name)) {
                if (registry.sizeAccordoServizioParteComuneList() <= d.index) {
                    throw this.getUtilsExceptionDocumentoNonAssociabileApi(d, registry);
                }
                registry.getAccordoServizioParteComune(d.index).setByteWsdlLogicoFruitore(d.content);
            }
        }
    }

    private void convert(RegistroServizi registry, DriverRegistroServiziDB driverRegistroServizi) throws DriverRegistroServiziException {
        String superUser = null;
        XMLDataConverter xmlDataConverter = new XMLDataConverter(registry, (IDriverRegistroServiziCRUD)driverRegistroServizi, CostantiConfigurazione.REGISTRO_DB.getValue(), superUser, this.protocolloDefault, this.log, this.log);
        boolean reset = false;
        boolean mantieniFruitoriEsistenti = true;
        boolean aggiornamentoSoggetti = false;
        boolean updateEnabled = false;
        xmlDataConverter.convertXML(reset, mantieniFruitoriEsistenti, aggiornamentoSoggetti, StatiAccordo.operativo, updateEnabled);
    }

    private boolean existsGenericProperties(DriverConfigurazioneDB driverConfigurazione, GenericProperties genericProperties) throws DriverConfigurazioneException {
        try {
            return driverConfigurazione.getGenericProperties(genericProperties.getTipologia(), genericProperties.getNome()) != null;
        }
        catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
            return false;
        }
    }

    private void convert(DriverConfigurazioneDB driverConfigurazione, byte[] content, Configurazione config, Openspcoop2 op2) throws UtilsException, DriverConfigurazioneException {
        byte[] contentXml = content;
        if (config == null) {
            op2.setConfigurazione(new Configurazione());
            op2.getConfigurazione().setAccessoRegistro(new AccessoRegistro());
            AccessoRegistroRegistro registro = new AccessoRegistroRegistro();
            registro.setTipo(RegistroTipo.DB);
            registro.setNome("dummy");
            registro.setLocation("dummy");
            op2.getConfigurazione().getAccessoRegistro().addRegistro(registro);
            op2.getConfigurazione().setInoltroBusteNonRiscontrate(new InoltroBusteNonRiscontrate());
            op2.getConfigurazione().getInoltroBusteNonRiscontrate().setCadenza("1");
            op2.getConfigurazione().setMessaggiDiagnostici(new MessaggiDiagnostici());
            op2.getConfigurazione().getMessaggiDiagnostici().setSeverita(Severita.INFO_INTEGRATION);
            op2.getConfigurazione().getMessaggiDiagnostici().setSeveritaLog4j(Severita.INFO_INTEGRATION);
            CleanerOpenSPCoop2Extensions cleaner = new CleanerOpenSPCoop2Extensions();
            cleaner.clean(op2.getConfigurazione());
            for (Soggetto soggettoConfig : op2.getSoggettoList()) {
                cleaner.clean(soggettoConfig);
                for (PortaDelegata pdConfig : soggettoConfig.getPortaDelegataList()) {
                    cleaner.clean(pdConfig);
                }
                for (PortaApplicativa paConfig : soggettoConfig.getPortaApplicativaList()) {
                    cleaner.clean(paConfig);
                }
                for (ServizioApplicativo saConfig : soggettoConfig.getServizioApplicativoList()) {
                    cleaner.clean(saConfig);
                }
            }
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            op2.writeTo((OutputStream)bout, WriteToSerializerType.XML_JAXB);
            contentXml = bout.toByteArray();
        }
        boolean udpateConfigurazioneDisabled = false;
        boolean tabellaSoggettiCondivisaPddRegserv = true;
        String superUser = null;
        org.openspcoop2.core.config.driver.utils.XMLDataConverter xmlDataConverter = new org.openspcoop2.core.config.driver.utils.XMLDataConverter(contentXml, (IDriverConfigurazioneCRUD)driverConfigurazione, "db", udpateConfigurazioneDisabled, tabellaSoggettiCondivisaPddRegserv, superUser, this.protocolloDefault, this.log, this.log);
        boolean reset = false;
        boolean aggiornamentoSoggetti = false;
        boolean createMappingErogazioneFruizione = true;
        boolean updateEnabled = false;
        xmlDataConverter.convertXML(reset, aggiornamentoSoggetti, createMappingErogazioneFruizione, updateEnabled);
    }
}

