/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.config;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Session;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.IMonitoraggioRisorsa;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.pdd.config.JMSObject;
import org.openspcoop2.pdd.config.OpenSPCoop2ConfigurationException;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.Resource;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.resources.GestoreJNDI;

public class QueueManager
implements IMonitoraggioRisorsa {
    private static final String ID_MODULO = "QueueManager";
    private static Queue queueRicezioneContenutiApplicativi;
    private static Queue queueRicezioneBuste;
    private static Queue queueImbustamento;
    private static Queue queueImbustamentoRisposte;
    private static Queue queueSbustamento;
    private static Queue queueSbustamentoRisposte;
    private static Queue queueInoltroBuste;
    private static Queue queueInoltroRisposte;
    private static Queue queueConsegnaContenutiApplicativi;
    private static OpenSPCoop2Properties openspcoopProperties;
    protected static Map<String, Resource> risorseInGestione;
    private static QueueManager manager;
    private ConnectionFactory qcf = null;
    private MsgDiagnostico msgDiag = MsgDiagnostico.newInstance("WrapperQueueManager");

    public static String[] getStatoRisorse() {
        String[] sNull = null;
        Resource[] o = risorseInGestione.values().toArray(new Resource[0]);
        if (!(o instanceof Resource[])) {
            return sNull;
        }
        Resource[] resources = o;
        if (resources.length <= 0) {
            return sNull;
        }
        String[] r = new String[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            Resource rr = resources[i];
            r[i] = rr.getIdentificativoPorta() + "." + rr.getModuloFunzionale();
            if (rr.getIdTransazione() != null) {
                r[i] = r[i] + "." + rr.getIdTransazione();
            }
            r[i] = r[i] + " (" + rr.getDate().toString() + ")";
        }
        return r;
    }

    public static void initialize(String jndiName, Properties contextFactory) throws OpenSPCoop2ConfigurationException {
        manager = new QueueManager(jndiName, contextFactory);
    }

    public static void initializeQueueNodeReceiver(Properties contextQueue) throws UtilsException {
        Map<String, String> nomiJndi = OpenSPCoop2Properties.getInstance().getJNDIQueueName(true, false);
        GestoreJNDI jndiQueue = new GestoreJNDI(contextQueue);
        queueRicezioneContenutiApplicativi = (Queue)jndiQueue.lookup(nomiJndi.get("RicezioneContenutiApplicativi"));
        queueRicezioneBuste = (Queue)jndiQueue.lookup(nomiJndi.get("RicezioneBuste"));
    }

    public static void initializeQueueNodeSender(Properties contextQueue) throws UtilsException {
        Map<String, String> nomiJndi = OpenSPCoop2Properties.getInstance().getJNDIQueueName(false, true);
        GestoreJNDI jndiQueue = new GestoreJNDI(contextQueue);
        queueImbustamento = (Queue)jndiQueue.lookup(nomiJndi.get("Imbustamento"));
        queueImbustamentoRisposte = (Queue)jndiQueue.lookup(nomiJndi.get("ImbustamentoRisposte"));
        queueSbustamento = (Queue)jndiQueue.lookup(nomiJndi.get("Sbustamento"));
        queueSbustamentoRisposte = (Queue)jndiQueue.lookup(nomiJndi.get("SbustamentoRisposte"));
        queueInoltroBuste = (Queue)jndiQueue.lookup(nomiJndi.get("InoltroBuste"));
        queueInoltroRisposte = (Queue)jndiQueue.lookup(nomiJndi.get("InoltroRisposte"));
        queueConsegnaContenutiApplicativi = (Queue)jndiQueue.lookup(nomiJndi.get("ConsegnaContenutiApplicativi"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QueueManager getInstance() {
        if (manager == null) {
            Class<QueueManager> clazz = QueueManager.class;
            synchronized (QueueManager.class) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return manager;
            }
        }
        return manager;
    }

    public Queue getQueue(String idNodo) {
        if (idNodo.startsWith("RicezioneContenutiApplicativi")) {
            return queueRicezioneContenutiApplicativi;
        }
        if (idNodo.startsWith("RicezioneBuste")) {
            return queueRicezioneBuste;
        }
        if ("Imbustamento".equals(idNodo)) {
            return queueImbustamento;
        }
        if ("ImbustamentoRisposte".equals(idNodo)) {
            return queueImbustamentoRisposte;
        }
        if ("Sbustamento".equals(idNodo)) {
            return queueSbustamento;
        }
        if ("SbustamentoRisposte".equals(idNodo)) {
            return queueSbustamentoRisposte;
        }
        if ("InoltroBuste".equals(idNodo)) {
            return queueInoltroBuste;
        }
        if ("InoltroRisposte".equals(idNodo)) {
            return queueInoltroRisposte;
        }
        if ("ConsegnaContenutiApplicativi".equals(idNodo)) {
            return queueConsegnaContenutiApplicativi;
        }
        return null;
    }

    private QueueManager(String jndiName, Properties context) throws OpenSPCoop2ConfigurationException {
        try {
            GestoreJNDI jndi = new GestoreJNDI(context);
            this.qcf = (ConnectionFactory)jndi.lookup(jndiName);
        }
        catch (Exception e) {
            throw new OpenSPCoop2ConfigurationException("WrapperQueueManager: " + e.getMessage(), e);
        }
    }

    public Resource getResource(IDSoggetto idPDD, String modulo, String idTransazione) throws OpenSPCoop2ConfigurationException {
        Resource risorsa = new Resource();
        try {
            Connection con = this.qcf.createConnection();
            QueueManager.checkConnection(con);
            Session s = con.createSession(false, openspcoopProperties.getAcknowledgeModeSessioneConnectionFactory());
            if (s == null) {
                con.close();
                throw new OpenSPCoop2ConfigurationException("SessioneNonDisponibile");
            }
            JMSObject jms = new JMSObject();
            jms.setConnection(con);
            jms.setSession(s);
            String idUnivoco = Resource.generaIdentificatoreUnivoco(idPDD, modulo);
            risorsa.setId(idUnivoco);
            risorsa.setDate(DateManager.getDate());
            risorsa.setIdentificativoPorta(idPDD);
            risorsa.setModuloFunzionale(modulo);
            risorsa.setResource(jms);
            risorsa.setResourceType(JMSObject.class.getName());
            risorsa.setIdTransazione(idTransazione);
            risorseInGestione.put(idUnivoco, risorsa);
            return risorsa;
        }
        catch (Exception e) {
            this.msgDiag.aggiornaFiltri();
            this.msgDiag.setDominio(idPDD);
            this.msgDiag.setFunzione("QueueManager." + modulo);
            this.msgDiag.logFatalError(e, "Richiesta connessione al QueueManager");
            throw new OpenSPCoop2ConfigurationException("getJMSObject: " + e.getMessage());
        }
    }

    private static void checkConnection(Connection con) throws OpenSPCoop2ConfigurationException {
        if (con == null) {
            throw new OpenSPCoop2ConfigurationException("ConnessioneNonDisponibile");
        }
    }

    public void releaseResource(IDSoggetto idPDD, String modulo, Resource resource) throws OpenSPCoop2ConfigurationException {
        try {
            if (resource != null) {
                if (resource.getResource() != null) {
                    JMSObject jms = (JMSObject)resource.getResource();
                    if (jms == null) {
                        throw new OpenSPCoop2ConfigurationException("PassivateObject[JMSObjectNull]");
                    }
                    if (jms.getConnection() == null) {
                        throw new OpenSPCoop2ConfigurationException("PassivateObject[ConnectionNull]");
                    }
                    if (jms.getSession() == null) {
                        throw new OpenSPCoop2ConfigurationException("PassivateObject[SessionNull]");
                    }
                    this.close(jms);
                }
                if (risorseInGestione.containsKey(resource.getId())) {
                    risorseInGestione.remove(resource.getId());
                }
            }
        }
        catch (Exception e) {
            this.msgDiag.aggiornaFiltri();
            this.msgDiag.setDominio(idPDD);
            this.msgDiag.setFunzione("QueueManager." + modulo);
            this.msgDiag.logFatalError(e, "Rilasciata connessione al QueueManager");
            throw new OpenSPCoop2ConfigurationException("releaseJMSObject: " + e.getMessage());
        }
    }

    private void close(JMSObject jms) throws JMSException {
        try {
            jms.getSession().close();
        }
        catch (Exception e) {
            jms.getConnection().close();
            throw e;
        }
        jms.getConnection().close();
    }

    public void isAlive() throws CoreException {
        Resource resource = null;
        IDSoggetto idSoggettAlive = new IDSoggetto();
        idSoggettAlive.setCodicePorta(ID_MODULO);
        idSoggettAlive.setTipo(ID_MODULO);
        idSoggettAlive.setNome(ID_MODULO);
        try {
            resource = this.getResource(idSoggettAlive, "CheckIsAlive", null);
            if (resource == null) {
                throw new CoreException("Resource is null");
            }
            if (resource.getResource() == null) {
                throw new CoreException("JMSObject is null");
            }
            JMSObject jmsObject = (JMSObject)resource.getResource();
            if (jmsObject.getConnection() == null) {
                throw new CoreException("Connessione is null");
            }
            if (jmsObject.getSession() == null) {
                throw new CoreException("Sessione is null");
            }
            Connection connectionJMS = jmsObject.getConnection();
            connectionJMS.getClientID();
        }
        catch (Exception e) {
            throw new CoreException("Connessione al broker JMS non disponibile: " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                this.releaseResource(idSoggettAlive, "CheckIsAlive", resource);
            }
            catch (Exception exception) {}
        }
    }

    static {
        openspcoopProperties = OpenSPCoop2Properties.getInstance();
        risorseInGestione = new ConcurrentHashMap<String, Resource>();
        manager = null;
    }
}

