/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.soap.SOAPBody;
import org.openspcoop2.core.config.GestioneErrore;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaApplicativaServizioApplicativo;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.constants.TipoBehaviour;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.eccezione.details.DettaglioEccezione;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.integrazione.EsitoRichiesta;
import org.openspcoop2.core.integrazione.utils.EsitoRichiestaXMLUtils;
import org.openspcoop2.core.transazioni.IdTransazioneApplicativoServer;
import org.openspcoop2.core.transazioni.TransazioneApplicativoServer;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2MessageParseResult;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.exception.ParseException;
import org.openspcoop2.message.utils.MessageUtilities;
import org.openspcoop2.pdd.config.ClassNameProperties;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.RichiestaApplicativa;
import org.openspcoop2.pdd.config.RichiestaDelegata;
import org.openspcoop2.pdd.config.SoggettoVirtuale;
import org.openspcoop2.pdd.core.AbstractCore;
import org.openspcoop2.pdd.core.CostantiPdD;
import org.openspcoop2.pdd.core.EJBUtilsConsegnaException;
import org.openspcoop2.pdd.core.EJBUtilsException;
import org.openspcoop2.pdd.core.EJBUtilsMessaggioInConsegna;
import org.openspcoop2.pdd.core.EJBUtilsMessaggioInConsegnaEsito;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.core.JMSSender;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.behaviour.Behaviour;
import org.openspcoop2.pdd.core.behaviour.BehaviourForwardTo;
import org.openspcoop2.pdd.core.behaviour.BehaviourForwardToConfiguration;
import org.openspcoop2.pdd.core.behaviour.BehaviourForwardToFilter;
import org.openspcoop2.pdd.core.behaviour.BehaviourLoadBalancer;
import org.openspcoop2.pdd.core.behaviour.BehaviourLoader;
import org.openspcoop2.pdd.core.behaviour.IBehaviour;
import org.openspcoop2.pdd.core.behaviour.StatoFunzionalita;
import org.openspcoop2.pdd.core.behaviour.built_in.multi_deliver.ConfigurazioneGestioneConsegnaNotifiche;
import org.openspcoop2.pdd.core.behaviour.built_in.multi_deliver.GestioneConsegnaNotificheUtils;
import org.openspcoop2.pdd.core.behaviour.built_in.multi_deliver.MessaggioDaNotificare;
import org.openspcoop2.pdd.core.behaviour.built_in.multi_deliver.MultiDeliverBehaviour;
import org.openspcoop2.pdd.core.behaviour.built_in.multi_deliver.MultiDeliverUtils;
import org.openspcoop2.pdd.core.handlers.HandlerException;
import org.openspcoop2.pdd.core.node.INodeSender;
import org.openspcoop2.pdd.core.state.IOpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateless;
import org.openspcoop2.pdd.core.transazioni.GestoreConsegnaMultipla;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.mdb.ConsegnaContenutiApplicativi;
import org.openspcoop2.pdd.mdb.ConsegnaContenutiApplicativiBehaviourMessage;
import org.openspcoop2.pdd.mdb.ConsegnaContenutiApplicativiMessage;
import org.openspcoop2.pdd.mdb.EsitoLib;
import org.openspcoop2.pdd.mdb.InoltroRisposteMessage;
import org.openspcoop2.pdd.services.ServicesUtils;
import org.openspcoop2.pdd.services.core.RicezioneBusteMessage;
import org.openspcoop2.pdd.services.core.RicezioneContenutiApplicativiMessage;
import org.openspcoop2.pdd.services.error.AbstractErrorGenerator;
import org.openspcoop2.pdd.services.error.RicezioneBusteExternalErrorGenerator;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.builder.DettaglioEccezioneOpenSPCoop2Builder;
import org.openspcoop2.protocol.engine.builder.Imbustamento;
import org.openspcoop2.protocol.engine.driver.RepositoryBuste;
import org.openspcoop2.protocol.engine.driver.RollbackRepositoryBuste;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.Eccezione;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.Integrazione;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.config.IProtocolVersionManager;
import org.openspcoop2.protocol.sdk.config.ITraduttore;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.ErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.ErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroriCooperazione;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.state.StateMessage;
import org.openspcoop2.protocol.sdk.state.StatelessMessage;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.MapKey;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.id.UniqueIdentifierManager;
import org.openspcoop2.utils.resources.Loader;
import org.slf4j.Logger;

public class EJBUtils {
    private Logger log = null;
    private IOpenSPCoopState openSPCoopState;
    private String idModulo = null;
    private TipoPdD tipoPdD;
    private IDSoggetto identitaPdD = null;
    private String idSessione;
    private String idMessage;
    private String tipo;
    private String scenarioCooperazione;
    private MsgDiagnostico msgDiag;
    private volatile boolean oneWayVersione11 = false;
    private volatile boolean portaDiTipoStateless_esclusoOneWay11;
    private volatile boolean rollbackRichiestaInCasoErrore = true;
    private volatile boolean rollbackRichiestaInCasoErrore_rollbackHistory = true;
    private volatile boolean routing;
    private OpenSPCoop2Properties propertiesReader;
    private ConfigurazionePdDManager configurazionePdDReader;
    private boolean functionAsRouter = false;
    private Timestamp spedizioneMsgIngresso;
    private Timestamp ricezioneMsgRisposta;
    private volatile boolean replyOnNewConnection;
    private volatile boolean utilizzoIndirizzoTelematico;
    private String implementazionePdDSoggettoMittente;
    private String implementazionePdDSoggettoDestinatario;
    private String servizioApplicativoErogatore;
    private PdDContext pddContext;
    private String oldFunctionName;
    private INodeSender nodeSender = null;
    private IProtocolFactory<?> protocolFactory = null;
    private IProtocolVersionManager protocolManager = null;
    private DettaglioEccezioneOpenSPCoop2Builder dettaglioBuilder = null;
    private RicezioneBusteExternalErrorGenerator generatoreErrorePortaApplicativa = null;
    private IntegrationFunctionError _integrationFunctionErrorPortaApplicativa;
    private volatile boolean gestioneStatelessConIntegrationManager = false;
    private volatile boolean gestioneSolamenteConIntegrationManager = false;

    public void setPddContext(PdDContext pddContext) {
        this.pddContext = pddContext;
    }

    private IntegrationFunctionError getIntegrationFunctionErrorPortaApplicativa(boolean erroreValidazione) {
        if (this._integrationFunctionErrorPortaApplicativa != null) {
            return this._integrationFunctionErrorPortaApplicativa;
        }
        IntegrationFunctionError ife = AbstractErrorGenerator.getIntegrationInternalError(this.pddContext);
        if (erroreValidazione) {
            ife = IntegrationFunctionError.INTERNAL_RESPONSE_ERROR.equals((Object)ife) ? IntegrationFunctionError.INVALID_INTEROPERABILITY_PROFILE_RESPONSE : IntegrationFunctionError.INVALID_INTEROPERABILITY_PROFILE_REQUEST;
        }
        return ife;
    }

    public void setGeneratoreErrorePortaApplicativa(RicezioneBusteExternalErrorGenerator generatoreErrorePortaApplicativa) {
        this.generatoreErrorePortaApplicativa = generatoreErrorePortaApplicativa;
    }

    public void setIntegrationFunctionErrorPortaApplicativa(IntegrationFunctionError integrationErrorPortaApplicativa) {
        this._integrationFunctionErrorPortaApplicativa = integrationErrorPortaApplicativa;
    }

    public synchronized void initializeNodeSender(OpenSPCoop2Properties propertiesReader, Logger logCore) throws EJBUtilsException {
        if (this.nodeSender != null) {
            return;
        }
        String classTypeNodeSender = null;
        try {
            classTypeNodeSender = ClassNameProperties.getInstance().getNodeSender(propertiesReader.getNodeSender());
            this.nodeSender = (INodeSender)Loader.getInstance().newInstance(classTypeNodeSender);
            AbstractCore.init(this.nodeSender, this.pddContext, this.protocolFactory, new Object[0]);
            logCore.info("Inizializzazione gestore NodeSender di tipo " + classTypeNodeSender + " effettuata.");
        }
        catch (Exception e) {
            throw new EJBUtilsException("Riscontrato errore durante il caricamento della classe [" + classTypeNodeSender + "] da utilizzare per la spedizione nell'infrastruttura: " + e.getMessage());
        }
    }

    public INodeSender getNodeSender(OpenSPCoop2Properties propertiesReader, Logger log) throws EJBUtilsException {
        if (this.nodeSender == null) {
            this.initializeNodeSender(propertiesReader, log);
        }
        return this.nodeSender;
    }

    public EJBUtils(IDSoggetto identitaPdD, TipoPdD tipoPdD, String aIDModulo, String idSessione, String idMessage, String tipo, IOpenSPCoopState openspcoop_state, MsgDiagnostico msgDiag, boolean functionAsRouter, String implementazionePdDSoggettoMittente, String implementazionePdDSoggettoDestinatario, String profiloGestione, PdDContext pddContext) throws EJBUtilsException {
        this.identitaPdD = identitaPdD;
        this.tipoPdD = tipoPdD;
        this.idModulo = aIDModulo;
        this.idSessione = idSessione;
        this.idMessage = idMessage;
        this.tipo = tipo;
        this.openSPCoopState = openspcoop_state;
        this.functionAsRouter = functionAsRouter;
        this.log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
        if (this.log == null) {
            this.log = LoggerWrapperFactory.getLogger(EJBUtils.class);
        }
        this.msgDiag = msgDiag;
        this.propertiesReader = OpenSPCoop2Properties.getInstance();
        this.configurazionePdDReader = openspcoop_state == null ? ConfigurazionePdDManager.getInstance() : ConfigurazionePdDManager.getInstance(openspcoop_state.getStatoRichiesta(), openspcoop_state.getStatoRisposta());
        this.implementazionePdDSoggettoMittente = implementazionePdDSoggettoMittente;
        this.implementazionePdDSoggettoDestinatario = implementazionePdDSoggettoDestinatario;
        this.pddContext = pddContext;
        try {
            this.protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)this.pddContext.getObject(Costanti.PROTOCOL_NAME));
            this.protocolManager = this.protocolFactory.createProtocolVersionManager(profiloGestione);
            this.dettaglioBuilder = new DettaglioEccezioneOpenSPCoop2Builder(this.log, this.protocolFactory);
        }
        catch (Exception e) {
            throw new EJBUtilsException(e.getMessage(), e);
        }
        this.initializeNodeSender(this.propertiesReader, this.log);
    }

    public void setIdMessage(String idMessage) {
        this.idMessage = idMessage;
    }

    private void setEJBSuffixFunctionName() {
        if (this.msgDiag != null) {
            this.oldFunctionName = this.msgDiag.getFunzione();
            this.msgDiag.setFunzione(this.msgDiag.getFunzione() + ".EJBUtils");
        }
    }

    private void unsetEJBSuffixFunctionName() {
        if (this.msgDiag != null && this.oldFunctionName != null) {
            this.msgDiag.setFunzione(this.oldFunctionName);
        }
    }

    public void updateOpenSPCoopState(IOpenSPCoopState openSPCoopState) {
        this.openSPCoopState = openSPCoopState;
    }

    public void updateIdSessione(String id) {
        this.idSessione = id;
    }

    public void setReplyOnNewConnection(boolean replyOnNewConnection) {
        this.replyOnNewConnection = replyOnNewConnection;
    }

    public void setUtilizzoIndirizzoTelematico(boolean utilizzoIndirizzoTelematico) {
        this.utilizzoIndirizzoTelematico = utilizzoIndirizzoTelematico;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackMessage(String motivoRollbackEJB, EsitoLib esito) {
        this.setEJBSuffixFunctionName();
        try {
            GestoreMessaggi msg = new GestoreMessaggi(this.openSPCoopState, true, this.idMessage, this.tipo, this.msgDiag, this.pddContext);
            msg.setOneWayVersione11(this.oneWayVersione11);
            msg.aggiornaErroreProcessamentoMessaggio(motivoRollbackEJB, null);
            esito.setErroreProcessamentoMessaggioAggiornato(true);
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "EJBUtils.rollbackMessage(motivoRollbackEJB)");
        }
        finally {
            this.unsetEJBSuffixFunctionName();
        }
    }

    public void rollbackMessage(String motivoRollbackEJB, String servizioApplicativo, EsitoLib esito) {
        this.rollbackMessage(motivoRollbackEJB, servizioApplicativo, esito, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackMessage(String motivoRollbackEJB, String servizioApplicativo, EsitoLib esito, boolean throwExceptionConnectionNull) {
        this.setEJBSuffixFunctionName();
        try {
            GestoreMessaggi msg = new GestoreMessaggi(this.openSPCoopState, true, this.idMessage, this.tipo, this.msgDiag, this.pddContext);
            msg.setOneWayVersione11(this.oneWayVersione11);
            msg.aggiornaErroreProcessamentoMessaggio(motivoRollbackEJB, servizioApplicativo, throwExceptionConnectionNull);
            esito.setErroreProcessamentoMessaggioAggiornato(true);
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "EJBUtils.rollbackMessage(motivoRollbackEJB,servizioApplicativo)");
        }
        finally {
            this.unsetEJBSuffixFunctionName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackMessage(String motivoRollbackEJB, Timestamp dataRiconsegna, String servizioApplicativo, EsitoLib esito) {
        this.setEJBSuffixFunctionName();
        try {
            GestoreMessaggi msg = new GestoreMessaggi(this.openSPCoopState, true, this.idMessage, this.tipo, this.msgDiag, this.pddContext);
            msg.setOneWayVersione11(this.oneWayVersione11);
            msg.aggiornaErroreProcessamentoMessaggio(motivoRollbackEJB, servizioApplicativo);
            esito.setErroreProcessamentoMessaggioAggiornato(true);
            if (dataRiconsegna != null) {
                msg.aggiornaDataRispedizione(dataRiconsegna, servizioApplicativo);
                esito.setDataRispedizioneAggiornata(dataRiconsegna);
            }
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "EJBUtils.rollbackMessage(motivoRollbackEJB,dataRiconsegna,servizioApplicativo)");
        }
        finally {
            this.unsetEJBSuffixFunctionName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackMessage(String motivoRollbackEJB, Timestamp dataRiconsegna, EsitoLib esito) {
        this.setEJBSuffixFunctionName();
        try {
            GestoreMessaggi msg = new GestoreMessaggi(this.openSPCoopState, true, this.idMessage, this.tipo, this.msgDiag, this.pddContext);
            msg.setOneWayVersione11(this.oneWayVersione11);
            msg.aggiornaErroreProcessamentoMessaggio(motivoRollbackEJB, null);
            esito.setErroreProcessamentoMessaggioAggiornato(true);
            if (dataRiconsegna != null) {
                msg.aggiornaDataRispedizione(dataRiconsegna, null);
                esito.setDataRispedizioneAggiornata(dataRiconsegna);
            }
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "EJBUtils.rollbackMessage(motivoRollbackEJB,dataRiconsegna)");
        }
        finally {
            this.unsetEJBSuffixFunctionName();
        }
    }

    public void updateErroreProcessamentoMessage(String motivoRollbackEJB, EsitoLib esito) {
        this.updateErroreProcessamentoMessage(motivoRollbackEJB, null, esito);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateErroreProcessamentoMessage(String motivoRollbackEJB, Timestamp dataRispedizione, EsitoLib esito) {
        this.setEJBSuffixFunctionName();
        try {
            GestoreMessaggi msg = new GestoreMessaggi(this.openSPCoopState, true, this.idMessage, this.tipo, this.msgDiag, this.pddContext);
            msg.setOneWayVersione11(this.oneWayVersione11);
            msg.aggiornaErroreProcessamentoMessaggio(motivoRollbackEJB, null);
            esito.setErroreProcessamentoMessaggioAggiornato(true);
            if (dataRispedizione != null) {
                msg.aggiornaDataRispedizione(dataRispedizione, null);
                esito.setDataRispedizioneAggiornata(dataRispedizione);
            }
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "EJBUtils.updateErroreProcessamentoMessage");
        }
        finally {
            this.unsetEJBSuffixFunctionName();
        }
    }

    public void releaseOutboxMessage(boolean isMessaggioRichiesta) throws EJBUtilsException {
        this.releaseMessage(true, false, null, null, true, isMessaggioRichiesta);
    }

    public void releaseOutboxMessage(boolean cleanHistory, boolean isMessaggioRichiesta) throws EJBUtilsException {
        this.releaseMessage(true, false, null, null, cleanHistory, isMessaggioRichiesta);
    }

    public void releaseOutboxMessage(String tipo, String id, boolean isMessaggioRichiesta) throws EJBUtilsException {
        if (!"INBOX".equals(tipo) && !"OUTBOX".equals(tipo)) {
            throw new EJBUtilsException("EJBUtils.releaseOutboxMessage error: Tipo di Messaggio non definito");
        }
        if (id == null) {
            throw new EJBUtilsException("EJBUtils.releaseOutboxMessage error: ID Messaggio non definito");
        }
        this.releaseMessage(true, false, tipo, id, true, isMessaggioRichiesta);
    }

    public void releaseInboxMessage(boolean isMessaggioRichiesta) throws EJBUtilsException {
        this.releaseMessage(false, true, null, null, true, isMessaggioRichiesta);
    }

    public void releaseInboxMessage(boolean cleanHistory, boolean isMessaggioRichiesta) throws EJBUtilsException {
        this.releaseMessage(false, true, null, null, cleanHistory, isMessaggioRichiesta);
    }

    public void releaseInboxMessage(String tipo, String id, boolean isMessaggioRichiesta) throws EJBUtilsException {
        if (!"INBOX".equals(tipo) && !"OUTBOX".equals(tipo)) {
            throw new EJBUtilsException("EJBUtils.releaseOutboxMessage error: Tipo di Messaggio non definito");
        }
        if (id == null) {
            throw new EJBUtilsException("EJBUtils.releaseOutboxMessage error: ID Messaggio non definito");
        }
        this.releaseMessage(false, true, tipo, id, true, isMessaggioRichiesta);
    }

    private void releaseMessage(boolean rollbackOutbox, boolean rollbackInbox, String tipo, String id, boolean cleanHistory, boolean isMessaggioRichiesta) throws EJBUtilsException {
        StateMessage stateMSG;
        StateMessage stateMessage = stateMSG = isMessaggioRichiesta ? (StateMessage)this.openSPCoopState.getStatoRichiesta() : (StateMessage)this.openSPCoopState.getStatoRisposta();
        if (stateMSG instanceof StatelessMessage && !this.oneWayVersione11) {
            return;
        }
        RollbackRepositoryBuste rollbackBuste = null;
        RollbackRepositoryBuste rollbackBusteRifMessaggio = null;
        GestoreMessaggi msg = null;
        try {
            if (rollbackOutbox) {
                rollbackBuste = new RollbackRepositoryBuste(this.idMessage, (IState)stateMSG, this.oneWayVersione11);
                rollbackBuste.rollbackBustaIntoOutBox(cleanHistory);
            } else if (rollbackInbox) {
                rollbackBuste = new RollbackRepositoryBuste(this.idMessage, (IState)stateMSG, this.oneWayVersione11);
                rollbackBuste.rollbackBustaIntoInBox(cleanHistory);
            }
            if (tipo != null && id != null) {
                rollbackBusteRifMessaggio = new RollbackRepositoryBuste(id, (IState)stateMSG, this.oneWayVersione11);
                if ("OUTBOX".equals(tipo)) {
                    rollbackBusteRifMessaggio.rollbackBustaIntoOutBox();
                } else {
                    rollbackBusteRifMessaggio.rollbackBustaIntoInBox();
                }
            }
            msg = new GestoreMessaggi(this.openSPCoopState, true, this.idMessage, this.tipo, this.msgDiag, this.pddContext);
            msg.setOneWayVersione11(this.oneWayVersione11);
            msg.aggiornaProprietarioMessaggio("GestoreMessaggi");
            this.openSPCoopState.commit();
            String idBustaRichiestaCorrelata = null;
            if (!this.idMessage.equals(this.idSessione)) {
                idBustaRichiestaCorrelata = this.idSessione;
            }
            msg.addProprietariIntoCache_readFromTable("EJBUtils." + this.idModulo, "releaseMessage", idBustaRichiestaCorrelata, this.functionAsRouter);
        }
        catch (Exception e) {
            stateMSG.closePreparedStatement();
            throw new EJBUtilsException("EJBUtils.releaseMessage error: " + e.getMessage(), e);
        }
    }

    public void sendRispostaApplicativaErrore(OpenSPCoop2Message responseMessageError, RichiestaDelegata richiestaDelegata, PortaDelegata pd, ServizioApplicativo sa) throws EJBUtilsException {
        this.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, true, pd, sa);
    }

    public void sendRispostaApplicativaErrore(OpenSPCoop2Message responseMessageError, RichiestaDelegata richiestaDelegata, boolean rollbackRichiesta, PortaDelegata pd, ServizioApplicativo sa) throws EJBUtilsException {
        String idTransazione = (String)this.pddContext.getObject(Costanti.ID_TRANSAZIONE);
        if (this.openSPCoopState instanceof OpenSPCoopStateless) {
            ((OpenSPCoopStateless)this.openSPCoopState).setRispostaMsg(responseMessageError);
        }
        StateMessage statoRichiesta = (StateMessage)this.openSPCoopState.getStatoRichiesta();
        StateMessage statoRisposta = (StateMessage)this.openSPCoopState.getStatoRisposta();
        String correlazioneApplicativa = null;
        if (richiestaDelegata != null) {
            correlazioneApplicativa = richiestaDelegata.getIdCorrelazioneApplicativa();
        }
        String correlazioneApplicativaRisposta = null;
        if (richiestaDelegata != null) {
            correlazioneApplicativaRisposta = richiestaDelegata.getIdCorrelazioneApplicativaRisposta();
        }
        String nomePorta = null;
        if (richiestaDelegata != null && richiestaDelegata.getIdPortaDelegata() != null) {
            nomePorta = richiestaDelegata.getIdPortaDelegata().getNome();
        }
        RollbackRepositoryBuste rollbackBuste = null;
        RollbackRepositoryBuste rollbackBusteRifMessaggio = null;
        GestoreMessaggi msgRequest = null;
        GestoreMessaggi msgResponse = null;
        GestoreMessaggi msgSbloccoRicezioneContenutiApplicativi = null;
        if (richiestaDelegata == null) {
            throw new EJBUtilsException("Param richiestaDelegata is null");
        }
        this.msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_EROGATORE@", richiestaDelegata.getServizioApplicativo());
        this.setEJBSuffixFunctionName();
        try {
            String idModuloInAttesa = richiestaDelegata.getIdModuloInAttesa();
            boolean consegnaRispostaAsincrona = false;
            if (rollbackRichiesta) {
                rollbackBusteRifMessaggio = new RollbackRepositoryBuste(this.idSessione, (IState)statoRichiesta, this.oneWayVersione11);
                rollbackBusteRifMessaggio.rollbackBustaIntoOutBox(this.rollbackRichiestaInCasoErrore_rollbackHistory);
            } else {
                rollbackBusteRifMessaggio = new RollbackRepositoryBuste(this.idSessione, (IState)statoRichiesta, this.oneWayVersione11);
                rollbackBusteRifMessaggio.clearAccessiIntoOutBox(false, false, true);
            }
            if (!this.idSessione.equals(this.idMessage)) {
                rollbackBuste = new RollbackRepositoryBuste(this.idMessage, (IState)statoRichiesta, this.oneWayVersione11);
                rollbackBuste.rollbackBustaIntoInBox();
            }
            msgRequest = new GestoreMessaggi(this.openSPCoopState, true, this.idMessage, this.tipo, this.msgDiag, this.pddContext);
            msgRequest.setOneWayVersione11(this.oneWayVersione11);
            msgRequest.aggiornaProprietarioMessaggio("GestoreMessaggi");
            String idRisposta = null;
            if (consegnaRispostaAsincrona || idModuloInAttesa != null) {
                Imbustamento imbustatore = new Imbustamento(this.log, this.protocolFactory, this.openSPCoopState.getStatoRichiesta());
                idRisposta = imbustatore.buildID(this.identitaPdD, idTransazione, this.propertiesReader.getGestioneSerializableDBAttesaAttiva(), this.propertiesReader.getGestioneSerializableDBCheckInterval(), RuoloMessaggio.RISPOSTA);
                if (idRisposta == null) {
                    throw new Exception("Identificativo non costruito.");
                }
                Timestamp oraRegistrazioneMessaggio = DateManager.getTimestamp();
                msgResponse = new GestoreMessaggi(this.openSPCoopState, false, idRisposta, "INBOX", this.msgDiag, this.pddContext);
                msgResponse.registraMessaggio(responseMessageError, oraRegistrazioneMessaggio, this.saveMessageStateless(pd), correlazioneApplicativa, correlazioneApplicativaRisposta);
                msgResponse.aggiornaRiferimentoMessaggio(this.idSessione);
                if (consegnaRispostaAsincrona) {
                    msgResponse.aggiornaProprietarioMessaggio("ConsegnaContenutiApplicativi");
                } else if (idModuloInAttesa != null) {
                    msgResponse.aggiornaProprietarioMessaggio(idModuloInAttesa);
                }
                boolean servizioApplicativoConConnettore = false;
                boolean getMessageAbilitato = false;
                boolean sbustamentoSoap = false;
                boolean sbustamentoInformazioniProtocollo = true;
                try {
                    servizioApplicativoConConnettore = this.configurazionePdDReader.consegnaRispostaAsincronaConConnettore(sa);
                    getMessageAbilitato = this.configurazionePdDReader.consegnaRispostaAsincronaConGetMessage(sa);
                    sbustamentoSoap = this.configurazionePdDReader.consegnaRispostaAsincronaConSbustamento(sa);
                    sbustamentoInformazioniProtocollo = this.configurazionePdDReader.consegnaRispostaAsincronaConSbustamentoInformazioniProtocollo(sa);
                }
                catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                    // empty catch block
                }
                if (!getMessageAbilitato && !servizioApplicativoConConnettore && idModuloInAttesa == null) {
                    this.msgDiag.logPersonalizzato("consegnaContenutiApplicativi.", "consegnaNonDefinita");
                    return;
                }
                String tipoConsegna = "IntegrationManager";
                if (consegnaRispostaAsincrona) {
                    if (servizioApplicativoConConnettore) {
                        richiestaDelegata.setScenario("ConsegnaContenutiApplicativi");
                        this.sendToConsegnaContenutiApplicativi_rispostaConsegnataModalitaAsincrona(richiestaDelegata, idRisposta, msgResponse);
                        tipoConsegna = "Connettore";
                    } else {
                        this.msgDiag.logPersonalizzato("consegnaContenutiApplicativi.", "integrationManager.messaggioDisponibile");
                    }
                } else if (idModuloInAttesa != null) {
                    this.sendToRicezioneContenutiApplicativi(idModuloInAttesa, idRisposta, richiestaDelegata.getIdCollaborazione(), richiestaDelegata.getProfiloCollaborazione(), richiestaDelegata.getProfiloCollaborazioneValue());
                    tipoConsegna = "ConnectionReply";
                }
                msgResponse.registraDestinatarioMessaggio(richiestaDelegata.getServizioApplicativo(), sbustamentoSoap, sbustamentoInformazioniProtocollo, getMessageAbilitato, tipoConsegna, oraRegistrazioneMessaggio, nomePorta, false, false, null, null, false);
            }
            String idSbloccoRicezioneContenutiApplicativi = null;
            if (consegnaRispostaAsincrona && idModuloInAttesa != null) {
                Imbustamento imbustatore = new Imbustamento(this.log, this.protocolFactory, this.openSPCoopState.getStatoRichiesta());
                idSbloccoRicezioneContenutiApplicativi = imbustatore.buildID(this.identitaPdD, idTransazione, this.propertiesReader.getGestioneSerializableDBAttesaAttiva(), this.propertiesReader.getGestioneSerializableDBCheckInterval(), RuoloMessaggio.RISPOSTA);
                if (idSbloccoRicezioneContenutiApplicativi == null) {
                    throw new Exception("Identificativo non costruito.");
                }
                msgSbloccoRicezioneContenutiApplicativi = new GestoreMessaggi(this.openSPCoopState, false, idSbloccoRicezioneContenutiApplicativi, "INBOX", this.msgDiag, this.pddContext);
                if (this.protocolManager.isHttpEmptyResponseOneWay()) {
                    msgSbloccoRicezioneContenutiApplicativi.registraMessaggio(MessageUtilities.buildEmptyMessage((OpenSPCoop2MessageFactory)responseMessageError.getFactory(), (MessageType)responseMessageError.getMessageType(), (MessageRole)MessageRole.RESPONSE), correlazioneApplicativa, correlazioneApplicativaRisposta);
                } else {
                    msgSbloccoRicezioneContenutiApplicativi.registraMessaggio(this.buildOpenSPCoopOK(responseMessageError.getMessageType(), this.idSessione), correlazioneApplicativa, correlazioneApplicativaRisposta);
                }
                msgSbloccoRicezioneContenutiApplicativi.aggiornaRiferimentoMessaggio(this.idSessione);
                msgSbloccoRicezioneContenutiApplicativi.aggiornaProprietarioMessaggio(idModuloInAttesa);
                this.sendToRicezioneContenutiApplicativi(idModuloInAttesa, idSbloccoRicezioneContenutiApplicativi, richiestaDelegata.getIdCollaborazione(), richiestaDelegata.getProfiloCollaborazione(), richiestaDelegata.getProfiloCollaborazioneValue());
            }
            this.openSPCoopState.commit();
            if (msgSbloccoRicezioneContenutiApplicativi != null) {
                msgSbloccoRicezioneContenutiApplicativi.addMessaggiIntoCache_readFromTable(this.idModulo, "sendRispostaApplicativaErrore [sblocco]");
            }
            if (msgResponse != null) {
                msgResponse.addMessaggiIntoCache_readFromTable(this.idModulo, "sendRispostaApplicativaErrore [risposta]");
            }
            if (msgRequest != null) {
                String idRichiestaCorrelata = null;
                if (!this.idMessage.equals(this.idSessione)) {
                    idRichiestaCorrelata = this.idSessione;
                }
                msgRequest.addProprietariIntoCache_readFromTable(this.idModulo, "sendRispostaApplicativaErrore [richiesta]", idRichiestaCorrelata, this.functionAsRouter);
            }
            if (msgSbloccoRicezioneContenutiApplicativi != null) {
                msgSbloccoRicezioneContenutiApplicativi.addProprietariIntoCache_readFromTable(this.idModulo, "sendRispostaApplicativaErrore [sblocco]", this.idSessione, this.functionAsRouter);
            }
            if (msgResponse != null) {
                msgResponse.addProprietariIntoCache_readFromTable(this.idModulo, "sendRispostaApplicativaErrore [risposta]", this.idSessione, this.functionAsRouter);
            }
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "EJBUtils.sendRispostaApplicativaErrore");
            statoRichiesta.closePreparedStatement();
            statoRisposta.closePreparedStatement();
            throw new EJBUtilsException("EJBUtils.sendRispostaApplicativaErrore error: " + e.getMessage(), e);
        }
        finally {
            this.unsetEJBSuffixFunctionName();
        }
    }

    public GestoreMessaggi sendRispostaApplicativa(RichiestaDelegata richiestaDelegata, PortaDelegata pd, ServizioApplicativo sa) throws EJBUtilsException {
        return this.sendRispostaApplicativa(null, richiestaDelegata, this.idMessage, pd, sa);
    }

    public GestoreMessaggi sendRispostaApplicativaOK(OpenSPCoop2Message msg, RichiestaDelegata richiestaDelegata, PortaDelegata pd, ServizioApplicativo sa) throws EJBUtilsException {
        return this.sendRispostaApplicativa(msg, richiestaDelegata, null, pd, sa);
    }

    private GestoreMessaggi sendRispostaApplicativa(OpenSPCoop2Message msg, RichiestaDelegata richiestaDelegata, String idBustaRisposta, PortaDelegata pd, ServizioApplicativo sa) throws EJBUtilsException {
        String idTransazione = (String)this.pddContext.getObject(Costanti.ID_TRANSAZIONE);
        StateMessage statoRisposta = (StateMessage)this.openSPCoopState.getStatoRisposta();
        GestoreMessaggi msgResponse = null;
        GestoreMessaggi msgSbloccoRicezioneContenutiApplicativi = null;
        String correlazioneApplicativa = null;
        if (richiestaDelegata != null) {
            correlazioneApplicativa = richiestaDelegata.getIdCorrelazioneApplicativa();
        }
        String correlazioneApplicativaRisposta = null;
        if (richiestaDelegata != null) {
            correlazioneApplicativaRisposta = richiestaDelegata.getIdCorrelazioneApplicativaRisposta();
        }
        String nomePorta = null;
        if (richiestaDelegata != null && richiestaDelegata.getIdPortaDelegata() != null) {
            nomePorta = richiestaDelegata.getIdPortaDelegata().getNome();
        }
        if (richiestaDelegata == null) {
            throw new EJBUtilsException("Param richiestaDelegata is null");
        }
        this.msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_EROGATORE@", richiestaDelegata.getServizioApplicativo());
        this.setEJBSuffixFunctionName();
        try {
            String idModuloInAttesa = richiestaDelegata.getIdModuloInAttesa();
            boolean existsConsegnaRispostaAsincrona = false;
            try {
                existsConsegnaRispostaAsincrona = this.configurazionePdDReader.existsConsegnaRispostaAsincrona(sa);
            }
            catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                // empty catch block
            }
            boolean consegnaRispostaAsincrona = richiestaDelegata.getUtilizzoConsegnaAsincrona() && existsConsegnaRispostaAsincrona;
            String idRisposta = idBustaRisposta;
            if (consegnaRispostaAsincrona || idModuloInAttesa != null) {
                Timestamp oraRegistrazioneMessaggio = DateManager.getTimestamp();
                if (idRisposta == null) {
                    Imbustamento imbustatore = new Imbustamento(this.log, this.protocolFactory, this.openSPCoopState.getStatoRichiesta());
                    idRisposta = imbustatore.buildID(this.identitaPdD, idTransazione, this.propertiesReader.getGestioneSerializableDBAttesaAttiva(), this.propertiesReader.getGestioneSerializableDBCheckInterval(), RuoloMessaggio.RISPOSTA);
                    if (idRisposta == null) {
                        throw new Exception("Identificativo non costruito.");
                    }
                    msgResponse = new GestoreMessaggi(this.openSPCoopState, false, idRisposta, "INBOX", this.msgDiag, this.pddContext);
                    msgResponse.registraMessaggio(msg, oraRegistrazioneMessaggio, this.saveMessageStateless(pd), correlazioneApplicativa, correlazioneApplicativaRisposta);
                } else {
                    msgResponse = new GestoreMessaggi(this.openSPCoopState, false, idRisposta, "INBOX", this.msgDiag, this.pddContext);
                    oraRegistrazioneMessaggio = msgResponse.getOraRegistrazioneMessaggio();
                }
                msgResponse.aggiornaRiferimentoMessaggio(this.idSessione);
                if (consegnaRispostaAsincrona) {
                    msgResponse.aggiornaProprietarioMessaggio("ConsegnaContenutiApplicativi");
                } else if (idModuloInAttesa != null) {
                    msgResponse.aggiornaProprietarioMessaggio(idModuloInAttesa);
                }
                boolean servizioApplicativoConConnettore = false;
                boolean getMessageAbilitato = false;
                boolean sbustamentoSoap = false;
                boolean sbustamentoInformazioniProtocollo = true;
                try {
                    servizioApplicativoConConnettore = this.configurazionePdDReader.consegnaRispostaAsincronaConConnettore(sa);
                    getMessageAbilitato = this.configurazionePdDReader.consegnaRispostaAsincronaConGetMessage(sa);
                    sbustamentoSoap = this.configurazionePdDReader.consegnaRispostaAsincronaConSbustamento(sa);
                    sbustamentoInformazioniProtocollo = this.configurazionePdDReader.consegnaRispostaAsincronaConSbustamentoInformazioniProtocollo(sa);
                }
                catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                    // empty catch block
                }
                if (!getMessageAbilitato && !servizioApplicativoConConnettore && idModuloInAttesa == null) {
                    this.msgDiag.logPersonalizzato("consegnaContenutiApplicativi.", "consegnaNonDefinita");
                    GestoreMessaggi gestoreMessaggi = msgResponse;
                    return gestoreMessaggi;
                }
                if (!servizioApplicativoConConnettore && idModuloInAttesa == null) {
                    this.msgDiag.logPersonalizzato("consegnaContenutiApplicativi.", "integrationManager.messaggioDisponibile");
                }
                String tipoConsegna = "IntegrationManager";
                if (consegnaRispostaAsincrona) {
                    if (servizioApplicativoConConnettore) {
                        richiestaDelegata.setScenario("ConsegnaContenutiApplicativi");
                        this.sendToConsegnaContenutiApplicativi_rispostaConsegnataModalitaAsincrona(richiestaDelegata, idRisposta, msgResponse);
                        tipoConsegna = "Connettore";
                    } else {
                        this.msgDiag.logPersonalizzato("consegnaContenutiApplicativi.", "integrationManager.messaggioDisponibile");
                    }
                } else if (idModuloInAttesa != null) {
                    this.sendToRicezioneContenutiApplicativi(idModuloInAttesa, idRisposta, richiestaDelegata.getIdCollaborazione(), richiestaDelegata.getProfiloCollaborazione(), richiestaDelegata.getProfiloCollaborazioneValue());
                    tipoConsegna = "ConnectionReply";
                }
                msgResponse.registraDestinatarioMessaggio(richiestaDelegata.getServizioApplicativo(), sbustamentoSoap, sbustamentoInformazioniProtocollo, getMessageAbilitato, tipoConsegna, oraRegistrazioneMessaggio, nomePorta, false, false, null, null, false);
            }
            if (consegnaRispostaAsincrona && idModuloInAttesa != null) {
                Imbustamento imbustatore = new Imbustamento(this.log, this.protocolFactory, this.openSPCoopState.getStatoRichiesta());
                String idSbloccoRicezioneContenutiApplicativi = imbustatore.buildID(this.identitaPdD, idTransazione, this.propertiesReader.getGestioneSerializableDBAttesaAttiva(), this.propertiesReader.getGestioneSerializableDBCheckInterval(), RuoloMessaggio.RISPOSTA);
                if (idSbloccoRicezioneContenutiApplicativi == null) {
                    throw new Exception("Identificativo non costruito.");
                }
                msgSbloccoRicezioneContenutiApplicativi = new GestoreMessaggi(this.openSPCoopState, false, idSbloccoRicezioneContenutiApplicativi, "INBOX", this.msgDiag, this.pddContext);
                RequestInfo requestInfo = (RequestInfo)this.pddContext.getObject(Costanti.REQUEST_INFO);
                MessageType msgTypeSblocco = requestInfo.getIntegrationRequestMessageType();
                if (msgTypeSblocco == null) {
                    throw new Exception("Versione messaggio non definita");
                }
                if (this.protocolManager.isHttpEmptyResponseOneWay()) {
                    msgSbloccoRicezioneContenutiApplicativi.registraMessaggio(MessageUtilities.buildEmptyMessage((OpenSPCoop2MessageFactory)OpenSPCoop2MessageFactory.getDefaultMessageFactory(), (MessageType)msgTypeSblocco, (MessageRole)MessageRole.RESPONSE), correlazioneApplicativa, correlazioneApplicativaRisposta);
                } else {
                    msgSbloccoRicezioneContenutiApplicativi.registraMessaggio(this.buildOpenSPCoopOK(msgTypeSblocco, this.idSessione), correlazioneApplicativa, correlazioneApplicativaRisposta);
                }
                msgSbloccoRicezioneContenutiApplicativi.aggiornaRiferimentoMessaggio(this.idSessione);
                msgSbloccoRicezioneContenutiApplicativi.aggiornaProprietarioMessaggio(idModuloInAttesa);
                this.sendToRicezioneContenutiApplicativi(idModuloInAttesa, idSbloccoRicezioneContenutiApplicativi, richiestaDelegata.getIdCollaborazione(), richiestaDelegata.getProfiloCollaborazione(), richiestaDelegata.getProfiloCollaborazioneValue());
            }
            GestoreMessaggi gestoreMessaggi = msgResponse;
            return gestoreMessaggi;
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "EJBUtils.sendRispostaApplicativa");
            if (msgResponse != null) {
                statoRisposta.closePreparedStatement();
            }
            throw new EJBUtilsException("EJBUtils.sendRispostaApplicativa error: " + e.getMessage(), e);
        }
        finally {
            this.unsetEJBSuffixFunctionName();
        }
    }

    public void sendToRicezioneContenutiApplicativi(String idModuloInAttesa, String idRisposta, String idCollaborazione, ProfiloDiCollaborazione profiloCollaborazione, String profiloCollaborazioneValue) throws EJBUtilsException {
        if (this.openSPCoopState instanceof OpenSPCoopStateless) {
            RicezioneContenutiApplicativiMessage accettazioneMSG = new RicezioneContenutiApplicativiMessage();
            accettazioneMSG.setIdBustaRisposta(idRisposta);
            accettazioneMSG.setIdCollaborazione(idCollaborazione);
            accettazioneMSG.setProfiloCollaborazione(profiloCollaborazione, profiloCollaborazioneValue);
            accettazioneMSG.setPddContext(this.pddContext);
            ((OpenSPCoopStateless)this.openSPCoopState).setMessageLib(accettazioneMSG);
            return;
        }
        if ("jms".equals(this.propertiesReader.getNodeReceiver())) {
            try {
                this.msgDiag.highDebug("[EJBUtils] Creazione ObjectMessage for send via JMS.");
                RicezioneContenutiApplicativiMessage accettazioneMSG = new RicezioneContenutiApplicativiMessage();
                accettazioneMSG.setIdBustaRisposta(idRisposta);
                accettazioneMSG.setIdCollaborazione(idCollaborazione);
                accettazioneMSG.setProfiloCollaborazione(profiloCollaborazione, profiloCollaborazioneValue);
                accettazioneMSG.setPddContext(this.pddContext);
                if (this.openSPCoopState instanceof OpenSPCoopStateless) {
                    ((OpenSPCoopStateless)this.openSPCoopState).setMessageLib(accettazioneMSG);
                } else {
                    String idT = PdDContext.getValue((MapKey<String>)Costanti.ID_TRANSAZIONE, this.pddContext);
                    JMSSender senderJMS = new JMSSender(this.identitaPdD, this.idModulo, this.log, idT);
                    if (!senderJMS.send(idModuloInAttesa, (Serializable)accettazioneMSG, this.idSessione)) {
                        this.msgDiag.logErroreGenerico(senderJMS.getErrore(), "EJBUtils.sendToRicezioneContenutiApplicativi.senderJMS");
                        throw new Exception("[EJBUtils]  SendJMSError: " + senderJMS.getErrore());
                    }
                    this.msgDiag.highDebug("[EJBUtils]  ObjectMessage send via JMS.");
                }
            }
            catch (Exception e) {
                this.msgDiag.logErroreGenerico(e, "EJBUtils.sendToRicezioneContenutiApplicativi");
                throw new EJBUtilsException("EJBUtils.sendToRicezioneContenutiApplicativi error: " + e.getMessage(), e);
            }
        }
    }

    public void sendToConsegnaContenutiApplicativi_rispostaConsegnataModalitaAsincrona(RichiestaDelegata richiestaDelegata, String idBustaConsegna, GestoreMessaggi gm) throws EJBUtilsException {
        try {
            this.msgDiag.highDebug("[EJBUtils]  Creazione ObjectMessage for send nell'infrastruttura.");
            ConsegnaContenutiApplicativiMessage consegnaMSG = new ConsegnaContenutiApplicativiMessage();
            consegnaMSG.setRichiestaDelegata(richiestaDelegata);
            consegnaMSG.setOneWayVersione11(this.oneWayVersione11);
            consegnaMSG.setStateless(this.portaDiTipoStateless_esclusoOneWay11);
            consegnaMSG.setImplementazionePdDSoggettoMittente(this.implementazionePdDSoggettoMittente);
            consegnaMSG.setImplementazionePdDSoggettoDestinatario(this.implementazionePdDSoggettoDestinatario);
            consegnaMSG.setPddContext(this.pddContext);
            Busta busta = new Busta(this.protocolFactory.getProtocol());
            busta.setTipoMittente(richiestaDelegata.getIdSoggettoFruitore().getTipo());
            busta.setMittente(richiestaDelegata.getIdSoggettoFruitore().getNome());
            busta.setIdentificativoPortaMittente(richiestaDelegata.getIdSoggettoFruitore().getCodicePorta());
            busta.setTipoDestinatario(richiestaDelegata.getIdServizio().getSoggettoErogatore().getTipo());
            busta.setDestinatario(richiestaDelegata.getIdServizio().getSoggettoErogatore().getNome());
            busta.setIdentificativoPortaDestinatario(richiestaDelegata.getIdServizio().getSoggettoErogatore().getCodicePorta());
            busta.setTipoServizio(richiestaDelegata.getIdServizio().getTipo());
            busta.setServizio(richiestaDelegata.getIdServizio().getNome());
            busta.setVersioneServizio(richiestaDelegata.getIdServizio().getVersione());
            busta.setAzione(richiestaDelegata.getIdServizio().getAzione());
            busta.setID(idBustaConsegna);
            busta.setRiferimentoMessaggio(this.idSessione);
            busta.setProfiloDiCollaborazione(richiestaDelegata.getProfiloCollaborazione());
            boolean idCollaborazione = false;
            switch (this.protocolFactory.createProtocolVersionManager(richiestaDelegata.getProfiloGestione()).getCollaborazione(busta)) {
                case ABILITATA: {
                    idCollaborazione = true;
                    break;
                }
                case DISABILITATA: {
                    idCollaborazione = false;
                    break;
                }
                default: {
                    idCollaborazione = this.propertiesReader.isGestioneElementoCollaborazione(this.implementazionePdDSoggettoDestinatario);
                }
            }
            if (idCollaborazione) {
                busta.setCollaborazione(richiestaDelegata.getIdCollaborazione());
            }
            consegnaMSG.setBusta(busta);
            this.nodeSender.send(consegnaMSG, "ConsegnaContenutiApplicativi", this.msgDiag, this.identitaPdD, this.idModulo, idBustaConsegna, gm);
        }
        catch (Exception e) {
            this.log.error("Spedizione->ConsegnaContenutiApplicativi(RichiestaDelegata) non riuscita", (Throwable)e);
            this.msgDiag.logErroreGenerico(e, "EJBUtils.sendToConsegnaContenutiApplicativi(RichiestaDelegata)");
            throw new EJBUtilsException("EJBUtils.sendToConsegnaContenutiApplicativi error: " + e.getMessage(), e);
        }
    }

    public void sendToConsegnaContenutiApplicativi_gestioneMessaggio(RichiestaDelegata richiestaDelegata, Busta busta, GestoreMessaggi gestoreMessaggi, ServizioApplicativo sa) throws EJBUtilsException {
        block14: {
            try {
                if (richiestaDelegata != null) {
                    this.msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_EROGATORE@", richiestaDelegata.getServizioApplicativo());
                }
                if (richiestaDelegata == null) {
                    throw new EJBUtilsException("Param richiestaDelegata is null");
                }
                String nomePorta = null;
                if (richiestaDelegata.getIdPortaDelegata() != null) {
                    nomePorta = richiestaDelegata.getIdPortaDelegata().getNome();
                }
                this.msgDiag.setServizioApplicativo(richiestaDelegata.getServizioApplicativo());
                gestoreMessaggi.aggiornaRiferimentoMessaggio(busta.getRiferimentoMessaggio());
                boolean servizioApplicativoRicezioneAsincronaConConnettore = this.configurazionePdDReader.consegnaRispostaAsincronaConConnettore(sa);
                boolean getMessageAbilitato = this.configurazionePdDReader.consegnaRispostaAsincronaConGetMessage(sa);
                if (!getMessageAbilitato && !servizioApplicativoRicezioneAsincronaConConnettore) {
                    throw new EJBUtilsConsegnaException(this.msgDiag, "consegnaContenutiApplicativi.", "consegnaNonDefinita");
                }
                boolean sbustamentoSoap = this.configurazionePdDReader.consegnaRispostaAsincronaConSbustamento(sa);
                boolean sbustamentoInformazioniProtocollo = this.configurazionePdDReader.consegnaRispostaAsincronaConSbustamentoInformazioniProtocollo(sa);
                String tipoConsegna = "IntegrationManager";
                if (servizioApplicativoRicezioneAsincronaConConnettore) {
                    tipoConsegna = "Connettore";
                }
                Timestamp oraRegistrazioneMessaggio = gestoreMessaggi.getOraRegistrazioneMessaggio();
                gestoreMessaggi.registraDestinatarioMessaggio(richiestaDelegata.getServizioApplicativo(), sbustamentoSoap, sbustamentoInformazioniProtocollo, getMessageAbilitato, tipoConsegna, oraRegistrazioneMessaggio, nomePorta, false, false, null, null, false);
                this.msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_EROGATORE@", richiestaDelegata.getServizioApplicativo());
                if (servizioApplicativoRicezioneAsincronaConConnettore) {
                    this.msgDiag.highDebug("[EJBUtils] Creazione ObjectMessage for send nell'infrastruttura.");
                    ConsegnaContenutiApplicativiMessage consegnaMSG = new ConsegnaContenutiApplicativiMessage();
                    consegnaMSG.setRichiestaDelegata(richiestaDelegata);
                    consegnaMSG.setBusta(busta);
                    consegnaMSG.setOneWayVersione11(this.oneWayVersione11);
                    consegnaMSG.setStateless(this.portaDiTipoStateless_esclusoOneWay11);
                    consegnaMSG.setImplementazionePdDSoggettoMittente(this.implementazionePdDSoggettoMittente);
                    consegnaMSG.setImplementazionePdDSoggettoDestinatario(this.implementazionePdDSoggettoDestinatario);
                    consegnaMSG.setPddContext(this.pddContext);
                    if (this.openSPCoopState instanceof OpenSPCoopStateless) {
                        ((OpenSPCoopStateless)this.openSPCoopState).setMessageLib(consegnaMSG);
                    } else {
                        this.nodeSender.send(consegnaMSG, "ConsegnaContenutiApplicativi", this.msgDiag, this.identitaPdD, this.idModulo, busta.getID(), gestoreMessaggi);
                    }
                    break block14;
                }
                if (richiestaDelegata.isRicevutaAsincrona() && (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)busta.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)busta.getProfiloDiCollaborazione()))) {
                    throw new EJBUtilsConsegnaException(this.msgDiag, "consegnaContenutiApplicativi.", "gestioneProfiloAsincrono.servizioNonUtilizzabile");
                }
                this.msgDiag.logPersonalizzato("consegnaContenutiApplicativi.", "integrationManager.messaggioDisponibile");
            }
            catch (EJBUtilsConsegnaException e) {
                throw e;
            }
            catch (Exception e) {
                this.log.error("Spedizione->ConsegnaContenutiApplicativi_gestoreMessaggi(RichiestaDelegata) non riuscita", (Throwable)e);
                this.msgDiag.logErroreGenerico(e, "EJBUtils.sendToConsegnaContenutiApplicativi_gestoreMessaggi(RichiestaDelegata)");
                throw new EJBUtilsException("EJBUtils.sendToConsegnaContenutiApplicativi error: " + e.getMessage(), e);
            }
        }
    }

    public boolean isGestioneStatelessConIntegrationManager() {
        return this.gestioneStatelessConIntegrationManager;
    }

    public boolean isGestioneSolamenteConIntegrationManager() {
        return this.gestioneSolamenteConIntegrationManager;
    }

    public Behaviour sendToConsegnaContenutiApplicativi(RequestInfo requestInfo, RichiestaApplicativa richiestaApplicativa, Busta busta, GestoreMessaggi gestoreMessaggi, PortaApplicativa pa, RepositoryBuste repositoryBuste) throws EJBUtilsException {
        return this.sendToConsegnaContenutiApplicativi(requestInfo, richiestaApplicativa, busta, gestoreMessaggi, pa, repositoryBuste, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Behaviour sendToConsegnaContenutiApplicativi(RequestInfo requestInfo, RichiestaApplicativa richiestaApplicativa, Busta busta, GestoreMessaggi gestoreMessaggi, PortaApplicativa pa, RepositoryBuste repositoryBuste, RichiestaDelegata localForwardRichiestaDelegata) throws EJBUtilsException {
        try {
            IBehaviour behaviourImpl;
            MessaggioDaNotificare tipiMessaggiNotificabili;
            IDServizioApplicativo behaviour_idSA_SyncResponder;
            boolean behaviourResponseTo;
            BehaviourForwardToFilter singleFilterBehaviour;
            boolean registraNuoviMessaggiViaBehaviour;
            boolean stateless;
            boolean soggettoVirtuale;
            Behaviour behaviour;
            block89: {
                block91: {
                    boolean oldUseConnection;
                    OpenSPCoopState stateGestoreMessaggiBehaviour_onlyUseConnectionFalse;
                    block90: {
                        behaviour = null;
                        soggettoVirtuale = false;
                        if (richiestaApplicativa != null && richiestaApplicativa.getIDServizio() != null && richiestaApplicativa.getIDServizio().getSoggettoErogatore() != null) {
                            soggettoVirtuale = this.configurazionePdDReader.isSoggettoVirtuale(richiestaApplicativa.getIDServizio().getSoggettoErogatore(), requestInfo);
                        }
                        stateless = false;
                        if (!soggettoVirtuale) {
                            stateless = localForwardRichiestaDelegata != null ? this.portaDiTipoStateless_esclusoOneWay11 : this.configurazionePdDReader.isModalitaStateless(pa, busta.getProfiloDiCollaborazione());
                        }
                        if (pa != null) {
                            this.msgDiag.addKeyword("@PORTA_APPLICATIVA@", pa.getNome());
                        }
                        registraNuoviMessaggiViaBehaviour = false;
                        int sizeNuoviMessaggiViaBehaviour = -1;
                        singleFilterBehaviour = null;
                        behaviourResponseTo = false;
                        behaviour_idSA_SyncResponder = null;
                        tipiMessaggiNotificabili = null;
                        behaviourImpl = null;
                        if (pa == null || pa.getBehaviour() == null || pa.getBehaviour().getNome() == null || "".equals(pa.getBehaviour().getNome())) break block89;
                        behaviourImpl = BehaviourLoader.newInstance(pa.getBehaviour(), this.msgDiag, this.pddContext, this.protocolFactory, this.openSPCoopState != null ? this.openSPCoopState.getStatoRichiesta() : null);
                        gestoreMessaggi.setPortaDiTipoStateless(stateless);
                        behaviour = behaviourImpl.behaviour(gestoreMessaggi, busta, pa, requestInfo);
                        boolean bl = behaviourResponseTo = behaviour != null && behaviour.isResponseTo();
                        if (behaviour != null) {
                            behaviour_idSA_SyncResponder = behaviour.getApplicativeSyncResponder();
                        }
                        if (behaviour != null && behaviour.getForwardTo() != null) {
                            if (behaviour.getForwardTo().size() > 1) {
                                registraNuoviMessaggiViaBehaviour = true;
                                if (!behaviourResponseTo) {
                                    throw new Exception("La consegna di messaggi multipli via custom behaviour (tipo:" + pa.getBehaviour().getNome() + ") e' permessa solo se viene abilita anche la funzione 'responseTo'");
                                }
                                for (int i = 0; i < behaviour.getForwardTo().size(); ++i) {
                                    BehaviourForwardTo forwardTo = behaviour.getForwardTo().get(i);
                                    if (forwardTo.getDescription() == null) {
                                        forwardTo.setDescription("ForwardTo[" + i + "]");
                                    }
                                    if (forwardTo.getMessage() != null) continue;
                                    throw new Exception("La consegna di messaggi multipli via custom behaviour (tipo:" + pa.getBehaviour().getNome() + ") richiede che vengano definiti tutti i messaggi da inoltrare. Trovato un elemento ForwardTo (" + forwardTo.getDescription() + ") che non contiene alcun messaggio");
                                }
                            } else if (behaviour.getForwardTo().size() == 1) {
                                BehaviourForwardTo forwardTo = behaviour.getForwardTo().get(0);
                                if (forwardTo.getDescription() == null) {
                                    forwardTo.setDescription("ForwardTo");
                                }
                                if (forwardTo.getMessage() != null) {
                                    if (behaviourResponseTo) {
                                        registraNuoviMessaggiViaBehaviour = true;
                                    } else if (!stateless) {
                                        registraNuoviMessaggiViaBehaviour = true;
                                    }
                                } else {
                                    singleFilterBehaviour = behaviour.getForwardTo().get(0).getFilter();
                                }
                            }
                        }
                        if (!registraNuoviMessaggiViaBehaviour) break block91;
                        String idTransazione = (String)this.pddContext.getObject(Costanti.ID_TRANSAZIONE);
                        IOpenSPCoopState stateGestoreMessaggiBehaviour_newConnection_old = null;
                        OpenSPCoopState stateGestoreMessaggiBehaviour_newConnection = null;
                        stateGestoreMessaggiBehaviour_onlyUseConnectionFalse = null;
                        oldUseConnection = false;
                        try {
                            if (stateless && !this.propertiesReader.isServerJ2EE().booleanValue()) {
                                OpenSPCoopStateless check;
                                boolean createNew = true;
                                if (gestoreMessaggi.getOpenspcoopstate() instanceof OpenSPCoopStateless && (check = (OpenSPCoopStateless)gestoreMessaggi.getOpenspcoopstate()).getConnectionDB() != null && !check.getConnectionDB().isClosed()) {
                                    createNew = false;
                                    stateGestoreMessaggiBehaviour_onlyUseConnectionFalse = (OpenSPCoopStateless)gestoreMessaggi.getOpenspcoopstate();
                                    oldUseConnection = check.isUseConnection();
                                    stateGestoreMessaggiBehaviour_onlyUseConnectionFalse.setUseConnection(true);
                                }
                                if (createNew) {
                                    stateGestoreMessaggiBehaviour_newConnection_old = gestoreMessaggi.getOpenspcoopstate();
                                    stateGestoreMessaggiBehaviour_newConnection = new OpenSPCoopStateless();
                                    stateGestoreMessaggiBehaviour_newConnection.setUseConnection(true);
                                    ((OpenSPCoopStateless)stateGestoreMessaggiBehaviour_newConnection).setTempiAttraversamentoPDD(((OpenSPCoopStateless)this.openSPCoopState).getTempiAttraversamentoPDD());
                                    ((OpenSPCoopStateless)stateGestoreMessaggiBehaviour_newConnection).setDimensioneMessaggiAttraversamentoPDD(((OpenSPCoopStateless)this.openSPCoopState).getDimensioneMessaggiAttraversamentoPDD());
                                    ((OpenSPCoopStateless)stateGestoreMessaggiBehaviour_newConnection).setIDCorrelazioneApplicativa(((OpenSPCoopStateless)this.openSPCoopState).getIDCorrelazioneApplicativa());
                                    ((OpenSPCoopStateless)stateGestoreMessaggiBehaviour_newConnection).setIDCorrelazioneApplicativaRisposta(((OpenSPCoopStateless)this.openSPCoopState).getIDCorrelazioneApplicativaRisposta());
                                    ((OpenSPCoopStateless)stateGestoreMessaggiBehaviour_newConnection).setPddContext(((OpenSPCoopStateless)this.openSPCoopState).getPddContext());
                                    stateGestoreMessaggiBehaviour_newConnection.initResource(this.identitaPdD, "EJBUtils.behaviour_" + pa.getBehaviour().getNome(), idTransazione);
                                    gestoreMessaggi.updateOpenSPCoopState(stateGestoreMessaggiBehaviour_newConnection);
                                }
                            }
                            sizeNuoviMessaggiViaBehaviour = behaviour.getForwardTo().size();
                            if (localForwardRichiestaDelegata != null) {
                                if (stateless) {
                                    repositoryBuste.eliminaUtilizzoPdDFromInBox(busta.getID(), false);
                                } else {
                                    repositoryBuste.eliminaUtilizzoPdDFromInBox(busta.getID(), true);
                                }
                                gestoreMessaggi.aggiornaProprietarioMessaggio("GestoreMessaggi");
                            } else {
                                if (stateless) {
                                    repositoryBuste.eliminaUtilizzoPdDFromInBox(busta.getID(), repositoryBuste.isRegistrazioneInCorso());
                                } else {
                                    repositoryBuste.eliminaUtilizzoPdDFromInBox(busta.getID(), true);
                                }
                                boolean originalValue = gestoreMessaggi.isOneWayVersione11();
                                gestoreMessaggi.setOneWayVersione11(true);
                                gestoreMessaggi.logicDeleteMessage();
                                gestoreMessaggi.setOneWayVersione11(originalValue);
                            }
                            if (stateless && !this.propertiesReader.isServerJ2EE().booleanValue()) {
                                if (stateGestoreMessaggiBehaviour_newConnection != null) {
                                    if (stateGestoreMessaggiBehaviour_newConnection.resourceReleased()) {
                                        stateGestoreMessaggiBehaviour_newConnection.updateResource(idTransazione);
                                    }
                                    stateGestoreMessaggiBehaviour_newConnection.commit();
                                } else if (stateGestoreMessaggiBehaviour_onlyUseConnectionFalse != null) {
                                    stateGestoreMessaggiBehaviour_onlyUseConnectionFalse.commit();
                                }
                            }
                            if (!stateless || this.propertiesReader.isServerJ2EE().booleanValue()) break block89;
                            if (stateGestoreMessaggiBehaviour_newConnection == null) break block90;
                        }
                        catch (Throwable throwable) {
                            if (stateless && !this.propertiesReader.isServerJ2EE().booleanValue()) {
                                if (stateGestoreMessaggiBehaviour_newConnection != null) {
                                    stateGestoreMessaggiBehaviour_newConnection.releaseResource();
                                    gestoreMessaggi.updateOpenSPCoopState(stateGestoreMessaggiBehaviour_newConnection_old);
                                } else if (stateGestoreMessaggiBehaviour_onlyUseConnectionFalse != null) {
                                    stateGestoreMessaggiBehaviour_onlyUseConnectionFalse.setUseConnection(oldUseConnection);
                                }
                            }
                            throw throwable;
                        }
                        stateGestoreMessaggiBehaviour_newConnection.releaseResource();
                        gestoreMessaggi.updateOpenSPCoopState(stateGestoreMessaggiBehaviour_newConnection_old);
                        break block89;
                    }
                    if (stateGestoreMessaggiBehaviour_onlyUseConnectionFalse != null) {
                        stateGestoreMessaggiBehaviour_onlyUseConnectionFalse.setUseConnection(oldUseConnection);
                    }
                    break block89;
                }
                if (stateless && behaviourResponseTo) {
                    throw new Exception("La definizione dell'elemento 'responseTo', via custom behaviour (tipo:" + pa.getBehaviour().getNome() + "), in una porta applicativa stateless richiede la definizione almeno di un elemento forwardTo contenente un messaggio da inoltrare.");
                }
            }
            if (richiestaApplicativa == null) {
                throw new Exception("Tipo di consegna sconosciuta (RichiestaApplicativa non definita)");
            }
            if (!("OneWay_InvocazioneServizio".equals(richiestaApplicativa.getScenario()) || "Sincrono_InvocazioneServizio".equals(richiestaApplicativa.getScenario()) || "AsincronoSimmetrico_InvocazioneServizio".equals(richiestaApplicativa.getScenario()) || "AsincronoAsimmetrico_InvocazioneServizio".equals(richiestaApplicativa.getScenario()) || "AsincronoAsimmetrico_Polling".equals(richiestaApplicativa.getScenario()))) {
                throw new Exception("Tipo di consegna sconosciuta");
            }
            String[] serviziApplicativiConfigurazione = null;
            SoggettoVirtuale soggettiRealiMappatiInUnSoggettoVirtuale = null;
            IDSoggetto soggettoDestinatario = richiestaApplicativa.getIDServizio().getSoggettoErogatore();
            if ("AsincronoAsimmetrico_Polling".equals(richiestaApplicativa.getScenario())) {
                serviziApplicativiConfigurazione = this.configurazionePdDReader.getServiziApplicativi(pa);
                if (serviziApplicativiConfigurazione == null) {
                    throw new EJBUtilsConsegnaException(this.msgDiag, "consegnaContenutiApplicativi.", "servizioApplicativoNonDefinito");
                }
            } else if (soggettoVirtuale) {
                SoggettoVirtuale soggettiVirtuali = this.configurazionePdDReader.getServiziApplicativiSoggettiVirtuali(richiestaApplicativa);
                if (soggettiVirtuali == null) {
                    throw new EJBUtilsConsegnaException("(SoggettoVirtuale) " + this.msgDiag.getMessaggio_replaceKeywords("consegnaContenutiApplicativi.", "servizioApplicativoNonDefinito"), this.msgDiag.getLivello("consegnaContenutiApplicativi.", "servizioApplicativoNonDefinito"), this.msgDiag.getCodice("consegnaContenutiApplicativi.", "servizioApplicativoNonDefinito"));
                }
                boolean GESTISCI_BEHAVIOUR = true;
                List<String> idServiziApplicativiVirtuali = soggettiVirtuali.getIdServiziApplicativi(GESTISCI_BEHAVIOUR, gestoreMessaggi, busta, requestInfo, this.pddContext, this.protocolFactory, this.openSPCoopState != null ? this.openSPCoopState.getStatoRichiesta() : null);
                if (idServiziApplicativiVirtuali.size() > 0) {
                    serviziApplicativiConfigurazione = idServiziApplicativiVirtuali.toArray(new String[1]);
                }
                soggettiRealiMappatiInUnSoggettoVirtuale = soggettiVirtuali;
            } else {
                serviziApplicativiConfigurazione = this.configurazionePdDReader.getServiziApplicativi(pa);
                if (serviziApplicativiConfigurazione == null) {
                    throw new EJBUtilsConsegnaException(this.msgDiag, "consegnaContenutiApplicativi.", "servizioApplicativoNonDefinito");
                }
            }
            if (serviziApplicativiConfigurazione == null || serviziApplicativiConfigurazione.length < 1) {
                throw new EJBUtilsConsegnaException(this.msgDiag, "consegnaContenutiApplicativi.", "servizioApplicativoNonDefinito");
            }
            ArrayList<String> serviziApplicativiAbilitati = new ArrayList<String>();
            List<IDServizioApplicativo> idServiziApplicativiAbilitati = new ArrayList<IDServizioApplicativo>();
            for (int i = 0; i < serviziApplicativiConfigurazione.length; ++i) {
                IDServizioApplicativo idSA = new IDServizioApplicativo();
                idSA.setIdSoggettoProprietario(soggettoDestinatario);
                idSA.setNome(serviziApplicativiConfigurazione[i]);
                serviziApplicativiAbilitati.add(serviziApplicativiConfigurazione[i]);
                idServiziApplicativiAbilitati.add(idSA);
            }
            if (singleFilterBehaviour != null) {
                idServiziApplicativiAbilitati = singleFilterBehaviour.aggiornaDestinatariAbilitati(idServiziApplicativiAbilitati);
                serviziApplicativiAbilitati = new ArrayList();
                for (IDServizioApplicativo idServizioApplicativo : idServiziApplicativiAbilitati) {
                    serviziApplicativiAbilitati.add(idServizioApplicativo.getNome());
                }
            }
            if (serviziApplicativiAbilitati.size() < 1 && behaviour_idSA_SyncResponder == null) {
                throw new EJBUtilsConsegnaException(this.msgDiag, "consegnaContenutiApplicativi.", "behaviour.servizioApplicativoNonDefinito");
            }
            if (!(registraNuoviMessaggiViaBehaviour && behaviourResponseTo || behaviour_idSA_SyncResponder != null)) {
                if (!"OneWay_InvocazioneServizio".equals(richiestaApplicativa.getScenario()) && serviziApplicativiAbilitati.size() > 1) {
                    throw new EJBUtilsConsegnaException(this.msgDiag, "consegnaContenutiApplicativi.", "gestioneProfiloNonOneway.consegnaVersoNServiziApplicativi");
                }
                if ("OneWay_InvocazioneServizio".equals(richiestaApplicativa.getScenario()) && !this.oneWayVersione11 && this.openSPCoopState instanceof OpenSPCoopStateless && serviziApplicativiAbilitati.size() > 1) {
                    for (String nomeServizioApplicativo : serviziApplicativiAbilitati) {
                        IDServizioApplicativo idSA = new IDServizioApplicativo();
                        idSA.setNome(nomeServizioApplicativo);
                        idSA.setIdSoggettoProprietario(richiestaApplicativa.getIDServizio().getSoggettoErogatore());
                        ServizioApplicativo sappl = this.configurazionePdDReader.getServizioApplicativo(idSA, requestInfo);
                        boolean servizioApplicativoConConnettore = this.configurazionePdDReader.invocazioneServizioConConnettore(sappl);
                        boolean getMessageAbilitato = this.configurazionePdDReader.invocazioneServizioConGetMessage(sappl);
                        if (!servizioApplicativoConConnettore && getMessageAbilitato) continue;
                        throw new EJBUtilsConsegnaException(this.msgDiag, "consegnaContenutiApplicativi.", "gestioneStateless.consegnaVersoNServiziApplicativi");
                    }
                }
            }
            boolean EFFETTUA_SPEDIZIONE_CONSEGNA_CONTENUTI = true;
            boolean ATTENDI_ESITO_TRANSAZIONE_SINCRONA_PRIMA_DI_SPEDIRE = true;
            if (!(behaviour_idSA_SyncResponder != null || behaviour != null && registraNuoviMessaggiViaBehaviour)) {
                List serviziApplicativiAbilitatiById = DriverConfigurazioneDB.normalizeConnettoriMultpliById(serviziApplicativiAbilitati, (PortaApplicativa)pa);
                if (serviziApplicativiAbilitatiById != null && !serviziApplicativiAbilitatiById.isEmpty()) {
                    this.pddContext.addObject(Costanti.CONSEGNA_MULTIPLA_CONNETTORI_BY_ID, serviziApplicativiAbilitatiById);
                }
                this._sendMessageToServiziApplicativi(serviziApplicativiAbilitati, soggettiRealiMappatiInUnSoggettoVirtuale, richiestaApplicativa, localForwardRichiestaDelegata, gestoreMessaggi, busta, pa, repositoryBuste, null, null, stateless, this.openSPCoopState, false, null, EFFETTUA_SPEDIZIONE_CONSEGNA_CONTENUTI, !ATTENDI_ESITO_TRANSAZIONE_SINCRONA_PRIMA_DI_SPEDIRE, behaviour != null ? behaviour.getLoadBalancer() : null, false, null, requestInfo);
            } else {
                boolean attendiEsitoTransazioneSincronaPrimaDiSpedire = false;
                if (behaviour_idSA_SyncResponder != null) {
                    this.pddContext.addObject(Costanti.CONSEGNA_MULTIPLA_SINCRONA, "true");
                    attendiEsitoTransazioneSincronaPrimaDiSpedire = true;
                    ArrayList<String> sa_list = new ArrayList<String>();
                    sa_list.add(behaviour_idSA_SyncResponder.getNome());
                    this._sendMessageToServiziApplicativi(sa_list, soggettiRealiMappatiInUnSoggettoVirtuale, richiestaApplicativa, localForwardRichiestaDelegata, gestoreMessaggi, busta, pa, repositoryBuste, null, null, stateless, this.openSPCoopState, false, null, EFFETTUA_SPEDIZIONE_CONSEGNA_CONTENUTI, !ATTENDI_ESITO_TRANSAZIONE_SINCRONA_PRIMA_DI_SPEDIRE, null, false, null, requestInfo);
                }
                List<BehaviourForwardTo> forwardTo = behaviour.getForwardTo();
                for (int i = 0; i < forwardTo.size(); ++i) {
                    MultiDeliverBehaviour multiDeliverBehaviour;
                    BehaviourForwardTo behaviourForwardTo = forwardTo.get(i);
                    ArrayList<String> serviziApplicativiAbilitatiForwardTo = new ArrayList<String>();
                    List<Object> idServiziApplicativiAbilitatiForwardTo = new ArrayList<IDServizioApplicativo>();
                    serviziApplicativiAbilitatiForwardTo.addAll(serviziApplicativiAbilitati);
                    idServiziApplicativiAbilitatiForwardTo.addAll(idServiziApplicativiAbilitati);
                    if (behaviourForwardTo.getFilter() != null) {
                        idServiziApplicativiAbilitatiForwardTo = behaviourForwardTo.getFilter().aggiornaDestinatariAbilitati(idServiziApplicativiAbilitati);
                        serviziApplicativiAbilitatiForwardTo = new ArrayList();
                        for (IDServizioApplicativo iDServizioApplicativo : idServiziApplicativiAbilitatiForwardTo) {
                            serviziApplicativiAbilitatiForwardTo.add(iDServizioApplicativo.getNome());
                        }
                    }
                    if (serviziApplicativiAbilitatiForwardTo.size() < 1 && behaviour_idSA_SyncResponder == null) {
                        throw new EJBUtilsConsegnaException(this.msgDiag, "consegnaContenutiApplicativi.", "behaviour.servizioApplicativoNonDefinito");
                    }
                    List serviziApplicativiAbilitatiForwardToNormalizedById = DriverConfigurazioneDB.normalizeConnettoriMultpliById(serviziApplicativiAbilitatiForwardTo, (PortaApplicativa)pa);
                    if (serviziApplicativiAbilitatiForwardToNormalizedById != null && !serviziApplicativiAbilitatiForwardToNormalizedById.isEmpty()) {
                        this.pddContext.addObject(Costanti.CONSEGNA_MULTIPLA_CONNETTORI_BY_ID, serviziApplicativiAbilitatiForwardToNormalizedById);
                    }
                    this.pddContext.addObject(Costanti.CONSEGNA_MULTIPLA_CONNETTORI, serviziApplicativiAbilitatiForwardTo.size());
                    if (serviziApplicativiAbilitatiForwardTo != null && !serviziApplicativiAbilitatiForwardTo.isEmpty()) {
                        this.pddContext.addObject(Costanti.CONSEGNA_MULTIPLA_CONNETTORI_BY_SA, serviziApplicativiAbilitatiForwardTo);
                    }
                    if (behaviourImpl instanceof MultiDeliverBehaviour && TipoBehaviour.CONSEGNA_CON_NOTIFICHE.equals((Object)(multiDeliverBehaviour = (MultiDeliverBehaviour)behaviourImpl).getBt())) {
                        tipiMessaggiNotificabili = MultiDeliverUtils.readMessaggiNotificabili(pa, serviziApplicativiAbilitatiForwardTo);
                    }
                    String string = (String)this.pddContext.getObject(Costanti.ID_TRANSAZIONE);
                    OpenSPCoopState stateBehaviour_newConnection = null;
                    OpenSPCoopState stateBehaviour_onlyUseConnectionFalse = null;
                    boolean oldUseConnection = false;
                    try {
                        Busta bustaNewMessaggio;
                        if (stateless && !this.propertiesReader.isServerJ2EE().booleanValue()) {
                            OpenSPCoopStateless check;
                            boolean createNew = true;
                            if (this.openSPCoopState instanceof OpenSPCoopStateless && (check = (OpenSPCoopStateless)this.openSPCoopState).getConnectionDB() != null && !check.getConnectionDB().isClosed()) {
                                createNew = false;
                                stateBehaviour_onlyUseConnectionFalse = (OpenSPCoopStateless)this.openSPCoopState;
                                oldUseConnection = check.isUseConnection();
                                stateBehaviour_onlyUseConnectionFalse.setUseConnection(true);
                            }
                            if (createNew) {
                                stateBehaviour_newConnection = new OpenSPCoopStateless();
                                stateBehaviour_newConnection.setUseConnection(true);
                                ((OpenSPCoopStateless)stateBehaviour_newConnection).setTempiAttraversamentoPDD(((OpenSPCoopStateless)this.openSPCoopState).getTempiAttraversamentoPDD());
                                ((OpenSPCoopStateless)stateBehaviour_newConnection).setDimensioneMessaggiAttraversamentoPDD(((OpenSPCoopStateless)this.openSPCoopState).getDimensioneMessaggiAttraversamentoPDD());
                                ((OpenSPCoopStateless)stateBehaviour_newConnection).setIDCorrelazioneApplicativa(((OpenSPCoopStateless)this.openSPCoopState).getIDCorrelazioneApplicativa());
                                ((OpenSPCoopStateless)stateBehaviour_newConnection).setIDCorrelazioneApplicativaRisposta(((OpenSPCoopStateless)this.openSPCoopState).getIDCorrelazioneApplicativaRisposta());
                                ((OpenSPCoopStateless)stateBehaviour_newConnection).setPddContext(((OpenSPCoopStateless)this.openSPCoopState).getPddContext());
                                stateBehaviour_newConnection.initResource(this.identitaPdD, "EJBUtils.behaviour_" + pa.getBehaviour().getNome(), string);
                            }
                        }
                        if ((bustaNewMessaggio = behaviourForwardTo.getBusta()) == null) {
                            bustaNewMessaggio = busta.newInstance();
                            bustaNewMessaggio.setID("gw-" + i + "-" + busta.getID());
                        }
                        bustaNewMessaggio.setRiferimentoMessaggio(busta.getID());
                        bustaNewMessaggio.addProperty("@DESCRIZIONE_BEHAVIOUR@", behaviourForwardTo.getDescription());
                        IOpenSPCoopState stateNuoviMessaggi = this.openSPCoopState;
                        if (stateBehaviour_newConnection != null) {
                            stateNuoviMessaggi = stateBehaviour_newConnection;
                        } else if (stateBehaviour_onlyUseConnectionFalse != null) {
                            stateNuoviMessaggi = stateBehaviour_onlyUseConnectionFalse;
                        }
                        GestoreMessaggi gestoreNewMessaggio = new GestoreMessaggi(stateNuoviMessaggi, true, bustaNewMessaggio.getID(), "INBOX", this.msgDiag, this.pddContext);
                        RepositoryBuste repositoryBusteNewMessaggio = new RepositoryBuste(stateNuoviMessaggi.getStatoRichiesta(), true, this.protocolFactory);
                        OpenSPCoop2Message messaggioDaNotificare = behaviourForwardTo.getMessage();
                        if (tipiMessaggiNotificabili != null && MessaggioDaNotificare.RISPOSTA.equals(tipiMessaggiNotificabili)) {
                            messaggioDaNotificare = messaggioDaNotificare.getFactory().createEmptyMessage(MessageType.BINARY, MessageRole.NONE);
                        }
                        Timestamp oraRegistrazione = EJBUtils._forceSaveMessage(this.propertiesReader, gestoreNewMessaggio, null, bustaNewMessaggio, richiestaApplicativa, repositoryBusteNewMessaggio, messaggioDaNotificare, stateNuoviMessaggi, this.pddContext, this.identitaPdD);
                        this._sendMessageToServiziApplicativi(serviziApplicativiAbilitatiForwardTo, soggettiRealiMappatiInUnSoggettoVirtuale, richiestaApplicativa, localForwardRichiestaDelegata, gestoreNewMessaggio, bustaNewMessaggio, pa, repositoryBusteNewMessaggio, busta.getID(), behaviourForwardTo.getConfig(), stateless, stateNuoviMessaggi, stateBehaviour_newConnection != null, behaviourForwardTo.getMessage(), !EFFETTUA_SPEDIZIONE_CONSEGNA_CONTENUTI, attendiEsitoTransazioneSincronaPrimaDiSpedire, null, true, oraRegistrazione, requestInfo);
                        if (!stateless || this.propertiesReader.isServerJ2EE().booleanValue()) continue;
                        if (stateBehaviour_newConnection != null) {
                            if (stateBehaviour_newConnection.resourceReleased()) {
                                stateBehaviour_newConnection.updateResource(string);
                            }
                            stateBehaviour_newConnection.commit();
                            continue;
                        }
                        if (stateBehaviour_onlyUseConnectionFalse == null) continue;
                        stateBehaviour_onlyUseConnectionFalse.commit();
                        continue;
                    }
                    finally {
                        if (stateless && !this.propertiesReader.isServerJ2EE().booleanValue()) {
                            if (stateBehaviour_newConnection != null) {
                                stateBehaviour_newConnection.releaseResource();
                            } else if (stateBehaviour_onlyUseConnectionFalse != null) {
                                stateBehaviour_onlyUseConnectionFalse.setUseConnection(oldUseConnection);
                            }
                        }
                    }
                }
            }
            return behaviour;
        }
        catch (EJBUtilsConsegnaException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.error("Spedizione->ConsegnaContenutiApplicativi(RichiestaApplicativa) non riuscita", (Throwable)e);
            this.log.error("EJBUtils.sendToConsegnaContenutiApplicativi(RichiestaApplicativa)", (Throwable)e);
            this.msgDiag.logErroreGenerico(e, "EJBUtils.sendToConsegnaContenutiApplicativi(RichiestaApplicativa)");
            throw new EJBUtilsException("EJBUtils.sendToConsegnaContenutiApplicativi error: " + e.getMessage(), e);
        }
    }

    private static void overwriteIdSoggetto(IDServizio idServizio, IDSoggetto idSoggetto) {
        idServizio.setSoggettoErogatore(idSoggetto);
    }

    private void _sendMessageToServiziApplicativi(List<String> serviziApplicativi, SoggettoVirtuale soggettiRealiMappatiInUnSoggettoVirtuale, RichiestaApplicativa richiestaApplicativaParam, RichiestaDelegata localForwardRichiestaDelegata, GestoreMessaggi gestoreMessaggi, Busta busta, PortaApplicativa pa, RepositoryBuste repositoryBuste, String idBustaPreBehaviourNewMessage, BehaviourForwardToConfiguration behaviourForwardToConfiguration, boolean stateless, IOpenSPCoopState state, boolean releseaResource, OpenSPCoop2Message requestMessageNullable, boolean spedizioneConsegnaContenuti, boolean attendiEsitoTransazioneSincronaPrimaDiSpedire, BehaviourLoadBalancer loadBalancer, boolean presaInCarico, Timestamp dataRegistrazioneMessaggio, RequestInfo requestInfo) throws Exception {
        boolean registrazioneMessaggioPerStatelessEffettuata = false;
        boolean gestioneSolamenteConIntegrationManager = true;
        HashMap<String, Boolean> mapServizioApplicativoConConnettore = new HashMap<String, Boolean>();
        HashMap<String, Boolean> mapSbustamentoSoap = new HashMap<String, Boolean>();
        HashMap<String, Boolean> mapSbustamentoInformazioniProtocollo = new HashMap<String, Boolean>();
        HashMap<String, Boolean> mapGetMessage = new HashMap<String, Boolean>();
        HashMap<String, String> mapTipoConsegna = new HashMap<String, String>();
        HashMap<String, Timestamp> mapOraRegistrazione = new HashMap<String, Timestamp>();
        HashMap<String, ConsegnaContenutiApplicativiMessage> mapConsegnaContenutiApplicativiMessage = new HashMap<String, ConsegnaContenutiApplicativiMessage>();
        RichiestaApplicativa richiestaApplicativa = null;
        if (richiestaApplicativaParam != null) {
            richiestaApplicativa = (RichiestaApplicativa)richiestaApplicativaParam.clone();
        }
        String nomePorta = null;
        if (richiestaApplicativa != null && richiestaApplicativa.getIdPortaApplicativa() != null) {
            nomePorta = richiestaApplicativa.getIdPortaApplicativa().getNome();
        }
        for (String servizioApplicativo : serviziApplicativi) {
            if (soggettiRealiMappatiInUnSoggettoVirtuale != null) {
                String oldDominio = richiestaApplicativa.getIDServizio().getSoggettoErogatore().getCodicePorta();
                EJBUtils.overwriteIdSoggetto(richiestaApplicativa.getIDServizio(), soggettiRealiMappatiInUnSoggettoVirtuale.getSoggettoReale(servizioApplicativo));
                richiestaApplicativa.getIDServizio().getSoggettoErogatore().setCodicePorta(oldDominio);
                richiestaApplicativa.setIdPortaApplicativa(soggettiRealiMappatiInUnSoggettoVirtuale.getIDPortaApplicativa(servizioApplicativo));
                servizioApplicativo = soggettiRealiMappatiInUnSoggettoVirtuale.getNomeServizioApplicativo(servizioApplicativo);
            }
            this.msgDiag.highDebug("[EJBUtils] Creazione ObjectMessage for send nell'infrastruttura.");
            ConsegnaContenutiApplicativiMessage consegnaMSG = new ConsegnaContenutiApplicativiMessage();
            consegnaMSG.setBusta(busta);
            consegnaMSG.setOneWayVersione11(this.oneWayVersione11);
            consegnaMSG.setStateless(this.portaDiTipoStateless_esclusoOneWay11);
            consegnaMSG.setImplementazionePdDSoggettoMittente(this.implementazionePdDSoggettoMittente);
            consegnaMSG.setImplementazionePdDSoggettoDestinatario(this.implementazionePdDSoggettoDestinatario);
            consegnaMSG.setPddContext(this.pddContext);
            consegnaMSG.setRichiestaDelegata(localForwardRichiestaDelegata);
            String coda = null;
            String priorita = null;
            boolean schedulingNonAttivo = false;
            if (presaInCarico) {
                coda = "DEFAULT";
                priorita = "DEFAULT";
            }
            boolean gestioneTramiteConnettoriMultipli = false;
            if (idBustaPreBehaviourNewMessage != null || behaviourForwardToConfiguration != null) {
                gestioneTramiteConnettoriMultipli = true;
                ConsegnaContenutiApplicativiBehaviourMessage behaviourMsg = new ConsegnaContenutiApplicativiBehaviourMessage();
                behaviourMsg.setIdMessaggioPreBehaviour(idBustaPreBehaviourNewMessage);
                behaviourMsg.setBehaviourForwardToConfiguration(behaviourForwardToConfiguration);
                IdTransazioneApplicativoServer idTransazioneApplicativoServer = new IdTransazioneApplicativoServer();
                idTransazioneApplicativoServer.setIdTransazione(PdDContext.getValue((MapKey<String>)Costanti.ID_TRANSAZIONE, this.pddContext));
                idTransazioneApplicativoServer.setServizioApplicativoErogatore(servizioApplicativo);
                if (pa != null && pa.getServizioApplicativoList() != null) {
                    for (PortaApplicativaServizioApplicativo pasa : pa.getServizioApplicativoList()) {
                        if (!pasa.getNome().equals(servizioApplicativo)) continue;
                        if (pasa.getDatiConnettore() != null) {
                            idTransazioneApplicativoServer.setConnettoreNome(pasa.getDatiConnettore().getNome());
                            if (presaInCarico) {
                                if (pasa.getDatiConnettore().getCoda() != null) {
                                    coda = pasa.getDatiConnettore().getCoda();
                                }
                                if (pasa.getDatiConnettore().getPriorita() != null) {
                                    priorita = pasa.getDatiConnettore().getPriorita();
                                }
                                if (org.openspcoop2.core.config.constants.StatoFunzionalita.DISABILITATO.equals((Object)pasa.getDatiConnettore().getScheduling())) {
                                    schedulingNonAttivo = true;
                                }
                            }
                        }
                        ConfigurazioneGestioneConsegnaNotifiche configGestioneConsegna = MultiDeliverUtils.read(pasa);
                        GestioneErrore gestioneErroreBehaviour = GestioneConsegnaNotificheUtils.toGestioneErrore(configGestioneConsegna);
                        behaviourMsg.setGestioneErrore(gestioneErroreBehaviour);
                        break;
                    }
                }
                behaviourMsg.setIdTransazioneApplicativoServer(idTransazioneApplicativoServer);
                consegnaMSG.setBehaviour(behaviourMsg);
                consegnaMSG.setPddContext(this.pddContext != null ? (PdDContext)this.pddContext.clone() : null);
            }
            if (loadBalancer != null) {
                consegnaMSG.setLoadBalancer(loadBalancer);
            }
            this.msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_EROGATORE@", servizioApplicativo);
            richiestaApplicativa.setServizioApplicativo(servizioApplicativo);
            IDServizioApplicativo idSA = new IDServizioApplicativo();
            idSA.setNome(servizioApplicativo);
            idSA.setIdSoggettoProprietario(richiestaApplicativa.getIDServizio().getSoggettoErogatore());
            ServizioApplicativo sappl = this.configurazionePdDReader.getServizioApplicativo(idSA, requestInfo);
            if (!presaInCarico) {
                this.msgDiag.setServizioApplicativo(servizioApplicativo);
            }
            boolean servizioApplicativoConConnettore = true;
            boolean getMessageAbilitato = false;
            boolean sbustamento_soap = false;
            boolean sbustamento_informazioni_protocollo = true;
            if ("AsincronoAsimmetrico_Polling".equals(richiestaApplicativa.getScenario())) {
                sbustamento_soap = this.configurazionePdDReader.consegnaRispostaAsincronaConSbustamento(sappl);
                sbustamento_informazioni_protocollo = this.configurazionePdDReader.consegnaRispostaAsincronaConSbustamentoInformazioniProtocollo(sappl);
                servizioApplicativoConConnettore = this.configurazionePdDReader.consegnaRispostaAsincronaConConnettore(sappl);
            } else {
                servizioApplicativoConConnettore = this.configurazionePdDReader.invocazioneServizioConConnettore(sappl);
                sbustamento_soap = this.configurazionePdDReader.invocazioneServizioConSbustamento(sappl);
                sbustamento_informazioni_protocollo = this.configurazionePdDReader.invocazioneServizioConSbustamentoInformazioniProtocollo(sappl);
                getMessageAbilitato = this.configurazionePdDReader.invocazioneServizioConGetMessage(sappl);
            }
            if (behaviourForwardToConfiguration != null) {
                if (behaviourForwardToConfiguration.getSbustamentoInformazioniProtocollo() != null) {
                    if (StatoFunzionalita.ABILITATA.equals(behaviourForwardToConfiguration.getSbustamentoInformazioniProtocollo())) {
                        sbustamento_informazioni_protocollo = true;
                    } else if (StatoFunzionalita.DISABILITATA.equals(behaviourForwardToConfiguration.getSbustamentoInformazioniProtocollo())) {
                        sbustamento_informazioni_protocollo = false;
                    }
                }
                if (behaviourForwardToConfiguration.getSbustamentoSoap() != null) {
                    if (StatoFunzionalita.ABILITATA.equals(behaviourForwardToConfiguration.getSbustamentoSoap())) {
                        sbustamento_soap = true;
                    } else if (StatoFunzionalita.DISABILITATA.equals(behaviourForwardToConfiguration.getSbustamentoSoap())) {
                        sbustamento_soap = false;
                    }
                }
            }
            if (localForwardRichiestaDelegata != null) {
                sbustamento_informazioni_protocollo = false;
            }
            if (!getMessageAbilitato && !servizioApplicativoConConnettore) {
                throw new EJBUtilsConsegnaException(this.msgDiag, "consegnaContenutiApplicativi.", "consegnaNonDefinita");
            }
            if (state instanceof OpenSPCoopStateless && !this.oneWayVersione11 && getMessageAbilitato && servizioApplicativoConConnettore && idBustaPreBehaviourNewMessage == null) {
                throw new EJBUtilsConsegnaException(this.msgDiag, "consegnaContenutiApplicativi.", "gestioneStateless.integrationManager");
            }
            if (!servizioApplicativoConConnettore && idBustaPreBehaviourNewMessage == null) {
                if (ProfiloDiCollaborazione.SINCRONO.equals((Object)busta.getProfiloDiCollaborazione())) {
                    throw new EJBUtilsConsegnaException(this.msgDiag, "consegnaContenutiApplicativi.", "trasmissioneSincrona.servizioNonUtilizzabile");
                }
                if (richiestaApplicativa.isRicevutaAsincrona() && (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)busta.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)busta.getProfiloDiCollaborazione()))) {
                    throw new EJBUtilsConsegnaException(this.msgDiag, "consegnaContenutiApplicativi.", "gestioneProfiloAsincrono.servizioNonUtilizzabile");
                }
                if ("AsincronoAsimmetrico_Polling".equals(richiestaApplicativa.getScenario())) {
                    throw new EJBUtilsConsegnaException("(Polling AsincronoAsimmetrico) " + this.msgDiag.getMessaggio_replaceKeywords("consegnaContenutiApplicativi.", "trasmissioneSincrona.servizioNonUtilizzabile"), this.msgDiag.getLivello("consegnaContenutiApplicativi.", "trasmissioneSincrona.servizioNonUtilizzabile"), this.msgDiag.getCodice("consegnaContenutiApplicativi.", "trasmissioneSincrona.servizioNonUtilizzabile"));
                }
            }
            String tipoConsegna = "IntegrationManager";
            if (servizioApplicativoConConnettore) {
                tipoConsegna = "Connettore";
            }
            Timestamp oraRegistrazioneMessaggio = null;
            oraRegistrazioneMessaggio = dataRegistrazioneMessaggio != null ? dataRegistrazioneMessaggio : gestoreMessaggi.getOraRegistrazioneMessaggio();
            if (idBustaPreBehaviourNewMessage != null) {
                gestoreMessaggi.setOneWayVersione11(true);
            }
            gestoreMessaggi.registraDestinatarioMessaggio(servizioApplicativo, sbustamento_soap, sbustamento_informazioni_protocollo, getMessageAbilitato, tipoConsegna, oraRegistrazioneMessaggio, nomePorta, attendiEsitoTransazioneSincronaPrimaDiSpedire, servizioApplicativoConConnettore && !spedizioneConsegnaContenuti, coda, priorita, schedulingNonAttivo);
            mapServizioApplicativoConConnettore.put(servizioApplicativo, servizioApplicativoConConnettore);
            mapSbustamentoSoap.put(servizioApplicativo, sbustamento_soap);
            mapSbustamentoInformazioniProtocollo.put(servizioApplicativo, sbustamento_informazioni_protocollo);
            mapGetMessage.put(servizioApplicativo, getMessageAbilitato);
            mapTipoConsegna.put(servizioApplicativo, tipoConsegna);
            mapOraRegistrazione.put(servizioApplicativo, oraRegistrazioneMessaggio);
            mapConsegnaContenutiApplicativiMessage.put(servizioApplicativo, consegnaMSG);
            if (!getMessageAbilitato || servizioApplicativoConConnettore || gestioneTramiteConnettoriMultipli) continue;
            ConsegnaContenutiApplicativiBehaviourMessage behaviourMsg = new ConsegnaContenutiApplicativiBehaviourMessage();
            IdTransazioneApplicativoServer idTransazioneApplicativoServer = new IdTransazioneApplicativoServer();
            idTransazioneApplicativoServer.setIdTransazione(PdDContext.getValue((MapKey<String>)Costanti.ID_TRANSAZIONE, this.pddContext));
            idTransazioneApplicativoServer.setServizioApplicativoErogatore(servizioApplicativo);
            idTransazioneApplicativoServer.setConnettoreNome("Default");
            behaviourMsg.setIdTransazioneApplicativoServer(idTransazioneApplicativoServer);
            consegnaMSG.setBehaviour(behaviourMsg);
            consegnaMSG.setPddContext(this.pddContext != null ? (PdDContext)this.pddContext.clone() : null);
            if (this.pddContext == null) continue;
            this.pddContext.addObject(Costanti.MESSAGE_BOX, "true");
        }
        boolean registrazioneDestinatarioEffettuataPerViaBehaviour = false;
        if (idBustaPreBehaviourNewMessage != null && stateless && !this.propertiesReader.isServerJ2EE().booleanValue()) {
            state.commit();
            if (releseaResource) {
                state.releaseResource();
            }
            registrazioneDestinatarioEffettuataPerViaBehaviour = true;
        }
        EJBUtilsMessaggioInConsegna messaggiInConsegna = new EJBUtilsMessaggioInConsegna();
        messaggiInConsegna.setServiziApplicativi(serviziApplicativi);
        messaggiInConsegna.setSoggettiRealiMappatiInUnSoggettoVirtuale(soggettiRealiMappatiInUnSoggettoVirtuale);
        messaggiInConsegna.setRichiestaApplicativa(richiestaApplicativa);
        messaggiInConsegna.setMapServizioApplicativoConConnettore(mapServizioApplicativoConConnettore);
        messaggiInConsegna.setMapSbustamentoSoap(mapSbustamentoSoap);
        messaggiInConsegna.setMapSbustamentoInformazioniProtocollo(mapSbustamentoInformazioniProtocollo);
        messaggiInConsegna.setMapGetMessage(mapGetMessage);
        messaggiInConsegna.setMapTipoConsegna(mapTipoConsegna);
        messaggiInConsegna.setMapOraRegistrazione(mapOraRegistrazione);
        messaggiInConsegna.setMapConsegnaContenutiApplicativiMessage(mapConsegnaContenutiApplicativiMessage);
        messaggiInConsegna.setRegistrazioneMessaggioPerStatelessEffettuata(registrazioneMessaggioPerStatelessEffettuata);
        messaggiInConsegna.setGestioneSolamenteConIntegrationManager(gestioneSolamenteConIntegrationManager);
        messaggiInConsegna.setRegistrazioneDestinatarioEffettuataPerViaBehaviour(registrazioneDestinatarioEffettuataPerViaBehaviour);
        messaggiInConsegna.setStateless(stateless);
        messaggiInConsegna.setOneWayVersione11(this.oneWayVersione11);
        messaggiInConsegna.setIdBustaPreBehaviourNewMessage(idBustaPreBehaviourNewMessage);
        messaggiInConsegna.setBusta(busta);
        messaggiInConsegna.setNomePorta(nomePorta);
        messaggiInConsegna.setRequestMessageNullable(requestMessageNullable);
        messaggiInConsegna.setOraRegistrazioneMessaggio(dataRegistrazioneMessaggio);
        if (attendiEsitoTransazioneSincronaPrimaDiSpedire) {
            this.pddContext.addObject(CostantiPdD.TIMER_RICONSEGNA_CONTENUTI_APPLICATIVI_MESSAGGI_SPEDIRE, messaggiInConsegna);
        } else {
            EJBUtilsMessaggioInConsegnaEsito esito = EJBUtils.sendMessages(this.log, this.msgDiag, state, this.idSessione, repositoryBuste, gestoreMessaggi, this.nodeSender, this.protocolFactory, this.identitaPdD, nomePorta, messaggiInConsegna, spedizioneConsegnaContenuti, this.pddContext, this.configurazionePdDReader);
            this.gestioneSolamenteConIntegrationManager = esito.isGestioneSolamenteConIntegrationManager();
            this.gestioneStatelessConIntegrationManager = esito.isGestioneStatelessConIntegrationManager();
        }
    }

    public static EJBUtilsMessaggioInConsegnaEsito sendMessages(Logger log, MsgDiagnostico msgDiag, IOpenSPCoopState state, String idSessioneParam, RepositoryBuste repositoryBuste, GestoreMessaggi gestoreMessaggi, INodeSender nodeSender, IProtocolFactory<?> protocolFactory, IDSoggetto identitaPdD, String idModulo, EJBUtilsMessaggioInConsegna message, boolean spedizioneConsegnaContenuti, PdDContext pddContext, ConfigurazionePdDManager configurazionePdDManager) throws Exception {
        RequestInfo requestInfo = null;
        if (pddContext != null && pddContext.containsKey(Costanti.REQUEST_INFO)) {
            requestInfo = (RequestInfo)pddContext.getObject(Costanti.REQUEST_INFO);
        }
        EJBUtilsMessaggioInConsegnaEsito esito = new EJBUtilsMessaggioInConsegnaEsito();
        OpenSPCoop2Properties propertiesReader = OpenSPCoop2Properties.getInstance();
        List<String> serviziApplicativi = message.getServiziApplicativi();
        SoggettoVirtuale soggettiRealiMappatiInUnSoggettoVirtuale = message.getSoggettiRealiMappatiInUnSoggettoVirtuale();
        RichiestaApplicativa richiestaApplicativa = message.getRichiestaApplicativa();
        Map<String, Boolean> mapServizioApplicativoConConnettore = message.getMapServizioApplicativoConConnettore();
        Map<String, Boolean> mapSbustamentoSoap = message.getMapSbustamentoSoap();
        Map<String, Boolean> mapSbustamentoInformazioniProtocollo = message.getMapSbustamentoInformazioniProtocollo();
        Map<String, Boolean> mapGetMessage = message.getMapGetMessage();
        Map<String, String> mapTipoConsegna = message.getMapTipoConsegna();
        Map<String, Timestamp> mapOraRegistrazione = message.getMapOraRegistrazione();
        Map<String, ConsegnaContenutiApplicativiMessage> mapConsegnaContenutiApplicativiMessage = message.getMapConsegnaContenutiApplicativiMessage();
        boolean registrazioneMessaggioPerStatelessEffettuata = message.isRegistrazioneMessaggioPerStatelessEffettuata();
        boolean gestioneSolamenteConIntegrationManager = message.isGestioneSolamenteConIntegrationManager();
        boolean registrazioneDestinatarioEffettuataPerViaBehaviour = message.isRegistrazioneDestinatarioEffettuataPerViaBehaviour();
        boolean stateless = message.isStateless();
        boolean oneWayVersione11 = message.isOneWayVersione11();
        String idBustaPreBehaviourNewMessage = message.getIdBustaPreBehaviourNewMessage();
        Busta busta = message.getBusta();
        String nomePorta = message.getNomePorta();
        OpenSPCoop2Message requestMessageNullable = message.getRequestMessageNullable();
        Date dataRegistrazioneMessaggio = message.getOraRegistrazioneMessaggio();
        for (String servizioApplicativo : serviziApplicativi) {
            if (soggettiRealiMappatiInUnSoggettoVirtuale != null) {
                String oldDominio = richiestaApplicativa.getIDServizio().getSoggettoErogatore().getCodicePorta();
                EJBUtils.overwriteIdSoggetto(richiestaApplicativa.getIDServizio(), soggettiRealiMappatiInUnSoggettoVirtuale.getSoggettoReale(servizioApplicativo));
                richiestaApplicativa.getIDServizio().getSoggettoErogatore().setCodicePorta(oldDominio);
                richiestaApplicativa.setIdPortaApplicativa(soggettiRealiMappatiInUnSoggettoVirtuale.getIDPortaApplicativa(servizioApplicativo));
                servizioApplicativo = soggettiRealiMappatiInUnSoggettoVirtuale.getNomeServizioApplicativo(servizioApplicativo);
            }
            boolean servizioApplicativoConConnettore = mapServizioApplicativoConConnettore.get(servizioApplicativo);
            boolean sbustamento_soap = mapSbustamentoSoap.get(servizioApplicativo);
            boolean sbustamento_informazioni_protocollo = mapSbustamentoInformazioniProtocollo.get(servizioApplicativo);
            boolean getMessageAbilitato = mapGetMessage.get(servizioApplicativo);
            String tipoConsegna = mapTipoConsegna.get(servizioApplicativo);
            Timestamp oraRegistrazioneMessaggio = mapOraRegistrazione.get(servizioApplicativo);
            ConsegnaContenutiApplicativiMessage consegnaMSG = mapConsegnaContenutiApplicativiMessage.get(servizioApplicativo);
            msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_EROGATORE@", servizioApplicativo);
            richiestaApplicativa.setServizioApplicativo(servizioApplicativo);
            TransazioneApplicativoServer transazioneApplicativoServer = null;
            if (consegnaMSG.getBehaviour() != null && consegnaMSG.getBehaviour().getIdTransazioneApplicativoServer() != null) {
                transazioneApplicativoServer = new TransazioneApplicativoServer();
                transazioneApplicativoServer.setIdTransazione(consegnaMSG.getBehaviour().getIdTransazioneApplicativoServer().getIdTransazione());
                transazioneApplicativoServer.setServizioApplicativoErogatore(consegnaMSG.getBehaviour().getIdTransazioneApplicativoServer().getServizioApplicativoErogatore());
                transazioneApplicativoServer.setConnettoreNome(consegnaMSG.getBehaviour().getIdTransazioneApplicativoServer().getConnettoreNome());
                if (dataRegistrazioneMessaggio != null) {
                    transazioneApplicativoServer.setDataRegistrazione(dataRegistrazioneMessaggio);
                } else {
                    transazioneApplicativoServer.setDataRegistrazione(DateManager.getDate());
                }
                transazioneApplicativoServer.setProtocollo(protocolFactory.getProtocol());
                transazioneApplicativoServer.setDataAccettazioneRichiesta(DateManager.getDate());
                if (requestMessageNullable != null) {
                    transazioneApplicativoServer.setRichiestaUscitaBytes(Long.valueOf(requestMessageNullable.getOutgoingMessageContentLength()));
                }
                transazioneApplicativoServer.setIdentificativoMessaggio(consegnaMSG.getBusta().getID());
                transazioneApplicativoServer.setClusterIdPresaInCarico(propertiesReader.getClusterId(false));
                transazioneApplicativoServer.setConsegnaTrasparente(servizioApplicativoConConnettore);
                transazioneApplicativoServer.setConsegnaIntegrationManager(getMessageAbilitato);
                if (transazioneApplicativoServer != null) {
                    try {
                        GestoreConsegnaMultipla.getInstance().safeCreate(transazioneApplicativoServer, richiestaApplicativa.getIdPortaApplicativa(), state, requestInfo, pddContext);
                    }
                    catch (Throwable t) {
                        log.error("[" + transazioneApplicativoServer.getIdTransazione() + "][" + transazioneApplicativoServer.getServizioApplicativoErogatore() + "] Errore durante il salvataggio delle informazioni relative al servizio applicativo: " + t.getMessage(), t);
                    }
                }
            }
            if (transazioneApplicativoServer == null) {
                msgDiag.setServizioApplicativo(servizioApplicativo);
            }
            if (servizioApplicativoConConnettore) {
                gestioneSolamenteConIntegrationManager = false;
                consegnaMSG.setRichiestaApplicativa(richiestaApplicativa);
                if (spedizioneConsegnaContenuti) {
                    if (!stateless || propertiesReader.isServerJ2EE().booleanValue() && idBustaPreBehaviourNewMessage != null) {
                        if (oneWayVersione11) {
                            OpenSPCoopStateless statelessSerializzabile = ((OpenSPCoopStateless)state).rendiSerializzabile();
                            consegnaMSG.setOpenspcoopstate(statelessSerializzabile);
                        }
                        try {
                            String idSessione = idSessioneParam;
                            if (idBustaPreBehaviourNewMessage != null) {
                                idSessione = busta.getID();
                            }
                            nodeSender.send(consegnaMSG, "ConsegnaContenutiApplicativi", msgDiag, identitaPdD, idModulo, idSessione, gestoreMessaggi);
                            continue;
                        }
                        catch (Exception e) {
                            msgDiag.logErroreGenerico(e, "EJBUtils.sendToConsegnaContenutiApplicativi(RichiestaApplicativa).senderJMS");
                            throw e;
                        }
                    }
                    ((OpenSPCoopStateless)state).setMessageLib(consegnaMSG);
                    ((OpenSPCoopStateless)state).setDestinatarioRequestMsgLib("ConsegnaContenutiApplicativi");
                    if (idBustaPreBehaviourNewMessage == null) continue;
                    ConsegnaContenutiApplicativi lib = new ConsegnaContenutiApplicativi(log);
                    EsitoLib result = lib.onMessage(state, configurazionePdDManager);
                    log.debug("Invocato ConsegnaContenutiApplicativi per [" + busta.getID() + "] con esito: " + result.getStatoInvocazione(), result.getErroreNonGestito());
                    continue;
                }
                if (transazioneApplicativoServer == null) continue;
                msgDiag.logPersonalizzato("consegnaContenutiApplicativi.", "queue.messaggioSchedulato");
                continue;
            }
            if (!registrazioneDestinatarioEffettuataPerViaBehaviour && state instanceof OpenSPCoopStateless && !oneWayVersione11) {
                esito.setGestioneStatelessConIntegrationManager(true);
                if (idBustaPreBehaviourNewMessage == null && !registrazioneMessaggioPerStatelessEffettuata) {
                    EJBUtils._forceSaveMessage(propertiesReader, gestoreMessaggi, gestoreMessaggi.getOraRegistrazioneMessaggio(), busta, richiestaApplicativa, repositoryBuste, ((OpenSPCoopStateless)state).getRichiestaMsg(), state, pddContext, identitaPdD);
                    registrazioneMessaggioPerStatelessEffettuata = true;
                }
                gestoreMessaggi.setOneWayVersione11(true);
                gestoreMessaggi.registraDestinatarioMessaggio(servizioApplicativo, sbustamento_soap, sbustamento_informazioni_protocollo, getMessageAbilitato, tipoConsegna, oraRegistrazioneMessaggio, nomePorta, false, false, null, null, false);
                gestoreMessaggi.setOneWayVersione11(false);
            }
            msgDiag.logPersonalizzato("consegnaContenutiApplicativi.", "integrationManager.messaggioDisponibile");
        }
        esito.setGestioneSolamenteConIntegrationManager(gestioneSolamenteConIntegrationManager);
        return esito;
    }

    private static Timestamp _forceSaveMessage(OpenSPCoop2Properties propertiesReader, GestoreMessaggi gestoreMessaggi, Timestamp oraRegistrazione, Busta busta, RichiestaApplicativa richiestaApplicativa, RepositoryBuste repositoryBuste, OpenSPCoop2Message message, IOpenSPCoopState state, PdDContext pddContext, IDSoggetto identitaPdD) throws Exception {
        if (state.resourceReleased()) {
            ((OpenSPCoopState)state).setUseConnection(true);
            String idTransazione = (String)pddContext.getObject(Costanti.ID_TRANSAZIONE);
            ((OpenSPCoopState)state).initResource(identitaPdD, "EJBUtils.saveMessage", idTransazione);
            gestoreMessaggi.updateOpenSPCoopState(state);
            repositoryBuste.updateState(state.getStatoRichiesta());
        }
        Timestamp oraRegistrazioneT = gestoreMessaggi.registraInformazioniMessaggio_statelessEngine(oraRegistrazione, "ConsegnaContenutiApplicativi", busta.getRiferimentoMessaggio(), richiestaApplicativa.getIdCorrelazioneApplicativa(), null);
        boolean consumeMessage = true;
        gestoreMessaggi.registraMessaggio_statelessEngine(message, !consumeMessage, oraRegistrazioneT);
        String key = "INSERT RegistrazioneBustaForHistoryINBOX_" + busta.getID();
        if (repositoryBuste.isRegistrataIntoInBox(busta.getID())) {
            repositoryBuste.aggiornaBustaIntoInBox(busta, propertiesReader.getRepositoryIntervalloScadenzaMessaggi(), true);
            repositoryBuste.impostaUtilizzoPdD(busta.getID(), "INBOX");
        } else if (((StateMessage)state.getStatoRichiesta()).getPreparedStatement().containsKey(key)) {
            repositoryBuste.aggiornaBustaIntoInBox(busta, propertiesReader.getRepositoryIntervalloScadenzaMessaggi(), true);
            repositoryBuste.impostaUtilizzoPdD(busta.getID(), "INBOX");
        } else {
            repositoryBuste.registraBustaIntoInBox(busta, propertiesReader.getRepositoryIntervalloScadenzaMessaggi(), true);
            if (!(state instanceof OpenSPCoopStateful) && busta.sizeProperties() > 0) {
                HashMap<String, String> bustaProperties = new HashMap<String, String>();
                String[] propertyNames = busta.getPropertiesNames();
                if (propertyNames != null) {
                    for (int i = 0; i < propertyNames.length; ++i) {
                        String keyP = propertyNames[i];
                        String valueP = busta.getProperty(key);
                        if (keyP == null || valueP == null) continue;
                        bustaProperties.put(keyP, valueP);
                    }
                }
                repositoryBuste.aggiornaProprietaBustaIntoInBox(bustaProperties, busta.getID());
            }
        }
        return oraRegistrazioneT;
    }

    public void sendAsRispostaBustaErroreProcessamento(String idModuloInAttesa, Busta busta, ErroreIntegrazione errore, String idCorrelazioneApplicativa, String servizioApplicativoFruitore, Throwable eProcessamento, ParseException parseException) throws EJBUtilsException, ProtocolException {
        Eccezione ecc = new Eccezione(ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreProcessamento(errore.getDescrizione(this.protocolFactory)), false, this.idModulo, this.protocolFactory);
        ArrayList<Eccezione> errs = new ArrayList<Eccezione>();
        errs.add(ecc);
        this._sendAsRispostaBustaErroreProcessamento(idModuloInAttesa, busta, errs, errore, idCorrelazioneApplicativa, null, servizioApplicativoFruitore, eProcessamento, parseException, null);
    }

    public void sendAsRispostaBustaErroreProcessamento(String idModuloInAttesa, Busta busta, ErroreIntegrazione errore, String idCorrelazioneApplicativa, String idCorrelazioneApplicativaRisposta, String servizioApplicativoFruitore, Throwable eProcessamento, ParseException parseException) throws EJBUtilsException, ProtocolException {
        Eccezione ecc = new Eccezione(ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreProcessamento(errore.getDescrizione(this.protocolFactory)), false, this.idModulo, this.protocolFactory);
        ArrayList<Eccezione> errs = new ArrayList<Eccezione>();
        errs.add(ecc);
        this._sendAsRispostaBustaErroreProcessamento(idModuloInAttesa, busta, errs, errore, idCorrelazioneApplicativa, idCorrelazioneApplicativaRisposta, servizioApplicativoFruitore, eProcessamento, parseException, null);
    }

    public void sendAsRispostaBustaErroreProcessamento(String idModuloInAttesa, Busta busta, List<Eccezione> errs, String idCorrelazioneApplicativa, String idCorrelazioneApplicativaRisposta, String servizioApplicativoFruitore, Throwable eProcessamento, ParseException parseException) throws EJBUtilsException, ProtocolException {
        this._sendAsRispostaBustaErroreProcessamento(idModuloInAttesa, busta, errs, null, idCorrelazioneApplicativa, idCorrelazioneApplicativaRisposta, servizioApplicativoFruitore, eProcessamento, parseException, null);
    }

    public void sendAsRispostaBustaErroreProcessamento(String idModuloInAttesa, Busta busta, String idCorrelazioneApplicativa, String servizioApplicativoFruitore, OpenSPCoop2Message errorMessageParam, String errorDetail) throws EJBUtilsException, ProtocolException {
        Eccezione ecc = new Eccezione(ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreProcessamento(errorDetail), false, this.idModulo, this.protocolFactory);
        ArrayList<Eccezione> errs = new ArrayList<Eccezione>();
        errs.add(ecc);
        this._sendAsRispostaBustaErroreProcessamento(idModuloInAttesa, busta, errs, null, idCorrelazioneApplicativa, null, servizioApplicativoFruitore, null, null, errorMessageParam);
    }

    public void sendAsRispostaBustaErroreProcessamento(String idModuloInAttesa, Busta busta, String idCorrelazioneApplicativa, String idCorrelazioneApplicativaRisposta, String servizioApplicativoFruitore, OpenSPCoop2Message errorMessageParam, String errorDetail) throws EJBUtilsException, ProtocolException {
        Eccezione ecc = new Eccezione(ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreProcessamento(errorDetail), false, this.idModulo, this.protocolFactory);
        ArrayList<Eccezione> errs = new ArrayList<Eccezione>();
        errs.add(ecc);
        this._sendAsRispostaBustaErroreProcessamento(idModuloInAttesa, busta, errs, null, idCorrelazioneApplicativa, idCorrelazioneApplicativaRisposta, servizioApplicativoFruitore, null, null, errorMessageParam);
    }

    public void sendAsRispostaBustaErroreProcessamento(String idModuloInAttesa, Busta busta, List<Eccezione> errs, String idCorrelazioneApplicativa, String idCorrelazioneApplicativaRisposta, String servizioApplicativoFruitore, OpenSPCoop2Message errorMessageParam) throws EJBUtilsException, ProtocolException {
        this._sendAsRispostaBustaErroreProcessamento(idModuloInAttesa, busta, errs, null, idCorrelazioneApplicativa, idCorrelazioneApplicativaRisposta, servizioApplicativoFruitore, null, null, errorMessageParam);
    }

    private void _sendAsRispostaBustaErroreProcessamento(String idModuloInAttesa, Busta busta, List<Eccezione> errs, ErroreIntegrazione errore, String idCorrelazioneApplicativa, String idCorrelazioneApplicativaRisposta, String servizioApplicativoFruitore, Throwable eProcessamento, ParseException parseException, OpenSPCoop2Message errorMessageParam) throws EJBUtilsException, ProtocolException {
        if (this.pddContext == null) {
            throw new EJBUtilsException("PddContext undefined");
        }
        String idTransazione = (String)this.pddContext.getObject(Costanti.ID_TRANSAZIONE);
        Imbustamento imbustatore = new Imbustamento(this.log, this.protocolFactory, this.openSPCoopState.getStatoRichiesta());
        String id_bustaErrore = imbustatore.buildID(this.identitaPdD, idTransazione, this.propertiesReader.getGestioneSerializableDBAttesaAttiva(), this.propertiesReader.getGestioneSerializableDBCheckInterval(), RuoloMessaggio.RISPOSTA);
        busta = this.generatoreErrorePortaApplicativa.getImbustamentoErrore().buildMessaggioErroreProtocollo_Processamento(errs, busta, id_bustaErrore, this.propertiesReader.getTipoTempoBusta(this.implementazionePdDSoggettoMittente));
        this.generatoreErrorePortaApplicativa.getImbustamentoErrore().gestioneListaEccezioniMessaggioErroreProtocolloProcessamento(busta);
        if (!this.identitaPdD.getNome().equals(busta.getMittente()) || !this.identitaPdD.getTipo().equals(busta.getTipoMittente())) {
            busta.setMittente(this.identitaPdD.getNome());
            busta.setTipoMittente(this.identitaPdD.getTipo());
            busta.setIdentificativoPortaMittente(this.identitaPdD.getCodicePorta());
            busta.setIndirizzoMittente(null);
        }
        OpenSPCoop2Message errorMsg = null;
        if (errorMessageParam != null) {
            errorMsg = errorMessageParam;
        } else {
            if (errore == null) {
                DettaglioEccezione dettaglioEccezione = this.dettaglioBuilder.buildDettaglioEccezioneFromBusta(this.identitaPdD, this.tipoPdD, this.idModulo, this.servizioApplicativoErogatore, busta, eProcessamento);
                errorMsg = this.generatoreErrorePortaApplicativa.buildErroreProcessamento((Context)this.pddContext, this.getIntegrationFunctionErrorPortaApplicativa(false), dettaglioEccezione);
            } else {
                errorMsg = this.generatoreErrorePortaApplicativa.buildErroreProcessamento(this.pddContext, this.getIntegrationFunctionErrorPortaApplicativa(false), errore, eProcessamento);
            }
            if (errorMsg == null) {
                throw new EJBUtilsException("EJBUtils.sendRispostaErroreProcessamentoProtocollo error: Costruzione Msg Errore Protocollo fallita.");
            }
        }
        IntegrationFunctionError integrationFunctionErrorPortaApplicativa = this.getIntegrationFunctionErrorPortaApplicativa(false);
        if (integrationFunctionErrorPortaApplicativa != null && (IntegrationFunctionError.SERVICE_UNAVAILABLE.equals((Object)integrationFunctionErrorPortaApplicativa) || IntegrationFunctionError.ENDPOINT_REQUEST_TIMED_OUT.equals((Object)integrationFunctionErrorPortaApplicativa))) {
            boolean isEnabled = this.propertiesReader.isEnabledServiceUnavailableRetryAfterPAConnectionFailed();
            Integer retryAfterSeconds = this.propertiesReader.getServiceUnavailableRetryAfterSecondsPAConnectionFailed();
            Integer retryAfterBackOffSeconds = this.propertiesReader.getServiceUnavailableRetryAfterSecondsRandomBackoffPAConnectionFailed();
            if (isEnabled && retryAfterSeconds != null && retryAfterSeconds > 0) {
                int seconds = retryAfterSeconds;
                if (retryAfterBackOffSeconds != null && retryAfterBackOffSeconds > 0) {
                    seconds += ServicesUtils.getRandom().nextInt(retryAfterBackOffSeconds);
                }
                errorMsg.forceTransportHeader("Retry-After", "" + seconds);
            }
        }
        if (eProcessamento != null && eProcessamento instanceof HandlerException) {
            HandlerException he = (HandlerException)eProcessamento;
            he.customized(errorMsg);
        }
        if (parseException != null) {
            errorMsg.setParseException(parseException);
            if (this.pddContext != null) {
                if (MessageRole.REQUEST.equals((Object)parseException.getMessageRole())) {
                    this.pddContext.addObject(Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO, true);
                    this.pddContext.addObject(Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO_PARSE_EXCEPTION, parseException);
                    errorMsg.addContextProperty(Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO, (Object)true);
                    errorMsg.addContextProperty(Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO_PARSE_EXCEPTION, (Object)parseException);
                } else if (MessageRole.RESPONSE.equals((Object)parseException.getMessageRole())) {
                    this.pddContext.addObject(Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO, true);
                    this.pddContext.addObject(Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO_PARSE_EXCEPTION, parseException);
                    errorMsg.addContextProperty(Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO, (Object)true);
                    errorMsg.addContextProperty(Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO_PARSE_EXCEPTION, (Object)parseException);
                }
            }
        }
        this.sendAsRispostaBustaErrore(idModuloInAttesa, busta, errorMsg, false, idCorrelazioneApplicativa, idCorrelazioneApplicativaRisposta, servizioApplicativoFruitore);
    }

    public void sendAsRispostaBustaErroreValidazione(String idModuloInAttesa, Busta busta, Eccezione eccezione, String idCorrelazioneApplicativa, String servizioApplicativoFruitore) throws EJBUtilsException, ProtocolException {
        ArrayList<Eccezione> v = new ArrayList<Eccezione>();
        v.add(eccezione);
        this._sendAsRispostaBustaErroreValidazione(idModuloInAttesa, busta, v, idCorrelazioneApplicativa, null, servizioApplicativoFruitore);
    }

    public void sendAsRispostaBustaErroreValidazione(String idModuloInAttesa, Busta busta, Eccezione eccezione, String idCorrelazioneApplicativa, String idCorrelazioneApplicativaRisposta, String servizioApplicativoFruitore) throws EJBUtilsException, ProtocolException {
        ArrayList<Eccezione> v = new ArrayList<Eccezione>();
        v.add(eccezione);
        this._sendAsRispostaBustaErroreValidazione(idModuloInAttesa, busta, v, idCorrelazioneApplicativa, idCorrelazioneApplicativaRisposta, servizioApplicativoFruitore);
    }

    public void sendAsRispostaBustaErroreValidazione(String idModuloInAttesa, Busta busta, List<Eccezione> eccezioni, String idCorrelazioneApplicativa, String idCorrelazioneApplicativaRisposta, String servizioApplicativoFruitore) throws EJBUtilsException, ProtocolException {
        this._sendAsRispostaBustaErroreValidazione(idModuloInAttesa, busta, eccezioni, idCorrelazioneApplicativa, idCorrelazioneApplicativaRisposta, servizioApplicativoFruitore);
    }

    private void _sendAsRispostaBustaErroreValidazione(String idModuloInAttesa, Busta busta, List<Eccezione> eccezioni, String idCorrelazioneApplicativa, String idCorrelazioneApplicativaRisposta, String servizioApplicativoFruitore) throws EJBUtilsException, ProtocolException {
        Imbustamento imbustatore = new Imbustamento(this.log, this.protocolFactory, this.openSPCoopState.getStatoRichiesta());
        String id_bustaErrore = imbustatore.buildID(this.identitaPdD, (String)this.pddContext.getObject(Costanti.ID_TRANSAZIONE), this.propertiesReader.getGestioneSerializableDBAttesaAttiva(), this.propertiesReader.getGestioneSerializableDBCheckInterval(), RuoloMessaggio.RISPOSTA);
        CodiceErroreCooperazione codiceErroreCooperazione = null;
        String descrizioneErroreCooperazione = null;
        if (eccezioni != null && eccezioni.size() > 0) {
            Eccezione eccezioneDaInviare = Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.ERRORE_GENERICO_PROTOCOLLO_NON_CORRETTO.getErroreCooperazione(), this.protocolFactory);
            if (eccezioni.size() > 1) {
                ITraduttore traduttore = this.protocolFactory.createTraduttore();
                StringBuilder bfDescrizione = new StringBuilder();
                for (int k = 0; k < eccezioni.size(); ++k) {
                    Eccezione error = eccezioni.get(k);
                    if (error.getDescrizione(this.protocolFactory) == null) continue;
                    bfDescrizione.append("[" + traduttore.toString(error.getCodiceEccezione(), error.getSubCodiceEccezione()) + "] " + error.getDescrizione(this.protocolFactory) + "\n");
                }
                if (bfDescrizione.length() > 0) {
                    eccezioneDaInviare.setDescrizione(bfDescrizione.toString());
                }
            } else {
                eccezioneDaInviare = eccezioni.get(0);
            }
            codiceErroreCooperazione = eccezioneDaInviare.getCodiceEccezione();
            descrizioneErroreCooperazione = eccezioneDaInviare.getDescrizione(this.protocolFactory);
        }
        busta = this.generatoreErrorePortaApplicativa.getImbustamentoErrore().buildMessaggioErroreProtocollo_Validazione(eccezioni, busta, id_bustaErrore, this.propertiesReader.getTipoTempoBusta(this.implementazionePdDSoggettoMittente));
        if (!this.identitaPdD.getNome().equals(busta.getMittente()) || !this.identitaPdD.getTipo().equals(busta.getTipoMittente())) {
            busta.setMittente(this.identitaPdD.getNome());
            busta.setTipoMittente(this.identitaPdD.getTipo());
            busta.setIdentificativoPortaMittente(this.identitaPdD.getCodicePorta());
            busta.setIndirizzoMittente(null);
        }
        OpenSPCoop2Message msg = null;
        msg = codiceErroreCooperazione != null && descrizioneErroreCooperazione != null ? this.generatoreErrorePortaApplicativa.buildErroreIntestazione(this.pddContext, this.getIntegrationFunctionErrorPortaApplicativa(true), codiceErroreCooperazione, descrizioneErroreCooperazione) : this.generatoreErrorePortaApplicativa.buildErroreIntestazione(this.pddContext, this.getIntegrationFunctionErrorPortaApplicativa(true));
        if (msg == null) {
            throw new EJBUtilsException("EJBUtils.sendRispostaErroreValidazioneProtocollo error: Costruzione messaggio Errore Protocollo fallita.");
        }
        this.sendAsRispostaBustaErrore(idModuloInAttesa, busta, msg, false, idCorrelazioneApplicativa, idCorrelazioneApplicativaRisposta, servizioApplicativoFruitore);
    }

    public void sendAsRispostaBustaErrore_inoltroSegnalazioneErrore(Busta busta, List<Eccezione> eccezioni) throws EJBUtilsException, ProtocolException {
        String idTransazione = null;
        try {
            idTransazione = UniqueIdentifierManager.newUniqueIdentifier().getAsString();
        }
        catch (Exception e) {
            throw new EJBUtilsException(e.getMessage(), e);
        }
        Imbustamento imbustatore = new Imbustamento(this.log, this.protocolFactory, this.openSPCoopState.getStatoRichiesta());
        String id_bustaErrore = imbustatore.buildID(this.identitaPdD, idTransazione, this.propertiesReader.getGestioneSerializableDBAttesaAttiva(), this.propertiesReader.getGestioneSerializableDBCheckInterval(), RuoloMessaggio.RISPOSTA);
        CodiceErroreCooperazione codiceErroreCooperazione = null;
        String descrizioneErroreCooperazione = null;
        if (eccezioni != null && eccezioni.size() > 0) {
            Eccezione eccezioneDaInviare = Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.ERRORE_GENERICO_PROTOCOLLO_NON_CORRETTO.getErroreCooperazione(), this.protocolFactory);
            if (eccezioni.size() > 1) {
                ITraduttore traduttore = this.protocolFactory.createTraduttore();
                StringBuilder bfDescrizione = new StringBuilder();
                for (int k = 0; k < eccezioni.size(); ++k) {
                    Eccezione error = eccezioni.get(k);
                    if (error.getDescrizione(this.protocolFactory) == null) continue;
                    bfDescrizione.append("[" + traduttore.toString(error.getCodiceEccezione(), error.getSubCodiceEccezione()) + "] " + error.getDescrizione(this.protocolFactory) + "\n");
                }
                if (bfDescrizione.length() > 0) {
                    eccezioneDaInviare.setDescrizione(bfDescrizione.toString());
                }
            } else {
                eccezioneDaInviare = eccezioni.get(0);
            }
            codiceErroreCooperazione = eccezioneDaInviare.getCodiceEccezione();
            descrizioneErroreCooperazione = eccezioneDaInviare.getDescrizione(this.protocolFactory);
        }
        busta = this.generatoreErrorePortaApplicativa.getImbustamentoErrore().buildMessaggioErroreProtocollo_Validazione(eccezioni, busta, id_bustaErrore, this.propertiesReader.getTipoTempoBusta(this.implementazionePdDSoggettoDestinatario));
        OpenSPCoop2Message msg = null;
        msg = codiceErroreCooperazione != null && descrizioneErroreCooperazione != null ? this.generatoreErrorePortaApplicativa.buildErroreIntestazione(this.pddContext, this.getIntegrationFunctionErrorPortaApplicativa(false), codiceErroreCooperazione, descrizioneErroreCooperazione) : this.generatoreErrorePortaApplicativa.buildErroreIntestazione(this.pddContext, this.getIntegrationFunctionErrorPortaApplicativa(false));
        if (msg == null) {
            throw new EJBUtilsException("EJBUtils.sendRispostaErroreProtocollo_BustaRispostaMalformata error: Costruzione Msg Errore Protocollo fallita.");
        }
        this.sendAsRispostaBustaErrore(null, busta, msg, true, null, null, null);
    }

    private void sendAsRispostaBustaErrore(String idModuloInAttesa, Busta busta, OpenSPCoop2Message msg, boolean segnalazioneBustaRispostaMalformata, String idCorrelazioneApplicativa, String idCorrelazioneApplicativaRisposta, String servizioApplicativoFruitore) throws EJBUtilsException {
        StateMessage statoRichiesta = (StateMessage)this.openSPCoopState.getStatoRichiesta();
        StateMessage statoRisposta = (StateMessage)this.openSPCoopState.getStatoRisposta();
        RollbackRepositoryBuste rollbackBuste = null;
        RepositoryBuste repositoryBuste = null;
        GestoreMessaggi msgRequest = null;
        GestoreMessaggi msgResponse = null;
        this.setEJBSuffixFunctionName();
        try {
            boolean addIntoCache = false;
            if (this.rollbackRichiestaInCasoErrore) {
                rollbackBuste = new RollbackRepositoryBuste(this.idSessione, (IState)statoRichiesta, this.oneWayVersione11);
                if (this.routing) {
                    rollbackBuste.rollbackBustaIntoOutBox(this.rollbackRichiestaInCasoErrore_rollbackHistory);
                } else {
                    rollbackBuste.rollbackBustaIntoInBox(this.rollbackRichiestaInCasoErrore_rollbackHistory);
                }
                if (!segnalazioneBustaRispostaMalformata && this.idMessage != null) {
                    msgRequest = new GestoreMessaggi(this.openSPCoopState, true, this.idMessage, this.tipo, this.msgDiag, this.pddContext);
                    msgRequest.setOneWayVersione11(this.oneWayVersione11);
                    if (msgRequest.existsMessage_noCache()) {
                        msgRequest.aggiornaProprietarioMessaggio("GestoreMessaggi");
                        addIntoCache = true;
                    } else {
                        addIntoCache = false;
                    }
                }
            } else {
                msgRequest = new GestoreMessaggi(this.openSPCoopState, true, this.idMessage, this.tipo, this.msgDiag, this.pddContext);
                addIntoCache = false;
            }
            boolean httpReply = true;
            if (this.replyOnNewConnection) {
                httpReply = false;
            }
            if (busta.getIndirizzoDestinatario() != null && this.utilizzoIndirizzoTelematico) {
                httpReply = false;
            }
            if (segnalazioneBustaRispostaMalformata) {
                httpReply = false;
            }
            if (!httpReply || idModuloInAttesa != null) {
                boolean salvaSuDatabasePerStateless = false;
                if (!httpReply) {
                    salvaSuDatabasePerStateless = true;
                }
                repositoryBuste = new RepositoryBuste((IState)statoRisposta, salvaSuDatabasePerStateless, this.protocolFactory);
                repositoryBuste.registraBustaIntoOutBox(busta, this.propertiesReader.getRepositoryIntervalloScadenzaMessaggi());
                Integrazione infoIntegrazione = new Integrazione();
                infoIntegrazione.setIdModuloInAttesa(idModuloInAttesa);
                infoIntegrazione.setScenario(this.scenarioCooperazione);
                repositoryBuste.aggiornaInfoIntegrazioneIntoOutBox(busta.getID(), infoIntegrazione);
                msgResponse = new GestoreMessaggi(this.openSPCoopState, salvaSuDatabasePerStateless, busta.getID(), "OUTBOX", this.msgDiag, this.pddContext);
                if (!httpReply) {
                    msgResponse.setOneWayVersione11(this.oneWayVersione11);
                }
                if (this.openSPCoopState instanceof OpenSPCoopStateless) {
                    msgResponse.registraMessaggio(msg, (Date)((OpenSPCoopStateless)this.openSPCoopState).getTempiAttraversamentoPDD().getRicezioneMsgIngresso(), idCorrelazioneApplicativa, idCorrelazioneApplicativaRisposta);
                } else {
                    msgResponse.registraMessaggio(msg, idCorrelazioneApplicativa, idCorrelazioneApplicativaRisposta);
                }
                msgResponse.aggiornaRiferimentoMessaggio(this.idSessione);
                if (!httpReply) {
                    msgResponse.aggiornaProprietarioMessaggio("InoltroRisposte");
                } else if (idModuloInAttesa != null) {
                    msgResponse.aggiornaProprietarioMessaggio(idModuloInAttesa);
                }
                if (!httpReply) {
                    this.sendToInoltroRisposte(busta, segnalazioneBustaRispostaMalformata, null, msgResponse, idCorrelazioneApplicativa, idCorrelazioneApplicativaRisposta, servizioApplicativoFruitore, true);
                } else if (idModuloInAttesa != null) {
                    this.sendBustaToRicezioneBuste(idModuloInAttesa, busta, null);
                }
            }
            this.openSPCoopState.commit();
            if (msgResponse != null) {
                msgResponse.addMessaggiIntoCache_readFromTable(this.idModulo, "sendRispostaErroreProtocollo [risposta]");
            }
            if (addIntoCache) {
                String idRichiestaCorrelata = null;
                if (!this.idMessage.equals(this.idSessione)) {
                    idRichiestaCorrelata = this.idSessione;
                }
                msgRequest.addProprietariIntoCache_readFromTable(this.idModulo, "sendRispostaErroreProtocollo [richiesta]", idRichiestaCorrelata, this.functionAsRouter);
            }
            if (msgResponse != null) {
                msgResponse.addProprietariIntoCache_readFromTable(this.idModulo, "sendRispostaErroreProtocollo [risposta]", this.idSessione, this.functionAsRouter);
            }
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "EJBUtils.sendRispostaErroreProtocollo");
            statoRichiesta.closePreparedStatement();
            statoRisposta.closePreparedStatement();
            throw new EJBUtilsException("EJBUtils.sendRispostaErroreProtocollo error: " + e.getMessage(), e);
        }
        finally {
            this.unsetEJBSuffixFunctionName();
        }
    }

    public GestoreMessaggi sendSbloccoRicezioneBuste(String idModuloInAttesa) throws EJBUtilsException, ProtocolException {
        String idTransazione = (String)this.pddContext.getObject(Costanti.ID_TRANSAZIONE);
        RequestInfo requestInfo = (RequestInfo)this.pddContext.getObject(Costanti.REQUEST_INFO);
        Imbustamento imbustatore = new Imbustamento(this.log, this.protocolFactory, this.openSPCoopState.getStatoRichiesta());
        String idSblocco = imbustatore.buildID(this.identitaPdD, idTransazione, this.propertiesReader.getGestioneSerializableDBAttesaAttiva(), this.propertiesReader.getGestioneSerializableDBCheckInterval(), RuoloMessaggio.RISPOSTA);
        return this.sendBustaRisposta(idModuloInAttesa, null, MessageUtilities.buildEmptyMessage((OpenSPCoop2MessageFactory)OpenSPCoop2MessageFactory.getDefaultMessageFactory(), (MessageType)requestInfo.getProtocolRequestMessageType(), (MessageRole)MessageRole.RESPONSE), idSblocco, null, null, null, null);
    }

    public GestoreMessaggi sendSOAPFault(String idModuloInAttesa, OpenSPCoop2Message msg) throws EJBUtilsException, ProtocolException {
        String idTransazione = (String)this.pddContext.getObject(Costanti.ID_TRANSAZIONE);
        Imbustamento imbustatore = new Imbustamento(this.log, this.protocolFactory, this.openSPCoopState.getStatoRichiesta());
        String idSblocco = imbustatore.buildID(this.identitaPdD, idTransazione, this.propertiesReader.getGestioneSerializableDBAttesaAttiva(), this.propertiesReader.getGestioneSerializableDBCheckInterval(), RuoloMessaggio.RISPOSTA);
        return this.sendBustaRisposta(idModuloInAttesa, null, msg, idSblocco, null, null, null, null);
    }

    public GestoreMessaggi buildAndSendBustaRisposta(String idModuloInAttesa, Busta busta, OpenSPCoop2Message msg, String profiloGestione, String idCorrelazioneApplicativa, String servizioApplicativoFruitore) throws EJBUtilsException, ProtocolException {
        return this.buildAndSendBustaRisposta(idModuloInAttesa, busta, msg, profiloGestione, idCorrelazioneApplicativa, null, servizioApplicativoFruitore);
    }

    public GestoreMessaggi buildAndSendBustaRisposta(String idModuloInAttesa, Busta busta, OpenSPCoop2Message msg, String profiloGestione, String idCorrelazioneApplicativa, String idCorrelazioneApplicativaRisposta, String servizioApplicativoFruitore) throws EJBUtilsException, ProtocolException {
        String idTransazione = (String)this.pddContext.getObject(Costanti.ID_TRANSAZIONE);
        Imbustamento imbustatore = new Imbustamento(this.log, this.protocolFactory, this.openSPCoopState.getStatoRichiesta());
        String id_busta = imbustatore.buildID(this.identitaPdD, idTransazione, this.propertiesReader.getGestioneSerializableDBAttesaAttiva(), this.propertiesReader.getGestioneSerializableDBCheckInterval(), RuoloMessaggio.RISPOSTA);
        if (busta != null) {
            busta.setID(id_busta);
        }
        return this.sendBustaRisposta(idModuloInAttesa, busta, msg, null, profiloGestione, idCorrelazioneApplicativa, idCorrelazioneApplicativaRisposta, servizioApplicativoFruitore);
    }

    public GestoreMessaggi sendBustaRisposta(String idModuloInAttesa, Busta busta, String profiloGestione, String idCorrelazioneApplicativa, String idCorrelazioneApplicativaRisposta, String servizioApplicativoFruitore) throws EJBUtilsException {
        return this.sendBustaRisposta(idModuloInAttesa, busta, null, null, profiloGestione, idCorrelazioneApplicativa, idCorrelazioneApplicativaRisposta, servizioApplicativoFruitore);
    }

    private GestoreMessaggi sendBustaRisposta(String idModuloInAttesa, Busta busta, OpenSPCoop2Message msg, String idSbloccoModulo, String profiloGestione, String idCorrelazioneApplicativa, String idCorrelazioneApplicativaRisposta, String servizioApplicativoFruitore) throws EJBUtilsException {
        IState statoRisposta = this.openSPCoopState.getStatoRisposta();
        GestoreMessaggi msgResponse = null;
        this.setEJBSuffixFunctionName();
        try {
            boolean httpReply = true;
            if (idSbloccoModulo == null) {
                if (this.replyOnNewConnection) {
                    httpReply = false;
                }
                if (busta != null && busta.getIndirizzoDestinatario() != null && this.utilizzoIndirizzoTelematico) {
                    httpReply = false;
                }
            }
            if (!httpReply || idModuloInAttesa != null) {
                boolean salvaSuDatabasePerStateless = false;
                if (!httpReply && !this.functionAsRouter && this.openSPCoopState instanceof OpenSPCoopStateless) {
                    salvaSuDatabasePerStateless = true;
                }
                if (busta != null) {
                    RepositoryBuste repositoryRisposta = new RepositoryBuste(statoRisposta, this.log, salvaSuDatabasePerStateless, this.protocolFactory);
                    repositoryRisposta.registraBustaIntoOutBox(busta, this.propertiesReader.getRepositoryIntervalloScadenzaMessaggi());
                    Integrazione infoIntegrazione = new Integrazione();
                    infoIntegrazione.setIdModuloInAttesa(idModuloInAttesa);
                    infoIntegrazione.setScenario(this.scenarioCooperazione);
                    repositoryRisposta.aggiornaInfoIntegrazioneIntoOutBox(busta.getID(), infoIntegrazione);
                }
                String idRisposta = null;
                idRisposta = busta != null ? busta.getID() : idSbloccoModulo;
                msgResponse = new GestoreMessaggi(this.openSPCoopState, salvaSuDatabasePerStateless, idRisposta, "OUTBOX", this.msgDiag, this.pddContext);
                if (!httpReply) {
                    msgResponse.setOneWayVersione11(this.oneWayVersione11);
                }
                if (msg != null) {
                    if (this.openSPCoopState instanceof OpenSPCoopStateless) {
                        msgResponse.registraMessaggio(msg, (Date)((OpenSPCoopStateless)this.openSPCoopState).getTempiAttraversamentoPDD().getRicezioneMsgIngresso(), idCorrelazioneApplicativa, idCorrelazioneApplicativaRisposta);
                    } else {
                        msgResponse.registraMessaggio(msg, idCorrelazioneApplicativa, idCorrelazioneApplicativaRisposta);
                    }
                }
                msgResponse.aggiornaRiferimentoMessaggio(this.idSessione);
                if (!httpReply) {
                    msgResponse.aggiornaProprietarioMessaggio("InoltroRisposte");
                } else if (idModuloInAttesa != null) {
                    msgResponse.aggiornaProprietarioMessaggio(idModuloInAttesa);
                }
                if (!httpReply) {
                    this.sendToInoltroRisposte(busta, false, profiloGestione, msgResponse, idCorrelazioneApplicativa, idCorrelazioneApplicativaRisposta, servizioApplicativoFruitore, true);
                } else if (idModuloInAttesa != null) {
                    this.sendBustaToRicezioneBuste(idModuloInAttesa, busta, idSbloccoModulo);
                }
            }
            GestoreMessaggi gestoreMessaggi = msgResponse;
            return gestoreMessaggi;
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "EJBUtils.sendRispostaProtocollo");
            if (msgResponse != null) {
                ((StateMessage)statoRisposta).closePreparedStatement();
            }
            throw new EJBUtilsException("EJBUtils.sendRispostaProtocollo error: " + e.getMessage(), e);
        }
        finally {
            this.unsetEJBSuffixFunctionName();
        }
    }

    public void sendToInoltroRisposte(Busta busta, boolean inoltroSegnalazioneErrore, String profiloGestione, GestoreMessaggi gm, String idCorrelazioneApplicativa, String idCorrelazioneApplicativaRisposta, String servizioApplicativoFruitore, boolean imbustamento) throws EJBUtilsException {
        if (this.openSPCoopState instanceof OpenSPCoopStateful || this.oneWayVersione11) {
            try {
                this.msgDiag.highDebug("[EJBUtils] Creazione ObjectMessage for send nell'infrastruttura.");
                InoltroRisposteMessage inoltroMSG = new InoltroRisposteMessage();
                inoltroMSG.setDominio(this.identitaPdD);
                inoltroMSG.setInoltroSegnalazioneErrore(inoltroSegnalazioneErrore);
                inoltroMSG.setBustaRisposta(busta);
                inoltroMSG.setProfiloGestione(profiloGestione);
                inoltroMSG.setOneWayVersione11(this.oneWayVersione11);
                inoltroMSG.setIdCorrelazioneApplicativa(idCorrelazioneApplicativa);
                inoltroMSG.setIdCorrelazioneApplicativaRisposta(idCorrelazioneApplicativaRisposta);
                inoltroMSG.setServizioApplicativoFruitore(servizioApplicativoFruitore);
                inoltroMSG.setImbustamento(imbustamento);
                inoltroMSG.setImplementazionePdDSoggettoMittente(this.implementazionePdDSoggettoMittente);
                inoltroMSG.setImplementazionePdDSoggettoDestinatario(this.implementazionePdDSoggettoDestinatario);
                inoltroMSG.setPddContext(this.pddContext);
                if (this.oneWayVersione11) {
                    OpenSPCoopStateless statelessSerializzabile = ((OpenSPCoopStateless)this.openSPCoopState).rendiSerializzabile();
                    inoltroMSG.setOpenspcoopstate(statelessSerializzabile);
                }
                this.nodeSender.send(inoltroMSG, "InoltroRisposte", this.msgDiag, this.identitaPdD, this.idModulo, this.idSessione, gm);
            }
            catch (Exception e) {
                this.log.error("Spedizione->InoltroRisposte non riuscita", (Throwable)e);
                this.msgDiag.logErroreGenerico(e, "EJBUtils.sendToInoltroRisposte");
                throw new EJBUtilsException("EJBUtils.sendToInoltroRisposte error: " + e.getMessage(), e);
            }
        }
    }

    public OpenSPCoop2Message buildOpenSPCoopOK(MessageType messageType, String id) throws UtilsException {
        try {
            OpenSPCoop2MessageFactory mf = OpenSPCoop2MessageFactory.getDefaultMessageFactory();
            EsitoRichiesta esito = new EsitoRichiesta();
            esito.setMessageId(id);
            esito.setState("ENQUEUED");
            switch (messageType) {
                case SOAP_11: 
                case SOAP_12: {
                    OpenSPCoop2Message responseSOAPMessage = mf.createEmptyMessage(messageType, MessageRole.RESPONSE);
                    OpenSPCoop2SoapMessage soapMessage = responseSOAPMessage.castAsSoap();
                    SOAPBody soapBody = soapMessage.getSOAPBody();
                    byte[] xmlEsito = EsitoRichiestaXMLUtils.generateEsitoRichiesta((EsitoRichiesta)esito);
                    soapBody.addChildElement(soapMessage.createSOAPElement(xmlEsito));
                    return responseSOAPMessage;
                }
                case JSON: {
                    byte[] bytes = EsitoRichiestaXMLUtils.generateEsitoRichiestaAsJson((EsitoRichiesta)esito).getBytes();
                    OpenSPCoop2MessageParseResult pr = mf.createMessage(messageType, MessageRole.RESPONSE, "application/json", bytes);
                    return pr.getMessage_throwParseException();
                }
            }
            byte[] bytes = EsitoRichiestaXMLUtils.generateEsitoRichiesta((EsitoRichiesta)esito);
            OpenSPCoop2MessageParseResult pr = mf.createMessage(MessageType.XML, MessageRole.RESPONSE, "application/xml", bytes);
            return pr.getMessage_throwParseException();
        }
        catch (Exception e) {
            throw new UtilsException("Creazione MsgOpenSPCoopOK non riuscito: " + e.getMessage(), (Throwable)e);
        }
    }

    public void sendBustaToRicezioneBuste(String idModuloInAttesa, Busta busta, String idSbloccoModulo) throws EJBUtilsException {
        RicezioneBusteMessage ricezioneMSG;
        if (this.openSPCoopState instanceof OpenSPCoopStateless) {
            ricezioneMSG = new RicezioneBusteMessage();
            ricezioneMSG.setBustaRisposta(busta);
            ricezioneMSG.setIdMessaggioSblocco(idSbloccoModulo);
            ricezioneMSG.setPddContext(this.pddContext);
            ((OpenSPCoopStateless)this.openSPCoopState).setMessageLib(ricezioneMSG);
        }
        if ("jms".equals(this.propertiesReader.getNodeReceiver())) {
            try {
                this.msgDiag.highDebug("Creazione ObjectMessage for send via JMS.");
                ricezioneMSG = new RicezioneBusteMessage();
                ricezioneMSG.setBustaRisposta(busta);
                ricezioneMSG.setIdMessaggioSblocco(idSbloccoModulo);
                ricezioneMSG.setPddContext(this.pddContext);
                if (this.openSPCoopState instanceof OpenSPCoopStateless) {
                    ((OpenSPCoopStateless)this.openSPCoopState).setMessageLib(ricezioneMSG);
                } else {
                    String idT = PdDContext.getValue((MapKey<String>)Costanti.ID_TRANSAZIONE, this.pddContext);
                    JMSSender senderJMS = new JMSSender(this.identitaPdD, this.idModulo, this.log, idT);
                    Properties prop = new Properties();
                    prop.put("ID", this.idSessione);
                    if (!senderJMS.send(idModuloInAttesa, (Serializable)ricezioneMSG, prop)) {
                        this.msgDiag.logErroreGenerico(senderJMS.getErrore(), "EJBUtils.sendBustaToRicezioneBuste.senderJMS");
                        throw new Exception("SendJMSError: " + senderJMS.getErrore());
                    }
                    this.msgDiag.highDebug("ObjectMessage send via JMS.");
                }
            }
            catch (Exception e) {
                this.msgDiag.logErroreGenerico(e, "EJBUtils.sendBustaToRicezioneBuste");
                throw new EJBUtilsException("EJBUtils.sendToRicezioneBuste error: " + e.getMessage(), e);
            }
        }
    }

    public void setScenarioCooperazione(String scenarioCooperazione) {
        this.scenarioCooperazione = scenarioCooperazione;
    }

    public Timestamp getRicezioneMsgRisposta() {
        return this.ricezioneMsgRisposta;
    }

    public void setRicezioneMsgRisposta(Timestamp ricezioneMsgRisposta) {
        this.ricezioneMsgRisposta = ricezioneMsgRisposta;
    }

    public Timestamp getSpedizioneMsgIngresso() {
        return this.spedizioneMsgIngresso;
    }

    public void setSpedizioneMsgIngresso(Timestamp spedizioneMsgIngresso) {
        this.spedizioneMsgIngresso = spedizioneMsgIngresso;
    }

    public boolean saveMessageStateless(PortaDelegata pd) throws Exception {
        ProfiloDiCollaborazione profiloCollaborazione = EJBUtils.calcolaProfiloCollaborazione(this.scenarioCooperazione);
        return this.configurazionePdDReader.isModalitaStateless(pd, profiloCollaborazione);
    }

    public void setOneWayVersione11(boolean oneWay11) {
        this.oneWayVersione11 = oneWay11;
    }

    public void setPortaDiTipoStateless_esclusoOneWay11(boolean stateless) {
        this.portaDiTipoStateless_esclusoOneWay11 = stateless;
    }

    public void setRouting(boolean routing) {
        this.routing = routing;
    }

    public void setRollbackRichiestaInCasoErrore(boolean rollbackRichiestaInCasoErrore) {
        this.rollbackRichiestaInCasoErrore = rollbackRichiestaInCasoErrore;
    }

    public void setRollbackRichiestaInCasoErrore_rollbackHistory(boolean rollbackRichiestaInCasoErrore_rollbackHistory) {
        this.rollbackRichiestaInCasoErrore_rollbackHistory = rollbackRichiestaInCasoErrore_rollbackHistory;
    }

    public static ProfiloDiCollaborazione calcolaProfiloCollaborazione(String scenarioCooperazione) {
        ProfiloDiCollaborazione profiloCollaborazione = null;
        if ("OneWay_InvocazioneServizio".equals(scenarioCooperazione)) {
            profiloCollaborazione = ProfiloDiCollaborazione.ONEWAY;
        } else if ("Sincrono_InvocazioneServizio".equals(scenarioCooperazione)) {
            profiloCollaborazione = ProfiloDiCollaborazione.SINCRONO;
        } else if ("AsincronoAsimmetrico_Polling".equals(scenarioCooperazione) || "AsincronoAsimmetrico_InvocazioneServizio".equals(scenarioCooperazione)) {
            profiloCollaborazione = ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO;
        } else if ("AsincronoSimmetrico_InvocazioneServizio".equals(scenarioCooperazione) || "AsincronoSimmetrico_ConsegnaRisposta".equals(scenarioCooperazione)) {
            profiloCollaborazione = ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO;
        }
        return profiloCollaborazione;
    }

    public String getServizioApplicativoErogatore() {
        return this.servizioApplicativoErogatore;
    }

    public void setServizioApplicativoErogatore(String servizioApplicativoErogatore) {
        this.servizioApplicativoErogatore = servizioApplicativoErogatore;
    }
}

