/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDConnettore;
import org.openspcoop2.core.id.IDGenericProperties;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDRuolo;
import org.openspcoop2.core.id.IDScope;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mapping.MappingErogazionePortaApplicativa;
import org.openspcoop2.core.mapping.MappingFruizionePortaDelegata;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.soap.reader.OpenSPCoop2MessageSoapStreamReader;
import org.openspcoop2.pdd.config.ConfigurazionePdD;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.sdk.state.RequestConfig;
import org.openspcoop2.protocol.sdk.state.RequestFruitore;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.state.RequestRateLimitingConfig;
import org.openspcoop2.protocol.sdk.state.RequestThreadContext;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.cache.Cache;
import org.openspcoop2.utils.cache.CacheAlgorithm;
import org.openspcoop2.utils.cache.CacheResponse;
import org.openspcoop2.utils.cache.CacheType;
import org.openspcoop2.utils.certificate.CertificateInfo;
import org.slf4j.Logger;

public class GestoreRichieste {
    private static volatile boolean useCache = true;
    public static final String GESTORE_RICHIESTE_PREFIX_CACHE_NAME = "gestoreRichieste-";
    private static final String GESTORE_RICHIESTE_API_CACHE_NAME = "gestoreRichieste-API";
    private static final String GESTORE_RICHIESTE_RATE_LIMITING_CACHE_NAME = "gestoreRichieste-RateLimiting";
    private static final String GESTORE_RICHIESTE_FRUITORI_CACHE_NAME = "gestoreRichieste-Fruitori";
    private static Cache cacheApi = null;
    private static Cache cacheRateLimiting = null;
    private static Cache cacheFruitori = null;
    private static Map<String, Cache> caches = null;
    private static List<String> cacheKeys = null;
    private static final Semaphore lockCache = new Semaphore("gestoreRichieste-API");
    private static final Semaphore lockCache_rateLimiting = new Semaphore("gestoreRichieste-RateLimiting");
    private static final Semaphore lockCache_fruitori = new Semaphore("gestoreRichieste-Fruitori");
    private static Logger logger = null;
    private static Logger logConsole = OpenSPCoop2Logger.getLoggerOpenSPCoopConsole();
    private static final String KEY_IN_MEMORY_ONLY = "@@InMemoryOnly@@";
    private static final String INIT_SEPARATOR = "\n\n=======================";
    private static final String END_SEPARATOR = "=======================";
    private static final String FRUITORE_TRASPORTO = "trasparto";
    private static final String FRUITORE_TOKEN = "token";
    private static final String FRUITORE_TOKEN_MODI = "token-modi";

    private GestoreRichieste() {
    }

    public static boolean isUseCache() {
        return useCache;
    }

    public static void setUseCache(boolean useCache) {
        GestoreRichieste.useCache = useCache;
    }

    private static synchronized void initCacheKeys() {
        if (cacheKeys == null) {
            cacheKeys = new ArrayList<String>();
            cacheKeys.add(GESTORE_RICHIESTE_API_CACHE_NAME);
            cacheKeys.add(GESTORE_RICHIESTE_RATE_LIMITING_CACHE_NAME);
            cacheKeys.add(GESTORE_RICHIESTE_FRUITORI_CACHE_NAME);
        }
    }

    public static void resetCache() throws CoreException {
        if (cacheKeys != null && !cacheKeys.isEmpty()) {
            try {
                for (String cacheKey : cacheKeys) {
                    Cache cache = caches.get(cacheKey);
                    if (cache == null) continue;
                    cache.clear();
                }
            }
            catch (Exception e) {
                throw new CoreException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static String printStatsCache(String separator) throws CoreException {
        try {
            if (cacheKeys != null && !cacheKeys.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (String cacheKey : cacheKeys) {
                    Cache cache = caches.get(cacheKey);
                    if (cache == null) continue;
                    if (sb.length() > 0) {
                        sb.append(separator);
                    }
                    sb.append(cache.printStats(separator));
                }
                return sb.toString();
            }
            throw new CoreException("Cache non abilitata");
        }
        catch (Exception e) {
            throw new CoreException("Visualizzazione Statistiche riguardante la cache dei dati di gestione delle richieste non riuscita: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void abilitaCache() throws CoreException {
        if (cacheKeys != null) {
            throw new CoreException("Cache gia' abilitata");
        }
        try {
            GestoreRichieste.initCacheKeys();
            cacheApi = new Cache(CacheType.JCS, GESTORE_RICHIESTE_API_CACHE_NAME);
            cacheRateLimiting = new Cache(CacheType.JCS, GESTORE_RICHIESTE_RATE_LIMITING_CACHE_NAME);
            cacheFruitori = new Cache(CacheType.JCS, GESTORE_RICHIESTE_FRUITORI_CACHE_NAME);
            cacheApi.build();
            cacheRateLimiting.build();
            cacheFruitori.build();
            caches = new HashMap<String, Cache>();
            caches.put(GESTORE_RICHIESTE_API_CACHE_NAME, cacheApi);
            caches.put(GESTORE_RICHIESTE_RATE_LIMITING_CACHE_NAME, cacheRateLimiting);
            caches.put(GESTORE_RICHIESTE_FRUITORI_CACHE_NAME, cacheFruitori);
        }
        catch (Exception e) {
            throw new CoreException(e.getMessage(), (Throwable)e);
        }
    }

    public static void abilitaCache(Long dimensioneCache, Boolean algoritmoCacheLRU, Long itemIdleTime, Long itemLifeSecond) throws CoreException {
        if (cacheKeys != null) {
            throw new CoreException("Cache gi\u00e0 abilitata");
        }
        try {
            int dimensioneCacheInt = -1;
            if (dimensioneCache != null) {
                dimensioneCacheInt = dimensioneCache.intValue();
            }
            String algoritmoCache = null;
            algoritmoCache = algoritmoCacheLRU != null ? (algoritmoCacheLRU.booleanValue() ? CostantiConfigurazione.CACHE_LRU.toString() : CostantiConfigurazione.CACHE_MRU.toString()) : CostantiConfigurazione.CACHE_LRU.toString();
            long itemIdleTimeLong = -1L;
            if (itemIdleTime != null) {
                itemIdleTimeLong = itemIdleTime;
            }
            long itemLifeSecondLong = -1L;
            if (itemLifeSecond != null) {
                itemLifeSecondLong = itemLifeSecond;
            }
            GestoreRichieste.initCacheGestoreRichieste(CacheType.JCS, dimensioneCacheInt, algoritmoCache, itemIdleTimeLong, itemLifeSecondLong, null);
        }
        catch (Exception e) {
            throw new CoreException(e.getMessage(), (Throwable)e);
        }
    }

    public static void disabilitaCache() throws CoreException {
        if (cacheKeys == null) {
            throw new CoreException("Cache gi\u00e0 disabilitata");
        }
        GestoreRichieste.disabilitaCacheEngine();
    }

    private static synchronized void disabilitaCacheEngine() throws CoreException {
        if (cacheKeys != null) {
            try {
                cacheApi.clear();
                cacheApi = null;
                cacheRateLimiting.clear();
                cacheRateLimiting = null;
                cacheFruitori.clear();
                cacheFruitori = null;
                caches.clear();
                caches = null;
                cacheKeys.clear();
                cacheKeys = null;
            }
            catch (Exception e) {
                throw new CoreException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static boolean isCacheAbilitata() {
        return cacheKeys != null;
    }

    public static String listKeysCache(String separator) throws CoreException {
        if (cacheKeys != null && !cacheKeys.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String cacheKey : cacheKeys) {
                Cache cache = caches.get(cacheKey);
                if (cache == null) continue;
                if (sb.length() > 0) {
                    sb.append(separator);
                }
                try {
                    String nomeCache = cacheKey;
                    if (nomeCache.startsWith(GESTORE_RICHIESTE_PREFIX_CACHE_NAME)) {
                        nomeCache = nomeCache.substring(GESTORE_RICHIESTE_PREFIX_CACHE_NAME.length());
                    }
                    sb.append(cache.printKeys(separator).replaceFirst("Cache", "Cache-" + nomeCache));
                }
                catch (Exception e) {
                    throw new CoreException(e.getMessage(), (Throwable)e);
                }
            }
            return sb.toString();
        }
        throw new CoreException("Cache non abilitata");
    }

    @Deprecated
    public static List<String> listKeysCache() throws CoreException {
        if (cacheKeys != null && !cacheKeys.isEmpty()) {
            ArrayList<String> keys = new ArrayList<String>();
            for (String cacheKey : cacheKeys) {
                Cache cache = caches.get(cacheKey);
                if (cache == null) continue;
                try {
                    List k = cache.keys();
                    if (k == null || k.isEmpty()) continue;
                    keys.addAll(k);
                }
                catch (Exception e) {
                    throw new CoreException(e.getMessage(), (Throwable)e);
                }
            }
            return keys;
        }
        throw new CoreException("Cache non abilitata");
    }

    public static String getObjectCache(String key) throws CoreException {
        if (cacheKeys != null && !cacheKeys.isEmpty()) {
            try {
                Object o = null;
                for (String cacheKey : cacheKeys) {
                    Cache cache;
                    if (key.startsWith("Cache-")) {
                        Object nomeCache = cacheKey;
                        if (((String)nomeCache).startsWith(GESTORE_RICHIESTE_PREFIX_CACHE_NAME)) {
                            nomeCache = ((String)nomeCache).substring(GESTORE_RICHIESTE_PREFIX_CACHE_NAME.length());
                        }
                        if (!key.startsWith((String)(nomeCache = "Cache-" + (String)nomeCache + " "))) continue;
                        key = key.substring(((String)nomeCache).length());
                    }
                    if ((cache = caches.get(cacheKey)) == null || (o = cache.get(key)) == null) continue;
                    break;
                }
                if (o != null) {
                    return o.toString();
                }
                return "oggetto con chiave [" + key + "] non presente";
            }
            catch (Exception e) {
                throw new CoreException(e.getMessage(), (Throwable)e);
            }
        }
        throw new CoreException("Cache non abilitata");
    }

    public static Object getRawObjectCache(String key) throws CoreException {
        if (cacheKeys != null && !cacheKeys.isEmpty()) {
            try {
                Object o = null;
                for (String cacheKey : cacheKeys) {
                    Cache cache;
                    if (key.startsWith("Cache-")) {
                        Object nomeCache = cacheKey;
                        if (((String)nomeCache).startsWith(GESTORE_RICHIESTE_PREFIX_CACHE_NAME)) {
                            nomeCache = ((String)nomeCache).substring(GESTORE_RICHIESTE_PREFIX_CACHE_NAME.length());
                        }
                        if (!key.startsWith((String)(nomeCache = "Cache-" + (String)nomeCache + " "))) continue;
                        key = key.substring(((String)nomeCache).length());
                    }
                    if ((cache = caches.get(cacheKey)) == null || (o = cache.get(key)) == null) continue;
                    break;
                }
                return GestoreRichieste.getRawObjectCacheEngine(o);
            }
            catch (Exception e) {
                throw new CoreException(e.getMessage(), (Throwable)e);
            }
        }
        throw new CoreException("Cache non abilitata");
    }

    public static Object getRawObjectCacheEngine(Object o) throws CoreException {
        if (o != null) {
            if (o instanceof CacheResponse) {
                CacheResponse cR = (CacheResponse)o;
                if (cR.getObject() != null) {
                    o = cR.getObject();
                } else if (cR.getException() != null) {
                    o = cR.getException();
                }
            }
            return o;
        }
        return null;
    }

    public static void removeObjectCache(String key) throws CoreException {
        if (cacheKeys != null && !cacheKeys.isEmpty()) {
            try {
                for (String cacheKey : cacheKeys) {
                    Cache cache;
                    if (key.startsWith("Cache-")) {
                        Object nomeCache = cacheKey;
                        if (((String)nomeCache).startsWith(GESTORE_RICHIESTE_PREFIX_CACHE_NAME)) {
                            nomeCache = ((String)nomeCache).substring(GESTORE_RICHIESTE_PREFIX_CACHE_NAME.length());
                        }
                        if (!key.startsWith((String)(nomeCache = "Cache-" + (String)nomeCache + " "))) continue;
                        key = key.substring(((String)nomeCache).length());
                    }
                    if ((cache = caches.get(cacheKey)) == null) continue;
                    cache.remove(key);
                }
            }
            catch (Exception e) {
                throw new CoreException(e.getMessage(), (Throwable)e);
            }
        } else {
            throw new CoreException("Cache non abilitata");
        }
    }

    public static void initialize(Logger log) throws Exception {
        GestoreRichieste.initialize(null, false, -1, null, -1L, -1L, log);
    }

    public static void initialize(CacheType cacheType, int dimensioneCache, String algoritmoCache, long idleTime, long itemLifeSecond, Logger log) throws Exception {
        GestoreRichieste.initialize(cacheType, true, dimensioneCache, algoritmoCache, idleTime, itemLifeSecond, log);
    }

    private static void initialize(CacheType cacheType, boolean cacheAbilitata, int dimensioneCache, String algoritmoCache, long idleTime, long itemLifeSecond, Logger log) throws Exception {
        logger = log;
        if (cacheAbilitata) {
            GestoreRichieste.initCacheGestoreRichieste(cacheType, dimensioneCache, algoritmoCache, idleTime, itemLifeSecond, log);
        }
    }

    public static void initCacheGestoreRichieste(CacheType cacheType, int dimensioneCache, String algoritmoCache, long idleTime, long itemLifeSecond, Logger log) throws UtilsException, CoreException {
        Cache cache;
        if (log != null) {
            log.info("Inizializzazione cache GestoreRichieste");
        }
        GestoreRichieste.initCacheKeys();
        cacheApi = new Cache(cacheType, GESTORE_RICHIESTE_API_CACHE_NAME);
        cacheRateLimiting = new Cache(cacheType, GESTORE_RICHIESTE_RATE_LIMITING_CACHE_NAME);
        cacheFruitori = new Cache(cacheType, GESTORE_RICHIESTE_FRUITORI_CACHE_NAME);
        caches = new HashMap<String, Cache>();
        caches.put(GESTORE_RICHIESTE_API_CACHE_NAME, cacheApi);
        caches.put(GESTORE_RICHIESTE_RATE_LIMITING_CACHE_NAME, cacheRateLimiting);
        caches.put(GESTORE_RICHIESTE_FRUITORI_CACHE_NAME, cacheFruitori);
        if (dimensioneCache > 0 || algoritmoCache != null) {
            Cache cache2;
            if (dimensioneCache > 0) {
                try {
                    int dimensioneCacheInterna = dimensioneCache / cacheKeys.size();
                    String msg = "Dimensione della cache (GestoreRichieste) impostata al valore: " + dimensioneCache + " (" + cacheKeys.size() + " cache interne di " + dimensioneCacheInterna + " elementi ciascuna)";
                    if (log != null) {
                        log.info(msg);
                    }
                    logConsole.info(msg);
                    for (String cacheKey : cacheKeys) {
                        cache2 = caches.get(cacheKey);
                        cache2.setCacheSize(dimensioneCacheInterna);
                    }
                }
                catch (Exception error) {
                    throw new CoreException("Parametro errato per la dimensione della cache (Gestore Messaggi): " + error.getMessage(), (Throwable)error);
                }
            }
            if (algoritmoCache != null) {
                String msg = "Algoritmo di cache (GestoreRichieste) impostato al valore: " + algoritmoCache;
                if (log != null) {
                    log.info(msg);
                }
                logConsole.info(msg);
                CacheAlgorithm ca = null;
                ca = CostantiConfigurazione.CACHE_MRU.toString().equalsIgnoreCase(algoritmoCache) ? CacheAlgorithm.MRU : CacheAlgorithm.LRU;
                for (String cacheKey : cacheKeys) {
                    cache2 = caches.get(cacheKey);
                    cache2.setCacheAlgoritm(ca);
                }
            }
        }
        if (idleTime > 0L) {
            try {
                String msg = "Attributo 'IdleTime' (GestoreRichieste) impostato al valore: " + idleTime;
                if (log != null) {
                    log.info(msg);
                }
                logConsole.info(msg);
                for (String cacheKey : cacheKeys) {
                    cache = caches.get(cacheKey);
                    cache.setItemIdleTime(idleTime);
                }
            }
            catch (Exception error) {
                throw new CoreException("Parametro errato per l'attributo 'IdleTime' (Gestore Messaggi): " + error.getMessage(), (Throwable)error);
            }
        }
        try {
            String msg = "Attributo 'MaxLifeSecond' (GestoreRichieste) impostato al valore: " + itemLifeSecond;
            if (log != null) {
                log.info(msg);
            }
            logConsole.info(msg);
            for (String cacheKey : cacheKeys) {
                cache = caches.get(cacheKey);
                cache.setItemLifeTime(itemLifeSecond);
            }
        }
        catch (Exception error) {
            throw new CoreException("Parametro errato per l'attributo 'MaxLifeSecond' (Gestore Messaggi): " + error.getMessage(), (Throwable)error);
        }
        cacheApi.build();
        cacheRateLimiting.build();
        cacheFruitori.build();
    }

    @Deprecated
    public static void disableSyncronizedGet() throws UtilsException {
        if (cacheKeys != null && !cacheKeys.isEmpty()) {
            try {
                for (String cacheKey : cacheKeys) {
                    Cache cache = caches.get(cacheKey);
                    if (cache == null) continue;
                    cache.disableSyncronizedGet();
                }
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), (Throwable)e);
            }
        } else {
            throw new UtilsException("Cache disabled");
        }
    }

    @Deprecated
    public static boolean isDisableSyncronizedGet() throws UtilsException {
        if (cacheKeys != null && !cacheKeys.isEmpty()) {
            try {
                boolean isDisabled = true;
                for (String cacheKey : cacheKeys) {
                    Cache cache = caches.get(cacheKey);
                    if (cache == null || cache.isDisableSyncronizedGet()) continue;
                    isDisabled = false;
                    break;
                }
                return isDisabled;
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), (Throwable)e);
            }
        }
        throw new UtilsException("Cache disabled");
    }

    public static void removeRateLimitingConfigGlobale() throws UtilsException {
        if (cacheRateLimiting != null) {
            cacheRateLimiting.clear();
        }
    }

    public static void removeRateLimitingConfig(TipoPdD tipoPdD, String nomePorta) throws UtilsException, CoreException {
        if (cacheRateLimiting != null) {
            ArrayList<String> keyForClean = new ArrayList<String>();
            List keys = cacheRateLimiting.keys();
            if (keys != null && !keys.isEmpty()) {
                for (String key : keys) {
                    RequestRateLimitingConfig rl;
                    Object o;
                    if (key == null || !((o = GestoreRichieste.getRawObjectCacheEngine(cacheRateLimiting.get(key))) instanceof RequestRateLimitingConfig) || !tipoPdD.equals((Object)(rl = (RequestRateLimitingConfig)o).getTipoPdD()) || !nomePorta.equals(rl.getNomePorta())) continue;
                    keyForClean.add(key);
                }
            }
            if (keyForClean != null && !keyForClean.isEmpty()) {
                for (String key : keyForClean) {
                    cacheRateLimiting.remove(key);
                }
            }
        }
    }

    public static void removeApi(IDAccordo idAccordo) throws UtilsException, CoreException {
        IDAccordoFactory idAccordoFactory = IDAccordoFactory.getInstance();
        ArrayList<String> keyForClean = new ArrayList<String>();
        List keys = cacheApi.keys();
        if (keys != null && !keys.isEmpty()) {
            for (String key : keys) {
                Object o;
                if (key == null || !((o = GestoreRichieste.getRawObjectCacheEngine(cacheApi.get(key))) instanceof RequestConfig)) continue;
                RequestConfig rc = (RequestConfig)o;
                IDAccordo idCheck = null;
                try {
                    idCheck = idAccordoFactory.getIDAccordoFromAccordo(rc.getAspc());
                }
                catch (Exception e) {
                    throw new CoreException(e.getMessage(), (Throwable)e);
                }
                if (rc.getAspc() == null || !idAccordo.equals((Object)idCheck)) continue;
                keyForClean.add(key);
            }
        }
        if (keyForClean != null && !keyForClean.isEmpty()) {
            for (String key : keyForClean) {
                cacheApi.remove(key);
            }
        }
    }

    public static void removeErogazione(IDServizio idServizio) throws UtilsException, CoreException {
        GestoreRichieste.removeErogazioneRequestConfig(idServizio);
        GestoreRichieste.removeErogazioneRequestRateLimitingConfig(idServizio);
    }

    private static void removeErogazioneRequestConfig(IDServizio idServizio) throws UtilsException, CoreException {
        ArrayList<String> keyForClean = new ArrayList<String>();
        List keys = cacheApi.keys();
        if (keys != null && !keys.isEmpty()) {
            for (String key : keys) {
                RequestConfig rc;
                Object o;
                if (key == null || !((o = GestoreRichieste.getRawObjectCacheEngine(cacheApi.get(key))) instanceof RequestConfig) || (rc = (RequestConfig)o).getIdServizio() == null || !idServizio.equals(rc.getIdServizio(), false)) continue;
                keyForClean.add(key);
            }
        }
        if (keyForClean != null && !keyForClean.isEmpty()) {
            for (String key : keyForClean) {
                cacheApi.remove(key);
            }
        }
    }

    private static void removeErogazioneRequestRateLimitingConfig(IDServizio idServizio) throws UtilsException, CoreException {
        ArrayList<String> keyForClean = new ArrayList<String>();
        List keys = cacheRateLimiting.keys();
        if (keys != null && !keys.isEmpty()) {
            for (String key : keys) {
                RequestRateLimitingConfig rl;
                Object o;
                if (key == null || !((o = GestoreRichieste.getRawObjectCacheEngine(cacheRateLimiting.get(key))) instanceof RequestRateLimitingConfig) || (rl = (RequestRateLimitingConfig)o).getIdServizio() == null || !idServizio.equals(rl.getIdServizio(), false)) continue;
                keyForClean.add(key);
            }
        }
        if (keyForClean != null && !keyForClean.isEmpty()) {
            for (String key : keyForClean) {
                cacheRateLimiting.remove(key);
            }
        }
    }

    public static void removeFruizione(IDSoggetto fruitore, IDServizio idServizio) throws UtilsException, CoreException {
        GestoreRichieste.removeFruizioneRequestConfig(fruitore, idServizio);
        GestoreRichieste.removeFruizioneRequestRateLimitingConfig(fruitore, idServizio);
        GestoreRichieste.removeFruizioneRequestFruitore(fruitore, idServizio);
    }

    private static void removeFruizioneRequestConfig(IDSoggetto fruitore, IDServizio idServizio) throws UtilsException, CoreException {
        ArrayList<String> keyForClean = new ArrayList<String>();
        List keys = cacheApi.keys();
        if (keys != null && !keys.isEmpty()) {
            for (String key : keys) {
                RequestConfig rc;
                Object o;
                if (key == null || !((o = GestoreRichieste.getRawObjectCacheEngine(cacheApi.get(key))) instanceof RequestConfig) || (rc = (RequestConfig)o).getIdServizio() == null || !idServizio.equals(rc.getIdServizio(), false) || rc.getIdFruitore() == null || !fruitore.equals((Object)rc.getIdFruitore())) continue;
                keyForClean.add(key);
            }
        }
        if (keyForClean != null && !keyForClean.isEmpty()) {
            for (String key : keyForClean) {
                cacheApi.remove(key);
            }
        }
    }

    private static void removeFruizioneRequestRateLimitingConfig(IDSoggetto fruitore, IDServizio idServizio) throws UtilsException, CoreException {
        ArrayList<String> keyForClean = new ArrayList<String>();
        List keys = cacheRateLimiting.keys();
        if (keys != null && !keys.isEmpty()) {
            for (String key : keys) {
                RequestRateLimitingConfig rl;
                Object o;
                if (key == null || !((o = GestoreRichieste.getRawObjectCacheEngine(cacheRateLimiting.get(key))) instanceof RequestRateLimitingConfig) || (rl = (RequestRateLimitingConfig)o).getIdServizio() == null || !idServizio.equals(rl.getIdServizio(), false) || rl.getIdFruitore() == null || !fruitore.equals((Object)rl.getIdFruitore())) continue;
                keyForClean.add(key);
            }
        }
        if (keyForClean != null && !keyForClean.isEmpty()) {
            for (String key : keyForClean) {
                cacheRateLimiting.remove(key);
            }
        }
    }

    private static void removeFruizioneRequestFruitore(IDSoggetto fruitore, IDServizio idServizio) throws UtilsException, CoreException {
        ArrayList<String> keyForClean = new ArrayList<String>();
        List keys = cacheFruitori.keys();
        if (keys != null && !keys.isEmpty()) {
            for (String key : keys) {
                RequestFruitore rf;
                Object o;
                if (key == null || !((o = GestoreRichieste.getRawObjectCacheEngine(cacheFruitori.get(key))) instanceof RequestFruitore) || (rf = (RequestFruitore)o).getIdSoggettoFruitore() == null || !fruitore.equals((Object)rf.getIdSoggettoFruitore())) continue;
                keyForClean.add(key);
            }
        }
        if (keyForClean != null && !keyForClean.isEmpty()) {
            for (String key : keyForClean) {
                cacheFruitori.remove(key);
            }
        }
    }

    public static void removePortaApplicativa(IDPortaApplicativa idPA) throws UtilsException, CoreException {
        GestoreRichieste.removePortaApplicativaRequestConfig(idPA);
        GestoreRichieste.removePortaApplicativaRequestRateLimitingConfig(idPA);
    }

    private static void removePortaApplicativaRequestConfig(IDPortaApplicativa idPA) throws UtilsException, CoreException {
        ArrayList<String> keyForClean = new ArrayList<String>();
        List keys = cacheApi.keys();
        if (keys != null && !keys.isEmpty()) {
            for (String key : keys) {
                Object o;
                if (key == null || !((o = GestoreRichieste.getRawObjectCacheEngine(cacheApi.get(key))) instanceof RequestConfig)) continue;
                RequestConfig rc = (RequestConfig)o;
                if (rc.getIdPortaApplicativaDefault() != null && idPA.equals((Object)rc.getIdPortaApplicativaDefault())) {
                    keyForClean.add(key);
                    continue;
                }
                if (rc.getIdPortaApplicativa() != null && idPA.equals((Object)rc.getIdPortaApplicativa())) {
                    keyForClean.add(key);
                    continue;
                }
                if (rc.getPortaApplicativaDefault() != null && rc.getPortaApplicativaDefault().getNome() != null && idPA != null && rc.getPortaApplicativaDefault().getNome().equals(idPA.getNome())) {
                    keyForClean.add(key);
                    continue;
                }
                if (rc.getPortaApplicativa() != null && rc.getPortaApplicativa().getNome() != null && idPA != null && rc.getPortaApplicativa().getNome().equals(idPA.getNome())) {
                    keyForClean.add(key);
                    continue;
                }
                boolean find = false;
                if (rc.getListPorteApplicativeByFiltroRicerca() != null && !rc.getListPorteApplicativeByFiltroRicerca().isEmpty()) {
                    for (String keyID : rc.getListPorteApplicativeByFiltroRicerca().keySet()) {
                        List ids = (List)rc.getListPorteApplicativeByFiltroRicerca().get(keyID);
                        if (ids == null || !ids.contains(idPA)) continue;
                        find = true;
                        break;
                    }
                }
                if (!find && rc.getListMappingErogazionePortaApplicativa() != null && !rc.getListMappingErogazionePortaApplicativa().isEmpty()) {
                    for (MappingErogazionePortaApplicativa mapping : rc.getListMappingErogazionePortaApplicativa()) {
                        if (mapping == null || mapping.getIdPortaApplicativa() == null || !mapping.getIdPortaApplicativa().equals((Object)idPA)) continue;
                        find = true;
                        break;
                    }
                }
                if (!find) continue;
                keyForClean.add(key);
            }
        }
        if (keyForClean != null && !keyForClean.isEmpty()) {
            for (String key : keyForClean) {
                cacheApi.remove(key);
            }
        }
    }

    private static void removePortaApplicativaRequestRateLimitingConfig(IDPortaApplicativa idPA) throws UtilsException, CoreException {
        ArrayList<String> keyForClean = new ArrayList<String>();
        List keys = cacheRateLimiting.keys();
        if (keys != null && !keys.isEmpty()) {
            for (String key : keys) {
                RequestRateLimitingConfig rl;
                Object o;
                if (key == null || !((o = GestoreRichieste.getRawObjectCacheEngine(cacheRateLimiting.get(key))) instanceof RequestRateLimitingConfig) || !TipoPdD.APPLICATIVA.equals((Object)(rl = (RequestRateLimitingConfig)o).getTipoPdD()) || !idPA.getNome().equals(rl.getNomePorta())) continue;
                keyForClean.add(key);
            }
        }
        if (keyForClean != null && !keyForClean.isEmpty()) {
            for (String key : keyForClean) {
                cacheRateLimiting.remove(key);
            }
        }
    }

    public static void removeConnettore(IDConnettore idConnettore) throws UtilsException, CoreException {
        ArrayList<String> keyForClean = new ArrayList<String>();
        List keys = cacheApi.keys();
        if (keys != null && !keys.isEmpty()) {
            for (String key : keys) {
                ServizioApplicativo sa;
                RequestConfig rc;
                Object o;
                if (key == null || !((o = GestoreRichieste.getRawObjectCacheEngine(cacheApi.get(key))) instanceof RequestConfig) || (rc = (RequestConfig)o).getIdServizio() == null || rc.getIdServizio().getSoggettoErogatore() == null || !idConnettore.getIdSoggettoProprietario().equals((Object)rc.getIdServizio().getSoggettoErogatore()) || (sa = rc.getServizioApplicativoErogatore(idConnettore.getNome())) == null) continue;
                keyForClean.add(key);
            }
        }
        if (keyForClean != null && !keyForClean.isEmpty()) {
            for (String key : keyForClean) {
                cacheApi.remove(key);
            }
        }
    }

    public static void removePortaDelegata(IDPortaDelegata idPD) throws UtilsException, CoreException {
        GestoreRichieste.removePortaDelegataRequestConfig(idPD);
        GestoreRichieste.removePortaDelegataRequestRateLimitingConfig(idPD);
    }

    private static void removePortaDelegataRequestConfig(IDPortaDelegata idPD) throws UtilsException, CoreException {
        ArrayList<String> keyForClean = new ArrayList<String>();
        List keys = cacheApi.keys();
        if (keys != null && !keys.isEmpty()) {
            for (String key : keys) {
                Object o;
                if (key == null || !((o = GestoreRichieste.getRawObjectCacheEngine(cacheApi.get(key))) instanceof RequestConfig)) continue;
                RequestConfig rc = (RequestConfig)o;
                if (rc.getIdPortaDelegataDefault() != null && idPD.equals((Object)rc.getIdPortaDelegataDefault())) {
                    keyForClean.add(key);
                    continue;
                }
                if (rc.getIdPortaDelegata() != null && idPD.equals((Object)rc.getIdPortaDelegata())) {
                    keyForClean.add(key);
                    continue;
                }
                if (rc.getPortaDelegataDefault() != null && rc.getPortaDelegataDefault().getNome() != null && idPD != null && rc.getPortaDelegataDefault().getNome().equals(idPD.getNome())) {
                    keyForClean.add(key);
                    continue;
                }
                if (rc.getPortaDelegata() != null && rc.getPortaDelegata().getNome() != null && idPD != null && rc.getPortaDelegata().getNome().equals(idPD.getNome())) {
                    keyForClean.add(key);
                    continue;
                }
                boolean find = false;
                if (rc.getListPorteDelegateByFiltroRicerca() != null && !rc.getListPorteDelegateByFiltroRicerca().isEmpty()) {
                    for (String keyID : rc.getListPorteDelegateByFiltroRicerca().keySet()) {
                        List ids = (List)rc.getListPorteDelegateByFiltroRicerca().get(keyID);
                        if (ids == null || !ids.contains(idPD)) continue;
                        find = true;
                        break;
                    }
                }
                if (!find && rc.getListMappingFruizionePortaDelegata() != null && !rc.getListMappingFruizionePortaDelegata().isEmpty()) {
                    for (MappingFruizionePortaDelegata mapping : rc.getListMappingFruizionePortaDelegata()) {
                        if (mapping == null || mapping.getIdPortaDelegata() == null || !mapping.getIdPortaDelegata().equals((Object)idPD)) continue;
                        find = true;
                        break;
                    }
                }
                if (!find) continue;
                keyForClean.add(key);
            }
        }
        if (keyForClean != null && !keyForClean.isEmpty()) {
            for (String key : keyForClean) {
                cacheApi.remove(key);
            }
        }
    }

    private static void removePortaDelegataRequestRateLimitingConfig(IDPortaDelegata idPD) throws UtilsException, CoreException {
        ArrayList<String> keyForClean = new ArrayList<String>();
        List keys = cacheRateLimiting.keys();
        if (keys != null && !keys.isEmpty()) {
            for (String key : keys) {
                RequestRateLimitingConfig rl;
                Object o;
                if (key == null || !((o = GestoreRichieste.getRawObjectCacheEngine(cacheRateLimiting.get(key))) instanceof RequestRateLimitingConfig) || !TipoPdD.DELEGATA.equals((Object)(rl = (RequestRateLimitingConfig)o).getTipoPdD()) || !idPD.getNome().equals(rl.getNomePorta())) continue;
                keyForClean.add(key);
            }
        }
        if (keyForClean != null && !keyForClean.isEmpty()) {
            for (String key : keyForClean) {
                cacheRateLimiting.remove(key);
            }
        }
    }

    public static void removePdd(String portaDominio) throws UtilsException, CoreException {
        ArrayList<String> keyForClean = new ArrayList<String>();
        List keys = cacheApi.keys();
        if (keys != null && !keys.isEmpty()) {
            for (String key : keys) {
                RequestConfig rc;
                Object o;
                if (key == null || !((o = GestoreRichieste.getRawObjectCacheEngine(cacheApi.get(key))) instanceof RequestConfig) || ((rc = (RequestConfig)o).getSoggettoErogatorePdd() == null || rc.getSoggettoErogatorePdd().getNome() == null || !portaDominio.equals(rc.getSoggettoErogatorePdd().getNome())) && (rc.getSoggettoFruitorePdd() == null || rc.getSoggettoFruitorePdd().getNome() == null || !portaDominio.equals(rc.getSoggettoFruitorePdd().getNome()))) continue;
                keyForClean.add(key);
            }
        }
        if (keyForClean != null && !keyForClean.isEmpty()) {
            for (String key : keyForClean) {
                cacheApi.remove(key);
            }
        }
    }

    public static void removeSoggetto(IDSoggetto idSoggetto) throws UtilsException, CoreException {
        GestoreRichieste.removeSoggettoRequestConfig(idSoggetto);
        GestoreRichieste.removeSoggettoRequestRateLimitingConfig(idSoggetto);
        GestoreRichieste.removeSoggettoRequestFruitore(idSoggetto);
    }

    private static void removeSoggettoRequestConfig(IDSoggetto idSoggetto) throws UtilsException, CoreException {
        ArrayList<String> keyForClean = new ArrayList<String>();
        List keys = cacheApi.keys();
        if (keys != null && !keys.isEmpty()) {
            for (String key : keys) {
                RequestConfig rc;
                Object o;
                if (key == null || !((o = GestoreRichieste.getRawObjectCacheEngine(cacheApi.get(key))) instanceof RequestConfig) || ((rc = (RequestConfig)o).getIdServizio() == null || rc.getIdServizio().getSoggettoErogatore() == null || !idSoggetto.equals((Object)rc.getIdServizio().getSoggettoErogatore())) && (rc.getIdFruitore() == null || !idSoggetto.equals((Object)rc.getIdFruitore()))) continue;
                keyForClean.add(key);
            }
        }
        if (keyForClean != null && !keyForClean.isEmpty()) {
            for (String key : keyForClean) {
                cacheApi.remove(key);
            }
        }
    }

    private static void removeSoggettoRequestRateLimitingConfig(IDSoggetto idSoggetto) throws UtilsException, CoreException {
        ArrayList<String> keyForClean = new ArrayList<String>();
        List keys = cacheRateLimiting.keys();
        if (keys != null && !keys.isEmpty()) {
            for (String key : keys) {
                RequestRateLimitingConfig rl;
                Object o;
                if (key == null || !((o = GestoreRichieste.getRawObjectCacheEngine(cacheRateLimiting.get(key))) instanceof RequestRateLimitingConfig) || ((rl = (RequestRateLimitingConfig)o).getIdServizio() == null || rl.getIdServizio().getSoggettoErogatore() == null || !idSoggetto.equals((Object)rl.getIdServizio().getSoggettoErogatore())) && (rl.getIdFruitore() == null || !idSoggetto.equals((Object)rl.getIdFruitore()))) continue;
                keyForClean.add(key);
            }
        }
        if (keyForClean != null && !keyForClean.isEmpty()) {
            for (String key : keyForClean) {
                cacheRateLimiting.remove(key);
            }
        }
    }

    private static void removeSoggettoRequestFruitore(IDSoggetto idSoggetto) throws UtilsException, CoreException {
        ArrayList<String> keyForClean = new ArrayList<String>();
        List keys = cacheFruitori.keys();
        if (keys != null && !keys.isEmpty()) {
            for (String key : keys) {
                RequestFruitore rf;
                Object o;
                if (key == null || !((o = GestoreRichieste.getRawObjectCacheEngine(cacheFruitori.get(key))) instanceof RequestFruitore) || ((rf = (RequestFruitore)o).getIdServizioApplicativoFruitore() == null || rf.getIdServizioApplicativoFruitore().getIdSoggettoProprietario() == null || !idSoggetto.equals((Object)rf.getIdServizioApplicativoFruitore().getIdSoggettoProprietario())) && (rf.getIdSoggettoFruitore() == null || !idSoggetto.equals((Object)rf.getIdSoggettoFruitore()))) continue;
                keyForClean.add(key);
            }
        }
        if (keyForClean != null && !keyForClean.isEmpty()) {
            for (String key : keyForClean) {
                cacheFruitori.remove(key);
            }
        }
    }

    public static void removeApplicativo(IDServizioApplicativo idApplicativo) throws UtilsException, CoreException {
        GestoreRichieste.removeApplicativoRequestConfig(idApplicativo);
        GestoreRichieste.removeApplicativoRequestFruitore(idApplicativo);
    }

    private static void removeApplicativoRequestConfig(IDServizioApplicativo idApplicativo) throws UtilsException, CoreException {
        ArrayList<String> keyForClean = new ArrayList<String>();
        List keys = cacheApi.keys();
        if (keys != null && !keys.isEmpty()) {
            for (String key : keys) {
                ServizioApplicativo sa;
                RequestConfig rc;
                Object o;
                if (key == null || !((o = GestoreRichieste.getRawObjectCacheEngine(cacheApi.get(key))) instanceof RequestConfig) || (rc = (RequestConfig)o).getIdServizio() == null || rc.getIdServizio().getSoggettoErogatore() == null || !idApplicativo.getIdSoggettoProprietario().equals((Object)rc.getIdServizio().getSoggettoErogatore()) || (sa = rc.getServizioApplicativoErogatore(idApplicativo.getNome())) == null) continue;
                keyForClean.add(key);
            }
        }
        if (keyForClean != null && !keyForClean.isEmpty()) {
            for (String key : keyForClean) {
                cacheApi.remove(key);
            }
        }
    }

    private static void removeApplicativoRequestFruitore(IDServizioApplicativo idApplicativo) throws UtilsException, CoreException {
        ArrayList<String> keyForClean = new ArrayList<String>();
        List keys = cacheFruitori.keys();
        if (keys != null && !keys.isEmpty()) {
            for (String key : keys) {
                RequestFruitore rf;
                Object o;
                if (key == null || !((o = GestoreRichieste.getRawObjectCacheEngine(cacheFruitori.get(key))) instanceof RequestFruitore) || (rf = (RequestFruitore)o).getIdServizioApplicativoFruitore() == null || !idApplicativo.equals((Object)rf.getIdServizioApplicativoFruitore())) continue;
                keyForClean.add(key);
            }
        }
        if (keyForClean != null && !keyForClean.isEmpty()) {
            for (String key : keyForClean) {
                cacheFruitori.remove(key);
            }
        }
    }

    public static void removeRuolo(IDRuolo idRuolo) throws UtilsException, CoreException {
        ArrayList<String> keyForClean = new ArrayList<String>();
        List keys = cacheApi.keys();
        if (keys != null && !keys.isEmpty()) {
            for (String key : keys) {
                RequestConfig rc;
                List ruoloKeys;
                Object o;
                if (key == null || !((o = GestoreRichieste.getRawObjectCacheEngine(cacheApi.get(key))) instanceof RequestConfig) || (ruoloKeys = (rc = (RequestConfig)o).getRuoloKeys()) == null || !ruoloKeys.contains(idRuolo.getNome())) continue;
                keyForClean.add(key);
            }
        }
        if (keyForClean != null && !keyForClean.isEmpty()) {
            for (String key : keyForClean) {
                cacheApi.remove(key);
            }
        }
    }

    public static void removeScope(IDScope idScope) throws UtilsException, CoreException {
        ArrayList<String> keyForClean = new ArrayList<String>();
        List keys = cacheApi.keys();
        if (keys != null && !keys.isEmpty()) {
            for (String key : keys) {
                RequestConfig rc;
                List scopeKeys;
                Object o;
                if (key == null || !((o = GestoreRichieste.getRawObjectCacheEngine(cacheApi.get(key))) instanceof RequestConfig) || (scopeKeys = (rc = (RequestConfig)o).getScopeKeys()) == null || !scopeKeys.contains(idScope.getNome())) continue;
                keyForClean.add(key);
            }
        }
        if (keyForClean != null && !keyForClean.isEmpty()) {
            for (String key : keyForClean) {
                cacheApi.remove(key);
            }
        }
    }

    public static void removeGenericProperties(IDGenericProperties idGP) throws UtilsException, CoreException {
        ArrayList<String> keyForClean = new ArrayList<String>();
        List keys = cacheApi.keys();
        if (keys != null && !keys.isEmpty()) {
            for (String key : keys) {
                Serializable oT;
                Object o;
                if (key == null || !((o = GestoreRichieste.getRawObjectCacheEngine(cacheApi.get(key))) instanceof RequestConfig)) continue;
                RequestConfig rc = (RequestConfig)o;
                if ("gestionePolicyToken".equals(idGP.getTipologia()) && (oT = rc.getPolicyValidazioneToken(idGP.getNome())) != null) {
                    keyForClean.add(key);
                    continue;
                }
                if ("retrievePolicyToken".equals(idGP.getTipologia()) && (oT = rc.getPolicyNegoziazioneToken(idGP.getNome())) != null) {
                    keyForClean.add(key);
                    continue;
                }
                if ("attributeAuthority".equals(idGP.getTipologia()) && (oT = rc.getAttributeAuthority(idGP.getNome())) != null) {
                    keyForClean.add(key);
                    continue;
                }
                List forwardProxyKeys = rc.getForwardProxyEnabled() != null && rc.getForwardProxyEnabled() != false ? rc.getForwardProxyKeys() : null;
                String forwardProxyGP = ConfigurazionePdD._toKey_ForwardProxyConfigSuffix(idGP);
                if (forwardProxyKeys == null || !forwardProxyKeys.contains(forwardProxyGP)) continue;
                keyForClean.add(key);
            }
        }
        if (keyForClean != null && !keyForClean.isEmpty()) {
            for (String key : keyForClean) {
                cacheApi.remove(key);
            }
        }
    }

    public static void setRequestConfigInMemory(RequestInfo requestInfo) {
        if (Cache.DEBUG_CACHE) {
            System.out.println(INIT_SEPARATOR);
            System.out.println("Creato RequestConfig in ram");
            System.out.println(END_SEPARATOR);
        }
        RequestConfig rc = new RequestConfig();
        rc.setKey(KEY_IN_MEMORY_ONLY);
        rc.setCached(false);
        requestInfo.setRequestConfig(rc);
        RequestRateLimitingConfig rcRT = new RequestRateLimitingConfig();
        rcRT.setKey(KEY_IN_MEMORY_ONLY);
        rcRT.setCached(false);
        requestInfo.setRequestRateLimitingConfig(rcRT);
        RequestThreadContext rt = new RequestThreadContext(KEY_IN_MEMORY_ONLY, logger != null ? logger : logConsole);
        requestInfo.setRequestThreadContext(rt);
    }

    public static void readRequestConfig(RequestInfo requestInfo) {
        if (!useCache) {
            GestoreRichieste.setRequestConfigInMemory(requestInfo);
            return;
        }
        String key = GestoreRichieste.buildKey(requestInfo, null, null);
        if (key == null) {
            return;
        }
        GestoreRichieste.readRequestConfigEngine(requestInfo, key, null);
        GestoreRichieste.readRequestRateLimitingConfigEngine(requestInfo, key);
        requestInfo.setRequestThreadContext(RequestThreadContext.getRequestThreadContext());
        if (requestInfo.getRequestThreadContext() != null) {
            requestInfo.getRequestThreadContext().setRequestFruitoreTrasportoInfo(null);
            requestInfo.getRequestThreadContext().setRequestFruitoreTokenInfo(null);
        }
        if (Cache.DEBUG_CACHE) {
            System.out.println(INIT_SEPARATOR);
            System.out.println("Creato RequestConfig con chiave '" + key + "'");
            System.out.println("\tRequestThreadContext '" + requestInfo.getRequestThreadContext().gettName() + "'");
            System.out.println(END_SEPARATOR);
        }
    }

    public static void updateRequestConfig(RequestInfo requestInfo, ServiceBinding serviceBinding, OpenSPCoop2MessageSoapStreamReader soapStreamReader) {
        if (!useCache) {
            return;
        }
        if (requestInfo == null || requestInfo.getRequestConfig() == null) {
            return;
        }
        String oldKey = requestInfo.getRequestConfig().getKey();
        String key = GestoreRichieste.buildKey(requestInfo, serviceBinding, soapStreamReader);
        if (key == null) {
            return;
        }
        if (key.equals(oldKey)) {
            return;
        }
        if (Cache.DEBUG_CACHE) {
            System.out.println(INIT_SEPARATOR);
            System.out.println("AGGIORNO RequestConfig");
            System.out.println("OLD: " + oldKey);
            System.out.println("NEW: " + key);
            System.out.println(END_SEPARATOR);
        }
        RequestConfig rcOld = requestInfo.getRequestConfig();
        GestoreRichieste.readRequestConfigEngine(requestInfo, key, rcOld);
        GestoreRichieste.readRequestRateLimitingConfigEngine(requestInfo, key);
        requestInfo.setPreRequestConfig(rcOld);
    }

    private static void readRequestConfigEngine(RequestInfo requestInfo, String key, RequestConfig srcClone) {
        if (cacheApi == null) {
            return;
        }
        CacheResponse response = (CacheResponse)cacheApi.get(key);
        if (response != null && response.getObject() != null) {
            RequestConfig rc = (RequestConfig)response.getObject();
            if (rc.getIdServizio() != null) {
                rc.setIdServizio(rc.getIdServizio().clone());
            }
            requestInfo.setRequestConfig(rc);
            return;
        }
        RequestConfig rc = new RequestConfig();
        if (srcClone != null) {
            rc.copyFrom(srcClone);
        } else {
            rc = new RequestConfig();
        }
        rc.setKey(key);
        rc.setCached(false);
        requestInfo.setRequestConfig(rc);
    }

    private static void readRequestRateLimitingConfigEngine(RequestInfo requestInfo, String key) {
        if (cacheRateLimiting == null) {
            return;
        }
        CacheResponse response = (CacheResponse)cacheRateLimiting.get(key);
        if (response != null && response.getObject() != null) {
            RequestRateLimitingConfig rc = (RequestRateLimitingConfig)response.getObject();
            requestInfo.setRequestRateLimitingConfig(rc);
            return;
        }
        RequestRateLimitingConfig rc = new RequestRateLimitingConfig();
        rc.setKey(key);
        rc.setCached(false);
        requestInfo.setRequestRateLimitingConfig(rc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveRequestConfig(RequestInfo requestInfo) throws UtilsException, CoreException {
        CacheResponse responseCache;
        CacheResponse response;
        String key;
        SemaphoreLock lock;
        if (!useCache) {
            return;
        }
        if (requestInfo == null) {
            return;
        }
        String idTransazione = requestInfo.getIdTransazione();
        if (cacheApi != null && requestInfo.getPreRequestConfig() != null && !requestInfo.getPreRequestConfig().isCached()) {
            lock = lockCache.acquire("savePreRequestConfig", idTransazione);
            try {
                key = requestInfo.getPreRequestConfig().getKey();
                response = (CacheResponse)cacheApi.get(key);
                if (response == null) {
                    responseCache = new CacheResponse();
                    requestInfo.getPreRequestConfig().setCached(true);
                    responseCache.setObject((Serializable)requestInfo.getPreRequestConfig());
                    cacheApi.put(key, responseCache);
                }
            }
            finally {
                lockCache.release(lock, "savePreRequestConfig", idTransazione);
            }
        }
        if (cacheApi != null && requestInfo.getRequestConfig() != null && !requestInfo.getRequestConfig().isCached()) {
            lock = lockCache.acquire("saveRequestConfig", idTransazione);
            try {
                key = requestInfo.getRequestConfig().getKey();
                response = (CacheResponse)cacheApi.get(key);
                if (response == null) {
                    responseCache = new CacheResponse();
                    requestInfo.getRequestConfig().setCached(true);
                    responseCache.setObject((Serializable)requestInfo.getRequestConfig());
                    cacheApi.put(key, responseCache);
                }
            }
            finally {
                lockCache.release(lock, "saveRequestConfig", idTransazione);
            }
        }
        if (cacheRateLimiting != null && requestInfo.getRequestRateLimitingConfig() != null && !requestInfo.getRequestRateLimitingConfig().isCached()) {
            lock = lockCache_rateLimiting.acquire("saveRequestRateLimitingConfig", idTransazione);
            try {
                key = requestInfo.getRequestConfig().getKey();
                response = (CacheResponse)cacheRateLimiting.get(key);
                if (response == null) {
                    responseCache = new CacheResponse();
                    requestInfo.getRequestRateLimitingConfig().setCached(true);
                    responseCache.setObject((Serializable)requestInfo.getRequestRateLimitingConfig());
                    cacheRateLimiting.put(key, responseCache);
                }
            }
            finally {
                lockCache_rateLimiting.release(lock, "saveRequestRateLimitingConfig", idTransazione);
            }
        }
        if (requestInfo.getRequestThreadContext() != null) {
            requestInfo.getRequestThreadContext().clear();
            requestInfo.setRequestThreadContext(null);
        }
    }

    private static String buildKey(RequestInfo requestInfo, ServiceBinding serviceBinding, OpenSPCoop2MessageSoapStreamReader soapStreamReader) {
        StringBuilder bf = new StringBuilder();
        ArrayList<String> headerInKey = new ArrayList<String>();
        headerInKey.add("SOAPAction");
        if (requestInfo.getProtocolContext() != null) {
            if (requestInfo.getProtocolContext().getFunctionParameters() == null || "".equals(requestInfo.getProtocolContext().getFunctionParameters().trim())) {
                return null;
            }
            if (requestInfo.getProtocolContext().getRequestType() != null) {
                if (bf.length() > 0) {
                    bf.append("\t");
                }
            } else {
                return null;
            }
            bf.append("Method:").append(requestInfo.getProtocolContext().getRequestType());
            if (requestInfo.getProtocolContext() != null) {
                if (bf.length() > 0) {
                    bf.append("\t");
                }
                bf.append("URL:").append(requestInfo.getProtocolContext().getUrlInvocazioneWithoutParameters());
            }
            if (!headerInKey.isEmpty()) {
                for (String header : headerInKey) {
                    String s = requestInfo.getProtocolContext().getHeader_compactMultipleValues(header);
                    if (s == null) continue;
                    if (bf.length() > 0) {
                        bf.append("\t");
                    }
                    bf.append(header).append(":").append(s);
                }
            }
        } else {
            return null;
        }
        if (ServiceBinding.SOAP.equals((Object)serviceBinding) && soapStreamReader != null) {
            if (soapStreamReader.getRootElementLocalName() != null && soapStreamReader.getRootElementNamespace() != null) {
                if (bf.length() > 0) {
                    bf.append("\t");
                }
                bf.append("soapRootElement:{").append(soapStreamReader.getRootElementNamespace()).append("}").append(soapStreamReader.getRootElementLocalName());
            } else {
                return null;
            }
        }
        return bf.toString();
    }

    public static RequestFruitore readFruitoreTrasporto(RequestInfo requestInfo, IDSoggetto idSoggetto, IDServizioApplicativo servizioApplicativo) {
        return GestoreRichieste.readFruitoreEngine(requestInfo, idSoggetto, servizioApplicativo, null, FRUITORE_TRASPORTO, true, false);
    }

    public static RequestFruitore readFruitoreToken(RequestInfo requestInfo, IDSoggetto idSoggetto, IDServizioApplicativo servizioApplicativo) {
        return GestoreRichieste.readFruitoreEngine(requestInfo, idSoggetto, servizioApplicativo, null, FRUITORE_TOKEN, false, false);
    }

    public static RequestFruitore readFruitoreTokenModI(RequestInfo requestInfo, String certificateKey) {
        return GestoreRichieste.readFruitoreEngine(requestInfo, null, null, certificateKey, FRUITORE_TOKEN_MODI, false, true);
    }

    private static RequestFruitore readFruitoreEngine(RequestInfo requestInfo, IDSoggetto idSoggetto, IDServizioApplicativo servizioApplicativo, String certificateKey, String tipo, boolean trasporto, boolean tokenModi) {
        String key = null;
        key = tokenModi ? GestoreRichieste.buildKey(null, null, certificateKey, tipo, tokenModi) : GestoreRichieste.buildKey(idSoggetto, servizioApplicativo, null, tipo, tokenModi);
        if (key == null && useCache) {
            return null;
        }
        if (useCache) {
            GestoreRichieste.readFruitoreEngine(requestInfo, key, trasporto);
        }
        if (requestInfo != null && requestInfo.getRequestThreadContext() != null) {
            if (trasporto) {
                if (requestInfo.getRequestThreadContext().getRequestFruitoreTrasportoInfo() != null) {
                    return requestInfo.getRequestThreadContext().getRequestFruitoreTrasportoInfo();
                }
                return null;
            }
            if (requestInfo.getRequestThreadContext().getRequestFruitoreTokenInfo() != null) {
                return requestInfo.getRequestThreadContext().getRequestFruitoreTokenInfo();
            }
            return null;
        }
        return null;
    }

    public static RequestFruitore readFruitoreEngine(RequestInfo requestInfo, String key, boolean trasporto) {
        if (requestInfo == null || requestInfo.getRequestThreadContext() == null) {
            return null;
        }
        if (cacheFruitori == null) {
            return null;
        }
        CacheResponse response = (CacheResponse)cacheFruitori.get(key);
        if (response != null && response.getObject() != null) {
            RequestFruitore rf = (RequestFruitore)response.getObject();
            if (trasporto) {
                requestInfo.getRequestThreadContext().setRequestFruitoreTrasportoInfo(rf);
            } else {
                requestInfo.getRequestThreadContext().setRequestFruitoreTokenInfo(rf);
            }
            return rf;
        }
        return null;
    }

    public static void saveRequestFruitoreTrasporto(RequestInfo requestInfo, RequestFruitore rf) throws UtilsException {
        GestoreRichieste.saveRequestFruitoreEngine(requestInfo, rf, FRUITORE_TRASPORTO, true, false);
    }

    public static void saveRequestFruitoreToken(RequestInfo requestInfo, RequestFruitore rf) throws UtilsException {
        GestoreRichieste.saveRequestFruitoreEngine(requestInfo, rf, FRUITORE_TOKEN, false, false);
    }

    public static void saveRequestFruitoreTokenModI(RequestInfo requestInfo, RequestFruitore rf) throws UtilsException {
        GestoreRichieste.saveRequestFruitoreEngine(requestInfo, rf, FRUITORE_TOKEN_MODI, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveRequestFruitoreEngine(RequestInfo requestInfo, RequestFruitore rf, String tipo, boolean trasporto, boolean tokenModi) throws UtilsException {
        if (requestInfo == null || requestInfo.getRequestThreadContext() == null || rf == null) {
            return;
        }
        String key = null;
        if (useCache) {
            if (tokenModi) {
                if (rf.getCertificateKey() == null) {
                    return;
                }
                key = GestoreRichieste.buildKey(null, null, rf.getCertificateKey(), tipo, tokenModi);
            } else {
                if (rf.getIdSoggettoFruitore() == null) {
                    return;
                }
                key = GestoreRichieste.buildKey(rf.getIdSoggettoFruitore(), rf.getIdServizioApplicativoFruitore(), null, tipo, tokenModi);
            }
            if (key == null) {
                return;
            }
        } else {
            key = KEY_IN_MEMORY_ONLY;
        }
        rf.setKey(key);
        rf.setCached(false);
        if (trasporto) {
            requestInfo.getRequestThreadContext().setRequestFruitoreTrasportoInfo(rf);
        } else {
            requestInfo.getRequestThreadContext().setRequestFruitoreTokenInfo(rf);
        }
        if (!useCache || cacheFruitori == null) {
            return;
        }
        String idTransazione = requestInfo.getIdTransazione();
        RequestFruitore requestFruitore = null;
        requestFruitore = trasporto ? requestInfo.getRequestThreadContext().getRequestFruitoreTrasportoInfo() : requestInfo.getRequestThreadContext().getRequestFruitoreTokenInfo();
        if (!requestFruitore.isCached()) {
            SemaphoreLock lock = lockCache_fruitori.acquire("saveRequestFruitore", idTransazione);
            try {
                CacheResponse response = (CacheResponse)cacheFruitori.get(key);
                if (response == null) {
                    CacheResponse responseCache = new CacheResponse();
                    requestFruitore.setCached(true);
                    responseCache.setObject((Serializable)requestFruitore);
                    cacheFruitori.put(key, responseCache);
                }
            }
            finally {
                lockCache_fruitori.release(lock, "saveRequestFruitore", idTransazione);
            }
        }
    }

    private static String buildKey(IDSoggetto idSoggetto, IDServizioApplicativo servizioApplicativo, String certificateKey, String tipo, boolean tokenModi) {
        StringBuilder bf = new StringBuilder();
        bf.append("auth:").append(tipo);
        if (tokenModi) {
            if (certificateKey == null) {
                return null;
            }
            bf.append(" cert:");
            bf.append(certificateKey);
        } else {
            if (idSoggetto == null) {
                return null;
            }
            bf.append(" soggetto:");
            bf.append(idSoggetto.toString());
            bf.append(" sa:");
            if (servizioApplicativo != null) {
                bf.append(servizioApplicativo.toFormatString());
            } else {
                bf.append("-");
            }
        }
        return bf.toString();
    }

    public static String toCertificateKey(CertificateInfo certificateInfo) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        if (certificateInfo.getSubject() == null) {
            return null;
        }
        sb.append("subject:");
        sb.append(certificateInfo.getSubject().toString());
        if (certificateInfo.getIssuer() == null) {
            return null;
        }
        sb.append(" issuer:");
        sb.append(certificateInfo.getIssuer().toString());
        if (certificateInfo.getSerialNumber() == null) {
            return null;
        }
        sb.append(" serialNumber:");
        sb.append(certificateInfo.getSerialNumber());
        sb.append("]");
        return sb.toString();
    }
}

