/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.validation.Schema;
import org.apache.cxf.common.util.StringUtils;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.constants.FormatoSpecifica;
import org.openspcoop2.core.registry.driver.AccordoServizioUtils;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.rest.AccordoServizioWrapper;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2RestJsonMessage;
import org.openspcoop2.message.OpenSPCoop2RestMessage;
import org.openspcoop2.message.OpenSPCoop2RestXmlMessage;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.exception.MessageException;
import org.openspcoop2.message.exception.MessageNotSupportedException;
import org.openspcoop2.message.rest.RestUtilities;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.CostantiPdD;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.ValidatoreMessaggiApplicativi;
import org.openspcoop2.pdd.core.ValidatoreMessaggiApplicativiException;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.constants.InformationApiSource;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.utils.ErroriProperties;
import org.openspcoop2.protocol.utils.PorteNamingUtils;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.json.JSONUtils;
import org.openspcoop2.utils.json.YAMLUtils;
import org.openspcoop2.utils.openapi.OpenapiApi;
import org.openspcoop2.utils.openapi.UniqueInterfaceGenerator;
import org.openspcoop2.utils.openapi.UniqueInterfaceGeneratorConfig;
import org.openspcoop2.utils.openapi.validator.OpenAPILibrary;
import org.openspcoop2.utils.openapi.validator.OpenapiApiValidatorConfig;
import org.openspcoop2.utils.openapi.validator.OpenapiLibraryValidatorConfig;
import org.openspcoop2.utils.rest.ApiFactory;
import org.openspcoop2.utils.rest.ApiFormats;
import org.openspcoop2.utils.rest.ApiReaderConfig;
import org.openspcoop2.utils.rest.ApiValidatorConfig;
import org.openspcoop2.utils.rest.IApiReader;
import org.openspcoop2.utils.rest.IApiValidator;
import org.openspcoop2.utils.rest.api.Api;
import org.openspcoop2.utils.rest.api.ApiSchema;
import org.openspcoop2.utils.rest.api.ApiSchemaType;
import org.openspcoop2.utils.rest.entity.BinaryHttpRequestEntity;
import org.openspcoop2.utils.rest.entity.BinaryHttpResponseEntity;
import org.openspcoop2.utils.rest.entity.Cookie;
import org.openspcoop2.utils.rest.entity.ElementHttpRequestEntity;
import org.openspcoop2.utils.rest.entity.ElementHttpResponseEntity;
import org.openspcoop2.utils.rest.entity.HttpBaseEntity;
import org.openspcoop2.utils.rest.entity.InputStreamHttpRequestEntity;
import org.openspcoop2.utils.rest.entity.InputStreamHttpResponseEntity;
import org.openspcoop2.utils.rest.entity.TextHttpRequestEntity;
import org.openspcoop2.utils.rest.entity.TextHttpResponseEntity;
import org.openspcoop2.utils.transport.TransportRequestContext;
import org.openspcoop2.utils.transport.http.ContentTypeUtilities;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.openspcoop2.utils.wsdl.WSDLException;
import org.openspcoop2.utils.xml.AbstractXMLUtils;
import org.openspcoop2.utils.xml.ValidatoreXSD;
import org.slf4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ValidatoreMessaggiApplicativiRest {
    private RegistroServiziManager registroServiziManager;
    private OpenSPCoop2Message message;
    private AccordoServizioWrapper accordoServizioWrapper = null;
    private Logger logger = null;
    private IProtocolFactory<?> protocolFactory;
    private PdDContext pddContext;
    private RequestInfo requestInfo;
    private boolean useInterface;
    private OpenapiLibraryValidatorConfig configOpenApiValidator;
    private OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
    private boolean bufferMessage_readOnly = true;

    public ValidatoreMessaggiApplicativiRest(RegistroServiziManager registro, IDServizio idServizio, OpenSPCoop2Message message, boolean readInterfaceAccordoServizio, List<Proprieta> proprieta, IProtocolFactory<?> protocolFactory, PdDContext pddContext) throws ValidatoreMessaggiApplicativiException {
        if (registro == null) {
            ValidatoreMessaggiApplicativiException ex = new ValidatoreMessaggiApplicativiException("Reader del Registro dei Servizi non fornito");
            ex.setErrore(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_531_VALIDAZIONE_TRAMITE_INTERFACCIA_FALLITA));
            throw ex;
        }
        if (idServizio == null || idServizio.getSoggettoErogatore() == null || idServizio.getTipo() == null || idServizio.getNome() == null || idServizio.getVersione() == null || idServizio.getSoggettoErogatore().getTipo() == null || idServizio.getSoggettoErogatore().getNome() == null) {
            ValidatoreMessaggiApplicativiException ex = new ValidatoreMessaggiApplicativiException("ID del servizio da validare, non fornito");
            ex.setErrore(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_531_VALIDAZIONE_TRAMITE_INTERFACCIA_FALLITA));
            throw ex;
        }
        this.message = message;
        this.registroServiziManager = registro;
        this.logger = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
        this.protocolFactory = protocolFactory;
        this.pddContext = pddContext;
        if (this.pddContext != null && this.pddContext.containsKey(Costanti.REQUEST_INFO)) {
            this.requestInfo = (RequestInfo)this.pddContext.getObject(Costanti.REQUEST_INFO);
        }
        try {
            this.useInterface = readInterfaceAccordoServizio;
            boolean processIncludeForOpenApi = true;
            this.configOpenApiValidator = new OpenapiLibraryValidatorConfig();
            this.configOpenApiValidator.setOpenApiLibrary(this.op2Properties.getValidazioneContenutiApplicativiOpenApiLibrary());
            if (OpenAPILibrary.openapi4j.equals((Object)this.configOpenApiValidator.getOpenApiLibrary()) || OpenAPILibrary.swagger_request_validator.equals((Object)this.configOpenApiValidator.getOpenApiLibrary())) {
                this.configOpenApiValidator.setMergeAPISpec(this.op2Properties.isValidazioneContenutiApplicativiOpenApiMergeAPISpec());
                this.configOpenApiValidator.setValidateAPISpec(this.op2Properties.isValidazioneContenutiApplicativiOpenApiValidateAPISpec());
                this.configOpenApiValidator.setValidateRequestPath(this.op2Properties.isValidazioneContenutiApplicativiOpenApiValidateRequestPath());
                this.configOpenApiValidator.setValidateRequestQuery(this.op2Properties.isValidazioneContenutiApplicativiOpenApiValidateRequestQuery());
                this.configOpenApiValidator.setValidateRequestUnexpectedQueryParam(this.op2Properties.isValidazioneContenutiApplicativiOpenApiValidateRequestUnexpectedQueryParam());
                this.configOpenApiValidator.setValidateRequestHeaders(this.op2Properties.isValidazioneContenutiApplicativiOpenApiValidateRequestHeaders());
                this.configOpenApiValidator.setValidateRequestCookie(this.op2Properties.isValidazioneContenutiApplicativiOpenApiValidateRequestCookie());
                this.configOpenApiValidator.setValidateRequestBody(this.op2Properties.isValidazioneContenutiApplicativiOpenApiValidateRequestBody());
                this.configOpenApiValidator.setValidateResponseHeaders(this.op2Properties.isValidazioneContenutiApplicativiOpenApiValidateResponseHeaders());
                this.configOpenApiValidator.setValidateResponseBody(this.op2Properties.isValidazioneContenutiApplicativiOpenApiValidateResponseBody());
                this.configOpenApiValidator.setValidateWildcardSubtypeAsJson(this.op2Properties.isValidazioneContenutiApplicativiOpenApiValidateWildcardSubtypeAsJson());
                this.configOpenApiValidator.setValidateMultipartOptimization(this.op2Properties.isValidazioneContenutiApplicativiOpenApiValidateMultipartOptimization());
                this.configOpenApiValidator.setSwaggerRequestValidator_InjectingAdditionalPropertiesFalse(this.op2Properties.isValidazioneContenutiApplicativiOpenApiSwaggerRequestValidatorInjectingAdditionalPropertiesFalse());
                this.configOpenApiValidator.setSwaggerRequestValidator_ResolveFullyApiSpec(this.op2Properties.isValidazioneContenutiApplicativiOpenApiSwaggerRequestValidatorResolveFullyApiSpec());
            }
            this.updateOpenapiValidatorConfig(proprieta, this.configOpenApiValidator);
            if (OpenAPILibrary.openapi4j.equals((Object)this.configOpenApiValidator.getOpenApiLibrary()) || OpenAPILibrary.swagger_request_validator.equals((Object)this.configOpenApiValidator.getOpenApiLibrary())) {
                processIncludeForOpenApi = false;
            }
            this.bufferMessage_readOnly = OpenSPCoop2Properties.getInstance().isValidazioneContenutiApplicativiBufferContentRead();
            if (proprieta != null && !proprieta.isEmpty()) {
                boolean defaultBehaviour = this.bufferMessage_readOnly;
                this.bufferMessage_readOnly = ValidatoreMessaggiApplicativiRest.readBooleanValueWithDefault(proprieta, "validation.buffer.enabled", defaultBehaviour);
            }
            this.accordoServizioWrapper = readInterfaceAccordoServizio ? this.registroServiziManager.getRestAccordoServizio(idServizio, InformationApiSource.SPECIFIC, true, processIncludeForOpenApi, false, this.requestInfo) : this.registroServiziManager.getRestAccordoServizio(idServizio, InformationApiSource.REGISTRY, true, processIncludeForOpenApi, true, this.requestInfo);
        }
        catch (DriverRegistroServiziNotFound e) {
            this.logger.error("Riscontrato errore durante la ricerca del formato di specifica che definisce l'accordo di servizio: " + e.getMessage(), (Throwable)e);
            ValidatoreMessaggiApplicativiException ex = new ValidatoreMessaggiApplicativiException("Riscontrato errore durante la ricerca del formato di specifica: " + e.getMessage(), e);
            ex.setErrore(ErroriIntegrazione.ERRORE_405_SERVIZIO_NON_TROVATO.getErroreIntegrazione());
            throw ex;
        }
        catch (DriverRegistroServiziException e) {
            FormatoSpecifica formatoSpecifica = null;
            try {
                AccordoServizioParteSpecifica asps = this.registroServiziManager.getAccordoServizioParteSpecifica(idServizio, null, Boolean.valueOf(false), this.requestInfo);
                AccordoServizioParteComune apc = this.registroServiziManager.getAccordoServizioParteComune(IDAccordoFactory.getInstance().getIDAccordoFromUri(asps.getAccordoServizioParteComune()), null, Boolean.valueOf(false), Boolean.valueOf(false), this.requestInfo);
                formatoSpecifica = apc.getFormatoSpecifica();
            }
            catch (Exception asps) {
                // empty catch block
            }
            this.logger.error("Riscontrato errore durante l'inizializzazione: " + e.getMessage(), (Throwable)e);
            ValidatoreMessaggiApplicativiException ex = new ValidatoreMessaggiApplicativiException("Riscontrato errore durante l'inizializzazione: " + e.getMessage(), e);
            if (e.getMessage() != null && formatoSpecifica != null) {
                ex.setErrore(ErroriIntegrazione.ERRORE_417_COSTRUZIONE_VALIDATORE_TRAMITE_INTERFACCIA_FALLITA.getErrore417_CostruzioneValidatoreTramiteInterfacciaFallita(formatoSpecifica.getValue()));
                throw ex;
            }
            ex.setErrore(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_530_COSTRUZIONE_INTERFACCIA_FALLITA));
            throw ex;
        }
    }

    public AccordoServizioWrapper getAccordoServizioWrapper() {
        return this.accordoServizioWrapper;
    }

    public void validateWithSchemiXSD(boolean isRichiesta) throws ValidatoreMessaggiApplicativiException {
        if (ServiceBinding.SOAP.equals((Object)this.message.getServiceBinding())) {
            throw new ValidatoreMessaggiApplicativiException("Tipo di validazione non supportata con Service Binding SOAP");
        }
        if (!MessageType.XML.equals((Object)this.message.getMessageType())) {
            throw new ValidatoreMessaggiApplicativiException("Tipo di validazione non supportata con Service Binding REST e MessageType '" + this.message.getMessageType() + "'");
        }
        try {
            if (!this.message.castAsRest().hasContent()) {
                return;
            }
        }
        catch (Exception e) {
            this.logger.error("Riscontrato errore durante il controllo del messaggio: " + e.getMessage(), (Throwable)e);
            ValidatoreMessaggiApplicativiException ex = new ValidatoreMessaggiApplicativiException("Riscontrato errore durante l'inizializzazione: " + e.getMessage(), e);
            ex.setErrore(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_530_COSTRUZIONE_INTERFACCIA_FALLITA));
            throw ex;
        }
        ValidatoreXSD validatoreBodyApplicativo = null;
        try {
            AccordoServizioUtils accordoServizioUtils = new AccordoServizioUtils(this.message.getFactory(), this.logger);
            boolean fromBytes = this.accordoServizioWrapper.isRegistroServiziDB();
            Schema schema = accordoServizioUtils.buildSchema(this.accordoServizioWrapper.getAccordoServizio(), fromBytes);
            try {
                if (schema == null) {
                    throw new Exception("Schema non costruito?");
                }
                validatoreBodyApplicativo = new ValidatoreXSD(schema);
            }
            catch (Exception e2) {
                throw new WSDLException("Riscontrato errore durante la costruzione del validatore XSD per il contenuto applicativo: " + e2.getMessage(), (Throwable)e2);
            }
        }
        catch (Exception e) {
            this.logger.error("validateWithSchemiXSD failed: " + e.getMessage(), (Throwable)e);
            ValidatoreMessaggiApplicativiException ex = new ValidatoreMessaggiApplicativiException(e.getMessage(), e);
            ex.setErrore(ErroriIntegrazione.ERRORE_417_COSTRUZIONE_VALIDATORE_TRAMITE_INTERFACCIA_FALLITA.getErrore417_CostruzioneValidatoreTramiteInterfacciaFallita("Schema xsd dei messaggi"));
            throw ex;
        }
        try {
            String idTransazione = null;
            if (this.pddContext != null) {
                idTransazione = (String)this.pddContext.getObject(Costanti.ID_TRANSAZIONE);
            }
            OpenSPCoop2RestXmlMessage xmlMsg = this.message.castAsRestXml();
            Element content = (Element)xmlMsg.getContent(this.bufferMessage_readOnly, idTransazione);
            validatoreBodyApplicativo.valida((Node)content);
        }
        catch (Exception e) {
            Object messaggioErrore = e.getMessage();
            boolean overwriteMessageError = false;
            try {
                messaggioErrore = ErroriProperties.getInstance((Logger)this.logger).getGenericDetails_noWrap(isRichiesta ? IntegrationFunctionError.INVALID_REQUEST_CONTENT : IntegrationFunctionError.INVALID_RESPONSE_CONTENT);
                messaggioErrore = (String)messaggioErrore + ": " + ValidatoreMessaggiApplicativi.processValidationErrorMessage(e.getMessage(), this.op2Properties);
                overwriteMessageError = true;
            }
            catch (Exception e2) {
                // empty catch block
            }
            ValidatoreMessaggiApplicativiException ex = new ValidatoreMessaggiApplicativiException((String)messaggioErrore, e);
            if (isRichiesta) {
                ex.setErrore(ErroriIntegrazione.ERRORE_418_VALIDAZIONE_RICHIESTA_TRAMITE_INTERFACCIA_FALLITA.getErrore418_ValidazioneRichiestaTramiteInterfacciaFallita("Schema xsd dei messaggi", (String)messaggioErrore, overwriteMessageError));
            } else {
                ex.setErrore(ErroriIntegrazione.ERRORE_419_VALIDAZIONE_RISPOSTA_TRAMITE_INTERFACCIA_FALLITA.getErrore419_ValidazioneRispostaTramiteInterfacciaFallita("Schema xsd dei messaggi", (String)messaggioErrore, overwriteMessageError));
            }
            throw ex;
        }
    }

    public void validateRequestWithInterface(boolean portaApplicativa) throws ValidatoreMessaggiApplicativiException {
        this.validateWithInterface(true, portaApplicativa, null);
    }

    public void validateResponseWithInterface(OpenSPCoop2Message requestMessage, boolean portaApplicativa) throws ValidatoreMessaggiApplicativiException {
        this.validateWithInterface(false, portaApplicativa, requestMessage);
    }

    private void validateWithInterface(boolean isRichiesta, boolean portaApplicativa, OpenSPCoop2Message requestMessage) throws ValidatoreMessaggiApplicativiException {
        if (ServiceBinding.SOAP.equals((Object)this.message.getServiceBinding())) {
            throw new ValidatoreMessaggiApplicativiException("Tipo di validazione non supportata con Service Binding SOAP");
        }
        String interfaceType = null;
        ApiFormats format = null;
        ApiValidatorConfig validatorConfig = null;
        OpenAPILibrary openApiLibrary = null;
        Api api = this.accordoServizioWrapper.getApi();
        switch (this.accordoServizioWrapper.getAccordoServizio().getFormatoSpecifica()) {
            case WADL: {
                interfaceType = "Interfaccia WADL";
                format = ApiFormats.WADL;
                validatorConfig = new ApiValidatorConfig();
                break;
            }
            case SWAGGER_2: {
                interfaceType = "Interfaccia Swagger 2";
                format = ApiFormats.SWAGGER_2;
                validatorConfig = new OpenapiApiValidatorConfig();
                ((OpenapiApiValidatorConfig)validatorConfig).setJsonValidatorAPI(this.op2Properties.getValidazioneContenutiApplicativiOpenApiJsonValidator());
                if (!this.useInterface || this.configOpenApiValidator == null || !OpenAPILibrary.swagger_request_validator.equals((Object)(openApiLibrary = this.configOpenApiValidator.getOpenApiLibrary()))) break;
                ((OpenapiApiValidatorConfig)validatorConfig).setOpenApiValidatorConfig(this.configOpenApiValidator);
                if (!this.configOpenApiValidator.isMergeAPISpec()) break;
                this.configOpenApiValidator.setMergeAPISpec(false);
                break;
            }
            case OPEN_API_3: {
                OpenapiApi openapi;
                interfaceType = "Interfaccia OpenAPI 3";
                format = ApiFormats.OPEN_API_3;
                validatorConfig = new OpenapiApiValidatorConfig();
                ((OpenapiApiValidatorConfig)validatorConfig).setJsonValidatorAPI(this.op2Properties.getValidazioneContenutiApplicativiOpenApiJsonValidator());
                if (!this.useInterface || this.configOpenApiValidator == null || !OpenAPILibrary.openapi4j.equals((Object)(openApiLibrary = this.configOpenApiValidator.getOpenApiLibrary())) && !OpenAPILibrary.swagger_request_validator.equals((Object)openApiLibrary)) break;
                ((OpenapiApiValidatorConfig)validatorConfig).setOpenApiValidatorConfig(this.configOpenApiValidator);
                if (!this.configOpenApiValidator.isMergeAPISpec() || !(api instanceof OpenapiApi) || (openapi = (OpenapiApi)api).getValidationStructure() != null) break;
                api = this.mergeApiSpec(openapi, this.accordoServizioWrapper);
                break;
            }
            default: {
                throw new ValidatoreMessaggiApplicativiException("Tipo di interfaccia [" + this.accordoServizioWrapper.getAccordoServizio().getFormatoSpecifica() + "] non supportata");
            }
        }
        IApiValidator apiValidator = null;
        try {
            apiValidator = ApiFactory.newApiValidator((ApiFormats)format);
            validatorConfig.setXmlUtils((AbstractXMLUtils)MessageXMLUtils.getInstance((OpenSPCoop2MessageFactory)this.message.getFactory()));
            validatorConfig.setVerbose(this.op2Properties.isValidazioneContenutiApplicativiDebug());
            validatorConfig.setPolicyAdditionalProperties(this.op2Properties.getValidazioneContenutiApplicativiJsonPolicyAdditionalProperties());
            apiValidator.init(this.logger, api, validatorConfig);
        }
        catch (Exception e) {
            this.logger.error("validateWithInterface failed: " + e.getMessage(), (Throwable)e);
            ValidatoreMessaggiApplicativiException ex = new ValidatoreMessaggiApplicativiException(e.getMessage(), e);
            ex.setErrore(ErroriIntegrazione.ERRORE_417_COSTRUZIONE_VALIDATORE_TRAMITE_INTERFACCIA_FALLITA.getErrore417_CostruzioneValidatoreTramiteInterfacciaFallita(interfaceType));
            throw ex;
        }
        InputStream isContent = null;
        try {
            TransportRequestContext transportContext = null;
            transportContext = isRichiesta ? this.message.getTransportRequestContext() : requestMessage.getTransportRequestContext();
            String normalizedInterfaceName = null;
            try {
                String interfaceName = null;
                interfaceName = this.pddContext != null && this.pddContext.containsKey(CostantiPdD.NOME_PORTA_INVOCATA) ? (String)this.pddContext.getObject(CostantiPdD.NOME_PORTA_INVOCATA) : transportContext.getInterfaceName();
                if (transportContext.getInterfaceName() != null) {
                    PorteNamingUtils namingUtils = new PorteNamingUtils(this.protocolFactory);
                    normalizedInterfaceName = portaApplicativa ? namingUtils.normalizePA(interfaceName) : namingUtils.normalizePD(interfaceName);
                }
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
            }
            String path = RestUtilities.getUrlWithoutInterface((TransportRequestContext)transportContext, normalizedInterfaceName);
            HttpRequestMethod httpMethod = HttpRequestMethod.valueOf((String)transportContext.getRequestType());
            String idTransazione = null;
            if (this.pddContext != null) {
                idTransazione = (String)this.pddContext.getObject(Costanti.ID_TRANSAZIONE);
            }
            if (isRichiesta) {
                ElementHttpRequestEntity httpRequest = null;
                switch (this.message.getMessageType()) {
                    case XML: {
                        httpRequest = new ElementHttpRequestEntity();
                        if (!this.message.castAsRest().hasContent()) break;
                        OpenSPCoop2RestXmlMessage xmlMsg = this.message.castAsRestXml();
                        Element contentXml = (Element)xmlMsg.getContent(this.bufferMessage_readOnly, idTransazione);
                        if (OpenAPILibrary.openapi4j.equals((Object)openApiLibrary) || OpenAPILibrary.swagger_request_validator.equals((Object)openApiLibrary)) {
                            httpRequest = new BinaryHttpRequestEntity();
                            ByteArrayOutputStream bout = new ByteArrayOutputStream();
                            this.message.writeTo((OutputStream)bout, false);
                            bout.flush();
                            bout.close();
                            ((BinaryHttpRequestEntity)httpRequest).setContent((Object)bout.toByteArray());
                            break;
                        }
                        httpRequest.setContent((Object)contentXml);
                        break;
                    }
                    case JSON: {
                        httpRequest = new TextHttpRequestEntity();
                        if (!this.message.castAsRest().hasContent()) break;
                        OpenSPCoop2RestJsonMessage jsonMsg = this.message.castAsRestJson();
                        String contentString = (String)jsonMsg.getContent(this.bufferMessage_readOnly, idTransazione);
                        ((TextHttpRequestEntity)httpRequest).setContent((Object)contentString);
                        break;
                    }
                    case BINARY: 
                    case MIME_MULTIPART: {
                        OpenSPCoop2RestMessage restMsg = this.message.castAsRest();
                        if (restMsg.hasContent()) {
                            InputStream isLazyContent;
                            boolean lazy = restMsg.setInputStreamLazyBuffer(idTransazione);
                            InputStream inputStream = isLazyContent = lazy ? restMsg.getInputStream() : null;
                            if (isLazyContent != null) {
                                httpRequest = new InputStreamHttpRequestEntity();
                                ((InputStreamHttpRequestEntity)httpRequest).setContent((Object)isLazyContent);
                                break;
                            }
                            restMsg.initContent(this.bufferMessage_readOnly, idTransazione);
                            isContent = restMsg.getInputStreamFromContentBuffer();
                            if (isContent != null) {
                                httpRequest = new InputStreamHttpRequestEntity();
                                ((InputStreamHttpRequestEntity)httpRequest).setContent((Object)isContent);
                                break;
                            }
                            httpRequest = new BinaryHttpRequestEntity();
                            ByteArrayOutputStream bout = new ByteArrayOutputStream();
                            this.message.writeTo((OutputStream)bout, false);
                            bout.flush();
                            bout.close();
                            ((BinaryHttpRequestEntity)httpRequest).setContent((Object)bout.toByteArray());
                            break;
                        }
                        httpRequest = new BinaryHttpRequestEntity();
                        break;
                    }
                }
                if (httpRequest == null) {
                    throw new Exception("HttpRequest undefined");
                }
                httpRequest.setContentType(this.message.getContentType());
                httpRequest.setHeaders(this.message.getTransportRequestContext().getHeaders());
                httpRequest.setParameters(this.message.getTransportRequestContext().getParameters());
                Map mapCookies = this.message.getTransportRequestContext().getCookiesValue();
                if (mapCookies != null && !mapCookies.isEmpty()) {
                    for (String name : mapCookies.keySet()) {
                        String value = (String)mapCookies.get(name);
                        Cookie cookie = new Cookie(name, value);
                        if (httpRequest.getCookies() == null) {
                            httpRequest.setCookies(new ArrayList());
                        }
                        httpRequest.getCookies().add(cookie);
                    }
                }
                httpRequest.setUrl(path);
                httpRequest.setMethod(httpMethod);
                apiValidator.validate((HttpBaseEntity)httpRequest);
            } else {
                ElementHttpResponseEntity httpResponse = null;
                switch (this.message.getMessageType()) {
                    case XML: {
                        httpResponse = new ElementHttpResponseEntity();
                        if (!this.message.castAsRest().hasContent()) break;
                        OpenSPCoop2RestXmlMessage xmlMsg = this.message.castAsRestXml();
                        Element contentXml = (Element)xmlMsg.getContent(this.bufferMessage_readOnly, idTransazione);
                        if (OpenAPILibrary.openapi4j.equals((Object)openApiLibrary) || OpenAPILibrary.swagger_request_validator.equals((Object)openApiLibrary)) {
                            httpResponse = new BinaryHttpResponseEntity();
                            ByteArrayOutputStream bout = new ByteArrayOutputStream();
                            this.message.writeTo((OutputStream)bout, false);
                            bout.flush();
                            bout.close();
                            ((BinaryHttpResponseEntity)httpResponse).setContent((Object)bout.toByteArray());
                            break;
                        }
                        httpResponse.setContent((Object)contentXml);
                        break;
                    }
                    case JSON: {
                        httpResponse = new TextHttpResponseEntity();
                        if (!this.message.castAsRest().hasContent()) break;
                        OpenSPCoop2RestJsonMessage jsonMsg = this.message.castAsRestJson();
                        String contentString = (String)jsonMsg.getContent(this.bufferMessage_readOnly, idTransazione);
                        ((TextHttpResponseEntity)httpResponse).setContent((Object)contentString);
                        break;
                    }
                    case BINARY: 
                    case MIME_MULTIPART: {
                        OpenSPCoop2RestMessage restMsg = this.message.castAsRest();
                        if (restMsg.hasContent()) {
                            InputStream isLazyContent;
                            boolean lazy = restMsg.setInputStreamLazyBuffer(idTransazione);
                            InputStream inputStream = isLazyContent = lazy ? restMsg.getInputStream() : null;
                            if (isLazyContent != null) {
                                httpResponse = new InputStreamHttpResponseEntity();
                                ((InputStreamHttpResponseEntity)httpResponse).setContent((Object)isLazyContent);
                                break;
                            }
                            restMsg.initContent(this.bufferMessage_readOnly, idTransazione);
                            isContent = restMsg.getInputStreamFromContentBuffer();
                            if (isContent != null) {
                                httpResponse = new InputStreamHttpResponseEntity();
                                ((InputStreamHttpResponseEntity)httpResponse).setContent((Object)isContent);
                                break;
                            }
                            httpResponse = new BinaryHttpResponseEntity();
                            ByteArrayOutputStream bout = new ByteArrayOutputStream();
                            this.message.writeTo((OutputStream)bout, false);
                            bout.flush();
                            bout.close();
                            ((BinaryHttpResponseEntity)httpResponse).setContent((Object)bout.toByteArray());
                            break;
                        }
                        httpResponse = new BinaryHttpResponseEntity();
                        break;
                    }
                }
                if (httpResponse == null) {
                    throw new Exception("httpResponse undefined");
                }
                httpResponse.setContentType(this.message.getContentType());
                httpResponse.setHeaders(this.message.getTransportResponseContext().getHeaders());
                httpResponse.setUrl(path);
                httpResponse.setMethod(httpMethod);
                httpResponse.setStatus(Integer.parseInt(this.message.getTransportResponseContext().getCodiceTrasporto()));
                apiValidator.validate((HttpBaseEntity)httpResponse);
            }
        }
        catch (Throwable e) {
            Object messaggioErrore = e.getMessage();
            boolean overwriteMessageError = false;
            try {
                messaggioErrore = ErroriProperties.getInstance((Logger)this.logger).getGenericDetails_noWrap(isRichiesta ? IntegrationFunctionError.INVALID_REQUEST_CONTENT : IntegrationFunctionError.INVALID_RESPONSE_CONTENT);
                messaggioErrore = (String)messaggioErrore + ": " + ValidatoreMessaggiApplicativi.processValidationErrorMessage(e.getMessage(), this.op2Properties);
                overwriteMessageError = true;
            }
            catch (Exception httpMethod) {
                // empty catch block
            }
            ValidatoreMessaggiApplicativiException ex = new ValidatoreMessaggiApplicativiException((String)messaggioErrore, e);
            if (isRichiesta) {
                ex.setErrore(ErroriIntegrazione.ERRORE_418_VALIDAZIONE_RICHIESTA_TRAMITE_INTERFACCIA_FALLITA.getErrore418_ValidazioneRichiestaTramiteInterfacciaFallita(interfaceType, (String)messaggioErrore, overwriteMessageError));
            } else {
                ex.setErrore(ErroriIntegrazione.ERRORE_419_VALIDAZIONE_RISPOSTA_TRAMITE_INTERFACCIA_FALLITA.getErrore419_ValidazioneRispostaTramiteInterfacciaFallita(interfaceType, (String)messaggioErrore, overwriteMessageError));
            }
            throw ex;
        }
        finally {
            try {
                apiValidator.close(this.logger, this.accordoServizioWrapper.getApi(), validatorConfig);
            }
            catch (Throwable e) {
                this.logger.error("validateWithInterface close error: " + e.getMessage(), e);
            }
            try {
                if (isContent != null) {
                    isContent.close();
                    isContent = null;
                }
            }
            catch (Throwable e) {}
        }
    }

    private Api mergeApiSpec(OpenapiApi api, AccordoServizioWrapper accordoServizioWrapper) {
        YAMLUtils yamlUtils = YAMLUtils.getInstance();
        JSONUtils jsonUtils = JSONUtils.getInstance();
        HashMap<String, String> attachments = new HashMap<String, String>();
        if (api.getSchemas() != null && api.getSchemas().size() > 0) {
            for (ApiSchema apiSchema : api.getSchemas()) {
                if (!ApiSchemaType.JSON.equals((Object)apiSchema.getType()) && !ApiSchemaType.YAML.equals((Object)apiSchema.getType())) continue;
                byte[] schema = apiSchema.getContent();
                if (ApiSchemaType.JSON.equals((Object)apiSchema.getType())) {
                    if (!jsonUtils.isJson(schema)) continue;
                    attachments.put(apiSchema.getName(), new String(apiSchema.getContent()));
                    continue;
                }
                if (!yamlUtils.isYaml(schema)) continue;
                attachments.put(apiSchema.getName(), new String(apiSchema.getContent()));
            }
        }
        if (attachments.isEmpty()) {
            return api;
        }
        String apiRaw = api.getApiRaw();
        boolean apiRawIsYaml = yamlUtils.isYaml(apiRaw);
        UniqueInterfaceGeneratorConfig configUniqueInterfaceGeneratorConfig = new UniqueInterfaceGeneratorConfig();
        configUniqueInterfaceGeneratorConfig.setFormat(ApiFormats.OPEN_API_3);
        configUniqueInterfaceGeneratorConfig.setYaml(apiRawIsYaml);
        configUniqueInterfaceGeneratorConfig.setMaster(apiRaw);
        configUniqueInterfaceGeneratorConfig.setAttachments(attachments);
        try {
            String apiMerged = UniqueInterfaceGenerator.generate((UniqueInterfaceGeneratorConfig)configUniqueInterfaceGeneratorConfig, null, null, (boolean)true, (Logger)this.logger);
            if (apiMerged == null) {
                throw new Exception("empty ApiSpec");
            }
            IApiReader apiReader = ApiFactory.newApiReader((ApiFormats)ApiFormats.OPEN_API_3);
            ApiReaderConfig config = new ApiReaderConfig();
            config.setProcessInclude(false);
            config.setProcessInlineSchema(true);
            apiReader.init(this.logger, apiMerged, config);
            Api apiMergedObject = apiReader.read();
            if (apiMergedObject == null) {
                throw new Exception("empty ApiSpec after read");
            }
            accordoServizioWrapper.updateApi(apiMergedObject);
            return apiMergedObject;
        }
        catch (Throwable t) {
            this.logger.error("Merge API Spec failed: " + t.getMessage(), t);
            return api;
        }
    }

    private void updateOpenapiValidatorConfig(List<Proprieta> proprieta, OpenapiLibraryValidatorConfig configOpenApi4j) {
        String validateWildcardSubtypeAsJson;
        String validateResponseBody;
        String validateResponseHeaders;
        String validateRequestBody;
        String validateRequestCookie;
        String validateRequestHeaders;
        String validateRequestQueryUnexpectedQueryParam;
        String validateRequestQuery;
        String validateRequestPath;
        String validateAPISpec;
        if (proprieta == null || proprieta.isEmpty()) {
            return;
        }
        String useOpenApi4j = ValidatoreMessaggiApplicativiRest.readValue(proprieta, "validation.openApi4j.enabled");
        boolean openApi4jForceDisabled = false;
        if (useOpenApi4j != null && !StringUtils.isEmpty((String)useOpenApi4j)) {
            if ("true".equals(useOpenApi4j.trim())) {
                configOpenApi4j.setOpenApiLibrary(OpenAPILibrary.openapi4j);
            } else if ("false".equals(useOpenApi4j.trim())) {
                openApi4jForceDisabled = true;
            }
        }
        String useSwaggerRequestValidator = ValidatoreMessaggiApplicativiRest.readValue(proprieta, "validation.swaggerRequestValidator.enabled");
        boolean swaggerRequestValidatorForceDisabled = false;
        if (useSwaggerRequestValidator != null && !StringUtils.isEmpty((String)useSwaggerRequestValidator)) {
            if ("true".equals(useSwaggerRequestValidator.trim())) {
                configOpenApi4j.setOpenApiLibrary(OpenAPILibrary.swagger_request_validator);
            } else if ("false".equals(useSwaggerRequestValidator.trim())) {
                swaggerRequestValidatorForceDisabled = true;
            }
        }
        if (openApi4jForceDisabled && swaggerRequestValidatorForceDisabled) {
            configOpenApi4j.setOpenApiLibrary(OpenAPILibrary.json_schema);
        }
        if (!OpenAPILibrary.openapi4j.equals((Object)configOpenApi4j.getOpenApiLibrary()) && !OpenAPILibrary.swagger_request_validator.equals((Object)configOpenApi4j.getOpenApiLibrary())) {
            return;
        }
        boolean openapi4j = OpenAPILibrary.openapi4j.equals((Object)configOpenApi4j.getOpenApiLibrary());
        String enabled = openapi4j ? "true" : "true";
        String disabled = openapi4j ? "false" : "false";
        String mergeAPISpec = ValidatoreMessaggiApplicativiRest.readValue(proprieta, openapi4j ? "validation.openApi4j.mergeAPISpec" : "validation.swaggerRequestValidator.mergeAPISpec");
        if (mergeAPISpec == null || StringUtils.isEmpty((String)mergeAPISpec)) {
            mergeAPISpec = ValidatoreMessaggiApplicativiRest.readValue(proprieta, "validation.openApi.mergeAPISpec");
        }
        if (mergeAPISpec != null && !StringUtils.isEmpty((String)mergeAPISpec)) {
            if (enabled.equals(mergeAPISpec.trim())) {
                configOpenApi4j.setMergeAPISpec(true);
            } else if (disabled.equals(mergeAPISpec.trim())) {
                configOpenApi4j.setMergeAPISpec(false);
            }
        }
        if ((validateAPISpec = ValidatoreMessaggiApplicativiRest.readValue(proprieta, openapi4j ? "validation.openApi4j.validateAPISpec" : "validation.swaggerRequestValidator.validateAPISpec")) == null || StringUtils.isEmpty((String)validateAPISpec)) {
            validateAPISpec = ValidatoreMessaggiApplicativiRest.readValue(proprieta, "validation.openApi.validateAPISpec");
        }
        if (validateAPISpec != null && !StringUtils.isEmpty((String)validateAPISpec)) {
            if (enabled.equals(validateAPISpec.trim())) {
                configOpenApi4j.setValidateAPISpec(true);
            } else if (disabled.equals(validateAPISpec.trim())) {
                configOpenApi4j.setValidateAPISpec(false);
            }
        }
        if ((validateRequestPath = ValidatoreMessaggiApplicativiRest.readValue(proprieta, openapi4j ? "validation.openApi4j.validateRequestPath" : "validation.swaggerRequestValidator.validateRequestPath")) == null || StringUtils.isEmpty((String)validateRequestPath)) {
            validateRequestPath = ValidatoreMessaggiApplicativiRest.readValue(proprieta, "validation.openApi.validateRequestPath");
        }
        if (validateRequestPath != null && !StringUtils.isEmpty((String)validateRequestPath)) {
            if (enabled.equals(validateRequestPath.trim())) {
                configOpenApi4j.setValidateRequestPath(true);
            } else if (disabled.equals(validateRequestPath.trim())) {
                configOpenApi4j.setValidateRequestPath(false);
            }
        }
        if ((validateRequestQuery = ValidatoreMessaggiApplicativiRest.readValue(proprieta, openapi4j ? "validation.openApi4j.validateRequestQuery" : "validation.swaggerRequestValidator.validateRequestQuery")) == null || StringUtils.isEmpty((String)validateRequestQuery)) {
            validateRequestQuery = ValidatoreMessaggiApplicativiRest.readValue(proprieta, "validation.openApi.validateRequestQuery");
        }
        if (validateRequestQuery != null && !StringUtils.isEmpty((String)validateRequestQuery)) {
            if (enabled.equals(validateRequestQuery.trim())) {
                configOpenApi4j.setValidateRequestQuery(true);
            } else if (disabled.equals(validateRequestQuery.trim())) {
                configOpenApi4j.setValidateRequestQuery(false);
            }
        }
        if ((validateRequestQueryUnexpectedQueryParam = ValidatoreMessaggiApplicativiRest.readValue(proprieta, openapi4j ? "validation.openApi4j.validateRequestUnexpectedQueryParam" : "validation.swaggerRequestValidator.validateRequestUnexpectedQueryParam")) == null || StringUtils.isEmpty((String)validateRequestQueryUnexpectedQueryParam)) {
            validateRequestQueryUnexpectedQueryParam = ValidatoreMessaggiApplicativiRest.readValue(proprieta, "validation.openApi.validateRequestUnexpectedQueryParam");
        }
        if (validateRequestQueryUnexpectedQueryParam != null && !StringUtils.isEmpty((String)validateRequestQueryUnexpectedQueryParam)) {
            if (enabled.equals(validateRequestQueryUnexpectedQueryParam.trim())) {
                configOpenApi4j.setValidateRequestUnexpectedQueryParam(true);
            } else if (disabled.equals(validateRequestQueryUnexpectedQueryParam.trim())) {
                configOpenApi4j.setValidateRequestUnexpectedQueryParam(false);
            }
        }
        if ((validateRequestHeaders = ValidatoreMessaggiApplicativiRest.readValue(proprieta, openapi4j ? "validation.openApi4j.validateRequestHeaders" : "validation.swaggerRequestValidator.validateRequestHeaders")) == null || StringUtils.isEmpty((String)validateRequestHeaders)) {
            validateRequestHeaders = ValidatoreMessaggiApplicativiRest.readValue(proprieta, "validation.openApi.validateRequestHeaders");
        }
        if (validateRequestHeaders != null && !StringUtils.isEmpty((String)validateRequestHeaders)) {
            if (enabled.equals(validateRequestHeaders.trim())) {
                configOpenApi4j.setValidateRequestHeaders(true);
            } else if (disabled.equals(validateRequestHeaders.trim())) {
                configOpenApi4j.setValidateRequestHeaders(false);
            }
        }
        if ((validateRequestCookie = ValidatoreMessaggiApplicativiRest.readValue(proprieta, openapi4j ? "validation.openApi4j.validateRequestCookies" : "validation.swaggerRequestValidator.validateRequestCookies")) == null || StringUtils.isEmpty((String)validateRequestCookie)) {
            validateRequestCookie = ValidatoreMessaggiApplicativiRest.readValue(proprieta, "validation.openApi.validateRequestCookies");
        }
        if (validateRequestCookie != null && !StringUtils.isEmpty((String)validateRequestCookie)) {
            if (enabled.equals(validateRequestCookie.trim())) {
                configOpenApi4j.setValidateRequestCookie(true);
            } else if (disabled.equals(validateRequestCookie.trim())) {
                configOpenApi4j.setValidateRequestCookie(false);
            }
        }
        if ((validateRequestBody = ValidatoreMessaggiApplicativiRest.readValue(proprieta, openapi4j ? "validation.openApi4j.validateRequestBody" : "validation.swaggerRequestValidator.validateRequestBody")) == null || StringUtils.isEmpty((String)validateRequestBody)) {
            validateRequestBody = ValidatoreMessaggiApplicativiRest.readValue(proprieta, "validation.openApi.validateRequestBody");
        }
        if (validateRequestBody != null && !StringUtils.isEmpty((String)validateRequestBody)) {
            if (enabled.equals(validateRequestBody.trim())) {
                configOpenApi4j.setValidateRequestBody(true);
            } else if (disabled.equals(validateRequestBody.trim())) {
                configOpenApi4j.setValidateRequestBody(false);
            }
        }
        if ((validateResponseHeaders = ValidatoreMessaggiApplicativiRest.readValue(proprieta, openapi4j ? "validation.openApi4j.validateResponseHeaders" : "validation.swaggerRequestValidator.validateResponseHeaders")) == null || StringUtils.isEmpty((String)validateResponseHeaders)) {
            validateResponseHeaders = ValidatoreMessaggiApplicativiRest.readValue(proprieta, "validation.openApi.validateResponseHeaders");
        }
        if (validateResponseHeaders != null && !StringUtils.isEmpty((String)validateResponseHeaders)) {
            if (enabled.equals(validateResponseHeaders.trim())) {
                configOpenApi4j.setValidateResponseHeaders(true);
            } else if (disabled.equals(validateResponseHeaders.trim())) {
                configOpenApi4j.setValidateResponseHeaders(false);
            }
        }
        if ((validateResponseBody = ValidatoreMessaggiApplicativiRest.readValue(proprieta, openapi4j ? "validation.openApi4j.validateResponseBody" : "validation.swaggerRequestValidator.validateResponseBody")) == null || StringUtils.isEmpty((String)validateResponseBody)) {
            validateResponseBody = ValidatoreMessaggiApplicativiRest.readValue(proprieta, "validation.openApi.validateResponseBody");
        }
        if (validateResponseBody != null && !StringUtils.isEmpty((String)validateResponseBody)) {
            if (enabled.equals(validateResponseBody.trim())) {
                configOpenApi4j.setValidateResponseBody(true);
            } else if (disabled.equals(validateResponseBody.trim())) {
                configOpenApi4j.setValidateResponseBody(false);
            }
        }
        if ((validateWildcardSubtypeAsJson = ValidatoreMessaggiApplicativiRest.readValue(proprieta, openapi4j ? "validation.openApi4j.validateWildcardSubtypeAsJson" : "validation.swaggerRequestValidator.validateWildcardSubtypeAsJson")) == null || StringUtils.isEmpty((String)validateWildcardSubtypeAsJson)) {
            validateWildcardSubtypeAsJson = ValidatoreMessaggiApplicativiRest.readValue(proprieta, "validation.openApi.validateWildcardSubtypeAsJson");
        }
        if (validateWildcardSubtypeAsJson != null && !StringUtils.isEmpty((String)validateWildcardSubtypeAsJson)) {
            if (enabled.equals(validateWildcardSubtypeAsJson.trim())) {
                configOpenApi4j.setValidateWildcardSubtypeAsJson(true);
            } else if (disabled.equals(validateWildcardSubtypeAsJson.trim())) {
                configOpenApi4j.setValidateWildcardSubtypeAsJson(false);
            }
        }
        if (openapi4j) {
            String validateMultipartOptimization = ValidatoreMessaggiApplicativiRest.readValue(proprieta, "validation.openApi4j.validateMultipartOptimization");
            if (validateMultipartOptimization == null || StringUtils.isEmpty((String)validateMultipartOptimization)) {
                validateMultipartOptimization = ValidatoreMessaggiApplicativiRest.readValue(proprieta, "validation.openApi.validateMultipartOptimization");
            }
            if (validateMultipartOptimization != null && !StringUtils.isEmpty((String)validateMultipartOptimization)) {
                if (enabled.equals(validateMultipartOptimization.trim())) {
                    configOpenApi4j.setValidateMultipartOptimization(true);
                } else if (disabled.equals(validateMultipartOptimization.trim())) {
                    configOpenApi4j.setValidateMultipartOptimization(false);
                }
            }
        }
        if (!openapi4j) {
            String resolveFullyApiSpec;
            String injectingAdditionalPropertiesFalse = ValidatoreMessaggiApplicativiRest.readValue(proprieta, "validation.swaggerRequestValidator.injectingAdditionalPropertiesFalse");
            if (injectingAdditionalPropertiesFalse != null && !StringUtils.isEmpty((String)injectingAdditionalPropertiesFalse)) {
                if (enabled.equals(injectingAdditionalPropertiesFalse.trim())) {
                    configOpenApi4j.setSwaggerRequestValidator_InjectingAdditionalPropertiesFalse(true);
                } else if (disabled.equals(injectingAdditionalPropertiesFalse.trim())) {
                    configOpenApi4j.setSwaggerRequestValidator_InjectingAdditionalPropertiesFalse(false);
                }
            }
            if ((resolveFullyApiSpec = ValidatoreMessaggiApplicativiRest.readValue(proprieta, "validation.swaggerRequestValidator.resolveFullyApiSpec")) != null && !StringUtils.isEmpty((String)resolveFullyApiSpec)) {
                if (enabled.equals(resolveFullyApiSpec.trim())) {
                    configOpenApi4j.setSwaggerRequestValidator_ResolveFullyApiSpec(true);
                } else if (disabled.equals(resolveFullyApiSpec.trim())) {
                    configOpenApi4j.setSwaggerRequestValidator_ResolveFullyApiSpec(false);
                }
            }
        }
    }

    protected static String readValue(List<Proprieta> proprieta, String nome) {
        if (proprieta == null || proprieta.isEmpty()) {
            return null;
        }
        for (Proprieta proprietaCheck : proprieta) {
            if (!nome.equalsIgnoreCase(proprietaCheck.getNome())) continue;
            return proprietaCheck.getValore();
        }
        return null;
    }

    public static boolean readBooleanValueWithDefault(List<Proprieta> proprieta, String nome, boolean defaultValue) {
        String valueS = ValidatoreMessaggiApplicativiRest.readValue(proprieta, nome);
        if (valueS != null && !StringUtils.isEmpty((String)valueS)) {
            if ("true".equals(valueS.trim())) {
                return true;
            }
            if ("false".equals(valueS.trim())) {
                return false;
            }
        }
        return defaultValue;
    }

    public static boolean isValidazioneAbilitata(Logger log, List<Proprieta> proprieta, OpenSPCoop2Message responseMessage, int codiceRitornato) throws UtilsException, MessageException, MessageNotSupportedException {
        String[] tmp;
        boolean not;
        boolean defaultNot;
        boolean isFaultGovway;
        boolean hasContent;
        OpenSPCoop2RestMessage restMsg = responseMessage.castAsRest();
        boolean defaultValidateEmptyResponse = true;
        boolean validateEmptyResponse = ValidatoreMessaggiApplicativiRest.readBooleanValueWithDefault(proprieta, "validation.emptyResponse.enabled", defaultValidateEmptyResponse);
        if (!validateEmptyResponse && !(hasContent = restMsg.hasContent())) {
            return false;
        }
        boolean defaultValidateGovwayFault = false;
        boolean validateGovwayFault = ValidatoreMessaggiApplicativiRest.readBooleanValueWithDefault(proprieta, "validation.faultGovway.enabled", defaultValidateGovwayFault);
        if (!validateGovwayFault && (isFaultGovway = MessageRole.FAULT.equals((Object)responseMessage.getMessageRole()))) {
            return false;
        }
        boolean defaultValidateProblemDetail = true;
        boolean validateProblemDetail = ValidatoreMessaggiApplicativiRest.readBooleanValueWithDefault(proprieta, "validation.problemDetails.enabled", defaultValidateProblemDetail);
        if (!validateProblemDetail && restMsg.isProblemDetailsForHttpApis_RFC7807()) {
            return false;
        }
        String valueS = ValidatoreMessaggiApplicativiRest.readValue(proprieta, "validation.returnCode");
        if (valueS != null && !StringUtils.isEmpty((String)valueS)) {
            defaultNot = false;
            not = ValidatoreMessaggiApplicativiRest.readBooleanValueWithDefault(proprieta, "validation.returnCode.not", defaultNot);
            ArrayList<String> codici = new ArrayList<String>();
            if (valueS.contains(",")) {
                tmp = valueS.split(",");
                if (tmp != null && tmp.length > 0) {
                    for (String string : tmp) {
                        codici.add(string.trim());
                    }
                }
            } else {
                codici.add(valueS.trim());
            }
            if (codici != null && !codici.isEmpty()) {
                boolean match = false;
                for (String codice : codici) {
                    if (codice.contains("-")) {
                        String[] tmp2 = codice.split("-");
                        if (tmp2 == null || tmp2.length != 2) {
                            throw new UtilsException("Codice '" + codice + "' indicato nella propriet\u00e0 ',' possiede un formato errato; atteso: codiceMin-codiceMax");
                        }
                        String string = tmp2[0];
                        String codiceMax = tmp2[1];
                        if (string == null || StringUtils.isEmpty((String)string.trim())) {
                            throw new UtilsException("Codice '" + codice + "' indicato nella propriet\u00e0 ',' possiede un formato errato (intervallo minimo non definito); atteso: codiceMin-codiceMax");
                        }
                        if (codiceMax == null || StringUtils.isEmpty((String)codiceMax.trim())) {
                            throw new UtilsException("Codice '" + codice + "' indicato nella propriet\u00e0 ',' possiede un formato errato (intervallo massimo non definito); atteso: codiceMin-codiceMax");
                        }
                        String string2 = string.trim();
                        codiceMax = codiceMax.trim();
                        int codiceMinInt = -1;
                        try {
                            codiceMinInt = Integer.valueOf(string2);
                        }
                        catch (Exception e) {
                            throw new UtilsException("Codice '" + codice + "' indicato nella propriet\u00e0 ',' contiene un intervallo minimo '" + string2 + "' che non \u00e8 un numero intero");
                        }
                        int codiceMaxInt = -1;
                        try {
                            codiceMaxInt = Integer.valueOf(codiceMax);
                        }
                        catch (Exception e) {
                            throw new UtilsException("Codice '" + codice + "' indicato nella propriet\u00e0 ',' contiene un intervallo massimo '" + codiceMax + "' che non \u00e8 un numero intero");
                        }
                        if (codiceMaxInt <= codiceMinInt) {
                            throw new UtilsException("Codice '" + codice + "' indicato nella propriet\u00e0 ',' contiene un intervallo massimo '" + codiceMax + "' minore o uguale all'intervallo minimo '" + string2 + "'");
                        }
                        if (codiceMinInt > codiceRitornato || codiceRitornato > codiceMaxInt) continue;
                        match = true;
                        break;
                    }
                    try {
                        int codiceInt = Integer.parseInt(codice);
                        if (codiceInt != codiceRitornato) continue;
                        match = true;
                        break;
                    }
                    catch (Exception e) {
                        throw new UtilsException("Codice '" + codice + "' indicato nella propriet\u00e0 ',' non \u00e8 un numero intero");
                    }
                }
                if (match) {
                    return !not;
                }
                return not;
            }
        }
        if ((valueS = ValidatoreMessaggiApplicativiRest.readValue(proprieta, "validation.contentType")) != null && !StringUtils.isEmpty((String)valueS)) {
            defaultNot = false;
            not = ValidatoreMessaggiApplicativiRest.readBooleanValueWithDefault(proprieta, "validation.contentType.not", defaultNot);
            ArrayList<String> contentTypes = new ArrayList<String>();
            if (valueS.contains(",")) {
                tmp = valueS.split(",");
                if (tmp != null && tmp.length > 0) {
                    for (String string : tmp) {
                        contentTypes.add(string.trim());
                    }
                }
            } else {
                contentTypes.add(valueS.trim());
            }
            if (contentTypes != null && !contentTypes.isEmpty()) {
                String contentTypeRisposta = responseMessage.getContentType();
                if (ContentTypeUtilities.isMatch((Logger)log, (String)contentTypeRisposta, contentTypes)) {
                    return !not;
                }
                return not;
            }
        }
        return true;
    }
}

